/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ResearchSubject", profile="http://hl7.org/fhir/StructureDefinition/ResearchSubject")
public class ResearchSubject
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for research subject in a study", formalDefinition="Identifiers assigned to this research subject for a study.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The publication state of the resource (not of the subject).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="progress", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Subject status", formalDefinition="The current state (status) of the subject and resons for status change where appropriate.")
    protected List<ResearchSubjectProgressComponent> progress;
    @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end of participation", formalDefinition="The dates the subject began and ended their participation in the study.")
    protected Period period;
    @Child(name="study", type={ResearchStudy.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Study subject is part of", formalDefinition="Reference to the study the subject is participating in.")
    protected Reference study;
    @Child(name="subject", type={Patient.class, Group.class, Specimen.class, Device.class, Medication.class, Substance.class, BiologicallyDerivedProduct.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who or what is part of study", formalDefinition="The record of the person, animal or other entity involved in the study.")
    protected Reference subject;
    @Child(name="assignedComparisonGroup", type={IdType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What path should be followed", formalDefinition="The name of the arm in the study the subject is expected to follow as part of this study.")
    protected IdType assignedComparisonGroup;
    @Child(name="actualComparisonGroup", type={IdType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What path was followed", formalDefinition="The name of the arm in the study the subject actually followed as part of this study.")
    protected IdType actualComparisonGroup;
    @Child(name="consent", type={Consent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Agreement to participate in study", formalDefinition="A record of the patient's informed agreement to participate in the study.")
    protected List<Reference> consent;
    private static final long serialVersionUID = -1058527147L;
    @SearchParamDefinition(name="status", path="ResearchSubject.status", description="draft | active | retired | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="study", path="ResearchSubject.study", description="Study subject is part of", type="reference", target={ResearchStudy.class})
    public static final String SP_STUDY = "study";
    public static final ReferenceClientParam STUDY = new ReferenceClientParam("study");
    public static final Include INCLUDE_STUDY = new Include("ResearchSubject:study").toLocked();
    @SearchParamDefinition(name="subject", path="ResearchSubject.subject", description="Who or what is part of study", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Medication.class, Patient.class, Specimen.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ResearchSubject:subject").toLocked();
    @SearchParamDefinition(name="subject_state", path="ResearchSubject.progress.subjectState", description="candidate | eligible | follow-up | ineligible | not-registered | off-study | on-study | on-study-intervention | on-study-observation | pending-on-study | potential-candidate | screening | withdrawn", type="token")
    public static final String SP_SUBJECTSTATE = "subject_state";
    public static final TokenClientParam SUBJECTSTATE = new TokenClientParam("subject_state");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ResearchSubject:patient").toLocked();

    public ResearchSubject() {
    }

    public ResearchSubject(Enumerations.PublicationStatus status, Reference study, Reference subject) {
        this.setStatus(status);
        this.setStudy(study);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ResearchSubject setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ResearchSubject addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ResearchSubject setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public ResearchSubject setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<ResearchSubjectProgressComponent> getProgress() {
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        return this.progress;
    }

    public ResearchSubject setProgress(List<ResearchSubjectProgressComponent> theProgress) {
        this.progress = theProgress;
        return this;
    }

    public boolean hasProgress() {
        if (this.progress == null) {
            return false;
        }
        for (ResearchSubjectProgressComponent item : this.progress) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ResearchSubjectProgressComponent addProgress() {
        ResearchSubjectProgressComponent t = new ResearchSubjectProgressComponent();
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        this.progress.add(t);
        return t;
    }

    public ResearchSubject addProgress(ResearchSubjectProgressComponent t) {
        if (t == null) {
            return this;
        }
        if (this.progress == null) {
            this.progress = new ArrayList<ResearchSubjectProgressComponent>();
        }
        this.progress.add(t);
        return this;
    }

    public ResearchSubjectProgressComponent getProgressFirstRep() {
        if (this.getProgress().isEmpty()) {
            this.addProgress();
        }
        return this.getProgress().get(0);
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ResearchSubject setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getStudy() {
        if (this.study == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.study");
            }
            if (Configuration.doAutoCreate()) {
                this.study = new Reference();
            }
        }
        return this.study;
    }

    public boolean hasStudy() {
        return this.study != null && !this.study.isEmpty();
    }

    public ResearchSubject setStudy(Reference value) {
        this.study = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ResearchSubject setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public IdType getAssignedComparisonGroupElement() {
        if (this.assignedComparisonGroup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.assignedComparisonGroup");
            }
            if (Configuration.doAutoCreate()) {
                this.assignedComparisonGroup = new IdType();
            }
        }
        return this.assignedComparisonGroup;
    }

    public boolean hasAssignedComparisonGroupElement() {
        return this.assignedComparisonGroup != null && !this.assignedComparisonGroup.isEmpty();
    }

    public boolean hasAssignedComparisonGroup() {
        return this.assignedComparisonGroup != null && !this.assignedComparisonGroup.isEmpty();
    }

    public ResearchSubject setAssignedComparisonGroupElement(IdType value) {
        this.assignedComparisonGroup = value;
        return this;
    }

    public String getAssignedComparisonGroup() {
        return this.assignedComparisonGroup == null ? null : this.assignedComparisonGroup.getValue();
    }

    public ResearchSubject setAssignedComparisonGroup(String value) {
        if (Utilities.noString((String)value)) {
            this.assignedComparisonGroup = null;
        } else {
            if (this.assignedComparisonGroup == null) {
                this.assignedComparisonGroup = new IdType();
            }
            this.assignedComparisonGroup.setValue(value);
        }
        return this;
    }

    public IdType getActualComparisonGroupElement() {
        if (this.actualComparisonGroup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ResearchSubject.actualComparisonGroup");
            }
            if (Configuration.doAutoCreate()) {
                this.actualComparisonGroup = new IdType();
            }
        }
        return this.actualComparisonGroup;
    }

    public boolean hasActualComparisonGroupElement() {
        return this.actualComparisonGroup != null && !this.actualComparisonGroup.isEmpty();
    }

    public boolean hasActualComparisonGroup() {
        return this.actualComparisonGroup != null && !this.actualComparisonGroup.isEmpty();
    }

    public ResearchSubject setActualComparisonGroupElement(IdType value) {
        this.actualComparisonGroup = value;
        return this;
    }

    public String getActualComparisonGroup() {
        return this.actualComparisonGroup == null ? null : this.actualComparisonGroup.getValue();
    }

    public ResearchSubject setActualComparisonGroup(String value) {
        if (Utilities.noString((String)value)) {
            this.actualComparisonGroup = null;
        } else {
            if (this.actualComparisonGroup == null) {
                this.actualComparisonGroup = new IdType();
            }
            this.actualComparisonGroup.setValue(value);
        }
        return this;
    }

    public List<Reference> getConsent() {
        if (this.consent == null) {
            this.consent = new ArrayList<Reference>();
        }
        return this.consent;
    }

    public ResearchSubject setConsent(List<Reference> theConsent) {
        this.consent = theConsent;
        return this;
    }

    public boolean hasConsent() {
        if (this.consent == null) {
            return false;
        }
        for (Reference item : this.consent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addConsent() {
        Reference t = new Reference();
        if (this.consent == null) {
            this.consent = new ArrayList<Reference>();
        }
        this.consent.add(t);
        return t;
    }

    public ResearchSubject addConsent(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.consent == null) {
            this.consent = new ArrayList<Reference>();
        }
        this.consent.add(t);
        return this;
    }

    public Reference getConsentFirstRep() {
        if (this.getConsent().isEmpty()) {
            this.addConsent();
        }
        return this.getConsent().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research subject for a study.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The publication state of the resource (not of the subject).", 0, 1, this.status));
        children.add(new Property("progress", "", "The current state (status) of the subject and resons for status change where appropriate.", 0, Integer.MAX_VALUE, this.progress));
        children.add(new Property("period", "Period", "The dates the subject began and ended their participation in the study.", 0, 1, this.period));
        children.add(new Property(SP_STUDY, "Reference(ResearchStudy)", "Reference to the study the subject is participating in.", 0, 1, this.study));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Specimen|Device|Medication|Substance|BiologicallyDerivedProduct)", "The record of the person, animal or other entity involved in the study.", 0, 1, this.subject));
        children.add(new Property("assignedComparisonGroup", "id", "The name of the arm in the study the subject is expected to follow as part of this study.", 0, 1, this.assignedComparisonGroup));
        children.add(new Property("actualComparisonGroup", "id", "The name of the arm in the study the subject actually followed as part of this study.", 0, 1, this.actualComparisonGroup));
        children.add(new Property("consent", "Reference(Consent)", "A record of the patient's informed agreement to participate in the study.", 0, Integer.MAX_VALUE, this.consent));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this research subject for a study.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The publication state of the resource (not of the subject).", 0, 1, this.status);
            }
            case -1001078227: {
                return new Property("progress", "", "The current state (status) of the subject and resons for status change where appropriate.", 0, Integer.MAX_VALUE, this.progress);
            }
            case -991726143: {
                return new Property("period", "Period", "The dates the subject began and ended their participation in the study.", 0, 1, this.period);
            }
            case 109776329: {
                return new Property(SP_STUDY, "Reference(ResearchStudy)", "Reference to the study the subject is participating in.", 0, 1, this.study);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Specimen|Device|Medication|Substance|BiologicallyDerivedProduct)", "The record of the person, animal or other entity involved in the study.", 0, 1, this.subject);
            }
            case 394644552: {
                return new Property("assignedComparisonGroup", "id", "The name of the arm in the study the subject is expected to follow as part of this study.", 0, 1, this.assignedComparisonGroup);
            }
            case -676906872: {
                return new Property("actualComparisonGroup", "id", "The name of the arm in the study the subject actually followed as part of this study.", 0, 1, this.actualComparisonGroup);
            }
            case 951500826: {
                return new Property("consent", "Reference(Consent)", "A record of the patient's informed agreement to participate in the study.", 0, Integer.MAX_VALUE, this.consent);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1001078227: {
                return this.progress == null ? new Base[]{} : this.progress.toArray(new Base[this.progress.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case 109776329: {
                Base[] baseArray;
                if (this.study == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.study;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 394644552: {
                Base[] baseArray;
                if (this.assignedComparisonGroup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.assignedComparisonGroup;
                }
                return baseArray;
            }
            case -676906872: {
                Base[] baseArray;
                if (this.actualComparisonGroup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.actualComparisonGroup;
                }
                return baseArray;
            }
            case 951500826: {
                return this.consent == null ? new Base[]{} : this.consent.toArray(new Base[this.consent.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1001078227: {
                this.getProgress().add((ResearchSubjectProgressComponent)((Object)value));
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 109776329: {
                this.study = TypeConvertor.castToReference(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 394644552: {
                this.assignedComparisonGroup = TypeConvertor.castToId(value);
                return value;
            }
            case -676906872: {
                this.actualComparisonGroup = TypeConvertor.castToId(value);
                return value;
            }
            case 951500826: {
                this.getConsent().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("progress")) {
            this.getProgress().add((ResearchSubjectProgressComponent)((Object)value));
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_STUDY)) {
            this.study = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("assignedComparisonGroup")) {
            this.assignedComparisonGroup = TypeConvertor.castToId(value);
        } else if (name.equals("actualComparisonGroup")) {
            this.actualComparisonGroup = TypeConvertor.castToId(value);
        } else if (name.equals("consent")) {
            this.getConsent().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1001078227: {
                return this.addProgress();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 109776329: {
                return this.getStudy();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 394644552: {
                return this.getAssignedComparisonGroupElement();
            }
            case -676906872: {
                return this.getActualComparisonGroupElement();
            }
            case 951500826: {
                return this.addConsent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1001078227: {
                return new String[0];
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 109776329: {
                return new String[]{"Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 394644552: {
                return new String[]{"id"};
            }
            case -676906872: {
                return new String[]{"id"};
            }
            case 951500826: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchSubject.status");
        }
        if (name.equals("progress")) {
            return this.addProgress();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_STUDY)) {
            this.study = new Reference();
            return this.study;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("assignedComparisonGroup")) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchSubject.assignedComparisonGroup");
        }
        if (name.equals("actualComparisonGroup")) {
            throw new FHIRException("Cannot call addChild on a singleton property ResearchSubject.actualComparisonGroup");
        }
        if (name.equals("consent")) {
            return this.addConsent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ResearchSubject";
    }

    @Override
    public ResearchSubject copy() {
        ResearchSubject dst = new ResearchSubject();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ResearchSubject dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<Enumerations.PublicationStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.progress != null) {
            dst.progress = new ArrayList<ResearchSubjectProgressComponent>();
            for (ResearchSubjectProgressComponent researchSubjectProgressComponent : this.progress) {
                dst.progress.add(researchSubjectProgressComponent.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        dst.study = this.study == null ? null : this.study.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.assignedComparisonGroup = this.assignedComparisonGroup == null ? null : this.assignedComparisonGroup.copy();
        IdType idType = dst.actualComparisonGroup = this.actualComparisonGroup == null ? null : this.actualComparisonGroup.copy();
        if (this.consent != null) {
            dst.consent = new ArrayList<Reference>();
            for (Reference reference : this.consent) {
                dst.consent.add(reference.copy());
            }
        }
    }

    protected ResearchSubject typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchSubject)) {
            return false;
        }
        ResearchSubject o = (ResearchSubject)other_;
        return ResearchSubject.compareDeep(this.identifier, o.identifier, true) && ResearchSubject.compareDeep(this.status, o.status, true) && ResearchSubject.compareDeep(this.progress, o.progress, true) && ResearchSubject.compareDeep(this.period, o.period, true) && ResearchSubject.compareDeep(this.study, o.study, true) && ResearchSubject.compareDeep(this.subject, o.subject, true) && ResearchSubject.compareDeep(this.assignedComparisonGroup, o.assignedComparisonGroup, true) && ResearchSubject.compareDeep(this.actualComparisonGroup, o.actualComparisonGroup, true) && ResearchSubject.compareDeep(this.consent, o.consent, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ResearchSubject)) {
            return false;
        }
        ResearchSubject o = (ResearchSubject)other_;
        return ResearchSubject.compareValues(this.status, o.status, true) && ResearchSubject.compareValues(this.assignedComparisonGroup, o.assignedComparisonGroup, true) && ResearchSubject.compareValues(this.actualComparisonGroup, o.actualComparisonGroup, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.progress, this.period, this.study, this.subject, this.assignedComparisonGroup, this.actualComparisonGroup, this.consent});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ResearchSubject;
    }

    @Block
    public static class ResearchSubjectProgressComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="state | milestone", formalDefinition="Identifies the aspect of the subject's journey that the state refers to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-state-type")
        protected CodeableConcept type;
        @Child(name="subjectState", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="candidate | eligible | follow-up | ineligible | not-registered | off-study | on-study | on-study-intervention | on-study-observation | pending-on-study | potential-candidate | screening | withdrawn", formalDefinition="The current state of the subject.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-state")
        protected CodeableConcept subjectState;
        @Child(name="milestone", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="SignedUp | Screened | Randomized", formalDefinition="The milestones the subject has passed through.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/research-subject-milestone")
        protected CodeableConcept milestone;
        @Child(name="reason", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State change reason", formalDefinition="The reason for the state change.  If coded it should follow the formal subject state model.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/state-change-reason")
        protected CodeableConcept reason;
        @Child(name="startDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State change date", formalDefinition="The date when the new status started.")
        protected DateTimeType startDate;
        @Child(name="endDate", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="State change date", formalDefinition="The date when the state ended.")
        protected DateTimeType endDate;
        private static final long serialVersionUID = -330838916L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ResearchSubjectProgressComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getSubjectState() {
            if (this.subjectState == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.subjectState");
                }
                if (Configuration.doAutoCreate()) {
                    this.subjectState = new CodeableConcept();
                }
            }
            return this.subjectState;
        }

        public boolean hasSubjectState() {
            return this.subjectState != null && !this.subjectState.isEmpty();
        }

        public ResearchSubjectProgressComponent setSubjectState(CodeableConcept value) {
            this.subjectState = value;
            return this;
        }

        public CodeableConcept getMilestone() {
            if (this.milestone == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.milestone");
                }
                if (Configuration.doAutoCreate()) {
                    this.milestone = new CodeableConcept();
                }
            }
            return this.milestone;
        }

        public boolean hasMilestone() {
            return this.milestone != null && !this.milestone.isEmpty();
        }

        public ResearchSubjectProgressComponent setMilestone(CodeableConcept value) {
            this.milestone = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public ResearchSubjectProgressComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        public DateTimeType getStartDateElement() {
            if (this.startDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.startDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.startDate = new DateTimeType();
                }
            }
            return this.startDate;
        }

        public boolean hasStartDateElement() {
            return this.startDate != null && !this.startDate.isEmpty();
        }

        public boolean hasStartDate() {
            return this.startDate != null && !this.startDate.isEmpty();
        }

        public ResearchSubjectProgressComponent setStartDateElement(DateTimeType value) {
            this.startDate = value;
            return this;
        }

        public Date getStartDate() {
            return this.startDate == null ? null : (Date)this.startDate.getValue();
        }

        public ResearchSubjectProgressComponent setStartDate(Date value) {
            if (value == null) {
                this.startDate = null;
            } else {
                if (this.startDate == null) {
                    this.startDate = new DateTimeType();
                }
                this.startDate.setValue(value);
            }
            return this;
        }

        public DateTimeType getEndDateElement() {
            if (this.endDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResearchSubjectProgressComponent.endDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.endDate = new DateTimeType();
                }
            }
            return this.endDate;
        }

        public boolean hasEndDateElement() {
            return this.endDate != null && !this.endDate.isEmpty();
        }

        public boolean hasEndDate() {
            return this.endDate != null && !this.endDate.isEmpty();
        }

        public ResearchSubjectProgressComponent setEndDateElement(DateTimeType value) {
            this.endDate = value;
            return this;
        }

        public Date getEndDate() {
            return this.endDate == null ? null : (Date)this.endDate.getValue();
        }

        public ResearchSubjectProgressComponent setEndDate(Date value) {
            if (value == null) {
                this.endDate = null;
            } else {
                if (this.endDate == null) {
                    this.endDate = new DateTimeType();
                }
                this.endDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Identifies the aspect of the subject's journey that the state refers to.", 0, 1, this.type));
            children.add(new Property("subjectState", "CodeableConcept", "The current state of the subject.", 0, 1, this.subjectState));
            children.add(new Property("milestone", "CodeableConcept", "The milestones the subject has passed through.", 0, 1, this.milestone));
            children.add(new Property("reason", "CodeableConcept", "The reason for the state change.  If coded it should follow the formal subject state model.", 0, 1, this.reason));
            children.add(new Property("startDate", "dateTime", "The date when the new status started.", 0, 1, this.startDate));
            children.add(new Property("endDate", "dateTime", "The date when the state ended.", 0, 1, this.endDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Identifies the aspect of the subject's journey that the state refers to.", 0, 1, this.type);
                }
                case -1520444731: {
                    return new Property("subjectState", "CodeableConcept", "The current state of the subject.", 0, 1, this.subjectState);
                }
                case -1065084560: {
                    return new Property("milestone", "CodeableConcept", "The milestones the subject has passed through.", 0, 1, this.milestone);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "The reason for the state change.  If coded it should follow the formal subject state model.", 0, 1, this.reason);
                }
                case -2129778896: {
                    return new Property("startDate", "dateTime", "The date when the new status started.", 0, 1, this.startDate);
                }
                case -1607727319: {
                    return new Property("endDate", "dateTime", "The date when the state ended.", 0, 1, this.endDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1520444731: {
                    Base[] baseArray;
                    if (this.subjectState == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.subjectState;
                    }
                    return baseArray;
                }
                case -1065084560: {
                    Base[] baseArray;
                    if (this.milestone == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.milestone;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.reason;
                    }
                    return baseArray;
                }
                case -2129778896: {
                    Base[] baseArray;
                    if (this.startDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.startDate;
                    }
                    return baseArray;
                }
                case -1607727319: {
                    Base[] baseArray;
                    if (this.endDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.endDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1520444731: {
                    this.subjectState = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1065084560: {
                    this.milestone = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.reason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2129778896: {
                    this.startDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case -1607727319: {
                    this.endDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("subjectState")) {
                this.subjectState = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("milestone")) {
                this.milestone = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("startDate")) {
                this.startDate = TypeConvertor.castToDateTime(value);
            } else if (name.equals("endDate")) {
                this.endDate = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1520444731: {
                    return this.getSubjectState();
                }
                case -1065084560: {
                    return this.getMilestone();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -2129778896: {
                    return this.getStartDateElement();
                }
                case -1607727319: {
                    return this.getEndDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1520444731: {
                    return new String[]{"CodeableConcept"};
                }
                case -1065084560: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case -2129778896: {
                    return new String[]{"dateTime"};
                }
                case -1607727319: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("subjectState")) {
                this.subjectState = new CodeableConcept();
                return this.subjectState;
            }
            if (name.equals("milestone")) {
                this.milestone = new CodeableConcept();
                return this.milestone;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            if (name.equals("startDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property ResearchSubject.progress.startDate");
            }
            if (name.equals("endDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property ResearchSubject.progress.endDate");
            }
            return super.addChild(name);
        }

        @Override
        public ResearchSubjectProgressComponent copy() {
            ResearchSubjectProgressComponent dst = new ResearchSubjectProgressComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResearchSubjectProgressComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.subjectState = this.subjectState == null ? null : this.subjectState.copy();
            dst.milestone = this.milestone == null ? null : this.milestone.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.startDate = this.startDate == null ? null : this.startDate.copy();
            dst.endDate = this.endDate == null ? null : this.endDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchSubjectProgressComponent)) {
                return false;
            }
            ResearchSubjectProgressComponent o = (ResearchSubjectProgressComponent)other_;
            return ResearchSubjectProgressComponent.compareDeep(this.type, o.type, true) && ResearchSubjectProgressComponent.compareDeep(this.subjectState, o.subjectState, true) && ResearchSubjectProgressComponent.compareDeep(this.milestone, o.milestone, true) && ResearchSubjectProgressComponent.compareDeep(this.reason, o.reason, true) && ResearchSubjectProgressComponent.compareDeep(this.startDate, o.startDate, true) && ResearchSubjectProgressComponent.compareDeep(this.endDate, o.endDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResearchSubjectProgressComponent)) {
                return false;
            }
            ResearchSubjectProgressComponent o = (ResearchSubjectProgressComponent)other_;
            return ResearchSubjectProgressComponent.compareValues(this.startDate, o.startDate, true) && ResearchSubjectProgressComponent.compareValues(this.endDate, o.endDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.subjectState, this.milestone, this.reason, this.startDate, this.endDate});
        }

        @Override
        public String fhirType() {
            return "ResearchSubject.progress";
        }
    }
}

