/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="VirtualServiceDetail")
public class VirtualServiceDetail
extends DataType
implements ICompositeType {
    @Child(name="channelType", type={Coding.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Channel Type", formalDefinition="The type of virtual service to connect to (i.e. Teams, Zoom, Specific VMR technology, WhatsApp).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/virtual-service-type")
    protected Coding channelType;
    @Child(name="address", type={UrlType.class, StringType.class, ContactPoint.class, ExtendedContactDetail.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Contact address/number", formalDefinition="What address or number needs to be used for a user to connect to the virtual service to join. The channelType informs as to which datatype is appropriate to use (requires knowledge of the specific type).")
    protected DataType address;
    @Child(name="additionalInfo", type={UrlType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Address to see alternative connection details", formalDefinition="Address to see alternative connection details.")
    protected List<UrlType> additionalInfo;
    @Child(name="maxParticipants", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Maximum number of participants supported by the virtual service", formalDefinition="Maximum number of participants supported by the virtual service.")
    protected PositiveIntType maxParticipants;
    @Child(name="sessionKey", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Session Key required by the virtual service", formalDefinition="Session Key required by the virtual service.")
    protected StringType sessionKey;
    private static final long serialVersionUID = -514931977L;

    public Coding getChannelType() {
        if (this.channelType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VirtualServiceDetail.channelType");
            }
            if (Configuration.doAutoCreate()) {
                this.channelType = new Coding();
            }
        }
        return this.channelType;
    }

    public boolean hasChannelType() {
        return this.channelType != null && !this.channelType.isEmpty();
    }

    public VirtualServiceDetail setChannelType(Coding value) {
        this.channelType = value;
        return this;
    }

    public DataType getAddress() {
        return this.address;
    }

    public UrlType getAddressUrlType() throws FHIRException {
        if (this.address == null) {
            this.address = new UrlType();
        }
        if (!(this.address instanceof UrlType)) {
            throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.address.getClass().getName() + " was encountered");
        }
        return (UrlType)this.address;
    }

    public boolean hasAddressUrlType() {
        return this != null && this.address instanceof UrlType;
    }

    public StringType getAddressStringType() throws FHIRException {
        if (this.address == null) {
            this.address = new StringType();
        }
        if (!(this.address instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.address.getClass().getName() + " was encountered");
        }
        return (StringType)this.address;
    }

    public boolean hasAddressStringType() {
        return this != null && this.address instanceof StringType;
    }

    public ContactPoint getAddressContactPoint() throws FHIRException {
        if (this.address == null) {
            this.address = new ContactPoint();
        }
        if (!(this.address instanceof ContactPoint)) {
            throw new FHIRException("Type mismatch: the type ContactPoint was expected, but " + this.address.getClass().getName() + " was encountered");
        }
        return (ContactPoint)this.address;
    }

    public boolean hasAddressContactPoint() {
        return this != null && this.address instanceof ContactPoint;
    }

    public ExtendedContactDetail getAddressExtendedContactDetail() throws FHIRException {
        if (this.address == null) {
            this.address = new ExtendedContactDetail();
        }
        if (!(this.address instanceof ExtendedContactDetail)) {
            throw new FHIRException("Type mismatch: the type ExtendedContactDetail was expected, but " + this.address.getClass().getName() + " was encountered");
        }
        return (ExtendedContactDetail)this.address;
    }

    public boolean hasAddressExtendedContactDetail() {
        return this != null && this.address instanceof ExtendedContactDetail;
    }

    public boolean hasAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public VirtualServiceDetail setAddress(DataType value) {
        if (!(value == null || value instanceof UrlType || value instanceof StringType || value instanceof ContactPoint || value instanceof ExtendedContactDetail)) {
            throw new FHIRException("Not the right type for VirtualServiceDetail.address[x]: " + value.fhirType());
        }
        this.address = value;
        return this;
    }

    public List<UrlType> getAdditionalInfo() {
        if (this.additionalInfo == null) {
            this.additionalInfo = new ArrayList<UrlType>();
        }
        return this.additionalInfo;
    }

    public VirtualServiceDetail setAdditionalInfo(List<UrlType> theAdditionalInfo) {
        this.additionalInfo = theAdditionalInfo;
        return this;
    }

    public boolean hasAdditionalInfo() {
        if (this.additionalInfo == null) {
            return false;
        }
        for (UrlType item : this.additionalInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UrlType addAdditionalInfoElement() {
        UrlType t = new UrlType();
        if (this.additionalInfo == null) {
            this.additionalInfo = new ArrayList<UrlType>();
        }
        this.additionalInfo.add(t);
        return t;
    }

    public VirtualServiceDetail addAdditionalInfo(String value) {
        UrlType t = new UrlType();
        t.setValue(value);
        if (this.additionalInfo == null) {
            this.additionalInfo = new ArrayList<UrlType>();
        }
        this.additionalInfo.add(t);
        return this;
    }

    public boolean hasAdditionalInfo(String value) {
        if (this.additionalInfo == null) {
            return false;
        }
        for (UrlType v : this.additionalInfo) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public PositiveIntType getMaxParticipantsElement() {
        if (this.maxParticipants == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VirtualServiceDetail.maxParticipants");
            }
            if (Configuration.doAutoCreate()) {
                this.maxParticipants = new PositiveIntType();
            }
        }
        return this.maxParticipants;
    }

    public boolean hasMaxParticipantsElement() {
        return this.maxParticipants != null && !this.maxParticipants.isEmpty();
    }

    public boolean hasMaxParticipants() {
        return this.maxParticipants != null && !this.maxParticipants.isEmpty();
    }

    public VirtualServiceDetail setMaxParticipantsElement(PositiveIntType value) {
        this.maxParticipants = value;
        return this;
    }

    public int getMaxParticipants() {
        return this.maxParticipants == null || this.maxParticipants.isEmpty() ? 0 : (Integer)this.maxParticipants.getValue();
    }

    public VirtualServiceDetail setMaxParticipants(int value) {
        if (this.maxParticipants == null) {
            this.maxParticipants = new PositiveIntType();
        }
        this.maxParticipants.setValue((Object)value);
        return this;
    }

    public StringType getSessionKeyElement() {
        if (this.sessionKey == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VirtualServiceDetail.sessionKey");
            }
            if (Configuration.doAutoCreate()) {
                this.sessionKey = new StringType();
            }
        }
        return this.sessionKey;
    }

    public boolean hasSessionKeyElement() {
        return this.sessionKey != null && !this.sessionKey.isEmpty();
    }

    public boolean hasSessionKey() {
        return this.sessionKey != null && !this.sessionKey.isEmpty();
    }

    public VirtualServiceDetail setSessionKeyElement(StringType value) {
        this.sessionKey = value;
        return this;
    }

    public String getSessionKey() {
        return this.sessionKey == null ? null : (String)this.sessionKey.getValue();
    }

    public VirtualServiceDetail setSessionKey(String value) {
        if (Utilities.noString((String)value)) {
            this.sessionKey = null;
        } else {
            if (this.sessionKey == null) {
                this.sessionKey = new StringType();
            }
            this.sessionKey.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("channelType", "Coding", "The type of virtual service to connect to (i.e. Teams, Zoom, Specific VMR technology, WhatsApp).", 0, 1, this.channelType));
        children.add(new Property("address[x]", "url|string|ContactPoint|ExtendedContactDetail", "What address or number needs to be used for a user to connect to the virtual service to join. The channelType informs as to which datatype is appropriate to use (requires knowledge of the specific type).", 0, 1, this.address));
        children.add(new Property("additionalInfo", "url", "Address to see alternative connection details.", 0, Integer.MAX_VALUE, this.additionalInfo));
        children.add(new Property("maxParticipants", "positiveInt", "Maximum number of participants supported by the virtual service.", 0, 1, this.maxParticipants));
        children.add(new Property("sessionKey", "string", "Session Key required by the virtual service.", 0, 1, this.sessionKey));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 274155229: {
                return new Property("channelType", "Coding", "The type of virtual service to connect to (i.e. Teams, Zoom, Specific VMR technology, WhatsApp).", 0, 1, this.channelType);
            }
            case 1341051916: {
                return new Property("address[x]", "url|string|ContactPoint|ExtendedContactDetail", "What address or number needs to be used for a user to connect to the virtual service to join. The channelType informs as to which datatype is appropriate to use (requires knowledge of the specific type).", 0, 1, this.address);
            }
            case -1147692044: {
                return new Property("address[x]", "url|string|ContactPoint|ExtendedContactDetail", "What address or number needs to be used for a user to connect to the virtual service to join. The channelType informs as to which datatype is appropriate to use (requires knowledge of the specific type).", 0, 1, this.address);
            }
            case 1341045979: {
                return new Property("address[x]", "url", "What address or number needs to be used for a user to connect to the virtual service to join. The channelType informs as to which datatype is appropriate to use (requires knowledge of the specific type).", 0, 1, this.address);
            }
            case -740155099: {
                return new Property("address[x]", "string", "What address or number needs to be used for a user to connect to the virtual service to join. The channelType informs as to which datatype is appropriate to use (requires knowledge of the specific type).", 0, 1, this.address);
            }
            case 269121380: {
                return new Property("address[x]", "ContactPoint", "What address or number needs to be used for a user to connect to the virtual service to join. The channelType informs as to which datatype is appropriate to use (requires knowledge of the specific type).", 0, 1, this.address);
            }
            case -834417596: {
                return new Property("address[x]", "ExtendedContactDetail", "What address or number needs to be used for a user to connect to the virtual service to join. The channelType informs as to which datatype is appropriate to use (requires knowledge of the specific type).", 0, 1, this.address);
            }
            case -974297739: {
                return new Property("additionalInfo", "url", "Address to see alternative connection details.", 0, Integer.MAX_VALUE, this.additionalInfo);
            }
            case 950795044: {
                return new Property("maxParticipants", "positiveInt", "Maximum number of participants supported by the virtual service.", 0, 1, this.maxParticipants);
            }
            case 1661834217: {
                return new Property("sessionKey", "string", "Session Key required by the virtual service.", 0, 1, this.sessionKey);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 274155229: {
                Base[] baseArray;
                if (this.channelType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.channelType;
                }
                return baseArray;
            }
            case -1147692044: {
                Base[] baseArray;
                if (this.address == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.address;
                }
                return baseArray;
            }
            case -974297739: {
                return this.additionalInfo == null ? new Base[]{} : this.additionalInfo.toArray(new Base[this.additionalInfo.size()]);
            }
            case 950795044: {
                Base[] baseArray;
                if (this.maxParticipants == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.maxParticipants;
                }
                return baseArray;
            }
            case 1661834217: {
                Base[] baseArray;
                if (this.sessionKey == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.sessionKey;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 274155229: {
                this.channelType = TypeConvertor.castToCoding(value);
                return value;
            }
            case -1147692044: {
                this.address = TypeConvertor.castToType(value);
                return value;
            }
            case -974297739: {
                this.getAdditionalInfo().add(TypeConvertor.castToUrl(value));
                return value;
            }
            case 950795044: {
                this.maxParticipants = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case 1661834217: {
                this.sessionKey = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("channelType")) {
            this.channelType = TypeConvertor.castToCoding(value);
        } else if (name.equals("address[x]")) {
            this.address = TypeConvertor.castToType(value);
        } else if (name.equals("additionalInfo")) {
            this.getAdditionalInfo().add(TypeConvertor.castToUrl(value));
        } else if (name.equals("maxParticipants")) {
            this.maxParticipants = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("sessionKey")) {
            this.sessionKey = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 274155229: {
                return this.getChannelType();
            }
            case 1341051916: {
                return this.getAddress();
            }
            case -1147692044: {
                return this.getAddress();
            }
            case -974297739: {
                return this.addAdditionalInfoElement();
            }
            case 950795044: {
                return this.getMaxParticipantsElement();
            }
            case 1661834217: {
                return this.getSessionKeyElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 274155229: {
                return new String[]{"Coding"};
            }
            case -1147692044: {
                return new String[]{"url", "string", "ContactPoint", "ExtendedContactDetail"};
            }
            case -974297739: {
                return new String[]{"url"};
            }
            case 950795044: {
                return new String[]{"positiveInt"};
            }
            case 1661834217: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("channelType")) {
            this.channelType = new Coding();
            return this.channelType;
        }
        if (name.equals("addressUrl")) {
            this.address = new UrlType();
            return this.address;
        }
        if (name.equals("addressString")) {
            this.address = new StringType();
            return this.address;
        }
        if (name.equals("addressContactPoint")) {
            this.address = new ContactPoint();
            return this.address;
        }
        if (name.equals("addressExtendedContactDetail")) {
            this.address = new ExtendedContactDetail();
            return this.address;
        }
        if (name.equals("additionalInfo")) {
            throw new FHIRException("Cannot call addChild on a singleton property VirtualServiceDetail.additionalInfo");
        }
        if (name.equals("maxParticipants")) {
            throw new FHIRException("Cannot call addChild on a singleton property VirtualServiceDetail.maxParticipants");
        }
        if (name.equals("sessionKey")) {
            throw new FHIRException("Cannot call addChild on a singleton property VirtualServiceDetail.sessionKey");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "VirtualServiceDetail";
    }

    @Override
    public VirtualServiceDetail copy() {
        VirtualServiceDetail dst = new VirtualServiceDetail();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(VirtualServiceDetail dst) {
        super.copyValues(dst);
        dst.channelType = this.channelType == null ? null : this.channelType.copy();
        DataType dataType = dst.address = this.address == null ? null : this.address.copy();
        if (this.additionalInfo != null) {
            dst.additionalInfo = new ArrayList<UrlType>();
            for (UrlType i : this.additionalInfo) {
                dst.additionalInfo.add(i.copy());
            }
        }
        dst.maxParticipants = this.maxParticipants == null ? null : this.maxParticipants.copy();
        dst.sessionKey = this.sessionKey == null ? null : this.sessionKey.copy();
    }

    protected VirtualServiceDetail typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof VirtualServiceDetail)) {
            return false;
        }
        VirtualServiceDetail o = (VirtualServiceDetail)other_;
        return VirtualServiceDetail.compareDeep(this.channelType, o.channelType, true) && VirtualServiceDetail.compareDeep(this.address, o.address, true) && VirtualServiceDetail.compareDeep(this.additionalInfo, o.additionalInfo, true) && VirtualServiceDetail.compareDeep(this.maxParticipants, o.maxParticipants, true) && VirtualServiceDetail.compareDeep(this.sessionKey, o.sessionKey, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof VirtualServiceDetail)) {
            return false;
        }
        VirtualServiceDetail o = (VirtualServiceDetail)other_;
        return VirtualServiceDetail.compareValues(this.additionalInfo, o.additionalInfo, true) && VirtualServiceDetail.compareValues(this.maxParticipants, o.maxParticipants, true) && VirtualServiceDetail.compareValues(this.sessionKey, o.sessionKey, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.channelType, this.address, this.additionalInfo, this.maxParticipants, this.sessionKey});
    }
}

