/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.profilemodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.profilemodel.PEType;
import org.hl7.fhir.utilities.Utilities;

public abstract class PEDefinition {
    protected PEBuilder builder;
    protected String name;
    protected String path;
    protected StructureDefinition profile;
    protected ElementDefinition definition;
    protected List<PEType> types;
    protected Map<String, List<PEDefinition>> children = new HashMap<String, List<PEDefinition>>();
    private boolean recursing;
    private boolean mustHaveValue;
    private boolean inFixedValue;
    private boolean isSlicer;

    protected PEDefinition(PEBuilder builder, String name, StructureDefinition profile, ElementDefinition definition, String ppath) {
        this.builder = builder;
        this.name = name;
        this.profile = profile;
        this.definition = definition;
        this.path = this.path == null ? name : ppath + "." + name;
    }

    public String name() {
        return this.name;
    }

    public String path() {
        return this.path;
    }

    public String schemaName() {
        return this.definition.getName();
    }

    public List<PEType> types() {
        if (this.types == null) {
            ArrayList<PEType> ltypes = new ArrayList<PEType>();
            this.listTypes(ltypes);
            this.types = ltypes;
        }
        return this.types;
    }

    protected abstract void listTypes(List<PEType> var1);

    public int min() {
        return this.mustHaveValue ? 1 : this.definition.getMin();
    }

    public int max() {
        return this.definition.getMax() == null || "*".equals(this.definition.getMax()) ? Integer.MAX_VALUE : Integer.parseInt(this.definition.getMax());
    }

    public ElementDefinition definition() {
        return this.definition;
    }

    public ElementDefinition baseDefinition() {
        String type = this.definition.getBase().getPath();
        if (type.contains(".")) {
            type = type.substring(0, type.indexOf("."));
        }
        StructureDefinition sd = this.builder.getContext().fetchTypeDefinition(type);
        return sd.getSnapshot().getElementByPath(this.definition.getBase().getPath());
    }

    public String shortDocumentation() {
        return this.definition.getShort();
    }

    public String documentation() {
        return this.definition.getDefinition();
    }

    public List<PEDefinition> children(String typeUrl) {
        return this.children(typeUrl, false);
    }

    public List<PEDefinition> children(String typeUrl, boolean allFixed) {
        if (this.children.containsKey(typeUrl + "$" + allFixed)) {
            return this.children.get(typeUrl + "$" + allFixed);
        }
        ArrayList<PEDefinition> res = new ArrayList<PEDefinition>();
        this.makeChildren(typeUrl, res, allFixed);
        this.children.put(typeUrl + "$" + allFixed, res);
        return res;
    }

    public List<PEDefinition> children() {
        if (this.types().size() == 1) {
            return this.children(this.types.get(0).getUrl(), false);
        }
        throw new DefinitionException("Attempt to get children for an element that doesn't have a single type (types = " + this.types() + ")");
    }

    public List<PEDefinition> children(boolean allFixed) {
        if (this.types().size() == 1) {
            return this.children(this.types.get(0).getUrl(), allFixed);
        }
        throw new DefinitionException("Attempt to get children for an element that doesn't have a single type (types = " + this.types() + ")");
    }

    public boolean fixedValue() {
        return this.definition.hasFixed() || this.definition.hasPattern();
    }

    protected abstract void makeChildren(String var1, List<PEDefinition> var2, boolean var3);

    public String toString() {
        return this.name + "(" + this.schemaName() + "):" + this.types().toString() + " [" + this.min() + ":" + (Serializable)(this.max() == Integer.MAX_VALUE ? "*" : Integer.valueOf(this.max())) + "] \"" + this.shortDocumentation() + "\"";
    }

    public boolean isRecursing() {
        return this.recursing;
    }

    protected void setRecursing(boolean recursing) {
        this.recursing = recursing;
    }

    protected boolean isMustHaveValue() {
        return this.mustHaveValue;
    }

    protected void setMustHaveValue(boolean mustHaveValue) {
        this.mustHaveValue = mustHaveValue;
    }

    public boolean isInFixedValue() {
        return this.inFixedValue;
    }

    protected void setInFixedValue(boolean inFixedValue) {
        this.inFixedValue = inFixedValue;
    }

    public abstract String fhirpath();

    public boolean isList() {
        return "*".equals(this.definition.getBase().getMax());
    }

    public boolean repeats() {
        return this.max() > 1;
    }

    public PEDefinitionElementMode mode() {
        if (this.builder.isResource(this.definition.getBase().getPath())) {
            return PEDefinitionElementMode.Resource;
        }
        for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
            if ("Extension".equals(tr.getWorkingCode())) {
                return PEDefinitionElementMode.Extension;
            }
            if (Utilities.existsInList((String)tr.getWorkingCode(), (String[])new String[]{"Element", "BackboneElement"})) continue;
            return PEDefinitionElementMode.DataType;
        }
        return PEDefinitionElementMode.Element;
    }

    public boolean isProfiled() {
        return !this.profile.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition");
    }

    public boolean isSlicer() {
        return this.isSlicer;
    }

    public void setSlicer(boolean isSlicer) {
        this.isSlicer = isSlicer;
    }

    public boolean isBaseList() {
        return !"1".equals(this.definition.getBase().getMax());
    }

    public StructureDefinition getProfile() {
        return this.profile;
    }

    public boolean isKeyElement() {
        boolean selfKey;
        boolean bl = selfKey = this.definition.getMustSupport() || this.definition.getMustHaveValue() || this.min() > 0 || this.definition.hasCondition();
        if (this.isProfiled() && !selfKey && this.types() != null && this.types().size() > 0) {
            for (PEDefinition child : this.children()) {
                if (!child.isKeyElement()) continue;
                return true;
            }
        }
        return selfKey;
    }

    public static enum PEDefinitionElementMode {
        Resource,
        Element,
        DataType,
        Extension;

    }
}

