/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.comparison.VersionComparisonAnnotation;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.LoincLinker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class CodeSystemRenderer
extends TerminologyRenderer {
    private Boolean doMarkdown = null;

    public CodeSystemRenderer(RenderingContext context) {
        super(context);
    }

    public CodeSystemRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (CodeSystem)dr);
    }

    public boolean render(XhtmlNode x, CodeSystem cs) throws FHIRFormatError, DefinitionException, IOException {
        boolean hasExtensions = false;
        if (this.context.isHeader()) {
            XhtmlNode h = x.h2();
            h.addText(cs.hasTitle() ? cs.getTitle() : cs.getName());
            this.addMarkdown(x, cs.getDescription());
            if (cs.hasCopyright()) {
                this.generateCopyright(x, cs);
            }
        }
        boolean props = this.generateProperties(x, cs);
        this.generateFilters(x, cs);
        ArrayList<TerminologyRenderer.UsedConceptMap> maps = new ArrayList<TerminologyRenderer.UsedConceptMap>();
        hasExtensions = this.generateCodeSystemContent(x, cs, hasExtensions, maps, props);
        return hasExtensions;
    }

    public void describe(XhtmlNode x, CodeSystem cs) {
        x.tx(this.display(cs));
    }

    public String display(CodeSystem cs) {
        return cs.present();
    }

    private void generateFilters(XhtmlNode x, CodeSystem cs) {
        if (cs.hasFilter()) {
            x.para().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Filters", this.getContext().getLang()));
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Code", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Description", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "operator", this.getContext().getLang()));
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Value", this.getContext().getLang()));
            for (CodeSystem.CodeSystemFilterComponent f : cs.getFilter()) {
                tr = tbl.tr();
                this.renderStatus(f, tr.td()).tx(f.getCode());
                this.renderStatus(f.getDescriptionElement(), tr.td()).tx(f.getDescription());
                XhtmlNode td = tr.td();
                for (Enumeration<Enumerations.FilterOperator> t : f.getOperator()) {
                    this.renderStatus(t, td).tx(t.asStringValue() + " ");
                }
                this.renderStatus(f.getValueElement(), tr.td()).tx(f.getValue());
            }
        }
    }

    private boolean generateProperties(XhtmlNode x, CodeSystem cs) {
        if (cs.hasProperty()) {
            boolean hasRendered = false;
            boolean hasURI = false;
            boolean hasDescription = false;
            for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                hasRendered = hasRendered || !p.getCode().equals(ToolingExtensions.getPresentation(p, p.getCodeElement()));
                hasURI = hasURI || p.hasUri();
                hasDescription = hasDescription || p.hasDescription();
            }
            x.para().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Properties", this.getContext().getLang()));
            x.para().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "This code system  defines the following properties for its concepts", this.getContext().getLang()));
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            if (hasRendered) {
                tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Name", this.getContext().getLang()));
            }
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Code", this.getContext().getLang()));
            if (hasURI) {
                tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "URI", this.getContext().getLang()));
            }
            tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Type", this.getContext().getLang()));
            if (hasDescription) {
                tr.td().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Description", this.getContext().getLang()));
            }
            for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                tr = tbl.tr();
                if (hasRendered) {
                    tr.td().tx(ToolingExtensions.getPresentation(p, p.getCodeElement()));
                }
                this.renderStatus(p, tr.td()).tx(p.getCode());
                if (hasURI) {
                    this.renderStatus(p.getUriElement(), tr.td()).tx(p.getUri());
                }
                this.renderStatus(p.getTypeElement(), tr.td()).tx(p.hasType() ? p.getType().toCode() : "");
                if (!hasDescription) continue;
                this.renderStatus(p.getDescriptionElement(), tr.td()).tx(p.getDescription());
            }
            return true;
        }
        return false;
    }

    private String sentenceForContent(Enumerations.CodeSystemContentMode mode, CodeSystem cs) {
        switch (mode) {
            case COMPLETE: {
                return this.context.getContext().formatMessage("RND_CS_CONTENT_COMPLETE", new Object[0]);
            }
            case EXAMPLE: {
                return this.context.getContext().formatMessage("RND_CS_CONTENT_EXAMPLE", new Object[0]);
            }
            case FRAGMENT: {
                return this.context.getContext().formatMessage("RND_CS_CONTENT_FRAGMENT", new Object[0]);
            }
            case NOTPRESENT: {
                return this.context.getContext().formatMessage("RND_CS_CONTENT_NOTPRESENT", new Object[0]);
            }
            case SUPPLEMENT: {
                boolean properties = CodeSystemUtilities.hasProperties(cs);
                boolean designations = CodeSystemUtilities.hasDesignations(cs);
                String features = properties && designations ? "displays and properties" : (properties ? "properties" : (designations ? "displays" : "features"));
                return this.context.getContext().formatMessage("RND_CS_CONTENT_SUPPLEMENT", features);
            }
        }
        throw new FHIRException("Unknown CodeSystemContentMode mode");
    }

    private boolean generateCodeSystemContent(XhtmlNode x, CodeSystem cs, boolean hasExtensions, List<TerminologyRenderer.UsedConceptMap> maps, boolean props) throws FHIRFormatError, DefinitionException, IOException {
        if (props) {
            x.para().b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Concepts", this.getContext().getLang()));
        }
        XhtmlNode p = x.para();
        this.renderStatus(cs.getUrlElement(), p.param("cs")).code().tx(cs.getUrl());
        this.makeCasedParam(p.param("cased"), cs, cs.getCaseSensitiveElement());
        this.makeHierarchyParam(p.param("h"), cs, cs.getHierarchyMeaningElement());
        p.paramValue("code-count", CodeSystemUtilities.countCodes(cs));
        p.sentenceForParams(this.sentenceForContent(cs.getContent(), cs));
        if (cs.getContent() == Enumerations.CodeSystemContentMode.NOTPRESENT) {
            return false;
        }
        XhtmlNode t = x.table("codes");
        boolean definitions = false;
        boolean commentS = false;
        boolean deprecated = false;
        boolean display = false;
        boolean hierarchy = false;
        boolean version = false;
        boolean ignoreStatus = false;
        boolean isSupplement = cs.getContent() == Enumerations.CodeSystemContentMode.SUPPLEMENT;
        ArrayList<CodeSystem.PropertyComponent> properties = new ArrayList<CodeSystem.PropertyComponent>();
        for (CodeSystem.PropertyComponent propertyComponent : cs.getProperty()) {
            if (!this.showPropertyInTable(propertyComponent)) continue;
            boolean exists = false;
            for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
                exists = exists || this.conceptsHaveProperty(c, propertyComponent);
            }
            if (!exists) continue;
            properties.add(propertyComponent);
            if (!"status".equals(propertyComponent.getCode())) continue;
            ignoreStatus = true;
        }
        ArrayList<String> langs = new ArrayList<String>();
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            commentS = commentS || this.conceptsHaveComments(c);
            deprecated = deprecated || this.conceptsHaveDeprecated(cs, c, ignoreStatus);
            display = display || this.conceptsHaveDisplay(c);
            version = version || this.conceptsHaveVersion(c);
            hierarchy = hierarchy || c.hasConcept();
            definitions = definitions || this.conceptsHaveDefinition(c);
            this.listConceptLanguages(cs, c, langs);
        }
        CodeSystemUtilities.CodeSystemNavigator codeSystemNavigator = new CodeSystemUtilities.CodeSystemNavigator(cs);
        boolean bl = hierarchy = hierarchy || codeSystemNavigator.isRestructure();
        if (langs.size() < 2) {
            this.addCopyColumn(this.addMapHeaders(this.addTableHeaderRowStandard(t, hierarchy, display, definitions, commentS, version, deprecated, properties, langs, null, true), maps));
        } else {
            this.addCopyColumn(this.addMapHeaders(this.addTableHeaderRowStandard(t, hierarchy, display, definitions, commentS, version, deprecated, properties, null, null, false), maps));
        }
        for (CodeSystem.ConceptDefinitionComponent c : codeSystemNavigator.getConcepts(null)) {
            hasExtensions = this.addDefineRowToTable(t, c, 0, hierarchy, display, definitions, commentS, version, deprecated, maps, cs.getUrl(), cs, properties, codeSystemNavigator, langs.size() < 2 ? langs : null, isSupplement) || hasExtensions;
        }
        if (langs.size() >= 2) {
            Collections.sort(langs);
            x.para().b().tx("Additional Language Displays");
            t = x.table("codes");
            XhtmlNode tr = t.tr();
            tr.td().b().tx("Code");
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
                this.addLanguageRow(c, t, langs);
            }
        }
        return hasExtensions;
    }

    private void makeHierarchyParam(XhtmlNode x, CodeSystem cs, Enumeration<CodeSystem.CodeSystemHierarchyMeaning> hm) {
        if (hm.hasValue()) {
            String s = ((CodeSystem.CodeSystemHierarchyMeaning)((Object)hm.getValue())).getDisplay();
            this.renderStatus(hm, x).tx(" in a " + s + " heirarchy");
        } else if (VersionComparisonAnnotation.hasDeleted(cs, "hierarchyMeaning")) {
            this.makeHierarchyParam(x, null, (Enumeration)VersionComparisonAnnotation.getDeleted(cs, "hierarchyMeaning").get(0));
        } else if (CodeSystemUtilities.hasHierarchy(cs)) {
            x.tx(" in an undefined heirarchy");
        } else {
            x.tx("");
        }
    }

    private void makeCasedParam(XhtmlNode x, CodeSystem cs, BooleanType caseSensitiveElement) {
        if (caseSensitiveElement.hasValue()) {
            String s = (Boolean)caseSensitiveElement.getValue() == true ? "case-sensitive" : "case-insensitive";
            this.renderStatus(caseSensitiveElement, x).tx(s);
        } else if (VersionComparisonAnnotation.hasDeleted(cs, "caseSensitive")) {
            this.makeCasedParam(x, null, (BooleanType)VersionComparisonAnnotation.getDeleted(cs, "caseSensitive").get(0));
        } else {
            x.tx("");
        }
    }

    private void listConceptLanguages(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c, List<String> langs) {
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.hasLanguage() || langs.contains(cd.getLanguage()) || cs.hasLanguage() && cs.getLanguage().equals(cd.getLanguage())) continue;
            langs.add(cd.getLanguage());
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            this.listConceptLanguages(cs, g, langs);
        }
    }

    private void addCopyColumn(XhtmlNode tr) {
        if (this.context.isCopyButton()) {
            tr.td().b().tx("Copy");
        }
    }

    private boolean conceptsHaveDefinition(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasDefinition()) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDefinition(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveProperty(CodeSystem.ConceptDefinitionComponent c, CodeSystem.PropertyComponent cp) {
        if (CodeSystemUtilities.hasProperty(c, cp.getCode())) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveProperty(g, cp)) continue;
            return true;
        }
        return false;
    }

    private boolean showPropertyInTable(CodeSystem.PropertyComponent cp) {
        if (cp.hasCode()) {
            if (cp.hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
                return true;
            }
            if (cp.getCodeElement().hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
                return true;
            }
            String uri = cp.getUri();
            if (Utilities.noString((String)uri)) {
                return true;
            }
            String code = null;
            if (uri.contains("#")) {
                code = uri.substring(uri.indexOf("#") + 1);
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (Utilities.existsInList((String)uri, (String[])new String[]{"http://hl7.org/fhir/concept-properties"}) || this.context.getCodeSystemPropList().contains(uri)) {
                return true;
            }
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(uri);
            if (cs == null) {
                return false;
            }
            return code == null ? false : CodeSystemUtilities.hasCode(cs, code);
        }
        return false;
    }

    private int countConcepts(List<CodeSystem.ConceptDefinitionComponent> list) {
        int count = list.size();
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (!c.hasConcept()) continue;
            count += this.countConcepts(c.getConcept());
        }
        return count;
    }

    private boolean conceptsHaveComments(CodeSystem.ConceptDefinitionComponent c) {
        if (ToolingExtensions.hasCSComment(c)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveComments(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDisplay(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasDisplay() && !c.getDisplay().equals(c.getCode())) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDisplay(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveVersion(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasUserData("cs.version.notes")) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveVersion(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c, boolean ignoreStatus) {
        if (CodeSystemUtilities.isDeprecated(cs, c, ignoreStatus)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDeprecated(cs, g, ignoreStatus)) continue;
            return true;
        }
        return false;
    }

    private boolean addDefineRowToTable(XhtmlNode t, CodeSystem.ConceptDefinitionComponent c, int level, boolean hasHierarchy, boolean hasDisplay, boolean hasDefinitions, boolean comment, boolean version, boolean deprecated, List<TerminologyRenderer.UsedConceptMap> maps, String system, CodeSystem cs, List<CodeSystem.PropertyComponent> properties, CodeSystemUtilities.CodeSystemNavigator csNav, List<String> langs, boolean isSupplement) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode a;
        String link;
        boolean hasExtensions = false;
        XhtmlNode tr = t.tr();
        boolean notCurrent = CodeSystemUtilities.isNotCurrent(cs, c);
        if (notCurrent) {
            tr.setAttribute("style", "background-color: #ffeeee");
        }
        XhtmlNode td = this.renderStatusRow(c, t, tr);
        if (hasHierarchy) {
            td.addText(Integer.toString(level + 1));
            td = tr.td();
            String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(level * 2));
            td.addText(s);
        }
        String string = link = isSupplement ? this.getLinkForCode(cs.getSupplements(), null, c.getCode()) : null;
        if (link != null) {
            td.ah(link).style("white-space:nowrap").addText(c.getCode());
        } else {
            td.style("white-space:nowrap").addText(c.getCode());
        }
        if (c.hasCodeElement()) {
            td.an(cs.getId() + "-" + Utilities.nmtokenize((String)c.getCode()));
        }
        if (hasDisplay) {
            td = tr.td();
            this.renderDisplayName(c, cs, td);
        }
        if (hasDefinitions) {
            td = tr.td();
            if (c != null && c.hasDefinitionElement()) {
                if (this.getContext().getLang() == null) {
                    if (this.hasMarkdownInDefinitions(cs)) {
                        this.addMarkdown(this.renderStatusDiv(c.getDefinitionElement(), td), c.getDefinition());
                    } else {
                        this.renderStatus(c.getDefinitionElement(), td).addText(c.getDefinition());
                    }
                } else if (this.getContext().getLang().equals("*")) {
                    boolean sl = false;
                    for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                        if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
                        sl = true;
                    }
                    td.addText((String)(sl ? cs.getLanguage("en") + ": " : ""));
                    if (this.hasMarkdownInDefinitions(cs)) {
                        this.addMarkdown(this.renderStatusDiv(c.getDefinitionElement(), td), c.getDefinition());
                    } else {
                        this.renderStatus(c.getDefinitionElement(), td).addText(c.getDefinition());
                    }
                    for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                        if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
                        td.br();
                        td.addText(cd.getLanguage() + ": " + cd.getValue());
                    }
                } else if (this.getContext().getLang().equals(cs.getLanguage()) || this.getContext().getLang().equals("en") && !cs.hasLanguage()) {
                    this.renderStatus(c.getDefinitionElement(), td).addText(c.getDefinition());
                } else {
                    for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                        if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || !cd.getLanguage().equals(this.getContext().getLang())) continue;
                        td.addText(cd.getValue());
                    }
                }
            }
        }
        if (deprecated) {
            td = tr.td();
            Boolean b = CodeSystemUtilities.isDeprecated(cs, c, false);
            if (b != null && b.booleanValue()) {
                this.smartAddText(td, this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Deprecated", this.getContext().getLang()));
                hasExtensions = true;
                if (ToolingExtensions.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby")) {
                    Coding cc = (Coding)ToolingExtensions.getExtension(c, "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby").getValue();
                    td.tx(" (replaced by ");
                    String url = this.getCodingReference(cc, system);
                    if (url != null) {
                        td.ah(url).addText(cc.getCode());
                        td.tx(": " + cc.getDisplay() + ")");
                    } else {
                        td.addText(cc.getCode() + " '" + cc.getDisplay() + "' in " + cc.getSystem() + ")");
                    }
                } else {
                    Extension ext = c.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status");
                    if (ext != null && (ext = ext.getValue().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status-reason")) != null) {
                        this.addMarkdown(td, ext.getValue().primitiveValue());
                    }
                }
            }
        }
        if (comment) {
            td = tr.td();
            Extension ext = c.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments");
            if (ext != null) {
                hasExtensions = true;
                String bc = ext.hasValue() ? ext.getValue().primitiveValue() : null;
                Map<String, String> translations = ToolingExtensions.getLanguageTranslations(ext.getValue());
                if (this.getContext().getLang() == null) {
                    if (bc != null) {
                        td.addText(bc);
                    }
                } else if (this.getContext().getLang().equals("*")) {
                    boolean sl = false;
                    for (String l : translations.keySet()) {
                        if (bc != null && bc.equalsIgnoreCase(translations.get(l))) continue;
                        sl = true;
                    }
                    if (bc != null) {
                        td.addText((String)(sl ? cs.getLanguage("en") + ": " : "") + bc);
                    }
                    for (String l : translations.keySet()) {
                        if (bc != null && bc.equalsIgnoreCase(translations.get(l))) continue;
                        if (!td.getChildNodes().isEmpty()) {
                            td.br();
                        }
                        td.addText(l + ": " + translations.get(l));
                    }
                } else if (this.getContext().getLang().equals(cs.getLanguage()) || this.getContext().getLang().equals("en") && !cs.hasLanguage()) {
                    if (bc != null) {
                        td.addText(bc);
                    }
                } else {
                    if (bc != null) {
                        translations.put(cs.getLanguage("en"), bc);
                    }
                    for (String string2 : translations.keySet()) {
                        if (!string2.equals(this.getContext().getLang())) continue;
                        td.addText(translations.get(string2));
                    }
                }
            }
        }
        if (version) {
            td = tr.td();
            if (c.hasUserData("cs.version.notes")) {
                td.addText(c.getUserString("cs.version.notes"));
            }
        }
        if (properties != null) {
            for (CodeSystem.PropertyComponent pc : properties) {
                td = tr.td();
                boolean first = true;
                List<CodeSystem.ConceptPropertyComponent> pcvl = CodeSystemUtilities.getPropertyValues(c, pc.getCode());
                for (CodeSystem.ConceptPropertyComponent pcv : pcvl) {
                    if (!pcv.hasValue()) continue;
                    if (first) {
                        first = false;
                    } else {
                        td.addText(", ");
                    }
                    if (pcv.hasValueCoding()) {
                        td.addText(pcv.getValueCoding().getCode());
                        continue;
                    }
                    if (pcv.hasValueStringType() && Utilities.isAbsoluteUrlLinkable((String)pcv.getValue().primitiveValue())) {
                        td.ah(pcv.getValue().primitiveValue()).tx(pcv.getValue().primitiveValue());
                        continue;
                    }
                    td.addText(pcv.getValue().primitiveValue());
                }
            }
        }
        if (langs != null) {
            for (String lang : langs) {
                td = tr.td().tx(this.getDisplay(lang, c));
            }
        }
        for (TerminologyRenderer.UsedConceptMap m : maps) {
            td = tr.td();
            List<TerminologyRenderer.TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), m.getMap());
            boolean first = true;
            for (TerminologyRenderer.TargetElementComponentWrapper mapping : mappings) {
                if (!first) {
                    td.br();
                }
                first = false;
                XhtmlNode span = td.span(null, mapping.comp.hasRelationship() ? mapping.comp.getRelationship().toCode() : "");
                span.addText(this.getCharForRelationship(mapping.comp));
                a = td.ah(this.getContext().getLink(RenderingContext.KnownLinkType.SPEC) + m.getLink() + "#" + this.makeAnchor(mapping.group.getTarget(), mapping.comp.getCode()));
                a.addText(mapping.comp.getCode());
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
        List<CodeSystem.ConceptDefinitionComponent> ocl = csNav.getOtherChildren(c);
        for (CodeSystem.ConceptDefinitionComponent cc : csNav.getConcepts(c)) {
            hasExtensions = this.addDefineRowToTable(t, cc, level + 1, hasHierarchy, hasDisplay, hasDefinitions, comment, version, deprecated, maps, system, cs, properties, csNav, langs, isSupplement) || hasExtensions;
        }
        for (CodeSystem.ConceptDefinitionComponent cc : ocl) {
            int n;
            tr = t.tr();
            td = tr.td();
            td.addText(Integer.toString(level + 2));
            td = tr.td();
            String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)((level + 1) * 2));
            td.addText(s);
            td.style("white-space:nowrap");
            a = td.ah("#" + cs.getId() + "-" + Utilities.nmtokenize((String)cc.getCode()));
            a.addText(cc.getCode());
            if (hasDisplay) {
                td = tr.td();
                this.renderDisplayName(cc, cs, td);
            }
            int n2 = 1 + (deprecated ? 1 : 0) + (comment ? 1 : 0) + (version ? 1 : 0) + maps.size();
            if (properties != null) {
                n = n2 + properties.size();
            }
            td = tr.td().colspan(Integer.toString(n));
        }
        if (this.context.isCopyButton()) {
            td = tr.td();
            this.clipboard(td, "icon_clipboard_x.png", "XML", "<system value=\"" + Utilities.escapeXml((String)cs.getUrl()) + "\">\n" + (String)(cs.getVersionNeeded() ? "<version value=\"" + Utilities.escapeXml((String)cs.getVersion()) + "\">\n" : "") + "<code value=\"" + Utilities.escapeXml((String)c.getCode()) + "\">\n<display value=\"" + Utilities.escapeXml((String)c.getDisplay()) + "\">\n");
            td.nbsp();
            this.clipboard(td, "icon_clipboard_j.png", "JSON", "\"system\" : \"" + Utilities.escapeXml((String)cs.getUrl()) + "\",\n" + (String)(cs.getVersionNeeded() ? "\"version\" : \"" + Utilities.escapeXml((String)cs.getVersion()) + "\",\n" : "") + "\"code\" : \"" + Utilities.escapeXml((String)c.getCode()) + "\",\n\"display\" : \"" + Utilities.escapeXml((String)c.getDisplay()) + "\"\n");
        }
        return hasExtensions;
    }

    private String getDisplay(String lang, CodeSystem.ConceptDefinitionComponent c) {
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || !cd.getLanguage().equals(lang)) continue;
            return cd.getValue();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
            if (!cd.hasLanguage() || !cd.getLanguage().equals(lang)) continue;
            return cd.getValue();
        }
        return null;
    }

    private boolean hasMarkdownInDefinitions(CodeSystem cs) {
        if (this.doMarkdown == null) {
            this.doMarkdown = cs.hasExtension("http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown") ? Boolean.valueOf(ToolingExtensions.readBoolExtension(cs, "http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown")) : Boolean.valueOf(CodeSystemUtilities.hasMarkdownInDefinitions(cs, this.context.getMarkdown()));
        }
        return this.doMarkdown;
    }

    public void renderDisplayName(CodeSystem.ConceptDefinitionComponent c, CodeSystem cs, XhtmlNode td) {
        block9: {
            if (!c.hasDisplayElement()) break block9;
            if (this.getContext().getLang() == null) {
                this.renderStatus(c.getDisplayElement(), td).addText(c.getDisplay());
            } else if (this.getContext().getLang().equals("*")) {
                boolean sl = false;
                for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                    if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || c.getDisplay().equalsIgnoreCase(cd.getValue())) continue;
                    sl = true;
                }
                td.addText((String)(sl ? cs.getLanguage("en") + ": " : "") + c.getDisplay());
                for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                    if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || c.getDisplay().equalsIgnoreCase(cd.getValue())) continue;
                    td.br();
                    td.addText(cd.getLanguage() + ": " + cd.getValue());
                }
            } else if (this.getContext().getLang().equals(cs.getLanguage()) || this.getContext().getLang().equals("en") && !cs.hasLanguage()) {
                this.renderStatus(c.getDisplayElement(), td).addText(c.getDisplay());
            } else {
                for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                    if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || !cd.getLanguage().equals(this.getContext().getLang())) continue;
                    td.addText(cd.getValue());
                }
            }
        }
    }

    private String getCodingReference(Coding cc, String system) {
        if (cc.getSystem().equals(system)) {
            return "#" + cc.getCode();
        }
        if (cc.getSystem().equals("http://snomed.info/sct")) {
            return "http://snomed.info/sct/" + cc.getCode();
        }
        if (cc.getSystem().equals("http://loinc.org")) {
            return LoincLinker.getLinkForCode((String)cc.getCode());
        }
        return null;
    }

    private void addLanguageRow(CodeSystem.ConceptDefinitionComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        for (String lang : langs) {
            CodeSystem.ConceptDefinitionDesignationComponent d = null;
            for (CodeSystem.ConceptDefinitionDesignationComponent designation : c.getDesignation()) {
                if (!designation.hasLanguage() || !lang.equals(designation.getLanguage())) continue;
                d = designation;
            }
            tr.td().addText(d == null ? "" : d.getValue());
        }
    }
}

