/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ExampleScenarioRenderer
extends TerminologyRenderer {
    public ExampleScenarioRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource scen) throws IOException {
        return this.render(x, (ExampleScenario)scen);
    }

    public boolean render(XhtmlNode x, ExampleScenario scen) throws FHIRException {
        try {
            switch (this.context.getScenarioMode()) {
                case ACTORS: {
                    return this.renderActors(x, scen);
                }
                case INSTANCES: {
                    return this.renderInstances(x, scen);
                }
                case PROCESSES: {
                    return this.renderProcesses(x, scen);
                }
            }
            throw new FHIRException("Unknown ExampleScenario Renderer Mode " + this.context.getScenarioMode());
        }
        catch (Exception e) {
            throw new FHIRException("Error rendering ExampleScenario " + scen.getUrl(), (Throwable)e);
        }
    }

    public String renderDiagram(ExampleScenario scen) throws IOException {
        String plantUml = this.toPlantUml(scen);
        SourceStringReader reader = new SourceStringReader(plantUml);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
        os.close();
        String svg = new String(os.toByteArray(), Charset.forName("UTF-8"));
        return svg;
    }

    protected String toPlantUml(ExampleScenario scen) throws IOException {
        Object plantUml = "@startuml\r\n";
        plantUml = (String)plantUml + "Title " + (scen.hasTitle() ? scen.getTitle() : scen.getName()) + "\r\n\r\n";
        HashMap<String, String> actorKeys = new HashMap<String, String>();
        for (ExampleScenario.ExampleScenarioActorComponent actor : scen.getActor()) {
            String actorType = actor.getType().equals((Object)Enumerations.ExampleScenarioActorType.PERSON) ? "actor" : "participant";
            actorKeys.put(actor.getKey(), this.escapeKey(actor.getKey()));
            plantUml = (String)plantUml + actorType + " \"" + this.creolLink(actor.getTitle(), "#a_" + actor.getKey(), actor.getDescription()) + "\" as " + (String)actorKeys.get(actor.getKey()) + "\r\n";
        }
        plantUml = (String)plantUml + "\r\n";
        int processNum = 1;
        for (ExampleScenario.ExampleScenarioProcessComponent process : scen.getProcess()) {
            plantUml = (String)plantUml + this.toPlantUml(process, Integer.toString(processNum), scen, actorKeys);
            ++processNum;
        }
        plantUml = (String)plantUml + "@enduml";
        return plantUml;
    }

    private String escapeKey(String origKey) {
        char[] chars = origKey.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '@' || c == '.') continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    protected String toPlantUml(ExampleScenario.ExampleScenarioProcessComponent process, String prefix, ExampleScenario scen, Map<String, String> actorKeys) throws IOException {
        String plantUml = "group " + process.getTitle() + " " + this.creolLink("details", "#p_" + prefix, process.getDescription()) + "\r\n";
        HashMap<String, Boolean> actorsActive = new HashMap<String, Boolean>();
        for (ExampleScenario.ExampleScenarioActorComponent actor : scen.getActor()) {
            actorsActive.put(actor.getKey(), Boolean.FALSE);
        }
        int stepCount = 1;
        for (ExampleScenario.ExampleScenarioProcessStepComponent step : process.getStep()) {
            plantUml = plantUml + this.toPlantUml(step, this.stepPrefix(prefix, step, stepCount), scen, actorsActive, actorKeys);
            if (step.getPause()) {
                plantUml = plantUml + "... time passes ...\n";
            }
            ++stepCount;
        }
        plantUml = plantUml + "end\r\n\r\n";
        return plantUml;
    }

    protected String toPlantUml(ExampleScenario.ExampleScenarioProcessStepComponent step, String prefix, ExampleScenario scen, Map<String, Boolean> actorsActive, Map<String, String> actorKeys) throws IOException {
        Object plantUml = "";
        if (step.hasWorkflow()) {
            XhtmlDocument n = new XhtmlDocument();
            this.renderCanonical(scen, (XhtmlNode)n, step.getWorkflow());
            XhtmlNode ref = n.getChildNodes().get(0);
            plantUml = (String)plantUml + this.noteOver(scen.getActor(), "Step " + this.trimPrefix(prefix) + " - See scenario\n" + this.creolLink(ref.getContent(), ref.getAttribute("href")));
        } else {
            plantUml = step.hasProcess() ? (String)plantUml + this.toPlantUml(step.getProcess(), prefix, scen, actorKeys) : (String)plantUml + this.toPlantUml(step.getOperation(), prefix, scen, actorsActive, actorKeys);
        }
        return plantUml;
    }

    protected String toPlantUml(ExampleScenario.ExampleScenarioProcessStepOperationComponent op, String prefix, ExampleScenario scen, Map<String, Boolean> actorsActive, Map<String, String> actorKeys) {
        StringBuilder plantUml = new StringBuilder();
        plantUml.append(this.handleActivation(op.getInitiator(), op.getInitiatorActive(), actorsActive, actorKeys));
        plantUml.append(this.handleActivation(op.getReceiver(), op.getReceiverActive(), actorsActive, actorKeys));
        plantUml.append(actorKeys.get(op.getInitiator()) + " -> " + actorKeys.get(op.getReceiver()) + ": ");
        plantUml.append(this.creolLink(op.getTitle(), "#s_" + prefix, op.getDescription()));
        if (op.hasRequest()) {
            plantUml.append(" (" + this.creolLink("payload", this.linkForInstance(op.getRequest())) + ")\r\n");
        }
        if (op.hasResponse()) {
            plantUml.append("activate " + actorKeys.get(op.getReceiver()) + "\r\n");
            plantUml.append(actorKeys.get(op.getReceiver()) + " --> " + actorKeys.get(op.getInitiator()) + ": ");
            plantUml.append(this.creolLink("response", "#s_" + prefix, op.getDescription()));
            plantUml.append(" (" + this.creolLink("payload", this.linkForInstance(op.getResponse())) + ")\r\n");
            plantUml.append("deactivate " + actorKeys.get(op.getReceiver()) + "\r\n");
        }
        plantUml.append(this.handleDeactivation(op.getInitiator(), op.getInitiatorActive(), actorsActive, actorKeys));
        plantUml.append(this.handleDeactivation(op.getReceiver(), op.getReceiverActive(), actorsActive, actorKeys));
        return plantUml.toString();
    }

    private String handleActivation(String actorId, boolean active, Map<String, Boolean> actorsActive, Map<String, String> actorKeys) {
        Object plantUml = "";
        Boolean actorWasActive = actorsActive.get(actorId);
        if (active && !actorWasActive.booleanValue()) {
            plantUml = (String)plantUml + "activate " + actorKeys.get(actorId) + "\r\n";
        }
        return plantUml;
    }

    private String handleDeactivation(String actorId, boolean active, Map<String, Boolean> actorsActive, Map<String, String> actorKeys) {
        Object plantUml = "";
        Boolean actorWasActive = actorsActive.get(actorId);
        if (!active && actorWasActive.booleanValue()) {
            plantUml = (String)plantUml + "deactivate " + actorKeys.get(actorId) + "\r\n";
        }
        if (active != actorWasActive) {
            actorsActive.remove(actorId);
            actorsActive.put(actorId, active);
        }
        return plantUml;
    }

    private String linkForInstance(ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent ref) {
        String plantUml = "#i_" + ref.getInstanceReference();
        if (ref.hasVersionReference()) {
            plantUml = plantUml + "v_" + ref.getVersionReference();
        }
        return plantUml;
    }

    private String trimPrefix(String prefix) {
        return prefix.substring(prefix.lastIndexOf(".") + 1);
    }

    private String noteOver(List<ExampleScenario.ExampleScenarioActorComponent> actors, String text) {
        Object plantUml = "Note over ";
        ArrayList<String> actorKeys = new ArrayList<String>();
        for (ExampleScenario.ExampleScenarioActorComponent actor : actors) {
            actorKeys.add(actor.getKey());
        }
        plantUml = (String)plantUml + String.join((CharSequence)", ", actorKeys);
        plantUml = (String)plantUml + " " + text;
        return plantUml;
    }

    private String creolLink(String text, String url) {
        return this.creolLink(text, url, null);
    }

    private String creolLink(String text, String url, String flyover) {
        String s = "[[" + url;
        if (flyover != null) {
            s = s + "{" + flyover + "}";
        }
        s = s + " " + text + "]]";
        return s;
    }

    public boolean renderActors(XhtmlNode x, ExampleScenario scen) throws IOException {
        XhtmlNode tbl = x.table("table-striped table-bordered");
        XhtmlNode thead = tbl.tr();
        thead.th().addText("Name");
        thead.th().addText("Type");
        thead.th().addText("Description");
        for (ExampleScenario.ExampleScenarioActorComponent actor : scen.getActor()) {
            XhtmlNode tr = tbl.tr();
            XhtmlNode nameCell = tr.td();
            nameCell.an("a_" + actor.getKey());
            nameCell.tx(actor.getTitle());
            tr.td().tx(actor.getType().getDisplay());
            this.addMarkdown(tr.td().style("overflow-wrap:break-word"), actor.getDescription());
        }
        return true;
    }

    public boolean renderInstances(XhtmlNode x, ExampleScenario scen) throws IOException {
        XhtmlNode tbl = x.table("table-striped table-bordered");
        XhtmlNode thead = tbl.tr();
        thead.th().addText("Name");
        thead.th().addText("Type");
        thead.th().addText("Content");
        thead.th().addText("Description");
        HashMap<CallSite, String> instanceNames = new HashMap<CallSite, String>();
        for (ExampleScenario.ExampleScenarioInstanceComponent instance : scen.getInstance()) {
            instanceNames.put((CallSite)((Object)("i_" + instance.getKey())), instance.getTitle());
            if (!instance.hasVersion()) continue;
            for (ExampleScenario.ExampleScenarioInstanceVersionComponent version : instance.getVersion()) {
                instanceNames.put((CallSite)((Object)("i_" + instance.getKey() + "v_" + version.getKey())), version.getTitle());
            }
        }
        for (ExampleScenario.ExampleScenarioInstanceComponent instance : scen.getInstance()) {
            XhtmlNode row = tbl.tr();
            XhtmlNode nameCell = row.td();
            nameCell.an("i_" + instance.getKey());
            nameCell.tx(instance.getTitle());
            XhtmlNode typeCell = row.td();
            if (instance.hasVersion()) {
                typeCell.attribute("rowSpan", Integer.toString(instance.getVersion().size() + 1));
            }
            if (!instance.hasStructureVersion() || instance.getStructureType().getSystem().equals("")) {
                if (instance.hasStructureVersion()) {
                    typeCell.tx("FHIR version " + instance.getStructureVersion() + " ");
                }
                if (instance.hasStructureProfile()) {
                    this.renderCanonical(scen, typeCell, instance.getStructureProfile().toString());
                } else {
                    this.renderCanonical(scen, typeCell, "http://hl7.org/fhir/StructureDefinition/" + instance.getStructureType().getCode());
                }
            } else {
                this.render(typeCell, instance.getStructureVersionElement());
                typeCell.tx(" version " + instance.getStructureVersion());
                if (instance.hasStructureProfile()) {
                    typeCell.tx(" ");
                    this.renderCanonical(scen, typeCell, instance.getStructureProfile().toString());
                }
            }
            if (instance.hasContent() && instance.getContent().hasReference()) {
                RenderingContext.ResourceRendererMode mode = this.context.getMode();
                this.context.setMode(RenderingContext.ResourceRendererMode.END_USER);
                this.renderReference(scen, row.td(), instance.getContent().copy().setDisplay("here"));
                this.context.setMode(mode);
            } else {
                row.td();
            }
            XhtmlNode descCell = row.td();
            this.addMarkdown(descCell, instance.getDescription());
            if (instance.hasContainedInstance()) {
                descCell.b().tx("Contains: ");
                int containedCount = 1;
                for (ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent contained : instance.getContainedInstance()) {
                    String description;
                    String key = "i_" + contained.getInstanceReference();
                    if (contained.hasVersionReference()) {
                        key = key + "v_" + contained.getVersionReference();
                    }
                    if ((description = (String)instanceNames.get(key)) == null) {
                        throw new FHIRException("Unable to find contained instance " + key + " under " + instance.getKey());
                    }
                    descCell.ah("#" + key).tx(description);
                    if (instance.getContainedInstance().size() <= ++containedCount) continue;
                    descCell.tx(", ");
                }
            }
            for (ExampleScenario.ExampleScenarioInstanceVersionComponent version : instance.getVersion()) {
                row = tbl.tr();
                nameCell = row.td().style("padding-left: 10px;");
                nameCell.an("i_" + instance.getKey() + "v_" + version.getKey());
                XhtmlNode nameItem = nameCell.ul().li();
                nameItem.tx(version.getTitle());
                if (version.hasContent() && version.getContent().hasReference()) {
                    RenderingContext.ResourceRendererMode mode = this.context.getMode();
                    this.context.setMode(RenderingContext.ResourceRendererMode.END_USER);
                    this.renderReference(scen, row.td(), version.getContent().copy().setDisplay("here"));
                    this.context.setMode(mode);
                } else {
                    row.td();
                }
                descCell = row.td();
                this.addMarkdown(descCell, instance.getDescription());
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean renderProcesses(XhtmlNode x, ExampleScenario scen) throws IOException {
        HashMap<String, ExampleScenario.ExampleScenarioActorComponent> actors = new HashMap<String, ExampleScenario.ExampleScenarioActorComponent>();
        for (ExampleScenario.ExampleScenarioActorComponent exampleScenarioActorComponent : scen.getActor()) {
            actors.put(exampleScenarioActorComponent.getKey(), exampleScenarioActorComponent);
        }
        HashMap<String, ExampleScenario.ExampleScenarioInstanceComponent> instances = new HashMap<String, ExampleScenario.ExampleScenarioInstanceComponent>();
        for (ExampleScenario.ExampleScenarioInstanceComponent instance : scen.getInstance()) {
            instances.put(instance.getKey(), instance);
        }
        boolean bl = true;
        for (ExampleScenario.ExampleScenarioProcessComponent process : scen.getProcess()) {
            void var5_8;
            this.renderProcess(x, process, Integer.toString((int)var5_8), actors, instances);
            ++var5_8;
        }
        return true;
    }

    public void renderProcess(XhtmlNode x, ExampleScenario.ExampleScenarioProcessComponent process, String prefix, Map<String, ExampleScenario.ExampleScenarioActorComponent> actors, Map<String, ExampleScenario.ExampleScenarioInstanceComponent> instances) throws IOException {
        XhtmlNode div = x.div();
        div.an("p_" + prefix);
        div.b().tx("Process: " + process.getTitle());
        if (process.hasDescription()) {
            this.addMarkdown(div, process.getDescription());
        }
        if (process.hasPreConditions()) {
            div.para().b().i().tx("Pre-conditions:");
            this.addMarkdown(div, process.getPreConditions());
        }
        if (process.hasPostConditions()) {
            div.para().b().i().tx("Post-conditions:");
            this.addMarkdown(div, process.getPostConditions());
        }
        XhtmlNode tbl = div.table("table-striped table-bordered").style("width:100%");
        XhtmlNode thead = tbl.tr();
        thead.th().addText("Step");
        thead.th().addText("Name");
        thead.th().addText("Description");
        thead.th().addText("Initator");
        thead.th().addText("Receiver");
        thead.th().addText("Request");
        thead.th().addText("Response");
        int stepCount = 1;
        for (ExampleScenario.ExampleScenarioProcessStepComponent step : process.getStep()) {
            this.renderStep(tbl, step, this.stepPrefix(prefix, step, stepCount), actors, instances);
            ++stepCount;
        }
        stepCount = 1;
        for (ExampleScenario.ExampleScenarioProcessStepComponent step : process.getStep()) {
            this.stepSubProcesses(tbl, step, this.stepPrefix(prefix, step, stepCount), actors, instances);
            ++stepCount;
        }
    }

    private String stepPrefix(String prefix, ExampleScenario.ExampleScenarioProcessStepComponent step, int stepCount) {
        String num = step.hasNumber() ? step.getNumber() : Integer.toString(stepCount);
        return (String)(!prefix.isEmpty() ? prefix + "." : "") + num;
    }

    private String altStepPrefix(String prefix, ExampleScenario.ExampleScenarioProcessStepComponent step, int altNum, int stepCount) {
        return this.stepPrefix(prefix + "-Alt" + Integer.toString(altNum) + ".", step, stepCount);
    }

    private void stepSubProcesses(XhtmlNode x, ExampleScenario.ExampleScenarioProcessStepComponent step, String prefix, Map<String, ExampleScenario.ExampleScenarioActorComponent> actors, Map<String, ExampleScenario.ExampleScenarioInstanceComponent> instances) throws IOException {
        if (step.hasProcess()) {
            this.renderProcess(x, step.getProcess(), prefix, actors, instances);
        }
        if (step.hasAlternative()) {
            int altNum = 1;
            for (ExampleScenario.ExampleScenarioProcessStepAlternativeComponent alt : step.getAlternative()) {
                int stepCount = 1;
                for (ExampleScenario.ExampleScenarioProcessStepComponent altStep : alt.getStep()) {
                    this.stepSubProcesses(x, altStep, this.altStepPrefix(prefix, altStep, altNum, stepCount), actors, instances);
                    ++stepCount;
                }
                ++altNum;
            }
        }
    }

    private boolean renderStep(XhtmlNode tbl, ExampleScenario.ExampleScenarioProcessStepComponent step, String stepLabel, Map<String, ExampleScenario.ExampleScenarioActorComponent> actors, Map<String, ExampleScenario.ExampleScenarioInstanceComponent> instances) throws IOException {
        XhtmlNode n;
        XhtmlNode row = tbl.tr();
        XhtmlNode prefixCell = row.td();
        prefixCell.an("s_" + stepLabel);
        prefixCell.tx(stepLabel.substring(stepLabel.indexOf(".") + 1));
        if (step.hasProcess()) {
            n = row.td().colspan(6);
            n.tx("See subprocess");
            n.ah("#p_" + stepLabel, step.getProcess().getTitle());
            n.tx(" below");
        } else if (step.hasWorkflow()) {
            n = row.td().colspan(6);
            n.tx("See other scenario ");
            String link = new ContextUtilities(this.context.getWorker()).getLinkForUrl(this.context.getLink(RenderingContext.KnownLinkType.SPEC), step.getWorkflow());
            n.ah(link, step.getProcess().getTitle());
        } else {
            ExampleScenario.ExampleScenarioProcessStepOperationComponent op = step.getOperation();
            XhtmlNode name = row.td();
            name.tx(op.getTitle());
            if (op.hasType()) {
                name.tx(" - ");
                this.renderCoding(name, op.getType());
            }
            XhtmlNode descCell = row.td();
            this.addMarkdown(descCell, op.getDescription());
            this.addActor(row, op.getInitiator(), actors);
            this.addActor(row, op.getReceiver(), actors);
            this.addInstance(row, op.getRequest(), instances);
            this.addInstance(row, op.getResponse(), instances);
        }
        int altNum = 1;
        for (ExampleScenario.ExampleScenarioProcessStepAlternativeComponent alt : step.getAlternative()) {
            XhtmlNode altHeading = tbl.tr().colspan(7).td();
            altHeading.para().i().tx("Alternative " + alt.getTitle());
            if (alt.hasDescription()) {
                this.addMarkdown(altHeading, alt.getDescription());
            }
            int stepCount = 1;
            for (ExampleScenario.ExampleScenarioProcessStepComponent subStep : alt.getStep()) {
                this.renderStep(tbl, subStep, this.altStepPrefix(stepLabel, step, altNum, stepCount), actors, instances);
                ++stepCount;
            }
            ++altNum;
        }
        return true;
    }

    private void addActor(XhtmlNode row, String actorId, Map<String, ExampleScenario.ExampleScenarioActorComponent> actors) throws FHIRException {
        XhtmlNode actorCell = row.td();
        if (actorId == null) {
            return;
        }
        ExampleScenario.ExampleScenarioActorComponent actor = actors.get(actorId);
        if (actor == null) {
            throw new FHIRException("Unable to find referenced actor " + actorId);
        }
        actorCell.ah("#a_" + actor.getKey(), actor.getDescription()).tx(actor.getTitle());
    }

    private void addInstance(XhtmlNode row, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent instanceRef, Map<String, ExampleScenario.ExampleScenarioInstanceComponent> instances) {
        XhtmlNode instanceCell = row.td();
        if (instanceRef == null || instanceRef.getInstanceReference() == null) {
            return;
        }
        ExampleScenario.ExampleScenarioInstanceComponent instance = instances.get(instanceRef.getInstanceReference());
        if (instance == null) {
            throw new FHIRException("Unable to find referenced instance " + instanceRef.getInstanceReference());
        }
        if (instanceRef.hasVersionReference()) {
            ExampleScenario.ExampleScenarioInstanceVersionComponent theVersion = null;
            for (ExampleScenario.ExampleScenarioInstanceVersionComponent version : instance.getVersion()) {
                if (!version.getKey().equals(instanceRef.getVersionReference())) continue;
                theVersion = version;
                break;
            }
            if (theVersion == null) {
                throw new FHIRException("Unable to find referenced version " + instanceRef.getVersionReference() + " within instance " + instanceRef.getInstanceReference());
            }
            instanceCell.ah("#i_" + instance.getKey() + "v_" + theVersion.getKey(), theVersion.getDescription()).tx(theVersion.getTitle());
        } else {
            instanceCell.ah("#i_" + instance.getKey(), instance.getDescription()).tx(instance.getTitle());
        }
    }
}

