/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.CodeResolver;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.IMarkdownProcessor;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlNodeList;

public class ObligationsRenderer {
    private static String STYLE_UNCHANGED = "opacity: 0.5;";
    private static String STYLE_REMOVED = STYLE_UNCHANGED + "text-decoration: line-through;";
    private List<ObligationDetail> obligations = new ArrayList<ObligationDetail>();
    private String corePath;
    private StructureDefinition profile;
    private String path;
    private RenderingContext context;
    private IMarkdownProcessor md;
    private CodeResolver cr;

    public ObligationsRenderer(String corePath, StructureDefinition profile, String path, RenderingContext context, IMarkdownProcessor md, CodeResolver cr) {
        this.corePath = corePath;
        this.profile = profile;
        this.path = path;
        this.context = context;
        this.md = md;
        this.cr = cr;
    }

    public void seeObligations(ElementDefinition element, String id) {
        this.seeObligations(element.getExtension(), null, false, id);
    }

    public void seeObligations(List<Extension> list) {
        this.seeObligations(list, null, false, "$all");
    }

    public void seeRootObligations(String eid, List<Extension> list) {
        this.seeRootObligations(eid, list, null, false, "$all");
    }

    public void seeObligations(List<Extension> list, List<Extension> compList, boolean compare, String id) {
        HashMap<String, ObligationDetail> compBindings = new HashMap<String, ObligationDetail>();
        if (compare && compList != null) {
            for (Extension ext : compList) {
                ObligationDetail abr = this.obligationDetail(ext);
                if (compBindings.containsKey(abr.getKey())) {
                    abr.incrementCount();
                }
                compBindings.put(abr.getKey(), abr);
            }
        }
        for (Extension ext : list) {
            ObligationDetail obd = this.obligationDetail(ext);
            if (!"$all".equals(id) && !obd.hasActor(id)) continue;
            if (compare && compList != null) {
                ObligationDetail match = null;
                do {
                    match = (ObligationDetail)compBindings.get(obd.getKey());
                    if (!obd.alreadyMatched()) continue;
                    obd.incrementCount();
                } while (match != null && obd.alreadyMatched());
                if (match != null) {
                    obd.setCompare(match);
                }
                this.obligations.add(obd);
                if (obd.compare == null) continue;
                compBindings.remove(obd.compare.getKey());
                continue;
            }
            this.obligations.add(obd);
        }
        for (ObligationDetail b : compBindings.values()) {
            b.removed = true;
            this.obligations.add(b);
        }
    }

    public void seeRootObligations(String eid, List<Extension> list, List<Extension> compList, boolean compare, String id) {
        HashMap<String, ObligationDetail> compBindings = new HashMap<String, ObligationDetail>();
        if (compare && compList != null) {
            for (Extension ext : compList) {
                if (!this.forElement(eid, ext)) continue;
                ObligationDetail abr = this.obligationDetail(ext);
                if (compBindings.containsKey(abr.getKey())) {
                    abr.incrementCount();
                }
                compBindings.put(abr.getKey(), abr);
            }
        }
        for (Extension ext : list) {
            if (!this.forElement(eid, ext)) continue;
            ObligationDetail obd = this.obligationDetail(ext);
            obd.elementIds.clear();
            if (!"$all".equals(id) && !obd.hasActor(id)) continue;
            if (compare && compList != null) {
                ObligationDetail match = null;
                do {
                    match = (ObligationDetail)compBindings.get(obd.getKey());
                    if (!obd.alreadyMatched()) continue;
                    obd.incrementCount();
                } while (match != null && obd.alreadyMatched());
                if (match != null) {
                    obd.setCompare(match);
                }
                this.obligations.add(obd);
                if (obd.compare == null) continue;
                compBindings.remove(obd.compare.getKey());
                continue;
            }
            this.obligations.add(obd);
        }
        for (ObligationDetail b : compBindings.values()) {
            b.removed = true;
            this.obligations.add(b);
        }
    }

    private boolean forElement(String eid, Extension ext) {
        for (Extension exid : ext.getExtensionsByUrl("elementId")) {
            if (!eid.equals(exid.getValue().primitiveValue())) continue;
            return true;
        }
        return false;
    }

    protected ObligationDetail obligationDetail(Extension ext) {
        ObligationDetail abr = new ObligationDetail(ext);
        return abr;
    }

    public String render() throws IOException {
        if (this.obligations.isEmpty()) {
            return "";
        }
        XhtmlNode tbl = new XhtmlNode(NodeType.Element, "table");
        tbl.attribute("class", "grid");
        this.renderTable((List<XhtmlNode>)tbl.getChildNodes(), true);
        return new XhtmlComposer(false).compose(tbl);
    }

    public void renderTable(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell c) throws FHIRFormatError, DefinitionException, IOException {
        if (this.obligations.isEmpty()) {
            return;
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "table").attr("class", "grid");
        c.getPieces().add(piece);
        this.renderTable((List<XhtmlNode>)piece.getChildren(), false);
    }

    public void renderList(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell c) throws FHIRFormatError, DefinitionException, IOException {
        if (this.obligations.size() > 0) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null);
            c.addPiece(p);
            if (this.obligations.size() == 1) {
                this.renderObligationLI(p.getChildren(), this.obligations.get(0));
            } else {
                XhtmlNode ul = p.getChildren().ul();
                for (ObligationDetail ob : this.obligations) {
                    this.renderObligationLI(ul.li().getChildNodes(), ob);
                }
            }
        }
    }

    private void renderObligationLI(XhtmlNodeList children, ObligationDetail ob) throws IOException {
        this.renderCode(children, ob.getCode());
        if (ob.hasFilter() || ob.hasUsage()) {
            boolean ffirst;
            children.tx(" (");
            boolean bl = ffirst = !ob.hasFilter();
            if (ob.hasFilter()) {
                children.span(null, ob.getFilterDesc()).code().tx(ob.getFilter());
            }
            for (UsageContext uc : ob.getUsage()) {
                if (ffirst) {
                    ffirst = false;
                } else {
                    children.tx(",");
                }
                if (!uc.getCode().is("http://terminology.hl7.org/CodeSystem/usage-context-type", "jurisdiction")) {
                    children.tx(this.displayForUsage(uc.getCode()));
                    children.tx("=");
                }
                CodeResolver.CodeResolution ccr = this.cr.resolveCode(uc.getValueCodeableConcept());
                children.ah(ccr.getLink(), ccr.getHint()).tx(ccr.getDisplay());
            }
            children.tx(")");
        }
    }

    public void renderTable(List<XhtmlNode> children, boolean fullDoco) throws FHIRFormatError, DefinitionException, IOException {
        boolean doco = false;
        boolean usage = false;
        boolean actor = false;
        boolean filter = false;
        boolean elementId = false;
        for (ObligationDetail binding : this.obligations) {
            actor = actor || binding.actor != null || binding.compare != null && binding.compare.actor != null;
            doco = doco || binding.getDoco(fullDoco) != null || binding.compare != null && binding.compare.getDoco(fullDoco) != null;
            usage = usage || !binding.usage.isEmpty() || binding.compare != null && !binding.compare.usage.isEmpty();
            filter = filter || binding.filter != null || binding.compare != null && binding.compare.filter != null;
            elementId = elementId || !binding.elementIds.isEmpty() || binding.compare != null && !binding.compare.elementIds.isEmpty();
        }
        XhtmlNode tr = new XhtmlNode(NodeType.Element, "tr");
        children.add(tr);
        tr.td().style("font-size: 11px").b().tx("Obligations");
        if (actor) {
            tr.td().style("font-size: 11px").tx("Actor");
        }
        if (elementId) {
            tr.td().style("font-size: 11px").tx("Elements");
        }
        if (usage) {
            tr.td().style("font-size: 11px").tx("Usage");
        }
        if (doco) {
            tr.td().style("font-size: 11px").tx("Documentation");
        }
        if (filter) {
            tr.td().style("font-size: 11px").tx("Filter");
        }
        for (ObligationDetail ob : this.obligations) {
            String oldD;
            tr = new XhtmlNode(NodeType.Element, "tr");
            if (ob.unchanged()) {
                tr.style(STYLE_REMOVED);
            } else if (ob.removed) {
                tr.style(STYLE_REMOVED);
            }
            children.add(tr);
            XhtmlNode code = tr.td().style("font-size: 11px");
            if (ob.compare != null && ob.code.equals(ob.compare.code)) {
                code.style("font-color: darkgray");
            }
            this.renderCode(code.getChildNodes(), ob.code);
            if (ob.compare != null && ob.compare.code != null && !ob.code.equals(ob.compare.code)) {
                code.br();
                code = code.span(STYLE_UNCHANGED, null);
                this.renderCode(code.getChildNodes(), ob.compare.code);
            }
            if (actor) {
                ActorDefinition ad = this.context.getContext().fetchResource(ActorDefinition.class, ob.actor);
                Iterator<String> compAd = null;
                if (ob.compare != null && ob.compare.actor != null) {
                    compAd = this.context.getContext().fetchResource(ActorDefinition.class, ob.compare.actor);
                }
                XhtmlNode actorId = tr.td().style("font-size: 11px");
                if (ob.compare != null && ob.actor.equals(ob.compare.actor)) {
                    actorId.style(STYLE_UNCHANGED);
                }
                if (ad != null && ad.hasWebPath()) {
                    actorId.ah(ad.getWebPath(), ob.actor).tx(ad.present());
                } else if (ad != null) {
                    actorId.span(null, ob.actor).tx(ad.present());
                }
                if (ob.compare != null && ob.compare.actor != null && !ob.actor.equals(ob.compare.actor)) {
                    actorId.br();
                    actorId = actorId.span(STYLE_REMOVED, null);
                    if (compAd != null) {
                        if (((Resource)((Object)compAd)).hasWebPath()) {
                            actorId.ah(((Resource)((Object)compAd)).getWebPath(), ob.compare.actor).tx(((CanonicalResource)((Object)compAd)).present());
                        } else {
                            actorId.span(null, ob.compare.actor).tx(((CanonicalResource)((Object)compAd)).present());
                        }
                    }
                }
            }
            if (elementId) {
                XhtmlNode elementIds = tr.td().style("font-size: 11px");
                if (ob.compare != null && ob.elementIds.equals(ob.compare.elementIds)) {
                    elementIds.style(STYLE_UNCHANGED);
                }
                for (String eid : ob.elementIds) {
                    elementIds.sep(", ");
                    ElementDefinition ed = this.profile.getSnapshot().getElementById(eid);
                    if (ed != null) {
                        elementIds.ah("#" + eid).tx(ed.getName());
                        continue;
                    }
                    elementIds.code().tx(eid);
                }
                if (ob.compare != null && !ob.compare.elementIds.isEmpty()) {
                    for (String eid : ob.compare.elementIds) {
                        if (ob.elementIds.contains(eid)) continue;
                        elementIds.sep(", ");
                        elementIds.span(STYLE_REMOVED, null).code().tx(eid);
                    }
                }
            }
            if (usage) {
                if (ob.usage != null) {
                    boolean first = true;
                    XhtmlNode td = tr.td();
                    for (UsageContext u : ob.usage) {
                        if (first) {
                            first = false;
                        } else {
                            td.tx(", ");
                        }
                        new DataRenderer(this.context).render(td, u);
                    }
                } else {
                    tr.td();
                }
            }
            if (doco) {
                if (ob.doco != null) {
                    String d;
                    String string = d = fullDoco ? this.md.processMarkdown("Obligation.documentation", ob.doco) : ob.docoShort;
                    oldD = ob.compare == null ? null : (fullDoco ? this.md.processMarkdown("Binding.description.compare", ob.compare.doco) : ob.compare.docoShort);
                    tr.td().style("font-size: 11px").innerHTML(this.compareHtml(d, oldD));
                } else {
                    tr.td().style("font-size: 11px");
                }
            }
            if (!filter) continue;
            if (ob.filter != null) {
                String d = "<code>" + ob.filter + "</code>" + (fullDoco ? this.md.processMarkdown("Binding.description", ob.filterDoco) : "");
                oldD = ob.compare == null ? null : "<code>" + ob.compare.filter + "</code>" + (fullDoco ? this.md.processMarkdown("Binding.description", ob.compare.filterDoco) : "");
                tr.td().style("font-size: 11px").innerHTML(this.compareHtml(d, oldD));
                continue;
            }
            tr.td().style("font-size: 11px");
        }
    }

    private XhtmlNode compareString(XhtmlNode node, String newS, String oldS) {
        if (oldS == null) {
            return node.tx(newS);
        }
        if (newS.equals(oldS)) {
            return node.style(STYLE_UNCHANGED).tx(newS);
        }
        node.tx(newS);
        node.br();
        return node.span(STYLE_REMOVED, null).tx(oldS);
    }

    private String compareHtml(String newS, String oldS) {
        if (oldS == null) {
            return newS;
        }
        if (newS.equals(oldS)) {
            return "<span style=\"" + STYLE_UNCHANGED + "\">" + newS + "</span>";
        }
        return newS + "<br/><span style=\"" + STYLE_REMOVED + "\">" + oldS + "</span>";
    }

    private void renderCode(XhtmlNodeList children, String codeExpr) {
        if (codeExpr != null) {
            String[] codes;
            boolean first = true;
            for (String code : codes = codeExpr.split("\\+")) {
                if (first) {
                    first = false;
                } else {
                    children.tx(" & ");
                }
                int i = code.indexOf(":");
                if (i > -1) {
                    String c = code.substring(0, i);
                    code = code.substring(i + 1);
                    children.b().tx(c.toUpperCase());
                    children.tx(":");
                }
                CodeResolver.CodeResolution cr = this.cr.resolveCode("http://hl7.org/fhir/tools/CodeSystem/obligation", code);
                code = code.replace("will-", "").replace("can-", "");
                if (cr.getLink() != null) {
                    children.ah(cr.getLink(), cr.getHint()).tx(code);
                    continue;
                }
                children.span(null, cr.getHint()).tx(code);
            }
        } else {
            children.span(null, "No Obligation Code?").tx("??");
        }
    }

    public boolean hasObligations() {
        return !this.obligations.isEmpty();
    }

    private String displayForUsage(Coding c) {
        if (c.hasDisplay()) {
            return c.getDisplay();
        }
        if ("http://terminology.hl7.org/CodeSystem/usage-context-type".equals(c.getSystem())) {
            return c.getCode();
        }
        return c.getCode();
    }

    public static class ObligationDetail {
        private String code;
        private List<String> elementIds = new ArrayList<String>();
        private String actor;
        private String doco;
        private String docoShort;
        private String filter;
        private String filterDoco;
        private List<UsageContext> usage = new ArrayList<UsageContext>();
        private boolean isUnchanged = false;
        private boolean matched = false;
        private boolean removed = false;
        private ValueSet vs;
        private ObligationDetail compare;
        private int count = 1;

        public ObligationDetail(Extension ext) {
            this.code = ext.getExtensionString("code");
            this.actor = ext.getExtensionString("actor");
            if (this.actor == null) {
                this.actor = ext.getExtensionString("actorId");
            }
            this.doco = ext.getExtensionString("documentation");
            this.docoShort = ext.getExtensionString("shortDoco");
            this.filter = ext.getExtensionString("filter");
            this.filterDoco = ext.getExtensionString("filterDocumentation");
            if (this.filterDoco == null) {
                this.filterDoco = ext.getExtensionString("filter-desc");
            }
            for (Extension usage : ext.getExtensionsByUrl("usage")) {
                this.usage.add(usage.getValueUsageContext());
            }
            for (Extension eid : ext.getExtensionsByUrl("elementId")) {
                this.elementIds.add(eid.getValue().primitiveValue());
            }
            this.isUnchanged = ext.hasUserData("derivation.equals");
        }

        private String getKey() {
            return this.code + Integer.toString(this.count);
        }

        private void incrementCount() {
            ++this.count;
        }

        private void setCompare(ObligationDetail match) {
            this.compare = match;
            match.matched = true;
        }

        private boolean alreadyMatched() {
            return this.matched;
        }

        public String getDoco(boolean full) {
            return full ? this.doco : this.docoShort;
        }

        public String getCode() {
            return this.code;
        }

        public boolean unchanged() {
            if (!this.isUnchanged) {
                return false;
            }
            if (this.compare == null) {
                return true;
            }
            this.isUnchanged = true;
            this.isUnchanged = this.isUnchanged && (this.code == null && this.compare.code == null || this.code.equals(this.compare.code));
            this.isUnchanged = this.elementIds.equals(this.compare.elementIds);
            this.isUnchanged = this.isUnchanged && (this.actor == null && this.compare.actor == null || this.actor.equals(this.compare.actor));
            this.isUnchanged = this.isUnchanged && (this.doco == null && this.compare.doco == null || this.doco.equals(this.compare.doco));
            this.isUnchanged = this.isUnchanged && (this.docoShort == null && this.compare.docoShort == null || this.docoShort.equals(this.compare.docoShort));
            this.isUnchanged = this.isUnchanged && (this.filter == null && this.compare.filter == null || this.filter.equals(this.compare.filter));
            this.isUnchanged = this.isUnchanged && (this.filterDoco == null && this.compare.filterDoco == null || this.filterDoco.equals(this.compare.filterDoco));
            this.isUnchanged = this.isUnchanged && (this.usage == null && this.compare.usage == null || this.usage.equals(this.compare.usage));
            return this.isUnchanged;
        }

        public boolean hasFilter() {
            return this.filter != null;
        }

        public boolean hasUsage() {
            return !this.usage.isEmpty();
        }

        public String getFilterDesc() {
            return this.filterDoco;
        }

        public String getFilter() {
            return this.filter;
        }

        public List<UsageContext> getUsage() {
            return this.usage;
        }

        public boolean hasActor() {
            return this.actor != null;
        }

        public boolean hasActor(String id) {
            return id.equals(this.actor);
        }
    }
}

