/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.comparison.VersionComparisonAnnotation;
import org.hl7.fhir.r5.conformance.profile.BindingResolution;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.AdditionalBindingsRenderer;
import org.hl7.fhir.r5.renderers.IMarkdownProcessor;
import org.hl7.fhir.r5.renderers.ObligationsRenderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.utils.PublicationHacker;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class StructureDefinitionRenderer
extends ResourceRenderer {
    private List<String> keyRows = new ArrayList<String>();
    private Map<String, Map<String, ElementDefinition>> sdMapCache = new HashMap<String, Map<String, ElementDefinition>>();
    private IMarkdownProcessor hostMd;
    public static final String CONSTRAINT_CHAR = "C";
    public static final String CONSTRAINT_STYLE = "padding-left: 3px; padding-right: 3px; border: 1px maroon solid; font-weight: bold; color: #301212; background-color: #fdf4f4;";
    public static final int GEN_MODE_SNAP = 1;
    public static final int GEN_MODE_DIFF = 2;
    public static final int GEN_MODE_MS = 3;
    public static final int GEN_MODE_KEY = 4;
    public static final String RIM_MAPPING = "http://hl7.org/v3";
    public static final String v2_MAPPING = "http://hl7.org/v2";
    public static final String LOINC_MAPPING = "http://loinc.org";
    public static final String SNOMED_MAPPING = "http://snomed.info";
    private final boolean ADD_REFERENCE_TO_TABLE = true;
    private boolean useTableForFixedValues = true;
    private String corePath;

    public StructureDefinitionRenderer(RenderingContext context) {
        super(context);
        this.hostMd = new InternalMarkdownProcessor();
        this.corePath = context.getContext().getSpecUrl();
    }

    public StructureDefinitionRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    public Map<String, Map<String, ElementDefinition>> getSdMapCache() {
        return this.sdMapCache;
    }

    public void setSdMapCache(Map<String, Map<String, ElementDefinition>> sdMapCache) {
        this.sdMapCache = sdMapCache;
    }

    public IMarkdownProcessor getHostMd() {
        return this.hostMd;
    }

    public void setHostMd(IMarkdownProcessor hostMd) {
        this.hostMd = hostMd;
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (StructureDefinition)dr);
    }

    public boolean render(XhtmlNode x, StructureDefinition sd) throws FHIRFormatError, DefinitionException, IOException {
        if (this.context.getStructureMode() == RenderingContext.StructureDefinitionRendererMode.DATA_DICT) {
            this.renderDict(sd, sd.getDifferential().getElement(), x.table("dict"), false, 2, "");
        } else {
            x.getChildNodes().add(this.generateTable(this.context.getDefinitionsTarget(), sd, true, this.context.getDestDir(), false, sd.getId(), false, this.context.getLink(RenderingContext.KnownLinkType.SPEC), "", sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL, false, null, false, this.context, ""));
        }
        return true;
    }

    public void describe(XhtmlNode x, StructureDefinition sd) {
        x.tx(this.display(sd));
    }

    public String display(StructureDefinition sd) {
        return sd.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((StructureDefinition)r).present();
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        if (r.has("name")) {
            return r.children("name").get(0).getBase().primitiveValue();
        }
        return "??";
    }

    private ElementInStructure getElementByName(List<ElementDefinition> elements, String contentReference, StructureDefinition source) {
        if (contentReference.contains("#")) {
            String url = contentReference.substring(0, contentReference.indexOf("#"));
            contentReference = contentReference.substring(contentReference.indexOf("#"));
            if (Utilities.noString((String)url)) {
                url = source.getUrl();
            }
            if (!url.equals(source.getUrl())) {
                source = this.context.getWorker().fetchResource(StructureDefinition.class, url, source);
                if (source == null) {
                    throw new FHIRException("Unable to resolve StructureDefinition " + url + " resolving content reference " + contentReference);
                }
                elements = source.getSnapshot().getElement();
            }
        }
        for (ElementDefinition ed : elements) {
            if (("#" + ed.getPath()).equals(contentReference)) {
                return new ElementInStructure(source, ed);
            }
            if (!("#" + ed.getId()).equals(contentReference)) continue;
            return new ElementInStructure(source, ed);
        }
        throw new Error("getElementByName: can't find " + contentReference + " in " + elements.toString() + " from " + source.getUrl());
    }

    public XhtmlNode generateGrid(String defFile, StructureDefinition profile, String imageFolder, boolean inlineGraphics, String profileBaseFileName, String corePath, String imagePath, Set<String> outputTracker) throws IOException, FHIRException {
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, inlineGraphics, true);
        gen.setTranslator(this.getTranslator());
        HierarchicalTableGenerator.TableModel model = gen.initGridTable(corePath, profile.getId());
        List<ElementDefinition> list = profile.getSnapshot().getElement();
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        profiles.add(profile);
        this.genGridElement(defFile == null ? null : defFile + "#", gen, model.getRows(), list.get(0), list, profiles, true, profileBaseFileName, null, corePath, imagePath, true, profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && this.usesMustSupport(list));
        try {
            return gen.generate(model, imagePath, 1, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(e.getMessage(), (Throwable)e);
        }
    }

    public XhtmlNode generateTable(String defFile, StructureDefinition profile, boolean diff, String imageFolder, boolean inlineGraphics, String profileBaseFileName, boolean snapshot, String corePath, String imagePath, boolean logicalModel, boolean allInvariants, Set<String> outputTracker, boolean mustSupport, RenderingContext rc, String anchorPrefix) throws IOException, FHIRException {
        HierarchicalTableGenerator.TableModel model;
        List<ElementDefinition> list;
        assert (diff != snapshot);
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, inlineGraphics, true);
        gen.setTranslator(this.getTranslator());
        if (diff) {
            list = this.supplementMissingDiffElements(profile);
        } else {
            list = new ArrayList<ElementDefinition>();
            list.addAll(profile.getSnapshot().getElement());
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        switch (this.context.getStructureMode()) {
            case BINDINGS: {
                this.scanBindings(columns, list);
                model = this.initCustomTable(gen, corePath, false, true, profile.getId() + (diff ? "d" : "s"), rc.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER, columns);
                break;
            }
            case OBLIGATIONS: {
                this.scanObligations(columns, list);
                model = this.initCustomTable(gen, corePath, false, true, profile.getId() + (diff ? "d" : "s"), rc.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER, columns);
                break;
            }
            case SUMMARY: {
                model = gen.initNormalTable(corePath, false, true, profile.getId() + (diff ? "d" : "s"), rc.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER, rc.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER ? HierarchicalTableGenerator.TableGenerationMode.XHTML : HierarchicalTableGenerator.TableGenerationMode.XML);
                break;
            }
            default: {
                throw new Error("Unknown structure mode");
            }
        }
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        profiles.add(profile);
        this.keyRows.clear();
        this.genElement(defFile == null ? null : defFile + "#", gen, model.getRows(), list.get(0), list, profiles, diff, profileBaseFileName, null, snapshot, corePath, imagePath, true, logicalModel, profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && this.usesMustSupport(list), allInvariants, null, mustSupport, rc, anchorPrefix, profile, columns);
        try {
            return gen.generate(model, imagePath, 0, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(this.context.getWorker().formatMessage("Error_generating_table_for_profile__", profile.getUrl(), e.getMessage()), (Throwable)e);
        }
    }

    private void scanBindings(List<Column> columns, List<ElementDefinition> list) {
        HashSet<String> cols = new HashSet<String>();
        this.scanBindings(cols, list, list.get(0));
        if (cols.contains("required")) {
            columns.add(new Column("required", "Required", "Concepts must come from this value set"));
        }
        if (cols.contains("extensible")) {
            columns.add(new Column("extensible", "Extensible", "Concepts must come from this value set if an appropriate concept is in the value set "));
        }
        if (cols.contains("maximum")) {
            columns.add(new Column("maximum", "Maximum", "A required binding for additional codes, for use when the binding strength is 'extensible' or 'preferred'"));
        }
        if (cols.contains("minimum")) {
            columns.add(new Column("minimum", "Minimum", "The minimum allowable value set - any conformant system SHALL support all these codes"));
        }
        if (cols.contains("candidate")) {
            columns.add(new Column("candidate", "Candidate", "This value set is a candidate to substitute for the overall conformance value set in some situations; usually these are defined in the documentation"));
        }
        if (cols.contains("current")) {
            columns.add(new Column("current", "Current", "New records are required to use this value set, but legacy records may use other codes. The definition of 'new record' is difficult, since systems often create new records based on pre-existing data. Usually 'current' bindings are mandated by an external authority that makes clear rules around this"));
        }
        if (cols.contains("preferred")) {
            columns.add(new Column("preferred", "Preferred", "This is the value set that is preferred in a given context (documentation should explain why)"));
        }
        if (cols.contains("ui")) {
            columns.add(new Column("ui", "UI", "This value set is provided for user look up in a given context. Typically, these valuesets only include a subset of codes relevant for input in a context"));
        }
        if (cols.contains("starter")) {
            columns.add(new Column("starter", "Starter", "This value set is a good set of codes to start with when designing your system"));
        }
        if (cols.contains("component")) {
            columns.add(new Column("component", "Component", "This value set is a component of the base value set. Usually this is called out so that documentation can be written about a portion of the value set"));
        }
        if (cols.contains("example")) {
            columns.add(new Column("example", "Example", "Instances are not expected or even encouraged to draw from the specified value set. The value set merely provides examples of the types of concepts intended to be included."));
        }
    }

    public void scanBindings(Set<String> cols, List<ElementDefinition> list, ElementDefinition ed) {
        if (ed.hasBinding()) {
            if (ed.getBinding().hasValueSet() && ed.getBinding().hasStrength()) {
                switch (ed.getBinding().getStrength()) {
                    case EXAMPLE: {
                        cols.add("example");
                        break;
                    }
                    case EXTENSIBLE: {
                        cols.add("extensible");
                        break;
                    }
                    case PREFERRED: {
                        cols.add("preferred");
                        break;
                    }
                    case REQUIRED: {
                        cols.add("required");
                        break;
                    }
                }
            }
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : ed.getBinding().getAdditional()) {
                cols.add(ab.getPurpose().toCode());
            }
            for (Extension ext : ed.getBinding().getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/additional-binding")) {
                cols.add(ext.getExtensionString("purpose"));
            }
        }
        List<ElementDefinition> children = this.getChildren(list, ed);
        for (ElementDefinition element : children) {
            this.scanBindings(cols, list, element);
        }
    }

    private void scanObligations(List<Column> columns, List<ElementDefinition> list) {
        HashSet<String> cols = new HashSet<String>();
        this.scanObligations(cols, list, list.get(0));
        if (cols.contains("$all")) {
            columns.add(new Column("$all", "All Actors", "Obligations that apply to all actors"));
        }
        for (String col : cols) {
            if ("$all".equals(col)) continue;
            ActorDefinition actor = this.context.getWorker().fetchResource(ActorDefinition.class, col);
            if (actor == null) {
                columns.add(new Column(col, this.tail(col), "Obligations that apply to the undefined actor " + col, col));
                continue;
            }
            columns.add(new Column(col, actor.getName(), "Obligations that apply to the actor " + actor.present(), actor.getWebPath()));
        }
    }

    private void scanObligations(Set<String> cols, List<ElementDefinition> list, ElementDefinition ed) {
        for (Extension ob : ed.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation")) {
            if (ob.hasExtension("actor", "actorId")) {
                for (Extension a : ob.getExtensionsByUrl("actor", "actorId")) {
                    cols.add(a.getValueCanonicalType().primitiveValue());
                }
                continue;
            }
            cols.add("$all");
        }
        List<ElementDefinition> children = this.getChildren(list, ed);
        for (ElementDefinition element : children) {
            this.scanObligations(cols, list, element);
        }
    }

    public HierarchicalTableGenerator.TableModel initCustomTable(HierarchicalTableGenerator gen, String prefix, boolean isLogical, boolean alternating, String id, boolean isActive, List<Column> columns) throws IOException {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, isActive);
        model.setAlternating(alternating);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{prefix, "help16.png"}));
        }
        model.setDocoRef(Utilities.pathURL((String[])new String[]{"https://build.fhir.org/ig/FHIR/ig-guidance", "readingIgs.html#table-views"}));
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.translate("sd.head", "Name"), this.translate("sd.hint", "The logical name of the element"), null, 0));
        for (Column col : columns) {
            List list2 = model.getTitles();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.translate("sd.head", col.title), this.translate("sd.hint", col.hint), null, 0));
        }
        return model;
    }

    private HierarchicalTableGenerator.Row genElement(String defPath, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ElementDefinition element, List<ElementDefinition> all, List<StructureDefinition> profiles, boolean showMissing, String profileBaseFileName, Boolean extensions, boolean snapshot, String corePath, String imagePath, boolean root, boolean logicalModel, boolean isConstraintMode, boolean allInvariants, HierarchicalTableGenerator.Row slicingRow, boolean mustSupport, RenderingContext rc, String anchorPrefix, Resource srcSD, List<Column> columns) throws IOException, FHIRException {
        HierarchicalTableGenerator.Row originalRow = slicingRow;
        StructureDefinition profile = profiles == null ? null : profiles.get(profiles.size() - 1);
        HierarchicalTableGenerator.Row typesRow = null;
        List<ElementDefinition> children = this.getChildren(all, element);
        if (!this.onlyInformationIsMapping(all, element)) {
            HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
            row.setAnchor(element.getPath());
            row.setColor(this.context.getProfileUtilities().getRowColor(element, isConstraintMode));
            if (element.hasSlicing()) {
                row.setLineColor(1);
            } else if (element.hasSliceName()) {
                row.setLineColor(2);
            } else {
                row.setLineColor(0);
            }
            boolean hasDef = element != null;
            boolean ext = false;
            if (this.tail(element.getPath()).equals("extension")) {
                if (element.hasType() && element.getType().get(0).hasProfile() && this.extensionIsComplex((String)element.getType().get(0).getProfile().get(0).getValue())) {
                    row.setIcon("icon_extension_complex.png", "Complex Extension");
                } else {
                    row.setIcon("icon_extension_simple.png", "Simple Extension");
                }
                ext = true;
            } else if (this.tail(element.getPath()).equals("modifierExtension")) {
                if (element.hasType() && element.getType().get(0).hasProfile() && this.extensionIsComplex((String)element.getType().get(0).getProfile().get(0).getValue())) {
                    row.setIcon("icon_modifier_extension_complex.png", "Complex Extension");
                } else {
                    row.setIcon("icon_modifier_extension_simple.png", "Simple Extension");
                }
            } else if (!hasDef || element.getType().size() == 0) {
                if (root && profile != null && this.context.getWorker().getResourceNames().contains(profile.getType())) {
                    row.setIcon("icon_resource.png", "Resource");
                } else if (hasDef && element.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-property-key")) {
                    row.setIcon("icon-object-box.png", "Object");
                    this.keyRows.add(element.getId() + "." + ToolingExtensions.readStringExtension(element, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key"));
                } else {
                    row.setIcon("icon_element.gif", "Element");
                }
            } else if (hasDef && element.getType().size() > 1) {
                if (this.allAreReference(element.getType())) {
                    row.setIcon("icon_reference.png", "Reference to another Resource");
                } else if (element.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice")) {
                    row.setIcon("icon_choice.gif", "Choice of Types");
                } else {
                    row.setIcon("icon_choice.gif", "Choice of Types");
                    typesRow = row;
                }
            } else if (hasDef && element.getType().get(0).getWorkingCode() != null && element.getType().get(0).getWorkingCode().startsWith("@")) {
                row.setIcon("icon_reuse.png", "Reference to another Element");
            } else if (hasDef && this.isPrimitive(element.getType().get(0).getWorkingCode())) {
                if (this.keyRows.contains(element.getId())) {
                    row.setIcon("icon-key.png", "JSON Key Value");
                } else {
                    row.setIcon("icon_primitive.png", "Primitive Data Type");
                }
            } else if (hasDef && element.getType().get(0).hasTarget()) {
                row.setIcon("icon_reference.png", "Reference to another Resource");
            } else if (hasDef && this.isDataType(element.getType().get(0).getWorkingCode())) {
                row.setIcon("icon_datatype.gif", "Data Type");
            } else if (hasDef && element.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-property-key")) {
                row.setIcon("icon-object-box.png", "Object");
                this.keyRows.add(element.getId() + "." + ToolingExtensions.readStringExtension(element, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key"));
            } else if (hasDef && Utilities.existsInList((String)element.getType().get(0).getWorkingCode(), (String[])new String[]{"Base", "Element", "BackboneElement"})) {
                row.setIcon("icon_element.gif", "Element");
            } else {
                row.setIcon("icon_resource.png", "Resource");
            }
            if (element.hasUserData("render.opaque")) {
                row.setOpacity("0.5");
            }
            UnusedTracker used = new UnusedTracker();
            String ref = defPath == null ? null : defPath + anchorPrefix + element.getId();
            Object sName = this.tail(element.getPath());
            if (element.hasSliceName()) {
                sName = (String)sName + ":" + element.getSliceName();
            }
            used.used = true;
            if (logicalModel && element.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) {
                sName = "@" + (String)sName;
            }
            HierarchicalTableGenerator.Cell nc = this.genElementNameCell(gen, element, profileBaseFileName, snapshot, corePath, imagePath, root, logicalModel, allInvariants, profile, typesRow, row, hasDef, ext, used, ref, (String)sName, all);
            switch (this.context.getStructureMode()) {
                case BINDINGS: {
                    this.genElementBindings(gen, element, columns, row, profile, corePath);
                    break;
                }
                case OBLIGATIONS: {
                    this.genElementObligations(gen, element, columns, row, corePath, profile);
                    break;
                }
                case SUMMARY: {
                    this.genElementCells(gen, element, profileBaseFileName, snapshot, corePath, imagePath, root, logicalModel, allInvariants, profile, typesRow, row, hasDef, ext, used, ref, (String)sName, nc, mustSupport, true, rc);
                }
            }
            if (element.hasSlicing()) {
                if (this.standardExtensionSlicing(element)) {
                    used.used = true;
                    showMissing = false;
                } else {
                    row.setIcon("icon_slice.png", "Slice Definition");
                    slicingRow = row;
                    for (Object cell : row.getCells()) {
                        for (HierarchicalTableGenerator.Piece p : cell.getPieces()) {
                            p.addStyle("font-style: italic");
                        }
                    }
                }
            } else if (element.hasSliceName()) {
                row.setIcon("icon_slice_item.png", "Slice Item");
            }
            if (used.used || showMissing) {
                rows.add(row);
            }
            if (!used.used && !element.hasSlicing()) {
                for (Object cell : row.getCells()) {
                    for (HierarchicalTableGenerator.Piece p : cell.getPieces()) {
                        p.setStyle("text-decoration:line-through");
                        p.setReference(null);
                    }
                }
            } else {
                HierarchicalTableGenerator.Row hrow;
                if (slicingRow != originalRow && !children.isEmpty()) {
                    hrow = new HierarchicalTableGenerator.Row(gen);
                    hrow.setAnchor(element.getPath());
                    hrow.setColor(this.context.getProfileUtilities().getRowColor(element, isConstraintMode));
                    hrow.setLineColor(1);
                    hrow.setIcon("icon_element.gif", "Element");
                    List list = hrow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, (String)sName + ":All Slices", "", null));
                    switch (this.context.getStructureMode()) {
                        case BINDINGS: 
                        case OBLIGATIONS: {
                            for (Column col : columns) {
                                hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                            }
                            break;
                        }
                        case SUMMARY: {
                            hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                            hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                            hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                            List list2 = hrow.getCells();
                            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator2);
                            list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "Content/Rules for all slices", "", null));
                        }
                    }
                    row.getSubRows().add(hrow);
                    row = hrow;
                }
                if (typesRow != null && !children.isEmpty()) {
                    hrow = new HierarchicalTableGenerator.Row(gen);
                    hrow.setAnchor(element.getPath());
                    hrow.setColor(this.context.getProfileUtilities().getRowColor(element, isConstraintMode));
                    hrow.setLineColor(1);
                    hrow.setIcon("icon_element.gif", "Element");
                    List list = hrow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, (String)sName + ":All Types", "", null));
                    switch (this.context.getStructureMode()) {
                        case BINDINGS: 
                        case OBLIGATIONS: {
                            for (Column col : columns) {
                                hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                            }
                            break;
                        }
                        case SUMMARY: {
                            hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                            hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                            hrow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                            List list3 = hrow.getCells();
                            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator3);
                            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "Content/Rules for all Types", "", null));
                        }
                    }
                    row.getSubRows().add(hrow);
                    row = hrow;
                }
                HierarchicalTableGenerator.Row currRow = row;
                List<ProfileUtilities.ElementChoiceGroup> groups = this.readChoices(element, children);
                boolean isExtension = Utilities.existsInList((String)this.tail(element.getPath()), (String[])new String[]{"extension", "modifierExtension"});
                if (!element.prohibited()) {
                    for (ElementDefinition child : children) {
                        if (!child.hasSliceName()) {
                            currRow = row;
                        }
                        HierarchicalTableGenerator.Row childRow = this.chooseChildRowByGroup(gen, currRow, groups, child, element, isConstraintMode);
                        if (!logicalModel && child.getPath().endsWith(".id") && (!child.getPath().endsWith(".id") || profile == null || profile.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT)) continue;
                        currRow = this.genElement(defPath, gen, childRow.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, isExtension, snapshot, corePath, imagePath, false, logicalModel, isConstraintMode, allInvariants, currRow, mustSupport, rc, anchorPrefix, srcSD, columns);
                    }
                }
            }
            if (typesRow != null && !element.prohibited() && this.context.getStructureMode() == RenderingContext.StructureDefinitionRendererMode.SUMMARY) {
                this.makeChoiceRows(typesRow.getSubRows(), element, gen, corePath, profileBaseFileName, mustSupport, srcSD);
            }
        }
        return slicingRow;
    }

    private void genElementObligations(HierarchicalTableGenerator gen, ElementDefinition element, List<Column> columns, HierarchicalTableGenerator.Row row, String corePath, StructureDefinition profile) throws IOException {
        for (Column col : columns) {
            HierarchicalTableGenerator.Cell gc = new HierarchicalTableGenerator.Cell(gen);
            row.getCells().add(gc);
            ObligationsRenderer obr = new ObligationsRenderer(corePath, profile, element.getPath(), this.context, null, this);
            obr.seeObligations(element, col.id);
            obr.renderList(gen, gc);
        }
    }

    private String displayForUsage(Coding c) {
        if (c.hasDisplay()) {
            return c.getDisplay();
        }
        if ("http://terminology.hl7.org/CodeSystem/usage-context-type".equals(c.getSystem())) {
            return c.getCode();
        }
        return c.getCode();
    }

    private void genElementBindings(HierarchicalTableGenerator gen, ElementDefinition element, List<Column> columns, HierarchicalTableGenerator.Row row, StructureDefinition profile, String corepath) {
        for (Column col : columns) {
            HierarchicalTableGenerator.Cell gc = new HierarchicalTableGenerator.Cell(gen);
            row.getCells().add(gc);
            List<ElementDefinition.ElementDefinitionBindingAdditionalComponent> bindings = this.collectBindings(element, col.id);
            if (bindings.size() <= 0) continue;
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null);
            gc.addPiece(p);
            new AdditionalBindingsRenderer(this.context.getPkp(), corepath, profile, element.getPath(), this.context, null, this).render(p.getChildren(), bindings);
        }
    }

    private List<ElementDefinition.ElementDefinitionBindingAdditionalComponent> collectBindings(ElementDefinition element, String type) {
        ArrayList<ElementDefinition.ElementDefinitionBindingAdditionalComponent> res = new ArrayList<ElementDefinition.ElementDefinitionBindingAdditionalComponent>();
        if (element.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingAdditionalComponent ab;
            ElementDefinition.ElementDefinitionBindingComponent b = element.getBinding();
            if (b.hasStrength() && type.equals(b.getStrength().toCode())) {
                ab = new ElementDefinition.ElementDefinitionBindingAdditionalComponent();
                res.add(ab.setAny(false).setDocumentation(b.getDescription()).setValueSet(b.getValueSet()));
            }
            if ("maximum".equals(type) && b.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                ab = new ElementDefinition.ElementDefinitionBindingAdditionalComponent();
                res.add(ab.setAny(false).setValueSet(ToolingExtensions.readStringExtension(b, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")));
            }
            if ("minimum".equals(type) && b.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet")) {
                ab = new ElementDefinition.ElementDefinitionBindingAdditionalComponent();
                res.add(ab.setAny(false).setValueSet(ToolingExtensions.readStringExtension(b, "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet")));
            }
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent t : b.getAdditional()) {
                if (!type.equals(t.getPurpose().toCode())) continue;
                res.add(t);
            }
            for (Extension ext : b.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/additional-binding")) {
                if (!type.equals(ext.getExtensionString("purpose"))) continue;
                ElementDefinition.ElementDefinitionBindingAdditionalComponent ab2 = new ElementDefinition.ElementDefinitionBindingAdditionalComponent();
                if (ext.hasExtension("any")) {
                    ab2.setAny(ToolingExtensions.readBooleanExtension(ext, "any"));
                }
                if (ext.hasExtension("purpose")) {
                    ab2.setPurpose(ElementDefinition.AdditionalBindingPurposeVS.fromCode(ToolingExtensions.readStringExtension(ext, "purpose")));
                }
                if (ext.hasExtension("documentation")) {
                    ab2.setDocumentation(ToolingExtensions.readStringExtension(ext, "documentation"));
                }
                if (ext.hasExtension("shortDoco")) {
                    ab2.setShortDoco(ToolingExtensions.readStringExtension(ext, "shortDoco"));
                }
                if (ToolingExtensions.hasExtension(ext, "usage")) {
                    ab2.addUsage(ext.getExtensionByUrl("usage").getValueUsageContext());
                }
                if (ext.hasExtension("valueSet")) {
                    ab2.setValueSet(ToolingExtensions.readStringExtension(ext, "valueSet"));
                }
                res.add(ab2);
            }
        }
        return res;
    }

    public HierarchicalTableGenerator.Cell genElementNameCell(HierarchicalTableGenerator gen, ElementDefinition element, String profileBaseFileName, boolean snapshot, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, StructureDefinition profile, HierarchicalTableGenerator.Row typesRow, HierarchicalTableGenerator.Row row, boolean hasDef, boolean ext, UnusedTracker used, String ref, String sName, List<ElementDefinition> elements) throws IOException {
        String hint = "";
        hint = this.checkAdd(hint, (String)(element.hasSliceName() ? this.translate("sd.table", "Slice") + " " + element.getSliceName() : ""));
        if (hasDef && element.hasDefinition()) {
            hint = this.checkAdd(hint, hasDef && element.hasSliceName() ? ": " : "");
            hint = this.checkAdd(hint, !hasDef ? null : this.gt(element.getDefinitionElement()));
        }
        if (element.hasSlicing() && this.slicesExist(elements, element)) {
            sName = "Slices for " + (String)sName;
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell left = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, ref, (String)sName, hint, null);
        row.getCells().add(left);
        return left;
    }

    public List<HierarchicalTableGenerator.Cell> genElementCells(HierarchicalTableGenerator gen, ElementDefinition element, String profileBaseFileName, boolean snapshot, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, StructureDefinition profile, HierarchicalTableGenerator.Row typesRow, HierarchicalTableGenerator.Row row, boolean hasDef, boolean ext, UnusedTracker used, String ref, String sName, HierarchicalTableGenerator.Cell nameCell, boolean mustSupport, boolean allowSubRows, RenderingContext rc) throws IOException {
        ArrayList<HierarchicalTableGenerator.Cell> res = new ArrayList<HierarchicalTableGenerator.Cell>();
        HierarchicalTableGenerator.Cell gc = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(gc);
        res.add(gc);
        if (element != null && element.getIsModifier()) {
            this.checkForNoChange(element.getIsModifierElement(), gc.addStyledText(this.translate("sd.table", "This element is a modifier element"), "?!", null, null, null, false));
        }
        if (element != null) {
            if (element.getMustSupport() && element.hasExtension("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation")) {
                this.checkForNoChange(element.getMustSupportElement(), gc.addStyledText(this.translate("sd.table", "This element has obligations and must be supported"), "SO", "white", "red", null, false));
            } else if (element.getMustSupport()) {
                this.checkForNoChange(element.getMustSupportElement(), gc.addStyledText(this.translate("sd.table", "This element must be supported"), "S", "white", "red", null, false));
            } else if (element != null && element.hasExtension("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation")) {
                this.checkForNoChange(element.getMustSupportElement(), gc.addStyledText(this.translate("sd.table", "This element has obligations"), "O", "white", "red", null, false));
            }
        }
        if (element != null && element.getIsSummary()) {
            this.checkForNoChange(element.getIsSummaryElement(), gc.addStyledText(this.translate("sd.table", "This element is included in summaries"), "\u03a3", null, null, null, false));
        }
        if (element != null && element.getMustHaveValue()) {
            this.checkForNoChange(element.getMustHaveValueElement(), gc.addStyledText(this.translate("sd.table", "This primitive element must have a value"), "V", "maroon", null, null, true));
        }
        if (element != null && (this.hasNonBaseConstraints(element.getConstraint()) || this.hasNonBaseConditions(element.getCondition()))) {
            HierarchicalTableGenerator.Piece p = gc.addText(CONSTRAINT_CHAR);
            p.setHint(this.translate("sd.table", "This element has or is affected by constraints (" + this.listConstraintsAndConditions(element) + ")"));
            p.addStyle(CONSTRAINT_STYLE);
            p.setReference(Utilities.pathURL((String[])new String[]{VersionUtilities.getSpecUrl((String)this.context.getWorker().getVersion()), "conformance-rules.html#constraints"}));
        }
        if (element != null && element.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status")) {
            StandardsStatus ss = StandardsStatus.fromCode((String)element.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"));
            gc.addStyledText("Standards Status = " + ss.toDisplay(), ss.getAbbrev(), "black", ss.getColor(), this.context.getWorker().getSpecUrl() + "versions.html#std-process", true);
        }
        ProfileUtilities.ExtensionContext extDefn = null;
        if (ext) {
            if (element != null) {
                if (element.getType().size() == 1 && element.getType().get(0).hasProfile()) {
                    String eurl = (String)element.getType().get(0).getProfile().get(0).getValue();
                    extDefn = this.locateExtension(StructureDefinition.class, eurl);
                    if (extDefn == null) {
                        res.add(this.genCardinality(gen, element, row, hasDef, used, null));
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        res.add(this.addCell(row, new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "?gen-e1? " + element.getType().get(0).getProfile(), null, null)));
                        res.add(this.generateDescription(gen, row, element, (ElementDefinition)element.getUserData("derived.pointer"), used.used, profile == null ? "" : profile.getUrl(), eurl, profile, corePath, imagePath, root, logicalModel, allInvariants, snapshot, mustSupport, allowSubRows, rc));
                    } else {
                        String name = element.hasSliceName() ? element.getSliceName() : this.urltail(eurl);
                        ((HierarchicalTableGenerator.Piece)nameCell.getPieces().get(0)).setText(name);
                        ((HierarchicalTableGenerator.Piece)nameCell.getPieces().get(0)).setHint(this.translate("sd.table", "Extension URL") + " = " + extDefn.getUrl());
                        res.add(this.genCardinality(gen, element, row, hasDef, used, extDefn.getElement()));
                        ElementDefinition valueDefn = extDefn.getExtensionValueDefinition();
                        if (valueDefn != null && !"0".equals(valueDefn.getMax())) {
                            res.add(this.genTypes(gen, row, valueDefn, profileBaseFileName, profile, corePath, imagePath, root, mustSupport));
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            res.add(this.addCell(row, new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "(" + this.translate("sd.table", "Complex") + ")", null, null)));
                        }
                        res.add(this.generateDescription(gen, row, element, extDefn.getElement(), used.used, null, extDefn.getUrl(), profile, corePath, imagePath, root, logicalModel, allInvariants, valueDefn, snapshot, mustSupport, allowSubRows, rc));
                    }
                } else {
                    res.add(this.genCardinality(gen, element, row, hasDef, used, null));
                    if ("0".equals(element.getMax())) {
                        res.add(this.addCell(row, new HierarchicalTableGenerator.Cell(gen)));
                    } else {
                        res.add(this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath, root, mustSupport));
                    }
                    res.add(this.generateDescription(gen, row, element, (ElementDefinition)element.getUserData("derived.pointer"), used.used, null, null, profile, corePath, imagePath, root, logicalModel, allInvariants, snapshot, mustSupport, allowSubRows, rc));
                }
            }
        } else if (element != null) {
            res.add(this.genCardinality(gen, element, row, hasDef, used, null));
            if (hasDef && !"0".equals(element.getMax()) && typesRow == null) {
                res.add(this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath, root, mustSupport));
            } else {
                res.add(this.addCell(row, new HierarchicalTableGenerator.Cell(gen)));
            }
            res.add(this.generateDescription(gen, row, element, (ElementDefinition)element.getUserData("derived.pointer"), used.used, null, null, profile, corePath, imagePath, root, logicalModel, allInvariants, snapshot, mustSupport, allowSubRows, rc));
        }
        return res;
    }

    private HierarchicalTableGenerator.Cell genCardinality(HierarchicalTableGenerator gen, ElementDefinition definition, HierarchicalTableGenerator.Row row, boolean hasDef, UnusedTracker tracker, ElementDefinition fallback) {
        ElementDefinition base;
        StringType max;
        IntegerType min;
        IntegerType integerType = !hasDef ? new IntegerType() : (min = definition.hasMinElement() ? definition.getMinElement() : new IntegerType());
        StringType stringType = !hasDef ? new StringType() : (max = definition.hasMaxElement() ? definition.getMaxElement() : new StringType());
        if (min.isEmpty() && definition.getUserData("derived.pointer") != null && (base = (ElementDefinition)definition.getUserData("derived.pointer")).hasMinElement()) {
            min = base.getMinElement().copy();
            min.setUserData("derivation.equals", true);
        }
        if (max.isEmpty() && definition.getUserData("derived.pointer") != null && (base = (ElementDefinition)definition.getUserData("derived.pointer")).hasMaxElement()) {
            max = base.getMaxElement().copy();
            max.setUserData("derivation.equals", true);
        }
        if (min.isEmpty() && fallback != null) {
            min = fallback.getMinElement();
        }
        if (max.isEmpty() && fallback != null) {
            max = fallback.getMaxElement();
        }
        if (!max.isEmpty()) {
            tracker.used = !((String)max.getValue()).equals("0");
        }
        String hint = null;
        if (max.hasValue() && min.hasValue() && "*".equals(max.getValue()) && 0 == (Integer)min.getValue() && definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior")) {
            String code = ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior");
            hint = "present".equals(code) ? "This element is present as a JSON Array even when there are no items in the instance" : "This element may be present as a JSON Array even when there are no items in the instance";
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null);
        row.getCells().add(cell);
        if (!min.isEmpty() || !max.isEmpty()) {
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            cell.addPiece(this.checkForNoChange(min, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, !min.hasValue() ? "" : Integer.toString((Integer)min.getValue()), hint)));
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            cell.addPiece(this.checkForNoChange(min, max, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "..", hint)));
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            cell.addPiece(this.checkForNoChange(max, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, !max.hasValue() ? "" : (String)max.getValue(), hint)));
        }
        return cell;
    }

    public List<ElementDefinition> supplementMissingDiffElements(StructureDefinition profile) {
        ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
        list.addAll(profile.getDifferential().getElement());
        if (list.isEmpty()) {
            ElementDefinition root = new ElementDefinition().setPath(profile.getTypeName());
            root.setId(profile.getTypeName());
            list.add(root);
        } else if (((ElementDefinition)list.get(0)).getPath().contains(".")) {
            ElementDefinition root = new ElementDefinition().setPath(profile.getTypeName());
            root.setId(profile.getTypeName());
            list.add(0, root);
        }
        this.insertMissingSparseElements(list);
        return list;
    }

    private boolean usesMustSupport(List<ElementDefinition> list) {
        for (ElementDefinition ed : list) {
            if (!ed.hasMustSupport() || !ed.getMustSupport()) continue;
            return true;
        }
        return false;
    }

    private HierarchicalTableGenerator.Row chooseChildRowByGroup(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, List<ProfileUtilities.ElementChoiceGroup> groups, ElementDefinition element, ElementDefinition parent, boolean isConstraintMode) {
        String name = this.tail(element.getPath());
        for (ProfileUtilities.ElementChoiceGroup grp : groups) {
            if (!grp.getElements().contains(name)) continue;
            if (grp.getRow() == null) {
                grp.setRow(this.makeChoiceElementRow(gen, row, grp, parent, isConstraintMode));
            }
            return grp.getRow();
        }
        return row;
    }

    private HierarchicalTableGenerator.Row makeChoiceElementRow(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row prow, ProfileUtilities.ElementChoiceGroup grp, ElementDefinition parent, boolean isConstraintMode) {
        if (this.context.getStructureMode() != RenderingContext.StructureDefinitionRendererMode.SUMMARY) {
            return prow;
        }
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        row.setAnchor(parent.getPath() + "-" + grp.getName());
        row.setColor(this.context.getProfileUtilities().getRowColor(parent, isConstraintMode));
        row.setLineColor(1);
        row.setIcon("icon_choice.gif", "Choice of Types");
        List list = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "(Choice of one)", "", null));
        row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        List list2 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, (grp.isMandatory() ? "1" : "0") + "..1", "", null));
        row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        prow.getSubRows().add(row);
        return row;
    }

    private void insertMissingSparseElements(List<ElementDefinition> list) {
        for (int i = 1; i < list.size(); ++i) {
            int firstDiff;
            String[] pathCurrent = list.get(i).getPath().split("\\.");
            String[] pathLast = list.get(i - 1).getPath().split("\\.");
            for (firstDiff = 0; firstDiff < pathCurrent.length && firstDiff < pathLast.length && pathCurrent[firstDiff].equals(pathLast[firstDiff]); ++firstDiff) {
            }
            if (this.isSibling(pathCurrent, pathLast, firstDiff) || this.isChild(pathCurrent, pathLast, firstDiff)) continue;
            ElementDefinition parent = this.findParent(list, i, list.get(i).getPath());
            int parentDepth = Utilities.charCount((String)parent.getPath(), (char)'.') + 1;
            int childDepth = Utilities.charCount((String)list.get(i).getPath(), (char)'.') + 1;
            if (childDepth <= parentDepth + 1) continue;
            String basePath = parent.getPath();
            String baseId = parent.getId();
            for (int index = parentDepth; index >= firstDiff; --index) {
                String mtail = this.makeTail(pathCurrent, parentDepth, index);
                ElementDefinition root = new ElementDefinition().setPath(basePath + "." + mtail);
                root.setId(baseId + "." + mtail);
                list.add(i, root);
            }
        }
    }

    private String urltail(String path) {
        if (path.contains("#")) {
            return path.substring(path.lastIndexOf(35) + 1);
        }
        if (path.contains("/")) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path;
    }

    private boolean standardExtensionSlicing(ElementDefinition element) {
        String t = this.tail(element.getPath());
        return (t.equals("extension") || t.equals("modifierExtension")) && element.getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED && element.getSlicing().getDiscriminator().size() == 1 && element.getSlicing().getDiscriminator().get(0).getPath().equals("url") && element.getSlicing().getDiscriminator().get(0).getType().equals((Object)ElementDefinition.DiscriminatorType.VALUE);
    }

    public HierarchicalTableGenerator.Cell generateDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, boolean snapshot, boolean mustSupportOnly, boolean allowSubRows, RenderingContext rc) throws IOException, FHIRException {
        return this.generateDescription(gen, row, definition, fallback, used, baseURL, url, profile, corePath, imagePath, root, logicalModel, allInvariants, null, snapshot, mustSupportOnly, allowSubRows, rc);
    }

    /*
     * WARNING - void declaration
     */
    public HierarchicalTableGenerator.Cell generateDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, boolean logicalModel, boolean allInvariants, ElementDefinition valueDefn, boolean snapshot, boolean mustSupportOnly, boolean allowSubRows, RenderingContext rc) throws IOException, FHIRException {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(c);
        if (used) {
            if (logicalModel && ToolingExtensions.hasExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                if (root) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Namespace") + ": ", null).addStyle("font-weight:bold"));
                    List list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                } else if (!root && ToolingExtensions.hasExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace") && !ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").equals(ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"))) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Namespace") + ": ", null).addStyle("font-weight:bold"));
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                }
            }
            if (root && profile != null && profile.getAbstract()) {
                if (!c.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                }
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "This is an abstract " + (profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT ? "profile" : "type") + ". ", null));
                ArrayList<StructureDefinition> children = new ArrayList<StructureDefinition>();
                for (StructureDefinition structureDefinition : this.context.getWorker().fetchResourcesByType(StructureDefinition.class)) {
                    if (!structureDefinition.hasBaseDefinition() || !structureDefinition.getBaseDefinition().equals(profile.getUrl())) continue;
                    children.add(structureDefinition);
                }
                if (!children.isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, "Child " + (profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT ? "profiles" : "types") + ": ", null));
                    boolean first = true;
                    for (StructureDefinition sd : children) {
                        if (first) {
                            first = false;
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator5);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, ", ", null));
                        }
                        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator6);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, sd.getWebPath(), sd.getTypeName(), null));
                    }
                }
            }
            if (definition.getPath().endsWith("url") && definition.hasFixed()) {
                List list = c.getPieces();
                DataType dataType = definition.getFixed();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "\"" + this.buildJson(definition.getFixed()) + "\"", null).addStyle("color: darkgreen")));
            } else {
                String jn;
                String df;
                if (definition != null && definition.hasShort()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    StringType stringType = definition.getShortElement();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(stringType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.gt(definition.getShortElement()), null)));
                } else if (fallback != null && fallback.hasShort()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.gt(fallback.getShortElement()), null).addStyle("opacity: 0.5"));
                }
                if (url != null) {
                    void var22_28;
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    String fullUrl = url.startsWith("#") ? baseURL + url : url;
                    StructureDefinition ed = this.context.getWorker().fetchResource(StructureDefinition.class, url, profile);
                    Object var22_26 = null;
                    String ref2 = null;
                    String fixedUrl = null;
                    if (ed != null) {
                        String p = ed.getWebPath();
                        if (p != null) {
                            String string;
                            String string2 = string = p.startsWith("http:") || this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER ? p : Utilities.pathURL((String[])new String[]{corePath, p});
                        }
                        if ((fixedUrl = this.getFixedUrl(ed)) != null) {
                            if (fixedUrl.equals(url)) {
                                fixedUrl = null;
                            } else {
                                String p2;
                                StructureDefinition ed2 = this.context.getWorker().fetchResource(StructureDefinition.class, fixedUrl);
                                if (ed2 != null && (p2 = ed2.getWebPath()) != null) {
                                    String string = ref2 = p2.startsWith("http:") || this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER ? p2 : Utilities.pathURL((String[])new String[]{corePath, p2});
                                }
                            }
                        }
                    }
                    if (fixedUrl == null) {
                        if (!Utilities.noString((String)fullUrl)) {
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "URL") + ": ", null).addStyle("font-weight:bold"));
                            List list4 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator7);
                            list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, (String)var22_28, fullUrl, null));
                        }
                    } else {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "URL") + ": ", null).addStyle("font-weight:bold"));
                        List list5 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator8);
                        list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, ref2, fixedUrl, null));
                        List list6 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator9);
                        list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, this.translate("sd.table", " profiled by ") + " ", null).addStyle("font-weight:bold"));
                        List list7 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator10);
                        list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, (String)var22_28, fullUrl, null));
                    }
                }
                if (definition.hasSlicing()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Slice") + ": ", null).addStyle("font-weight:bold"));
                    List list8 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, this.describeSlice(definition.getSlicing()), null));
                }
                if (!definition.getPath().contains(".") && ToolingExtensions.hasExtension(profile, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Binding") + ": ", null).addStyle("font-weight:bold"));
                    List list9 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator12);
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, "This type can be bound to a value set using the ", null));
                    List list10 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator13);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style"), null));
                    List list11 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator14);
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, " binding style", null));
                }
                if (definition.hasValueAlternatives()) {
                    this.addCanonicalList(gen, c, definition.getValueAlternatives(), "The primitive value may be replaced by the extension", true);
                }
                if (definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "When this element is read ", null));
                    HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator15);
                    HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "code");
                    piece.addHtml(new XhtmlNode(NodeType.Text).setContent(ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix")));
                    c.getPieces().add(piece);
                    List list12 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator16);
                    list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, " is prefixed to the value before validation", null));
                }
                if (definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-extension-style")) {
                    String es;
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    if ("named-elements".equals(es = definition.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-extension-style"))) {
                        if (rc.hasLink(RenderingContext.KnownLinkType.JSON_NAMES)) {
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, rc.getLink(RenderingContext.KnownLinkType.JSON_NAMES), "This element can be extended by named JSON elements", null));
                        } else {
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "http://build.fhir.org/ig/FHIR/fhir-tools-ig/format-extensions.html#extension-related-extensions", "This element can be extended by named JSON elements", null));
                        }
                    }
                }
                if (definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format") && (df = ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format")) != null) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Date Format: " + df, null));
                }
                if (definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/id-expectation")) {
                    String ide = ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/id-expectation");
                    if (ide.equals("optional")) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Id may or not be present (this is the default for elements but not resources)", null));
                    } else if (ide.equals("required")) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Id is required to be present (this is the default for resources but not elements)", null));
                    } else if (ide.equals("required")) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "An ID is not allowed in this context", null));
                    }
                }
                if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML") + ": ", null).addStyle("font-weight:bold"));
                        List list13 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator17);
                        list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, null, definition.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name"), null));
                        List list14 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator18);
                        list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, null, " (", null));
                        List list15 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator19);
                        list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, definition.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                        List list16 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator20);
                        list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, ")", null));
                    } else {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Element Name") + ": ", null).addStyle("font-weight:bold"));
                        List list17 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator21);
                        list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, definition.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name"), null));
                    }
                } else if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "XML Namespace") + ": ", null).addStyle("font-weight:bold"));
                    List list18 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, null, definition.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), null));
                }
                if (definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior")) {
                    String code;
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    if ("present".equals(code = ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior"))) {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "JSON: This element is present as a JSON Array even when there are no items in the instance", null));
                    } else {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "JSON: This element may be present as a JSON Array even when there are no items in the instance", null));
                    }
                }
                if (!Utilities.noString((String)(jn = ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name")))) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    if (definition.getPath().contains(".")) {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "JSON Property Name") + ": ", null).addStyle("font-weight:bold"));
                        List list19 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator23);
                        list19.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, null, jn, null));
                    } else {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "JSON Property Name for Type") + ": ", null).addStyle("font-weight:bold"));
                        HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator24);
                        HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, "code");
                        piece.addHtml(new XhtmlNode(NodeType.Text).setContent(jn));
                        c.getPieces().add(piece);
                    }
                }
                if (ToolingExtensions.readBoolExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "JSON: The type of this element is inferred from the JSON type in the instance", null));
                }
                if (ToolingExtensions.readBoolExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "JSON: This object can be represented as null in the JSON structure (which counts as 'present' for cardinality purposes)", null));
                }
                if (definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/json-property-key")) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    String code = ToolingExtensions.readStringExtension(definition, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key");
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "JSON: Represented as a single JSON Object with named properties using the value of the " + (String)code + " child as the key", null));
                }
                if (definition.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
                    for (Extension extension : definition.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        String cond = ToolingExtensions.readStringExtension(extension, "condition");
                        String type = ToolingExtensions.readStringExtension(extension, "type");
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "JSON: If ", null));
                        HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator25);
                        HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, "code");
                        piece.addHtml(new XhtmlNode(NodeType.Text).setContent(cond));
                        c.getPieces().add(piece);
                        List list20 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator26);
                        list20.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, null, "then the type is ", null));
                        StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(type);
                        if (sd == null) {
                            List list21 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator27 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator27);
                            list21.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator27, "<code>"));
                            List list22 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator28 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator28);
                            list22.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator28, null, type, null));
                            List list23 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator29 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator29);
                            list23.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator29, "</code>"));
                            continue;
                        }
                        List list24 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator30 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator30);
                        list24.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator30, sd.getWebPath(), sd.getTypeName(), null));
                    }
                }
                if (root) {
                    if (ToolingExtensions.readBoolExtension(profile, "http://hl7.org/fhir/tools/StructureDefinition/obligation-profile")) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "This is an obligation profile that only contains obligations and additional bindings", null).addStyle("font-weight:bold"));
                    }
                    this.addCanonicalListExt(gen, c, profile.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations"), "This profile picks up obligations and additional bindings from the profile", true);
                    this.addCanonicalListExt(gen, c, profile.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile"), "This profile also imposes the profile", true);
                    this.addCanonicalListExt(gen, c, profile.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile"), "This profile also complies with the profile", true);
                    if (profile.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        if (ToolingExtensions.readBoolExtension(profile, "http://hl7.org/fhir/tools/StructureDefinition/logical-target")) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "This logical model can be the target of a reference", null).addStyle("font-weight:bold"));
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "This logical model cannot be the target of a reference", null).addStyle("font-weight:bold"));
                        }
                    }
                }
                if (definition != null) {
                    ElementDefinition.ElementDefinitionBindingComponent binding = null;
                    if (valueDefn != null && valueDefn.hasBinding() && !valueDefn.getBinding().isEmpty()) {
                        binding = this.makeUnifiedBinding(valueDefn.getBinding(), valueDefn);
                    } else if (definition.hasBinding()) {
                        binding = this.makeUnifiedBinding(definition.getBinding(), definition);
                    }
                    if (binding != null && !binding.isEmpty()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        BindingResolution bindingResolution = this.context.getPkp() == null ? this.makeNullBr(binding) : this.context.getPkp().resolveBinding(profile, binding, definition.getPath());
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Binding") + ": ", null).addStyle("font-weight:bold")));
                        List list25 = c.getPieces();
                        CanonicalType canonicalType = binding.getValueSetElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator31 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator31);
                        list25.add(this.checkForNoChange(canonicalType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator31, bindingResolution.url == null ? null : (Utilities.isAbsoluteUrl((String)bindingResolution.url) || !this.context.getPkp().prependLinks() ? bindingResolution.url : corePath + bindingResolution.url), bindingResolution.display, null)));
                        if (binding.hasStrength()) {
                            List list26 = c.getPieces();
                            Enumeration<Enumerations.BindingStrength> enumeration = binding.getStrengthElement();
                            HierarchicalTableGenerator hierarchicalTableGenerator32 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator32);
                            list26.add(this.checkForNoChange(enumeration, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator32, null, " (", null)));
                            List list27 = c.getPieces();
                            Enumeration<Enumerations.BindingStrength> enumeration2 = binding.getStrengthElement();
                            HierarchicalTableGenerator hierarchicalTableGenerator33 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator33);
                            list27.add(this.checkForNoChange(enumeration2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator33, corePath + "terminologies.html#" + binding.getStrength().toCode(), this.egt(binding.getStrengthElement()), binding.getStrength().getDefinition())));
                            List list28 = c.getPieces();
                            Enumeration<Enumerations.BindingStrength> enumeration3 = binding.getStrengthElement();
                            HierarchicalTableGenerator hierarchicalTableGenerator34 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator34);
                            list28.add(this.checkForNoChange(enumeration3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator34, null, ")", null)));
                        }
                        if (binding.hasDescription() && MarkDownProcessor.isSimpleMarkdown((String)binding.getDescription())) {
                            List list29 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator35 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator35);
                            list29.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator35, null, ": ", null));
                            c.addMarkdownNoPara(PublicationHacker.fixBindingDescriptions(this.context.getWorker(), binding.getDescriptionElement()).asStringValue(), this.checkForNoChange(PublicationHacker.fixBindingDescriptions(this.context.getWorker(), binding.getDescriptionElement())));
                        }
                        AdditionalBindingsRenderer abr = new AdditionalBindingsRenderer(this.context.getPkp(), corePath, profile, definition.getPath(), rc, null, this);
                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                            abr.seeMaxBinding(ToolingExtensions.getExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"));
                        }
                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet")) {
                            abr.seeMinBinding(ToolingExtensions.getExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet"));
                        }
                        if (binding.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/additional-binding")) {
                            abr.seeAdditionalBindings(binding.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/additional-binding"));
                        }
                        abr.render(gen, c);
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent inv : definition.getConstraint()) {
                        if (inv.hasSource() && profile != null && !inv.getSource().equals(profile.getUrl()) && !allInvariants) continue;
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, inv.getKey() + ": ", null).addStyle("font-weight:bold")));
                        List list30 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator36 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator36);
                        list30.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator36, null, this.gt(inv.getHumanElement()), null)));
                    }
                    if (definition.hasBase() && "*".equals(definition.getBase().getMax()) || definition.hasMax() && "*".equals(definition.getMax())) {
                        if (c.getPieces().size() > 0) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        if (definition.hasOrderMeaning()) {
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "This repeating element order: " + definition.getOrderMeaning(), null));
                        }
                    }
                    if (definition.hasFixed()) {
                        HierarchicalTableGenerator.Piece piece;
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        DataType dataType = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Fixed Value") + ": ", null).addStyle("font-weight:bold")));
                        if (!this.useTableForFixedValues || !allowSubRows || definition.getFixed().isPrimitive()) {
                            String string = this.buildJson(definition.getFixed());
                            String link = null;
                            if (Utilities.isAbsoluteUrl((String)string) && this.context.getPkp() != null) {
                                link = this.context.getPkp().getLinkForUrl(corePath, string);
                            }
                            List list31 = c.getPieces();
                            DataType dataType2 = definition.getFixed();
                            HierarchicalTableGenerator hierarchicalTableGenerator37 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator37);
                            list31.add(this.checkForNoChange(dataType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator37, link, string, null).addStyle("color: darkgreen")));
                        } else {
                            List list32 = c.getPieces();
                            DataType dataType3 = definition.getFixed();
                            HierarchicalTableGenerator hierarchicalTableGenerator38 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator38);
                            list32.add(this.checkForNoChange(dataType3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator38, null, "As shown", null).addStyle("color: darkgreen")));
                            this.genFixedValue(gen, row, definition.getFixed(), snapshot, false, corePath, false);
                        }
                        if (this.isCoded(definition.getFixed()) && !this.hasDescription(definition.getFixed()) && (piece = this.describeCoded(gen, definition.getFixed())) != null) {
                            c.getPieces().add(piece);
                        }
                    } else if (definition.hasPattern()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        DataType dataType = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Required Pattern") + ": ", null).addStyle("font-weight:bold")));
                        if (!this.useTableForFixedValues || !allowSubRows || definition.getPattern().isPrimitive()) {
                            List list33 = c.getPieces();
                            DataType dataType4 = definition.getPattern();
                            HierarchicalTableGenerator hierarchicalTableGenerator39 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator39);
                            list33.add(this.checkForNoChange(dataType4, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator39, null, this.buildJson(definition.getPattern()), null).addStyle("color: darkgreen")));
                        } else {
                            List list34 = c.getPieces();
                            DataType dataType5 = definition.getPattern();
                            HierarchicalTableGenerator hierarchicalTableGenerator40 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator40);
                            list34.add(this.checkForNoChange(dataType5, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator40, null, "At least the following", null).addStyle("color: darkgreen")));
                            this.genFixedValue(gen, row, definition.getPattern(), snapshot, true, corePath, mustSupportOnly);
                        }
                    } else if (definition.hasExample()) {
                        for (ElementDefinition.ElementDefinitionExampleComponent ex : definition.getExample()) {
                            if (!c.getPieces().isEmpty()) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                            }
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Example") + (String)("".equals("General") ? "" : " " + ex.getLabel()) + ": ", null).addStyle("font-weight:bold")));
                            List list35 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator41 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator41);
                            list35.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator41, null, this.buildJson(ex.getValue()), null).addStyle("color: darkgreen")));
                        }
                    }
                    ObligationsRenderer obligationsRenderer = new ObligationsRenderer(corePath, profile, definition.getPath(), rc, null, this);
                    if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation")) {
                        obligationsRenderer.seeObligations(definition.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation"));
                    }
                    if (!definition.getPath().contains(".") && profile.hasExtension("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation")) {
                        obligationsRenderer.seeObligations(profile.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation"));
                    }
                    obligationsRenderer.renderTable(gen, c);
                    if (definition.hasMaxLength() && definition.getMaxLength() != 0) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        IntegerType integerType = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(integerType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Max Length: ", null).addStyle("font-weight:bold")));
                        List list36 = c.getPieces();
                        IntegerType integerType2 = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator42 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator42);
                        list36.add(this.checkForNoChange(integerType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator42, null, Integer.toString(definition.getMaxLength()), null).addStyle("color: darkgreen")));
                    }
                    if (profile != null) {
                        for (StructureDefinition.StructureDefinitionMappingComponent md : profile.getMapping()) {
                            if (!md.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name")) continue;
                            ElementDefinition.ElementDefinitionMappingComponent map = null;
                            for (ElementDefinition.ElementDefinitionMappingComponent m : definition.getMapping()) {
                                if (!m.getIdentity().equals(md.getIdentity())) continue;
                                map = m;
                            }
                            if (map == null) continue;
                            for (int i = 0; i < definition.getMapping().size(); ++i) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                                List list = c.getPieces();
                                HierarchicalTableGenerator hierarchicalTableGenerator43 = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator43);
                                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator43, null, ToolingExtensions.readStringExtension(md, "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name") + ": " + map.getMap(), null));
                            }
                        }
                    }
                }
            }
        }
        return c;
    }

    private void addCanonicalListExt(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell c, List<Extension> list, String start, boolean bold) {
        ArrayList<CanonicalType> clist = new ArrayList<CanonicalType>();
        for (Extension ext : list) {
            if (!ext.hasValueCanonicalType()) continue;
            clist.add(ext.getValueCanonicalType());
        }
        this.addCanonicalList(gen, c, clist, start, bold);
    }

    private void addCanonicalList(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell c, List<CanonicalType> list, String start, boolean bold) {
        if (!list.isEmpty()) {
            if (!c.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
            }
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, start + (list.size() != 1 ? "s" : "") + " ", null);
            c.addPiece(p);
            if (bold) {
                p.addStyle("font-weight:bold");
            }
            for (int i = 0; i < list.size(); ++i) {
                CanonicalType ct = list.get(i);
                if (i > 0) {
                    if (i < list.size() - 1) {
                        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator2);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, ", ", null));
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator3);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, " and ", null));
                    }
                }
                String iu = ct.primitiveValue();
                StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, iu);
                if (sd == null) {
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, iu, null).addStyle("font-weight:bold");
                    c.addPiece(p);
                } else if (sd.hasWebPath()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, sd.getWebPath(), sd.present(), null).addStyle("font-weight:bold");
                    c.addPiece(p);
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator6);
                    p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, iu, sd.present(), null).addStyle("font-weight:bold");
                    c.addPiece(p);
                }
                if (!bold) continue;
                p.addStyle("font-weight:bold");
            }
        }
    }

    private HierarchicalTableGenerator.Piece checkForNoChange(Element source, HierarchicalTableGenerator.Piece piece) {
        if (source.hasUserData("derivation.equals")) {
            piece.addStyle("opacity: 0.5");
        }
        return piece;
    }

    private String checkForNoChange(Element source) {
        if (source.hasUserData("derivation.equals")) {
            return "opacity: 0.5";
        }
        return null;
    }

    private HierarchicalTableGenerator.Cell genTypes(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row r, ElementDefinition e, String profileBaseFileName, StructureDefinition profile, String corePath, String imagePath, boolean root, boolean mustSupportMode) {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(c);
        if (e.hasContentReference()) {
            ElementInStructure ed = this.getElementByName(profile.getSnapshot().getElement(), e.getContentReference(), profile);
            if (ed == null) {
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "Unknown reference to %s", new Object[]{e.getContentReference()}), null));
            } else if (ed.getSource() == profile) {
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "See ", new Object[]{ed.getElement().getPath()}), null));
                List list2 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, "#" + ed.getElement().getPath(), this.tail(ed.getElement().getPath()), ed.getElement().getPath()));
            } else {
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.translate("sd.table", "See ", new Object[]{ed.getElement().getPath()}), null));
                List list3 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator3);
                list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, this.pfx(corePath, ed.getSource().getWebPath()) + "#" + ed.getElement().getPath(), this.tail(ed.getElement().getPath()) + " (" + ed.getSource().getTypeName() + ")", ed.getElement().getPath()));
            }
            return c;
        }
        List<ElementDefinition.TypeRefComponent> types = e.getType();
        if (!e.hasType()) {
            if (root) {
                Resource bsd;
                Resource resource = bsd = profile == null ? null : this.context.getWorker().fetchResource(StructureDefinition.class, profile.getBaseDefinition(), profile);
                if (bsd != null) {
                    if (bsd.hasWebPath()) {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, (String)(Utilities.isAbsoluteUrl((String)bsd.getWebPath()) ? bsd.getWebPath() : imagePath + bsd.getWebPath()), ((StructureDefinition)bsd).getName(), null));
                    } else {
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ((StructureDefinition)bsd).getName(), null));
                    }
                }
                return c;
            }
            if (e.hasContentReference()) {
                return c;
            }
            ElementDefinition d = (ElementDefinition)e.getUserData("derived.pointer");
            if (d != null && d.hasType()) {
                types = new ArrayList<ElementDefinition.TypeRefComponent>();
                for (ElementDefinition.TypeRefComponent tr : d.getType()) {
                    ElementDefinition.TypeRefComponent tt = tr.copy();
                    tt.setUserData("derivation.equals", true);
                    types.add(tt);
                }
            } else {
                return c;
            }
        }
        boolean first = true;
        ElementDefinition.TypeRefComponent tl = null;
        for (ElementDefinition.TypeRefComponent t : types) {
            if (mustSupportMode && !this.allTypesMustSupport(e) && !this.isMustSupport(t)) continue;
            if (first) {
                first = false;
            } else {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(tl, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ", ", null)));
            }
            tl = t;
            if (t.hasTarget()) {
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + "references.html", t.getWorkingCode(), null));
                if (!mustSupportMode && this.isMustSupportDirect(t) && e.getMustSupport()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, " ", null));
                    c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
                }
                List list4 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, "(", null));
                boolean tfirst = true;
                for (CanonicalType u : t.getTargetProfile()) {
                    if (mustSupportMode && !this.allProfilesMustSupport(t.getTargetProfile()) && !this.isMustSupport(u)) continue;
                    if (tfirst) {
                        tfirst = false;
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator6);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, " | ", null));
                    }
                    this.genTargetLink(gen, profileBaseFileName, corePath, c, t, (String)u.getValue(), null);
                    if (mustSupportMode || !this.isMustSupport(u) || !e.getMustSupport()) continue;
                    HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator7);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, " ", null));
                    c.addStyledText(this.translate("sd.table", "This target must be supported"), "S", "white", "red", null, false);
                }
                List list5 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, ")", null));
                if (t.getAggregation().size() <= 0) continue;
                List list6 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, corePath + "valueset-resource-aggregation-mode.html", " {", null));
                boolean firstA = true;
                for (Enumeration enumeration : t.getAggregation()) {
                    if (firstA) {
                        firstA = false;
                    } else {
                        List list7 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator10);
                        list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, corePath + "valueset-resource-aggregation-mode.html", ", ", null));
                    }
                    List list8 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, corePath + "valueset-resource-aggregation-mode.html", this.codeForAggregation((ElementDefinition.AggregationMode)((Object)enumeration.getValue())), this.hintForAggregation((ElementDefinition.AggregationMode)((Object)enumeration.getValue()))));
                }
                List list9 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator12);
                list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, corePath + "valueset-resource-aggregation-mode.html", "}", null));
                continue;
            }
            if (t.hasProfile() && (!t.getWorkingCode().equals("Extension") || this.isProfiledType(t.getProfile()))) {
                boolean pfirst = true;
                for (CanonicalType canonicalType : t.getProfile()) {
                    String ref;
                    if (mustSupportMode && !this.allProfilesMustSupport(t.getProfile()) && !this.isMustSupport(canonicalType)) continue;
                    if (pfirst) {
                        pfirst = false;
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(tl, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ", ", null)));
                    }
                    String string = ref = this.context.getPkp() == null ? null : this.context.getPkp().getLinkForProfile(profile, (String)canonicalType.getValue());
                    if (ref != null) {
                        String[] parts = ref.split("\\|");
                        if (parts[0].startsWith("http:") || parts[0].startsWith("https:")) {
                            if (canonicalType.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element")) {
                                String pp = canonicalType.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element");
                                pp = pp.substring(pp.indexOf("."));
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, parts[0], parts[1] + pp, t.getWorkingCode())));
                            } else {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, parts[0], parts[1], t.getWorkingCode())));
                            }
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, (((String)canonicalType.getValue()).startsWith(corePath + "StructureDefinition") ? corePath : "") + parts[0], parts[1], t.getWorkingCode())));
                        }
                    } else {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, (((String)canonicalType.getValue()).startsWith(corePath) ? corePath : "") + ref, t.getWorkingCode(), null)));
                    }
                    if (mustSupportMode || !this.isMustSupport(canonicalType) || !e.getMustSupport()) continue;
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " ", null));
                    c.addStyledText(this.translate("sd.table", "This profile must be supported"), "S", "white", "red", null, false);
                }
                continue;
            }
            String tc = t.getWorkingCode();
            if (Utilities.isAbsoluteUrl((String)tc)) {
                StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(tc);
                if (sd == null) {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.context.getPkp().getLinkFor(corePath, tc), tc, null)));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.context.getPkp().getLinkFor(corePath, tc), sd.getTypeName(), null)));
                }
            } else if (this.context.getPkp() != null && this.context.getPkp().hasLinkFor(tc)) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.context.getPkp().getLinkFor(corePath, tc), tc, null)));
            } else {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, tc, null)));
            }
            if (mustSupportMode || !this.isMustSupportDirect(t) || !e.getMustSupport()) continue;
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " ", null));
            c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
        }
        return c;
    }

    private String pfx(String prefix, String url) {
        return Utilities.isAbsoluteUrl((String)url) ? url : prefix + url;
    }

    private void genTargetLink(HierarchicalTableGenerator gen, String profileBaseFileName, String corePath, HierarchicalTableGenerator.Cell c, ElementDefinition.TypeRefComponent t, String u, Resource src) {
        if (u.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            StructureDefinition sd = this.context.getWorker().fetchResource(StructureDefinition.class, u, src);
            if (sd != null) {
                String disp = sd.hasTitle() ? sd.getTitle() : sd.getName();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.checkPrepend(corePath, sd.getWebPath()), disp, null)));
            } else {
                String rn = u.substring(40);
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, this.context.getPkp().getLinkFor(corePath, rn), rn, null)));
            }
        } else if (Utilities.isAbsoluteUrl((String)u)) {
            StructureDefinition sd = this.context.getWorker().fetchResource(StructureDefinition.class, u, src);
            if (sd != null && this.context.getPkp() != null) {
                String disp = sd.hasTitle() ? sd.getTitle() : sd.getName();
                String ref = this.context.getPkp().getLinkForProfile(null, sd.getUrl());
                if (ref != null && ref.contains("|")) {
                    ref = ref.substring(0, ref.indexOf("|"));
                }
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ref, disp, null)));
            } else {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, u, null)));
            }
        } else if (t.hasTargetProfile() && u.startsWith("#")) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + profileBaseFileName + "." + u.substring(1).toLowerCase() + ".html", u, null)));
        }
    }

    private boolean isProfiledType(List<CanonicalType> theProfile) {
        for (CanonicalType next : theProfile) {
            if (!StringUtils.defaultString((String)next.getValueAsString()).contains(":")) continue;
            return true;
        }
        return false;
    }

    public String codeForAggregation(ElementDefinition.AggregationMode a) {
        switch (a) {
            case BUNDLED: {
                return "b";
            }
            case CONTAINED: {
                return "c";
            }
            case REFERENCED: {
                return "r";
            }
        }
        return "?";
    }

    public String hintForAggregation(ElementDefinition.AggregationMode a) {
        if (a != null) {
            return a.getDefinition();
        }
        return null;
    }

    private String checkPrepend(String corePath, String path) {
        if (this.context.getPkp() != null && this.context.getPkp().prependLinks() && !path.startsWith("http:") && !path.startsWith("https:")) {
            return corePath + path;
        }
        return path;
    }

    private ElementDefinition findParent(List<ElementDefinition> list, int i, String path) {
        while (i > 0 && !path.startsWith(list.get(i).getPath() + ".")) {
            --i;
        }
        return list.get(i);
    }

    private boolean isSibling(String[] pathCurrent, String[] pathLast, int firstDiff) {
        return pathCurrent.length == pathLast.length && firstDiff == pathCurrent.length - 1;
    }

    private boolean isChild(String[] pathCurrent, String[] pathLast, int firstDiff) {
        return pathCurrent.length == pathLast.length + 1 && firstDiff == pathLast.length;
    }

    private String makeTail(String[] pathCurrent, int start, int index) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(".");
        for (int i = start; i <= index; ++i) {
            b.append(pathCurrent[i]);
        }
        return b.toString();
    }

    private void genGridElement(String defPath, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ElementDefinition element, List<ElementDefinition> all, List<StructureDefinition> profiles, boolean showMissing, String profileBaseFileName, Boolean extensions, String corePath, String imagePath, boolean root, boolean isConstraintMode) throws IOException, FHIRException {
        boolean isExtension;
        StructureDefinition profile = profiles == null ? null : profiles.get(profiles.size() - 1);
        String s = this.tail(element.getPath());
        List<ElementDefinition> children = this.getChildren(all, element);
        boolean bl = isExtension = s.equals("extension") || s.equals("modifierExtension");
        if (!this.onlyInformationIsMapping(all, element)) {
            HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
            row.setAnchor(element.getPath());
            row.setColor(this.context.getProfileUtilities().getRowColor(element, isConstraintMode));
            if (element.hasSlicing()) {
                row.setLineColor(1);
            } else if (element.hasSliceName()) {
                row.setLineColor(2);
            } else {
                row.setLineColor(0);
            }
            boolean hasDef = element != null;
            String ref = defPath == null ? null : defPath + element.getId();
            UnusedTracker used = new UnusedTracker();
            used.used = true;
            HierarchicalTableGenerator.Cell left = new HierarchicalTableGenerator.Cell(gen);
            if (element.getType().size() == 1 && element.getType().get(0).isPrimitive()) {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ref, "\u00a0\u00a0" + s, !hasDef ? null : this.gt(element.getDefinitionElement())).addStyle("font-weight:bold"));
            } else {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ref, "\u00a0\u00a0" + s, !hasDef ? null : this.gt(element.getDefinitionElement())));
            }
            if (element.hasSliceName()) {
                List list = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                String indent = StringUtils.repeat((char)'\u00a0', (int)(1 + 2 * element.getPath().split("\\.").length));
                List list2 = left.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, indent + "(" + element.getSliceName() + ")", null));
            }
            row.getCells().add(left);
            this.genCardinality(gen, element, row, hasDef, used, null);
            if (hasDef && !"0".equals(element.getMax())) {
                this.genTypes(gen, row, element, profileBaseFileName, profile, corePath, imagePath, root, false);
            } else {
                row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
            }
            this.generateGridDescription(gen, row, element, null, used.used, null, null, profile, corePath, imagePath, root, null);
            rows.add(row);
            for (ElementDefinition child : children) {
                if (!child.getMustSupport()) continue;
                this.genGridElement(defPath, gen, row.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, isExtension, corePath, imagePath, false, isConstraintMode);
            }
        }
    }

    private ProfileUtilities.ExtensionContext locateExtension(Class<StructureDefinition> class1, String value) {
        if (value.contains("#")) {
            StructureDefinition ext = this.context.getWorker().fetchResource(StructureDefinition.class, value.substring(0, value.indexOf("#")));
            if (ext == null) {
                return null;
            }
            String tail = value.substring(value.indexOf("#") + 1);
            ElementDefinition ed = null;
            for (ElementDefinition ted : ext.getSnapshot().getElement()) {
                if (!tail.equals(ted.getSliceName())) continue;
                ed = ted;
                return new ProfileUtilities.ExtensionContext(ext, ed);
            }
            return null;
        }
        StructureDefinition ext = this.context.getWorker().fetchResource(StructureDefinition.class, value);
        if (ext == null) {
            return null;
        }
        return new ProfileUtilities.ExtensionContext(ext, ext.getSnapshot().getElement().get(0));
    }

    private boolean extensionIsComplex(String value) {
        if (value.contains("#")) {
            int j;
            StructureDefinition ext = this.context.getWorker().fetchResource(StructureDefinition.class, value.substring(0, value.indexOf("#")));
            if (ext == null) {
                return false;
            }
            String tail = value.substring(value.indexOf("#") + 1);
            ElementDefinition ed = null;
            for (ElementDefinition ted : ext.getSnapshot().getElement()) {
                if (!tail.equals(ted.getSliceName())) continue;
                ed = ted;
                break;
            }
            if (ed == null) {
                return false;
            }
            int i = ext.getSnapshot().getElement().indexOf(ed);
            for (j = i + 1; j < ext.getSnapshot().getElement().size() && !ext.getSnapshot().getElement().get(j).getPath().equals(ed.getPath()); ++j) {
            }
            return j - i > 5;
        }
        StructureDefinition ext = this.context.getWorker().fetchResource(StructureDefinition.class, value);
        return ext != null && ext.getSnapshot().getElement().size() > 5;
    }

    private BindingResolution makeNullBr(ElementDefinition.ElementDefinitionBindingComponent binding) {
        BindingResolution br = new BindingResolution();
        br.url = "http://none.none/none";
        br.display = "todo";
        return br;
    }

    private ElementDefinition.ElementDefinitionBindingComponent makeUnifiedBinding(ElementDefinition.ElementDefinitionBindingComponent binding, ElementDefinition element) {
        if (!element.hasUserData("derived.pointer")) {
            return binding;
        }
        ElementDefinition base = (ElementDefinition)element.getUserData("derived.pointer");
        if (!base.hasBinding()) {
            return binding;
        }
        ElementDefinition.ElementDefinitionBindingComponent o = base.getBinding();
        ElementDefinition.ElementDefinitionBindingComponent b = new ElementDefinition.ElementDefinitionBindingComponent();
        b.setUserData("derived.pointer", o);
        if (binding.hasValueSet()) {
            b.setValueSet(binding.getValueSet());
        } else if (o.hasValueSet()) {
            b.setValueSet(o.getValueSet());
            b.getValueSetElement().setUserData("derivation.equals", o.getValueSetElement());
        }
        if (binding.hasStrength()) {
            b.setStrength(binding.getStrength());
        } else if (o.hasStrength()) {
            b.setStrength(o.getStrength());
            b.getStrengthElement().setUserData("derivation.equals", o.getStrengthElement());
        }
        if (binding.hasDescription()) {
            b.setDescription(binding.getDescription());
        } else if (o.hasDescription()) {
            b.setDescription(o.getDescription());
            b.getDescriptionElement().setUserData("derivation.equals", o.getDescriptionElement());
        }
        b.getExtension().addAll(binding.getExtension());
        return b;
    }

    private void genFixedValue(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row erow, DataType value, boolean snapshot, boolean pattern, String corePath, boolean skipnoValue) {
        Object ref = this.context.getPkp().getLinkFor(corePath, value.fhirType());
        ref = ref != null && ((String)ref).contains(".html") ? ((String)ref).substring(0, ((String)ref).indexOf(".html")) + "-definitions.html#" : "?gen-fv?";
        StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(value.fhirType());
        for (Property t : value.children()) {
            if (t.getValues().size() <= 0 && !snapshot) continue;
            ElementDefinition ed = this.findElementDefinition(sd, t.getName());
            if (t.getValues().size() == 0 || t.getValues().size() == 1 && t.getValues().get(0).isEmpty()) {
                if (skipnoValue) continue;
                HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
                erow.getSubRows().add(row);
                HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ed.getBase().getPath().equals(ed.getPath()) ? (String)ref + ed.getPath() : corePath + (VersionUtilities.isR5Plus((String)this.context.getWorker().getVersion()) ? "types-definitions.html#" + ed.getBase().getPath() : "element-definitions.html#" + ed.getBase().getPath()), t.getName(), null));
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, null, null));
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                if (!pattern) {
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "0..0", null));
                    row.setIcon("icon_fixed.gif", "Fixed Value");
                } else if (this.isPrimitive(t.getTypeCode())) {
                    row.setIcon("icon_primitive.png", "Primitive Data Type");
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, "0.." + (t.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.toString(t.getMaxCardinality())), null));
                } else if (this.isReference(t.getTypeCode())) {
                    row.setIcon("icon_reference.png", "Reference to another Resource");
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, "0.." + (t.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.toString(t.getMaxCardinality())), null));
                } else {
                    row.setIcon("icon_datatype.gif", "Data Type");
                    HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator6);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, "0.." + (t.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.toString(t.getMaxCardinality())), null));
                }
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                if (t.getTypeCode().contains("(")) {
                    String[] p;
                    String tc = t.getTypeCode();
                    String tn = tc.substring(0, tc.indexOf("("));
                    HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator7);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, this.context.getPkp().getLinkFor(corePath, tn), tn, null));
                    HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator8);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, "(", null));
                    for (String s : p = tc.substring(tc.indexOf("(") + 1, tc.indexOf(")")).split("\\|")) {
                        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator9);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, this.context.getPkp().getLinkFor(corePath, s), s, null));
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator10);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, ")", null));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, this.context.getPkp().getLinkFor(corePath, t.getTypeCode()), t.getTypeCode(), null));
                }
                c = new HierarchicalTableGenerator.Cell(gen);
                HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator12);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, ed.getShort(), null));
                row.getCells().add(c);
                continue;
            }
            for (Base b : t.getValues()) {
                HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
                erow.getSubRows().add(row);
                row.setIcon("icon_fixed.gif", "Fixed Value");
                HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ed.getBase().getPath().equals(ed.getPath()) ? (String)ref + ed.getPath() : (VersionUtilities.isR5Ver((String)this.context.getWorker().getVersion()) ? corePath + "types-definitions.html#" + ed.getBase().getPath() : corePath + "element-definitions.html#" + ed.getBase().getPath()), t.getName(), null));
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator13);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, null, null));
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                if (pattern) {
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator14);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, "1.." + (t.getMaxCardinality() == Integer.MAX_VALUE ? "*" : Integer.toString(t.getMaxCardinality())), null));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator15);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, null, "1..1", null));
                }
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                if (b.fhirType().contains("(")) {
                    String[] p;
                    String tc = b.fhirType();
                    String tn = tc.substring(0, tc.indexOf("("));
                    HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator16);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, this.context.getPkp().getLinkFor(corePath, tn), tn, null));
                    HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator17);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, null, "(", null));
                    for (String s : p = tc.substring(tc.indexOf("(") + 1, tc.indexOf(")")).split("\\|")) {
                        HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator18);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, this.context.getPkp().getLinkFor(corePath, s), s, null));
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator19);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, ")", null));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator20);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, this.context.getPkp().getLinkFor(corePath, b.fhirType()), b.fhirType(), null));
                }
                if (b.isPrimitive()) {
                    c = new HierarchicalTableGenerator.Cell(gen);
                    row.getCells().add(c);
                    HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator21);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, ed.getShort(), null));
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, "br"));
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator23);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, null, "Fixed Value: ", null).addStyle("font-weight: bold"));
                    String s = b.primitiveValue();
                    String link = null;
                    if (Utilities.isAbsoluteUrl((String)s)) {
                        link = this.context.getPkp().getLinkForUrl(corePath, s);
                    }
                    List list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator24);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, link, s, null).addStyle("color: darkgreen"));
                    continue;
                }
                c = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(c);
                HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator25);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, null, ed.getShort(), null));
                HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator26);
                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, "br"));
                List list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator27 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator27);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator27, null, "Fixed Value: ", null).addStyle("font-weight: bold"));
                List list3 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator28 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator28);
                list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator28, null, "(complex)", null).addStyle("color: darkgreen"));
                this.genFixedValue(gen, row, (DataType)b, snapshot, pattern, corePath, skipnoValue);
            }
        }
    }

    private ElementDefinition findElementDefinition(StructureDefinition sd, String name) {
        String path = sd.getTypeName() + "." + name;
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals(path)) continue;
            return ed;
        }
        throw new FHIRException(this.context.getWorker().formatMessage("Unable_to_find_element_", path));
    }

    private String getFixedUrl(StructureDefinition sd) {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals("Extension.url") || !ed.hasFixed() || !(ed.getFixed() instanceof UriType)) continue;
            return ed.getFixed().primitiveValue();
        }
        return null;
    }

    private HierarchicalTableGenerator.Piece describeCoded(HierarchicalTableGenerator gen, DataType fixed) {
        if (fixed instanceof Coding) {
            Coding c = (Coding)fixed;
            IWorkerContext.ValidationResult vr = this.context.getWorker().validateCode(this.context.getTerminologyServiceOptions(), c.getSystem(), c.getVersion(), c.getCode(), c.getDisplay());
            if (vr.getDisplay() != null) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                return new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " (" + vr.getDisplay() + ")", null).addStyle("color: darkgreen");
            }
        } else if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            for (Coding c : cc.getCoding()) {
                IWorkerContext.ValidationResult vr = this.context.getWorker().validateCode(this.context.getTerminologyServiceOptions(), c.getSystem(), c.getVersion(), c.getCode(), c.getDisplay());
                if (vr.getDisplay() == null) continue;
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                return new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " (" + vr.getDisplay() + ")", null).addStyle("color: darkgreen");
            }
        }
        return null;
    }

    private boolean hasDescription(DataType fixed) {
        if (fixed instanceof Coding) {
            return ((Coding)fixed).hasDisplay();
        }
        if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            if (cc.hasText()) {
                return true;
            }
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplay()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCoded(DataType fixed) {
        return fixed instanceof Coding || fixed instanceof CodeableConcept || fixed instanceof CodeType || fixed instanceof Quantity;
    }

    private HierarchicalTableGenerator.Cell generateGridDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath, String imagePath, boolean root, ElementDefinition valueDefn) throws IOException, FHIRException {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(c);
        if (used) {
            if (definition.hasContentReference()) {
                ElementInStructure ed = this.getElementByName(profile.getSnapshot().getElement(), definition.getContentReference(), profile);
                if (ed == null) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Unknown reference to " + definition.getContentReference(), null));
                } else if (ed.getSource() == profile) {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "#" + ed.getElement().getPath(), "See " + ed.getElement().getPath(), null));
                } else {
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, ed.getSource().getWebPath() + "#" + ed.getElement().getPath(), "See " + ed.getSource().getTypeName() + "." + ed.getElement().getPath(), null));
                }
            }
            if (definition.getPath().endsWith("url") && definition.hasFixed()) {
                List list = c.getPieces();
                DataType dataType = definition.getFixed();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "\"" + this.buildJson(definition.getFixed()) + "\"", null).addStyle("color: darkgreen")));
            } else {
                if (url != null) {
                    String p;
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    String fullUrl = url.startsWith("#") ? baseURL + url : url;
                    StructureDefinition ed = this.context.getWorker().fetchResource(StructureDefinition.class, url, profile);
                    String ref = null;
                    if (ed != null && (p = ed.getWebPath()) != null) {
                        ref = p.startsWith("http:") || this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER ? p : Utilities.pathURL((String[])new String[]{corePath, p});
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "URL: ", null).addStyle("font-weight:bold"));
                    List list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, ref, fullUrl, null));
                }
                if (definition.hasSlicing()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Slice: ", null).addStyle("font-weight:bold"));
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, this.describeSlice(definition.getSlicing()), null));
                }
                if (definition != null) {
                    ElementDefinition.ElementDefinitionBindingComponent binding = null;
                    if (valueDefn != null && valueDefn.hasBinding() && !valueDefn.getBinding().isEmpty()) {
                        binding = valueDefn.getBinding();
                    } else if (definition.hasBinding()) {
                        binding = definition.getBinding();
                    }
                    if (binding != null && !binding.isEmpty()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        BindingResolution br = this.context.getPkp().resolveBinding(profile, binding, definition.getPath());
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Binding: ", null).addStyle("font-weight:bold")));
                        List list4 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator4);
                        list4.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.context.getPkp().prependLinks() ? br.url : corePath + br.url), br.display, null)));
                        if (binding.hasStrength()) {
                            List list5 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator5);
                            list5.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, " (", null)));
                            List list6 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator6);
                            list6.add(this.checkForNoChange(binding, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, corePath + "terminologies.html#" + binding.getStrength().toCode(), binding.getStrength().toCode(), binding.getStrength().getDefinition())));
                            List list7 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator7);
                            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, ")", null));
                        }
                        if (binding.hasDescription() && MarkDownProcessor.isSimpleMarkdown((String)binding.getDescription())) {
                            List list8 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator8);
                            list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, ": ", null));
                            c.addMarkdownNoPara(PublicationHacker.fixBindingDescriptions(this.context.getWorker(), binding.getDescriptionElement()).asStringValue());
                        }
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent inv : definition.getConstraint()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, inv.getKey() + ": ", null).addStyle("font-weight:bold")));
                        if (inv.getHumanElement().hasExtension("http://hl7.org/fhir/StructureDefinition/rendering-markdown")) {
                            c.addMarkdown(inv.getHumanElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/rendering-markdown"));
                            continue;
                        }
                        List list9 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator9);
                        list9.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, inv.getHuman(), null)));
                    }
                    if (definition.hasFixed()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        DataType dataType = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Fixed Value: ", null).addStyle("font-weight:bold")));
                        String s = this.buildJson(definition.getFixed());
                        String link = null;
                        if (Utilities.isAbsoluteUrl((String)s)) {
                            link = this.context.getPkp().getLinkForUrl(corePath, s);
                        }
                        List list10 = c.getPieces();
                        DataType dataType2 = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator10);
                        list10.add(this.checkForNoChange(dataType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, link, s, null).addStyle("color: darkgreen")));
                    } else if (definition.hasPattern()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        DataType dataType = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(dataType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Required Pattern: ", null).addStyle("font-weight:bold")));
                        List list11 = c.getPieces();
                        DataType dataType3 = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator11);
                        list11.add(this.checkForNoChange(dataType3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, this.buildJson(definition.getPattern()), null).addStyle("color: darkgreen")));
                    } else if (definition.hasExample()) {
                        for (ElementDefinition.ElementDefinitionExampleComponent ex : definition.getExample()) {
                            if (!c.getPieces().isEmpty()) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                            }
                            List list = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            list.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Example'" + (String)("".equals("General") ? "" : " " + ex.getLabel() + "'") + ": ", "").addStyle("font-weight:bold")));
                            List list12 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator12);
                            list12.add(this.checkForNoChange(ex, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, this.buildJson(ex.getValue()), null).addStyle("color: darkgreen")));
                        }
                    }
                    if (definition.hasMaxLength() && definition.getMaxLength() != 0) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        IntegerType integerType = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(integerType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Max Length: ", null).addStyle("font-weight:bold")));
                        List list13 = c.getPieces();
                        IntegerType integerType2 = definition.getMaxLengthElement();
                        HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator13);
                        list13.add(this.checkForNoChange(integerType2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, Integer.toString(definition.getMaxLength()), null).addStyle("color: darkgreen")));
                    }
                    if (profile != null) {
                        for (StructureDefinition.StructureDefinitionMappingComponent md : profile.getMapping()) {
                            if (!md.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name")) continue;
                            ElementDefinition.ElementDefinitionMappingComponent map = null;
                            for (ElementDefinition.ElementDefinitionMappingComponent m : definition.getMapping()) {
                                if (!m.getIdentity().equals(md.getIdentity())) continue;
                                map = m;
                            }
                            if (map == null) continue;
                            for (int i = 0; i < definition.getMapping().size(); ++i) {
                                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator);
                                c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                                List list = c.getPieces();
                                HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator14);
                                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, ToolingExtensions.readStringExtension(md, "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name") + ": " + map.getMap(), null));
                            }
                        }
                    }
                    if (definition.hasDefinition()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Definition: ", null).addStyle("font-weight:bold"));
                        HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator15);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "br"));
                        c.addMarkdown(definition.getDefinition());
                    }
                    if (definition.getComment() != null) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Comments: ", null).addStyle("font-weight:bold"));
                        HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator16);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, "br"));
                        c.addMarkdown(definition.getComment());
                    }
                }
            }
        }
        return c;
    }

    private boolean onlyInformationIsMapping(List<ElementDefinition> list, ElementDefinition e) {
        return !e.hasSliceName() && !e.hasSlicing() && this.onlyInformationIsMapping(e) && this.getChildren(list, e).isEmpty();
    }

    private boolean onlyInformationIsMapping(ElementDefinition d) {
        return !d.hasShort() && !d.hasDefinition() && !d.hasRequirements() && !d.getAlias().isEmpty() && !d.hasMinElement() && !d.hasMax() && !d.getType().isEmpty() && !d.hasContentReference() && !d.hasExample() && !d.hasFixed() && !d.hasMaxLengthElement() && !d.getCondition().isEmpty() && !d.getConstraint().isEmpty() && !d.hasMustSupportElement() && !d.hasBinding();
    }

    private boolean allAreReference(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (t.hasTarget()) continue;
            return false;
        }
        return true;
    }

    private List<ElementDefinition> getChildren(List<ElementDefinition> all, ElementDefinition element) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        for (int i = all.indexOf(element) + 1; i < all.size() && all.get(i).getPath().length() > element.getPath().length(); ++i) {
            if (!all.get(i).getPath().substring(0, element.getPath().length() + 1).equals(element.getPath() + ".") || all.get(i).getPath().substring(element.getPath().length() + 1).contains(".")) continue;
            result.add(all.get(i));
        }
        return result;
    }

    protected String tail(String path) {
        if (path == null) {
            return "";
        }
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return path;
    }

    protected boolean isPrimitive(String value) {
        StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(value);
        if (sd == null) {
            return Utilities.existsInList((String)value, (String[])new String[]{"base64Binary", "boolean", "canonical", "code", "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid"});
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private boolean isDataType(String value) {
        StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(value);
        if (sd == null) {
            return Utilities.existsInList((String)value, (String[])new String[]{"Address", "Age", "Annotation", "Attachment", "CodeableConcept", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "Contributor", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext"});
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION;
    }

    private boolean slicesExist(List<ElementDefinition> elements, ElementDefinition element) {
        if (elements == null) {
            return true;
        }
        boolean found = false;
        int start = elements.indexOf(element);
        if (start < 0) {
            return false;
        }
        for (int i = start; i < elements.size(); ++i) {
            ElementDefinition ed = elements.get(i);
            if (ed.getPath().equals(element.getPath()) && ed.hasSliceName()) {
                found = true;
            }
            if (ed.getPath().length() < element.getPath().length()) break;
        }
        return found;
    }

    private HierarchicalTableGenerator.Cell addCell(HierarchicalTableGenerator.Row row, HierarchicalTableGenerator.Cell cell) {
        row.getCells().add(cell);
        return cell;
    }

    private String checkAdd(String src, String app) {
        return app == null ? src : src + app;
    }

    public boolean hasNonBaseConditions(List<IdType> conditions) {
        for (IdType c : conditions) {
            if (this.isBaseCondition(c)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonBaseConstraints(List<ElementDefinition.ElementDefinitionConstraintComponent> constraints) {
        for (ElementDefinition.ElementDefinitionConstraintComponent c : constraints) {
            if (this.isBaseConstraint(c)) continue;
            return true;
        }
        return false;
    }

    public String listConstraintsAndConditions(ElementDefinition element) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.ElementDefinitionConstraintComponent con : element.getConstraint()) {
            if (this.isBaseConstraint(con)) continue;
            b.append(con.getKey());
        }
        for (IdType id : element.getCondition()) {
            if (this.isBaseCondition(id)) continue;
            b.append(id.asStringValue());
        }
        return b.toString();
    }

    private boolean isBaseCondition(IdType c) {
        String key = c.asStringValue();
        return key != null && (key.startsWith("ele-") || key.startsWith("res-") || key.startsWith("ext-") || key.startsWith("dom-") || key.startsWith("dr-"));
    }

    private boolean isBaseConstraint(ElementDefinition.ElementDefinitionConstraintComponent con) {
        String key = con.getKey();
        return key != null && (key.startsWith("ele-") || key.startsWith("res-") || key.startsWith("ext-") || key.startsWith("dom-") || key.startsWith("dr-"));
    }

    private void makeChoiceRows(List<HierarchicalTableGenerator.Row> subRows, ElementDefinition element, HierarchicalTableGenerator gen, String corePath, String profileBaseFileName, boolean mustSupportMode, Resource src) {
        for (ElementDefinition.TypeRefComponent tr : element.getType()) {
            if (mustSupportMode && !this.allTypesMustSupport(element) && !this.isMustSupport(tr)) continue;
            HierarchicalTableGenerator.Row choicerow = new HierarchicalTableGenerator.Row(gen);
            String t = tr.getWorkingCode();
            if (this.isReference(t)) {
                List list = choicerow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, this.tail(element.getPath()).replace("[x]", Utilities.capitalize((String)t)), null, null));
                choicerow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                List list2 = choicerow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
                choicerow.setIcon("icon_reference.png", "Reference to another Resource");
                HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
                choicerow.getCells().add(c);
                if (tr.getWorkingCode().equals("canonical")) {
                    List list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, corePath + "datatypes.html#canonical", "canonical", null));
                } else {
                    List list4 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator4);
                    list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, corePath + "references.html#Reference", "Reference", null));
                }
                if (!mustSupportMode && this.isMustSupportDirect(tr) && element.getMustSupport()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, " ", null));
                    c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
                }
                List list5 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, "(", null));
                boolean first = true;
                for (CanonicalType rt : tr.getTargetProfile()) {
                    if (mustSupportMode && !this.allProfilesMustSupport(tr.getTargetProfile()) && !this.isMustSupport(rt)) continue;
                    if (!first) {
                        List list6 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator7);
                        list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, " | ", null));
                    }
                    this.genTargetLink(gen, profileBaseFileName, corePath, c, tr, (String)rt.getValue(), src);
                    if (!mustSupportMode && this.isMustSupport(rt) && element.getMustSupport()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator8);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, " ", null));
                        c.addStyledText(this.translate("sd.table", "This target must be supported"), "S", "white", "red", null, false);
                    }
                    first = false;
                }
                if (first) {
                    List list7 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator9);
                    list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, "Any", null));
                }
                List list8 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator10);
                list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, ")", null));
            } else {
                StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(t);
                if (sd == null) {
                    System.out.println("Unable to find " + t);
                    sd = this.context.getWorker().fetchTypeDefinition(t);
                } else if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                    List list = choicerow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, this.tail(element.getPath()).replace("[x]", Utilities.capitalize((String)t)), sd.getDescription(), null));
                    choicerow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    List list9 = choicerow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list9.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator11, null, null, "", null, null));
                    choicerow.setIcon("icon_primitive.png", "Primitive Data Type");
                    HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator12);
                    HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator12, null, corePath + "datatypes.html#" + t, sd.getTypeName(), null, null);
                    choicerow.getCells().add(c);
                    if (!mustSupportMode && this.isMustSupport(tr) && element.getMustSupport()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator13);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, " ", null));
                        c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
                    }
                } else {
                    List list = choicerow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, this.tail(element.getPath()).replace("[x]", Utilities.capitalize((String)t)), sd.getDescription(), null));
                    choicerow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    List list10 = choicerow.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator14);
                    list10.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator14, null, null, "", null, null));
                    choicerow.setIcon("icon_datatype.gif", "Data Type");
                    HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator15);
                    HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator15, null, this.context.getPkp().getLinkFor(corePath, t), sd.getTypeName(), null, null);
                    choicerow.getCells().add(c);
                    if (!mustSupportMode && this.isMustSupport(tr) && element.getMustSupport()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator16);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, " ", null));
                        c.addStyledText(this.translate("sd.table", "This type must be supported"), "S", "white", "red", null, false);
                    }
                }
                if (tr.hasProfile()) {
                    HierarchicalTableGenerator.Cell typeCell = (HierarchicalTableGenerator.Cell)choicerow.getCells().get(3);
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "(", null));
                    boolean first = true;
                    for (CanonicalType pt : tr.getProfile()) {
                        if (mustSupportMode && !this.allProfilesMustSupport(tr.getProfile()) && !this.isMustSupport(pt)) continue;
                        if (first) {
                            first = false;
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator17);
                            typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, null, " | ", null));
                        }
                        StructureDefinition psd = this.context.getWorker().fetchResource(StructureDefinition.class, (String)pt.getValue(), src);
                        if (psd == null) {
                            HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator18);
                            typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, null, "?gen-e2?", null));
                        } else {
                            HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator19);
                            typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, psd.getWebPath(), psd.getName(), psd.present()));
                        }
                        if (mustSupportMode || !this.isMustSupport(pt) || !element.getMustSupport()) continue;
                        HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator20);
                        typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, " ", null));
                        typeCell.addStyledText(this.translate("sd.table", "This profile must be supported"), "S", "white", "red", null, false);
                    }
                    HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator21);
                    typeCell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, ")", null));
                }
            }
            choicerow.getCells().add(new HierarchicalTableGenerator.Cell(gen));
            subRows.add(choicerow);
        }
    }

    private boolean isReference(String t) {
        return t.equals("Reference") || t.equals("canonical");
    }

    private List<ProfileUtilities.ElementChoiceGroup> readChoices(ElementDefinition ed, List<ElementDefinition> children) {
        ArrayList<ProfileUtilities.ElementChoiceGroup> result = new ArrayList<ProfileUtilities.ElementChoiceGroup>();
        for (ElementDefinition.ElementDefinitionConstraintComponent c : ed.getConstraint()) {
            ProfileUtilities.ElementChoiceGroup grp = this.context.getProfileUtilities().processConstraint(children, c);
            if (grp == null) continue;
            result.add(grp);
        }
        return result;
    }

    private HierarchicalTableGenerator.Piece checkForNoChange(Element src1, Element src2, HierarchicalTableGenerator.Piece piece) {
        if (src1.hasUserData("derivation.equals") && src2.hasUserData("derivation.equals")) {
            piece.addStyle("opacity: 0.5");
        }
        return piece;
    }

    private String buildJson(DataType value) throws IOException {
        if (value instanceof PrimitiveType) {
            return ((PrimitiveType)value).asStringValue();
        }
        JsonParser json = new JsonParser();
        return json.composeString(value, null);
    }

    private String describeSlice(ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        return this.translate("sd.table", "%s, %s by %s", new Object[]{slicing.getOrdered() ? this.translate("sd.table", "Ordered") : this.translate("sd.table", "Unordered"), this.describe(slicing.getRules()), this.commas(slicing.getDiscriminator())});
    }

    private String commas(List<ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent> list) {
        CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent id : list) {
            c.append((id.hasType() ? id.getType().toCode() : "??") + ":" + id.getPath());
        }
        return c.toString();
    }

    private String describe(ElementDefinition.SlicingRules rules) {
        if (rules == null) {
            return this.translate("sd.table", "Unspecified");
        }
        switch (rules) {
            case CLOSED: {
                return this.translate("sd.table", "Closed");
            }
            case OPEN: {
                return this.translate("sd.table", "Open");
            }
            case OPENATEND: {
                return this.translate("sd.table", "Open At End");
            }
        }
        return "?gen-sr?";
    }

    private boolean allTypesMustSupport(ElementDefinition e) {
        boolean all = true;
        boolean any = false;
        for (ElementDefinition.TypeRefComponent tr : e.getType()) {
            all = all && this.isMustSupport(tr);
            any = any || this.isMustSupport(tr);
        }
        return !all && !any;
    }

    private boolean allProfilesMustSupport(List<CanonicalType> profiles) {
        boolean all = true;
        boolean any = false;
        for (CanonicalType u : profiles) {
            all = all && this.isMustSupport(u);
            any = any || this.isMustSupport(u);
        }
        return !all && !any;
    }

    public boolean isMustSupportDirect(ElementDefinition.TypeRefComponent tr) {
        return "true".equals(ToolingExtensions.readStringExtension(tr, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"));
    }

    public boolean isMustSupport(ElementDefinition.TypeRefComponent tr) {
        if ("true".equals(ToolingExtensions.readStringExtension(tr, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) {
            return true;
        }
        if (this.isMustSupport(tr.getProfile())) {
            return true;
        }
        return this.isMustSupport(tr.getTargetProfile());
    }

    public boolean isMustSupport(List<CanonicalType> profiles) {
        for (CanonicalType ct : profiles) {
            if (!this.isMustSupport(ct)) continue;
            return true;
        }
        return false;
    }

    public boolean isMustSupport(CanonicalType profile) {
        return "true".equals(ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"));
    }

    private SpanEntry buildSpanEntryFromProfile(String name, String cardinality, StructureDefinition profile) throws IOException {
        SpanEntry res = new SpanEntry();
        res.setName(name);
        res.setCardinality(cardinality);
        res.setProfileLink(profile.getWebPath());
        res.setResType(profile.getTypeName());
        StructureDefinition base = this.context.getWorker().fetchResource(StructureDefinition.class, res.getResType());
        if (base != null) {
            res.setResLink(base.getWebPath());
        }
        res.setId(profile.getId());
        res.setProfile(profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT);
        StringBuilder b = new StringBuilder();
        b.append(res.getResType());
        boolean first = true;
        boolean open = false;
        if (profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            res.setDescription(profile.getName());
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                if (!this.isKeyProperty(ed.getBase().getPath()) || !ed.hasFixed()) continue;
                if (first) {
                    open = true;
                    first = false;
                    b.append("[");
                } else {
                    b.append(", ");
                }
                b.append(this.tail(ed.getBase().getPath()));
                b.append("=");
                b.append(this.summarize(ed.getFixed()));
            }
            if (open) {
                b.append("]");
            }
        } else {
            res.setDescription("Base FHIR " + profile.getName());
        }
        res.setType(b.toString());
        return res;
    }

    private String summarize(DataType value) throws IOException {
        if (value instanceof Coding) {
            return this.summarizeCoding((Coding)value);
        }
        if (value instanceof CodeableConcept) {
            return this.summarizeCodeableConcept((CodeableConcept)value);
        }
        return this.buildJson(value);
    }

    private String summarizeCoding(Coding value) {
        String uri = value.getSystem();
        String system = TerminologyRenderer.describeSystem(uri);
        if (Utilities.isURL((String)system) && system.equals("http://cap.org/protocols")) {
            system = "CAP Code";
        }
        return system + " " + value.getCode();
    }

    private String summarizeCodeableConcept(CodeableConcept value) {
        if (value.hasCoding()) {
            return this.summarizeCoding(value.getCodingFirstRep());
        }
        return value.getText();
    }

    private boolean isKeyProperty(String path) {
        return Utilities.existsInList((String)path, (String[])new String[]{"Observation.code"});
    }

    private HierarchicalTableGenerator.TableModel initSpanningTable(HierarchicalTableGenerator gen, String prefix, boolean isLogical, String id) throws IOException {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, true);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{prefix, "help16.png"}));
        }
        model.setDocoRef(Utilities.pathURL((String[])new String[]{prefix, "formats.html#table"}));
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), "Property", "A profiled resource", null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), "Card.", "Minimum and Maximum # of times the the element can appear in the instance", null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), "Content", "What goes here", null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), "Description", "Description of the profile", null, 0));
        return model;
    }

    private void genSpanEntry(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, SpanEntry span) throws IOException {
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        rows.add(row);
        row.setAnchor(span.getId());
        if (span.isProfile()) {
            row.setIcon("icon_profile.png", "Profile");
        } else {
            row.setIcon("icon_resource.png", "Resource");
        }
        List list = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, span.getName(), null, null));
        List list2 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, span.getCardinality(), null, null));
        List list3 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, span.getProfileLink(), span.getType(), null, null));
        List list4 = row.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, span.getDescription(), null, null));
        for (SpanEntry child : span.getChildren()) {
            this.genSpanEntry(gen, row.getSubRows(), child);
        }
    }

    public XhtmlNode generateSpanningTable(StructureDefinition profile, String imageFolder, boolean onlyConstraints, String constraintPrefix, Set<String> outputTracker) throws IOException, FHIRException {
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, false, true);
        gen.setTranslator(this.getTranslator());
        HierarchicalTableGenerator.TableModel model = this.initSpanningTable(gen, "", false, profile.getId());
        HashSet<String> processed = new HashSet<String>();
        SpanEntry span = this.buildSpanningTable("(focus)", "", profile, processed, onlyConstraints, constraintPrefix);
        this.genSpanEntry(gen, model.getRows(), span);
        return gen.generate(model, "", 0, outputTracker);
    }

    private SpanEntry buildSpanningTable(String name, String cardinality, StructureDefinition profile, Set<String> processed, boolean onlyConstraints, String constraintPrefix) throws IOException {
        SpanEntry res = this.buildSpanEntryFromProfile(name, cardinality, profile);
        boolean wantProcess = !processed.contains(profile.getUrl());
        processed.add(profile.getUrl());
        if (wantProcess && profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                StructureDefinition sd;
                String uri;
                List<String> refProfiles;
                String card;
                if ("0".equals(ed.getMax()) || ed.getType().size() <= 0 || (card = this.getCardinality(ed, profile.getSnapshot().getElement())).endsWith(".0") || (refProfiles = this.listReferenceProfiles(ed)).size() <= 0 || (uri = refProfiles.get(0)) == null || (sd = this.context.getWorker().fetchResource(StructureDefinition.class, uri)) == null || onlyConstraints && (sd.getDerivation() != StructureDefinition.TypeDerivationRule.CONSTRAINT || constraintPrefix != null && !sd.getUrl().startsWith(constraintPrefix))) continue;
                res.getChildren().add(this.buildSpanningTable(this.nameForElement(ed), card, sd, processed, onlyConstraints, constraintPrefix));
            }
        }
        return res;
    }

    private String getCardinality(ElementDefinition ed, List<ElementDefinition> list) {
        int min = ed.getMin();
        int max = !ed.hasMax() || ed.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(ed.getMax());
        ElementDefinition ned = ed;
        while (ned != null && ned.getPath().contains(".")) {
            if ((ned = this.findParent(ned, list)) == null) continue;
            if ("0".equals(ned.getMax())) {
                max = 0;
            } else if (!ned.getMax().equals("1") && !ned.hasSlicing()) {
                max = Integer.MAX_VALUE;
            }
            if (ned.getMin() != 0) continue;
            min = 0;
        }
        return Integer.toString(min) + ".." + (max == Integer.MAX_VALUE ? "*" : Integer.toString(max));
    }

    private ElementDefinition findParent(ElementDefinition ed, List<ElementDefinition> list) {
        int i;
        for (i = list.indexOf(ed) - 1; i >= 0 && !ed.getPath().startsWith(list.get(i).getPath() + "."); --i) {
        }
        if (i == -1) {
            return null;
        }
        return list.get(i);
    }

    private List<String> listReferenceProfiles(ElementDefinition ed) {
        ArrayList<String> res = new ArrayList<String>();
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (!tr.hasTarget() || !tr.hasTargetProfile()) continue;
            for (UriType uriType : tr.getTargetProfile()) {
                res.add((String)uriType.getValue());
            }
        }
        return res;
    }

    private String nameForElement(ElementDefinition ed) {
        return ed.getPath().substring(ed.getPath().indexOf(".") + 1);
    }

    public XhtmlNode formatTypeSpecifiers(ElementDefinition d) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean first = true;
        for (Extension e : d.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
            if (first) {
                first = false;
            } else {
                x.br();
            }
            String cond = ToolingExtensions.readStringExtension(e, "condition");
            String type = ToolingExtensions.readStringExtension(e, "type");
            x.tx("If ");
            x.code().tx(cond);
            x.tx(" then the type is ");
            StructureDefinition sd = this.context.getContext().fetchTypeDefinition(type);
            if (sd == null) {
                x.code().tx(type);
                continue;
            }
            x.ah(sd.getWebPath()).tx(sd.getTypeName());
        }
        return first ? null : x;
    }

    public XhtmlNode generateExtensionTable(String defFile, StructureDefinition ed, String imageFolder, boolean inlineGraphics, boolean full, String corePath, String imagePath, Set<String> outputTracker, RenderingContext rc) throws IOException, FHIRException {
        List<ElementDefinition> children;
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, inlineGraphics, true);
        gen.setTranslator(this.getTranslator());
        HierarchicalTableGenerator.TableModel model = gen.initNormalTable(corePath, false, true, ed.getId() + (full ? "f" : "n"), true, HierarchicalTableGenerator.TableGenerationMode.XHTML);
        boolean deep = false;
        String m = "";
        boolean vdeep = false;
        if (ed.getSnapshot().getElementFirstRep().getIsModifier()) {
            m = "modifier_";
        }
        for (ElementDefinition eld : ed.getSnapshot().getElement()) {
            deep = deep || eld.getPath().contains("Extension.extension.");
            vdeep = vdeep || eld.getPath().contains("Extension.extension.extension.");
        }
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        model.getRows().add(r);
        String en = !full ? ed.getName() : (ed.getSnapshot().getElement().get(0).getIsModifier() ? "modifierExtension" : "extension");
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, (String)(defFile == null ? "" : defFile + "-definitions.html#extension." + ed.getName()), en, null, null));
        r.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, this.describeCardinality(ed.getSnapshot().getElement().get(0), null, new UnusedTracker()), null, null));
        ElementDefinition ved = null;
        if (full || vdeep) {
            List list3 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, "", "", "Extension", null, null));
            r.setIcon((String)(deep ? "icon_" + m + "extension_complex.png" : "icon_extension_simple.png"), deep ? "Complex Extension" : "Simple Extension");
            children = this.getChildren(ed.getSnapshot().getElement(), ed.getSnapshot().getElement().get(0));
            for (ElementDefinition child : children) {
                if (child.getPath().endsWith(".id")) continue;
                ArrayList<StructureDefinition> sdl = new ArrayList<StructureDefinition>();
                sdl.add(ed);
                this.genElement((String)(defFile == null ? "" : defFile + "-definitions.html#extension."), gen, r.getSubRows(), child, ed.getSnapshot().getElement(), sdl, true, defFile, true, full, corePath, imagePath, true, false, false, false, null, false, rc, "", ed, null);
            }
        } else if (deep) {
            children = new ArrayList();
            for (ElementDefinition ted : ed.getSnapshot().getElement()) {
                if (!ted.getPath().equals("Extension.extension")) continue;
                children.add(ted);
            }
            List list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, "", "", "Extension", null, null));
            r.setIcon("icon_" + m + "extension_complex.png", "Complex Extension");
            for (ElementDefinition c : children) {
                ved = this.getValueFor(ed, c);
                ElementDefinition ued = this.getUrlFor(ed, c);
                if (ved == null || ued == null) continue;
                HierarchicalTableGenerator.Row r1 = new HierarchicalTableGenerator.Row(gen);
                r.getSubRows().add(r1);
                List list5 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, (String)(defFile == null ? "" : defFile + "-definitions.html#" + ed.getId() + "." + c.getId()), (String)((UriType)ued.getFixed()).getValue(), null, null));
                r1.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                List list6 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, this.describeCardinality(c, null, new UnusedTracker()), null, null));
                this.genTypes(gen, r1, ved, defFile, ed, corePath, imagePath, false, false);
                r1.setIcon("icon_" + m + "extension_simple.png", "Simple Extension");
                this.generateDescription(gen, r1, c, null, true, corePath, corePath, ed, corePath, imagePath, false, false, false, ved, false, false, false, rc);
            }
        } else {
            for (ElementDefinition ted : ed.getSnapshot().getElement()) {
                if (!ted.getPath().startsWith("Extension.value")) continue;
                ved = ted;
            }
            this.genTypes(gen, r, ved, defFile, ed, corePath, imagePath, false, false);
            r.setIcon("icon_" + m + "extension_simple.png", "Simple Extension");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator7);
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, "", "", "URL = " + ed.getUrl(), null, null);
        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator8);
        HierarchicalTableGenerator.Piece cc = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, ed.getName() + ": ", null);
        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator9);
        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "br")).addPiece(cc);
        c.addMarkdown(ed.getDescription());
        if (!full && !deep && !vdeep && ved != null && ved.hasBinding()) {
            HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator10);
            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, "br"));
            BindingResolution br = this.context.getPkp().resolveBinding(ed, ved.getBinding(), ved.getPath());
            List list7 = c.getPieces();
            ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent = ved.getBinding();
            HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator11);
            list7.add(this.checkForNoChange(elementDefinitionBindingComponent, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, this.translate("sd.table", "Binding") + ": ", null).addStyle("font-weight:bold")));
            List list8 = c.getPieces();
            ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent2 = ved.getBinding();
            HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator12);
            list8.add(this.checkForNoChange(elementDefinitionBindingComponent2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, br.url == null ? null : (Utilities.isAbsoluteUrl((String)br.url) || !this.context.getPkp().prependLinks() ? br.url : corePath + br.url), br.display, null)));
            if (ved.getBinding().hasStrength()) {
                List list9 = c.getPieces();
                ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent3 = ved.getBinding();
                HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator13);
                list9.add(this.checkForNoChange(elementDefinitionBindingComponent3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, " (", null)));
                List list10 = c.getPieces();
                ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent4 = ved.getBinding();
                HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator14);
                list10.add(this.checkForNoChange(elementDefinitionBindingComponent4, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, corePath + "terminologies.html#" + ved.getBinding().getStrength().toCode(), this.egt(ved.getBinding().getStrengthElement()), ved.getBinding().getStrength().getDefinition())));
                List list11 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator15);
                list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, null, ")", null));
            }
            if (ved.getBinding().hasDescription() && MarkDownProcessor.isSimpleMarkdown((String)ved.getBinding().getDescription())) {
                List list12 = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator16);
                list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, ": ", null));
                c.addMarkdownNoPara(PublicationHacker.fixBindingDescriptions(this.context.getWorker(), ved.getBinding().getDescriptionElement()).asStringValue());
            }
        }
        HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator17);
        HierarchicalTableGenerator.Cell cell = c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, "br"));
        HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator18);
        cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, null, ProfileUtilities.describeExtensionContext(ed), null));
        r.getCells().add(c);
        try {
            return gen.generate(model, corePath, 0, outputTracker);
        }
        catch (FHIRException e) {
            throw new FHIRException(e.getMessage(), (Throwable)e);
        }
    }

    private String describeCardinality(ElementDefinition definition, ElementDefinition fallback, UnusedTracker tracker) {
        StringType max;
        IntegerType min = definition.hasMinElement() ? definition.getMinElement() : new IntegerType();
        StringType stringType = max = definition.hasMaxElement() ? definition.getMaxElement() : new StringType();
        if (min.isEmpty() && fallback != null) {
            min = fallback.getMinElement();
        }
        if (max.isEmpty() && fallback != null) {
            max = fallback.getMaxElement();
        }
        boolean bl = tracker.used = !max.isEmpty() && !((String)max.getValue()).equals("0");
        if (min.isEmpty() && max.isEmpty()) {
            return null;
        }
        return (!min.hasValue() ? "" : Integer.toString((Integer)min.getValue())) + ".." + (!max.hasValue() ? "" : (String)max.getValue());
    }

    private ElementDefinition getValueFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + ".value")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    private ElementDefinition getUrlFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().equals(c.getPath() + ".url")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    public void renderDict(StructureDefinition sd, List<ElementDefinition> elements, XhtmlNode t, boolean incProfiledOut, int mode, String anchorPrefix) throws FHIRException, IOException {
        int i = 0;
        HashMap<String, ElementDefinition> allAnchors = new HashMap<String, ElementDefinition>();
        ArrayList<ElementDefinition> excluded = new ArrayList<ElementDefinition>();
        ArrayList<ElementDefinition> stack = new ArrayList<ElementDefinition>();
        for (ElementDefinition ec : elements) {
            this.addToStack(stack, ec);
            this.generateAnchors(stack, allAnchors);
            this.checkInScope(stack, excluded);
        }
        Stack<ElementDefinition> dstack = new Stack<ElementDefinition>();
        for (ElementDefinition ec : elements) {
            if (!(!incProfiledOut && "0".equals(ec.getMax()) || excluded.contains(ec))) {
                ElementDefinition compareElement = null;
                if (mode == 2) {
                    compareElement = this.getBaseElement(ec, sd.getBaseDefinition());
                } else if (mode == 4) {
                    compareElement = this.getRootElement(ec);
                }
                List<String> anchors = this.makeAnchors(ec, anchorPrefix);
                String title = ec.getId();
                XhtmlNode tr = t.tr();
                XhtmlNode sp = this.renderStatus(ec, tr.td("structure").colspan(2).spanClss("self-link-parent"));
                for (String s : anchors) {
                    sp.an(s).tx(" ");
                }
                sp.span("color: grey", null).tx(Integer.toString(i++));
                sp.b().tx(". " + title);
                this.link(sp, ec.getId(), anchorPrefix);
                if (this.isProfiledExtension(ec)) {
                    StructureDefinition extDefn = this.context.getContext().fetchResource(StructureDefinition.class, (String)ec.getType().get(0).getProfile().get(0).getValue());
                    if (extDefn == null) {
                        this.generateElementInner(t, sd, ec, 1, null, compareElement, null, false);
                    } else {
                        ElementDefinition valueDefn = this.getExtensionValueDefinition(extDefn);
                        ElementDefinition compareValueDefn = null;
                        try {
                            StructureDefinition compareExtDefn = this.context.getContext().fetchResource(StructureDefinition.class, (String)compareElement.getType().get(0).getProfile().get(0).getValue());
                            compareValueDefn = this.getExtensionValueDefinition(extDefn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.generateElementInner(t, sd, ec, valueDefn == null || valueDefn.prohibited() ? 2 : 3, valueDefn, compareElement, compareValueDefn, false);
                    }
                } else {
                    while (!dstack.isEmpty() && !this.isParent((ElementDefinition)dstack.peek(), ec)) {
                        this.finish(t, sd, (ElementDefinition)dstack.pop(), mode);
                    }
                    dstack.push(ec);
                    this.generateElementInner(t, sd, ec, mode, null, compareElement, null, false);
                    if (ec.hasSlicing()) {
                        this.generateSlicing(t, sd, ec, ec.getSlicing(), compareElement, mode, false);
                    }
                }
            }
            t.tx("\r\n");
            ++i;
        }
        while (!dstack.isEmpty()) {
            this.finish(t, sd, (ElementDefinition)dstack.pop(), mode);
        }
        this.finish(t, sd, null, mode);
    }

    private void finish(XhtmlNode t, StructureDefinition sd, ElementDefinition ed, int mode) throws FHIRException, IOException {
        for (Base b : VersionComparisonAnnotation.getDeleted(ed == null ? sd : ed, "element")) {
            ElementDefinition ec = (ElementDefinition)b;
            String title = ec.getId();
            XhtmlNode tr = t.tr();
            XhtmlNode sp = this.renderStatus(ec, tr.td("structure").colspan(2).spanClss("self-link-parent"));
            sp.span("color: grey", null).tx("--");
            sp.b().tx(". " + title);
            this.generateElementInner(t, sd, ec, mode, null, null, null, true);
            if (!ec.hasSlicing()) continue;
            this.generateSlicing(t, sd, ec, ec.getSlicing(), null, mode, true);
        }
    }

    public ElementDefinition getElementById(String url, String id) {
        Map<String, ElementDefinition> sdCache = this.sdMapCache.get(url);
        if (sdCache == null) {
            StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, url);
            if (sd == null) {
                if (url.equals("http://hl7.org/fhir/StructureDefinition/Base")) {
                    sd = this.context.getContext().fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/Element");
                }
                if (sd == null) {
                    throw new FHIRException("Unable to retrieve StructureDefinition with URL " + url);
                }
            }
            sdCache = new HashMap<String, ElementDefinition>();
            this.sdMapCache.put(url, sdCache);
            String webroot = sd.getUserString("webroot");
            for (ElementDefinition e : sd.getSnapshot().getElement()) {
                this.context.getProfileUtilities().updateURLs(sd.getUrl(), webroot, e);
                sdCache.put(e.getId(), e);
            }
        }
        return sdCache.get(id);
    }

    private ElementDefinition getBaseElement(ElementDefinition e, String url) {
        if (e.hasUserData("derived.pointer")) {
            return this.getElementById(url, e.getUserString("derived.pointer"));
        }
        return null;
    }

    private ElementDefinition getRootElement(ElementDefinition e) {
        if (!e.hasBase()) {
            return null;
        }
        String basePath = e.getBase().getPath();
        String url = "http://hl7.org/fhir/StructureDefinition/" + (basePath.contains(".") ? basePath.substring(0, basePath.indexOf(".")) : basePath);
        try {
            return this.getElementById(url, basePath);
        }
        catch (FHIRException except) {
            return null;
        }
    }

    private void checkInScope(List<ElementDefinition> stack, List<ElementDefinition> excluded) {
        if (stack.size() > 2) {
            ElementDefinition parent = stack.get(stack.size() - 2);
            ElementDefinition focus = stack.get(stack.size() - 1);
            if (excluded.contains(parent) || "0".equals(parent.getMax())) {
                excluded.add(focus);
            }
        }
    }

    private void generateAnchors(List<ElementDefinition> stack, Map<String, ElementDefinition> allAnchors) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(stack.get(0).getId());
        for (int i = 1; i < stack.size(); ++i) {
            ElementDefinition ed = stack.get(i);
            ArrayList<Object> aliases = new ArrayList<Object>();
            String name = this.tail(ed.getPath());
            if (name.endsWith("[x]")) {
                aliases.add(name);
                HashSet<String> tl = new HashSet<String>();
                for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                    String tc = tr.getWorkingCode();
                    if (tl.contains(tc)) continue;
                    aliases.add(name.replace("[x]", Utilities.capitalize((String)tc)));
                    aliases.add(name + ":" + name.replace("[x]", Utilities.capitalize((String)tc)));
                    tl.add(tc);
                }
            } else if (ed.hasSliceName()) {
                aliases.add(name + ":" + ed.getSliceName());
            } else {
                aliases.add(name);
            }
            ArrayList<CallSite> generated = new ArrayList<CallSite>();
            for (String l : list) {
                for (String string : aliases) {
                    generated.add((CallSite)((Object)(l + "." + string)));
                }
            }
            list.clear();
            list.addAll(generated);
        }
        ElementDefinition ed = stack.get(stack.size() - 1);
        ArrayList<String> removed = new ArrayList<String>();
        for (String s : list) {
            if (!allAnchors.containsKey(s)) {
                allAnchors.put(s, ed);
                continue;
            }
            if (s.endsWith("[x]")) {
                removed.add(s);
                continue;
            }
            List other = (List)allAnchors.get(s).getUserData("dict.generator.anchors");
            other.remove(s);
            allAnchors.put(s, ed);
        }
        list.removeAll(removed);
        ed.setUserData("dict.generator.anchors", list);
    }

    private void addToStack(List<ElementDefinition> stack, ElementDefinition ec) {
        while (!stack.isEmpty() && !this.isParent(stack.get(stack.size() - 1), ec)) {
            stack.remove(stack.size() - 1);
        }
        stack.add(ec);
    }

    private boolean isParent(ElementDefinition ed, ElementDefinition ec) {
        return ec.getPath().startsWith(ed.getPath() + ".");
    }

    private List<String> makeAnchors(ElementDefinition ed, String anchorPrefix) {
        List list = (List)ed.getUserData("dict.generator.anchors");
        ArrayList<String> res = new ArrayList<String>();
        res.add(anchorPrefix + ed.getId());
        for (String s : list) {
            if (s.equals(ed.getId())) continue;
            res.add(anchorPrefix + s);
        }
        return res;
    }

    private void link(XhtmlNode x, String id, String anchorPrefix) {
        XhtmlNode ah = x.ah("#" + anchorPrefix + id);
        ah.attribute("title", "link to here");
        ah.attribute("class", "self-link");
        XhtmlNode svg = ah.svg();
        svg.attribute("viewBox", "0 0 1792 1792");
        svg.attribute("width", "16");
        svg.attribute("height", "16");
        svg.attribute("class", "self-link");
        svg.path("M1520 1216q0-40-28-68l-208-208q-28-28-68-28-42 0-72 32 3 3 19 18.5t21.5 21.5 15 19 13 25.5 3.5 27.5q0 40-28 68t-68 28q-15 0-27.5-3.5t-25.5-13-19-15-21.5-21.5-18.5-19q-33 31-33 73 0 40 28 68l206 207q27 27 68 27 40 0 68-26l147-146q28-28 28-67zm-703-705q0-40-28-68l-206-207q-28-28-68-28-39 0-68 27l-147 146q-28 28-28 67 0 40 28 68l208 208q27 27 68 27 42 0 72-31-3-3-19-18.5t-21.5-21.5-15-19-13-25.5-3.5-27.5q0-40 28-68t68-28q15 0 27.5 3.5t25.5 13 19 15 21.5 21.5 18.5 19q33-31 33-73zm895 705q0 120-85 203l-147 146q-83 83-203 83-121 0-204-85l-206-207q-83-83-83-203 0-123 88-209l-88-88q-86 88-208 88-120 0-204-84l-208-208q-84-84-84-204t85-203l147-146q83-83 203-83 121 0 204 85l206 207q83 83 83 203 0 123-88 209l88 88q86-88 208-88 120 0 204 84l208 208q84 84 84 204z");
    }

    private boolean isProfiledExtension(ElementDefinition ec) {
        return ec.getType().size() == 1 && "Extension".equals(ec.getType().get(0).getWorkingCode()) && ec.getType().get(0).hasProfile();
    }

    private ElementDefinition getExtensionValueDefinition(StructureDefinition extDefn) {
        for (ElementDefinition ed : extDefn.getSnapshot().getElement()) {
            if (!ed.getPath().startsWith("Extension.value")) continue;
            return ed;
        }
        return null;
    }

    public XhtmlNode compareMarkdown(String location, PrimitiveType md, PrimitiveType compare, int mode) throws FHIRException, IOException {
        XhtmlNode div;
        String xhtml;
        if (compare == null || mode == 2) {
            if (md.hasValue()) {
                String xhtml2 = this.hostMd.processMarkdown(location, md);
                if (Utilities.noString((String)xhtml2)) {
                    return null;
                }
                XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
                try {
                    this.renderStatusDiv(md, x).add(new XhtmlParser().parseFragment(xhtml2));
                }
                catch (Exception e) {
                    x.span("color: maroon").tx(e.getLocalizedMessage());
                }
                return x;
            }
            return null;
        }
        if (this.areEqual(compare, md)) {
            if (md.hasValue()) {
                String xhtml3 = "<div>" + this.hostMd.processMarkdown(location, md) + "</div>";
                XhtmlNode div2 = new XhtmlParser().parseFragment(xhtml3);
                for (XhtmlNode n : div2.getChildNodes()) {
                    if (n.getNodeType() != NodeType.Element) continue;
                    n.style(this.unchangedStyle());
                }
                return div2;
            }
            return null;
        }
        XhtmlNode ndiv = new XhtmlNode(NodeType.Element, "div");
        if (md.hasValue()) {
            xhtml = "<div>" + this.hostMd.processMarkdown(location, md) + "</div>";
            div = new XhtmlParser().parseFragment(xhtml);
            ndiv.copyAllContent(div);
        }
        if (compare.hasValue()) {
            xhtml = "<div>" + this.hostMd.processMarkdown(location, compare) + "</div>";
            div = new XhtmlParser().parseFragment(xhtml);
            for (XhtmlNode n : div.getChildNodes()) {
                if (n.getNodeType() != NodeType.Element) continue;
                n.style(this.removedStyle());
            }
            ndiv.br();
            ndiv.copyAllContent(div);
        }
        return ndiv;
    }

    private boolean areEqual(PrimitiveType compare, PrimitiveType md) {
        if (compare == null && md == null) {
            return true;
        }
        if (compare != null && md != null) {
            String one = compare.getValueAsString();
            String two = md.getValueAsString();
            if (one == null && two == null) {
                return true;
            }
            if (one != null && one.equals(two)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XhtmlNode compareString(String newStr, Base source, String nLink, String name, Base parent, String oldStr, String oLink, int mode) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        if (mode != 4) {
            if (newStr != null) {
                this.renderStatus(source, x).ah(nLink).tx(newStr);
                return x;
            } else {
                if (!VersionComparisonAnnotation.hasDeleted(parent, name)) return null;
                PrimitiveType p = (PrimitiveType)VersionComparisonAnnotation.getDeletedItem(parent, name);
                this.renderStatus(p, x).tx(p.primitiveValue());
            }
            return x;
        } else if (oldStr == null || oldStr.isEmpty()) {
            if (newStr == null || newStr.isEmpty()) {
                return null;
            }
            this.renderStatus(source, x).ah(nLink).tx(newStr);
            return x;
        } else if (oldStr != null && !oldStr.isEmpty() && (newStr == null || newStr.isEmpty())) {
            if (mode == 2) {
                return null;
            }
            this.removed(x).ah(oLink).tx(oldStr);
            return x;
        } else if (oldStr.equals(newStr)) {
            if (mode == 2) {
                return null;
            }
            this.unchanged(x).ah(nLink).tx(newStr);
            return x;
        } else if (newStr.startsWith(oldStr)) {
            this.unchanged(x).ah(oLink).tx(oldStr);
            this.renderStatus(source, x).ah(nLink).tx(newStr.substring(oldStr.length()));
            return x;
        } else {
            this.renderStatus(source, x).ah(nLink).tx(newStr);
            this.removed(x).ah(oLink).tx(oldStr);
        }
        return x;
    }

    public boolean compareString(XhtmlNode x, String newStr, Base source, String nLink, String name, Base parent, String oldStr, String oLink, int mode) {
        XhtmlNode x1 = this.compareString(newStr, source, nLink, name, parent, oldStr, oLink, mode);
        if (x1 == null) {
            return false;
        }
        x.getChildNodes().addAll((Collection)x1.getChildNodes());
        return true;
    }

    public XhtmlNode unchanged(XhtmlNode x) {
        return x.span(this.unchangedStyle());
    }

    private String unchangedStyle() {
        return "color:DarkGray";
    }

    public XhtmlNode removed(XhtmlNode x) {
        return x.span(this.removedStyle());
    }

    private String removedStyle() {
        return "color:DarkGray;text-decoration:line-through";
    }

    private void generateElementInner(XhtmlNode tbl, StructureDefinition sd, ElementDefinition d, int mode, ElementDefinition value, ElementDefinition compare, ElementDefinition compareValue, boolean strikethrough) throws FHIRException, IOException {
        String ide;
        String es;
        boolean slicedExtension;
        boolean root = !d.getPath().contains(".");
        boolean bl = slicedExtension = d.hasSliceName() && (d.getPath().endsWith(".extension") || d.getPath().endsWith(".modifierExtension"));
        if (d.hasSliceName()) {
            this.tableRow(tbl, "Slice Name", "profiling.html#slicing", strikethrough, this.compareString(d.getSliceName(), d.getSliceNameElement(), null, compare != null ? compare.getSliceName() : null, d, null, "sliceName", mode));
            this.tableRow(tbl, "Slice Constraining", "profiling.html#slicing", strikethrough, this.compareString(this.encodeValue(d.getSliceIsConstrainingElement()), d.getSliceIsConstrainingElement(), null, compare != null ? this.encodeValue(compare.getSliceIsConstrainingElement()) : null, d, null, "sliceName", mode));
        }
        this.tableRow(tbl, "Definition", null, strikethrough, this.compareMarkdown(sd.getName(), d.getDefinitionElement(), compare == null || slicedExtension ? null : compare.getDefinitionElement(), mode));
        this.tableRow(tbl, "Short", null, strikethrough, this.compareString(d.hasShort() ? d.getShort() : null, d.getShortElement(), null, "short", d, compare != null && compare.hasShortElement() ? compare.getShort() : null, null, mode));
        this.tableRow(tbl, "Comments", null, strikethrough, this.compareMarkdown(sd.getName(), d.getCommentElement(), compare == null || slicedExtension ? null : compare.getCommentElement(), mode));
        this.tableRow(tbl, "Note", null, strikethrough, this.businessIdWarning(sd.getName(), this.tail(d.getPath())));
        this.tableRow(tbl, "Control", "conformance-rules.html#conformance", strikethrough, this.describeCardinality(d, compare, mode));
        this.tableRow(tbl, "Binding", "terminologies.html", strikethrough, this.describeBinding(sd, d, d.getPath(), compare, mode));
        if (d.hasContentReference()) {
            this.tableRow(tbl, "Type", null, strikethrough, "See " + d.getContentReference().substring(1));
        } else {
            this.tableRow(tbl, "Type", "datatypes.html", strikethrough, this.describeTypes(d.getType(), false, d, compare, mode, value, compareValue, sd));
        }
        if (d.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype")) {
            this.tableRow(tbl, "Default Type", "datatypes.html", strikethrough, ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype"));
        }
        if (d.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
            this.tableRow(tbl, Utilities.pluralize((String)"Type Specifier", (int)d.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-specifier").size()), "datatypes.html", strikethrough, this.formatTypeSpecifiers(d));
        }
        if (d.getPath().endsWith("[x]") && !d.prohibited()) {
            this.tableRow(tbl, "[x] Note", null, strikethrough).ahWithText("See ", this.spec("formats.html#choice"), null, "Choice of Data Types", " for further information about how to use [x]");
        }
        this.tableRow(tbl, "Is Modifier", "conformance-rules.html#ismodifier", strikethrough, this.presentModifier(d, mode, compare));
        if (d.getMustHaveValue()) {
            this.tableRow(tbl, "Primitive Value", "elementdefinition.html#primitives", strikethrough, "This primitive type must have a value (the value must be present, and cannot be replaced by an extension)");
        } else if (d.hasValueAlternatives()) {
            this.tableRow(tbl, "Primitive Value", "elementdefinition.html#primitives", strikethrough, this.renderCanonicalList("This primitive type may be present, or absent if replaced by one of the following extensions: ", d.getValueAlternatives()));
        } else if (this.hasPrimitiveTypes(d)) {
            this.tableRow(tbl, "Primitive Value", "elementdefinition.html#primitives", strikethrough, "This primitive element may be present, or absent, or replaced by an extension");
        }
        if (ToolingExtensions.hasAllowedUnits(d)) {
            this.tableRow(tbl, "Allowed Units", "http://hl7.org/fhir/extensions/StructureDefinition-elementdefinition-allowedUnits.html", strikethrough, this.describeAllowedUnits(d));
        }
        this.tableRow(tbl, "Must Support", "conformance-rules.html#mustSupport", strikethrough, this.displayBoolean(d.getMustSupport(), d.getMustSupportElement(), "mustSupport", d, compare == null ? null : compare.getMustSupportElement(), mode));
        if (d.getMustSupport()) {
            if (this.hasMustSupportTypes(d.getType())) {
                this.tableRow(tbl, "Must Support Types", "datatypes.html", strikethrough, this.describeTypes(d.getType(), true, d, compare, mode, null, null, sd));
            } else if (this.hasChoices(d.getType())) {
                this.tableRow(tbl, "Must Support Types", "datatypes.html", strikethrough, "No must-support rules about the choice of types/profiles");
            }
        }
        if (root && sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
            this.tableRow(tbl, "Logical Model", null, strikethrough, ToolingExtensions.readBoolExtension(sd, "http://hl7.org/fhir/tools/StructureDefinition/logical-target") ? "This logical model can be the target of a reference" : "This logical model cannot be the target of a reference");
        }
        if (root && sd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")) {
            this.tableRow(tbl, "Impose Profile", "http://hl7.org/fhir/extensions/StructureDefinition-structuredefinition-imposeProfile.html", strikethrough, this.renderCanonicalListExt("This profile also requires that the instance also conform this additional profile: ", sd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")));
        }
        if (root && sd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile")) {
            this.tableRow(tbl, "Complies with Profile", "http://hl7.org/fhir/extensions/StructureDefinition-structuredefinition-compliesWithProfile.html", strikethrough, this.renderCanonicalListExt("This profile compiles with the profile ", sd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile")));
        }
        this.tableRow(tbl, "Obligations", null, strikethrough, this.describeObligations(d, root, sd));
        if (d.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-extension-style") && "named-elements".equals(es = d.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-extension-style"))) {
            if (this.context.hasLink(RenderingContext.KnownLinkType.JSON_NAMES)) {
                this.tableRow(tbl, "Extension Style", this.context.getLink(RenderingContext.KnownLinkType.JSON_NAMES), strikethrough, "This element can be extended by named JSON elements");
            } else {
                this.tableRow(tbl, "Extension Style", "http://build.fhir.org/ig/FHIR/fhir-tools-ig/format-extensions.html#extension-related-extensions", strikethrough, "This element can be extended by named JSON elements");
            }
        }
        if (!d.getPath().contains(".") && ToolingExtensions.hasExtension(sd, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style")) {
            this.tableRow(tbl, "Binding Style", "http://build.fhir.org/ig/FHIR/fhir-tools-ig/StructureDefinition-binding-style.html", strikethrough, "This type can be bound to a value set using the " + ToolingExtensions.readStringExtension(sd, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style") + " binding style");
        }
        if (d.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format")) {
            this.tableRow(tbl, "Date Format", null, strikethrough, ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format"));
        }
        if ((ide = ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/tools/StructureDefinition/id-expectation")) != null) {
            if (ide.equals("optional")) {
                this.tableRow(tbl, "ID Expectation", null, strikethrough, "Id may or not be present (this is the default for elements but not resources)");
            } else if (ide.equals("required")) {
                this.tableRow(tbl, "ID Expectation", null, strikethrough, "Id is required to be present (this is the default for resources but not elements)");
            } else if (ide.equals("required")) {
                this.tableRow(tbl, "ID Expectation", null, strikethrough, "An ID is not allowed in this context");
            }
        }
        if (ToolingExtensions.hasExtensions(d, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior", "http://hl7.org/fhir/tools/StructureDefinition/json-property-key", "http://hl7.org/fhir/tools/StructureDefinition/json-nullable", "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name", "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice")) {
            this.tableRow(tbl, "JSON Format", null, strikethrough, this.describeJson(d));
        }
        if (d.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace") || sd.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace") || d.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name") || root && sd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order") || d.hasRepresentation()) {
            this.tableRow(tbl, "XML Format", null, strikethrough, this.describeXml(sd, d, root));
        }
        if (d.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix")) {
            this.tableRow(tbl, "String Format", null, strikethrough).codeWithText("When this element is read ", ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix"), "is prefixed to the value before validation");
        }
        if (d.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status")) {
            StandardsStatus ss = StandardsStatus.fromCode((String)d.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"));
            StructureDefinition sdb = this.context.getContext().fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (sdb != null) {
                StandardsStatus base = this.determineStandardsStatus(sdb, (ElementDefinition)d.getUserData("derived.pointer"));
                if (base != null) {
                    this.tableRow(tbl, "Standards Status", "versions.html#std-process", strikethrough, ss.toDisplay() + " (from " + base.toDisplay() + ")");
                } else {
                    this.tableRow(tbl, "Standards Status", "versions.html#std-process", strikethrough, ss.toDisplay());
                }
            } else {
                this.tableRow(tbl, "Standards Status", "versions.html#std-process", strikethrough, ss.toDisplay());
            }
        }
        if (mode != 2 && d.hasIsSummary()) {
            this.tableRow(tbl, "Summary", "search.html#summary", strikethrough, Boolean.toString(d.getIsSummary()));
        }
        this.tableRow(tbl, "Requirements", null, strikethrough, this.compareMarkdown(sd.getName(), d.getRequirementsElement(), compare == null || slicedExtension ? null : compare.getRequirementsElement(), mode));
        this.tableRow(tbl, "Label", null, strikethrough, this.compareString(d.getLabel(), d.getLabelElement(), null, "label", d, compare != null ? compare.getLabel() : null, null, mode));
        this.tableRow(tbl, "Alternate Names", null, strikethrough, this.compareSimpleTypeLists(d.getAlias(), compare == null || slicedExtension ? null : compare.getAlias(), mode));
        this.tableRow(tbl, "Definitional Codes", null, strikethrough, this.compareDataTypeLists(d.getCode(), compare == null || slicedExtension ? null : compare.getCode(), mode));
        this.tableRow(tbl, "Min Value", null, strikethrough, this.compareString(d.hasMinValue() ? this.encodeValue(d.getMinValue()) : null, d.getMinValue(), null, "minValue", d, compare != null && compare.hasMinValue() ? this.encodeValue(compare.getMinValue()) : null, null, mode));
        this.tableRow(tbl, "Max Value", null, strikethrough, this.compareString(d.hasMaxValue() ? this.encodeValue(d.getMaxValue()) : null, d.getMaxValue(), null, "maxValue", d, compare != null && compare.hasMaxValue() ? this.encodeValue(compare.getMaxValue()) : null, null, mode));
        this.tableRow(tbl, "Max Length", null, strikethrough, this.compareString(d.hasMaxLength() ? this.toStr(d.getMaxLength()) : null, d.getMaxLengthElement(), null, "maxLength", d, compare != null && compare.hasMaxLengthElement() ? this.toStr(compare.getMaxLength()) : null, null, mode));
        this.tableRow(tbl, "Value Required", null, strikethrough, this.compareString(this.encodeValue(d.getMustHaveValueElement()), d.getMustHaveValueElement(), null, compare != null ? this.encodeValue(compare.getMustHaveValueElement()) : null, d, null, "mustHaveValueElement", mode));
        this.tableRow(tbl, "Value Alternatives", null, strikethrough, this.compareSimpleTypeLists(d.getValueAlternatives(), compare == null || slicedExtension ? null : compare.getValueAlternatives(), mode));
        this.tableRow(tbl, "Default Value", null, strikethrough, this.encodeValue(d.getDefaultValue(), "defaultValue", d, compare == null ? null : compare.getDefaultValue(), mode));
        this.tableRow(tbl, "Meaning if Missing", null, strikethrough, d.getMeaningWhenMissing());
        this.tableRow(tbl, "Fixed Value", null, strikethrough, this.encodeValue(d.getFixed(), "fixed", d, compare == null ? null : compare.getFixed(), mode));
        this.tableRow(tbl, "Pattern Value", null, strikethrough, this.encodeValue(d.getPattern(), "pattern", d, compare == null ? null : compare.getPattern(), mode));
        this.tableRow(tbl, "Example", null, strikethrough, this.encodeValues(d.getExample()));
        this.tableRow(tbl, "Invariants", null, strikethrough, this.invariants(d.getConstraint(), compare == null ? null : compare.getConstraint(), d, mode));
        this.tableRow(tbl, "LOINC Code", null, strikethrough, this.getMapping(sd, d, LOINC_MAPPING, compare, mode));
        this.tableRow(tbl, "SNOMED-CT Code", null, strikethrough, this.getMapping(sd, d, SNOMED_MAPPING, compare, mode));
        tbl.tx("\r\n");
    }

    private XhtmlNode presentModifier(ElementDefinition d, int mode, ElementDefinition compare) throws FHIRException, IOException {
        XhtmlNode x2;
        XhtmlNode x1 = this.compareString(this.encodeValue(d.getIsModifierElement()), d.getIsModifierElement(), null, "isModifier", d, compare == null ? null : this.encodeValue(compare.getIsModifierElement()), null, mode);
        if (x1 != null && (x2 = this.compareString(this.encodeValue(d.getIsModifierReasonElement()), d.getIsModifierReasonElement(), null, "isModifierReason", d, compare == null ? null : this.encodeValue(compare.getIsModifierReasonElement()), null, mode)) != null) {
            x1.tx(" because ");
            x1.copyAllContent(x2);
        }
        return x1;
    }

    private String spec(String name) {
        return Utilities.pathURL((String[])new String[]{VersionUtilities.getSpecUrl((String)this.context.getWorker().getVersion()), name});
    }

    private XhtmlNode describeXml(StructureDefinition profile, ElementDefinition d, boolean root) {
        boolean no;
        XhtmlNode ret = new XhtmlNode(NodeType.Element, "div");
        block7: for (ElementDefinition.PropertyRepresentation pr : ElementDefinition.PropertyRepresentation.values()) {
            if (!d.hasRepresentation(pr)) continue;
            switch (pr) {
                case CDATEXT: {
                    ret.tx("This property is represented as CDA Text in the XML.");
                    continue block7;
                }
                case TYPEATTR: {
                    ret.codeWithText("The type of this property is determined using the ", "xsi:type", "attribute.");
                    continue block7;
                }
                case XHTML: {
                    ret.tx("This property is represented as XHTML Text in the XML.");
                    continue block7;
                }
                case XMLATTR: {
                    ret.tx("In the XML format, this property is represented as an attribute.");
                    continue block7;
                }
                case XMLTEXT: {
                    ret.tx("In the XML format, this property is represented as unadorned text.");
                    continue block7;
                }
            }
        }
        String name = ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        if (name == null && root) {
            name = ToolingExtensions.readStringExtension(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        }
        if (name != null) {
            ret.codeWithText("In the XML format, this property has the namespace ", name, ".");
        }
        if ((name = ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name")) != null) {
            ret.codeWithText("In the XML format, this property has the actual name", name, ".");
        }
        boolean bl = no = root && ToolingExtensions.readBoolExtension(profile, "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order");
        if (no) {
            ret.tx("The children of this property can appear in any order in the XML.");
        }
        return ret;
    }

    private XhtmlNode describeJson(ElementDefinition d) {
        String jn;
        XhtmlNode ret = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode ul = ret.ul();
        boolean list = ToolingExtensions.countExtensions(d, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior", "http://hl7.org/fhir/tools/StructureDefinition/json-property-key", "http://hl7.org/fhir/tools/StructureDefinition/json-nullable", "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name") > 1;
        String code = ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior");
        if (code != null) {
            switch (code) {
                case "present": {
                    ul.li().tx("The JSON Array for this property is present even when there are no items in the instance (e.g. as an empty array)");
                    break;
                }
                case "absent": {
                    ul.li().tx("The JSON Array for this property is not present when there are no items in the instance (e.g. never as an empty array)");
                    break;
                }
                case "either": {
                    ul.li().tx("The JSON Array for this property may be present even when there are no items in the instance (e.g. may be present as an empty array)");
                }
            }
        }
        if ((jn = ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name")) != null) {
            if (d.getPath().contains(".")) {
                ul.li().codeWithText("This property appears in JSON with the property name ", jn, null);
            } else {
                ul.li().codeWithText("This type can appear in JSON with the property name ", jn, " (in elements using named extensions)");
            }
        }
        if ((code = ToolingExtensions.readStringExtension(d, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key")) != null) {
            ul.li().codeWithText("This repeating object is represented as a single JSON object with named properties. The name of the property (key) is the value of the ", code, " child");
        }
        if (ToolingExtensions.readBoolExtension(d, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable")) {
            ul.li().tx("This object can be represented as null in the JSON structure (which counts as 'present' for cardinality purposes)");
        }
        if (ToolingExtensions.readBoolExtension(d, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice")) {
            ul.li().tx("The type of this element is inferred from the JSON type in the instance");
        }
        switch (ul.getChildNodes().size()) {
            case 0: {
                return null;
            }
            case 1: {
                return ul.getChildNodes().get(0);
            }
        }
        return ret;
    }

    private XhtmlNode describeObligations(ElementDefinition d, boolean root, StructureDefinition sdx) throws IOException {
        XhtmlNode ret = new XhtmlNode(NodeType.Element, "div");
        ObligationsRenderer obr = new ObligationsRenderer(this.corePath, sdx, d.getPath(), this.context, this.hostMd, this);
        obr.seeObligations(d.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation"));
        obr.seeRootObligations(d.getId(), sdx.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation"));
        if (obr.hasObligations() || root && (sdx.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/obligation-profile") || sdx.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations"))) {
            XhtmlNode ul = ret.ul();
            if (root) {
                if (sdx.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/obligation-profile")) {
                    ul.li().tx("This is an obligation profile that only contains obligations and additional bindings");
                }
                for (Extension ext : sdx.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations")) {
                    String iu = ext.getValue().primitiveValue();
                    XhtmlNode bb = ul.li();
                    bb.tx("This profile picks up obligations and additional bindings from ");
                    StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, iu);
                    if (sd == null) {
                        bb.code().tx(iu);
                        continue;
                    }
                    if (sd.hasWebPath()) {
                        bb.ah(sd.getWebPath()).tx(sd.present());
                        continue;
                    }
                    bb.ah(iu).tx(sd.present());
                }
                if (ul.isEmpty()) {
                    ret.remove(ul);
                }
            }
            if (obr.hasObligations()) {
                XhtmlNode tbl = ret.table("grid");
                obr.renderTable((List<XhtmlNode>)tbl.getChildNodes(), true);
                if (tbl.isEmpty()) {
                    ret.remove(tbl);
                }
            }
            return ret.hasChildren() ? ret : null;
        }
        return null;
    }

    private XhtmlNode describeAllowedUnits(ElementDefinition d) {
        XhtmlNode ret = new XhtmlNode(NodeType.Element, "div");
        DataType au = ToolingExtensions.getAllowedUnits(d);
        if (au instanceof CanonicalType) {
            String url = ((CanonicalType)au).asStringValue();
            ValueSet vs = this.context.getContext().fetchResource(ValueSet.class, url);
            ret.tx("Value set ");
            this.genCT(ret, url, vs);
            return ret;
        }
        if (au instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)au;
            if (cc.getCoding().size() != 1) {
                ret.tx("One of:");
            }
            ret.tx(this.summarise(cc));
            return ret;
        }
        return null;
    }

    private void genCT(XhtmlNode x, String url, CanonicalResource cr) {
        if (cr == null) {
            x.code().tx(url);
        } else if (!cr.hasWebPath()) {
            x.ah(url).tx(cr.present());
        } else {
            x.ah(cr.getWebPath()).tx(cr.present());
        }
    }

    private boolean hasPrimitiveTypes(ElementDefinition d) {
        for (ElementDefinition.TypeRefComponent tr : d.getType()) {
            if (!this.isPrimitive(tr.getCode())) continue;
            return true;
        }
        return false;
    }

    private XhtmlNode renderCanonicalListExt(String text, List<Extension> list) {
        ArrayList<CanonicalType> clist = new ArrayList<CanonicalType>();
        for (Extension ext : list) {
            if (!ext.hasValueCanonicalType()) continue;
            clist.add(ext.getValueCanonicalType());
        }
        return this.renderCanonicalList(text, clist);
    }

    private XhtmlNode renderCanonicalList(String text, List<CanonicalType> list) {
        XhtmlNode ret = new XhtmlNode(NodeType.Element, "div");
        ret.tx(text);
        XhtmlNode ul = ret.ul();
        for (CanonicalType ct : list) {
            CanonicalResource cr = (CanonicalResource)this.context.getContext().fetchResource(Resource.class, (String)ct.getValue());
            this.genCT(ul.li(), (String)ct.getValue(), cr);
        }
        return ret;
    }

    private StandardsStatus determineStandardsStatus(StructureDefinition sd, ElementDefinition ed) {
        if (ed != null && ed.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status")) {
            return StandardsStatus.fromCode((String)ed.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"));
        }
        while (sd != null) {
            if (sd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status")) {
                return ToolingExtensions.getStandardsStatus(sd);
            }
            sd = this.context.getContext().fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return null;
    }

    private boolean hasChoices(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent type : types) {
            if (type.getProfile().size() <= 1 && type.getTargetProfile().size() <= 1) continue;
            return true;
        }
        return types.size() > 1;
    }

    private String sliceOrderString(ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        if (slicing.getOrdered()) {
            return "ordered";
        }
        return "unordered";
    }

    private void generateSlicing(XhtmlNode tbl, StructureDefinition profile, ElementDefinition ed, ElementDefinition.ElementDefinitionSlicingComponent slicing, ElementDefinition compare, int mode, boolean strikethrough) throws IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.codeWithText("This element introduces a set of slices on ", ed.getPath(), ". The slices are ");
        String newOrdered = this.sliceOrderString(slicing);
        String oldOrdered = compare == null || !compare.hasSlicing() ? null : this.sliceOrderString(compare.getSlicing());
        this.compareString(x, newOrdered, slicing.getOrderedElement(), null, null, null, oldOrdered, null, mode);
        x.tx(" and ");
        this.compareString(x, slicing.hasRules() ? slicing.getRules().getDisplay() : null, slicing.getRulesElement(), null, "rules", slicing, compare != null && compare.hasSlicing() && compare.getSlicing().hasRules() ? compare.getSlicing().getRules().getDisplay() : null, null, mode);
        if (slicing.hasDiscriminator()) {
            x.tx(", and can be differentiated using the following discriminators: ");
            StatusList<DiscriminatorWithStatus> list = new StatusList<DiscriminatorWithStatus>();
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slicing.getDiscriminator()) {
                list.add(new DiscriminatorWithStatus(d));
            }
            if (compare != null) {
                for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d : slicing.getDiscriminator()) {
                    list.merge(new DiscriminatorWithStatus(d));
                }
            }
            x.tx(", and can be differentiated using the following discriminators: ");
            XhtmlNode ul = x.ul();
            for (DiscriminatorWithStatus rc : list) {
                rc.render(x.li());
            }
        } else {
            x.tx(", and defines no discriminators to differentiate the slices");
        }
        this.tableRow(tbl, "Slicing", "profiling.html#slicing", strikethrough, x);
        tbl.tx("\r\n");
    }

    private XhtmlNode tableRow(XhtmlNode x, String name, String defRef, boolean strikethrough) throws IOException {
        XhtmlNode tr = x.tr();
        if (strikethrough) {
            tr.style("text-decoration: line-through");
        }
        this.addFirstCell(name, defRef, tr);
        return tr.td();
    }

    private void tableRow(XhtmlNode x, String name, String defRef, boolean strikethrough, XhtmlNode possibleTd) throws IOException {
        if (possibleTd != null && !possibleTd.isEmpty()) {
            XhtmlNode tr = x.tr();
            if (strikethrough) {
                tr.style("text-decoration: line-through");
            }
            this.addFirstCell(name, defRef, tr);
            tr.td().copyAllContent(possibleTd);
        }
    }

    private void tableRow(XhtmlNode x, String name, String defRef, boolean strikethrough, String text) throws IOException {
        if (!Utilities.noString((String)text)) {
            XhtmlNode tr = x.tr();
            if (strikethrough) {
                tr.style("text-decoration: line-through");
            }
            this.addFirstCell(name, defRef, tr);
            tr.td().tx(text);
        }
    }

    private void addFirstCell(String name, String defRef, XhtmlNode tr) {
        XhtmlNode td = tr.td();
        if (name.length() <= 16) {
            td.style("white-space: nowrap");
        }
        if (defRef == null) {
            td.tx(name);
        } else if (Utilities.isAbsoluteUrl((String)defRef)) {
            td.ah(defRef).tx(name);
        } else {
            td.ah(this.corePath + defRef).tx(name);
        }
    }

    private String head(String path) {
        if (path.contains(".")) {
            return path.substring(0, path.indexOf("."));
        }
        return path;
    }

    private String nottail(String path) {
        if (path.contains(".")) {
            return path.substring(0, path.lastIndexOf("."));
        }
        return path;
    }

    private XhtmlNode businessIdWarning(String resource, String name) {
        if (name.equals("identifier")) {
            XhtmlNode ret = new XhtmlNode(NodeType.Element, "div");
            ret.tx("This is a business identifier, not a resource identifier (see ");
            ret.ah(this.corePath + "resource.html#identifiers").tx("discussion");
            ret.tx(")");
            return ret;
        }
        if (name.equals("version")) {
            XhtmlNode ret = new XhtmlNode(NodeType.Element, "div");
            ret.tx("This is a business versionId, not a resource version id (see ");
            ret.ah(this.corePath + "resource.html#versions").tx("discussion");
            ret.tx(")");
            return ret;
        }
        return null;
    }

    private XhtmlNode describeCardinality(ElementDefinition d, ElementDefinition compare, int mode) throws IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        if (compare == null || mode == 2) {
            if (!d.hasMax() && !d.hasMin()) {
                return null;
            }
            if (d.getMax() == null) {
                this.renderStatus(d.getMinElement(), x).tx(this.toStr(d.getMin()));
                x.tx("..?");
            } else {
                this.renderStatus(d.getMinElement(), x).tx(this.toStr(d.getMin()));
                x.tx("..");
                this.renderStatus(d.getMaxElement(), x).tx(d.getMax());
            }
        } else {
            if (mode != 2 || d.getMin() != compare.getMin() && d.getMin() != 0) {
                this.compareString(x, this.toStr(d.getMin()), d.getMinElement(), null, "min", d, this.toStr(compare.getMin()), null, mode);
            }
            x.tx("..");
            if (mode != 2 || !d.getMax().equals(compare.getMax()) && !"1".equals(d.getMax())) {
                this.compareString(x, d.getMax(), d.getMaxElement(), null, "max", d, compare.getMax(), null, mode);
            }
        }
        XhtmlNode t = this.compareSimpleTypeLists(d.getCondition(), compare == null ? null : compare.getCondition(), mode);
        if (t != null) {
            x.br();
            x.tx("This element is affected by the following invariants: ");
            x.copyAllContent(t);
        }
        return x;
    }

    private boolean hasMustSupportTypes(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent tr : types) {
            if (!this.isMustSupport(tr)) continue;
            return true;
        }
        return false;
    }

    private XhtmlNode describeTypes(List<ElementDefinition.TypeRefComponent> types, boolean mustSupportOnly, ElementDefinition ed, ElementDefinition compare, int mode, ElementDefinition value, ElementDefinition compareValue, StructureDefinition sd) throws FHIRException, IOException {
        XhtmlNode xt;
        if (types.isEmpty()) {
            return null;
        }
        List<Object> compareTypes = compare == null ? new ArrayList() : compare.getType();
        XhtmlNode ret = new XhtmlNode(NodeType.Element, "div");
        if (!mustSupportOnly && types.size() == 1 && compareTypes.size() <= 1 && (mode != 2 || !VersionComparisonAnnotation.hasDeleted(ed, "type")) || mustSupportOnly && this.mustSupportCount(types) == 1) {
            if (!mustSupportOnly || this.isMustSupport(types.get(0))) {
                this.describeType(ret, types.get(0), mustSupportOnly, compareTypes.size() == 0 ? null : (ElementDefinition.TypeRefComponent)compareTypes.get(0), mode, sd);
            }
        } else {
            boolean first = true;
            if (types.size() > 1) {
                ret.tx("Choice of: ");
            }
            HashMap<String, ElementDefinition.TypeRefComponent> map = new HashMap<String, ElementDefinition.TypeRefComponent>();
            for (ElementDefinition.TypeRefComponent typeRefComponent : compareTypes) {
                map.put(typeRefComponent.getCode(), typeRefComponent);
            }
            for (ElementDefinition.TypeRefComponent typeRefComponent : types) {
                ElementDefinition.TypeRefComponent compareType = (ElementDefinition.TypeRefComponent)map.get(typeRefComponent.getCode());
                if (compareType != null) {
                    map.remove(typeRefComponent.getCode());
                }
                if (mustSupportOnly && !this.isMustSupport(typeRefComponent)) continue;
                if (first) {
                    first = false;
                } else {
                    ret.tx(", ");
                }
                this.describeType(ret, typeRefComponent, mustSupportOnly, compareType, mode, sd);
            }
            for (ElementDefinition.TypeRefComponent typeRefComponent : map.values()) {
                ret.tx(", ");
                this.describeType(this.removed(ret), typeRefComponent, mustSupportOnly, null, mode, sd);
            }
            if (mode == 2) {
                for (Base base : VersionComparisonAnnotation.getDeleted(ed, "type")) {
                    ElementDefinition.TypeRefComponent t = (ElementDefinition.TypeRefComponent)base;
                    ret.tx(", ");
                    this.describeType(ret, t, false, null, mode, sd);
                }
            }
        }
        if (value != null && (xt = this.processSecondary(mode, value, compareValue, mode, sd)) != null) {
            ret.copyAllContent(xt);
        }
        return ret;
    }

    private XhtmlNode processSecondary(int mode, ElementDefinition value, ElementDefinition compareValue, int compMode, StructureDefinition sd) throws FHIRException, IOException {
        switch (mode) {
            case 1: {
                return null;
            }
            case 2: {
                XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
                x.tx(" (Complex Extension)");
                return x;
            }
            case 3: {
                XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
                x.tx(" (Extension Type: ");
                x.copyAllContent(this.describeTypes(value.getType(), false, value, compareValue, compMode, null, null, sd));
                x.tx(")");
                return x;
            }
        }
        return null;
    }

    private int mustSupportCount(List<ElementDefinition.TypeRefComponent> types) {
        int c = 0;
        for (ElementDefinition.TypeRefComponent tr : types) {
            if (!this.isMustSupport(tr)) continue;
            ++c;
        }
        return c;
    }

    private void describeType(XhtmlNode x, ElementDefinition.TypeRefComponent t, boolean mustSupportOnly, ElementDefinition.TypeRefComponent compare, int mode, StructureDefinition sd) throws FHIRException, IOException {
        boolean first;
        StatusList<ResolvedCanonical> profiles;
        if (t.getWorkingCode() == null) {
            return;
        }
        if (t.getWorkingCode().startsWith("=")) {
            return;
        }
        boolean ts = false;
        ts = t.getWorkingCode().startsWith("xs:") ? this.compareString(x, t.getWorkingCode(), t, null, "code", t, compare == null ? null : compare.getWorkingCode(), null, mode) : this.compareString(x, t.getWorkingCode(), t, this.getTypeLink(t, sd), "code", t, compare == null ? null : compare.getWorkingCode(), compare == null ? null : this.getTypeLink(compare, sd), mode);
        if ((!mustSupportOnly && (t.hasProfile() || compare != null && compare.hasProfile()) || this.isMustSupport(t.getProfile())) && (profiles = this.analyseProfiles(t.getProfile(), compare == null ? null : compare.getProfile(), mustSupportOnly, mode)).size() > 0) {
            if (!ts) {
                this.getTypeLink(this.unchanged(x), t, sd);
                ts = true;
            }
            x.tx("(");
            first = true;
            for (ResolvedCanonical rc : profiles) {
                if (first) {
                    first = false;
                } else {
                    x.tx(", ");
                }
                rc.render(x);
            }
            x.tx(")");
        }
        if (!mustSupportOnly && (t.hasTargetProfile() || compare != null && compare.hasTargetProfile()) || this.isMustSupport(t.getTargetProfile())) {
            profiles = this.analyseProfiles(t.getTargetProfile(), compare == null ? null : compare.getTargetProfile(), mustSupportOnly, mode);
            if (profiles.size() > 0) {
                if (!ts) {
                    this.getTypeLink(this.unchanged(x), t, sd);
                }
                x.tx("(");
                first = true;
                for (ResolvedCanonical rc : profiles) {
                    if (first) {
                        first = false;
                    } else {
                        x.tx(", ");
                    }
                    rc.render(x);
                }
                x.tx(")");
            }
            if (!t.getAggregation().isEmpty() || compare != null && !compare.getAggregation().isEmpty()) {
                XhtmlNode xt;
                for (Enumeration<ElementDefinition.AggregationMode> a : t.getAggregation()) {
                    a.setUserData("render.link", this.corePath + "codesystem-resource-aggregation-mode.html#content");
                }
                if (compare != null) {
                    for (Enumeration<ElementDefinition.AggregationMode> a : compare.getAggregation()) {
                        a.setUserData("render.link", this.corePath + "codesystem-resource-aggregation-mode.html#content");
                    }
                }
                if ((xt = this.compareSimpleTypeLists(t.getAggregation(), compare == null ? null : compare.getAggregation(), mode)) != null) {
                    x.copyAllContent(xt);
                }
            }
        }
    }

    private StatusList<ResolvedCanonical> analyseProfiles(List<CanonicalType> newProfiles, List<CanonicalType> oldProfiles, boolean mustSupportOnly, int mode) {
        StatusList<ResolvedCanonical> profiles = new StatusList<ResolvedCanonical>();
        for (CanonicalType pt : newProfiles) {
            ResolvedCanonical rc = this.fetchProfile(pt, mustSupportOnly);
            profiles.add(rc);
        }
        if (oldProfiles != null && mode != 2) {
            for (CanonicalType pt : oldProfiles) {
                profiles.merge(this.fetchProfile(pt, mustSupportOnly));
            }
        }
        return profiles;
    }

    private ResolvedCanonical fetchProfile(CanonicalType pt, boolean mustSupportOnly) {
        if (!pt.hasValue()) {
            return null;
        }
        if (!mustSupportOnly || this.isMustSupport(pt)) {
            StructureDefinition p = this.context.getContext().fetchResource(StructureDefinition.class, (String)pt.getValue());
            return new ResolvedCanonical((String)pt.getValue(), p);
        }
        return null;
    }

    private void getTypeLink(XhtmlNode x, ElementDefinition.TypeRefComponent t, StructureDefinition sd) {
        String s = this.context.getPkp().getLinkFor(sd.getWebPath(), t.getWorkingCode());
        if (s != null) {
            x.ah(s).tx(t.getWorkingCode());
        } else {
            x.code().tx(t.getWorkingCode());
        }
    }

    private String getTypeLink(ElementDefinition.TypeRefComponent t, StructureDefinition sd) {
        String s = this.context.getPkp().getLinkFor(sd.getWebPath(), t.getWorkingCode());
        return s;
    }

    private XhtmlNode displayBoolean(boolean value, BooleanType source, String name, Base parent, BooleanType compare, int mode) {
        String newValue;
        String string = value ? "true" : (newValue = source.hasValue() ? "false" : null);
        String oldValue = compare == null || compare.getValue() == null ? null : ((Boolean)compare.getValue() != true ? null : "true");
        return this.compareString(newValue, source, null, name, parent, oldValue, null, mode);
    }

    private XhtmlNode invariants(List<ElementDefinition.ElementDefinitionConstraintComponent> originalList, List<ElementDefinition.ElementDefinitionConstraintComponent> compareList, ElementDefinition parent, int mode) throws IOException {
        StatusList<InvariantWithStatus> list = new StatusList<InvariantWithStatus>();
        for (ElementDefinition.ElementDefinitionConstraintComponent v : originalList) {
            if (v.isEmpty()) continue;
            list.add(new InvariantWithStatus(v));
        }
        if (compareList != null && mode != 2) {
            for (ElementDefinition.ElementDefinitionConstraintComponent v : compareList) {
                list.merge(new InvariantWithStatus(v));
            }
        }
        if (list.size() == 0) {
            return null;
        }
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean first = true;
        for (InvariantWithStatus t : list) {
            if (first) {
                first = false;
            } else {
                x.br();
            }
            t.render(x);
        }
        for (Base b : VersionComparisonAnnotation.getDeleted(parent, "invariant")) {
            if (first) {
                first = false;
            } else {
                x.br();
            }
            InvariantWithStatus ts = new InvariantWithStatus((ElementDefinition.ElementDefinitionConstraintComponent)b);
            ts.render(x);
        }
        return x;
    }

    private XhtmlNode describeBinding(StructureDefinition sd, ElementDefinition d, String path, ElementDefinition compare, int mode) throws FHIRException, IOException {
        if (!d.hasBinding()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent binding = d.getBinding();
        ElementDefinition.ElementDefinitionBindingComponent compBinding = compare == null ? null : compare.getBinding();
        XhtmlNode bindingDesc = null;
        if (binding.hasDescription()) {
            MarkdownType newBinding = PublicationHacker.fixBindingDescriptions(this.context.getContext(), binding.getDescriptionElement());
            if (mode == 1 || mode == 3) {
                bindingDesc = new XhtmlNode(NodeType.Element, "div");
                bindingDesc.add(new XhtmlParser().parseFragment(this.hostMd.processMarkdown("Binding.description", newBinding)));
            } else {
                MarkdownType oldBinding = compBinding != null && compBinding.hasDescription() ? PublicationHacker.fixBindingDescriptions(this.context.getContext(), compBinding.getDescriptionElement()) : null;
                bindingDesc = this.compareMarkdown("Binding.description", newBinding, oldBinding, mode);
            }
        }
        if (!binding.hasValueSet()) {
            return bindingDesc;
        }
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode nsp = x.span();
        this.renderBinding(nsp, binding, compBinding, path, sd, mode);
        if (bindingDesc != null) {
            if (this.isSimpleContent(bindingDesc)) {
                x.tx(": ");
                x.copyAllContent(bindingDesc.getChildNodes().get(0));
            } else {
                x.br();
                x.copyAllContent(bindingDesc);
            }
        }
        AdditionalBindingsRenderer abr = new AdditionalBindingsRenderer(this.context.getPkp(), this.corePath, sd, d.getPath(), this.context, this.hostMd, this);
        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
            abr.seeMaxBinding(ToolingExtensions.getExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), compBinding == null ? null : ToolingExtensions.getExtension(compBinding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), mode != 1 && mode != 3);
        }
        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet")) {
            abr.seeMinBinding(ToolingExtensions.getExtension(binding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet"), compBinding == null ? null : ToolingExtensions.getExtension(compBinding, "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet"), mode != 1 && mode != 3);
        }
        if (binding.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/additional-binding")) {
            abr.seeAdditionalBindings(binding.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/additional-binding"), compBinding == null ? null : compBinding.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/additional-binding"), mode != 1 && mode != 3);
        }
        if (abr.hasBindings()) {
            XhtmlNode tbl = x.table("grid");
            abr.render((List<XhtmlNode>)tbl.getChildNodes(), true);
        }
        return x;
    }

    private boolean isSimpleContent(XhtmlNode bindingDesc) {
        return bindingDesc.getChildNodes().size() == 1 && bindingDesc.getChildNodes().get(0).isPara();
    }

    private void renderBinding(XhtmlNode span, ElementDefinition.ElementDefinitionBindingComponent binding, ElementDefinition.ElementDefinitionBindingComponent compare, String path, StructureDefinition sd, int mode) {
        this.compareString(span, this.conf(binding), binding.getStrengthElement(), null, "strength", binding, compare == null ? null : this.conf(compare), null, mode);
        span.tx(" ");
        BindingResolution br = this.context.getPkp().resolveBinding(sd, binding, path);
        this.compareString(span, br.display, binding.getValueSetElement(), br.url, "valueSet", binding, compare == null ? null : compare.getValueSet(), null, mode);
    }

    private String stripPara(String s) {
        if (((String)s).startsWith("<p>")) {
            s = ((String)s).substring(3);
        }
        if (((String)s).trim().endsWith("</p>")) {
            s = ((String)s).substring(0, ((String)s).lastIndexOf("</p>") - 1) + ((String)s).substring(((String)s).lastIndexOf("</p>") + 4);
        }
        return s;
    }

    private String conf(ElementDefinition.ElementDefinitionBindingComponent def) {
        if (def.getStrength() == null) {
            return "For codes, see ";
        }
        switch (def.getStrength()) {
            case EXAMPLE: {
                return "For example codes, see ";
            }
            case PREFERRED: {
                return "The codes SHOULD be taken from ";
            }
            case EXTENSIBLE: {
                return "Unless not suitable, these codes SHALL be taken from ";
            }
            case REQUIRED: {
                return "The codes SHALL be taken from ";
            }
        }
        return "?sd-conf?";
    }

    private String encodeValues(List<ElementDefinition.ElementDefinitionExampleComponent> examples) throws FHIRException, IOException {
        StringBuilder b = new StringBuilder();
        boolean first = false;
        for (ElementDefinition.ElementDefinitionExampleComponent ex : examples) {
            if (first) {
                first = false;
            } else {
                b.append("<br/>");
            }
            b.append("<b>" + Utilities.escapeXml((String)ex.getLabel()) + "</b>:" + this.encodeValue(ex.getValue()) + "\r\n");
        }
        return b.toString();
    }

    private XhtmlNode encodeValue(DataType value, String name, Base parent, DataType compare, int mode) throws FHIRException, IOException {
        String oldValue = this.encodeValue(compare);
        String newValue = this.encodeValue(value);
        return this.compareString(newValue, value, null, name, parent, oldValue, null, mode);
    }

    private String encodeValue(DataType value) throws FHIRException, IOException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value instanceof PrimitiveType) {
            return Utilities.escapeXml((String)((PrimitiveType)value).asStringValue());
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        XmlParser parser = new XmlParser();
        parser.setOutputStyle(IParser.OutputStyle.PRETTY);
        parser.compose((OutputStream)bs, null, value);
        String[] lines = bs.toString().split("\\r?\\n");
        StringBuilder b = new StringBuilder();
        for (String s : lines) {
            if (Utilities.noString((String)s) || s.startsWith("<?")) continue;
            b.append(Utilities.escapeXml((String)s).replace(" ", "&nbsp;") + "<br/>");
        }
        return b.toString();
    }

    /*
     * WARNING - void declaration
     */
    private XhtmlNode getMapping(StructureDefinition profile, ElementDefinition d, String uri, ElementDefinition compare, int mode) {
        void var8_12;
        String id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : profile.getMapping()) {
            if (!structureDefinitionMappingComponent.hasUri() || !structureDefinitionMappingComponent.getUri().equals(uri)) continue;
            id = structureDefinitionMappingComponent.getIdentity();
        }
        if (id == null) {
            return null;
        }
        String newMap = null;
        for (ElementDefinition.ElementDefinitionMappingComponent m : d.getMapping()) {
            if (!m.getIdentity().equals(id)) continue;
            newMap = m.getMap();
            break;
        }
        if (compare == null) {
            return new XhtmlNode(NodeType.Element, "div").tx(newMap);
        }
        Object var8_10 = null;
        for (ElementDefinition.ElementDefinitionMappingComponent m : compare.getMapping()) {
            if (!m.getIdentity().equals(id)) continue;
            String string = m.getMap();
            break;
        }
        return this.compareString(Utilities.escapeXml((String)newMap), null, null, "mapping", d, Utilities.escapeXml((String)var8_12), null, mode);
    }

    private XhtmlNode compareSimpleTypeLists(List<? extends PrimitiveType> original, List<? extends PrimitiveType> compare, int mode) throws IOException {
        return this.compareSimpleTypeLists(original, compare, mode, ", ");
    }

    private XhtmlNode compareSimpleTypeLists(List<? extends PrimitiveType> originalList, List<? extends PrimitiveType> compareList, int mode, String separator) throws IOException {
        StatusList<ValueWithStatus> list = new StatusList<ValueWithStatus>();
        for (PrimitiveType primitiveType : originalList) {
            if (primitiveType.isEmpty()) continue;
            list.add(new ValueWithStatus(primitiveType));
        }
        if (compareList != null && mode != 2) {
            for (PrimitiveType primitiveType : compareList) {
                list.merge(new ValueWithStatus(primitiveType));
            }
        }
        if (list.size() == 0) {
            return null;
        }
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean bl = true;
        for (ValueWithStatus t : list) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else {
                x.tx(separator);
            }
            t.render(x);
        }
        return x;
    }

    private XhtmlNode compareDataTypeLists(List<? extends DataType> original, List<? extends DataType> compare, int mode) throws IOException {
        return this.compareDataTypeLists(original, compare, mode, ", ");
    }

    private XhtmlNode compareDataTypeLists(List<? extends DataType> originalList, List<? extends DataType> compareList, int mode, String separator) throws IOException {
        StatusList<DataValueWithStatus> list = new StatusList<DataValueWithStatus>();
        for (DataType dataType : originalList) {
            if (dataType.isEmpty()) continue;
            list.add(new DataValueWithStatus(dataType));
        }
        if (compareList != null && mode != 2) {
            for (DataType dataType : compareList) {
                list.merge(new DataValueWithStatus(dataType));
            }
        }
        if (list.size() == 0) {
            return null;
        }
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean bl = true;
        for (DataValueWithStatus t : list) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else {
                x.tx(separator);
            }
            t.render(x);
        }
        return x;
    }

    private String summarise(CodeableConcept cc) throws FHIRException {
        if (cc.getCoding().size() == 1 && cc.getText() == null) {
            return this.summarise(cc.getCoding().get(0));
        }
        if (cc.hasText()) {
            return "\"" + cc.getText() + "\"";
        }
        if (cc.getCoding().size() > 0) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Coding c : cc.getCoding()) {
                b.append(this.summarise(c));
            }
            return b.toString();
        }
        throw new FHIRException("Error describing concept - not done yet (no codings, no text)");
    }

    private String summarise(Coding coding) throws FHIRException {
        if ("http://snomed.info/sct".equals(coding.getSystem())) {
            return this.translate("sd.summary", "SNOMED CT code") + " " + coding.getCode() + (String)(!coding.hasDisplay() ? "" : "(\"" + this.gt(coding.getDisplayElement()) + "\")");
        }
        if (LOINC_MAPPING.equals(coding.getSystem())) {
            return this.translate("sd.summary", "LOINC code") + " " + coding.getCode() + (String)(!coding.hasDisplay() ? "" : "(\"" + this.gt(coding.getDisplayElement()) + "\")");
        }
        if ("http://unitsofmeasure.org/".equals(coding.getSystem())) {
            return " (" + this.translate("sd.summary", "UCUM") + ": " + coding.getCode() + ")";
        }
        CodeSystem cs = this.context.getContext().fetchCodeSystem(coding.getSystem());
        if (cs == null) {
            return "<span title=\"" + coding.getSystem() + "\">" + coding.getCode() + "</a>" + (String)(!coding.hasDisplay() ? "" : "(\"" + this.gt(coding.getDisplayElement()) + "\")");
        }
        return "<a title=\"" + cs.present() + "\" href=\"" + Utilities.escapeXml((String)cs.getWebPath()) + "#" + cs.getId() + "-" + coding.getCode() + "\">" + coding.getCode() + "</a>" + (String)(!coding.hasDisplay() ? "" : "(\"" + this.gt(coding.getDisplayElement()) + "\")");
    }

    private static class Column {
        String id;
        String title;
        String hint;
        private String link;

        protected Column(String id, String title, String hint) {
            this.id = id;
            this.title = title;
            this.hint = hint;
        }

        protected Column(String id, String title, String hint, String link) {
            this.id = id;
            this.title = title;
            this.hint = hint;
            this.link = link;
        }
    }

    private class ElementInStructure {
        private StructureDefinition source;
        private ElementDefinition element;

        public ElementInStructure(StructureDefinition source, ElementDefinition ed) {
            this.source = source;
            this.element = ed;
        }

        public StructureDefinition getSource() {
            return this.source;
        }

        public ElementDefinition getElement() {
            return this.element;
        }
    }

    private class SpanEntry {
        private List<SpanEntry> children = new ArrayList<SpanEntry>();
        private boolean profile;
        private String id;
        private String name;
        private String resType;
        private String cardinality;
        private String description;
        private String profileLink;
        private String resLink;
        private String type;

        private SpanEntry() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getResType() {
            return this.resType;
        }

        public void setResType(String resType) {
            this.resType = resType;
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public void setCardinality(String cardinality) {
            this.cardinality = cardinality;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getProfileLink() {
            return this.profileLink;
        }

        public void setProfileLink(String profileLink) {
            this.profileLink = profileLink;
        }

        public String getResLink() {
            return this.resLink;
        }

        public void setResLink(String resLink) {
            this.resLink = resLink;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isProfile() {
            return this.profile;
        }

        public void setProfile(boolean profile) {
            this.profile = profile;
        }

        public List<SpanEntry> getChildren() {
            return this.children;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class UnusedTracker {
        private boolean used;
    }

    private class DataValueWithStatus
    extends ItemWithStatus {
        DataType value;

        protected DataValueWithStatus(DataType value) {
            this.value = value;
        }

        @Override
        protected boolean matches(ItemWithStatus other) {
            return ((ValueWithStatus)other).value.equalsDeep(this.value);
        }

        @Override
        public void renderDetails(XhtmlNode f) throws IOException {
            if (this.value.hasUserData("render.link")) {
                f = f.ah(this.value.getUserString("render.link"));
            }
            f.tx(StructureDefinitionRenderer.this.summarize(this.value));
        }
    }

    private class ValueWithStatus
    extends ItemWithStatus {
        PrimitiveType value;

        protected ValueWithStatus(PrimitiveType value) {
            this.value = value;
        }

        @Override
        protected boolean matches(ItemWithStatus other) {
            return ((ValueWithStatus)other).value.equalsDeep(this.value);
        }

        @Override
        public void renderDetails(XhtmlNode f) {
            if (this.value.hasUserData("render.link")) {
                f = f.ah(this.value.getUserString("render.link"));
            }
            f.tx(this.value.asStringValue());
        }
    }

    private class DiscriminatorWithStatus
    extends ItemWithStatus {
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent value;

        protected DiscriminatorWithStatus(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent value) {
            this.value = value;
        }

        @Override
        protected boolean matches(ItemWithStatus other) {
            return ((DiscriminatorWithStatus)other).value.equalsDeep(this.value);
        }

        @Override
        public void renderDetails(XhtmlNode f) {
            f.tx(this.value.getType().toCode());
            f.tx(" @ ");
            f.tx(this.value.getPath());
        }
    }

    private class InvariantWithStatus
    extends ItemWithStatus {
        ElementDefinition.ElementDefinitionConstraintComponent value;

        protected InvariantWithStatus(ElementDefinition.ElementDefinitionConstraintComponent value) {
            this.value = value;
        }

        @Override
        protected boolean matches(ItemWithStatus other) {
            return ((InvariantWithStatus)other).value.equalsDeep(this.value);
        }

        @Override
        public void renderDetails(XhtmlNode f) {
            Base b;
            f = StructureDefinitionRenderer.this.renderStatus(this.value, f);
            f.b().attribute("title", "Formal Invariant Identifier").tx(this.value.getKey());
            f.tx(": ");
            if (this.value.hasHuman()) {
                StructureDefinitionRenderer.this.renderStatus(this.value.getHumanElement(), f).tx(this.value.getHuman());
            } else if (VersionComparisonAnnotation.hasDeleted(this.value, "human")) {
                b = VersionComparisonAnnotation.getDeletedItem(this.value, "human");
                StructureDefinitionRenderer.this.renderStatus(b, f).tx(b.primitiveValue());
            }
            f.tx(" (");
            if (this.status == ListItemStatus.New) {
                if (this.value.hasExpression()) {
                    StructureDefinitionRenderer.this.renderStatus(this.value.getExpressionElement(), f).code().tx(this.value.getExpression());
                } else if (VersionComparisonAnnotation.hasDeleted(this.value, "expression")) {
                    b = VersionComparisonAnnotation.getDeletedItem(this.value, "expression");
                    StructureDefinitionRenderer.this.renderStatus(b, f).code().tx(b.primitiveValue());
                }
            } else {
                StructureDefinitionRenderer.this.renderStatus(this.value.getExpressionElement(), f).tx(this.value.getExpression());
            }
            f.tx(")");
        }
    }

    private class ResolvedCanonical
    extends ItemWithStatus {
        String url;
        CanonicalResource cr;

        public ResolvedCanonical(String url, CanonicalResource cr) {
            this.url = url;
            this.cr = cr;
        }

        @Override
        public void renderDetails(XhtmlNode f) {
            if (this.cr != null && this.cr.hasWebPath()) {
                f.ah(this.cr.getWebPath()).tx(this.cr.present());
            } else {
                f.code().tx(this.url);
            }
        }

        @Override
        protected boolean matches(ItemWithStatus other) {
            return ((ResolvedCanonical)other).url.equals(this.url);
        }
    }

    protected class StatusList<T extends ItemWithStatus>
    extends ArrayList<T>
    implements List<T> {
        protected StatusList() {
        }

        public boolean merge(T item) {
            if (item == null) {
                return false;
            }
            boolean found = false;
            for (ItemWithStatus t : this) {
                if (!t.matches((ItemWithStatus)item)) continue;
                found = true;
                t.status = ListItemStatus.Unchanged;
            }
            if (!found) {
                ((ItemWithStatus)item).status = ListItemStatus.Removed;
                return this.add(item);
            }
            return false;
        }

        @Override
        public boolean add(T item) {
            if (item != null) {
                return super.add(item);
            }
            return false;
        }
    }

    private abstract class ItemWithStatus {
        ListItemStatus status = ListItemStatus.New;

        private ItemWithStatus() {
        }

        protected abstract void renderDetails(XhtmlNode var1) throws IOException;

        protected abstract boolean matches(ItemWithStatus var1);

        public void render(XhtmlNode x) throws IOException {
            XhtmlNode f = x;
            if (this.status == ListItemStatus.Unchanged) {
                f = StructureDefinitionRenderer.this.unchanged(f);
            } else if (this.status == ListItemStatus.Removed) {
                f = StructureDefinitionRenderer.this.removed(f);
            }
            this.renderDetails(f);
        }
    }

    private static enum ListItemStatus {
        New,
        Unchanged,
        Removed;

    }

    public class InternalMarkdownProcessor
    implements IMarkdownProcessor {
        @Override
        public String processMarkdown(String location, PrimitiveType md) throws FHIRException {
            return StructureDefinitionRenderer.this.context.getMarkdown().process(md.primitiveValue(), location);
        }

        @Override
        public String processMarkdown(String location, String text) throws FHIRException {
            return StructureDefinitionRenderer.this.context.getMarkdown().process(text, location);
        }
    }
}

