/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.client;

import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;

public class TerminologyClientContext {
    private String cacheId;
    private boolean isTxCaching;
    private int serverQueryCount = 0;
    private final Set<String> cached = new HashSet<String>();
    protected String server;
    private ITerminologyClient client;
    private TerminologyCapabilities txcaps;

    public String getCacheId() {
        return this.cacheId;
    }

    public void setCacheId(String cacheId) {
        this.cacheId = cacheId;
    }

    public boolean isTxCaching() {
        return this.isTxCaching;
    }

    public void setTxCaching(boolean isTxCaching) {
        this.isTxCaching = isTxCaching;
    }

    public int getServerQueryCount() {
        return this.serverQueryCount;
    }

    public void setServerQueryCount(int serverQueryCount) {
        this.serverQueryCount = serverQueryCount;
    }

    public Set<String> getCached() {
        return this.cached;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public ITerminologyClient getClient() {
        return this.client;
    }

    public void setClient(ITerminologyClient client) {
        this.client = client;
    }

    public TerminologyCapabilities getTxcaps() {
        return this.txcaps;
    }

    public void setTxcaps(TerminologyCapabilities txcaps) {
        this.txcaps = txcaps;
    }

    public void copy(TerminologyClientContext other) {
        this.cacheId = other.cacheId;
        this.isTxCaching = other.isTxCaching;
        this.cached.addAll(other.cached);
        this.client = other.client;
        this.txcaps = other.txcaps;
    }

    public boolean usingCache() {
        return this.isTxCaching && this.cacheId != null;
    }

    public boolean alreadyCached(CanonicalResource cr) {
        return this.cached.contains(cr.getVUrl());
    }

    public void addToCache(CanonicalResource cr) {
        this.cached.add(cr.getVUrl());
    }
}

