/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.expansion;

import java.util.List;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ConceptFilter;

public class PropertyFilter
extends ConceptFilter {
    private ValueSet.ConceptSetFilterComponent filter;
    private CodeSystem.PropertyComponent property;

    public PropertyFilter(List<String> allErrors, ValueSet.ConceptSetFilterComponent fc, CodeSystem.PropertyComponent propertyDefinition) {
        super(allErrors);
        this.filter = fc;
        this.property = propertyDefinition;
    }

    @Override
    public boolean includeConcept(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        CodeSystem.ConceptPropertyComponent pc = this.getPropertyForConcept(def);
        if (pc != null) {
            String v = pc.getValue().isPrimitive() ? pc.getValue().primitiveValue() : null;
            switch (this.filter.getOp()) {
                case DESCENDENTOF: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case EQUAL: {
                    return this.filter.getValue().equals(v);
                }
                case EXISTS: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case GENERALIZES: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case IN: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case ISA: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case ISNOTA: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case NOTIN: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case NULL: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
                case REGEX: {
                    throw this.fail("not supported yet: " + this.filter.getOp().toCode());
                }
            }
            throw this.fail("Shouldn't get here");
        }
        if (this.property.getType() == CodeSystem.PropertyType.BOOLEAN && this.filter.getOp() == Enumerations.FilterOperator.EQUAL) {
            return "false".equals(this.filter.getValue());
        }
        return false;
    }

    private CodeSystem.ConceptPropertyComponent getPropertyForConcept(CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptPropertyComponent pc : def.getProperty()) {
            if (!pc.getCode().equals(this.property.getCode())) continue;
            return pc;
        }
        return null;
    }
}

