/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.LanguageUtils;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.providers.CodeSystemProvider;
import org.hl7.fhir.r5.terminologies.providers.SpecialCodeSystem;
import org.hl7.fhir.r5.terminologies.providers.URICodeSystem;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyOperationContext;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValueSetProcessBase;
import org.hl7.fhir.r5.terminologies.validation.ConceptReferencePair;
import org.hl7.fhir.r5.terminologies.validation.VSCheckerException;
import org.hl7.fhir.r5.terminologies.validation.ValidationProcessInfo;
import org.hl7.fhir.r5.terminologies.validation.VersionInfo;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class ValueSetValidator
extends ValueSetProcessBase {
    private ValueSet valueset;
    private Map<String, ValueSetValidator> inner = new HashMap<String, ValueSetValidator>();
    private ValidationOptions options;
    private ValidationContextCarrier localContext;
    private List<CodeSystem> localSystems = new ArrayList<CodeSystem>();
    protected Parameters expansionProfile;
    private TerminologyCapabilities txCaps;
    private Set<String> unknownSystems;
    private boolean throwToServer;
    private static final Set<String> SERVER_SIDE_LIST = new HashSet<String>(Arrays.asList("http://fdasis.nlm.nih.gov", "http://hl7.org/fhir/sid/ndc", "http://loinc.org", "http://snomed.info/sct", "http://unitsofmeasure.org", "http://unstats.un.org/unsd/methods/m49/m49.htm", "http://varnomen.hgvs.org", "http://www.nlm.nih.gov/research/umls/rxnorm", "https://www.usps.com/", "urn:ietf:bcp:13", "urn:ietf:bcp:47", "urn:ietf:rfc:3986", "urn:iso:std:iso:3166", "urn:iso:std:iso:4217", "urn:oid:1.2.36.1.2001.1005.17"));

    public ValueSetValidator(IWorkerContext context, TerminologyOperationContext opContext, ValidationOptions options, ValueSet source, Parameters expansionProfile, TerminologyCapabilities txCaps) {
        super(context, opContext);
        this.valueset = source;
        this.options = options;
        this.expansionProfile = expansionProfile;
        this.txCaps = txCaps;
        this.analyseValueSet();
    }

    public ValueSetValidator(IWorkerContext context, TerminologyOperationContext opContext, ValidationOptions options, ValueSet source, ValidationContextCarrier ctxt, Parameters expansionProfile, TerminologyCapabilities txCaps) {
        super(context, opContext);
        this.valueset = source;
        this.options = options.copy();
        this.options.setEnglishOk(true);
        this.localContext = ctxt;
        this.expansionProfile = expansionProfile;
        this.txCaps = txCaps;
        this.analyseValueSet();
    }

    public Set<String> getUnknownSystems() {
        return this.unknownSystems;
    }

    public void setUnknownSystems(Set<String> unknownSystems) {
        this.unknownSystems = unknownSystems;
    }

    public boolean isThrowToServer() {
        return this.throwToServer;
    }

    public void setThrowToServer(boolean throwToServer) {
        this.throwToServer = throwToServer;
    }

    private void analyseValueSet() {
        if (this.valueset != null) {
            this.opContext.seeContext(this.valueset.getVersionedUrl());
            for (Extension s : this.valueset.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-supplement")) {
                this.requiredSupplements.add(s.getValue().primitiveValue());
            }
        }
        this.altCodeParams.seeParameters(this.expansionProfile);
        this.altCodeParams.seeValueSet(this.valueset);
        if (this.localContext != null && this.valueset != null) {
            for (ValueSet.ConceptSetComponent i : this.valueset.getCompose().getInclude()) {
                this.analyseComponent(i);
            }
            for (ValueSet.ConceptSetComponent i : this.valueset.getCompose().getExclude()) {
                this.analyseComponent(i);
            }
        }
    }

    private void analyseComponent(ValueSet.ConceptSetComponent i) {
        this.opContext.deadCheck();
        if (i.getSystemElement().hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-system")) {
            String ref = i.getSystemElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-system");
            if (ref.startsWith("#")) {
                String id = ref.substring(1);
                for (ValidationContextCarrier.ValidationContextResourceProxy t : this.localContext.getResources()) {
                    CodeSystem cs = (CodeSystem)t.loadContainedResource(id, CodeSystem.class);
                    if (cs == null) continue;
                    this.localSystems.add(cs);
                }
            } else {
                throw new Error("Not done yet #2: " + ref);
            }
        }
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept code) throws FHIRException {
        return this.validateCode("CodeableConcept", code);
    }

    public IWorkerContext.ValidationResult validateCode(String path, CodeableConcept code) throws FHIRException {
        CodeSystem.ConceptDefinitionComponent cd;
        this.opContext.deadCheck();
        this.checkValueSetOptions();
        ValidationProcessInfo info = new ValidationProcessInfo();
        CodeableConcept vcc = new CodeableConcept();
        if (this.options.getValueSetMode() != ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
            int i = 0;
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem()) {
                    info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.UNKNOWN, path, this.context.formatMessage("Coding_has_no_system__cannot_validate", new Object[0])));
                }
                VersionInfo vi = new VersionInfo(this);
                this.checkExpansion(c, vi);
                this.checkInclude(c, vi);
                CodeSystem cs = this.resolveCodeSystem(c.getSystem(), vi.getVersion(c.getSystem(), c.getVersion()));
                IWorkerContext.ValidationResult res = null;
                if (cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE) {
                    if (this.context.isNoTerminologyServer()) {
                        String msg;
                        if (c.hasVersion()) {
                            msg = this.context.formatMessage("UNKNOWN_CODESYSTEM_VERSION", c.getSystem(), c.getVersion(), this.resolveCodeSystemVersions(c.getSystem()).toString());
                            this.unknownSystems.add(c.getSystem() + "|" + c.getVersion());
                            res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path + ".coding[" + i + "].system", msg)).setUnknownSystems(this.unknownSystems);
                        } else {
                            msg = this.context.formatMessage("UNKNOWN_CODESYSTEM", c.getSystem(), c.getVersion());
                            this.unknownSystems.add(c.getSystem());
                            res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path + ".coding[" + i + "].system", msg)).setUnknownSystems(this.unknownSystems);
                        }
                    } else {
                        res = this.context.validateCode(this.options.withNoClient(), c, null);
                    }
                } else {
                    c.setUserData("cs", cs);
                    res = this.validateCode(path + ".coding[" + i + "]", c, cs, vcc, info);
                }
                info.getIssues().addAll(res.getIssues());
                ++i;
            }
        }
        Coding foundCoding = null;
        String msg = null;
        Boolean result = false;
        if (this.valueset != null && this.options.getValueSetMode() != ValidationOptions.ValueSetMode.NO_MEMBERSHIP_CHECK) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(", ");
            for (Coding c : code.getCoding()) {
                b.append("'" + c.getSystem() + (String)(c.hasVersion() ? "|" + c.getVersion() : "") + "#" + c.getCode() + "'");
                Boolean ok = this.codeInValueSet(path, c.getSystem(), c.getVersion(), c.getCode(), info);
                if (ok == null && result != null && !result.booleanValue()) {
                    result = null;
                } else if (ok != null && ok.booleanValue()) {
                    result = true;
                    foundCoding = c;
                    if (this.options.getValueSetMode() == ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
                        vcc.addCoding().setSystem(c.getSystem()).setVersion(c.getVersion()).setCode(c.getCode());
                    }
                }
                if (ok != null && ok.booleanValue()) continue;
                vcc.removeCoding(c.getSystem(), c.getVersion(), c.getCode());
            }
            if (result == null) {
                msg = this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_", this.valueset.getVersionedUrl(), b.toString());
                info.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, this.unknownSystems.isEmpty() ? OperationOutcome.IssueType.CODEINVALID : OperationOutcome.IssueType.NOTFOUND, path, msg));
            } else if (!result.booleanValue()) {
                msg = this.context.formatMessagePlural(code.getCoding().size(), "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getVersionedUrl(), b.toString());
                info.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, path, msg));
            }
        }
        if (vcc.hasCoding() && code.hasText()) {
            vcc.setText(code.getText());
        }
        if (!this.checkRequiredSupplements(info)) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, info.getIssues().get(info.getIssues().size() - 1).getDetails().getText(), info.getIssues());
        }
        if (info.hasErrors()) {
            IWorkerContext.ValidationResult res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, info.summary(), info.getIssues());
            if (foundCoding != null) {
                cd = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
                cd.setDisplay(this.lookupDisplay(foundCoding));
                res.setDefinition(cd);
                res.setSystem(foundCoding.getSystem());
                res.setVersion(foundCoding.hasVersion() ? foundCoding.getVersion() : ((CodeSystem)foundCoding.getUserData("cs")).getVersion());
                res.setDisplay(cd.getDisplay());
            }
            res.setUnknownSystems(this.unknownSystems);
            res.addCodeableConcept(vcc);
            return res;
        }
        if (result == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, info.summary(), info.getIssues());
        }
        if (foundCoding == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Internal Error that should not happen", this.makeIssue(ValidationMessage.IssueSeverity.FATAL, OperationOutcome.IssueType.EXCEPTION, path, "Internal Error that should not happen"));
        }
        if (info.getIssues().size() > 0) {
            String disp = this.lookupDisplay(foundCoding);
            cd = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
            cd.setDisplay(disp);
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, info.summary(), foundCoding.getSystem(), this.getVersion(foundCoding), cd, disp, info.getIssues()).addCodeableConcept(vcc);
        }
        CodeSystem.ConceptDefinitionComponent cd2 = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
        cd2.setDisplay(this.lookupDisplay(foundCoding));
        return new IWorkerContext.ValidationResult(foundCoding.getSystem(), this.getVersion(foundCoding), cd2, this.getPreferredDisplay(cd2, null)).addCodeableConcept(vcc);
    }

    private boolean checkRequiredSupplements(ValidationProcessInfo info) {
        if (!this.requiredSupplements.isEmpty()) {
            String msg = this.context.formatMessagePlural(this.requiredSupplements.size(), "VALUESET_SUPPLEMENT_MISSING", CommaSeparatedStringBuilder.build((List)this.requiredSupplements));
            throw new TerminologyOperationContext.TerminologyServiceProtectionException(msg, TerminologyServiceErrorClass.BUSINESS_RULE, OperationOutcome.IssueType.NOTFOUND);
        }
        return this.requiredSupplements.isEmpty();
    }

    private boolean valueSetDependsOn(String system, String version) {
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!system.equals(inc.getSystem()) || version != null && inc.getVersion() != null && !version.equals(inc.getVersion())) continue;
            return true;
        }
        return false;
    }

    private String getVersion(Coding c) {
        if (c.hasVersion()) {
            return c.getVersion();
        }
        if (c.hasUserData("cs")) {
            return ((CodeSystem)c.getUserData("cs")).getVersion();
        }
        return null;
    }

    private String lookupDisplay(Coding c) {
        CodeSystem.ConceptDefinitionComponent cd;
        CodeSystem cs = this.resolveCodeSystem(c.getSystem(), c.getVersion());
        if (cs != null && (cd = CodeSystemUtilities.findCodeOrAltCode(cs.getConcept(), c.getCode(), null)) != null) {
            return this.getPreferredDisplay(cd, cs);
        }
        return null;
    }

    public CodeSystem resolveCodeSystem(String system, String version) {
        for (CodeSystem t : this.localSystems) {
            if (!t.getUrl().equals(system) || !this.versionsMatch(version, t.getVersion())) continue;
            return t;
        }
        CodeSystem cs = this.context.fetchSupplementedCodeSystem(system, version);
        if (cs == null) {
            cs = this.findSpecialCodeSystem(system, version);
        }
        return cs;
    }

    public List<String> resolveCodeSystemVersions(String system) {
        ArrayList<String> res = new ArrayList<String>();
        for (CodeSystem t : this.localSystems) {
            if (!t.getUrl().equals(system) || !t.hasVersion()) continue;
            res.add(t.getVersion());
        }
        res.addAll(new ContextUtilities(this.context).fetchCodeSystemVersions(system));
        return res;
    }

    private boolean versionsMatch(String versionTest, String versionActual) {
        return versionTest == null && VersionUtilities.versionsMatch((String)versionTest, (String)versionActual);
    }

    public IWorkerContext.ValidationResult validateCode(Coding code) throws FHIRException {
        return this.validateCode("Coding", code);
    }

    public IWorkerContext.ValidationResult validateCode(String path, Coding code) throws FHIRException {
        String wv;
        String system;
        this.opContext.deadCheck();
        this.checkValueSetOptions();
        Object warningMessage = null;
        IWorkerContext.ValidationResult res = null;
        boolean inExpansion = false;
        boolean inInclude = false;
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        ValidationProcessInfo info = new ValidationProcessInfo(issues);
        VersionInfo vi = new VersionInfo(this);
        this.checkCanonical(issues, path, this.valueset, this.valueset);
        String string = system = code.hasSystem() ? code.getSystem() : this.getValueSetSystemOrNull();
        if (this.options.getValueSetMode() != ValidationOptions.ValueSetMode.CHECK_MEMERSHIP_ONLY) {
            if (system == null && !code.hasDisplay()) {
                ArrayList<String> problems = new ArrayList<String>();
                system = this.systemForCodeInValueSet(code.getCode(), problems);
                if (system == null) {
                    if (problems.size() == 0) {
                        throw new Error("Unable to resolve systems but no reason why");
                    }
                    if (problems.size() == 1) {
                        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, (String)problems.get(0), this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.UNKNOWN, path, (String)problems.get(0)));
                    }
                    IWorkerContext.ValidationResult vr = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((Object)problems).toString(), null);
                    for (String s : problems) {
                        vr.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.UNKNOWN, path, s));
                    }
                    return vr;
                }
            }
            if (!code.hasSystem()) {
                if (this.options.isGuessSystem() && system == null && Utilities.isAbsoluteUrl((String)code.getCode())) {
                    system = "urn:ietf:rfc:3986";
                }
                code.setSystem(system);
            }
            inExpansion = this.checkExpansion(code, vi);
            inInclude = this.checkInclude(code, vi);
            wv = vi.getVersion(system, code.getVersion());
            CodeSystem cs = this.resolveCodeSystem(system, wv);
            if (cs == null) {
                if (wv == null) {
                    warningMessage = this.context.formatMessage("UNKNOWN_CODESYSTEM", system);
                    this.unknownSystems.add(system);
                } else {
                    warningMessage = this.context.formatMessage("UNKNOWN_CODESYSTEM_VERSION", system, wv, this.resolveCodeSystemVersions(system).toString());
                    this.unknownSystems.add(system + "|" + wv);
                }
                if (!inExpansion) {
                    if (this.valueset != null && this.valueset.hasExpansion()) {
                        String msg = this.context.formatMessage("CODESYSTEM_CS_UNK_EXPANSION", this.valueset.getUrl(), code.getSystem(), code.getCode().toString());
                        issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path, msg));
                        throw new VSCheckerException(msg, issues);
                    }
                    issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path + ".system", (String)warningMessage));
                    res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, (String)warningMessage, issues);
                    if (this.valueset == null) {
                        throw new VSCheckerException((String)warningMessage, issues);
                    }
                }
            } else {
                this.checkCanonical(issues, path, cs, this.valueset);
            }
            if (cs != null && cs.hasSupplements()) {
                String msg = this.context.formatMessage("CODESYSTEM_CS_NO_SUPPLEMENT", cs.getUrl());
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path, msg));
            }
            if (cs != null && cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE) {
                warningMessage = "Resolved system " + system + (String)(cs.hasVersion() ? " (v" + cs.getVersion() + ")" : "") + ", but the definition is not complete";
                if (!inExpansion && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
                    throw new VSCheckerException((String)warningMessage, null, true);
                }
            }
            if (cs != null) {
                if (cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
                    ValueSet.ConceptReferenceComponent cc;
                    if (inInclude && (cc = this.findInInclude(code)) != null) {
                        String disp = this.getPreferredDisplay(cc);
                        res = new IWorkerContext.ValidationResult(system, cs.getVersion(), new CodeSystem.ConceptDefinitionComponent().setCode(cc.getCode()).setDisplay(disp), disp);
                        res.addToMessage("Resolved system " + system + ", but the definition is not complete, so assuming value set include is correct");
                        return res;
                    }
                    throw new FHIRException("Unable to evaluate based on empty code system");
                }
                res = this.validateCode(path, code, cs, null, info);
                res.setIssues(issues);
            } else if (cs == null && this.valueset.hasExpansion() && inExpansion) {
                res = new IWorkerContext.ValidationResult(system, wv, new CodeSystem.ConceptDefinitionComponent().setCode(code.getCode()).setDisplay(code.getDisplay()), code.getDisplay());
                if (!this.preferServerSide(system)) {
                    res.addToMessage("Code System unknown, so assuming value set expansion is correct (" + (String)warningMessage + ")");
                }
            } else if (this.throwToServer) {
                throw new FHIRException("No; try the server");
            }
        } else {
            inExpansion = this.checkExpansion(code, vi);
            inInclude = this.checkInclude(code, vi);
        }
        wv = vi.getVersion(system, code.getVersion());
        if (!this.checkRequiredSupplements(info)) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((OperationOutcome.OperationOutcomeIssueComponent)issues.get(issues.size() - 1)).getDetails().getText(), issues);
        }
        if (this.valueset != null && this.options.getValueSetMode() != ValidationOptions.ValueSetMode.NO_MEMBERSHIP_CHECK) {
            if (res == null || res.isOk()) {
                Boolean ok = this.codeInValueSet(path, system, wv, code.getCode(), info);
                if (ok == null || !ok.booleanValue()) {
                    if (res == null) {
                        res = new IWorkerContext.ValidationResult(null, null, info.getIssues());
                    }
                    if (info.getErr() != null) {
                        res.setErrorClass(info.getErr());
                    }
                    if (ok == null) {
                        String m = "Unable to check whether the code is in the value set " + this.valueset.getVersionedUrl();
                        res.addToMessage(m);
                        res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.NOTFOUND, path, m));
                        res.setUnknownSystems(this.unknownSystems);
                        res.setSeverity(ValidationMessage.IssueSeverity.ERROR);
                        res.setErrorClass(TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
                    } else if (!inExpansion && !inInclude) {
                        String msg = this.context.formatMessagePlural(1, "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getVersionedUrl(), "'" + code.toString() + "'");
                        res.addToMessage(msg).setSeverity(ValidationMessage.IssueSeverity.ERROR);
                        res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, path, msg));
                        res.setDefinition(null);
                        res.setSystem(null);
                        res.setDisplay(null);
                        res.setUnknownSystems(this.unknownSystems);
                    } else if (warningMessage != null) {
                        String msg = this.context.formatMessage("Code_found_in_expansion_however_", warningMessage);
                        res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg, this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, msg));
                    } else if (inExpansion) {
                        res.setMessage("Code found in expansion, however: " + res.getMessage());
                        res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, res.getMessage()));
                    } else if (inInclude) {
                        res.setMessage("Code found in include, however: " + res.getMessage());
                        res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, res.getMessage()));
                    }
                } else if (res == null) {
                    res = new IWorkerContext.ValidationResult(system, wv, null, null);
                }
            } else if (res != null && !res.isOk()) {
                String msg = this.context.formatMessagePlural(1, "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getVersionedUrl(), "'" + code.toString() + "'");
                res.setMessage(res.getMessage() + "; " + msg);
                res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, path, msg));
            }
        }
        if (res != null && res.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
            res.setSeverity(ValidationMessage.IssueSeverity.ERROR);
        }
        return res;
    }

    private void checkValueSetOptions() {
        if (this.valueset != null) {
            for (Extension ext : this.valueset.getCompose().getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinion/valueset-expansion-param")) {
                String name = ext.getExtensionString("name");
                DataType value = ext.getExtensionByUrl("value").getValue();
                if (!"displayLanguage".equals(name)) continue;
                this.options.setLanguages(value.primitiveValue());
            }
            if (!this.options.hasLanguages() && this.valueset.hasLanguage()) {
                this.options.addLanguage(this.valueset.getLanguage());
            }
        }
    }

    private boolean preferServerSide(String system) {
        if (SERVER_SIDE_LIST.contains(system)) {
            return true;
        }
        if (this.txCaps != null) {
            for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent tccs : this.txCaps.getCodeSystem()) {
                if (!system.equals(tccs.getUri())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkInclude(Coding code, VersionInfo vi) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return false;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getExclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return false;
            }
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            vi.setComposeVersion(inc.getVersion());
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSet.ConceptReferenceComponent findInInclude(Coding code) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return null;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem findSpecialCodeSystem(String system, String version) {
        if ("urn:ietf:rfc:3986".equals(system)) {
            CodeSystem cs = new CodeSystem();
            cs.setUrl(system);
            cs.setUserData("tx.cs.special", new URICodeSystem());
            cs.setContent(Enumerations.CodeSystemContentMode.COMPLETE);
            return cs;
        }
        return null;
    }

    private IWorkerContext.ValidationResult findCodeInExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return null;
        }
        return this.findCodeInExpansion(code, this.valueset.getExpansion().getContains());
    }

    private IWorkerContext.ValidationResult findCodeInExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            IWorkerContext.ValidationResult res;
            this.opContext.deadCheck();
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                CodeSystem.ConceptDefinitionComponent ccd = new CodeSystem.ConceptDefinitionComponent();
                ccd.setCode(containsComponent.getCode());
                ccd.setDisplay(containsComponent.getDisplay());
                IWorkerContext.ValidationResult res2 = new IWorkerContext.ValidationResult(code.getSystem(), code.hasVersion() ? code.getVersion() : containsComponent.getVersion(), ccd, this.getPreferredDisplay(ccd, null));
                return res2;
            }
            if (!containsComponent.hasContains() || (res = this.findCodeInExpansion(code, containsComponent.getContains())) == null) continue;
            return res;
        }
        return null;
    }

    private boolean checkExpansion(Coding code, VersionInfo vi) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return false;
        }
        return this.checkExpansion(code, this.valueset.getExpansion().getContains(), vi);
    }

    private boolean checkExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains, VersionInfo vi) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            this.opContext.deadCheck();
            if (containsComponent.hasSystem() && containsComponent.hasCode() && containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                vi.setExpansionVersion(containsComponent.getVersion());
                return true;
            }
            if (!containsComponent.hasContains() || !this.checkExpansion(code, containsComponent.getContains(), vi)) continue;
            return true;
        }
        return false;
    }

    private IWorkerContext.ValidationResult validateCode(String path, Coding code, CodeSystem cs, CodeableConcept vcc, ValidationProcessInfo info) {
        String msg;
        ConceptReferencePair vs;
        boolean inactive;
        CodeSystem.ConceptDefinitionComponent cc;
        CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = cc = cs.hasUserData("tx.cs.special") ? ((SpecialCodeSystem)cs.getUserData("tx.cs.special")).findConcept(code) : this.findCodeInConcept(cs.getConcept(), code.getCode(), this.allAltCodes);
        if (cc == null) {
            if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                String msg2 = this.context.formatMessage("UNKNOWN_CODE__IN_FRAGMENT", code.getCode(), cs.getUrl());
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg2, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, path + ".code", msg2));
            }
            String msg3 = this.context.formatMessage("Unknown_Code__in_", code.getCode(), cs.getUrl());
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg3, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, path + ".code", msg3));
        }
        Coding vc = new Coding().setCode(cc.getCode()).setSystem(cs.getUrl()).setVersion(cs.getVersion()).setDisplay(this.getPreferredDisplay(cc, cs));
        if (vcc != null) {
            vcc.addCoding(vc);
        }
        String status = (inactive = CodeSystemUtilities.isInactive(cs, cc)) ? CodeSystemUtilities.getStatus(cs, cc) : null;
        boolean ws = false;
        if (code.getDisplay() == null) {
            return new IWorkerContext.ValidationResult(code.getSystem(), cs.getVersion(), cc, vc.getDisplay()).setStatus(inactive, status);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(", ", " or ");
        if (cc.hasDisplay() && this.isOkLanguage(cs.getLanguage())) {
            b.append("'" + cc.getDisplay() + "'" + (String)(cs.hasLanguage() ? " (" + cs.getLanguage() + ")" : ""));
            if (code.getDisplay().equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs)).setStatus(inactive, status);
            }
            if (Utilities.normalize((String)code.getDisplay()).equals(Utilities.normalize((String)cc.getDisplay()))) {
                ws = true;
            }
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            this.opContext.deadCheck();
            if (!this.isOkLanguage(ds.getLanguage())) continue;
            b.append("'" + ds.getValue() + "'");
            if (code.getDisplay().equalsIgnoreCase(ds.getValue())) {
                return new IWorkerContext.ValidationResult(code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs)).setStatus(inactive, status);
            }
            if (!Utilities.normalize((String)code.getDisplay()).equalsIgnoreCase(Utilities.normalize((String)ds.getValue()))) continue;
            ws = true;
        }
        if (this.options.isUseValueSetDisplays() && (vs = this.findValueSetRef(code.getSystem(), code.getCode())) != null && (vs.getCc().hasDisplay() || vs.getCc().hasDesignation())) {
            if (vs.getCc().hasDisplay() && this.isOkLanguage(vs.getValueset().getLanguage())) {
                b.append("'" + vs.getCc().getDisplay() + "'");
                if (code.getDisplay().equalsIgnoreCase(vs.getCc().getDisplay())) {
                    return new IWorkerContext.ValidationResult(code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs)).setStatus(inactive, status);
                }
            }
            for (ValueSet.ConceptReferenceDesignationComponent ds : vs.getCc().getDesignation()) {
                this.opContext.deadCheck();
                if (!this.isOkLanguage(ds.getLanguage())) continue;
                b.append("'" + ds.getValue() + "'");
                if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
                return new IWorkerContext.ValidationResult(code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs)).setStatus(inactive, status);
            }
        }
        if (b.count() == 0) {
            msg = this.context.formatMessagePlural(this.options.getLanguages().getLangs().size(), "NO_VALID_DISPLAY_FOUND", code.getSystem(), code.getCode(), code.getDisplay(), this.options.langSummary());
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg, code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs), this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.INVALID, path + ".display", msg)).setStatus(inactive, status);
        }
        msg = this.context.formatMessagePlural(b.count(), ws ? "Display_Name_WS_for__should_be_one_of__instead_of" : "Display_Name_for__should_be_one_of__instead_of", code.getSystem(), code.getCode(), b.toString(), code.getDisplay(), this.options.langSummary());
        return new IWorkerContext.ValidationResult(this.dispWarningStatus(), msg, code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs), this.makeIssue(this.dispWarning(), OperationOutcome.IssueType.INVALID, path + ".display", msg)).setStatus(inactive, status);
    }

    private ValidationMessage.IssueSeverity dispWarning() {
        return this.options.isDisplayWarningMode() ? ValidationMessage.IssueSeverity.WARNING : ValidationMessage.IssueSeverity.ERROR;
    }

    private ValidationMessage.IssueSeverity dispWarningStatus() {
        return this.options.isDisplayWarningMode() ? ValidationMessage.IssueSeverity.WARNING : ValidationMessage.IssueSeverity.INFORMATION;
    }

    private boolean isOkLanguage(String language) {
        if (!this.options.hasLanguages()) {
            return true;
        }
        if (LanguageUtils.langsMatch(this.options.getLanguages(), language)) {
            return true;
        }
        return language == null && (this.options.langSummary().contains("en") || this.options.langSummary().contains("en-US") || this.options.isEnglishOk());
    }

    private ConceptReferencePair findValueSetRef(String system, String code) {
        if (this.valueset == null) {
            return null;
        }
        for (ValueSet.ValueSetExpansionContainsComponent exp : this.valueset.getExpansion().getContains()) {
            this.opContext.deadCheck();
            if (!system.equals(exp.getSystem()) || !code.equals(exp.getCode())) continue;
            ValueSet.ConceptReferenceComponent cc = new ValueSet.ConceptReferenceComponent();
            cc.setDisplay(exp.getDisplay());
            cc.setDesignation(exp.getDesignation());
            return new ConceptReferencePair(this.valueset, cc);
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (system.equals(inc.getSystem())) {
                for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                    if (!cc.getCode().equals(code)) continue;
                    return new ConceptReferencePair(this.valueset, cc);
                }
            }
            for (CanonicalType url : inc.getValueSet()) {
                ConceptReferencePair cc = this.getVs(url.asStringValue()).findValueSetRef(system, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private String gen(Coding code) {
        if (code.hasSystem()) {
            return code.getSystem() + "#" + code.getCode();
        }
        return null;
    }

    private String getValueSetSystemOrNull() throws FHIRException {
        if (this.valueset == null) {
            return null;
        }
        if (this.valueset.getCompose().getInclude().size() == 0) {
            if (!this.valueset.hasExpansion() || this.valueset.getExpansion().getContains().size() == 0) {
                return null;
            }
            String cs = this.valueset.getExpansion().getContains().get(0).getSystem();
            if (cs != null && this.checkSystem(this.valueset.getExpansion().getContains(), cs)) {
                return cs;
            }
            return null;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (inc.hasValueSet()) {
                return null;
            }
            if (inc.hasSystem()) continue;
            return null;
        }
        if (this.valueset.getCompose().getInclude().size() == 1) {
            return this.valueset.getCompose().getInclude().get(0).getSystem();
        }
        return null;
    }

    private boolean checkSystem(List<ValueSet.ValueSetExpansionContainsComponent> containsList, String system) {
        for (ValueSet.ValueSetExpansionContainsComponent contains : containsList) {
            if (contains.getSystem().equals(system) && (!contains.hasContains() || this.checkSystem(contains.getContains(), system))) continue;
            return false;
        }
        return true;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(CodeSystem.ConceptDefinitionComponent concept, String code, ValueSetProcessBase.AlternateCodesProcessingRules altCodeRules) {
        this.opContext.deadCheck();
        if (code.equals(concept.getCode())) {
            return concept;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(concept.getConcept(), code, altCodeRules);
        if (cc != null) {
            return cc;
        }
        if (concept.hasUserData("cs.utils.cross.link")) {
            List children = (List)concept.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                cc = this.findCodeInConcept(c, code, altCodeRules);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code, ValueSetProcessBase.AlternateCodesProcessingRules altCodeRules) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            if (Utilities.existsInList((String)code, this.alternateCodes(cc, altCodeRules))) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc, code, altCodeRules);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private List<String> alternateCodes(CodeSystem.ConceptDefinitionComponent focus, ValueSetProcessBase.AlternateCodesProcessingRules altCodeRules) {
        ArrayList<String> codes = new ArrayList<String>();
        for (CodeSystem.ConceptPropertyComponent p : focus.getProperty()) {
            if (!"alternateCode".equals(p.getCode()) || !altCodeRules.passes(p.getExtension()) || !p.getValue().isPrimitive()) continue;
            codes.add(p.getValue().primitiveValue());
        }
        return codes;
    }

    private String systemForCodeInValueSet(String code, List<String> problems) {
        HashSet<String> sys = new HashSet<String>();
        if (!this.scanForCodeInValueSet(code, sys, problems)) {
            return null;
        }
        if (sys.size() != 1) {
            problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_multiple_matches", ((Object)sys).toString()));
            return null;
        }
        return (String)sys.iterator().next();
    }

    private boolean scanForCodeInValueSet(String code, Set<String> sys, List<String> problems) {
        if (this.valueset.hasCompose()) {
            if (!this.valueset.getCompose().hasInclude() && !this.valueset.getExpansion().hasContains()) {
                problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_no_includes_or_expansion", this.valueset.getVersionedUrl()));
            }
            int i = 0;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                this.opContext.deadCheck();
                if (vsi.hasValueSet()) {
                    for (CanonicalType u : vsi.getValueSet()) {
                        if (this.checkForCodeInValueSet(code, (String)u.getValue(), sys, problems)) continue;
                        return false;
                    }
                } else if (!vsi.hasSystem()) {
                    problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_no_system", this.valueset.getVersionedUrl(), i));
                    return false;
                }
                if (vsi.hasSystem()) {
                    if (vsi.hasFilter()) {
                        problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_no_system", this.valueset.getVersionedUrl(), i, vsi.getSystem()));
                        return false;
                    }
                    CodeSystemProvider csp = CodeSystemProvider.factory(vsi.getSystem());
                    if (csp != null) {
                        Boolean ok = csp.checkCode(code);
                        if (ok == null) {
                            problems.add(this.context.formatMessage("UNABLE_TO_RESOLVE_SYSTEM_SYSTEM_IS_INDETERMINATE", this.valueset.getVersionedUrl(), vsi.getSystem()));
                            sys.add(vsi.getSystem());
                        } else if (ok.booleanValue()) {
                            sys.add(vsi.getSystem());
                        }
                    } else {
                        boolean match;
                        CodeSystem cs = this.resolveCodeSystem(vsi.getSystem(), vsi.getVersion());
                        if (cs != null && cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE) {
                            if (vsi.hasConcept()) {
                                for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                                    match = cs.getCaseSensitive() ? cc.getCode().equals(code) : cc.getCode().equalsIgnoreCase(code);
                                    if (!match) continue;
                                    sys.add(vsi.getSystem());
                                }
                            } else {
                                CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code, this.allAltCodes);
                                if (cc != null) {
                                    sys.add(vsi.getSystem());
                                }
                            }
                        } else if (vsi.hasConcept()) {
                            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                                match = cc.getCode().equals(code);
                                if (!match) continue;
                                sys.add(vsi.getSystem());
                            }
                        } else {
                            ValueSetExpansionOutcome vse = this.context.expandVS(vsi, false, false);
                            if (vse.isOk()) {
                                if (!this.checkSystems(vse.getValueset().getExpansion().getContains(), code, sys, problems)) {
                                    return false;
                                }
                            } else {
                                problems.add(this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_unknown_system", this.valueset.getVersionedUrl(), i, vsi.getSystem(), vse.getAllErrors().toString()));
                                return false;
                            }
                        }
                    }
                }
                ++i;
            }
        } else if (this.valueset.hasExpansion() && !this.checkSystems(this.valueset.getExpansion().getContains(), code, sys, problems)) {
            return false;
        }
        return true;
    }

    private boolean checkForCodeInValueSet(String code, String uri, Set<String> sys, List<String> problems) {
        ValueSetValidator vs = this.getVs(uri);
        return vs.scanForCodeInValueSet(code, sys, problems);
    }

    private boolean checkSystems(List<ValueSet.ValueSetExpansionContainsComponent> contains, String code, Set<String> systems, List<String> problems) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            this.opContext.deadCheck();
            if (c.getCode().equals(code)) {
                systems.add(c.getSystem());
            }
            if (!c.hasContains()) continue;
            this.checkSystems(c.getContains(), code, systems, problems);
        }
        return true;
    }

    public Boolean codeInValueSet(String path, String system, String version, String code, ValidationProcessInfo info) throws FHIRException {
        if (this.valueset == null) {
            return false;
        }
        this.opContext.deadCheck();
        this.checkCanonical(info.getIssues(), path, this.valueset, this.valueset);
        Boolean result = false;
        VersionInfo vi = new VersionInfo(this);
        if (this.valueset.hasExpansion()) {
            return this.checkExpansion(new Coding(system, code, null), vi);
        }
        if (this.valueset.hasCompose()) {
            int i = 0;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                Boolean ok = this.inComponent(path, vsi, i, system, version, code, this.valueset.getCompose().getInclude().size() == 1, info);
                ++i;
                if (ok == null && result != null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (ok == null || !ok.booleanValue()) continue;
                result = true;
                break;
            }
            i = this.valueset.getCompose().getInclude().size();
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                Boolean nok = this.inComponent(path, vsi, i, system, version, code, this.valueset.getCompose().getInclude().size() == 1, info);
                ++i;
                if (nok == null && result != null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (nok == null || !nok.booleanValue()) continue;
                result = false;
            }
        }
        return result;
    }

    private Boolean inComponent(String path, ValueSet.ConceptSetComponent vsi, int vsiIndex, String system, String version, String code, boolean only, ValidationProcessInfo info) throws FHIRException {
        List<CodeSystem.ConceptDefinitionComponent> list;
        this.opContext.deadCheck();
        boolean ok = true;
        if (vsi.hasValueSet()) {
            if (this.isValueSetUnionImports()) {
                ok = false;
                for (UriType uriType : vsi.getValueSet()) {
                    if (!this.inImport(path, (String)uriType.getValue(), system, version, code, info)) continue;
                    return true;
                }
            } else {
                ok = this.inImport(path, (String)vsi.getValueSet().get(0).getValue(), system, version, code, info);
                for (int i = 1; i < vsi.getValueSet().size(); ++i) {
                    UriType uriType = vsi.getValueSet().get(i);
                    ok = ok && this.inImport(path, (String)uriType.getValue(), system, version, code, info);
                }
            }
        }
        if (!vsi.hasSystem() || !ok) {
            return ok;
        }
        if (only && system == null) {
            for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
                if (!conceptReferenceComponent.getCode().equals(code)) continue;
                return true;
            }
        }
        if (system == null || !system.equals(vsi.getSystem())) {
            return false;
        }
        CodeSystem cs = this.resolveCodeSystem(system, version);
        if (cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
            if (this.throwToServer) {
                ValueSet valueSet = new ValueSet();
                valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
                valueSet.setUrl(this.valueset.getUrl() + "--" + vsiIndex);
                valueSet.setVersion(this.valueset.getVersion());
                valueSet.getCompose().addInclude(vsi);
                IWorkerContext.ValidationResult res = this.context.validateCode(this.options.withNoClient(), new Coding(system, code, null), valueSet);
                if (res.getErrorClass() == TerminologyServiceErrorClass.UNKNOWN || res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED || res.getErrorClass() == TerminologyServiceErrorClass.VALUESET_UNSUPPORTED) {
                    if (info != null && res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                        info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.UNKNOWN, path, this.context.formatMessage("Terminology_TX_System_NotKnown", system)));
                        for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                            if (!cc.getCode().equals(code)) continue;
                            return true;
                        }
                        info.setErr(TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
                        return null;
                    }
                    return false;
                }
                if (res.getErrorClass() == TerminologyServiceErrorClass.NOSERVICE) {
                    throw new NoTerminologyServiceException();
                }
                return res.isOk();
            }
            if (this.unknownSystems != null) {
                if (version == null) {
                    this.unknownSystems.add(system);
                } else {
                    this.unknownSystems.add(system + "|" + version);
                }
            }
            return null;
        }
        this.checkCanonical(info.getIssues(), path, cs, this.valueset);
        if (this.valueset.getCompose().hasInactive() && !this.valueset.getCompose().getInactive() && CodeSystemUtilities.isInactive(cs, code)) {
            return false;
        }
        if (vsi.hasFilter()) {
            ok = true;
            for (ValueSet.ConceptSetFilterComponent f : vsi.getFilter()) {
                if (this.codeInFilter(cs, system, f, code)) continue;
                return false;
            }
        }
        if ((ok = this.validateCodeInConceptList(code, cs, list = cs.getConcept(), this.allAltCodes)) && vsi.hasConcept()) {
            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                if (!cc.getCode().equals(code)) continue;
                return true;
            }
            return false;
        }
        ok = this.validateCodeInConceptList(code, cs, list, this.altCodeParams);
        return ok;
    }

    protected boolean isValueSetUnionImports() {
        PackageInformation p = this.valueset.getSourcePackage();
        if (p != null) {
            return p.getDate().before(new GregorianCalendar(2022, 2, 31).getTime());
        }
        return false;
    }

    private boolean codeInFilter(CodeSystem cs, String system, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        if ("concept".equals(f.getProperty())) {
            return this.codeInConceptFilter(cs, f, code);
        }
        if ("code".equals(f.getProperty()) && f.getOp() == Enumerations.FilterOperator.REGEX) {
            return this.codeInRegexFilter(cs, f, code);
        }
        if (CodeSystemUtilities.hasPropertyDef(cs, f.getProperty())) {
            return this.codeInPropertyFilter(cs, f, code);
        }
        System.out.println("todo: handle filters with property = " + f.getProperty() + " " + f.getOp().toCode());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__filter_with_property__", cs.getUrl(), f.getProperty(), f.getOp().toCode()));
    }

    private boolean codeInPropertyFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) {
        switch (f.getOp()) {
            case EQUAL: {
                if (f.getValue() == null) {
                    return false;
                }
                DataType d = CodeSystemUtilities.getProperty(cs, code, f.getProperty());
                return d != null && f.getValue().equals(d.primitiveValue());
            }
            case EXISTS: {
                return CodeSystemUtilities.getProperty(cs, code, f.getProperty()) != null;
            }
            case REGEX: {
                if (f.getValue() == null) {
                    return false;
                }
                DataType d = CodeSystemUtilities.getProperty(cs, code, f.getProperty());
                return d != null && d.primitiveValue() != null && d.primitiveValue().matches(f.getValue());
            }
        }
        System.out.println("todo: handle property filters with op = " + f.getOp());
        throw new FHIRException(this.context.formatMessage("UNABLE_TO_HANDLE_SYSTEM__PROPERTY_FILTER_WITH_OP__", new Object[]{cs.getUrl(), f.getOp()}));
    }

    private boolean codeInRegexFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) {
        return code.matches(f.getValue());
    }

    private boolean codeInConceptFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        switch (f.getOp()) {
            case ISA: {
                return this.codeInConceptIsAFilter(cs, f, code, false);
            }
            case ISNOTA: {
                return !this.codeInConceptIsAFilter(cs, f, code, false);
            }
            case DESCENDENTOF: {
                return this.codeInConceptIsAFilter(cs, f, code, true);
            }
        }
        System.out.println("todo: handle concept filters with op = " + f.getOp());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__concept_filter_with_op__", new Object[]{cs.getUrl(), f.getOp()}));
    }

    private boolean codeInConceptIsAFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code, boolean excludeRoot) {
        if (!excludeRoot && code.equals(f.getValue())) {
            return true;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), f.getValue(), this.altCodeParams);
        if (cc == null) {
            return false;
        }
        CodeSystem.ConceptDefinitionComponent cc2 = this.findCodeInConcept(cc, code, this.altCodeParams);
        return cc2 != null && cc2 != cc;
    }

    public boolean validateCodeInConceptList(String code, CodeSystem def, List<CodeSystem.ConceptDefinitionComponent> list, ValueSetProcessBase.AlternateCodesProcessingRules altCodeRules) {
        this.opContext.deadCheck();
        if (def.getCaseSensitive()) {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equals(code)) {
                    return true;
                }
                if (Utilities.existsInList((String)code, this.alternateCodes(cc, altCodeRules))) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept(), altCodeRules)) continue;
                return true;
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equalsIgnoreCase(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept(), altCodeRules)) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSetValidator getVs(String url) {
        if (this.inner.containsKey(url)) {
            return this.inner.get(url);
        }
        ValueSet vs = this.context.fetchResource(ValueSet.class, url, this.valueset);
        ValueSetValidator vsc = new ValueSetValidator(this.context, this.opContext.copy(), this.options, vs, this.localContext, this.expansionProfile, this.txCaps);
        vsc.setThrowToServer(this.throwToServer);
        this.inner.put(url, vsc);
        return vsc;
    }

    private boolean inImport(String path, String uri, String system, String version, String code, ValidationProcessInfo info) throws FHIRException {
        ValueSetValidator vs = this.getVs(uri);
        if (vs == null) {
            return false;
        }
        Boolean ok = vs.codeInValueSet(path, system, version, code, info);
        return ok != null && ok != false;
    }

    private String getPreferredDisplay(ValueSet.ConceptReferenceComponent cc) {
        if (!this.options.hasLanguages()) {
            return cc.getDisplay();
        }
        if (LanguageUtils.langsMatch(this.options.getLanguages(), this.valueset.getLanguage())) {
            return cc.getDisplay();
        }
        if (this.valueset.getLanguage() == null && (this.options.langSummary().contains("en") || this.options.langSummary().contains("en-US"))) {
            return cc.getDisplay();
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
            if (d.hasUse() || !LanguageUtils.langsMatch(this.options.getLanguages(), d.getLanguage())) continue;
            return d.getValue();
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
            if (!LanguageUtils.langsMatch(this.options.getLanguages(), d.getLanguage())) continue;
            return d.getValue();
        }
        return cc.getDisplay();
    }

    private String getPreferredDisplay(CodeSystem.ConceptDefinitionComponent cc, CodeSystem cs) {
        if (!this.options.hasLanguages()) {
            return cc.getDisplay();
        }
        if (cs != null && LanguageUtils.langsMatch(this.options.getLanguages(), cs.getLanguage())) {
            return cc.getDisplay();
        }
        if ((cs == null || cs.getLanguage() == null) && (this.options.langSummary().contains("en") || this.options.langSummary().contains("en-US"))) {
            return cc.getDisplay();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cc.getDesignation()) {
            if (d.hasUse() || !LanguageUtils.langsMatch(this.options.getLanguages(), d.getLanguage())) continue;
            return d.getValue();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cc.getDesignation()) {
            if (!LanguageUtils.langsMatch(this.options.getLanguages(), d.getLanguage())) continue;
            return d.getValue();
        }
        return cc.getDisplay();
    }
}

