/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.test.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.utilities.tests.BaseTestingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CompareUtilities
extends BaseTestingUtilities {
    private static final boolean SHOW_DIFF = false;
    private JsonObject externals;

    public String createNotEqualMessage(String message, String expected, String actual) {
        return message + '\n' + "Expected :" + this.presentExpected(expected) + '\n' + "Actual  :" + ("\"" + actual + "\"");
    }

    private String presentExpected(String expected) {
        if (expected.startsWith("$") && expected.endsWith("$")) {
            if (expected.startsWith("$choice:")) {
                return "Contains one of " + this.readChoices(expected.substring(8, expected.length() - 1)).toString();
            }
            if (expected.startsWith("$fragments:")) {
                List<String> fragments = this.readChoices(expected.substring(11, expected.length() - 1));
                return "Contains all of " + fragments.toString();
            }
            if (expected.startsWith("$external:")) {
                String[] cmd = expected.substring(1, expected.length() - 1).split(":");
                if (this.externals != null) {
                    String s = this.externals.asString(cmd[1]);
                    return "\"" + s + "\" (Ext)";
                }
                List<String> fragments = this.readChoices(cmd[2]);
                return "Contains all of " + fragments.toString() + " (because no external string provided for " + cmd[1] + ")";
            }
            switch (expected) {
                case "$$": {
                    return "$$";
                }
                case "$instant$": {
                    return "\"An Instant\"";
                }
                case "$uuid$": {
                    return "\"A Uuid\"";
                }
            }
            return "Unhandled template: " + expected;
        }
        return "\"" + expected + "\"";
    }

    public static String checkXMLIsSame(InputStream expected, InputStream actual) throws Exception {
        CompareUtilities self = new CompareUtilities();
        String result = self.compareXml(expected, actual);
        return result;
    }

    public static String checkXMLIsSame(String expected, String actual) throws Exception {
        CompareUtilities self = new CompareUtilities();
        String result = self.compareXml(expected, actual);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    private static String getDiffTool() throws IOException {
        if (FhirSettings.hasDiffToolPath()) {
            return FhirSettings.getDiffToolPath();
        }
        if (System.getenv("ProgramFiles") != null) {
            return Utilities.path((String[])new String[]{System.getenv("ProgramFiles"), "WinMerge", "WinMergeU.exe"});
        }
        return null;
    }

    private String compareXml(InputStream expected, InputStream actual) throws Exception {
        return this.compareElements("", this.loadXml(expected).getDocumentElement(), this.loadXml(actual).getDocumentElement());
    }

    private String compareXml(String expected, String actual) throws Exception {
        return this.compareElements("", this.loadXml(expected).getDocumentElement(), this.loadXml(actual).getDocumentElement());
    }

    private String compareElements(String path, Element expectedElement, Element actualElement) {
        if (!this.namespacesMatch(expectedElement.getNamespaceURI(), actualElement.getNamespaceURI())) {
            return this.createNotEqualMessage("Namespaces differ at " + (String)path, expectedElement.getNamespaceURI(), actualElement.getNamespaceURI());
        }
        if (!expectedElement.getLocalName().equals(actualElement.getLocalName())) {
            return this.createNotEqualMessage("Names differ at " + (String)path, expectedElement.getLocalName(), actualElement.getLocalName());
        }
        String s = this.compareAttributes((String)(path = (String)path + "/" + expectedElement.getLocalName()), expectedElement.getAttributes(), actualElement.getAttributes());
        if (!Utilities.noString((String)s)) {
            return s;
        }
        s = this.compareAttributes((String)path, expectedElement.getAttributes(), actualElement.getAttributes());
        if (!Utilities.noString((String)s)) {
            return s;
        }
        Node expectedChild = expectedElement.getFirstChild();
        Node actualChild = actualElement.getFirstChild();
        expectedChild = this.skipBlankText(expectedChild);
        actualChild = this.skipBlankText(actualChild);
        while (expectedChild != null && actualChild != null) {
            if (expectedChild.getNodeType() != actualChild.getNodeType()) {
                return this.createNotEqualMessage("node type mismatch in children of " + (String)path, Short.toString(expectedElement.getNodeType()), Short.toString(actualElement.getNodeType()));
            }
            if (expectedChild.getNodeType() == 3) {
                if (!this.normalise(expectedChild.getTextContent()).equals(this.normalise(actualChild.getTextContent()))) {
                    return this.createNotEqualMessage("Text differs at " + (String)path, this.normalise(expectedChild.getTextContent()).toString(), this.normalise(actualChild.getTextContent()).toString());
                }
            } else if (expectedChild.getNodeType() == 1 && !Utilities.noString((String)(s = this.compareElements((String)path, (Element)expectedChild, (Element)actualChild)))) {
                return s;
            }
            expectedChild = this.skipBlankText(expectedChild.getNextSibling());
            actualChild = this.skipBlankText(actualChild.getNextSibling());
        }
        if (expectedChild != null) {
            return "node mismatch - more nodes in actual in children of " + (String)path;
        }
        if (actualChild != null) {
            return "node mismatch - more nodes in expected in children of " + (String)path;
        }
        return null;
    }

    private boolean namespacesMatch(String ns1, String ns2) {
        return ns1 == null ? ns2 == null : ns1.equals(ns2);
    }

    private String normalise(String text) {
        String result = text.trim().replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        while (result.contains("  ")) {
            result = result.replace("  ", " ");
        }
        return result;
    }

    private String compareAttributes(String path, NamedNodeMap expected, NamedNodeMap actual) {
        for (int i = 0; i < expected.getLength(); ++i) {
            byte[] b2;
            byte[] b1;
            Node expectedNode = expected.item(i);
            String expectedNodeName = expectedNode.getNodeName();
            if (expectedNodeName.equals("xmlns") || expectedNodeName.startsWith("xmlns:")) continue;
            Node actualNode = actual.getNamedItem(expectedNodeName);
            if (actualNode == null) {
                return "Attributes differ at " + path + ": missing attribute " + expectedNodeName;
            }
            if (this.normalise(expectedNode.getTextContent()).equals(this.normalise(actualNode.getTextContent())) || this.sameBytes(b1 = this.unBase64(expectedNode.getTextContent()), b2 = this.unBase64(actualNode.getTextContent()))) continue;
            return this.createNotEqualMessage("Attributes differ at " + path, this.normalise(expectedNode.getTextContent()).toString(), this.normalise(actualNode.getTextContent()).toString());
        }
        return null;
    }

    private boolean sameBytes(byte[] b1, byte[] b2) {
        if (b1.length == 0 || b2.length == 0) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] unBase64(String text) {
        return Base64.decodeBase64((String)text);
    }

    private Node skipBlankText(Node node) {
        while (node != null && (node.getNodeType() == 3 && StringUtils.isWhitespace((CharSequence)node.getTextContent()) || node.getNodeType() == 8)) {
            node = node.getNextSibling();
        }
        return node;
    }

    private Document loadXml(String fn) throws Exception {
        return this.loadXml(new FileInputStream(fn));
    }

    private Document loadXml(InputStream fn) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(fn);
    }

    public static String checkJsonSrcIsSame(String expected, String actual, JsonObject externals) throws FileNotFoundException, IOException {
        return CompareUtilities.checkJsonSrcIsSame(expected, actual, true, externals);
    }

    public static String checkJsonSrcIsSame(String expectedString, String actualString, boolean showDiff, JsonObject externals) throws FileNotFoundException, IOException {
        CompareUtilities self = new CompareUtilities();
        self.externals = externals;
        String result = self.compareJsonSrc(expectedString, actualString);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    public static String checkJsonIsSame(String expected, String actual) throws FileNotFoundException, IOException {
        CompareUtilities self = new CompareUtilities();
        String result = self.compareJson(expected, actual);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    private String compareJsonSrc(String expected, String actual) throws FileNotFoundException, IOException {
        JsonObject actualJsonObject = JsonParser.parseObject((String)actual);
        JsonObject expectedJsonObject = JsonParser.parseObject((String)expected);
        return this.compareObjects("", expectedJsonObject, actualJsonObject);
    }

    private String compareJson(String expected, String actual) throws FileNotFoundException, IOException {
        JsonObject actualJsonObject = JsonParser.parseObject((String)TextFile.fileToString((String)actual));
        JsonObject expectedJsonObject = JsonParser.parseObject((String)TextFile.fileToString((String)expected));
        return this.compareObjects("", expectedJsonObject, actualJsonObject);
    }

    private String compareObjects(String path, JsonObject expectedJsonObject, JsonObject actualJsonObject) {
        String n;
        List<String> optionals = this.listOptionals(expectedJsonObject);
        for (JsonProperty en : actualJsonObject.getProperties()) {
            n = en.getName();
            if (n.equals("fhir_comments")) continue;
            if (expectedJsonObject.has(n)) {
                String s = this.compareNodes(path + "." + n, expectedJsonObject.get(n), en.getValue());
                if (Utilities.noString((String)s)) continue;
                return s;
            }
            return "properties differ at " + path + ": missing property " + n;
        }
        for (JsonProperty en : expectedJsonObject.getProperties()) {
            n = en.getName();
            if (n.equals("fhir_comments") || n.equals("$optional$") || optionals.contains(n) || actualJsonObject.has(n)) continue;
            return "properties differ at " + path + ": missing property " + n;
        }
        return null;
    }

    private List<String> listOptionals(JsonObject expectedJsonObject) {
        ArrayList<String> res = new ArrayList<String>();
        if (expectedJsonObject.has("$optional-properties$")) {
            res.add("$optional-properties$");
            for (String s : expectedJsonObject.getStrings("$optional-properties$")) {
                res.add(s);
            }
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String compareNodes(String path, JsonElement expectedJsonElement, JsonElement actualJsonElement) {
        if (!(expectedJsonElement instanceof JsonPrimitive && actualJsonElement instanceof JsonPrimitive || actualJsonElement.getClass() == expectedJsonElement.getClass())) {
            return this.createNotEqualMessage("properties differ at " + path, expectedJsonElement.getClass().getName(), actualJsonElement.getClass().getName());
        }
        if (actualJsonElement instanceof JsonPrimitive) {
            JsonPrimitive actualJsonPrimitive = (JsonPrimitive)actualJsonElement;
            JsonPrimitive expectedJsonPrimitive = (JsonPrimitive)expectedJsonElement;
            if (actualJsonPrimitive.isJsonBoolean() && expectedJsonPrimitive.isJsonBoolean()) {
                if (actualJsonPrimitive.asBoolean() == expectedJsonPrimitive.asBoolean()) return null;
                return this.createNotEqualMessage("boolean property values differ at " + path, expectedJsonPrimitive.asString(), actualJsonPrimitive.asString());
            }
            if (actualJsonPrimitive.isJsonString() && expectedJsonPrimitive.isJsonString()) {
                String actualJsonString = actualJsonPrimitive.asString();
                String expectedJsonString = expectedJsonPrimitive.asString();
                if (actualJsonString.contains("<div")) {
                    if (expectedJsonString.contains("<div")) return null;
                }
                if (this.matches(actualJsonString, expectedJsonString)) return null;
                if (this.sameBytes(this.unBase64(actualJsonString), this.unBase64(expectedJsonString))) return null;
                return this.createNotEqualMessage("string property values differ at " + path, expectedJsonString, actualJsonString);
            }
            if (actualJsonPrimitive.isJsonNumber() && expectedJsonPrimitive.isJsonNumber()) {
                if (actualJsonPrimitive.asString().equals(expectedJsonPrimitive.asString())) return null;
                return this.createNotEqualMessage("number property values differ at " + path, expectedJsonPrimitive.asString(), actualJsonPrimitive.asString());
            }
            if (!(expectedJsonElement instanceof JsonNull)) return this.createNotEqualMessage("property types differ at " + path, expectedJsonPrimitive.asString(), actualJsonPrimitive.asString());
            if (actualJsonPrimitive instanceof JsonNull) {
                return null;
            }
            String string = this.createNotEqualMessage("null Properties differ at " + path, "null", actualJsonPrimitive.asString());
            return string;
        }
        if (actualJsonElement instanceof JsonObject) {
            String s = this.compareObjects(path, (JsonObject)expectedJsonElement, (JsonObject)actualJsonElement);
            if (Utilities.noString((String)s)) return null;
            return s;
        }
        if (!(actualJsonElement instanceof JsonArray)) return "unhandled property " + actualJsonElement.getClass().getName();
        JsonArray actualArray = (JsonArray)actualJsonElement;
        JsonArray expectedArray = (JsonArray)expectedJsonElement;
        int expectedMin = this.countExpectedMin(expectedArray);
        int as = actualArray.size();
        int es = expectedArray.size();
        int oc = this.optionalCount(expectedArray);
        if (as > es) return this.createNotEqualMessage("array item count differs at " + path, Integer.toString(es), Integer.toString(as));
        if (as < expectedMin) {
            return this.createNotEqualMessage("array item count differs at " + path, Integer.toString(es), Integer.toString(as));
        }
        int c = 0;
        for (int i = 0; i < es; ++i) {
            if (c >= as) {
                if (i < es - oc) return "One or more array items did not match at " + path + " starting at index " + i;
                if (!this.isOptional(expectedArray.get(i))) return "One or more array items did not match at " + path + " starting at index " + i;
                return null;
            }
            String s = this.compareNodes(path + "[" + Integer.toString(i) + "]", expectedArray.get(i), actualArray.get(c));
            if (!Utilities.noString((String)s) && !this.isOptional(expectedArray.get(i))) {
                return s;
            }
            if (!Utilities.noString((String)s)) continue;
            ++c;
        }
        if (c >= as) return null;
        return "Unexpected Node found in array at index " + c;
    }

    private int optionalCount(JsonArray arr) {
        int c = 0;
        for (JsonElement e : arr) {
            JsonObject j;
            if (!e.isJsonObject() || !(j = e.asJsonObject()).has("$optional$") || !j.asBoolean("$optional$")) continue;
            ++c;
        }
        return c;
    }

    private boolean isOptional(JsonElement e) {
        return e.isJsonObject() && e.asJsonObject().has("$optional$");
    }

    private int countExpectedMin(JsonArray array) {
        int count = array.size();
        for (JsonElement e : array) {
            if (!this.isOptional(e)) continue;
            --count;
        }
        return count;
    }

    private boolean matches(String actualJsonString, String expectedJsonString) {
        if (expectedJsonString.startsWith("$") && expectedJsonString.endsWith("$")) {
            if (expectedJsonString.startsWith("$choice:")) {
                return Utilities.existsInList((String)actualJsonString, this.readChoices(expectedJsonString.substring(8, expectedJsonString.length() - 1)));
            }
            if (expectedJsonString.startsWith("$fragments:")) {
                List<String> fragments = this.readChoices(expectedJsonString.substring(11, expectedJsonString.length() - 1));
                for (String f : fragments) {
                    if (actualJsonString.toLowerCase().contains(f.toLowerCase())) continue;
                    return false;
                }
                return true;
            }
            if (expectedJsonString.startsWith("$external:")) {
                String[] cmd = expectedJsonString.substring(1, expectedJsonString.length() - 1).split("\\:");
                if (this.externals != null) {
                    String s = this.externals.asString(cmd[1]);
                    return actualJsonString.equals(s);
                }
                List<String> fragments = this.readChoices(cmd[2]);
                for (String f : fragments) {
                    if (actualJsonString.toLowerCase().contains(f.toLowerCase())) continue;
                    return false;
                }
                return true;
            }
            switch (expectedJsonString) {
                case "$$": {
                    return true;
                }
                case "$instant$": {
                    return actualJsonString.matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]{1,9})?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))");
                }
                case "$uuid$": {
                    return actualJsonString.matches("urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
                }
            }
            throw new Error("Unhandled template: " + expectedJsonString);
        }
        return actualJsonString.equals(expectedJsonString);
    }

    private List<String> readChoices(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (String p : s.split("\\|")) {
            list.add(p);
        }
        return list;
    }

    public static String checkTextIsSame(String expected, String actual) throws FileNotFoundException, IOException {
        return CompareUtilities.checkTextIsSame(expected, actual, true);
    }

    public static String checkTextIsSame(String expectedString, String actualString, boolean showDiff) throws FileNotFoundException, IOException {
        CompareUtilities self = new CompareUtilities();
        String result = self.compareText(expectedString, actualString);
        if (result != null) {
            // empty if block
        }
        return result;
    }

    private String compareText(String expectedString, String actualString) {
        for (int i = 0; i < Integer.min(expectedString.length(), actualString.length()); ++i) {
            if (expectedString.charAt(i) == actualString.charAt(i)) continue;
            return this.createNotEqualMessage("Strings differ at character " + Integer.toString(i), String.valueOf(expectedString.charAt(i)), String.valueOf(actualString.charAt(i)));
        }
        if (expectedString.length() != actualString.length()) {
            return this.createNotEqualMessage("Strings differ in length but match to the end of the shortest.", Integer.toString(expectedString.length()), Integer.toString(actualString.length()));
        }
        return null;
    }
}

