/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValidatedFragment {
    private String name;
    private String elementPath;
    private String extension;
    private Element element;
    private byte[] content;
    private final boolean isDerivedContent;
    public static final String FOCUS_NAME = "focus";
    private List<ValidationMessage> errors = new ArrayList<ValidationMessage>();

    public ValidatedFragment(String name, String extension, Element element, byte[] content, boolean isDerivedContent) {
        this.name = name;
        this.element = element;
        this.content = content;
        this.extension = extension;
        this.isDerivedContent = isDerivedContent;
    }

    public ValidatedFragment(String name, String extension, byte[] content, boolean isDerivedContent) {
        this.name = name;
        this.content = content;
        this.extension = extension;
        this.isDerivedContent = isDerivedContent;
    }

    public String getFilename() {
        return this.name + "." + this.extension;
    }

    public String path() {
        return this.elementPath == null ? this.name : this.elementPath;
    }

    public String getName() {
        return this.name;
    }

    public String getElementPath() {
        return this.elementPath;
    }

    public void setElementPath(String elementPath) {
        this.elementPath = elementPath;
    }

    public String getExtension() {
        return this.extension;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean isDerivedContent() {
        return this.isDerivedContent;
    }

    public List<ValidationMessage> getErrors() {
        return this.errors;
    }
}

