/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="DeviceAssociation", profile="http://hl7.org/fhir/StructureDefinition/DeviceAssociation")
public class DeviceAssociation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instance identifier", formalDefinition="Instance identifier.")
    protected List<Identifier> identifier;
    @Child(name="device", type={Device.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to the devices associated with the patient or group", formalDefinition="Reference to the devices associated with the patient or group.")
    protected Reference device;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Describes the relationship between the device and subject", formalDefinition="Describes the relationship between the device and subject.")
    protected List<CodeableConcept> category;
    @Child(name="status", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="implanted | explanted | attached | entered-in-error | unknown", formalDefinition="Indicates the state of the Device association.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/deviceassociation-status")
    protected CodeableConcept status;
    @Child(name="statusReason", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The reasons given for the current association status", formalDefinition="The reasons given for the current association status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/deviceassociation-status-reason")
    protected List<CodeableConcept> statusReason;
    @Child(name="subject", type={Patient.class, Group.class, Practitioner.class, RelatedPerson.class, Device.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The individual, group of individuals or device that the device is on or associated with", formalDefinition="The individual, group of individuals or device that the device is on or associated with.")
    protected Reference subject;
    @Child(name="bodyStructure", type={BodyStructure.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Current anatomical location of the device in/on subject", formalDefinition="Current anatomical location of the device in/on subject.")
    protected Reference bodyStructure;
    @Child(name="period", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Begin and end dates and times for the device association", formalDefinition="Begin and end dates and times for the device association.")
    protected Period period;
    @Child(name="operation", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The details about the device when it is in use to describe its operation", formalDefinition="The details about the device when it is in use to describe its operation.")
    protected List<DeviceAssociationOperationComponent> operation;
    private static final long serialVersionUID = 1892071017L;
    @SearchParamDefinition(name="device", path="DeviceAssociation.device", description="Search for products that match this code", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device")}, target={Device.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("DeviceAssociation:device").toLocked();
    @SearchParamDefinition(name="identifier", path="DeviceAssociation.identifier", description="The identifier of the device association", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="operator", path="DeviceAssociation.operation.operator", description="The identity of a operator for whom to list associations", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_OPERATOR = "operator";
    public static final ReferenceClientParam OPERATOR = new ReferenceClientParam("operator");
    public static final Include INCLUDE_OPERATOR = new Include("DeviceAssociation:operator").toLocked();
    @SearchParamDefinition(name="patient", path="DeviceAssociation.subject.where(resolve() is Patient)", description="The identity of a patient for whom to list associations", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DeviceAssociation:patient").toLocked();
    @SearchParamDefinition(name="status", path="DeviceAssociation.status", description="The status of the device associations", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DeviceAssociation.subject.where(resolve() is Patient)", description="The identity of a patient for whom to list associations", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceAssociation:subject").toLocked();

    public DeviceAssociation() {
    }

    public DeviceAssociation(Reference device, CodeableConcept status) {
        this.setDevice(device);
        this.setStatus(status);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceAssociation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceAssociation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceAssociation.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public DeviceAssociation setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DeviceAssociation setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DeviceAssociation addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceAssociation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DeviceAssociation setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public List<CodeableConcept> getStatusReason() {
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        return this.statusReason;
    }

    public DeviceAssociation setStatusReason(List<CodeableConcept> theStatusReason) {
        this.statusReason = theStatusReason;
        return this;
    }

    public boolean hasStatusReason() {
        if (this.statusReason == null) {
            return false;
        }
        for (CodeableConcept item : this.statusReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addStatusReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return t;
    }

    public DeviceAssociation addStatusReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.statusReason == null) {
            this.statusReason = new ArrayList<CodeableConcept>();
        }
        this.statusReason.add(t);
        return this;
    }

    public CodeableConcept getStatusReasonFirstRep() {
        if (this.getStatusReason().isEmpty()) {
            this.addStatusReason();
        }
        return this.getStatusReason().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceAssociation.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DeviceAssociation setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getBodyStructure() {
        if (this.bodyStructure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceAssociation.bodyStructure");
            }
            if (Configuration.doAutoCreate()) {
                this.bodyStructure = new Reference();
            }
        }
        return this.bodyStructure;
    }

    public boolean hasBodyStructure() {
        return this.bodyStructure != null && !this.bodyStructure.isEmpty();
    }

    public DeviceAssociation setBodyStructure(Reference value) {
        this.bodyStructure = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceAssociation.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public DeviceAssociation setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<DeviceAssociationOperationComponent> getOperation() {
        if (this.operation == null) {
            this.operation = new ArrayList<DeviceAssociationOperationComponent>();
        }
        return this.operation;
    }

    public DeviceAssociation setOperation(List<DeviceAssociationOperationComponent> theOperation) {
        this.operation = theOperation;
        return this;
    }

    public boolean hasOperation() {
        if (this.operation == null) {
            return false;
        }
        for (DeviceAssociationOperationComponent item : this.operation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceAssociationOperationComponent addOperation() {
        DeviceAssociationOperationComponent t = new DeviceAssociationOperationComponent();
        if (this.operation == null) {
            this.operation = new ArrayList<DeviceAssociationOperationComponent>();
        }
        this.operation.add(t);
        return t;
    }

    public DeviceAssociation addOperation(DeviceAssociationOperationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.operation == null) {
            this.operation = new ArrayList<DeviceAssociationOperationComponent>();
        }
        this.operation.add(t);
        return this;
    }

    public DeviceAssociationOperationComponent getOperationFirstRep() {
        if (this.getOperation().isEmpty()) {
            this.addOperation();
        }
        return this.getOperation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Instance identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_DEVICE, "Reference(Device)", "Reference to the devices associated with the patient or group.", 0, 1, this.device));
        children.add(new Property("category", "CodeableConcept", "Describes the relationship between the device and subject.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_STATUS, "CodeableConcept", "Indicates the state of the Device association.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableConcept", "The reasons given for the current association status.", 0, Integer.MAX_VALUE, this.statusReason));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Practitioner|RelatedPerson|Device)", "The individual, group of individuals or device that the device is on or associated with.", 0, 1, this.subject));
        children.add(new Property("bodyStructure", "Reference(BodyStructure)", "Current anatomical location of the device in/on subject.", 0, 1, this.bodyStructure));
        children.add(new Property("period", "Period", "Begin and end dates and times for the device association.", 0, 1, this.period));
        children.add(new Property("operation", "", "The details about the device when it is in use to describe its operation.", 0, Integer.MAX_VALUE, this.operation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Instance identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "Reference(Device)", "Reference to the devices associated with the patient or group.", 0, 1, this.device);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Describes the relationship between the device and subject.", 0, Integer.MAX_VALUE, this.category);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "Indicates the state of the Device association.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableConcept", "The reasons given for the current association status.", 0, Integer.MAX_VALUE, this.statusReason);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Practitioner|RelatedPerson|Device)", "The individual, group of individuals or device that the device is on or associated with.", 0, 1, this.subject);
            }
            case -1001731599: {
                return new Property("bodyStructure", "Reference(BodyStructure)", "Current anatomical location of the device in/on subject.", 0, 1, this.bodyStructure);
            }
            case -991726143: {
                return new Property("period", "Period", "Begin and end dates and times for the device association.", 0, 1, this.period);
            }
            case 1662702951: {
                return new Property("operation", "", "The details about the device when it is in use to describe its operation.", 0, Integer.MAX_VALUE, this.operation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.device;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                return this.statusReason == null ? new Base[]{} : this.statusReason.toArray(new Base[this.statusReason.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case -1001731599: {
                Base[] baseArray;
                if (this.bodyStructure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.bodyStructure;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.period;
                }
                return baseArray;
            }
            case 1662702951: {
                return this.operation == null ? new Base[]{} : this.operation.toArray(new Base[this.operation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1335157162: {
                this.device = TypeConvertor.castToReference(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 2051346646: {
                this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -1001731599: {
                this.bodyStructure = TypeConvertor.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 1662702951: {
                this.getOperation().add((DeviceAssociationOperationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_DEVICE)) {
            this.device = TypeConvertor.castToReference(value);
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("statusReason")) {
            this.getStatusReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("bodyStructure")) {
            this.bodyStructure = TypeConvertor.castToReference(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("operation")) {
            this.getOperation().add((DeviceAssociationOperationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = null;
        } else if (name.equals("category")) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("statusReason")) {
            this.getStatusReason().remove(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals("bodyStructure")) {
            this.bodyStructure = null;
        } else if (name.equals("period")) {
            this.period = null;
        } else if (name.equals("operation")) {
            this.getOperation().remove((DeviceAssociationOperationComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 2051346646: {
                return this.addStatusReason();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -1001731599: {
                return this.getBodyStructure();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1662702951: {
                return this.addOperation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 2051346646: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -1001731599: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1662702951: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("statusReason")) {
            return this.addStatusReason();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("bodyStructure")) {
            this.bodyStructure = new Reference();
            return this.bodyStructure;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("operation")) {
            return this.addOperation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceAssociation";
    }

    @Override
    public DeviceAssociation copy() {
        DeviceAssociation dst = new DeviceAssociation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DeviceAssociation dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Reference reference = dst.device = this.device == null ? null : this.device.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusReason != null) {
            dst.statusReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.statusReason) {
                dst.statusReason.add(codeableConcept2.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.bodyStructure = this.bodyStructure == null ? null : this.bodyStructure.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.operation != null) {
            dst.operation = new ArrayList<DeviceAssociationOperationComponent>();
            for (DeviceAssociationOperationComponent deviceAssociationOperationComponent : this.operation) {
                dst.operation.add(deviceAssociationOperationComponent.copy());
            }
        }
    }

    protected DeviceAssociation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceAssociation)) {
            return false;
        }
        DeviceAssociation o = (DeviceAssociation)other_;
        return DeviceAssociation.compareDeep(this.identifier, o.identifier, true) && DeviceAssociation.compareDeep(this.device, o.device, true) && DeviceAssociation.compareDeep(this.category, o.category, true) && DeviceAssociation.compareDeep(this.status, o.status, true) && DeviceAssociation.compareDeep(this.statusReason, o.statusReason, true) && DeviceAssociation.compareDeep(this.subject, o.subject, true) && DeviceAssociation.compareDeep(this.bodyStructure, o.bodyStructure, true) && DeviceAssociation.compareDeep(this.period, o.period, true) && DeviceAssociation.compareDeep(this.operation, o.operation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceAssociation)) {
            return false;
        }
        DeviceAssociation o = (DeviceAssociation)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.device, this.category, this.status, this.statusReason, this.subject, this.bodyStructure, this.period, this.operation});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceAssociation;
    }

    @Block
    public static class DeviceAssociationOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Device operational condition", formalDefinition="Device operational condition corresponding to the association.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/deviceassociation-operationstatus")
        protected CodeableConcept status;
        @Child(name="operator", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The individual performing the action enabled by the device", formalDefinition="The individual performing the action enabled by the device.")
        protected List<Reference> operator;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Begin and end dates and times for the device's operation", formalDefinition="Begin and end dates and times for the device's operation.")
        protected Period period;
        private static final long serialVersionUID = -1587836408L;

        public DeviceAssociationOperationComponent() {
        }

        public DeviceAssociationOperationComponent(CodeableConcept status) {
            this.setStatus(status);
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceAssociationOperationComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public DeviceAssociationOperationComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public List<Reference> getOperator() {
            if (this.operator == null) {
                this.operator = new ArrayList<Reference>();
            }
            return this.operator;
        }

        public DeviceAssociationOperationComponent setOperator(List<Reference> theOperator) {
            this.operator = theOperator;
            return this;
        }

        public boolean hasOperator() {
            if (this.operator == null) {
                return false;
            }
            for (Reference item : this.operator) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addOperator() {
            Reference t = new Reference();
            if (this.operator == null) {
                this.operator = new ArrayList<Reference>();
            }
            this.operator.add(t);
            return t;
        }

        public DeviceAssociationOperationComponent addOperator(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.operator == null) {
                this.operator = new ArrayList<Reference>();
            }
            this.operator.add(t);
            return this;
        }

        public Reference getOperatorFirstRep() {
            if (this.getOperator().isEmpty()) {
                this.addOperator();
            }
            return this.getOperator().get(0);
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceAssociationOperationComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public DeviceAssociationOperationComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceAssociation.SP_STATUS, "CodeableConcept", "Device operational condition corresponding to the association.", 0, 1, this.status));
            children.add(new Property(DeviceAssociation.SP_OPERATOR, "Reference(Patient|Practitioner|RelatedPerson)", "The individual performing the action enabled by the device.", 0, Integer.MAX_VALUE, this.operator));
            children.add(new Property("period", "Period", "Begin and end dates and times for the device's operation.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property(DeviceAssociation.SP_STATUS, "CodeableConcept", "Device operational condition corresponding to the association.", 0, 1, this.status);
                }
                case -500553564: {
                    return new Property(DeviceAssociation.SP_OPERATOR, "Reference(Patient|Practitioner|RelatedPerson)", "The individual performing the action enabled by the device.", 0, Integer.MAX_VALUE, this.operator);
                }
                case -991726143: {
                    return new Property("period", "Period", "Begin and end dates and times for the device's operation.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case -500553564: {
                    return this.operator == null ? new Base[]{} : this.operator.toArray(new Base[this.operator.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    this.status = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -500553564: {
                    this.getOperator().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceAssociation.SP_STATUS)) {
                this.status = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(DeviceAssociation.SP_OPERATOR)) {
                this.getOperator().add(TypeConvertor.castToReference(value));
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(DeviceAssociation.SP_STATUS)) {
                this.status = null;
            } else if (name.equals(DeviceAssociation.SP_OPERATOR)) {
                this.getOperator().remove(value);
            } else if (name.equals("period")) {
                this.period = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatus();
                }
                case -500553564: {
                    return this.addOperator();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case -500553564: {
                    return new String[]{"Reference"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceAssociation.SP_STATUS)) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals(DeviceAssociation.SP_OPERATOR)) {
                return this.addOperator();
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceAssociationOperationComponent copy() {
            DeviceAssociationOperationComponent dst = new DeviceAssociationOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceAssociationOperationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.status = this.status == null ? null : this.status.copy();
            if (this.operator != null) {
                dst.operator = new ArrayList<Reference>();
                for (Reference i : this.operator) {
                    dst.operator.add(i.copy());
                }
            }
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceAssociationOperationComponent)) {
                return false;
            }
            DeviceAssociationOperationComponent o = (DeviceAssociationOperationComponent)other_;
            return DeviceAssociationOperationComponent.compareDeep(this.status, o.status, true) && DeviceAssociationOperationComponent.compareDeep(this.operator, o.operator, true) && DeviceAssociationOperationComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceAssociationOperationComponent)) {
                return false;
            }
            DeviceAssociationOperationComponent o = (DeviceAssociationOperationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.status, this.operator, this.period});
        }

        @Override
        public String fhirType() {
            return "DeviceAssociation.operation";
        }
    }
}

