/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DeviceDispense", profile="http://hl7.org/fhir/StructureDefinition/DeviceDispense")
public class DeviceDispense
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for this dispensation", formalDefinition="Business identifier for this dispensation.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={CarePlan.class, DeviceRequest.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The order or request that this dispense is fulfilling", formalDefinition="The order or request that this dispense is fulfilling.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={Procedure.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The bigger event that this dispense is a part of", formalDefinition="The bigger event that this dispense is a part of.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preparation | in-progress | cancelled | on-hold | completed | entered-in-error | stopped | declined | unknown", formalDefinition="A code specifying the state of the set of dispense events.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/devicedispense-status")
    protected Enumeration<DeviceDispenseStatusCodes> status;
    @Child(name="statusReason", type={CodeableReference.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why a dispense was or was not performed", formalDefinition="Indicates the reason why a dispense was or was not performed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/devicedispense-status-reason")
    protected CodeableReference statusReason;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Type of device dispense", formalDefinition="Indicates the type of device dispense.")
    protected List<CodeableConcept> category;
    @Child(name="device", type={CodeableReference.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What device was supplied", formalDefinition="Identifies the device being dispensed. This is either a link to a resource representing the details of the device or a simple attribute carrying a code that identifies the device from a known list of devices.")
    protected CodeableReference device;
    @Child(name="subject", type={Patient.class, Practitioner.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the dispense is for", formalDefinition="A link to a resource representing the person to whom the device is intended.")
    protected Reference subject;
    @Child(name="receiver", type={Patient.class, Practitioner.class, RelatedPerson.class, Location.class, PractitionerRole.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who collected the device or where the medication was delivered", formalDefinition="Identifies the person who picked up the device or the person or location where the device was delivered.  This may be a patient or their caregiver, but some cases exist where it can be a healthcare professional or a location.")
    protected Reference receiver;
    @Child(name="encounter", type={Encounter.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter associated with event", formalDefinition="The encounter that establishes the context for this event.")
    protected Reference encounter;
    @Child(name="supportingInformation", type={Reference.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information that supports the dispensing of the device", formalDefinition="Additional information that supports the device being dispensed.")
    protected List<Reference> supportingInformation;
    @Child(name="performer", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who performed event", formalDefinition="Indicates who or what performed the event.")
    protected List<DeviceDispensePerformerComponent> performer;
    @Child(name="location", type={Location.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the dispense occurred", formalDefinition="The principal physical location where the dispense was performed.")
    protected Reference location;
    @Child(name="type", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Trial fill, partial fill, emergency fill, etc", formalDefinition="Indicates the type of dispensing event that is performed.")
    protected CodeableConcept type;
    @Child(name="quantity", type={Quantity.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Amount dispensed", formalDefinition="The number of devices that have been dispensed.")
    protected Quantity quantity;
    @Child(name="preparedDate", type={DateTimeType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When product was packaged and reviewed", formalDefinition="The time when the dispensed product was packaged and reviewed.")
    protected DateTimeType preparedDate;
    @Child(name="whenHandedOver", type={DateTimeType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When product was given out", formalDefinition="The time the dispensed product was made available to the patient or their representative.")
    protected DateTimeType whenHandedOver;
    @Child(name="destination", type={Location.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the device was sent or should be sent", formalDefinition="Identification of the facility/location where the device was /should be shipped to, as part of the dispense process.")
    protected Reference destination;
    @Child(name="note", type={Annotation.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the dispense", formalDefinition="Extra information about the dispense that could not be conveyed in the other attributes.")
    protected List<Annotation> note;
    @Child(name="usageInstruction", type={MarkdownType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Full representation of the usage instructions", formalDefinition="The full representation of the instructions.")
    protected MarkdownType usageInstruction;
    @Child(name="eventHistory", type={Provenance.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of relevant lifecycle events", formalDefinition="A summary of the events of interest that have occurred, such as when the dispense was verified.")
    protected List<Reference> eventHistory;
    private static final long serialVersionUID = 1740231007L;
    @SearchParamDefinition(name="code", path="DeviceDispense.device.concept", description="Search for devices that match this code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="DeviceDispense.identifier", description="The identifier of the dispense", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="DeviceDispense.subject.where(resolve() is Patient)", description="Returns device dispenses for a specific patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DeviceDispense:patient").toLocked();
    @SearchParamDefinition(name="status", path="DeviceDispense.status", description="The status of the dispense", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DeviceDispense.subject", description="The identity of a patient for whom to list dispenses", type="reference", target={Patient.class, Practitioner.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceDispense:subject").toLocked();

    public DeviceDispense() {
    }

    public DeviceDispense(DeviceDispenseStatusCodes status, CodeableReference device, Reference subject) {
        this.setStatus(status);
        this.setDevice(device);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceDispense setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceDispense addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DeviceDispense setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DeviceDispense addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public DeviceDispense setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public DeviceDispense addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<DeviceDispenseStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DeviceDispenseStatusCodes>(new DeviceDispenseStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DeviceDispense setStatusElement(Enumeration<DeviceDispenseStatusCodes> value) {
        this.status = value;
        return this;
    }

    public DeviceDispenseStatusCodes getStatus() {
        return this.status == null ? null : (DeviceDispenseStatusCodes)((Object)this.status.getValue());
    }

    public DeviceDispense setStatus(DeviceDispenseStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<DeviceDispenseStatusCodes>(new DeviceDispenseStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableReference getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableReference();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public DeviceDispense setStatusReason(CodeableReference value) {
        this.statusReason = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DeviceDispense setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DeviceDispense addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableReference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new CodeableReference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public DeviceDispense setDevice(CodeableReference value) {
        this.device = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DeviceDispense setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getReceiver() {
        if (this.receiver == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.receiver");
            }
            if (Configuration.doAutoCreate()) {
                this.receiver = new Reference();
            }
        }
        return this.receiver;
    }

    public boolean hasReceiver() {
        return this.receiver != null && !this.receiver.isEmpty();
    }

    public DeviceDispense setReceiver(Reference value) {
        this.receiver = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public DeviceDispense setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public DeviceDispense setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public DeviceDispense addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    public List<DeviceDispensePerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<DeviceDispensePerformerComponent>();
        }
        return this.performer;
    }

    public DeviceDispense setPerformer(List<DeviceDispensePerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (DeviceDispensePerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDispensePerformerComponent addPerformer() {
        DeviceDispensePerformerComponent t = new DeviceDispensePerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<DeviceDispensePerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public DeviceDispense addPerformer(DeviceDispensePerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<DeviceDispensePerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public DeviceDispensePerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public DeviceDispense setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DeviceDispense setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public DeviceDispense setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public DateTimeType getPreparedDateElement() {
        if (this.preparedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.preparedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.preparedDate = new DateTimeType();
            }
        }
        return this.preparedDate;
    }

    public boolean hasPreparedDateElement() {
        return this.preparedDate != null && !this.preparedDate.isEmpty();
    }

    public boolean hasPreparedDate() {
        return this.preparedDate != null && !this.preparedDate.isEmpty();
    }

    public DeviceDispense setPreparedDateElement(DateTimeType value) {
        this.preparedDate = value;
        return this;
    }

    public Date getPreparedDate() {
        return this.preparedDate == null ? null : (Date)this.preparedDate.getValue();
    }

    public DeviceDispense setPreparedDate(Date value) {
        if (value == null) {
            this.preparedDate = null;
        } else {
            if (this.preparedDate == null) {
                this.preparedDate = new DateTimeType();
            }
            this.preparedDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getWhenHandedOverElement() {
        if (this.whenHandedOver == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.whenHandedOver");
            }
            if (Configuration.doAutoCreate()) {
                this.whenHandedOver = new DateTimeType();
            }
        }
        return this.whenHandedOver;
    }

    public boolean hasWhenHandedOverElement() {
        return this.whenHandedOver != null && !this.whenHandedOver.isEmpty();
    }

    public boolean hasWhenHandedOver() {
        return this.whenHandedOver != null && !this.whenHandedOver.isEmpty();
    }

    public DeviceDispense setWhenHandedOverElement(DateTimeType value) {
        this.whenHandedOver = value;
        return this;
    }

    public Date getWhenHandedOver() {
        return this.whenHandedOver == null ? null : (Date)this.whenHandedOver.getValue();
    }

    public DeviceDispense setWhenHandedOver(Date value) {
        if (value == null) {
            this.whenHandedOver = null;
        } else {
            if (this.whenHandedOver == null) {
                this.whenHandedOver = new DateTimeType();
            }
            this.whenHandedOver.setValue(value);
        }
        return this;
    }

    public Reference getDestination() {
        if (this.destination == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destination = new Reference();
            }
        }
        return this.destination;
    }

    public boolean hasDestination() {
        return this.destination != null && !this.destination.isEmpty();
    }

    public DeviceDispense setDestination(Reference value) {
        this.destination = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DeviceDispense setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DeviceDispense addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public MarkdownType getUsageInstructionElement() {
        if (this.usageInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDispense.usageInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.usageInstruction = new MarkdownType();
            }
        }
        return this.usageInstruction;
    }

    public boolean hasUsageInstructionElement() {
        return this.usageInstruction != null && !this.usageInstruction.isEmpty();
    }

    public boolean hasUsageInstruction() {
        return this.usageInstruction != null && !this.usageInstruction.isEmpty();
    }

    public DeviceDispense setUsageInstructionElement(MarkdownType value) {
        this.usageInstruction = value;
        return this;
    }

    public String getUsageInstruction() {
        return this.usageInstruction == null ? null : (String)this.usageInstruction.getValue();
    }

    public DeviceDispense setUsageInstruction(String value) {
        if (Utilities.noString((String)value)) {
            this.usageInstruction = null;
        } else {
            if (this.usageInstruction == null) {
                this.usageInstruction = new MarkdownType();
            }
            this.usageInstruction.setValue(value);
        }
        return this;
    }

    public List<Reference> getEventHistory() {
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        return this.eventHistory;
    }

    public DeviceDispense setEventHistory(List<Reference> theEventHistory) {
        this.eventHistory = theEventHistory;
        return this;
    }

    public boolean hasEventHistory() {
        if (this.eventHistory == null) {
            return false;
        }
        for (Reference item : this.eventHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEventHistory() {
        Reference t = new Reference();
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return t;
    }

    public DeviceDispense addEventHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.eventHistory == null) {
            this.eventHistory = new ArrayList<Reference>();
        }
        this.eventHistory.add(t);
        return this;
    }

    public Reference getEventHistoryFirstRep() {
        if (this.getEventHistory().isEmpty()) {
            this.addEventHistory();
        }
        return this.getEventHistory().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this dispensation.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(CarePlan|DeviceRequest)", "The order or request that this dispense is fulfilling.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(Procedure)", "The bigger event that this dispense is a part of.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, SP_CODE, "A code specifying the state of the set of dispense events.", 0, 1, this.status));
        children.add(new Property("statusReason", "CodeableReference(DetectedIssue)", "Indicates the reason why a dispense was or was not performed.", 0, 1, this.statusReason));
        children.add(new Property("category", "CodeableConcept", "Indicates the type of device dispense.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property("device", "CodeableReference(Device|DeviceDefinition)", "Identifies the device being dispensed. This is either a link to a resource representing the details of the device or a simple attribute carrying a code that identifies the device from a known list of devices.", 0, 1, this.device));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner)", "A link to a resource representing the person to whom the device is intended.", 0, 1, this.subject));
        children.add(new Property("receiver", "Reference(Patient|Practitioner|RelatedPerson|Location|PractitionerRole)", "Identifies the person who picked up the device or the person or location where the device was delivered.  This may be a patient or their caregiver, but some cases exist where it can be a healthcare professional or a location.", 0, 1, this.receiver));
        children.add(new Property("encounter", "Reference(Encounter)", "The encounter that establishes the context for this event.", 0, 1, this.encounter));
        children.add(new Property("supportingInformation", "Reference(Any)", "Additional information that supports the device being dispensed.", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property("performer", "", "Indicates who or what performed the event.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("location", "Reference(Location)", "The principal physical location where the dispense was performed.", 0, 1, this.location));
        children.add(new Property("type", "CodeableConcept", "Indicates the type of dispensing event that is performed.", 0, 1, this.type));
        children.add(new Property("quantity", "Quantity", "The number of devices that have been dispensed.", 0, 1, this.quantity));
        children.add(new Property("preparedDate", "dateTime", "The time when the dispensed product was packaged and reviewed.", 0, 1, this.preparedDate));
        children.add(new Property("whenHandedOver", "dateTime", "The time the dispensed product was made available to the patient or their representative.", 0, 1, this.whenHandedOver));
        children.add(new Property("destination", "Reference(Location)", "Identification of the facility/location where the device was /should be shipped to, as part of the dispense process.", 0, 1, this.destination));
        children.add(new Property("note", "Annotation", "Extra information about the dispense that could not be conveyed in the other attributes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("usageInstruction", "markdown", "The full representation of the instructions.", 0, 1, this.usageInstruction));
        children.add(new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the dispense was verified.", 0, Integer.MAX_VALUE, this.eventHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for this dispensation.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|DeviceRequest)", "The order or request that this dispense is fulfilling.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Procedure)", "The bigger event that this dispense is a part of.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code specifying the state of the set of dispense events.", 0, 1, this.status);
            }
            case 2051346646: {
                return new Property("statusReason", "CodeableReference(DetectedIssue)", "Indicates the reason why a dispense was or was not performed.", 0, 1, this.statusReason);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Indicates the type of device dispense.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1335157162: {
                return new Property("device", "CodeableReference(Device|DeviceDefinition)", "Identifies the device being dispensed. This is either a link to a resource representing the details of the device or a simple attribute carrying a code that identifies the device from a known list of devices.", 0, 1, this.device);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Practitioner)", "A link to a resource representing the person to whom the device is intended.", 0, 1, this.subject);
            }
            case -808719889: {
                return new Property("receiver", "Reference(Patient|Practitioner|RelatedPerson|Location|PractitionerRole)", "Identifies the person who picked up the device or the person or location where the device was delivered.  This may be a patient or their caregiver, but some cases exist where it can be a healthcare professional or a location.", 0, 1, this.receiver);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "The encounter that establishes the context for this event.", 0, 1, this.encounter);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Additional information that supports the device being dispensed.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case 481140686: {
                return new Property("performer", "", "Indicates who or what performed the event.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "The principal physical location where the dispense was performed.", 0, 1, this.location);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Indicates the type of dispensing event that is performed.", 0, 1, this.type);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "The number of devices that have been dispensed.", 0, 1, this.quantity);
            }
            case -2024959605: {
                return new Property("preparedDate", "dateTime", "The time when the dispensed product was packaged and reviewed.", 0, 1, this.preparedDate);
            }
            case -940241380: {
                return new Property("whenHandedOver", "dateTime", "The time the dispensed product was made available to the patient or their representative.", 0, 1, this.whenHandedOver);
            }
            case -1429847026: {
                return new Property("destination", "Reference(Location)", "Identification of the facility/location where the device was /should be shipped to, as part of the dispense process.", 0, 1, this.destination);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Extra information about the dispense that could not be conveyed in the other attributes.", 0, Integer.MAX_VALUE, this.note);
            }
            case 2138372141: {
                return new Property("usageInstruction", "markdown", "The full representation of the instructions.", 0, 1, this.usageInstruction);
            }
            case 1835190426: {
                return new Property("eventHistory", "Reference(Provenance)", "A summary of the events of interest that have occurred, such as when the dispense was verified.", 0, Integer.MAX_VALUE, this.eventHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.statusReason;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.device;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case -808719889: {
                Base[] baseArray;
                if (this.receiver == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.receiver;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.encounter;
                }
                return baseArray;
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.location;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.type;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.quantity;
                }
                return baseArray;
            }
            case -2024959605: {
                Base[] baseArray;
                if (this.preparedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.preparedDate;
                }
                return baseArray;
            }
            case -940241380: {
                Base[] baseArray;
                if (this.whenHandedOver == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.whenHandedOver;
                }
                return baseArray;
            }
            case -1429847026: {
                Base[] baseArray;
                if (this.destination == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.destination;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 2138372141: {
                Base[] baseArray;
                if (this.usageInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.usageInstruction;
                }
                return baseArray;
            }
            case 1835190426: {
                return this.eventHistory == null ? new Base[]{} : this.eventHistory.toArray(new Base[this.eventHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new DeviceDispenseStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2051346646: {
                this.statusReason = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1335157162: {
                this.device = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -808719889: {
                this.receiver = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 481140686: {
                this.getPerformer().add((DeviceDispensePerformerComponent)((Object)value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToQuantity(value);
                return value;
            }
            case -2024959605: {
                this.preparedDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -940241380: {
                this.whenHandedOver = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1429847026: {
                this.destination = TypeConvertor.castToReference(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 2138372141: {
                this.usageInstruction = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1835190426: {
                this.getEventHistory().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new DeviceDispenseStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("device")) {
            this.device = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("receiver")) {
            this.receiver = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("performer")) {
            this.getPerformer().add((DeviceDispensePerformerComponent)((Object)value));
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("quantity")) {
            this.quantity = TypeConvertor.castToQuantity(value);
        } else if (name.equals("preparedDate")) {
            this.preparedDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("whenHandedOver")) {
            this.whenHandedOver = TypeConvertor.castToDateTime(value);
        } else if (name.equals("destination")) {
            this.destination = TypeConvertor.castToReference(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("usageInstruction")) {
            this.usageInstruction = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals("partOf")) {
            this.getPartOf().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new DeviceDispenseStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusReason")) {
            this.statusReason = null;
        } else if (name.equals("category")) {
            this.getCategory().remove(value);
        } else if (name.equals("device")) {
            this.device = null;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals("receiver")) {
            this.receiver = null;
        } else if (name.equals("encounter")) {
            this.encounter = null;
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().remove(value);
        } else if (name.equals("performer")) {
            this.getPerformer().remove((DeviceDispensePerformerComponent)((Object)value));
        } else if (name.equals("location")) {
            this.location = null;
        } else if (name.equals("type")) {
            this.type = null;
        } else if (name.equals("quantity")) {
            this.quantity = null;
        } else if (name.equals("preparedDate")) {
            this.preparedDate = null;
        } else if (name.equals("whenHandedOver")) {
            this.whenHandedOver = null;
        } else if (name.equals("destination")) {
            this.destination = null;
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("usageInstruction")) {
            this.usageInstruction = null;
        } else if (name.equals("eventHistory")) {
            this.getEventHistory().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -808719889: {
                return this.getReceiver();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 3575610: {
                return this.getType();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case -2024959605: {
                return this.getPreparedDateElement();
            }
            case -940241380: {
                return this.getWhenHandedOverElement();
            }
            case -1429847026: {
                return this.getDestination();
            }
            case 3387378: {
                return this.addNote();
            }
            case 2138372141: {
                return this.getUsageInstructionElement();
            }
            case 1835190426: {
                return this.addEventHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2051346646: {
                return new String[]{"CodeableReference"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1335157162: {
                return new String[]{"CodeableReference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -808719889: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case 481140686: {
                return new String[0];
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case -2024959605: {
                return new String[]{"dateTime"};
            }
            case -940241380: {
                return new String[]{"dateTime"};
            }
            case -1429847026: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 2138372141: {
                return new String[]{"markdown"};
            }
            case 1835190426: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceDispense.status");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableReference();
            return this.statusReason;
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals("device")) {
            this.device = new CodeableReference();
            return this.device;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("receiver")) {
            this.receiver = new Reference();
            return this.receiver;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("performer")) {
            return this.addPerformer();
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("preparedDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceDispense.preparedDate");
        }
        if (name.equals("whenHandedOver")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceDispense.whenHandedOver");
        }
        if (name.equals("destination")) {
            this.destination = new Reference();
            return this.destination;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("usageInstruction")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceDispense.usageInstruction");
        }
        if (name.equals("eventHistory")) {
            return this.addEventHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceDispense";
    }

    @Override
    public DeviceDispense copy() {
        DeviceDispense dst = new DeviceDispense();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DeviceDispense dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableReference codeableReference = dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.device = this.device == null ? null : this.device.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.receiver = this.receiver == null ? null : this.receiver.copy();
        Reference reference = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference2 : this.supportingInformation) {
                dst.supportingInformation.add(reference2.copy());
            }
        }
        if (this.performer != null) {
            dst.performer = new ArrayList<DeviceDispensePerformerComponent>();
            for (DeviceDispensePerformerComponent deviceDispensePerformerComponent : this.performer) {
                dst.performer.add(deviceDispensePerformerComponent.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        dst.preparedDate = this.preparedDate == null ? null : this.preparedDate.copy();
        dst.whenHandedOver = this.whenHandedOver == null ? null : this.whenHandedOver.copy();
        Reference reference3 = dst.destination = this.destination == null ? null : this.destination.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        MarkdownType markdownType = dst.usageInstruction = this.usageInstruction == null ? null : this.usageInstruction.copy();
        if (this.eventHistory != null) {
            dst.eventHistory = new ArrayList<Reference>();
            for (Reference reference4 : this.eventHistory) {
                dst.eventHistory.add(reference4.copy());
            }
        }
    }

    protected DeviceDispense typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceDispense)) {
            return false;
        }
        DeviceDispense o = (DeviceDispense)other_;
        return DeviceDispense.compareDeep(this.identifier, o.identifier, true) && DeviceDispense.compareDeep(this.basedOn, o.basedOn, true) && DeviceDispense.compareDeep(this.partOf, o.partOf, true) && DeviceDispense.compareDeep(this.status, o.status, true) && DeviceDispense.compareDeep(this.statusReason, o.statusReason, true) && DeviceDispense.compareDeep(this.category, o.category, true) && DeviceDispense.compareDeep(this.device, o.device, true) && DeviceDispense.compareDeep(this.subject, o.subject, true) && DeviceDispense.compareDeep(this.receiver, o.receiver, true) && DeviceDispense.compareDeep(this.encounter, o.encounter, true) && DeviceDispense.compareDeep(this.supportingInformation, o.supportingInformation, true) && DeviceDispense.compareDeep(this.performer, o.performer, true) && DeviceDispense.compareDeep(this.location, o.location, true) && DeviceDispense.compareDeep(this.type, o.type, true) && DeviceDispense.compareDeep(this.quantity, o.quantity, true) && DeviceDispense.compareDeep(this.preparedDate, o.preparedDate, true) && DeviceDispense.compareDeep(this.whenHandedOver, o.whenHandedOver, true) && DeviceDispense.compareDeep(this.destination, o.destination, true) && DeviceDispense.compareDeep(this.note, o.note, true) && DeviceDispense.compareDeep(this.usageInstruction, o.usageInstruction, true) && DeviceDispense.compareDeep(this.eventHistory, o.eventHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceDispense)) {
            return false;
        }
        DeviceDispense o = (DeviceDispense)other_;
        return DeviceDispense.compareValues(this.status, o.status, true) && DeviceDispense.compareValues(this.preparedDate, o.preparedDate, true) && DeviceDispense.compareValues(this.whenHandedOver, o.whenHandedOver, true) && DeviceDispense.compareValues(this.usageInstruction, o.usageInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.partOf, this.status, this.statusReason, this.category, this.device, this.subject, this.receiver, this.encounter, this.supportingInformation, this.performer, this.location, this.type, this.quantity, this.preparedDate, this.whenHandedOver, this.destination, this.note, this.usageInstruction, this.eventHistory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceDispense;
    }

    @Block
    public static class DeviceDispensePerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who performed the dispense and what they did", formalDefinition="Distinguishes the type of performer in the dispense.  For example, date enterer, packager, final checker.")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, Device.class, RelatedPerson.class, CareTeam.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual who was performing", formalDefinition="The device, practitioner, etc. who performed the action.  It should be assumed that the actor is the dispenser of the device.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public DeviceDispensePerformerComponent() {
        }

        public DeviceDispensePerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDispensePerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public DeviceDispensePerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDispensePerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public DeviceDispensePerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of performer in the dispense.  For example, date enterer, packager, final checker.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|Patient|Device|RelatedPerson|CareTeam)", "The device, practitioner, etc. who performed the action.  It should be assumed that the actor is the dispenser of the device.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of performer in the dispense.  For example, date enterer, packager, final checker.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|Patient|Device|RelatedPerson|CareTeam)", "The device, practitioner, etc. who performed the action.  It should be assumed that the actor is the dispenser of the device.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = null;
            } else if (name.equals("actor")) {
                this.actor = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDispensePerformerComponent copy() {
            DeviceDispensePerformerComponent dst = new DeviceDispensePerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDispensePerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDispensePerformerComponent)) {
                return false;
            }
            DeviceDispensePerformerComponent o = (DeviceDispensePerformerComponent)other_;
            return DeviceDispensePerformerComponent.compareDeep(this.function, o.function, true) && DeviceDispensePerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDispensePerformerComponent)) {
                return false;
            }
            DeviceDispensePerformerComponent o = (DeviceDispensePerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "DeviceDispense.performer";
        }
    }

    public static class DeviceDispenseStatusCodesEnumFactory
    implements EnumFactory<DeviceDispenseStatusCodes> {
        @Override
        public DeviceDispenseStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return DeviceDispenseStatusCodes.PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return DeviceDispenseStatusCodes.INPROGRESS;
            }
            if ("cancelled".equals(codeString)) {
                return DeviceDispenseStatusCodes.CANCELLED;
            }
            if ("on-hold".equals(codeString)) {
                return DeviceDispenseStatusCodes.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return DeviceDispenseStatusCodes.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DeviceDispenseStatusCodes.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return DeviceDispenseStatusCodes.STOPPED;
            }
            if ("declined".equals(codeString)) {
                return DeviceDispenseStatusCodes.DECLINED;
            }
            if ("unknown".equals(codeString)) {
                return DeviceDispenseStatusCodes.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown DeviceDispenseStatusCodes code '" + codeString + "'");
        }

        public Enumeration<DeviceDispenseStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.NULL, code);
            }
            if ("preparation".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.PREPARATION, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.INPROGRESS, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.CANCELLED, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.ONHOLD, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.ENTEREDINERROR, code);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.STOPPED, code);
            }
            if ("declined".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.DECLINED, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<DeviceDispenseStatusCodes>(this, DeviceDispenseStatusCodes.UNKNOWN, code);
            }
            throw new FHIRException("Unknown DeviceDispenseStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceDispenseStatusCodes code) {
            if (code == DeviceDispenseStatusCodes.PREPARATION) {
                return "preparation";
            }
            if (code == DeviceDispenseStatusCodes.INPROGRESS) {
                return "in-progress";
            }
            if (code == DeviceDispenseStatusCodes.CANCELLED) {
                return "cancelled";
            }
            if (code == DeviceDispenseStatusCodes.ONHOLD) {
                return "on-hold";
            }
            if (code == DeviceDispenseStatusCodes.COMPLETED) {
                return "completed";
            }
            if (code == DeviceDispenseStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DeviceDispenseStatusCodes.STOPPED) {
                return "stopped";
            }
            if (code == DeviceDispenseStatusCodes.DECLINED) {
                return "declined";
            }
            if (code == DeviceDispenseStatusCodes.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceDispenseStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum DeviceDispenseStatusCodes {
        PREPARATION,
        INPROGRESS,
        CANCELLED,
        ONHOLD,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        DECLINED,
        UNKNOWN,
        NULL;


        public static DeviceDispenseStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("declined".equals(codeString)) {
                return DECLINED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceDispenseStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREPARATION: {
                    return "preparation";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
                case DECLINED: {
                    return "declined";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREPARATION: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case DECLINED: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/devicedispense-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREPARATION: {
                    return "The core event has not started yet, but some staging activities have begun (e.g. initial preparing of the device. Preparation stages may be tracked e.g. for planning, supply or billing purposes.";
                }
                case INPROGRESS: {
                    return "The dispensed product is ready for pickup.";
                }
                case CANCELLED: {
                    return "The dispensed product was not and will never be picked up by the patient.";
                }
                case ONHOLD: {
                    return "The dispense process is paused while waiting for an external event to reactivate the dispense.  For example, new stock has arrived or the prescriber has called.";
                }
                case COMPLETED: {
                    return "The dispensed product has been picked up.";
                }
                case ENTEREDINERROR: {
                    return "The dispense was entered in error and therefore nullified.";
                }
                case STOPPED: {
                    return "Actions implied by the dispense have been permanently halted, before all of them occurred.";
                }
                case DECLINED: {
                    return "The dispense was declined and not performed.";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values applies for this dispense.  Note: this concept is not to be used for other - one of the listed statuses is presumed to apply, it's just now known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREPARATION: {
                    return "Preparation";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case DECLINED: {
                    return "Declined";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

