/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DiagnosticReport", profile="http://hl7.org/fhir/StructureDefinition/DiagnosticReport")
public class DiagnosticReport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for report", formalDefinition="Identifiers assigned to this report by the performer or other systems.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={CarePlan.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What was requested", formalDefinition="Details concerning a service requested.")
    protected List<Reference> basedOn;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | partial | preliminary | modified | final | amended | corrected | appended | cancelled | entered-in-error | unknown", formalDefinition="The status of the diagnostic report.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-report-status")
    protected Enumeration<DiagnosticReportStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Service category", formalDefinition="A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-service-sections")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name/Code for this diagnostic report", formalDefinition="A code or name that describes this diagnostic report.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-codes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Practitioner.class, Medication.class, Substance.class, BiologicallyDerivedProduct.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the report - usually, but not always, the patient", formalDefinition="The subject of the report. Usually, but not always, this is a patient. However, diagnostic services also perform analyses on specimens collected from a variety of other sources.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Health care event when test ordered", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.")
    protected Reference encounter;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinically relevant time/time-period for report", formalDefinition="The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.")
    protected DataType effective;
    @Child(name="issued", type={InstantType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DateTime this version was made", formalDefinition="The date and time that this version of the report was made available to providers, typically after the report was reviewed and verified.")
    protected InstantType issued;
    @Child(name="performer", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible Diagnostic Service", formalDefinition="The diagnostic service that is responsible for issuing the report.")
    protected List<Reference> performer;
    @Child(name="resultsInterpreter", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Primary result interpreter", formalDefinition="The practitioner or organization that is responsible for the report's conclusions and interpretations.")
    protected List<Reference> resultsInterpreter;
    @Child(name="specimen", type={Specimen.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimens this report is based on", formalDefinition="Details about the specimens on which this diagnostic report is based.")
    protected List<Reference> specimen;
    @Child(name="result", type={Observation.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Observations", formalDefinition="[Observations](observation.html)  that are part of this diagnostic report.")
    protected List<Reference> result;
    @Child(name="note", type={Annotation.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the diagnostic report", formalDefinition="Comments about the diagnostic report.")
    protected List<Annotation> note;
    @Child(name="study", type={GenomicStudy.class, ImagingStudy.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to full details of an analysis associated with the diagnostic report", formalDefinition="One or more links to full details of any study performed during the diagnostic investigation. An ImagingStudy might comprise a set of radiologic images obtained via a procedure that are analyzed as a group. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images. A GenomicStudy might comprise one or more analyses, each serving a specific purpose. These analyses may vary in method (e.g., karyotyping, CNV, or SNV detection), performer, software, devices used, or regions targeted.")
    protected List<Reference> study;
    @Child(name="supportingInfo", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information supporting the diagnostic report", formalDefinition="This backbone element contains supporting information that was used in the creation of the report not included in the results already included in the report.")
    protected List<DiagnosticReportSupportingInfoComponent> supportingInfo;
    @Child(name="media", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Key images or data associated with this report", formalDefinition="A list of key images or data associated with this report. The images or data are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).")
    protected List<DiagnosticReportMediaComponent> media;
    @Child(name="composition", type={Composition.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to a Composition resource for the DiagnosticReport structure", formalDefinition="Reference to a Composition resource instance that provides structure for organizing the contents of the DiagnosticReport.")
    protected Reference composition;
    @Child(name="conclusion", type={MarkdownType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical conclusion (interpretation) of test results", formalDefinition="Concise and clinically contextualized summary conclusion (interpretation/impression) of the diagnostic report.")
    protected MarkdownType conclusion;
    @Child(name="conclusionCode", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Codes for the clinical conclusion of test results", formalDefinition="One or more codes that represent the summary conclusion (interpretation/impression) of the diagnostic report.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableConcept> conclusionCode;
    @Child(name="presentedForm", type={Attachment.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Entire report as issued", formalDefinition="Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.")
    protected List<Attachment> presentedForm;
    private static final long serialVersionUID = -530178625L;
    @SearchParamDefinition(name="based-on", path="DiagnosticReport.basedOn", description="Reference to the service request.", type="reference", target={CarePlan.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("DiagnosticReport:based-on").toLocked();
    @SearchParamDefinition(name="category", path="DiagnosticReport.category", description="Which diagnostic discipline/department created the report", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="conclusion", path="DiagnosticReport.conclusionCode", description="A coded conclusion (interpretation/impression) on the report", type="token")
    public static final String SP_CONCLUSION = "conclusion";
    public static final TokenClientParam CONCLUSION = new TokenClientParam("conclusion");
    @SearchParamDefinition(name="issued", path="DiagnosticReport.issued", description="When the report was issued", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="media", path="DiagnosticReport.media.link", description="A reference to the image source.", type="reference", target={DocumentReference.class})
    public static final String SP_MEDIA = "media";
    public static final ReferenceClientParam MEDIA = new ReferenceClientParam("media");
    public static final Include INCLUDE_MEDIA = new Include("DiagnosticReport:media").toLocked();
    @SearchParamDefinition(name="performer", path="DiagnosticReport.performer", description="Who is responsible for the report", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={CareTeam.class, Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("DiagnosticReport:performer").toLocked();
    @SearchParamDefinition(name="result", path="DiagnosticReport.result", description="Link to an atomic result (observation resource)", type="reference", target={Observation.class})
    public static final String SP_RESULT = "result";
    public static final ReferenceClientParam RESULT = new ReferenceClientParam("result");
    public static final Include INCLUDE_RESULT = new Include("DiagnosticReport:result").toLocked();
    @SearchParamDefinition(name="results-interpreter", path="DiagnosticReport.resultsInterpreter", description="Who was the source of the report", type="reference", target={CareTeam.class, Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_RESULTS_INTERPRETER = "results-interpreter";
    public static final ReferenceClientParam RESULTS_INTERPRETER = new ReferenceClientParam("results-interpreter");
    public static final Include INCLUDE_RESULTS_INTERPRETER = new Include("DiagnosticReport:results-interpreter").toLocked();
    @SearchParamDefinition(name="specimen", path="DiagnosticReport.specimen", description="The specimen details", type="reference", target={Specimen.class})
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("DiagnosticReport:specimen").toLocked();
    @SearchParamDefinition(name="status", path="DiagnosticReport.status", description="The status of the report", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="study", path="DiagnosticReport.study", description="Studies associated with the diagnostic report", type="reference", target={GenomicStudy.class, ImagingStudy.class})
    public static final String SP_STUDY = "study";
    public static final ReferenceClientParam STUDY = new ReferenceClientParam("study");
    public static final Include INCLUDE_STUDY = new Include("DiagnosticReport:study").toLocked();
    @SearchParamDefinition(name="subject", path="DiagnosticReport.subject", description="The subject of the report", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, Organization.class, Patient.class, Practitioner.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DiagnosticReport:subject").toLocked();
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="AuditEvent.encounter | CarePlan.encounter | ChargeItem.encounter | Claim.item.encounter | ClinicalImpression.encounter | Communication.encounter | CommunicationRequest.encounter | Composition.encounter | Condition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | EncounterHistory.encounter | ExplanationOfBenefit.item.encounter | Flag.encounter | ImagingStudy.encounter | List.encounter | MedicationDispense.encounter | MedicationStatement.encounter | NutritionIntake.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | Provenance.encounter | QuestionnaireResponse.encounter | RequestOrchestration.encounter | RiskAssessment.encounter | ServiceRequest.encounter | Task.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [AuditEvent](auditevent.html): Encounter related to the activity recorded in the AuditEvent\r\n* [CarePlan](careplan.html): The Encounter during which this CarePlan was created\r\n* [ChargeItem](chargeitem.html): Encounter associated with event\r\n* [Claim](claim.html): Encounters associated with a billed line item\r\n* [ClinicalImpression](clinicalimpression.html): The Encounter during which this ClinicalImpression was created\r\n* [Communication](communication.html): The Encounter during which this Communication was created\r\n* [CommunicationRequest](communicationrequest.html): The Encounter during which this CommunicationRequest was created\r\n* [Composition](composition.html): Context of the Composition\r\n* [Condition](condition.html): The Encounter during which this Condition was created\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [EncounterHistory](encounterhistory.html): The Encounter associated with this set of history values\r\n* [ExplanationOfBenefit](explanationofbenefit.html): Encounters associated with a billed line item\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [ImagingStudy](imagingstudy.html): The context of the study\r\n* [List](list.html): Context in which list created\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with a specific encounter\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific encounter\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific encounter\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [Provenance](provenance.html): Encounter related to the Provenance\r\n* [QuestionnaireResponse](questionnaireresponse.html): Encounter associated with the questionnaire response\r\n* [RequestOrchestration](requestorchestration.html): The encounter the request orchestration applies to\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [Task](task.html): Search by encounter\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("DiagnosticReport:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DiagnosticReport:patient").toLocked();

    public DiagnosticReport() {
    }

    public DiagnosticReport(DiagnosticReportStatus status, CodeableConcept code) {
        this.setStatus(status);
        this.setCode(code);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DiagnosticReport setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DiagnosticReport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DiagnosticReport setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DiagnosticReport addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Enumeration<DiagnosticReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DiagnosticReportStatus>(new DiagnosticReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DiagnosticReport setStatusElement(Enumeration<DiagnosticReportStatus> value) {
        this.status = value;
        return this;
    }

    public DiagnosticReportStatus getStatus() {
        return this.status == null ? null : (DiagnosticReportStatus)((Object)this.status.getValue());
    }

    public DiagnosticReport setStatus(DiagnosticReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DiagnosticReportStatus>(new DiagnosticReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DiagnosticReport setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DiagnosticReport addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public DiagnosticReport setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DiagnosticReport setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public DiagnosticReport setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (this.effective == null) {
            this.effective = new DateTimeType();
        }
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this != null && this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (this.effective == null) {
            this.effective = new Period();
        }
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this != null && this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public DiagnosticReport setEffective(DataType value) {
        if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
            throw new FHIRException("Not the right type for DiagnosticReport.effective[x]: " + value.fhirType());
        }
        this.effective = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public DiagnosticReport setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public DiagnosticReport setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public DiagnosticReport setPerformer(List<Reference> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (Reference item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPerformer() {
        Reference t = new Reference();
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return t;
    }

    public DiagnosticReport addPerformer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        this.performer.add(t);
        return this;
    }

    public Reference getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<Reference> getResultsInterpreter() {
        if (this.resultsInterpreter == null) {
            this.resultsInterpreter = new ArrayList<Reference>();
        }
        return this.resultsInterpreter;
    }

    public DiagnosticReport setResultsInterpreter(List<Reference> theResultsInterpreter) {
        this.resultsInterpreter = theResultsInterpreter;
        return this;
    }

    public boolean hasResultsInterpreter() {
        if (this.resultsInterpreter == null) {
            return false;
        }
        for (Reference item : this.resultsInterpreter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResultsInterpreter() {
        Reference t = new Reference();
        if (this.resultsInterpreter == null) {
            this.resultsInterpreter = new ArrayList<Reference>();
        }
        this.resultsInterpreter.add(t);
        return t;
    }

    public DiagnosticReport addResultsInterpreter(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.resultsInterpreter == null) {
            this.resultsInterpreter = new ArrayList<Reference>();
        }
        this.resultsInterpreter.add(t);
        return this;
    }

    public Reference getResultsInterpreterFirstRep() {
        if (this.getResultsInterpreter().isEmpty()) {
            this.addResultsInterpreter();
        }
        return this.getResultsInterpreter().get(0);
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public DiagnosticReport setSpecimen(List<Reference> theSpecimen) {
        this.specimen = theSpecimen;
        return this;
    }

    public boolean hasSpecimen() {
        if (this.specimen == null) {
            return false;
        }
        for (Reference item : this.specimen) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSpecimen() {
        Reference t = new Reference();
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return t;
    }

    public DiagnosticReport addSpecimen(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return this;
    }

    public Reference getSpecimenFirstRep() {
        if (this.getSpecimen().isEmpty()) {
            this.addSpecimen();
        }
        return this.getSpecimen().get(0);
    }

    public List<Reference> getResult() {
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        return this.result;
    }

    public DiagnosticReport setResult(List<Reference> theResult) {
        this.result = theResult;
        return this;
    }

    public boolean hasResult() {
        if (this.result == null) {
            return false;
        }
        for (Reference item : this.result) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResult() {
        Reference t = new Reference();
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return t;
    }

    public DiagnosticReport addResult(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return this;
    }

    public Reference getResultFirstRep() {
        if (this.getResult().isEmpty()) {
            this.addResult();
        }
        return this.getResult().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DiagnosticReport setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DiagnosticReport addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        return this.study;
    }

    public DiagnosticReport setStudy(List<Reference> theStudy) {
        this.study = theStudy;
        return this;
    }

    public boolean hasStudy() {
        if (this.study == null) {
            return false;
        }
        for (Reference item : this.study) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addStudy() {
        Reference t = new Reference();
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        this.study.add(t);
        return t;
    }

    public DiagnosticReport addStudy(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.study == null) {
            this.study = new ArrayList<Reference>();
        }
        this.study.add(t);
        return this;
    }

    public Reference getStudyFirstRep() {
        if (this.getStudy().isEmpty()) {
            this.addStudy();
        }
        return this.getStudy().get(0);
    }

    public List<DiagnosticReportSupportingInfoComponent> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<DiagnosticReportSupportingInfoComponent>();
        }
        return this.supportingInfo;
    }

    public DiagnosticReport setSupportingInfo(List<DiagnosticReportSupportingInfoComponent> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (DiagnosticReportSupportingInfoComponent item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosticReportSupportingInfoComponent addSupportingInfo() {
        DiagnosticReportSupportingInfoComponent t = new DiagnosticReportSupportingInfoComponent();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<DiagnosticReportSupportingInfoComponent>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public DiagnosticReport addSupportingInfo(DiagnosticReportSupportingInfoComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<DiagnosticReportSupportingInfoComponent>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public DiagnosticReportSupportingInfoComponent getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    public List<DiagnosticReportMediaComponent> getMedia() {
        if (this.media == null) {
            this.media = new ArrayList<DiagnosticReportMediaComponent>();
        }
        return this.media;
    }

    public DiagnosticReport setMedia(List<DiagnosticReportMediaComponent> theMedia) {
        this.media = theMedia;
        return this;
    }

    public boolean hasMedia() {
        if (this.media == null) {
            return false;
        }
        for (DiagnosticReportMediaComponent item : this.media) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosticReportMediaComponent addMedia() {
        DiagnosticReportMediaComponent t = new DiagnosticReportMediaComponent();
        if (this.media == null) {
            this.media = new ArrayList<DiagnosticReportMediaComponent>();
        }
        this.media.add(t);
        return t;
    }

    public DiagnosticReport addMedia(DiagnosticReportMediaComponent t) {
        if (t == null) {
            return this;
        }
        if (this.media == null) {
            this.media = new ArrayList<DiagnosticReportMediaComponent>();
        }
        this.media.add(t);
        return this;
    }

    public DiagnosticReportMediaComponent getMediaFirstRep() {
        if (this.getMedia().isEmpty()) {
            this.addMedia();
        }
        return this.getMedia().get(0);
    }

    public Reference getComposition() {
        if (this.composition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.composition");
            }
            if (Configuration.doAutoCreate()) {
                this.composition = new Reference();
            }
        }
        return this.composition;
    }

    public boolean hasComposition() {
        return this.composition != null && !this.composition.isEmpty();
    }

    public DiagnosticReport setComposition(Reference value) {
        this.composition = value;
        return this;
    }

    public MarkdownType getConclusionElement() {
        if (this.conclusion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.conclusion");
            }
            if (Configuration.doAutoCreate()) {
                this.conclusion = new MarkdownType();
            }
        }
        return this.conclusion;
    }

    public boolean hasConclusionElement() {
        return this.conclusion != null && !this.conclusion.isEmpty();
    }

    public boolean hasConclusion() {
        return this.conclusion != null && !this.conclusion.isEmpty();
    }

    public DiagnosticReport setConclusionElement(MarkdownType value) {
        this.conclusion = value;
        return this;
    }

    public String getConclusion() {
        return this.conclusion == null ? null : (String)this.conclusion.getValue();
    }

    public DiagnosticReport setConclusion(String value) {
        if (Utilities.noString((String)value)) {
            this.conclusion = null;
        } else {
            if (this.conclusion == null) {
                this.conclusion = new MarkdownType();
            }
            this.conclusion.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getConclusionCode() {
        if (this.conclusionCode == null) {
            this.conclusionCode = new ArrayList<CodeableConcept>();
        }
        return this.conclusionCode;
    }

    public DiagnosticReport setConclusionCode(List<CodeableConcept> theConclusionCode) {
        this.conclusionCode = theConclusionCode;
        return this;
    }

    public boolean hasConclusionCode() {
        if (this.conclusionCode == null) {
            return false;
        }
        for (CodeableConcept item : this.conclusionCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addConclusionCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.conclusionCode == null) {
            this.conclusionCode = new ArrayList<CodeableConcept>();
        }
        this.conclusionCode.add(t);
        return t;
    }

    public DiagnosticReport addConclusionCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.conclusionCode == null) {
            this.conclusionCode = new ArrayList<CodeableConcept>();
        }
        this.conclusionCode.add(t);
        return this;
    }

    public CodeableConcept getConclusionCodeFirstRep() {
        if (this.getConclusionCode().isEmpty()) {
            this.addConclusionCode();
        }
        return this.getConclusionCode().get(0);
    }

    public List<Attachment> getPresentedForm() {
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        return this.presentedForm;
    }

    public DiagnosticReport setPresentedForm(List<Attachment> thePresentedForm) {
        this.presentedForm = thePresentedForm;
        return this;
    }

    public boolean hasPresentedForm() {
        if (this.presentedForm == null) {
            return false;
        }
        for (Attachment item : this.presentedForm) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPresentedForm() {
        Attachment t = new Attachment();
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        this.presentedForm.add(t);
        return t;
    }

    public DiagnosticReport addPresentedForm(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        this.presentedForm.add(t);
        return this;
    }

    public Attachment getPresentedFormFirstRep() {
        if (this.getPresentedForm().isEmpty()) {
            this.addPresentedForm();
        }
        return this.getPresentedForm().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this report by the performer or other systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(CarePlan|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest)", "Details concerning a service requested.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of the diagnostic report.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code or name that describes this diagnostic report.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Practitioner|Medication|Substance|BiologicallyDerivedProduct)", "The subject of the report. Usually, but not always, this is a patient. However, diagnostic services also perform analyses on specimens collected from a variety of other sources.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.", 0, 1, this.encounter));
        children.add(new Property("effective[x]", "dateTime|Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective));
        children.add(new Property(SP_ISSUED, "instant", "The date and time that this version of the report was made available to providers, typically after the report was reviewed and verified.", 0, 1, this.issued));
        children.add(new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam)", "The diagnostic service that is responsible for issuing the report.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("resultsInterpreter", "Reference(Practitioner|PractitionerRole|Organization|CareTeam)", "The practitioner or organization that is responsible for the report's conclusions and interpretations.", 0, Integer.MAX_VALUE, this.resultsInterpreter));
        children.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "Details about the specimens on which this diagnostic report is based.", 0, Integer.MAX_VALUE, this.specimen));
        children.add(new Property(SP_RESULT, "Reference(Observation)", "[Observations](observation.html)  that are part of this diagnostic report.", 0, Integer.MAX_VALUE, this.result));
        children.add(new Property("note", "Annotation", "Comments about the diagnostic report.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property(SP_STUDY, "Reference(GenomicStudy|ImagingStudy)", "One or more links to full details of any study performed during the diagnostic investigation. An ImagingStudy might comprise a set of radiologic images obtained via a procedure that are analyzed as a group. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images. A GenomicStudy might comprise one or more analyses, each serving a specific purpose. These analyses may vary in method (e.g., karyotyping, CNV, or SNV detection), performer, software, devices used, or regions targeted.", 0, Integer.MAX_VALUE, this.study));
        children.add(new Property("supportingInfo", "", "This backbone element contains supporting information that was used in the creation of the report not included in the results already included in the report.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property(SP_MEDIA, "", "A list of key images or data associated with this report. The images or data are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).", 0, Integer.MAX_VALUE, this.media));
        children.add(new Property("composition", "Reference(Composition)", "Reference to a Composition resource instance that provides structure for organizing the contents of the DiagnosticReport.", 0, 1, this.composition));
        children.add(new Property(SP_CONCLUSION, "markdown", "Concise and clinically contextualized summary conclusion (interpretation/impression) of the diagnostic report.", 0, 1, this.conclusion));
        children.add(new Property("conclusionCode", "CodeableConcept", "One or more codes that represent the summary conclusion (interpretation/impression) of the diagnostic report.", 0, Integer.MAX_VALUE, this.conclusionCode));
        children.add(new Property("presentedForm", "Attachment", "Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.", 0, Integer.MAX_VALUE, this.presentedForm));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this report by the performer or other systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest)", "Details concerning a service requested.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of the diagnostic report.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code or name that describes this diagnostic report.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Practitioner|Medication|Substance|BiologicallyDerivedProduct)", "The subject of the report. Usually, but not always, this is a patient. However, diagnostic services also perform analyses on specimens collected from a variety of other sources.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event  (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.", 0, 1, this.encounter);
            }
            case 247104889: {
                return new Property("effective[x]", "dateTime|Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -1468651097: {
                return new Property("effective[x]", "dateTime|Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -275306910: {
                return new Property("effective[x]", "dateTime", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -403934648: {
                return new Property("effective[x]", "Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, 1, this.effective);
            }
            case -1179159893: {
                return new Property(SP_ISSUED, "instant", "The date and time that this version of the report was made available to providers, typically after the report was reviewed and verified.", 0, 1, this.issued);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "Reference(Practitioner|PractitionerRole|Organization|CareTeam)", "The diagnostic service that is responsible for issuing the report.", 0, Integer.MAX_VALUE, this.performer);
            }
            case 2134944932: {
                return new Property("resultsInterpreter", "Reference(Practitioner|PractitionerRole|Organization|CareTeam)", "The practitioner or organization that is responsible for the report's conclusions and interpretations.", 0, Integer.MAX_VALUE, this.resultsInterpreter);
            }
            case -2132868344: {
                return new Property(SP_SPECIMEN, "Reference(Specimen)", "Details about the specimens on which this diagnostic report is based.", 0, Integer.MAX_VALUE, this.specimen);
            }
            case -934426595: {
                return new Property(SP_RESULT, "Reference(Observation)", "[Observations](observation.html)  that are part of this diagnostic report.", 0, Integer.MAX_VALUE, this.result);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments about the diagnostic report.", 0, Integer.MAX_VALUE, this.note);
            }
            case 109776329: {
                return new Property(SP_STUDY, "Reference(GenomicStudy|ImagingStudy)", "One or more links to full details of any study performed during the diagnostic investigation. An ImagingStudy might comprise a set of radiologic images obtained via a procedure that are analyzed as a group. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images. A GenomicStudy might comprise one or more analyses, each serving a specific purpose. These analyses may vary in method (e.g., karyotyping, CNV, or SNV detection), performer, software, devices used, or regions targeted.", 0, Integer.MAX_VALUE, this.study);
            }
            case 1922406657: {
                return new Property("supportingInfo", "", "This backbone element contains supporting information that was used in the creation of the report not included in the results already included in the report.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 103772132: {
                return new Property(SP_MEDIA, "", "A list of key images or data associated with this report. The images or data are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).", 0, Integer.MAX_VALUE, this.media);
            }
            case -838923862: {
                return new Property("composition", "Reference(Composition)", "Reference to a Composition resource instance that provides structure for organizing the contents of the DiagnosticReport.", 0, 1, this.composition);
            }
            case -1731259873: {
                return new Property(SP_CONCLUSION, "markdown", "Concise and clinically contextualized summary conclusion (interpretation/impression) of the diagnostic report.", 0, 1, this.conclusion);
            }
            case -1731523412: {
                return new Property("conclusionCode", "CodeableConcept", "One or more codes that represent the summary conclusion (interpretation/impression) of the diagnostic report.", 0, Integer.MAX_VALUE, this.conclusionCode);
            }
            case 230090366: {
                return new Property("presentedForm", "Attachment", "Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.", 0, Integer.MAX_VALUE, this.presentedForm);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.encounter;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.effective;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.issued;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case 2134944932: {
                return this.resultsInterpreter == null ? new Base[]{} : this.resultsInterpreter.toArray(new Base[this.resultsInterpreter.size()]);
            }
            case -2132868344: {
                return this.specimen == null ? new Base[]{} : this.specimen.toArray(new Base[this.specimen.size()]);
            }
            case -934426595: {
                return this.result == null ? new Base[]{} : this.result.toArray(new Base[this.result.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 109776329: {
                return this.study == null ? new Base[]{} : this.study.toArray(new Base[this.study.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 103772132: {
                return this.media == null ? new Base[]{} : this.media.toArray(new Base[this.media.size()]);
            }
            case -838923862: {
                Base[] baseArray;
                if (this.composition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.composition;
                }
                return baseArray;
            }
            case -1731259873: {
                Base[] baseArray;
                if (this.conclusion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.conclusion;
                }
                return baseArray;
            }
            case -1731523412: {
                return this.conclusionCode == null ? new Base[]{} : this.conclusionCode.toArray(new Base[this.conclusionCode.size()]);
            }
            case 230090366: {
                return this.presentedForm == null ? new Base[]{} : this.presentedForm.toArray(new Base[this.presentedForm.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new DiagnosticReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = TypeConvertor.castToType(value);
                return value;
            }
            case -1179159893: {
                this.issued = TypeConvertor.castToInstant(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 2134944932: {
                this.getResultsInterpreter().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -2132868344: {
                this.getSpecimen().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -934426595: {
                this.getResult().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 109776329: {
                this.getStudy().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add((DiagnosticReportSupportingInfoComponent)((Object)value));
                return value;
            }
            case 103772132: {
                this.getMedia().add((DiagnosticReportMediaComponent)((Object)value));
                return value;
            }
            case -838923862: {
                this.composition = TypeConvertor.castToReference(value);
                return value;
            }
            case -1731259873: {
                this.conclusion = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1731523412: {
                this.getConclusionCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 230090366: {
                this.getPresentedForm().add(TypeConvertor.castToAttachment(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new DiagnosticReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = TypeConvertor.castToType(value);
        } else if (name.equals(SP_ISSUED)) {
            this.issued = TypeConvertor.castToInstant(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("resultsInterpreter")) {
            this.getResultsInterpreter().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_SPECIMEN)) {
            this.getSpecimen().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_RESULT)) {
            this.getResult().add(TypeConvertor.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals(SP_STUDY)) {
            this.getStudy().add(TypeConvertor.castToReference(value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add((DiagnosticReportSupportingInfoComponent)((Object)value));
        } else if (name.equals(SP_MEDIA)) {
            this.getMedia().add((DiagnosticReportMediaComponent)((Object)value));
        } else if (name.equals("composition")) {
            this.composition = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CONCLUSION)) {
            this.conclusion = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("conclusionCode")) {
            this.getConclusionCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("presentedForm")) {
            this.getPresentedForm().add(TypeConvertor.castToAttachment(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new DiagnosticReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_CODE)) {
            this.code = null;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = null;
        } else if (name.equals("effective[x]")) {
            this.effective = null;
        } else if (name.equals(SP_ISSUED)) {
            this.issued = null;
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().remove(value);
        } else if (name.equals("resultsInterpreter")) {
            this.getResultsInterpreter().remove(value);
        } else if (name.equals(SP_SPECIMEN)) {
            this.getSpecimen().remove(value);
        } else if (name.equals(SP_RESULT)) {
            this.getResult().remove(value);
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals(SP_STUDY)) {
            this.getStudy().remove(value);
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().remove((DiagnosticReportSupportingInfoComponent)((Object)value));
        } else if (name.equals(SP_MEDIA)) {
            this.getMedia().remove((DiagnosticReportMediaComponent)((Object)value));
        } else if (name.equals("composition")) {
            this.composition = null;
        } else if (name.equals(SP_CONCLUSION)) {
            this.conclusion = null;
        } else if (name.equals("conclusionCode")) {
            this.getConclusionCode().remove(value);
        } else if (name.equals("presentedForm")) {
            this.getPresentedForm().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case 2134944932: {
                return this.addResultsInterpreter();
            }
            case -2132868344: {
                return this.addSpecimen();
            }
            case -934426595: {
                return this.addResult();
            }
            case 3387378: {
                return this.addNote();
            }
            case 109776329: {
                return this.addStudy();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 103772132: {
                return this.addMedia();
            }
            case -838923862: {
                return this.getComposition();
            }
            case -1731259873: {
                return this.getConclusionElement();
            }
            case -1731523412: {
                return this.addConclusionCode();
            }
            case 230090366: {
                return this.addPresentedForm();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case -1179159893: {
                return new String[]{"instant"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case 2134944932: {
                return new String[]{"Reference"};
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case -934426595: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 109776329: {
                return new String[]{"Reference"};
            }
            case 1922406657: {
                return new String[0];
            }
            case 103772132: {
                return new String[0];
            }
            case -838923862: {
                return new String[]{"Reference"};
            }
            case -1731259873: {
                return new String[]{"markdown"};
            }
            case -1731523412: {
                return new String[]{"CodeableConcept"};
            }
            case 230090366: {
                return new String[]{"Attachment"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property DiagnosticReport.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a singleton property DiagnosticReport.issued");
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals("resultsInterpreter")) {
            return this.addResultsInterpreter();
        }
        if (name.equals(SP_SPECIMEN)) {
            return this.addSpecimen();
        }
        if (name.equals(SP_RESULT)) {
            return this.addResult();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals(SP_STUDY)) {
            return this.addStudy();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals(SP_MEDIA)) {
            return this.addMedia();
        }
        if (name.equals("composition")) {
            this.composition = new Reference();
            return this.composition;
        }
        if (name.equals(SP_CONCLUSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property DiagnosticReport.conclusion");
        }
        if (name.equals("conclusionCode")) {
            return this.addConclusionCode();
        }
        if (name.equals("presentedForm")) {
            return this.addPresentedForm();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DiagnosticReport";
    }

    @Override
    public DiagnosticReport copy() {
        DiagnosticReport dst = new DiagnosticReport();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DiagnosticReport dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Enumeration<DiagnosticReportStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        InstantType instantType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<Reference>();
            for (Reference reference : this.performer) {
                dst.performer.add(reference.copy());
            }
        }
        if (this.resultsInterpreter != null) {
            dst.resultsInterpreter = new ArrayList<Reference>();
            for (Reference reference : this.resultsInterpreter) {
                dst.resultsInterpreter.add(reference.copy());
            }
        }
        if (this.specimen != null) {
            dst.specimen = new ArrayList<Reference>();
            for (Reference reference : this.specimen) {
                dst.specimen.add(reference.copy());
            }
        }
        if (this.result != null) {
            dst.result = new ArrayList<Reference>();
            for (Reference reference : this.result) {
                dst.result.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.study != null) {
            dst.study = new ArrayList<Reference>();
            for (Reference reference : this.study) {
                dst.study.add(reference.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<DiagnosticReportSupportingInfoComponent>();
            for (DiagnosticReportSupportingInfoComponent diagnosticReportSupportingInfoComponent : this.supportingInfo) {
                dst.supportingInfo.add(diagnosticReportSupportingInfoComponent.copy());
            }
        }
        if (this.media != null) {
            dst.media = new ArrayList<DiagnosticReportMediaComponent>();
            for (DiagnosticReportMediaComponent diagnosticReportMediaComponent : this.media) {
                dst.media.add(diagnosticReportMediaComponent.copy());
            }
        }
        dst.composition = this.composition == null ? null : this.composition.copy();
        MarkdownType markdownType = dst.conclusion = this.conclusion == null ? null : this.conclusion.copy();
        if (this.conclusionCode != null) {
            dst.conclusionCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.conclusionCode) {
                dst.conclusionCode.add(codeableConcept.copy());
            }
        }
        if (this.presentedForm != null) {
            dst.presentedForm = new ArrayList<Attachment>();
            for (Attachment attachment : this.presentedForm) {
                dst.presentedForm.add(attachment.copy());
            }
        }
    }

    protected DiagnosticReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DiagnosticReport)) {
            return false;
        }
        DiagnosticReport o = (DiagnosticReport)other_;
        return DiagnosticReport.compareDeep(this.identifier, o.identifier, true) && DiagnosticReport.compareDeep(this.basedOn, o.basedOn, true) && DiagnosticReport.compareDeep(this.status, o.status, true) && DiagnosticReport.compareDeep(this.category, o.category, true) && DiagnosticReport.compareDeep(this.code, o.code, true) && DiagnosticReport.compareDeep(this.subject, o.subject, true) && DiagnosticReport.compareDeep(this.encounter, o.encounter, true) && DiagnosticReport.compareDeep(this.effective, o.effective, true) && DiagnosticReport.compareDeep(this.issued, o.issued, true) && DiagnosticReport.compareDeep(this.performer, o.performer, true) && DiagnosticReport.compareDeep(this.resultsInterpreter, o.resultsInterpreter, true) && DiagnosticReport.compareDeep(this.specimen, o.specimen, true) && DiagnosticReport.compareDeep(this.result, o.result, true) && DiagnosticReport.compareDeep(this.note, o.note, true) && DiagnosticReport.compareDeep(this.study, o.study, true) && DiagnosticReport.compareDeep(this.supportingInfo, o.supportingInfo, true) && DiagnosticReport.compareDeep(this.media, o.media, true) && DiagnosticReport.compareDeep(this.composition, o.composition, true) && DiagnosticReport.compareDeep(this.conclusion, o.conclusion, true) && DiagnosticReport.compareDeep(this.conclusionCode, o.conclusionCode, true) && DiagnosticReport.compareDeep(this.presentedForm, o.presentedForm, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DiagnosticReport)) {
            return false;
        }
        DiagnosticReport o = (DiagnosticReport)other_;
        return DiagnosticReport.compareValues(this.status, o.status, true) && DiagnosticReport.compareValues(this.issued, o.issued, true) && DiagnosticReport.compareValues(this.conclusion, o.conclusion, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.status, this.category, this.code, this.subject, this.encounter, this.effective, this.issued, this.performer, this.resultsInterpreter, this.specimen, this.result, this.note, this.study, this.supportingInfo, this.media, this.composition, this.conclusion, this.conclusionCode, this.presentedForm});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DiagnosticReport;
    }

    @Block
    public static class DiagnosticReportMediaComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="comment", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Comment about the image or data (e.g. explanation)", formalDefinition="A comment about the image or data. Typically, this is used to provide an explanation for why the image or data is included, or to draw the viewer's attention to important features.")
        protected StringType comment;
        @Child(name="link", type={DocumentReference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to the image or data source", formalDefinition="Reference to the image or data source.")
        protected Reference link;
        private static final long serialVersionUID = 1827561947L;

        public DiagnosticReportMediaComponent() {
        }

        public DiagnosticReportMediaComponent(Reference link) {
            this.setLink(link);
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportMediaComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public DiagnosticReportMediaComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public DiagnosticReportMediaComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public Reference getLink() {
            if (this.link == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportMediaComponent.link");
                }
                if (Configuration.doAutoCreate()) {
                    this.link = new Reference();
                }
            }
            return this.link;
        }

        public boolean hasLink() {
            return this.link != null && !this.link.isEmpty();
        }

        public DiagnosticReportMediaComponent setLink(Reference value) {
            this.link = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("comment", "string", "A comment about the image or data. Typically, this is used to provide an explanation for why the image or data is included, or to draw the viewer's attention to important features.", 0, 1, this.comment));
            children.add(new Property("link", "Reference(DocumentReference)", "Reference to the image or data source.", 0, 1, this.link));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 950398559: {
                    return new Property("comment", "string", "A comment about the image or data. Typically, this is used to provide an explanation for why the image or data is included, or to draw the viewer's attention to important features.", 0, 1, this.comment);
                }
                case 3321850: {
                    return new Property("link", "Reference(DocumentReference)", "Reference to the image or data source.", 0, 1, this.link);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.comment;
                    }
                    return baseArray;
                }
                case 3321850: {
                    Base[] baseArray;
                    if (this.link == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.link;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    this.comment = TypeConvertor.castToString(value);
                    return value;
                }
                case 3321850: {
                    this.link = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("comment")) {
                this.comment = TypeConvertor.castToString(value);
            } else if (name.equals("link")) {
                this.link = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("comment")) {
                this.comment = null;
            } else if (name.equals("link")) {
                this.link = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    return this.getCommentElement();
                }
                case 3321850: {
                    return this.getLink();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    return new String[]{"string"};
                }
                case 3321850: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a singleton property DiagnosticReport.media.comment");
            }
            if (name.equals("link")) {
                this.link = new Reference();
                return this.link;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosticReportMediaComponent copy() {
            DiagnosticReportMediaComponent dst = new DiagnosticReportMediaComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosticReportMediaComponent dst) {
            super.copyValues(dst);
            dst.comment = this.comment == null ? null : this.comment.copy();
            dst.link = this.link == null ? null : this.link.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosticReportMediaComponent)) {
                return false;
            }
            DiagnosticReportMediaComponent o = (DiagnosticReportMediaComponent)other_;
            return DiagnosticReportMediaComponent.compareDeep(this.comment, o.comment, true) && DiagnosticReportMediaComponent.compareDeep(this.link, o.link, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosticReportMediaComponent)) {
                return false;
            }
            DiagnosticReportMediaComponent o = (DiagnosticReportMediaComponent)other_;
            return DiagnosticReportMediaComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.comment, this.link});
        }

        @Override
        public String fhirType() {
            return "DiagnosticReport.media";
        }
    }

    @Block
    public static class DiagnosticReportSupportingInfoComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting information role code", formalDefinition="The code value for the role of the supporting information in the diagnostic report.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0936")
        protected CodeableConcept type;
        @Child(name="reference", type={Procedure.class, Observation.class, DiagnosticReport.class, Citation.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Supporting information reference", formalDefinition="The reference for the supporting information in the diagnostic report.")
        protected Reference reference;
        private static final long serialVersionUID = 492391425L;

        public DiagnosticReportSupportingInfoComponent() {
        }

        public DiagnosticReportSupportingInfoComponent(CodeableConcept type, Reference reference) {
            this.setType(type);
            this.setReference(reference);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportSupportingInfoComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DiagnosticReportSupportingInfoComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportSupportingInfoComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public DiagnosticReportSupportingInfoComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The code value for the role of the supporting information in the diagnostic report.", 0, 1, this.type));
            children.add(new Property("reference", "Reference(Procedure|Observation|DiagnosticReport|Citation)", "The reference for the supporting information in the diagnostic report.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The code value for the role of the supporting information in the diagnostic report.", 0, 1, this.type);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Procedure|Observation|DiagnosticReport|Citation)", "The reference for the supporting information in the diagnostic report.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("reference")) {
                this.reference = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosticReportSupportingInfoComponent copy() {
            DiagnosticReportSupportingInfoComponent dst = new DiagnosticReportSupportingInfoComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosticReportSupportingInfoComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosticReportSupportingInfoComponent)) {
                return false;
            }
            DiagnosticReportSupportingInfoComponent o = (DiagnosticReportSupportingInfoComponent)other_;
            return DiagnosticReportSupportingInfoComponent.compareDeep(this.type, o.type, true) && DiagnosticReportSupportingInfoComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosticReportSupportingInfoComponent)) {
                return false;
            }
            DiagnosticReportSupportingInfoComponent o = (DiagnosticReportSupportingInfoComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.reference});
        }

        @Override
        public String fhirType() {
            return "DiagnosticReport.supportingInfo";
        }
    }

    public static class DiagnosticReportStatusEnumFactory
    implements EnumFactory<DiagnosticReportStatus> {
        @Override
        public DiagnosticReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return DiagnosticReportStatus.REGISTERED;
            }
            if ("partial".equals(codeString)) {
                return DiagnosticReportStatus.PARTIAL;
            }
            if ("preliminary".equals(codeString)) {
                return DiagnosticReportStatus.PRELIMINARY;
            }
            if ("modified".equals(codeString)) {
                return DiagnosticReportStatus.MODIFIED;
            }
            if ("final".equals(codeString)) {
                return DiagnosticReportStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return DiagnosticReportStatus.AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return DiagnosticReportStatus.CORRECTED;
            }
            if ("appended".equals(codeString)) {
                return DiagnosticReportStatus.APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return DiagnosticReportStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DiagnosticReportStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return DiagnosticReportStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        public Enumeration<DiagnosticReportStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.NULL, code);
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.REGISTERED, code);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.PARTIAL, code);
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.PRELIMINARY, code);
            }
            if ("modified".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.MODIFIED, code);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.FINAL, code);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.AMENDED, code);
            }
            if ("corrected".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.CORRECTED, code);
            }
            if ("appended".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.APPENDED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.CANCELLED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DiagnosticReportStatus code) {
            if (code == DiagnosticReportStatus.REGISTERED) {
                return "registered";
            }
            if (code == DiagnosticReportStatus.PARTIAL) {
                return "partial";
            }
            if (code == DiagnosticReportStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == DiagnosticReportStatus.MODIFIED) {
                return "modified";
            }
            if (code == DiagnosticReportStatus.FINAL) {
                return "final";
            }
            if (code == DiagnosticReportStatus.AMENDED) {
                return "amended";
            }
            if (code == DiagnosticReportStatus.CORRECTED) {
                return "corrected";
            }
            if (code == DiagnosticReportStatus.APPENDED) {
                return "appended";
            }
            if (code == DiagnosticReportStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == DiagnosticReportStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DiagnosticReportStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(DiagnosticReportStatus code) {
            return code.getSystem();
        }
    }

    public static enum DiagnosticReportStatus {
        REGISTERED,
        PARTIAL,
        PRELIMINARY,
        MODIFIED,
        FINAL,
        AMENDED,
        CORRECTED,
        APPENDED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static DiagnosticReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("modified".equals(codeString)) {
                return MODIFIED;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return CORRECTED;
            }
            if ("appended".equals(codeString)) {
                return APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case PARTIAL: {
                    return "partial";
                }
                case PRELIMINARY: {
                    return "preliminary";
                }
                case MODIFIED: {
                    return "modified";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case CORRECTED: {
                    return "corrected";
                }
                case APPENDED: {
                    return "appended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case MODIFIED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case CORRECTED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case APPENDED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the report is registered, but there is nothing yet available.";
                }
                case PARTIAL: {
                    return "This is a partial (e.g. initial, interim or preliminary) report: data in the report may be incomplete or unverified.";
                }
                case PRELIMINARY: {
                    return "Verified early results are available, but not all results are final.";
                }
                case MODIFIED: {
                    return "Prior to being final, the report has been modified.  This includes any change in the results, diagnosis, narrative text, or other content of a non-finalized (e.g., preliminary) report that has been issued.";
                }
                case FINAL: {
                    return "The report is complete and verified by an authorized person.";
                }
                case AMENDED: {
                    return "Subsequent to being final, the report has been modified.  This includes any change in the results, diagnosis, narrative text, or other content of a report that has been issued.";
                }
                case CORRECTED: {
                    return "Subsequent to being final, the report has been modified to correct an error in the report or referenced results.";
                }
                case APPENDED: {
                    return "Subsequent to being final, the report has been modified by adding new content. The existing content is unchanged.";
                }
                case CANCELLED: {
                    return "The report is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The report has been withdrawn following a previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this observation. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring/source system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case PARTIAL: {
                    return "Partial";
                }
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case MODIFIED: {
                    return "Modified";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case CORRECTED: {
                    return "Corrected";
                }
                case APPENDED: {
                    return "Appended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

