/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Group", profile="http://hl7.org/fhir/StructureDefinition/Group")
public class Group
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for this Group", formalDefinition="Business identifiers assigned to this participant by one of the applications involved.  These identifiers remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this group's record is in active use", formalDefinition="Indicates whether the record for the group is available for use or is merely being retained for historical purposes.")
    protected BooleanType active;
    @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="person | animal | practitioner | device | careteam | healthcareservice | location | organization | relatedperson | specimen", formalDefinition="Identifies the broad classification of the kind of resources the group includes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/group-type")
    protected Enumeration<GroupType> type;
    @Child(name="membership", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="definitional | enumerated", formalDefinition="Basis for membership in the Group:\n\n* 'definitional': The Group.characteristics specified are both necessary and sufficient to determine membership. All entities that meet the criteria are considered to be members of the group, whether referenced by the group or not. If members are present, they are individuals that happen to be known as meeting the Group.characteristics. The list cannot be presumed to be complete.\n* 'enumerated': The Group.characteristics are necessary but not sufficient to determine membership. Membership is determined by being listed as one of the Group.member.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/group-membership-basis")
    protected Enumeration<GroupMembershipBasis> membership;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of Group members", formalDefinition="Provides a specific type of resource the group includes; e.g. \"cow\", \"syringe\", etc.")
    protected CodeableConcept code;
    @Child(name="name", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Label for Group", formalDefinition="A label assigned to the group for human identification and communication.")
    protected StringType name;
    @Child(name="description", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the group", formalDefinition="Explanation of what the group represents and how it is intended to be used.")
    protected MarkdownType description;
    @Child(name="quantity", type={UnsignedIntType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of members", formalDefinition="A count of the number of resource instances that are part of the group.")
    protected UnsignedIntType quantity;
    @Child(name="managingEntity", type={Organization.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Entity that is the custodian of the Group's definition", formalDefinition="Entity responsible for defining and maintaining Group characteristics and/or registered members.")
    protected Reference managingEntity;
    @Child(name="characteristic", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Include / Exclude group members by Trait", formalDefinition="Identifies traits whose presence r absence is shared by members of the group.")
    protected List<GroupCharacteristicComponent> characteristic;
    @Child(name="member", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who or what is in group", formalDefinition="Identifies the resource instances that are members of the group.")
    protected List<GroupMemberComponent> member;
    private static final long serialVersionUID = -39542514L;
    @SearchParamDefinition(name="characteristic-reference", path="(Group.characteristic.value.ofType(Reference))", description="An entity referenced in a characteristic", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_CHARACTERISTIC_REFERENCE = "characteristic-reference";
    public static final ReferenceClientParam CHARACTERISTIC_REFERENCE = new ReferenceClientParam("characteristic-reference");
    public static final Include INCLUDE_CHARACTERISTIC_REFERENCE = new Include("Group:characteristic-reference").toLocked();
    @SearchParamDefinition(name="characteristic-value", path="Group.characteristic", description="A composite of both characteristic and value", type="composite", compositeOf={"characteristic", "value"})
    public static final String SP_CHARACTERISTIC_VALUE = "characteristic-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CHARACTERISTIC_VALUE = new CompositeClientParam("characteristic-value");
    @SearchParamDefinition(name="characteristic", path="Group.characteristic.code", description="Kind of characteristic", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";
    public static final TokenClientParam CHARACTERISTIC = new TokenClientParam("characteristic");
    @SearchParamDefinition(name="code", path="Group.code", description="The kind of resources contained", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="exclude", path="Group.characteristic.exclude", description="Group includes or excludes", type="token")
    public static final String SP_EXCLUDE = "exclude";
    public static final TokenClientParam EXCLUDE = new TokenClientParam("exclude");
    @SearchParamDefinition(name="identifier", path="Group.identifier", description="Unique id", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="managing-entity", path="Group.managingEntity", description="Entity that is the custodian of the Group's definition", type="reference", target={Organization.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_MANAGING_ENTITY = "managing-entity";
    public static final ReferenceClientParam MANAGING_ENTITY = new ReferenceClientParam("managing-entity");
    public static final Include INCLUDE_MANAGING_ENTITY = new Include("Group:managing-entity").toLocked();
    @SearchParamDefinition(name="member", path="Group.member.entity", description="Reference to the group member", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Specimen.class})
    public static final String SP_MEMBER = "member";
    public static final ReferenceClientParam MEMBER = new ReferenceClientParam("member");
    public static final Include INCLUDE_MEMBER = new Include("Group:member").toLocked();
    @SearchParamDefinition(name="membership", path="Group.membership", description="Definitional or enumerated group", type="token")
    public static final String SP_MEMBERSHIP = "membership";
    public static final TokenClientParam MEMBERSHIP = new TokenClientParam("membership");
    @SearchParamDefinition(name="name", path="Group.name", description="A portion of the Group's name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="type", path="Group.type", description="The type of resources the group contains", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="value", path="(Group.characteristic.value.ofType(CodeableConcept)) | (Group.characteristic.value.ofType(boolean))", description="Value held by characteristic", type="token")
    public static final String SP_VALUE = "value";
    public static final TokenClientParam VALUE = new TokenClientParam("value");

    public Group() {
    }

    public Group(GroupType type, GroupMembershipBasis membership) {
        this.setType(type);
        this.setMembership(membership);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Group setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Group addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Group setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Group setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Enumeration<GroupType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<GroupType>(new GroupTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Group setTypeElement(Enumeration<GroupType> value) {
        this.type = value;
        return this;
    }

    public GroupType getType() {
        return this.type == null ? null : (GroupType)((Object)this.type.getValue());
    }

    public Group setType(GroupType value) {
        if (this.type == null) {
            this.type = new Enumeration<GroupType>(new GroupTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public Enumeration<GroupMembershipBasis> getMembershipElement() {
        if (this.membership == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.membership");
            }
            if (Configuration.doAutoCreate()) {
                this.membership = new Enumeration<GroupMembershipBasis>(new GroupMembershipBasisEnumFactory());
            }
        }
        return this.membership;
    }

    public boolean hasMembershipElement() {
        return this.membership != null && !this.membership.isEmpty();
    }

    public boolean hasMembership() {
        return this.membership != null && !this.membership.isEmpty();
    }

    public Group setMembershipElement(Enumeration<GroupMembershipBasis> value) {
        this.membership = value;
        return this;
    }

    public GroupMembershipBasis getMembership() {
        return this.membership == null ? null : (GroupMembershipBasis)((Object)this.membership.getValue());
    }

    public Group setMembership(GroupMembershipBasis value) {
        if (this.membership == null) {
            this.membership = new Enumeration<GroupMembershipBasis>(new GroupMembershipBasisEnumFactory());
        }
        this.membership.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Group setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Group setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Group setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Group setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Group setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public UnsignedIntType getQuantityElement() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new UnsignedIntType();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantityElement() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public Group setQuantityElement(UnsignedIntType value) {
        this.quantity = value;
        return this;
    }

    public int getQuantity() {
        return this.quantity == null || this.quantity.isEmpty() ? 0 : (Integer)this.quantity.getValue();
    }

    public Group setQuantity(int value) {
        if (this.quantity == null) {
            this.quantity = new UnsignedIntType();
        }
        this.quantity.setValue((Object)value);
        return this;
    }

    public Reference getManagingEntity() {
        if (this.managingEntity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Group.managingEntity");
            }
            if (Configuration.doAutoCreate()) {
                this.managingEntity = new Reference();
            }
        }
        return this.managingEntity;
    }

    public boolean hasManagingEntity() {
        return this.managingEntity != null && !this.managingEntity.isEmpty();
    }

    public Group setManagingEntity(Reference value) {
        this.managingEntity = value;
        return this;
    }

    public List<GroupCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<GroupCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public Group setCharacteristic(List<GroupCharacteristicComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (GroupCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GroupCharacteristicComponent addCharacteristic() {
        GroupCharacteristicComponent t = new GroupCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<GroupCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public Group addCharacteristic(GroupCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<GroupCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public GroupCharacteristicComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public List<GroupMemberComponent> getMember() {
        if (this.member == null) {
            this.member = new ArrayList<GroupMemberComponent>();
        }
        return this.member;
    }

    public Group setMember(List<GroupMemberComponent> theMember) {
        this.member = theMember;
        return this;
    }

    public boolean hasMember() {
        if (this.member == null) {
            return false;
        }
        for (GroupMemberComponent item : this.member) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GroupMemberComponent addMember() {
        GroupMemberComponent t = new GroupMemberComponent();
        if (this.member == null) {
            this.member = new ArrayList<GroupMemberComponent>();
        }
        this.member.add(t);
        return t;
    }

    public Group addMember(GroupMemberComponent t) {
        if (t == null) {
            return this;
        }
        if (this.member == null) {
            this.member = new ArrayList<GroupMemberComponent>();
        }
        this.member.add(t);
        return this;
    }

    public GroupMemberComponent getMemberFirstRep() {
        if (this.getMember().isEmpty()) {
            this.addMember();
        }
        return this.getMember().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this participant by one of the applications involved.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("active", "boolean", "Indicates whether the record for the group is available for use or is merely being retained for historical purposes.", 0, 1, this.active));
        children.add(new Property(SP_TYPE, SP_CODE, "Identifies the broad classification of the kind of resources the group includes.", 0, 1, this.type));
        children.add(new Property(SP_MEMBERSHIP, SP_CODE, "Basis for membership in the Group:\n\n* 'definitional': The Group.characteristics specified are both necessary and sufficient to determine membership. All entities that meet the criteria are considered to be members of the group, whether referenced by the group or not. If members are present, they are individuals that happen to be known as meeting the Group.characteristics. The list cannot be presumed to be complete.\n* 'enumerated': The Group.characteristics are necessary but not sufficient to determine membership. Membership is determined by being listed as one of the Group.member.", 0, 1, this.membership));
        children.add(new Property(SP_CODE, "CodeableConcept", "Provides a specific type of resource the group includes; e.g. \"cow\", \"syringe\", etc.", 0, 1, this.code));
        children.add(new Property(SP_NAME, "string", "A label assigned to the group for human identification and communication.", 0, 1, this.name));
        children.add(new Property("description", "markdown", "Explanation of what the group represents and how it is intended to be used.", 0, 1, this.description));
        children.add(new Property("quantity", "unsignedInt", "A count of the number of resource instances that are part of the group.", 0, 1, this.quantity));
        children.add(new Property("managingEntity", "Reference(Organization|RelatedPerson|Practitioner|PractitionerRole)", "Entity responsible for defining and maintaining Group characteristics and/or registered members.", 0, 1, this.managingEntity));
        children.add(new Property(SP_CHARACTERISTIC, "", "Identifies traits whose presence r absence is shared by members of the group.", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property(SP_MEMBER, "", "Identifies the resource instances that are members of the group.", 0, Integer.MAX_VALUE, this.member));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this participant by one of the applications involved.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property("active", "boolean", "Indicates whether the record for the group is available for use or is merely being retained for historical purposes.", 0, 1, this.active);
            }
            case 3575610: {
                return new Property(SP_TYPE, SP_CODE, "Identifies the broad classification of the kind of resources the group includes.", 0, 1, this.type);
            }
            case -1340241962: {
                return new Property(SP_MEMBERSHIP, SP_CODE, "Basis for membership in the Group:\n\n* 'definitional': The Group.characteristics specified are both necessary and sufficient to determine membership. All entities that meet the criteria are considered to be members of the group, whether referenced by the group or not. If members are present, they are individuals that happen to be known as meeting the Group.characteristics. The list cannot be presumed to be complete.\n* 'enumerated': The Group.characteristics are necessary but not sufficient to determine membership. Membership is determined by being listed as one of the Group.member.", 0, 1, this.membership);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Provides a specific type of resource the group includes; e.g. \"cow\", \"syringe\", etc.", 0, 1, this.code);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A label assigned to the group for human identification and communication.", 0, 1, this.name);
            }
            case -1724546052: {
                return new Property("description", "markdown", "Explanation of what the group represents and how it is intended to be used.", 0, 1, this.description);
            }
            case -1285004149: {
                return new Property("quantity", "unsignedInt", "A count of the number of resource instances that are part of the group.", 0, 1, this.quantity);
            }
            case -988474523: {
                return new Property("managingEntity", "Reference(Organization|RelatedPerson|Practitioner|PractitionerRole)", "Entity responsible for defining and maintaining Group characteristics and/or registered members.", 0, 1, this.managingEntity);
            }
            case 366313883: {
                return new Property(SP_CHARACTERISTIC, "", "Identifies traits whose presence r absence is shared by members of the group.", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case -1077769574: {
                return new Property(SP_MEMBER, "", "Identifies the resource instances that are members of the group.", 0, Integer.MAX_VALUE, this.member);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1340241962: {
                Base[] baseArray;
                if (this.membership == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.membership;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.code;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.name;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.description;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.quantity;
                }
                return baseArray;
            }
            case -988474523: {
                Base[] baseArray;
                if (this.managingEntity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.managingEntity;
                }
                return baseArray;
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case -1077769574: {
                return this.member == null ? new Base[]{} : this.member.toArray(new Base[this.member.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3575610: {
                value = new GroupTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case -1340241962: {
                value = new GroupMembershipBasisEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.membership = value;
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -988474523: {
                this.managingEntity = TypeConvertor.castToReference(value);
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((GroupCharacteristicComponent)((Object)value));
                return value;
            }
            case -1077769574: {
                this.getMember().add((GroupMemberComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("active")) {
            this.active = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_TYPE)) {
            value = new GroupTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_MEMBERSHIP)) {
            value = new GroupMembershipBasisEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.membership = value;
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("quantity")) {
            this.quantity = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("managingEntity")) {
            this.managingEntity = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CHARACTERISTIC)) {
            this.getCharacteristic().add((GroupCharacteristicComponent)((Object)value));
        } else if (name.equals(SP_MEMBER)) {
            this.getMember().add((GroupMemberComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("active")) {
            this.active = null;
        } else if (name.equals(SP_TYPE)) {
            value = new GroupTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_MEMBERSHIP)) {
            value = new GroupMembershipBasisEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.membership = value;
        } else if (name.equals(SP_CODE)) {
            this.code = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("quantity")) {
            this.quantity = null;
        } else if (name.equals("managingEntity")) {
            this.managingEntity = null;
        } else if (name.equals(SP_CHARACTERISTIC)) {
            this.getCharacteristic().remove((GroupCharacteristicComponent)((Object)value));
        } else if (name.equals(SP_MEMBER)) {
            this.getMember().remove((GroupMemberComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -1340241962: {
                return this.getMembershipElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1285004149: {
                return this.getQuantityElement();
            }
            case -988474523: {
                return this.getManagingEntity();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case -1077769574: {
                return this.addMember();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 3575610: {
                return new String[]{SP_CODE};
            }
            case -1340241962: {
                return new String[]{SP_CODE};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -1285004149: {
                return new String[]{"unsignedInt"};
            }
            case -988474523: {
                return new String[]{"Reference"};
            }
            case 366313883: {
                return new String[0];
            }
            case -1077769574: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("active")) {
            throw new FHIRException("Cannot call addChild on a singleton property Group.active");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Group.type");
        }
        if (name.equals(SP_MEMBERSHIP)) {
            throw new FHIRException("Cannot call addChild on a singleton property Group.membership");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property Group.name");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property Group.description");
        }
        if (name.equals("quantity")) {
            throw new FHIRException("Cannot call addChild on a singleton property Group.quantity");
        }
        if (name.equals("managingEntity")) {
            this.managingEntity = new Reference();
            return this.managingEntity;
        }
        if (name.equals(SP_CHARACTERISTIC)) {
            return this.addCharacteristic();
        }
        if (name.equals(SP_MEMBER)) {
            return this.addMember();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Group";
    }

    @Override
    public Group copy() {
        Group dst = new Group();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Group dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.membership = this.membership == null ? null : this.membership.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        Reference reference = dst.managingEntity = this.managingEntity == null ? null : this.managingEntity.copy();
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<GroupCharacteristicComponent>();
            for (GroupCharacteristicComponent groupCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(groupCharacteristicComponent.copy());
            }
        }
        if (this.member != null) {
            dst.member = new ArrayList<GroupMemberComponent>();
            for (GroupMemberComponent groupMemberComponent : this.member) {
                dst.member.add(groupMemberComponent.copy());
            }
        }
    }

    protected Group typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Group)) {
            return false;
        }
        Group o = (Group)other_;
        return Group.compareDeep(this.identifier, o.identifier, true) && Group.compareDeep(this.active, o.active, true) && Group.compareDeep(this.type, o.type, true) && Group.compareDeep(this.membership, o.membership, true) && Group.compareDeep(this.code, o.code, true) && Group.compareDeep(this.name, o.name, true) && Group.compareDeep(this.description, o.description, true) && Group.compareDeep(this.quantity, o.quantity, true) && Group.compareDeep(this.managingEntity, o.managingEntity, true) && Group.compareDeep(this.characteristic, o.characteristic, true) && Group.compareDeep(this.member, o.member, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Group)) {
            return false;
        }
        Group o = (Group)other_;
        return Group.compareValues(this.active, o.active, true) && Group.compareValues(this.type, o.type, true) && Group.compareValues(this.membership, o.membership, true) && Group.compareValues(this.name, o.name, true) && Group.compareValues(this.description, o.description, true) && Group.compareValues(this.quantity, o.quantity, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.type, this.membership, this.code, this.name, this.description, this.quantity, this.managingEntity, this.characteristic, this.member});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Group;
    }

    @Block
    public static class GroupMemberComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Specimen.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to the group member", formalDefinition="A reference to the entity that is a member of the group. Must be consistent with Group.type. If the entity is another group, then the type must be the same.")
        protected Reference entity;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period member belonged to the group", formalDefinition="The period that the member was in the group, if known.")
        protected Period period;
        @Child(name="inactive", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If member is no longer in group", formalDefinition="A flag to indicate that the member is no longer in the group, but previously may have been a member.")
        protected BooleanType inactive;
        private static final long serialVersionUID = -1206153083L;

        public GroupMemberComponent() {
        }

        public GroupMemberComponent(Reference entity) {
            this.setEntity(entity);
        }

        public Reference getEntity() {
            if (this.entity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupMemberComponent.entity");
                }
                if (Configuration.doAutoCreate()) {
                    this.entity = new Reference();
                }
            }
            return this.entity;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public GroupMemberComponent setEntity(Reference value) {
            this.entity = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupMemberComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public GroupMemberComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public BooleanType getInactiveElement() {
            if (this.inactive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupMemberComponent.inactive");
                }
                if (Configuration.doAutoCreate()) {
                    this.inactive = new BooleanType();
                }
            }
            return this.inactive;
        }

        public boolean hasInactiveElement() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public boolean hasInactive() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public GroupMemberComponent setInactiveElement(BooleanType value) {
            this.inactive = value;
            return this;
        }

        public boolean getInactive() {
            return this.inactive == null || this.inactive.isEmpty() ? false : (Boolean)this.inactive.getValue();
        }

        public GroupMemberComponent setInactive(boolean value) {
            if (this.inactive == null) {
                this.inactive = new BooleanType();
            }
            this.inactive.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("entity", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson|Specimen)", "A reference to the entity that is a member of the group. Must be consistent with Group.type. If the entity is another group, then the type must be the same.", 0, 1, this.entity));
            children.add(new Property("period", "Period", "The period that the member was in the group, if known.", 0, 1, this.period));
            children.add(new Property("inactive", "boolean", "A flag to indicate that the member is no longer in the group, but previously may have been a member.", 0, 1, this.inactive));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1298275357: {
                    return new Property("entity", "Reference(CareTeam|Device|Group|HealthcareService|Location|Organization|Patient|Practitioner|PractitionerRole|RelatedPerson|Specimen)", "A reference to the entity that is a member of the group. Must be consistent with Group.type. If the entity is another group, then the type must be the same.", 0, 1, this.entity);
                }
                case -991726143: {
                    return new Property("period", "Period", "The period that the member was in the group, if known.", 0, 1, this.period);
                }
                case 24665195: {
                    return new Property("inactive", "boolean", "A flag to indicate that the member is no longer in the group, but previously may have been a member.", 0, 1, this.inactive);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    Base[] baseArray;
                    if (this.entity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.entity;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 24665195: {
                    Base[] baseArray;
                    if (this.inactive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.inactive;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    this.entity = TypeConvertor.castToReference(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 24665195: {
                    this.inactive = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = TypeConvertor.castToReference(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals("inactive")) {
                this.inactive = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = null;
            } else if (name.equals("period")) {
                this.period = null;
            } else if (name.equals("inactive")) {
                this.inactive = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    return this.getEntity();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 24665195: {
                    return this.getInactiveElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1298275357: {
                    return new String[]{"Reference"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 24665195: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("inactive")) {
                throw new FHIRException("Cannot call addChild on a singleton property Group.member.inactive");
            }
            return super.addChild(name);
        }

        @Override
        public GroupMemberComponent copy() {
            GroupMemberComponent dst = new GroupMemberComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GroupMemberComponent dst) {
            super.copyValues(dst);
            dst.entity = this.entity == null ? null : this.entity.copy();
            dst.period = this.period == null ? null : this.period.copy();
            dst.inactive = this.inactive == null ? null : this.inactive.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GroupMemberComponent)) {
                return false;
            }
            GroupMemberComponent o = (GroupMemberComponent)other_;
            return GroupMemberComponent.compareDeep(this.entity, o.entity, true) && GroupMemberComponent.compareDeep(this.period, o.period, true) && GroupMemberComponent.compareDeep(this.inactive, o.inactive, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GroupMemberComponent)) {
                return false;
            }
            GroupMemberComponent o = (GroupMemberComponent)other_;
            return GroupMemberComponent.compareValues(this.inactive, o.inactive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.entity, this.period, this.inactive});
        }

        @Override
        public String fhirType() {
            return "Group.member";
        }
    }

    @Block
    public static class GroupCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Kind of characteristic", formalDefinition="A code that identifies the kind of trait being asserted.")
        protected CodeableConcept code;
        @Child(name="value", type={CodeableConcept.class, BooleanType.class, Quantity.class, Range.class, Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Value held by characteristic", formalDefinition="The value of the trait that holds (or does not hold - see 'exclude') for members of the group.")
        protected DataType value;
        @Child(name="exclude", type={BooleanType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Group includes or excludes", formalDefinition="If true, indicates the characteristic is one that is NOT held by members of the group.")
        protected BooleanType exclude;
        @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period over which characteristic is tested", formalDefinition="The period over which the characteristic is tested; e.g. the patient had an operation during the month of June.")
        protected Period period;
        private static final long serialVersionUID = 279867823L;

        public GroupCharacteristicComponent() {
        }

        public GroupCharacteristicComponent(CodeableConcept code, DataType value, boolean exclude) {
            this.setCode(code);
            this.setValue(value);
            this.setExclude(exclude);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupCharacteristicComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public GroupCharacteristicComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public GroupCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof BooleanType || value instanceof Quantity || value instanceof Range || value instanceof Reference)) {
                throw new FHIRException("Not the right type for Group.characteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public BooleanType getExcludeElement() {
            if (this.exclude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupCharacteristicComponent.exclude");
                }
                if (Configuration.doAutoCreate()) {
                    this.exclude = new BooleanType();
                }
            }
            return this.exclude;
        }

        public boolean hasExcludeElement() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public boolean hasExclude() {
            return this.exclude != null && !this.exclude.isEmpty();
        }

        public GroupCharacteristicComponent setExcludeElement(BooleanType value) {
            this.exclude = value;
            return this;
        }

        public boolean getExclude() {
            return this.exclude == null || this.exclude.isEmpty() ? false : (Boolean)this.exclude.getValue();
        }

        public GroupCharacteristicComponent setExclude(boolean value) {
            if (this.exclude == null) {
                this.exclude = new BooleanType();
            }
            this.exclude.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupCharacteristicComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public GroupCharacteristicComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Group.SP_CODE, "CodeableConcept", "A code that identifies the kind of trait being asserted.", 0, 1, this.code));
            children.add(new Property("value[x]", "CodeableConcept|boolean|Quantity|Range|Reference", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, 1, this.value));
            children.add(new Property(Group.SP_EXCLUDE, "boolean", "If true, indicates the characteristic is one that is NOT held by members of the group.", 0, 1, this.exclude));
            children.add(new Property("period", "Period", "The period over which the characteristic is tested; e.g. the patient had an operation during the month of June.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(Group.SP_CODE, "CodeableConcept", "A code that identifies the kind of trait being asserted.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|boolean|Quantity|Range|Reference", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|boolean|Quantity|Range|Reference", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference", "The value of the trait that holds (or does not hold - see 'exclude') for members of the group.", 0, 1, this.value);
                }
                case -1321148966: {
                    return new Property(Group.SP_EXCLUDE, "boolean", "If true, indicates the characteristic is one that is NOT held by members of the group.", 0, 1, this.exclude);
                }
                case -991726143: {
                    return new Property("period", "Period", "The period over which the characteristic is tested; e.g. the patient had an operation during the month of June.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1321148966: {
                    Base[] baseArray;
                    if (this.exclude == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.exclude;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case -1321148966: {
                    this.exclude = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Group.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals(Group.SP_EXCLUDE)) {
                this.exclude = TypeConvertor.castToBoolean(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Group.SP_CODE)) {
                this.code = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else if (name.equals(Group.SP_EXCLUDE)) {
                this.exclude = null;
            } else if (name.equals("period")) {
                this.period = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1321148966: {
                    return this.getExcludeElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "boolean", "Quantity", "Range", "Reference"};
                }
                case -1321148966: {
                    return new String[]{"boolean"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Group.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals(Group.SP_EXCLUDE)) {
                throw new FHIRException("Cannot call addChild on a singleton property Group.characteristic.exclude");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public GroupCharacteristicComponent copy() {
            GroupCharacteristicComponent dst = new GroupCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GroupCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.exclude = this.exclude == null ? null : this.exclude.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GroupCharacteristicComponent)) {
                return false;
            }
            GroupCharacteristicComponent o = (GroupCharacteristicComponent)other_;
            return GroupCharacteristicComponent.compareDeep(this.code, o.code, true) && GroupCharacteristicComponent.compareDeep(this.value, o.value, true) && GroupCharacteristicComponent.compareDeep(this.exclude, o.exclude, true) && GroupCharacteristicComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GroupCharacteristicComponent)) {
                return false;
            }
            GroupCharacteristicComponent o = (GroupCharacteristicComponent)other_;
            return GroupCharacteristicComponent.compareValues(this.exclude, o.exclude, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value, this.exclude, this.period});
        }

        @Override
        public String fhirType() {
            return "Group.characteristic";
        }
    }

    public static class GroupTypeEnumFactory
    implements EnumFactory<GroupType> {
        @Override
        public GroupType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("person".equals(codeString)) {
                return GroupType.PERSON;
            }
            if ("animal".equals(codeString)) {
                return GroupType.ANIMAL;
            }
            if ("practitioner".equals(codeString)) {
                return GroupType.PRACTITIONER;
            }
            if ("device".equals(codeString)) {
                return GroupType.DEVICE;
            }
            if ("careteam".equals(codeString)) {
                return GroupType.CARETEAM;
            }
            if ("healthcareservice".equals(codeString)) {
                return GroupType.HEALTHCARESERVICE;
            }
            if ("location".equals(codeString)) {
                return GroupType.LOCATION;
            }
            if ("organization".equals(codeString)) {
                return GroupType.ORGANIZATION;
            }
            if ("relatedperson".equals(codeString)) {
                return GroupType.RELATEDPERSON;
            }
            if ("specimen".equals(codeString)) {
                return GroupType.SPECIMEN;
            }
            throw new IllegalArgumentException("Unknown GroupType code '" + codeString + "'");
        }

        public Enumeration<GroupType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GroupType>(this, GroupType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.NULL, code);
            }
            if ("person".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.PERSON, code);
            }
            if ("animal".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.ANIMAL, code);
            }
            if ("practitioner".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.PRACTITIONER, code);
            }
            if ("device".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.DEVICE, code);
            }
            if ("careteam".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.CARETEAM, code);
            }
            if ("healthcareservice".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.HEALTHCARESERVICE, code);
            }
            if ("location".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.LOCATION, code);
            }
            if ("organization".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.ORGANIZATION, code);
            }
            if ("relatedperson".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.RELATEDPERSON, code);
            }
            if ("specimen".equals(codeString)) {
                return new Enumeration<GroupType>(this, GroupType.SPECIMEN, code);
            }
            throw new FHIRException("Unknown GroupType code '" + codeString + "'");
        }

        @Override
        public String toCode(GroupType code) {
            if (code == GroupType.PERSON) {
                return "person";
            }
            if (code == GroupType.ANIMAL) {
                return "animal";
            }
            if (code == GroupType.PRACTITIONER) {
                return "practitioner";
            }
            if (code == GroupType.DEVICE) {
                return "device";
            }
            if (code == GroupType.CARETEAM) {
                return "careteam";
            }
            if (code == GroupType.HEALTHCARESERVICE) {
                return "healthcareservice";
            }
            if (code == GroupType.LOCATION) {
                return "location";
            }
            if (code == GroupType.ORGANIZATION) {
                return "organization";
            }
            if (code == GroupType.RELATEDPERSON) {
                return "relatedperson";
            }
            if (code == GroupType.SPECIMEN) {
                return "specimen";
            }
            return "?";
        }

        @Override
        public String toSystem(GroupType code) {
            return code.getSystem();
        }
    }

    public static enum GroupType {
        PERSON,
        ANIMAL,
        PRACTITIONER,
        DEVICE,
        CARETEAM,
        HEALTHCARESERVICE,
        LOCATION,
        ORGANIZATION,
        RELATEDPERSON,
        SPECIMEN,
        NULL;


        public static GroupType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("person".equals(codeString)) {
                return PERSON;
            }
            if ("animal".equals(codeString)) {
                return ANIMAL;
            }
            if ("practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("device".equals(codeString)) {
                return DEVICE;
            }
            if ("careteam".equals(codeString)) {
                return CARETEAM;
            }
            if ("healthcareservice".equals(codeString)) {
                return HEALTHCARESERVICE;
            }
            if ("location".equals(codeString)) {
                return LOCATION;
            }
            if ("organization".equals(codeString)) {
                return ORGANIZATION;
            }
            if ("relatedperson".equals(codeString)) {
                return RELATEDPERSON;
            }
            if ("specimen".equals(codeString)) {
                return SPECIMEN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GroupType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PERSON: {
                    return "person";
                }
                case ANIMAL: {
                    return "animal";
                }
                case PRACTITIONER: {
                    return "practitioner";
                }
                case DEVICE: {
                    return "device";
                }
                case CARETEAM: {
                    return "careteam";
                }
                case HEALTHCARESERVICE: {
                    return "healthcareservice";
                }
                case LOCATION: {
                    return "location";
                }
                case ORGANIZATION: {
                    return "organization";
                }
                case RELATEDPERSON: {
                    return "relatedperson";
                }
                case SPECIMEN: {
                    return "specimen";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PERSON: {
                    return "http://hl7.org/fhir/group-type";
                }
                case ANIMAL: {
                    return "http://hl7.org/fhir/group-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/group-type";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/group-type";
                }
                case CARETEAM: {
                    return "http://hl7.org/fhir/group-type";
                }
                case HEALTHCARESERVICE: {
                    return "http://hl7.org/fhir/group-type";
                }
                case LOCATION: {
                    return "http://hl7.org/fhir/group-type";
                }
                case ORGANIZATION: {
                    return "http://hl7.org/fhir/group-type";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/group-type";
                }
                case SPECIMEN: {
                    return "http://hl7.org/fhir/group-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PERSON: {
                    return "Group contains \"person\" Patient resources.";
                }
                case ANIMAL: {
                    return "Group contains \"animal\" Patient resources.";
                }
                case PRACTITIONER: {
                    return "Group contains healthcare practitioner resources (Practitioner or PractitionerRole).";
                }
                case DEVICE: {
                    return "Group contains Device resources.";
                }
                case CARETEAM: {
                    return "Group contains CareTeam resources.";
                }
                case HEALTHCARESERVICE: {
                    return "Group contains HealthcareService resources.";
                }
                case LOCATION: {
                    return "Group contains Location resources.";
                }
                case ORGANIZATION: {
                    return "Group contains Organization resources.";
                }
                case RELATEDPERSON: {
                    return "Group contains RelatedPerson resources.";
                }
                case SPECIMEN: {
                    return "Group contains Specimen resources.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PERSON: {
                    return "Person";
                }
                case ANIMAL: {
                    return "Animal";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case DEVICE: {
                    return "Device";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case LOCATION: {
                    return "Location";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class GroupMembershipBasisEnumFactory
    implements EnumFactory<GroupMembershipBasis> {
        @Override
        public GroupMembershipBasis fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("definitional".equals(codeString)) {
                return GroupMembershipBasis.DEFINITIONAL;
            }
            if ("enumerated".equals(codeString)) {
                return GroupMembershipBasis.ENUMERATED;
            }
            throw new IllegalArgumentException("Unknown GroupMembershipBasis code '" + codeString + "'");
        }

        public Enumeration<GroupMembershipBasis> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GroupMembershipBasis>(this, GroupMembershipBasis.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GroupMembershipBasis>(this, GroupMembershipBasis.NULL, code);
            }
            if ("definitional".equals(codeString)) {
                return new Enumeration<GroupMembershipBasis>(this, GroupMembershipBasis.DEFINITIONAL, code);
            }
            if ("enumerated".equals(codeString)) {
                return new Enumeration<GroupMembershipBasis>(this, GroupMembershipBasis.ENUMERATED, code);
            }
            throw new FHIRException("Unknown GroupMembershipBasis code '" + codeString + "'");
        }

        @Override
        public String toCode(GroupMembershipBasis code) {
            if (code == GroupMembershipBasis.DEFINITIONAL) {
                return "definitional";
            }
            if (code == GroupMembershipBasis.ENUMERATED) {
                return "enumerated";
            }
            return "?";
        }

        @Override
        public String toSystem(GroupMembershipBasis code) {
            return code.getSystem();
        }
    }

    public static enum GroupMembershipBasis {
        DEFINITIONAL,
        ENUMERATED,
        NULL;


        public static GroupMembershipBasis fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("definitional".equals(codeString)) {
                return DEFINITIONAL;
            }
            if ("enumerated".equals(codeString)) {
                return ENUMERATED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GroupMembershipBasis code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DEFINITIONAL: {
                    return "definitional";
                }
                case ENUMERATED: {
                    return "enumerated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DEFINITIONAL: {
                    return "http://hl7.org/fhir/group-membership-basis";
                }
                case ENUMERATED: {
                    return "http://hl7.org/fhir/group-membership-basis";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DEFINITIONAL: {
                    return "The Group.characteristics specified are both necessary and sufficient to determine membership. All entities that meet the criteria are considered to be members of the group, whether referenced by the group or not. If members are present, they are individuals that happen to be known as meeting the Group.characteristics. The list cannot be presumed to be complete.";
                }
                case ENUMERATED: {
                    return "The Group.characteristics are necessary but not sufficient to determine membership. Membership is determined by being listed as one of the Group.member.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DEFINITIONAL: {
                    return "Definitional";
                }
                case ENUMERATED: {
                    return "Enumerated";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

