/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="InventoryItem", profile="http://hl7.org/fhir/StructureDefinition/InventoryItem")
public class InventoryItem
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for the inventory item", formalDefinition="Business identifier for the inventory item.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error | unknown", formalDefinition="Status of the item entry.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/inventoryitem-status")
    protected Enumeration<InventoryItemStatusCodes> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Category or class of the item", formalDefinition="Category or class of the item.")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Code designating the specific type of item", formalDefinition="Code designating the specific type of item.")
    protected List<CodeableConcept> code;
    @Child(name="name", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The item name(s) - the brand name, or common name, functional name, generic name or others", formalDefinition="The item name(s) - the brand name, or common name, functional name, generic name.")
    protected List<InventoryItemNameComponent> name;
    @Child(name="responsibleOrganization", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Organization(s) responsible for the product", formalDefinition="Organization(s) responsible for the product.")
    protected List<InventoryItemResponsibleOrganizationComponent> responsibleOrganization;
    @Child(name="description", type={}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Descriptive characteristics of the item", formalDefinition="The descriptive characteristics of the inventory item.")
    protected InventoryItemDescriptionComponent description;
    @Child(name="inventoryStatus", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The usage status like recalled, in use, discarded", formalDefinition="The usage status e.g. recalled, in use, discarded... This can be used to indicate that the items have been taken out of inventory, or are in use, etc.")
    protected List<CodeableConcept> inventoryStatus;
    @Child(name="baseUnit", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The base unit of measure - the unit in which the product is used or counted", formalDefinition="The base unit of measure - the unit in which the product is used or counted.")
    protected CodeableConcept baseUnit;
    @Child(name="netContent", type={Quantity.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Net content or amount present in the item", formalDefinition="Net content or amount present in the item.")
    protected Quantity netContent;
    @Child(name="association", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Association with other items or products", formalDefinition="Association with other items or products.")
    protected List<InventoryItemAssociationComponent> association;
    @Child(name="characteristic", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Characteristic of the item", formalDefinition="The descriptive or identifying characteristics of the item.")
    protected List<InventoryItemCharacteristicComponent> characteristic;
    @Child(name="instance", type={}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Instances or occurrences of the product", formalDefinition="Instances or occurrences of the product.")
    protected InventoryItemInstanceComponent instance;
    @Child(name="productReference", type={Medication.class, Device.class, NutritionProduct.class, BiologicallyDerivedProduct.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Link to a product resource used in clinical workflows", formalDefinition="Link to a product resource used in clinical workflows.")
    protected Reference productReference;
    private static final long serialVersionUID = 2127201564L;
    @SearchParamDefinition(name="code", path="InventoryItem.code", description="Search for products that match this code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="InventoryItem.identifier", description="The identifier of the item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="InventoryItem.status", description="The status of the item", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="InventoryItem.instance.subject", description="The identity of a patient for whom to list associations", type="reference", target={Organization.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("InventoryItem:subject").toLocked();

    public InventoryItem() {
    }

    public InventoryItem(InventoryItemStatusCodes status) {
        this.setStatus(status);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public InventoryItem setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public InventoryItem addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<InventoryItemStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryItem.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<InventoryItemStatusCodes>(new InventoryItemStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public InventoryItem setStatusElement(Enumeration<InventoryItemStatusCodes> value) {
        this.status = value;
        return this;
    }

    public InventoryItemStatusCodes getStatus() {
        return this.status == null ? null : (InventoryItemStatusCodes)((Object)this.status.getValue());
    }

    public InventoryItem setStatus(InventoryItemStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<InventoryItemStatusCodes>(new InventoryItemStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public InventoryItem setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public InventoryItem addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<CodeableConcept> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        return this.code;
    }

    public InventoryItem setCode(List<CodeableConcept> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (CodeableConcept item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        this.code.add(t);
        return t;
    }

    public InventoryItem addCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        this.code.add(t);
        return this;
    }

    public CodeableConcept getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public List<InventoryItemNameComponent> getName() {
        if (this.name == null) {
            this.name = new ArrayList<InventoryItemNameComponent>();
        }
        return this.name;
    }

    public InventoryItem setName(List<InventoryItemNameComponent> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (InventoryItemNameComponent item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InventoryItemNameComponent addName() {
        InventoryItemNameComponent t = new InventoryItemNameComponent();
        if (this.name == null) {
            this.name = new ArrayList<InventoryItemNameComponent>();
        }
        this.name.add(t);
        return t;
    }

    public InventoryItem addName(InventoryItemNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<InventoryItemNameComponent>();
        }
        this.name.add(t);
        return this;
    }

    public InventoryItemNameComponent getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<InventoryItemResponsibleOrganizationComponent> getResponsibleOrganization() {
        if (this.responsibleOrganization == null) {
            this.responsibleOrganization = new ArrayList<InventoryItemResponsibleOrganizationComponent>();
        }
        return this.responsibleOrganization;
    }

    public InventoryItem setResponsibleOrganization(List<InventoryItemResponsibleOrganizationComponent> theResponsibleOrganization) {
        this.responsibleOrganization = theResponsibleOrganization;
        return this;
    }

    public boolean hasResponsibleOrganization() {
        if (this.responsibleOrganization == null) {
            return false;
        }
        for (InventoryItemResponsibleOrganizationComponent item : this.responsibleOrganization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InventoryItemResponsibleOrganizationComponent addResponsibleOrganization() {
        InventoryItemResponsibleOrganizationComponent t = new InventoryItemResponsibleOrganizationComponent();
        if (this.responsibleOrganization == null) {
            this.responsibleOrganization = new ArrayList<InventoryItemResponsibleOrganizationComponent>();
        }
        this.responsibleOrganization.add(t);
        return t;
    }

    public InventoryItem addResponsibleOrganization(InventoryItemResponsibleOrganizationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.responsibleOrganization == null) {
            this.responsibleOrganization = new ArrayList<InventoryItemResponsibleOrganizationComponent>();
        }
        this.responsibleOrganization.add(t);
        return this;
    }

    public InventoryItemResponsibleOrganizationComponent getResponsibleOrganizationFirstRep() {
        if (this.getResponsibleOrganization().isEmpty()) {
            this.addResponsibleOrganization();
        }
        return this.getResponsibleOrganization().get(0);
    }

    public InventoryItemDescriptionComponent getDescription() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryItem.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new InventoryItemDescriptionComponent();
            }
        }
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public InventoryItem setDescription(InventoryItemDescriptionComponent value) {
        this.description = value;
        return this;
    }

    public List<CodeableConcept> getInventoryStatus() {
        if (this.inventoryStatus == null) {
            this.inventoryStatus = new ArrayList<CodeableConcept>();
        }
        return this.inventoryStatus;
    }

    public InventoryItem setInventoryStatus(List<CodeableConcept> theInventoryStatus) {
        this.inventoryStatus = theInventoryStatus;
        return this;
    }

    public boolean hasInventoryStatus() {
        if (this.inventoryStatus == null) {
            return false;
        }
        for (CodeableConcept item : this.inventoryStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addInventoryStatus() {
        CodeableConcept t = new CodeableConcept();
        if (this.inventoryStatus == null) {
            this.inventoryStatus = new ArrayList<CodeableConcept>();
        }
        this.inventoryStatus.add(t);
        return t;
    }

    public InventoryItem addInventoryStatus(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.inventoryStatus == null) {
            this.inventoryStatus = new ArrayList<CodeableConcept>();
        }
        this.inventoryStatus.add(t);
        return this;
    }

    public CodeableConcept getInventoryStatusFirstRep() {
        if (this.getInventoryStatus().isEmpty()) {
            this.addInventoryStatus();
        }
        return this.getInventoryStatus().get(0);
    }

    public CodeableConcept getBaseUnit() {
        if (this.baseUnit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryItem.baseUnit");
            }
            if (Configuration.doAutoCreate()) {
                this.baseUnit = new CodeableConcept();
            }
        }
        return this.baseUnit;
    }

    public boolean hasBaseUnit() {
        return this.baseUnit != null && !this.baseUnit.isEmpty();
    }

    public InventoryItem setBaseUnit(CodeableConcept value) {
        this.baseUnit = value;
        return this;
    }

    public Quantity getNetContent() {
        if (this.netContent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryItem.netContent");
            }
            if (Configuration.doAutoCreate()) {
                this.netContent = new Quantity();
            }
        }
        return this.netContent;
    }

    public boolean hasNetContent() {
        return this.netContent != null && !this.netContent.isEmpty();
    }

    public InventoryItem setNetContent(Quantity value) {
        this.netContent = value;
        return this;
    }

    public List<InventoryItemAssociationComponent> getAssociation() {
        if (this.association == null) {
            this.association = new ArrayList<InventoryItemAssociationComponent>();
        }
        return this.association;
    }

    public InventoryItem setAssociation(List<InventoryItemAssociationComponent> theAssociation) {
        this.association = theAssociation;
        return this;
    }

    public boolean hasAssociation() {
        if (this.association == null) {
            return false;
        }
        for (InventoryItemAssociationComponent item : this.association) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InventoryItemAssociationComponent addAssociation() {
        InventoryItemAssociationComponent t = new InventoryItemAssociationComponent();
        if (this.association == null) {
            this.association = new ArrayList<InventoryItemAssociationComponent>();
        }
        this.association.add(t);
        return t;
    }

    public InventoryItem addAssociation(InventoryItemAssociationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.association == null) {
            this.association = new ArrayList<InventoryItemAssociationComponent>();
        }
        this.association.add(t);
        return this;
    }

    public InventoryItemAssociationComponent getAssociationFirstRep() {
        if (this.getAssociation().isEmpty()) {
            this.addAssociation();
        }
        return this.getAssociation().get(0);
    }

    public List<InventoryItemCharacteristicComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<InventoryItemCharacteristicComponent>();
        }
        return this.characteristic;
    }

    public InventoryItem setCharacteristic(List<InventoryItemCharacteristicComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (InventoryItemCharacteristicComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InventoryItemCharacteristicComponent addCharacteristic() {
        InventoryItemCharacteristicComponent t = new InventoryItemCharacteristicComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<InventoryItemCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public InventoryItem addCharacteristic(InventoryItemCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<InventoryItemCharacteristicComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public InventoryItemCharacteristicComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public InventoryItemInstanceComponent getInstance() {
        if (this.instance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryItem.instance");
            }
            if (Configuration.doAutoCreate()) {
                this.instance = new InventoryItemInstanceComponent();
            }
        }
        return this.instance;
    }

    public boolean hasInstance() {
        return this.instance != null && !this.instance.isEmpty();
    }

    public InventoryItem setInstance(InventoryItemInstanceComponent value) {
        this.instance = value;
        return this;
    }

    public Reference getProductReference() {
        if (this.productReference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryItem.productReference");
            }
            if (Configuration.doAutoCreate()) {
                this.productReference = new Reference();
            }
        }
        return this.productReference;
    }

    public boolean hasProductReference() {
        return this.productReference != null && !this.productReference.isEmpty();
    }

    public InventoryItem setProductReference(Reference value) {
        this.productReference = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for the inventory item.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, SP_CODE, "Status of the item entry.", 0, 1, this.status));
        children.add(new Property("category", "CodeableConcept", "Category or class of the item.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "Code designating the specific type of item.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property("name", "", "The item name(s) - the brand name, or common name, functional name, generic name.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property("responsibleOrganization", "", "Organization(s) responsible for the product.", 0, Integer.MAX_VALUE, this.responsibleOrganization));
        children.add(new Property("description", "", "The descriptive characteristics of the inventory item.", 0, 1, this.description));
        children.add(new Property("inventoryStatus", "CodeableConcept", "The usage status e.g. recalled, in use, discarded... This can be used to indicate that the items have been taken out of inventory, or are in use, etc.", 0, Integer.MAX_VALUE, this.inventoryStatus));
        children.add(new Property("baseUnit", "CodeableConcept", "The base unit of measure - the unit in which the product is used or counted.", 0, 1, this.baseUnit));
        children.add(new Property("netContent", "Quantity", "Net content or amount present in the item.", 0, 1, this.netContent));
        children.add(new Property("association", "", "Association with other items or products.", 0, Integer.MAX_VALUE, this.association));
        children.add(new Property("characteristic", "", "The descriptive or identifying characteristics of the item.", 0, Integer.MAX_VALUE, this.characteristic));
        children.add(new Property("instance", "", "Instances or occurrences of the product.", 0, 1, this.instance));
        children.add(new Property("productReference", "Reference(Medication|Device|NutritionProduct|BiologicallyDerivedProduct)", "Link to a product resource used in clinical workflows.", 0, 1, this.productReference));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for the inventory item.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "Status of the item entry.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Category or class of the item.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Code designating the specific type of item.", 0, Integer.MAX_VALUE, this.code);
            }
            case 3373707: {
                return new Property("name", "", "The item name(s) - the brand name, or common name, functional name, generic name.", 0, Integer.MAX_VALUE, this.name);
            }
            case -1704933559: {
                return new Property("responsibleOrganization", "", "Organization(s) responsible for the product.", 0, Integer.MAX_VALUE, this.responsibleOrganization);
            }
            case -1724546052: {
                return new Property("description", "", "The descriptive characteristics of the inventory item.", 0, 1, this.description);
            }
            case -1370922898: {
                return new Property("inventoryStatus", "CodeableConcept", "The usage status e.g. recalled, in use, discarded... This can be used to indicate that the items have been taken out of inventory, or are in use, etc.", 0, Integer.MAX_VALUE, this.inventoryStatus);
            }
            case -1721465867: {
                return new Property("baseUnit", "CodeableConcept", "The base unit of measure - the unit in which the product is used or counted.", 0, 1, this.baseUnit);
            }
            case 612796444: {
                return new Property("netContent", "Quantity", "Net content or amount present in the item.", 0, 1, this.netContent);
            }
            case -87499647: {
                return new Property("association", "", "Association with other items or products.", 0, Integer.MAX_VALUE, this.association);
            }
            case 366313883: {
                return new Property("characteristic", "", "The descriptive or identifying characteristics of the item.", 0, Integer.MAX_VALUE, this.characteristic);
            }
            case 555127957: {
                return new Property("instance", "", "Instances or occurrences of the product.", 0, 1, this.instance);
            }
            case -669667556: {
                return new Property("productReference", "Reference(Medication|Device|NutritionProduct|BiologicallyDerivedProduct)", "Link to a product resource used in clinical workflows.", 0, 1, this.productReference);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -1704933559: {
                return this.responsibleOrganization == null ? new Base[]{} : this.responsibleOrganization.toArray(new Base[this.responsibleOrganization.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.description;
                }
                return baseArray;
            }
            case -1370922898: {
                return this.inventoryStatus == null ? new Base[]{} : this.inventoryStatus.toArray(new Base[this.inventoryStatus.size()]);
            }
            case -1721465867: {
                Base[] baseArray;
                if (this.baseUnit == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.baseUnit;
                }
                return baseArray;
            }
            case 612796444: {
                Base[] baseArray;
                if (this.netContent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.netContent;
                }
                return baseArray;
            }
            case -87499647: {
                return this.association == null ? new Base[]{} : this.association.toArray(new Base[this.association.size()]);
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
            case 555127957: {
                Base[] baseArray;
                if (this.instance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.instance;
                }
                return baseArray;
            }
            case -669667556: {
                Base[] baseArray;
                if (this.productReference == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.productReference;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new InventoryItemStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.getName().add((InventoryItemNameComponent)((Object)value));
                return value;
            }
            case -1704933559: {
                this.getResponsibleOrganization().add((InventoryItemResponsibleOrganizationComponent)((Object)value));
                return value;
            }
            case -1724546052: {
                this.description = (InventoryItemDescriptionComponent)((Object)value);
                return value;
            }
            case -1370922898: {
                this.getInventoryStatus().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1721465867: {
                this.baseUnit = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 612796444: {
                this.netContent = TypeConvertor.castToQuantity(value);
                return value;
            }
            case -87499647: {
                this.getAssociation().add((InventoryItemAssociationComponent)((Object)value));
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((InventoryItemCharacteristicComponent)((Object)value));
                return value;
            }
            case 555127957: {
                this.instance = (InventoryItemInstanceComponent)((Object)value);
                return value;
            }
            case -669667556: {
                this.productReference = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new InventoryItemStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.getCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("name")) {
            this.getName().add((InventoryItemNameComponent)((Object)value));
        } else if (name.equals("responsibleOrganization")) {
            this.getResponsibleOrganization().add((InventoryItemResponsibleOrganizationComponent)((Object)value));
        } else if (name.equals("description")) {
            this.description = (InventoryItemDescriptionComponent)((Object)value);
        } else if (name.equals("inventoryStatus")) {
            this.getInventoryStatus().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("baseUnit")) {
            this.baseUnit = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("netContent")) {
            this.netContent = TypeConvertor.castToQuantity(value);
        } else if (name.equals("association")) {
            this.getAssociation().add((InventoryItemAssociationComponent)((Object)value));
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add((InventoryItemCharacteristicComponent)((Object)value));
        } else if (name.equals("instance")) {
            this.instance = (InventoryItemInstanceComponent)((Object)value);
        } else if (name.equals("productReference")) {
            this.productReference = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new InventoryItemStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("category")) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_CODE)) {
            this.getCode().remove(value);
        } else if (name.equals("name")) {
            this.getName().remove((InventoryItemNameComponent)((Object)value));
        } else if (name.equals("responsibleOrganization")) {
            this.getResponsibleOrganization().remove((InventoryItemResponsibleOrganizationComponent)((Object)value));
        } else if (name.equals("description")) {
            this.description = (InventoryItemDescriptionComponent)((Object)value);
        } else if (name.equals("inventoryStatus")) {
            this.getInventoryStatus().remove(value);
        } else if (name.equals("baseUnit")) {
            this.baseUnit = null;
        } else if (name.equals("netContent")) {
            this.netContent = null;
        } else if (name.equals("association")) {
            this.getAssociation().remove((InventoryItemAssociationComponent)((Object)value));
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().remove((InventoryItemCharacteristicComponent)((Object)value));
        } else if (name.equals("instance")) {
            this.instance = (InventoryItemInstanceComponent)((Object)value);
        } else if (name.equals("productReference")) {
            this.productReference = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.addCode();
            }
            case 3373707: {
                return this.addName();
            }
            case -1704933559: {
                return this.addResponsibleOrganization();
            }
            case -1724546052: {
                return this.getDescription();
            }
            case -1370922898: {
                return this.addInventoryStatus();
            }
            case -1721465867: {
                return this.getBaseUnit();
            }
            case 612796444: {
                return this.getNetContent();
            }
            case -87499647: {
                return this.addAssociation();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
            case 555127957: {
                return this.getInstance();
            }
            case -669667556: {
                return this.getProductReference();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[0];
            }
            case -1704933559: {
                return new String[0];
            }
            case -1724546052: {
                return new String[0];
            }
            case -1370922898: {
                return new String[]{"CodeableConcept"};
            }
            case -1721465867: {
                return new String[]{"CodeableConcept"};
            }
            case 612796444: {
                return new String[]{"Quantity"};
            }
            case -87499647: {
                return new String[0];
            }
            case 366313883: {
                return new String[0];
            }
            case 555127957: {
                return new String[0];
            }
            case -669667556: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property InventoryItem.status");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            return this.addCode();
        }
        if (name.equals("name")) {
            return this.addName();
        }
        if (name.equals("responsibleOrganization")) {
            return this.addResponsibleOrganization();
        }
        if (name.equals("description")) {
            this.description = new InventoryItemDescriptionComponent();
            return this.description;
        }
        if (name.equals("inventoryStatus")) {
            return this.addInventoryStatus();
        }
        if (name.equals("baseUnit")) {
            this.baseUnit = new CodeableConcept();
            return this.baseUnit;
        }
        if (name.equals("netContent")) {
            this.netContent = new Quantity();
            return this.netContent;
        }
        if (name.equals("association")) {
            return this.addAssociation();
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        if (name.equals("instance")) {
            this.instance = new InventoryItemInstanceComponent();
            return this.instance;
        }
        if (name.equals("productReference")) {
            this.productReference = new Reference();
            return this.productReference;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "InventoryItem";
    }

    @Override
    public InventoryItem copy() {
        InventoryItem dst = new InventoryItem();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(InventoryItem dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<InventoryItemStatusCodes> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        if (this.code != null) {
            dst.code = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.code) {
                dst.code.add(codeableConcept.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<InventoryItemNameComponent>();
            for (InventoryItemNameComponent inventoryItemNameComponent : this.name) {
                dst.name.add(inventoryItemNameComponent.copy());
            }
        }
        if (this.responsibleOrganization != null) {
            dst.responsibleOrganization = new ArrayList<InventoryItemResponsibleOrganizationComponent>();
            for (InventoryItemResponsibleOrganizationComponent inventoryItemResponsibleOrganizationComponent : this.responsibleOrganization) {
                dst.responsibleOrganization.add(inventoryItemResponsibleOrganizationComponent.copy());
            }
        }
        InventoryItemDescriptionComponent inventoryItemDescriptionComponent = dst.description = this.description == null ? null : this.description.copy();
        if (this.inventoryStatus != null) {
            dst.inventoryStatus = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.inventoryStatus) {
                dst.inventoryStatus.add(codeableConcept.copy());
            }
        }
        dst.baseUnit = this.baseUnit == null ? null : this.baseUnit.copy();
        Quantity quantity = dst.netContent = this.netContent == null ? null : this.netContent.copy();
        if (this.association != null) {
            dst.association = new ArrayList<InventoryItemAssociationComponent>();
            for (InventoryItemAssociationComponent inventoryItemAssociationComponent : this.association) {
                dst.association.add(inventoryItemAssociationComponent.copy());
            }
        }
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<InventoryItemCharacteristicComponent>();
            for (InventoryItemCharacteristicComponent inventoryItemCharacteristicComponent : this.characteristic) {
                dst.characteristic.add(inventoryItemCharacteristicComponent.copy());
            }
        }
        dst.instance = this.instance == null ? null : this.instance.copy();
        dst.productReference = this.productReference == null ? null : this.productReference.copy();
    }

    protected InventoryItem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof InventoryItem)) {
            return false;
        }
        InventoryItem o = (InventoryItem)other_;
        return InventoryItem.compareDeep(this.identifier, o.identifier, true) && InventoryItem.compareDeep(this.status, o.status, true) && InventoryItem.compareDeep(this.category, o.category, true) && InventoryItem.compareDeep(this.code, o.code, true) && InventoryItem.compareDeep(this.name, o.name, true) && InventoryItem.compareDeep(this.responsibleOrganization, o.responsibleOrganization, true) && InventoryItem.compareDeep(this.description, o.description, true) && InventoryItem.compareDeep(this.inventoryStatus, o.inventoryStatus, true) && InventoryItem.compareDeep(this.baseUnit, o.baseUnit, true) && InventoryItem.compareDeep(this.netContent, o.netContent, true) && InventoryItem.compareDeep(this.association, o.association, true) && InventoryItem.compareDeep(this.characteristic, o.characteristic, true) && InventoryItem.compareDeep(this.instance, o.instance, true) && InventoryItem.compareDeep(this.productReference, o.productReference, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof InventoryItem)) {
            return false;
        }
        InventoryItem o = (InventoryItem)other_;
        return InventoryItem.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.category, this.code, this.name, this.responsibleOrganization, this.description, this.inventoryStatus, this.baseUnit, this.netContent, this.association, this.characteristic, this.instance, this.productReference});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.InventoryItem;
    }

    @Block
    public static class InventoryItemInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The identifier for the physical instance, typically a serial number", formalDefinition="The identifier for the physical instance, typically a serial number.")
        protected List<Identifier> identifier;
        @Child(name="lotNumber", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The lot or batch number of the item", formalDefinition="The lot or batch number of the item.")
        protected StringType lotNumber;
        @Child(name="expiry", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The expiry date or date and time for the product", formalDefinition="The expiry date or date and time for the product.")
        protected DateTimeType expiry;
        @Child(name="subject", type={Patient.class, Organization.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The subject that the item is associated with", formalDefinition="The subject that the item is associated with.")
        protected Reference subject;
        @Child(name="location", type={Location.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The location that the item is associated with", formalDefinition="The location that the item is associated with.")
        protected Reference location;
        private static final long serialVersionUID = 657936980L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public InventoryItemInstanceComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public InventoryItemInstanceComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public StringType getLotNumberElement() {
            if (this.lotNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemInstanceComponent.lotNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.lotNumber = new StringType();
                }
            }
            return this.lotNumber;
        }

        public boolean hasLotNumberElement() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public boolean hasLotNumber() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public InventoryItemInstanceComponent setLotNumberElement(StringType value) {
            this.lotNumber = value;
            return this;
        }

        public String getLotNumber() {
            return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
        }

        public InventoryItemInstanceComponent setLotNumber(String value) {
            if (Utilities.noString((String)value)) {
                this.lotNumber = null;
            } else {
                if (this.lotNumber == null) {
                    this.lotNumber = new StringType();
                }
                this.lotNumber.setValue(value);
            }
            return this;
        }

        public DateTimeType getExpiryElement() {
            if (this.expiry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemInstanceComponent.expiry");
                }
                if (Configuration.doAutoCreate()) {
                    this.expiry = new DateTimeType();
                }
            }
            return this.expiry;
        }

        public boolean hasExpiryElement() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public boolean hasExpiry() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public InventoryItemInstanceComponent setExpiryElement(DateTimeType value) {
            this.expiry = value;
            return this;
        }

        public Date getExpiry() {
            return this.expiry == null ? null : (Date)this.expiry.getValue();
        }

        public InventoryItemInstanceComponent setExpiry(Date value) {
            if (value == null) {
                this.expiry = null;
            } else {
                if (this.expiry == null) {
                    this.expiry = new DateTimeType();
                }
                this.expiry.setValue(value);
            }
            return this;
        }

        public Reference getSubject() {
            if (this.subject == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemInstanceComponent.subject");
                }
                if (Configuration.doAutoCreate()) {
                    this.subject = new Reference();
                }
            }
            return this.subject;
        }

        public boolean hasSubject() {
            return this.subject != null && !this.subject.isEmpty();
        }

        public InventoryItemInstanceComponent setSubject(Reference value) {
            this.subject = value;
            return this;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemInstanceComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public InventoryItemInstanceComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(InventoryItem.SP_IDENTIFIER, "Identifier", "The identifier for the physical instance, typically a serial number.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("lotNumber", "string", "The lot or batch number of the item.", 0, 1, this.lotNumber));
            children.add(new Property("expiry", "dateTime", "The expiry date or date and time for the product.", 0, 1, this.expiry));
            children.add(new Property(InventoryItem.SP_SUBJECT, "Reference(Patient|Organization)", "The subject that the item is associated with.", 0, 1, this.subject));
            children.add(new Property("location", "Reference(Location)", "The location that the item is associated with.", 0, 1, this.location));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(InventoryItem.SP_IDENTIFIER, "Identifier", "The identifier for the physical instance, typically a serial number.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 462547450: {
                    return new Property("lotNumber", "string", "The lot or batch number of the item.", 0, 1, this.lotNumber);
                }
                case -1289159373: {
                    return new Property("expiry", "dateTime", "The expiry date or date and time for the product.", 0, 1, this.expiry);
                }
                case -1867885268: {
                    return new Property(InventoryItem.SP_SUBJECT, "Reference(Patient|Organization)", "The subject that the item is associated with.", 0, 1, this.subject);
                }
                case 1901043637: {
                    return new Property("location", "Reference(Location)", "The location that the item is associated with.", 0, 1, this.location);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 462547450: {
                    Base[] baseArray;
                    if (this.lotNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lotNumber;
                    }
                    return baseArray;
                }
                case -1289159373: {
                    Base[] baseArray;
                    if (this.expiry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expiry;
                    }
                    return baseArray;
                }
                case -1867885268: {
                    Base[] baseArray;
                    if (this.subject == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.subject;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.location;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 462547450: {
                    this.lotNumber = TypeConvertor.castToString(value);
                    return value;
                }
                case -1289159373: {
                    this.expiry = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case -1867885268: {
                    this.subject = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(InventoryItem.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("lotNumber")) {
                this.lotNumber = TypeConvertor.castToString(value);
            } else if (name.equals("expiry")) {
                this.expiry = TypeConvertor.castToDateTime(value);
            } else if (name.equals(InventoryItem.SP_SUBJECT)) {
                this.subject = TypeConvertor.castToReference(value);
            } else if (name.equals("location")) {
                this.location = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(InventoryItem.SP_IDENTIFIER)) {
                this.getIdentifier().remove(value);
            } else if (name.equals("lotNumber")) {
                this.lotNumber = null;
            } else if (name.equals("expiry")) {
                this.expiry = null;
            } else if (name.equals(InventoryItem.SP_SUBJECT)) {
                this.subject = null;
            } else if (name.equals("location")) {
                this.location = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 462547450: {
                    return this.getLotNumberElement();
                }
                case -1289159373: {
                    return this.getExpiryElement();
                }
                case -1867885268: {
                    return this.getSubject();
                }
                case 1901043637: {
                    return this.getLocation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 462547450: {
                    return new String[]{"string"};
                }
                case -1289159373: {
                    return new String[]{"dateTime"};
                }
                case -1867885268: {
                    return new String[]{"Reference"};
                }
                case 1901043637: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(InventoryItem.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("lotNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property InventoryItem.instance.lotNumber");
            }
            if (name.equals("expiry")) {
                throw new FHIRException("Cannot call addChild on a singleton property InventoryItem.instance.expiry");
            }
            if (name.equals(InventoryItem.SP_SUBJECT)) {
                this.subject = new Reference();
                return this.subject;
            }
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            return super.addChild(name);
        }

        @Override
        public InventoryItemInstanceComponent copy() {
            InventoryItemInstanceComponent dst = new InventoryItemInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryItemInstanceComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier i : this.identifier) {
                    dst.identifier.add(i.copy());
                }
            }
            dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
            dst.expiry = this.expiry == null ? null : this.expiry.copy();
            dst.subject = this.subject == null ? null : this.subject.copy();
            dst.location = this.location == null ? null : this.location.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemInstanceComponent)) {
                return false;
            }
            InventoryItemInstanceComponent o = (InventoryItemInstanceComponent)other_;
            return InventoryItemInstanceComponent.compareDeep(this.identifier, o.identifier, true) && InventoryItemInstanceComponent.compareDeep(this.lotNumber, o.lotNumber, true) && InventoryItemInstanceComponent.compareDeep(this.expiry, o.expiry, true) && InventoryItemInstanceComponent.compareDeep(this.subject, o.subject, true) && InventoryItemInstanceComponent.compareDeep(this.location, o.location, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemInstanceComponent)) {
                return false;
            }
            InventoryItemInstanceComponent o = (InventoryItemInstanceComponent)other_;
            return InventoryItemInstanceComponent.compareValues(this.lotNumber, o.lotNumber, true) && InventoryItemInstanceComponent.compareValues(this.expiry, o.expiry, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.lotNumber, this.expiry, this.subject, this.location});
        }

        @Override
        public String fhirType() {
            return "InventoryItem.instance";
        }
    }

    @Block
    public static class InventoryItemCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="characteristicType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The characteristic that is being defined", formalDefinition="The type of characteristic that is being defined.")
        protected CodeableConcept characteristicType;
        @Child(name="value", type={StringType.class, IntegerType.class, DecimalType.class, BooleanType.class, UrlType.class, DateTimeType.class, Quantity.class, Range.class, Ratio.class, Annotation.class, Address.class, Duration.class, CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The value of the attribute", formalDefinition="The value of the attribute.")
        protected DataType value;
        private static final long serialVersionUID = -642436065L;

        public InventoryItemCharacteristicComponent() {
        }

        public InventoryItemCharacteristicComponent(CodeableConcept characteristicType, DataType value) {
            this.setCharacteristicType(characteristicType);
            this.setValue(value);
        }

        public CodeableConcept getCharacteristicType() {
            if (this.characteristicType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemCharacteristicComponent.characteristicType");
                }
                if (Configuration.doAutoCreate()) {
                    this.characteristicType = new CodeableConcept();
                }
            }
            return this.characteristicType;
        }

        public boolean hasCharacteristicType() {
            return this.characteristicType != null && !this.characteristicType.isEmpty();
        }

        public InventoryItemCharacteristicComponent setCharacteristicType(CodeableConcept value) {
            this.characteristicType = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public UrlType getValueUrlType() throws FHIRException {
            if (this.value == null) {
                this.value = new UrlType();
            }
            if (!(this.value instanceof UrlType)) {
                throw new FHIRException("Type mismatch: the type UrlType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UrlType)this.value;
        }

        public boolean hasValueUrlType() {
            return this != null && this.value instanceof UrlType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public Annotation getValueAnnotation() throws FHIRException {
            if (this.value == null) {
                this.value = new Annotation();
            }
            if (!(this.value instanceof Annotation)) {
                throw new FHIRException("Type mismatch: the type Annotation was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Annotation)this.value;
        }

        public boolean hasValueAnnotation() {
            return this != null && this.value instanceof Annotation;
        }

        public Address getValueAddress() throws FHIRException {
            if (this.value == null) {
                this.value = new Address();
            }
            if (!(this.value instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Address)this.value;
        }

        public boolean hasValueAddress() {
            return this != null && this.value instanceof Address;
        }

        public Duration getValueDuration() throws FHIRException {
            if (this.value == null) {
                this.value = new Duration();
            }
            if (!(this.value instanceof Duration)) {
                throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Duration)this.value;
        }

        public boolean hasValueDuration() {
            return this != null && this.value instanceof Duration;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public InventoryItemCharacteristicComponent setValue(DataType value) {
            if (!(value == null || value instanceof StringType || value instanceof IntegerType || value instanceof DecimalType || value instanceof BooleanType || value instanceof UrlType || value instanceof DateTimeType || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof Annotation || value instanceof Address || value instanceof Duration || value instanceof CodeableConcept)) {
                throw new FHIRException("Not the right type for InventoryItem.characteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("characteristicType", "CodeableConcept", "The type of characteristic that is being defined.", 0, 1, this.characteristicType));
            children.add(new Property("value[x]", "string|integer|decimal|boolean|url|dateTime|Quantity|Range|Ratio|Annotation|Address|Duration|CodeableConcept", "The value of the attribute.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1172127605: {
                    return new Property("characteristicType", "CodeableConcept", "The type of characteristic that is being defined.", 0, 1, this.characteristicType);
                }
                case -1410166417: {
                    return new Property("value[x]", "string|integer|decimal|boolean|url|dateTime|Quantity|Range|Ratio|Annotation|Address|Duration|CodeableConcept", "The value of the attribute.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "string|integer|decimal|boolean|url|dateTime|Quantity|Range|Ratio|Annotation|Address|Duration|CodeableConcept", "The value of the attribute.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of the attribute.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of the attribute.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of the attribute.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the attribute.", 0, 1, this.value);
                }
                case -1410172354: {
                    return new Property("value[x]", "url", "The value of the attribute.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the attribute.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The value of the attribute.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The value of the attribute.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "The value of the attribute.", 0, 1, this.value);
                }
                case -67108992: {
                    return new Property("value[x]", "Annotation", "The value of the attribute.", 0, 1, this.value);
                }
                case -478981821: {
                    return new Property("value[x]", "Address", "The value of the attribute.", 0, 1, this.value);
                }
                case 1558135333: {
                    return new Property("value[x]", "Duration", "The value of the attribute.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The value of the attribute.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1172127605: {
                    Base[] baseArray;
                    if (this.characteristicType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.characteristicType;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1172127605: {
                    this.characteristicType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("characteristicType")) {
                this.characteristicType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("characteristicType")) {
                this.characteristicType = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1172127605: {
                    return this.getCharacteristicType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1172127605: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"string", "integer", "decimal", "boolean", "url", "dateTime", "Quantity", "Range", "Ratio", "Annotation", "Address", "Duration", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("characteristicType")) {
                this.characteristicType = new CodeableConcept();
                return this.characteristicType;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueUrl")) {
                this.value = new UrlType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueDuration")) {
                this.value = new Duration();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public InventoryItemCharacteristicComponent copy() {
            InventoryItemCharacteristicComponent dst = new InventoryItemCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryItemCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.characteristicType = this.characteristicType == null ? null : this.characteristicType.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemCharacteristicComponent)) {
                return false;
            }
            InventoryItemCharacteristicComponent o = (InventoryItemCharacteristicComponent)other_;
            return InventoryItemCharacteristicComponent.compareDeep(this.characteristicType, o.characteristicType, true) && InventoryItemCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemCharacteristicComponent)) {
                return false;
            }
            InventoryItemCharacteristicComponent o = (InventoryItemCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.characteristicType, this.value});
        }

        @Override
        public String fhirType() {
            return "InventoryItem.characteristic";
        }
    }

    @Block
    public static class InventoryItemAssociationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="associationType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of association between the device and the other item", formalDefinition="This attribute defined the type of association when establishing associations or relations between items, e.g. 'packaged within' or 'used with' or 'to be mixed with.")
        protected CodeableConcept associationType;
        @Child(name="relatedItem", type={InventoryItem.class, Medication.class, MedicationKnowledge.class, Device.class, DeviceDefinition.class, NutritionProduct.class, BiologicallyDerivedProduct.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The related item or product", formalDefinition="The related item or product.")
        protected Reference relatedItem;
        @Child(name="quantity", type={Ratio.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of the product in this product", formalDefinition="The quantity of the related product in this product - Numerator is the quantity of the related product. Denominator is the quantity of the present product. For example a value of 20 means that this product contains 20 units of the related product; a value of 1:20 means the inverse - that the contained product contains 20 units of the present product.")
        protected Ratio quantity;
        private static final long serialVersionUID = -1001386921L;

        public InventoryItemAssociationComponent() {
        }

        public InventoryItemAssociationComponent(CodeableConcept associationType, Reference relatedItem, Ratio quantity) {
            this.setAssociationType(associationType);
            this.setRelatedItem(relatedItem);
            this.setQuantity(quantity);
        }

        public CodeableConcept getAssociationType() {
            if (this.associationType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemAssociationComponent.associationType");
                }
                if (Configuration.doAutoCreate()) {
                    this.associationType = new CodeableConcept();
                }
            }
            return this.associationType;
        }

        public boolean hasAssociationType() {
            return this.associationType != null && !this.associationType.isEmpty();
        }

        public InventoryItemAssociationComponent setAssociationType(CodeableConcept value) {
            this.associationType = value;
            return this;
        }

        public Reference getRelatedItem() {
            if (this.relatedItem == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemAssociationComponent.relatedItem");
                }
                if (Configuration.doAutoCreate()) {
                    this.relatedItem = new Reference();
                }
            }
            return this.relatedItem;
        }

        public boolean hasRelatedItem() {
            return this.relatedItem != null && !this.relatedItem.isEmpty();
        }

        public InventoryItemAssociationComponent setRelatedItem(Reference value) {
            this.relatedItem = value;
            return this;
        }

        public Ratio getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemAssociationComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Ratio();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public InventoryItemAssociationComponent setQuantity(Ratio value) {
            this.quantity = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("associationType", "CodeableConcept", "This attribute defined the type of association when establishing associations or relations between items, e.g. 'packaged within' or 'used with' or 'to be mixed with.", 0, 1, this.associationType));
            children.add(new Property("relatedItem", "Reference(InventoryItem|Medication|MedicationKnowledge|Device|DeviceDefinition|NutritionProduct|BiologicallyDerivedProduct)", "The related item or product.", 0, 1, this.relatedItem));
            children.add(new Property("quantity", "Ratio", "The quantity of the related product in this product - Numerator is the quantity of the related product. Denominator is the quantity of the present product. For example a value of 20 means that this product contains 20 units of the related product; a value of 1:20 means the inverse - that the contained product contains 20 units of the present product.", 0, 1, this.quantity));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2050799451: {
                    return new Property("associationType", "CodeableConcept", "This attribute defined the type of association when establishing associations or relations between items, e.g. 'packaged within' or 'used with' or 'to be mixed with.", 0, 1, this.associationType);
                }
                case 1112702430: {
                    return new Property("relatedItem", "Reference(InventoryItem|Medication|MedicationKnowledge|Device|DeviceDefinition|NutritionProduct|BiologicallyDerivedProduct)", "The related item or product.", 0, 1, this.relatedItem);
                }
                case -1285004149: {
                    return new Property("quantity", "Ratio", "The quantity of the related product in this product - Numerator is the quantity of the related product. Denominator is the quantity of the present product. For example a value of 20 means that this product contains 20 units of the related product; a value of 1:20 means the inverse - that the contained product contains 20 units of the present product.", 0, 1, this.quantity);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 2050799451: {
                    Base[] baseArray;
                    if (this.associationType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.associationType;
                    }
                    return baseArray;
                }
                case 1112702430: {
                    Base[] baseArray;
                    if (this.relatedItem == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relatedItem;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 2050799451: {
                    this.associationType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1112702430: {
                    this.relatedItem = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToRatio(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("associationType")) {
                this.associationType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("relatedItem")) {
                this.relatedItem = TypeConvertor.castToReference(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToRatio(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("associationType")) {
                this.associationType = null;
            } else if (name.equals("relatedItem")) {
                this.relatedItem = null;
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2050799451: {
                    return this.getAssociationType();
                }
                case 1112702430: {
                    return this.getRelatedItem();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2050799451: {
                    return new String[]{"CodeableConcept"};
                }
                case 1112702430: {
                    return new String[]{"Reference"};
                }
                case -1285004149: {
                    return new String[]{"Ratio"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("associationType")) {
                this.associationType = new CodeableConcept();
                return this.associationType;
            }
            if (name.equals("relatedItem")) {
                this.relatedItem = new Reference();
                return this.relatedItem;
            }
            if (name.equals("quantity")) {
                this.quantity = new Ratio();
                return this.quantity;
            }
            return super.addChild(name);
        }

        @Override
        public InventoryItemAssociationComponent copy() {
            InventoryItemAssociationComponent dst = new InventoryItemAssociationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryItemAssociationComponent dst) {
            super.copyValues(dst);
            dst.associationType = this.associationType == null ? null : this.associationType.copy();
            dst.relatedItem = this.relatedItem == null ? null : this.relatedItem.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemAssociationComponent)) {
                return false;
            }
            InventoryItemAssociationComponent o = (InventoryItemAssociationComponent)other_;
            return InventoryItemAssociationComponent.compareDeep(this.associationType, o.associationType, true) && InventoryItemAssociationComponent.compareDeep(this.relatedItem, o.relatedItem, true) && InventoryItemAssociationComponent.compareDeep(this.quantity, o.quantity, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemAssociationComponent)) {
                return false;
            }
            InventoryItemAssociationComponent o = (InventoryItemAssociationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.associationType, this.relatedItem, this.quantity});
        }

        @Override
        public String fhirType() {
            return "InventoryItem.association";
        }
    }

    @Block
    public static class InventoryItemDescriptionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The language that is used in the item description", formalDefinition="The language for the item description, when an item must be described in different languages and those languages may be authoritative and not translations of a 'main' language.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected Enumeration<Enumerations.CommonLanguages> language;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Textual description of the item", formalDefinition="Textual description of the item.")
        protected StringType description;
        private static final long serialVersionUID = -803271414L;

        public Enumeration<Enumerations.CommonLanguages> getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemDescriptionComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new Enumeration<Enumerations.CommonLanguages>(new Enumerations.CommonLanguagesEnumFactory());
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public InventoryItemDescriptionComponent setLanguageElement(Enumeration<Enumerations.CommonLanguages> value) {
            this.language = value;
            return this;
        }

        public Enumerations.CommonLanguages getLanguage() {
            return this.language == null ? null : (Enumerations.CommonLanguages)((Object)this.language.getValue());
        }

        public InventoryItemDescriptionComponent setLanguage(Enumerations.CommonLanguages value) {
            if (value == null) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new Enumeration<Enumerations.CommonLanguages>(new Enumerations.CommonLanguagesEnumFactory());
                }
                this.language.setValue((Object)value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemDescriptionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public InventoryItemDescriptionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public InventoryItemDescriptionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("language", InventoryItem.SP_CODE, "The language for the item description, when an item must be described in different languages and those languages may be authoritative and not translations of a 'main' language.", 0, 1, this.language));
            children.add(new Property("description", "string", "Textual description of the item.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1613589672: {
                    return new Property("language", InventoryItem.SP_CODE, "The language for the item description, when an item must be described in different languages and those languages may be authoritative and not translations of a 'main' language.", 0, 1, this.language);
                }
                case -1724546052: {
                    return new Property("description", "string", "Textual description of the item.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    value = new Enumerations.CommonLanguagesEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.language = value;
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                value = new Enumerations.CommonLanguagesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.language = value;
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                value = new Enumerations.CommonLanguagesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.language = value;
            } else if (name.equals("description")) {
                this.description = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{InventoryItem.SP_CODE};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property InventoryItem.description.language");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property InventoryItem.description.description");
            }
            return super.addChild(name);
        }

        @Override
        public InventoryItemDescriptionComponent copy() {
            InventoryItemDescriptionComponent dst = new InventoryItemDescriptionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryItemDescriptionComponent dst) {
            super.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemDescriptionComponent)) {
                return false;
            }
            InventoryItemDescriptionComponent o = (InventoryItemDescriptionComponent)other_;
            return InventoryItemDescriptionComponent.compareDeep(this.language, o.language, true) && InventoryItemDescriptionComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemDescriptionComponent)) {
                return false;
            }
            InventoryItemDescriptionComponent o = (InventoryItemDescriptionComponent)other_;
            return InventoryItemDescriptionComponent.compareValues(this.language, o.language, true) && InventoryItemDescriptionComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.language, this.description});
        }

        @Override
        public String fhirType() {
            return "InventoryItem.description";
        }
    }

    @Block
    public static class InventoryItemResponsibleOrganizationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The role of the organization e.g. manufacturer, distributor, or other", formalDefinition="The role of the organization e.g. manufacturer, distributor, etc.")
        protected CodeableConcept role;
        @Child(name="organization", type={Organization.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="An organization that is associated with the item", formalDefinition="An organization that has an association with the item, e.g. manufacturer, distributor, responsible, etc.")
        protected Reference organization;
        private static final long serialVersionUID = -575091539L;

        public InventoryItemResponsibleOrganizationComponent() {
        }

        public InventoryItemResponsibleOrganizationComponent(CodeableConcept role, Reference organization) {
            this.setRole(role);
            this.setOrganization(organization);
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemResponsibleOrganizationComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public InventoryItemResponsibleOrganizationComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getOrganization() {
            if (this.organization == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemResponsibleOrganizationComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organization = new Reference();
                }
            }
            return this.organization;
        }

        public boolean hasOrganization() {
            return this.organization != null && !this.organization.isEmpty();
        }

        public InventoryItemResponsibleOrganizationComponent setOrganization(Reference value) {
            this.organization = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "The role of the organization e.g. manufacturer, distributor, etc.", 0, 1, this.role));
            children.add(new Property("organization", "Reference(Organization)", "An organization that has an association with the item, e.g. manufacturer, distributor, responsible, etc.", 0, 1, this.organization));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role of the organization e.g. manufacturer, distributor, etc.", 0, 1, this.role);
                }
                case 1178922291: {
                    return new Property("organization", "Reference(Organization)", "An organization that has an association with the item, e.g. manufacturer, distributor, responsible, etc.", 0, 1, this.organization);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 1178922291: {
                    Base[] baseArray;
                    if (this.organization == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.organization;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1178922291: {
                    this.organization = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("organization")) {
                this.organization = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = null;
            } else if (name.equals("organization")) {
                this.organization = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case 1178922291: {
                    return this.getOrganization();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 1178922291: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("organization")) {
                this.organization = new Reference();
                return this.organization;
            }
            return super.addChild(name);
        }

        @Override
        public InventoryItemResponsibleOrganizationComponent copy() {
            InventoryItemResponsibleOrganizationComponent dst = new InventoryItemResponsibleOrganizationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryItemResponsibleOrganizationComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.organization = this.organization == null ? null : this.organization.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemResponsibleOrganizationComponent)) {
                return false;
            }
            InventoryItemResponsibleOrganizationComponent o = (InventoryItemResponsibleOrganizationComponent)other_;
            return InventoryItemResponsibleOrganizationComponent.compareDeep(this.role, o.role, true) && InventoryItemResponsibleOrganizationComponent.compareDeep(this.organization, o.organization, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemResponsibleOrganizationComponent)) {
                return false;
            }
            InventoryItemResponsibleOrganizationComponent o = (InventoryItemResponsibleOrganizationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.organization});
        }

        @Override
        public String fhirType() {
            return "InventoryItem.responsibleOrganization";
        }
    }

    @Block
    public static class InventoryItemNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="nameType", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of name e.g. 'brand-name', 'functional-name', 'common-name'", formalDefinition="The type of name e.g. 'brand-name', 'functional-name', 'common-name'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/inventoryitem-nametype")
        protected Coding nameType;
        @Child(name="language", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The language used to express the item name", formalDefinition="The language that the item name is expressed in.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected Enumeration<Enumerations.CommonLanguages> language;
        @Child(name="name", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The name or designation of the item", formalDefinition="The name or designation that the item is given.")
        protected StringType name;
        private static final long serialVersionUID = 2074178414L;

        public InventoryItemNameComponent() {
        }

        public InventoryItemNameComponent(Coding nameType, Enumerations.CommonLanguages language, String name) {
            this.setNameType(nameType);
            this.setLanguage(language);
            this.setName(name);
        }

        public Coding getNameType() {
            if (this.nameType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemNameComponent.nameType");
                }
                if (Configuration.doAutoCreate()) {
                    this.nameType = new Coding();
                }
            }
            return this.nameType;
        }

        public boolean hasNameType() {
            return this.nameType != null && !this.nameType.isEmpty();
        }

        public InventoryItemNameComponent setNameType(Coding value) {
            this.nameType = value;
            return this;
        }

        public Enumeration<Enumerations.CommonLanguages> getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemNameComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new Enumeration<Enumerations.CommonLanguages>(new Enumerations.CommonLanguagesEnumFactory());
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public InventoryItemNameComponent setLanguageElement(Enumeration<Enumerations.CommonLanguages> value) {
            this.language = value;
            return this;
        }

        public Enumerations.CommonLanguages getLanguage() {
            return this.language == null ? null : (Enumerations.CommonLanguages)((Object)this.language.getValue());
        }

        public InventoryItemNameComponent setLanguage(Enumerations.CommonLanguages value) {
            if (this.language == null) {
                this.language = new Enumeration<Enumerations.CommonLanguages>(new Enumerations.CommonLanguagesEnumFactory());
            }
            this.language.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryItemNameComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public InventoryItemNameComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public InventoryItemNameComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("nameType", "Coding", "The type of name e.g. 'brand-name', 'functional-name', 'common-name'.", 0, 1, this.nameType));
            children.add(new Property("language", InventoryItem.SP_CODE, "The language that the item name is expressed in.", 0, 1, this.language));
            children.add(new Property("name", "string", "The name or designation that the item is given.", 0, 1, this.name));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1840595045: {
                    return new Property("nameType", "Coding", "The type of name e.g. 'brand-name', 'functional-name', 'common-name'.", 0, 1, this.nameType);
                }
                case -1613589672: {
                    return new Property("language", InventoryItem.SP_CODE, "The language that the item name is expressed in.", 0, 1, this.language);
                }
                case 3373707: {
                    return new Property("name", "string", "The name or designation that the item is given.", 0, 1, this.name);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1840595045: {
                    Base[] baseArray;
                    if (this.nameType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.nameType;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.language;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1840595045: {
                    this.nameType = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -1613589672: {
                    value = new Enumerations.CommonLanguagesEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.language = value;
                    return value;
                }
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("nameType")) {
                this.nameType = TypeConvertor.castToCoding(value);
            } else if (name.equals("language")) {
                value = new Enumerations.CommonLanguagesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.language = value;
            } else if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("nameType")) {
                this.nameType = null;
            } else if (name.equals("language")) {
                value = new Enumerations.CommonLanguagesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.language = value;
            } else if (name.equals("name")) {
                this.name = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1840595045: {
                    return this.getNameType();
                }
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1840595045: {
                    return new String[]{"Coding"};
                }
                case -1613589672: {
                    return new String[]{InventoryItem.SP_CODE};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("nameType")) {
                this.nameType = new Coding();
                return this.nameType;
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a singleton property InventoryItem.name.language");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property InventoryItem.name.name");
            }
            return super.addChild(name);
        }

        @Override
        public InventoryItemNameComponent copy() {
            InventoryItemNameComponent dst = new InventoryItemNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryItemNameComponent dst) {
            super.copyValues(dst);
            dst.nameType = this.nameType == null ? null : this.nameType.copy();
            dst.language = this.language == null ? null : this.language.copy();
            dst.name = this.name == null ? null : this.name.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemNameComponent)) {
                return false;
            }
            InventoryItemNameComponent o = (InventoryItemNameComponent)other_;
            return InventoryItemNameComponent.compareDeep(this.nameType, o.nameType, true) && InventoryItemNameComponent.compareDeep(this.language, o.language, true) && InventoryItemNameComponent.compareDeep(this.name, o.name, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryItemNameComponent)) {
                return false;
            }
            InventoryItemNameComponent o = (InventoryItemNameComponent)other_;
            return InventoryItemNameComponent.compareValues(this.language, o.language, true) && InventoryItemNameComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.nameType, this.language, this.name});
        }

        @Override
        public String fhirType() {
            return "InventoryItem.name";
        }
    }

    public static class InventoryItemStatusCodesEnumFactory
    implements EnumFactory<InventoryItemStatusCodes> {
        @Override
        public InventoryItemStatusCodes fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return InventoryItemStatusCodes.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return InventoryItemStatusCodes.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return InventoryItemStatusCodes.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return InventoryItemStatusCodes.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown InventoryItemStatusCodes code '" + codeString + "'");
        }

        public Enumeration<InventoryItemStatusCodes> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InventoryItemStatusCodes>(this, InventoryItemStatusCodes.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<InventoryItemStatusCodes>(this, InventoryItemStatusCodes.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<InventoryItemStatusCodes>(this, InventoryItemStatusCodes.ACTIVE, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<InventoryItemStatusCodes>(this, InventoryItemStatusCodes.INACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<InventoryItemStatusCodes>(this, InventoryItemStatusCodes.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<InventoryItemStatusCodes>(this, InventoryItemStatusCodes.UNKNOWN, code);
            }
            throw new FHIRException("Unknown InventoryItemStatusCodes code '" + codeString + "'");
        }

        @Override
        public String toCode(InventoryItemStatusCodes code) {
            if (code == InventoryItemStatusCodes.ACTIVE) {
                return "active";
            }
            if (code == InventoryItemStatusCodes.INACTIVE) {
                return "inactive";
            }
            if (code == InventoryItemStatusCodes.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == InventoryItemStatusCodes.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(InventoryItemStatusCodes code) {
            return code.getSystem();
        }
    }

    public static enum InventoryItemStatusCodes {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static InventoryItemStatusCodes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InventoryItemStatusCodes code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/inventoryitem-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/inventoryitem-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/inventoryitem-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/inventoryitem-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The item is active and can be referenced.";
                }
                case INACTIVE: {
                    return "The item is presently inactive - there may be references to it but the item is not expected to be used.";
                }
                case ENTEREDINERROR: {
                    return "The item record was entered in error.";
                }
                case UNKNOWN: {
                    return "The item status has not been determined.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

