/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MonetaryComponent;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Invoice", profile="http://hl7.org/fhir/StructureDefinition/Invoice")
public class Invoice
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for item", formalDefinition="Identifier of this Invoice, often used for reference in correspondence about this invoice or for tracking of payments.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | issued | balanced | cancelled | entered-in-error", formalDefinition="The current state of the Invoice.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/invoice-status")
    protected Enumeration<InvoiceStatus> status;
    @Child(name="cancelledReason", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for cancellation of this Invoice", formalDefinition="In case of Invoice cancellation a reason must be given (entered in error, superseded by corrected invoice etc.).")
    protected StringType cancelledReason;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of Invoice", formalDefinition="Type of Invoice depending on domain, realm an usage (e.g. internal/external, dental, preliminary).")
    protected CodeableConcept type;
    @Child(name="subject", type={Patient.class, Group.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Recipient(s) of goods and services", formalDefinition="The individual or set of individuals receiving the goods and services billed in this invoice.")
    protected Reference subject;
    @Child(name="recipient", type={Organization.class, Patient.class, RelatedPerson.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Recipient of this invoice", formalDefinition="The individual or Organization responsible for balancing of this invoice.")
    protected Reference recipient;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="DEPRICATED", formalDefinition="Depricared by the element below.")
    protected DateTimeType date;
    @Child(name="creation", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When posted", formalDefinition="Date/time(s) of when this Invoice was posted.")
    protected DateTimeType creation;
    @Child(name="period", type={DateType.class, Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Billing date or period", formalDefinition="Date/time(s) range of services included in this invoice.")
    protected DataType period;
    @Child(name="participant", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Participant in creation of this Invoice", formalDefinition="Indicates who or what performed or participated in the charged service.")
    protected List<InvoiceParticipantComponent> participant;
    @Child(name="issuer", type={Organization.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Issuing Organization of Invoice", formalDefinition="The organizationissuing the Invoice.")
    protected Reference issuer;
    @Child(name="account", type={Account.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Account that is being balanced", formalDefinition="Account which is supposed to be balanced with this Invoice.")
    protected Reference account;
    @Child(name="lineItem", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Line items of this Invoice", formalDefinition="Each line item represents one charge for goods and services rendered. Details such.ofType(date), code and amount are found in the referenced ChargeItem resource.")
    protected List<InvoiceLineItemComponent> lineItem;
    @Child(name="totalPriceComponent", type={MonetaryComponent.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Components of Invoice total", formalDefinition="The total amount for the Invoice may be calculated as the sum of the line items with surcharges/deductions that apply in certain conditions.  The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the total price was calculated.")
    protected List<MonetaryComponent> totalPriceComponent;
    @Child(name="totalNet", type={Money.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Net total of this Invoice", formalDefinition="Invoice total , taxes excluded.")
    protected Money totalNet;
    @Child(name="totalGross", type={Money.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Gross total of this Invoice", formalDefinition="Invoice total, tax included.")
    protected Money totalGross;
    @Child(name="paymentTerms", type={MarkdownType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment details", formalDefinition="Payment details such as banking details, period of payment, deductibles, methods of payment.")
    protected MarkdownType paymentTerms;
    @Child(name="note", type={Annotation.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the invoice", formalDefinition="Comments made about the invoice by the issuer, subject, or other participants.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 6346282L;
    @SearchParamDefinition(name="account", path="Invoice.account", description="Account that is being balanced", type="reference", target={Account.class})
    public static final String SP_ACCOUNT = "account";
    public static final ReferenceClientParam ACCOUNT = new ReferenceClientParam("account");
    public static final Include INCLUDE_ACCOUNT = new Include("Invoice:account").toLocked();
    @SearchParamDefinition(name="issuer", path="Invoice.issuer", description="Issuing Organization of Invoice", type="reference", target={Organization.class})
    public static final String SP_ISSUER = "issuer";
    public static final ReferenceClientParam ISSUER = new ReferenceClientParam("issuer");
    public static final Include INCLUDE_ISSUER = new Include("Invoice:issuer").toLocked();
    @SearchParamDefinition(name="participant-role", path="Invoice.participant.role", description="Type of involvement in creation of this Invoice", type="token")
    public static final String SP_PARTICIPANT_ROLE = "participant-role";
    public static final TokenClientParam PARTICIPANT_ROLE = new TokenClientParam("participant-role");
    @SearchParamDefinition(name="participant", path="Invoice.participant.actor", description="Individual who was involved", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("Invoice:participant").toLocked();
    @SearchParamDefinition(name="recipient", path="Invoice.recipient", description="Recipient of this invoice", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Organization.class, Patient.class, RelatedPerson.class})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("Invoice:recipient").toLocked();
    @SearchParamDefinition(name="status", path="Invoice.status", description="draft | issued | balanced | cancelled | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Invoice.subject", description="Recipient(s) of goods and services", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Invoice:subject").toLocked();
    @SearchParamDefinition(name="totalgross", path="Invoice.totalGross", description="Gross total of this Invoice", type="quantity")
    public static final String SP_TOTALGROSS = "totalgross";
    public static final QuantityClientParam TOTALGROSS = new QuantityClientParam("totalgross");
    @SearchParamDefinition(name="totalnet", path="Invoice.totalNet", description="Net total of this Invoice", type="quantity")
    public static final String SP_TOTALNET = "totalnet";
    public static final QuantityClientParam TOTALNET = new QuantityClientParam("totalnet");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Invoice:patient").toLocked();
    @SearchParamDefinition(name="type", path="Account.type | AllergyIntolerance.type | Composition.type | Coverage.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type | Invoice.type | MedicationDispense.type | MolecularSequence.type | Specimen.type", description="Multiple Resources: \r\n\r\n* [Account](account.html): E.g. patient, expense, depreciation\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [Coverage](coverage.html): The kind of coverage (health plan, auto, Workers Compensation)\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n* [Invoice](invoice.html): Type of Invoice\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of a specific type\r\n* [MolecularSequence](molecularsequence.html): Amino Acid Sequence/ DNA Sequence / RNA Sequence\r\n* [Specimen](specimen.html): The specimen type\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Invoice() {
    }

    public Invoice(InvoiceStatus status) {
        this.setStatus(status);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Invoice setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Invoice addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<InvoiceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<InvoiceStatus>(new InvoiceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Invoice setStatusElement(Enumeration<InvoiceStatus> value) {
        this.status = value;
        return this;
    }

    public InvoiceStatus getStatus() {
        return this.status == null ? null : (InvoiceStatus)((Object)this.status.getValue());
    }

    public Invoice setStatus(InvoiceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<InvoiceStatus>(new InvoiceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public StringType getCancelledReasonElement() {
        if (this.cancelledReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.cancelledReason");
            }
            if (Configuration.doAutoCreate()) {
                this.cancelledReason = new StringType();
            }
        }
        return this.cancelledReason;
    }

    public boolean hasCancelledReasonElement() {
        return this.cancelledReason != null && !this.cancelledReason.isEmpty();
    }

    public boolean hasCancelledReason() {
        return this.cancelledReason != null && !this.cancelledReason.isEmpty();
    }

    public Invoice setCancelledReasonElement(StringType value) {
        this.cancelledReason = value;
        return this;
    }

    public String getCancelledReason() {
        return this.cancelledReason == null ? null : (String)this.cancelledReason.getValue();
    }

    public Invoice setCancelledReason(String value) {
        if (Utilities.noString((String)value)) {
            this.cancelledReason = null;
        } else {
            if (this.cancelledReason == null) {
                this.cancelledReason = new StringType();
            }
            this.cancelledReason.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Invoice setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Invoice setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getRecipient() {
        if (this.recipient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.recipient");
            }
            if (Configuration.doAutoCreate()) {
                this.recipient = new Reference();
            }
        }
        return this.recipient;
    }

    public boolean hasRecipient() {
        return this.recipient != null && !this.recipient.isEmpty();
    }

    public Invoice setRecipient(Reference value) {
        this.recipient = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Invoice setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Invoice setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public DateTimeType getCreationElement() {
        if (this.creation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.creation");
            }
            if (Configuration.doAutoCreate()) {
                this.creation = new DateTimeType();
            }
        }
        return this.creation;
    }

    public boolean hasCreationElement() {
        return this.creation != null && !this.creation.isEmpty();
    }

    public boolean hasCreation() {
        return this.creation != null && !this.creation.isEmpty();
    }

    public Invoice setCreationElement(DateTimeType value) {
        this.creation = value;
        return this;
    }

    public Date getCreation() {
        return this.creation == null ? null : (Date)this.creation.getValue();
    }

    public Invoice setCreation(Date value) {
        if (value == null) {
            this.creation = null;
        } else {
            if (this.creation == null) {
                this.creation = new DateTimeType();
            }
            this.creation.setValue(value);
        }
        return this;
    }

    public DataType getPeriod() {
        return this.period;
    }

    public DateType getPeriodDateType() throws FHIRException {
        if (this.period == null) {
            this.period = new DateType();
        }
        if (!(this.period instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.period.getClass().getName() + " was encountered");
        }
        return (DateType)this.period;
    }

    public boolean hasPeriodDateType() {
        return this != null && this.period instanceof DateType;
    }

    public Period getPeriodPeriod() throws FHIRException {
        if (this.period == null) {
            this.period = new Period();
        }
        if (!(this.period instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.period.getClass().getName() + " was encountered");
        }
        return (Period)this.period;
    }

    public boolean hasPeriodPeriod() {
        return this != null && this.period instanceof Period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Invoice setPeriod(DataType value) {
        if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
            throw new FHIRException("Not the right type for Invoice.period[x]: " + value.fhirType());
        }
        this.period = value;
        return this;
    }

    public List<InvoiceParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<InvoiceParticipantComponent>();
        }
        return this.participant;
    }

    public Invoice setParticipant(List<InvoiceParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (InvoiceParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InvoiceParticipantComponent addParticipant() {
        InvoiceParticipantComponent t = new InvoiceParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<InvoiceParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Invoice addParticipant(InvoiceParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<InvoiceParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public InvoiceParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public Reference getIssuer() {
        if (this.issuer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.issuer");
            }
            if (Configuration.doAutoCreate()) {
                this.issuer = new Reference();
            }
        }
        return this.issuer;
    }

    public boolean hasIssuer() {
        return this.issuer != null && !this.issuer.isEmpty();
    }

    public Invoice setIssuer(Reference value) {
        this.issuer = value;
        return this;
    }

    public Reference getAccount() {
        if (this.account == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.account");
            }
            if (Configuration.doAutoCreate()) {
                this.account = new Reference();
            }
        }
        return this.account;
    }

    public boolean hasAccount() {
        return this.account != null && !this.account.isEmpty();
    }

    public Invoice setAccount(Reference value) {
        this.account = value;
        return this;
    }

    public List<InvoiceLineItemComponent> getLineItem() {
        if (this.lineItem == null) {
            this.lineItem = new ArrayList<InvoiceLineItemComponent>();
        }
        return this.lineItem;
    }

    public Invoice setLineItem(List<InvoiceLineItemComponent> theLineItem) {
        this.lineItem = theLineItem;
        return this;
    }

    public boolean hasLineItem() {
        if (this.lineItem == null) {
            return false;
        }
        for (InvoiceLineItemComponent item : this.lineItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InvoiceLineItemComponent addLineItem() {
        InvoiceLineItemComponent t = new InvoiceLineItemComponent();
        if (this.lineItem == null) {
            this.lineItem = new ArrayList<InvoiceLineItemComponent>();
        }
        this.lineItem.add(t);
        return t;
    }

    public Invoice addLineItem(InvoiceLineItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.lineItem == null) {
            this.lineItem = new ArrayList<InvoiceLineItemComponent>();
        }
        this.lineItem.add(t);
        return this;
    }

    public InvoiceLineItemComponent getLineItemFirstRep() {
        if (this.getLineItem().isEmpty()) {
            this.addLineItem();
        }
        return this.getLineItem().get(0);
    }

    public List<MonetaryComponent> getTotalPriceComponent() {
        if (this.totalPriceComponent == null) {
            this.totalPriceComponent = new ArrayList<MonetaryComponent>();
        }
        return this.totalPriceComponent;
    }

    public Invoice setTotalPriceComponent(List<MonetaryComponent> theTotalPriceComponent) {
        this.totalPriceComponent = theTotalPriceComponent;
        return this;
    }

    public boolean hasTotalPriceComponent() {
        if (this.totalPriceComponent == null) {
            return false;
        }
        for (MonetaryComponent item : this.totalPriceComponent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MonetaryComponent addTotalPriceComponent() {
        MonetaryComponent t = new MonetaryComponent();
        if (this.totalPriceComponent == null) {
            this.totalPriceComponent = new ArrayList<MonetaryComponent>();
        }
        this.totalPriceComponent.add(t);
        return t;
    }

    public Invoice addTotalPriceComponent(MonetaryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.totalPriceComponent == null) {
            this.totalPriceComponent = new ArrayList<MonetaryComponent>();
        }
        this.totalPriceComponent.add(t);
        return this;
    }

    public MonetaryComponent getTotalPriceComponentFirstRep() {
        if (this.getTotalPriceComponent().isEmpty()) {
            this.addTotalPriceComponent();
        }
        return this.getTotalPriceComponent().get(0);
    }

    public Money getTotalNet() {
        if (this.totalNet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.totalNet");
            }
            if (Configuration.doAutoCreate()) {
                this.totalNet = new Money();
            }
        }
        return this.totalNet;
    }

    public boolean hasTotalNet() {
        return this.totalNet != null && !this.totalNet.isEmpty();
    }

    public Invoice setTotalNet(Money value) {
        this.totalNet = value;
        return this;
    }

    public Money getTotalGross() {
        if (this.totalGross == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.totalGross");
            }
            if (Configuration.doAutoCreate()) {
                this.totalGross = new Money();
            }
        }
        return this.totalGross;
    }

    public boolean hasTotalGross() {
        return this.totalGross != null && !this.totalGross.isEmpty();
    }

    public Invoice setTotalGross(Money value) {
        this.totalGross = value;
        return this;
    }

    public MarkdownType getPaymentTermsElement() {
        if (this.paymentTerms == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Invoice.paymentTerms");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentTerms = new MarkdownType();
            }
        }
        return this.paymentTerms;
    }

    public boolean hasPaymentTermsElement() {
        return this.paymentTerms != null && !this.paymentTerms.isEmpty();
    }

    public boolean hasPaymentTerms() {
        return this.paymentTerms != null && !this.paymentTerms.isEmpty();
    }

    public Invoice setPaymentTermsElement(MarkdownType value) {
        this.paymentTerms = value;
        return this;
    }

    public String getPaymentTerms() {
        return this.paymentTerms == null ? null : (String)this.paymentTerms.getValue();
    }

    public Invoice setPaymentTerms(String value) {
        if (Utilities.noString((String)value)) {
            this.paymentTerms = null;
        } else {
            if (this.paymentTerms == null) {
                this.paymentTerms = new MarkdownType();
            }
            this.paymentTerms.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Invoice setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Invoice addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier of this Invoice, often used for reference in correspondence about this invoice or for tracking of payments.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the Invoice.", 0, 1, this.status));
        children.add(new Property("cancelledReason", "string", "In case of Invoice cancellation a reason must be given (entered in error, superseded by corrected invoice etc.).", 0, 1, this.cancelledReason));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Type of Invoice depending on domain, realm an usage (e.g. internal/external, dental, preliminary).", 0, 1, this.type));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or set of individuals receiving the goods and services billed in this invoice.", 0, 1, this.subject));
        children.add(new Property(SP_RECIPIENT, "Reference(Organization|Patient|RelatedPerson)", "The individual or Organization responsible for balancing of this invoice.", 0, 1, this.recipient));
        children.add(new Property(SP_DATE, "dateTime", "Depricared by the element below.", 0, 1, this.date));
        children.add(new Property("creation", "dateTime", "Date/time(s) of when this Invoice was posted.", 0, 1, this.creation));
        children.add(new Property("period[x]", "date|Period", "Date/time(s) range of services included in this invoice.", 0, 1, this.period));
        children.add(new Property(SP_PARTICIPANT, "", "Indicates who or what performed or participated in the charged service.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property(SP_ISSUER, "Reference(Organization)", "The organizationissuing the Invoice.", 0, 1, this.issuer));
        children.add(new Property(SP_ACCOUNT, "Reference(Account)", "Account which is supposed to be balanced with this Invoice.", 0, 1, this.account));
        children.add(new Property("lineItem", "", "Each line item represents one charge for goods and services rendered. Details such.ofType(date), code and amount are found in the referenced ChargeItem resource.", 0, Integer.MAX_VALUE, this.lineItem));
        children.add(new Property("totalPriceComponent", "MonetaryComponent", "The total amount for the Invoice may be calculated as the sum of the line items with surcharges/deductions that apply in certain conditions.  The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the total price was calculated.", 0, Integer.MAX_VALUE, this.totalPriceComponent));
        children.add(new Property("totalNet", "Money", "Invoice total , taxes excluded.", 0, 1, this.totalNet));
        children.add(new Property("totalGross", "Money", "Invoice total, tax included.", 0, 1, this.totalGross));
        children.add(new Property("paymentTerms", "markdown", "Payment details such as banking details, period of payment, deductibles, methods of payment.", 0, 1, this.paymentTerms));
        children.add(new Property("note", "Annotation", "Comments made about the invoice by the issuer, subject, or other participants.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier of this Invoice, often used for reference in correspondence about this invoice or for tracking of payments.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the Invoice.", 0, 1, this.status);
            }
            case 1550362357: {
                return new Property("cancelledReason", "string", "In case of Invoice cancellation a reason must be given (entered in error, superseded by corrected invoice etc.).", 0, 1, this.cancelledReason);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Type of Invoice depending on domain, realm an usage (e.g. internal/external, dental, preliminary).", 0, 1, this.type);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The individual or set of individuals receiving the goods and services billed in this invoice.", 0, 1, this.subject);
            }
            case 820081177: {
                return new Property(SP_RECIPIENT, "Reference(Organization|Patient|RelatedPerson)", "The individual or Organization responsible for balancing of this invoice.", 0, 1, this.recipient);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "Depricared by the element below.", 0, 1, this.date);
            }
            case 1820421855: {
                return new Property("creation", "dateTime", "Date/time(s) of when this Invoice was posted.", 0, 1, this.creation);
            }
            case 566594335: {
                return new Property("period[x]", "date|Period", "Date/time(s) range of services included in this invoice.", 0, 1, this.period);
            }
            case -991726143: {
                return new Property("period[x]", "date|Period", "Date/time(s) range of services included in this invoice.", 0, 1, this.period);
            }
            case 383848719: {
                return new Property("period[x]", SP_DATE, "Date/time(s) range of services included in this invoice.", 0, 1, this.period);
            }
            case -141376798: {
                return new Property("period[x]", "Period", "Date/time(s) range of services included in this invoice.", 0, 1, this.period);
            }
            case 767422259: {
                return new Property(SP_PARTICIPANT, "", "Indicates who or what performed or participated in the charged service.", 0, Integer.MAX_VALUE, this.participant);
            }
            case -1179159879: {
                return new Property(SP_ISSUER, "Reference(Organization)", "The organizationissuing the Invoice.", 0, 1, this.issuer);
            }
            case -1177318867: {
                return new Property(SP_ACCOUNT, "Reference(Account)", "Account which is supposed to be balanced with this Invoice.", 0, 1, this.account);
            }
            case 1188332839: {
                return new Property("lineItem", "", "Each line item represents one charge for goods and services rendered. Details such.ofType(date), code and amount are found in the referenced ChargeItem resource.", 0, Integer.MAX_VALUE, this.lineItem);
            }
            case 1731497496: {
                return new Property("totalPriceComponent", "MonetaryComponent", "The total amount for the Invoice may be calculated as the sum of the line items with surcharges/deductions that apply in certain conditions.  The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the total price was calculated.", 0, Integer.MAX_VALUE, this.totalPriceComponent);
            }
            case -849911879: {
                return new Property("totalNet", "Money", "Invoice total , taxes excluded.", 0, 1, this.totalNet);
            }
            case -727607968: {
                return new Property("totalGross", "Money", "Invoice total, tax included.", 0, 1, this.totalGross);
            }
            case -507544799: {
                return new Property("paymentTerms", "markdown", "Payment details such as banking details, period of payment, deductibles, methods of payment.", 0, 1, this.paymentTerms);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments made about the invoice by the issuer, subject, or other participants.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1550362357: {
                Base[] baseArray;
                if (this.cancelledReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.cancelledReason;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 820081177: {
                Base[] baseArray;
                if (this.recipient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.recipient;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1820421855: {
                Base[] baseArray;
                if (this.creation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.creation;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.period;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -1179159879: {
                Base[] baseArray;
                if (this.issuer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.issuer;
                }
                return baseArray;
            }
            case -1177318867: {
                Base[] baseArray;
                if (this.account == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.account;
                }
                return baseArray;
            }
            case 1188332839: {
                return this.lineItem == null ? new Base[]{} : this.lineItem.toArray(new Base[this.lineItem.size()]);
            }
            case 1731497496: {
                return this.totalPriceComponent == null ? new Base[]{} : this.totalPriceComponent.toArray(new Base[this.totalPriceComponent.size()]);
            }
            case -849911879: {
                Base[] baseArray;
                if (this.totalNet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.totalNet;
                }
                return baseArray;
            }
            case -727607968: {
                Base[] baseArray;
                if (this.totalGross == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.totalGross;
                }
                return baseArray;
            }
            case -507544799: {
                Base[] baseArray;
                if (this.paymentTerms == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.paymentTerms;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new InvoiceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 1550362357: {
                this.cancelledReason = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 820081177: {
                this.recipient = TypeConvertor.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1820421855: {
                this.creation = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToType(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((InvoiceParticipantComponent)((Object)value));
                return value;
            }
            case -1179159879: {
                this.issuer = TypeConvertor.castToReference(value);
                return value;
            }
            case -1177318867: {
                this.account = TypeConvertor.castToReference(value);
                return value;
            }
            case 1188332839: {
                this.getLineItem().add((InvoiceLineItemComponent)((Object)value));
                return value;
            }
            case 1731497496: {
                this.getTotalPriceComponent().add(TypeConvertor.castToMonetaryComponent(value));
                return value;
            }
            case -849911879: {
                this.totalNet = TypeConvertor.castToMoney(value);
                return value;
            }
            case -727607968: {
                this.totalGross = TypeConvertor.castToMoney(value);
                return value;
            }
            case -507544799: {
                this.paymentTerms = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new InvoiceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("cancelledReason")) {
            this.cancelledReason = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.recipient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("creation")) {
            this.creation = TypeConvertor.castToDateTime(value);
        } else if (name.equals("period[x]")) {
            this.period = TypeConvertor.castToType(value);
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((InvoiceParticipantComponent)((Object)value));
        } else if (name.equals(SP_ISSUER)) {
            this.issuer = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ACCOUNT)) {
            this.account = TypeConvertor.castToReference(value);
        } else if (name.equals("lineItem")) {
            this.getLineItem().add((InvoiceLineItemComponent)((Object)value));
        } else if (name.equals("totalPriceComponent")) {
            this.getTotalPriceComponent().add(TypeConvertor.castToMonetaryComponent(value));
        } else if (name.equals("totalNet")) {
            this.totalNet = TypeConvertor.castToMoney(value);
        } else if (name.equals("totalGross")) {
            this.totalGross = TypeConvertor.castToMoney(value);
        } else if (name.equals("paymentTerms")) {
            this.paymentTerms = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new InvoiceStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("cancelledReason")) {
            this.cancelledReason = null;
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals(SP_RECIPIENT)) {
            this.recipient = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals("creation")) {
            this.creation = null;
        } else if (name.equals("period[x]")) {
            this.period = null;
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().remove((InvoiceParticipantComponent)((Object)value));
        } else if (name.equals(SP_ISSUER)) {
            this.issuer = null;
        } else if (name.equals(SP_ACCOUNT)) {
            this.account = null;
        } else if (name.equals("lineItem")) {
            this.getLineItem().remove((InvoiceLineItemComponent)((Object)value));
        } else if (name.equals("totalPriceComponent")) {
            this.getTotalPriceComponent().remove(value);
        } else if (name.equals("totalNet")) {
            this.totalNet = null;
        } else if (name.equals("totalGross")) {
            this.totalGross = null;
        } else if (name.equals("paymentTerms")) {
            this.paymentTerms = null;
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1550362357: {
                return this.getCancelledReasonElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 820081177: {
                return this.getRecipient();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1820421855: {
                return this.getCreationElement();
            }
            case 566594335: {
                return this.getPeriod();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -1179159879: {
                return this.getIssuer();
            }
            case -1177318867: {
                return this.getAccount();
            }
            case 1188332839: {
                return this.addLineItem();
            }
            case 1731497496: {
                return this.addTotalPriceComponent();
            }
            case -849911879: {
                return this.getTotalNet();
            }
            case -727607968: {
                return this.getTotalGross();
            }
            case -507544799: {
                return this.getPaymentTermsElement();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1550362357: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 820081177: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1820421855: {
                return new String[]{"dateTime"};
            }
            case -991726143: {
                return new String[]{SP_DATE, "Period"};
            }
            case 767422259: {
                return new String[0];
            }
            case -1179159879: {
                return new String[]{"Reference"};
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
            case 1188332839: {
                return new String[0];
            }
            case 1731497496: {
                return new String[]{"MonetaryComponent"};
            }
            case -849911879: {
                return new String[]{"Money"};
            }
            case -727607968: {
                return new String[]{"Money"};
            }
            case -507544799: {
                return new String[]{"markdown"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Invoice.status");
        }
        if (name.equals("cancelledReason")) {
            throw new FHIRException("Cannot call addChild on a singleton property Invoice.cancelledReason");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_RECIPIENT)) {
            this.recipient = new Reference();
            return this.recipient;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Invoice.date");
        }
        if (name.equals("creation")) {
            throw new FHIRException("Cannot call addChild on a singleton property Invoice.creation");
        }
        if (name.equals("periodDate")) {
            this.period = new DateType();
            return this.period;
        }
        if (name.equals("periodPeriod")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals(SP_ISSUER)) {
            this.issuer = new Reference();
            return this.issuer;
        }
        if (name.equals(SP_ACCOUNT)) {
            this.account = new Reference();
            return this.account;
        }
        if (name.equals("lineItem")) {
            return this.addLineItem();
        }
        if (name.equals("totalPriceComponent")) {
            return this.addTotalPriceComponent();
        }
        if (name.equals("totalNet")) {
            this.totalNet = new Money();
            return this.totalNet;
        }
        if (name.equals("totalGross")) {
            this.totalGross = new Money();
            return this.totalGross;
        }
        if (name.equals("paymentTerms")) {
            throw new FHIRException("Cannot call addChild on a singleton property Invoice.paymentTerms");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Invoice";
    }

    @Override
    public Invoice copy() {
        Invoice dst = new Invoice();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Invoice dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.cancelledReason = this.cancelledReason == null ? null : this.cancelledReason.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.recipient = this.recipient == null ? null : this.recipient.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.creation = this.creation == null ? null : this.creation.copy();
        DataType dataType = dst.period = this.period == null ? null : this.period.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<InvoiceParticipantComponent>();
            for (InvoiceParticipantComponent invoiceParticipantComponent : this.participant) {
                dst.participant.add(invoiceParticipantComponent.copy());
            }
        }
        dst.issuer = this.issuer == null ? null : this.issuer.copy();
        Reference reference = dst.account = this.account == null ? null : this.account.copy();
        if (this.lineItem != null) {
            dst.lineItem = new ArrayList<InvoiceLineItemComponent>();
            for (InvoiceLineItemComponent invoiceLineItemComponent : this.lineItem) {
                dst.lineItem.add(invoiceLineItemComponent.copy());
            }
        }
        if (this.totalPriceComponent != null) {
            dst.totalPriceComponent = new ArrayList<MonetaryComponent>();
            for (MonetaryComponent monetaryComponent : this.totalPriceComponent) {
                dst.totalPriceComponent.add(monetaryComponent.copy());
            }
        }
        dst.totalNet = this.totalNet == null ? null : this.totalNet.copy();
        dst.totalGross = this.totalGross == null ? null : this.totalGross.copy();
        MarkdownType markdownType = dst.paymentTerms = this.paymentTerms == null ? null : this.paymentTerms.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected Invoice typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Invoice)) {
            return false;
        }
        Invoice o = (Invoice)other_;
        return Invoice.compareDeep(this.identifier, o.identifier, true) && Invoice.compareDeep(this.status, o.status, true) && Invoice.compareDeep(this.cancelledReason, o.cancelledReason, true) && Invoice.compareDeep(this.type, o.type, true) && Invoice.compareDeep(this.subject, o.subject, true) && Invoice.compareDeep(this.recipient, o.recipient, true) && Invoice.compareDeep(this.date, o.date, true) && Invoice.compareDeep(this.creation, o.creation, true) && Invoice.compareDeep(this.period, o.period, true) && Invoice.compareDeep(this.participant, o.participant, true) && Invoice.compareDeep(this.issuer, o.issuer, true) && Invoice.compareDeep(this.account, o.account, true) && Invoice.compareDeep(this.lineItem, o.lineItem, true) && Invoice.compareDeep(this.totalPriceComponent, o.totalPriceComponent, true) && Invoice.compareDeep(this.totalNet, o.totalNet, true) && Invoice.compareDeep(this.totalGross, o.totalGross, true) && Invoice.compareDeep(this.paymentTerms, o.paymentTerms, true) && Invoice.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Invoice)) {
            return false;
        }
        Invoice o = (Invoice)other_;
        return Invoice.compareValues(this.status, o.status, true) && Invoice.compareValues(this.cancelledReason, o.cancelledReason, true) && Invoice.compareValues(this.date, o.date, true) && Invoice.compareValues(this.creation, o.creation, true) && Invoice.compareValues(this.paymentTerms, o.paymentTerms, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.cancelledReason, this.type, this.subject, this.recipient, this.date, this.creation, this.period, this.participant, this.issuer, this.account, this.lineItem, this.totalPriceComponent, this.totalNet, this.totalGross, this.paymentTerms, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Invoice;
    }

    @Block
    public static class InvoiceLineItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sequence number of line item", formalDefinition="Sequence in which the items appear on the invoice.")
        protected PositiveIntType sequence;
        @Child(name="serviced", type={DateType.class, Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service data or period", formalDefinition="Date/time(s) range when this service was delivered or completed.")
        protected DataType serviced;
        @Child(name="chargeItem", type={ChargeItem.class, CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to ChargeItem containing details of this line item or an inline billing code", formalDefinition="The ChargeItem contains information such as the billing code, date, amount etc. If no further details are required for the lineItem, inline billing codes can be added using the CodeableConcept data type instead of the Reference.")
        protected DataType chargeItem;
        @Child(name="priceComponent", type={MonetaryComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Components of total line item price", formalDefinition="The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice as to how the prices have been calculated.")
        protected List<MonetaryComponent> priceComponent;
        private static final long serialVersionUID = -9393053L;

        public InvoiceLineItemComponent() {
        }

        public InvoiceLineItemComponent(DataType chargeItem) {
            this.setChargeItem(chargeItem);
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceLineItemComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public InvoiceLineItemComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public InvoiceLineItemComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public DataType getServiced() {
            return this.serviced;
        }

        public DateType getServicedDateType() throws FHIRException {
            if (this.serviced == null) {
                this.serviced = new DateType();
            }
            if (!(this.serviced instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (DateType)this.serviced;
        }

        public boolean hasServicedDateType() {
            return this != null && this.serviced instanceof DateType;
        }

        public Period getServicedPeriod() throws FHIRException {
            if (this.serviced == null) {
                this.serviced = new Period();
            }
            if (!(this.serviced instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (Period)this.serviced;
        }

        public boolean hasServicedPeriod() {
            return this != null && this.serviced instanceof Period;
        }

        public boolean hasServiced() {
            return this.serviced != null && !this.serviced.isEmpty();
        }

        public InvoiceLineItemComponent setServiced(DataType value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new FHIRException("Not the right type for Invoice.lineItem.serviced[x]: " + value.fhirType());
            }
            this.serviced = value;
            return this;
        }

        public DataType getChargeItem() {
            return this.chargeItem;
        }

        public Reference getChargeItemReference() throws FHIRException {
            if (this.chargeItem == null) {
                this.chargeItem = new Reference();
            }
            if (!(this.chargeItem instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.chargeItem.getClass().getName() + " was encountered");
            }
            return (Reference)this.chargeItem;
        }

        public boolean hasChargeItemReference() {
            return this != null && this.chargeItem instanceof Reference;
        }

        public CodeableConcept getChargeItemCodeableConcept() throws FHIRException {
            if (this.chargeItem == null) {
                this.chargeItem = new CodeableConcept();
            }
            if (!(this.chargeItem instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.chargeItem.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.chargeItem;
        }

        public boolean hasChargeItemCodeableConcept() {
            return this != null && this.chargeItem instanceof CodeableConcept;
        }

        public boolean hasChargeItem() {
            return this.chargeItem != null && !this.chargeItem.isEmpty();
        }

        public InvoiceLineItemComponent setChargeItem(DataType value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new FHIRException("Not the right type for Invoice.lineItem.chargeItem[x]: " + value.fhirType());
            }
            this.chargeItem = value;
            return this;
        }

        public List<MonetaryComponent> getPriceComponent() {
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<MonetaryComponent>();
            }
            return this.priceComponent;
        }

        public InvoiceLineItemComponent setPriceComponent(List<MonetaryComponent> thePriceComponent) {
            this.priceComponent = thePriceComponent;
            return this;
        }

        public boolean hasPriceComponent() {
            if (this.priceComponent == null) {
                return false;
            }
            for (MonetaryComponent item : this.priceComponent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MonetaryComponent addPriceComponent() {
            MonetaryComponent t = new MonetaryComponent();
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<MonetaryComponent>();
            }
            this.priceComponent.add(t);
            return t;
        }

        public InvoiceLineItemComponent addPriceComponent(MonetaryComponent t) {
            if (t == null) {
                return this;
            }
            if (this.priceComponent == null) {
                this.priceComponent = new ArrayList<MonetaryComponent>();
            }
            this.priceComponent.add(t);
            return this;
        }

        public MonetaryComponent getPriceComponentFirstRep() {
            if (this.getPriceComponent().isEmpty()) {
                this.addPriceComponent();
            }
            return this.getPriceComponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "Sequence in which the items appear on the invoice.", 0, 1, this.sequence));
            children.add(new Property("serviced[x]", "date|Period", "Date/time(s) range when this service was delivered or completed.", 0, 1, this.serviced));
            children.add(new Property("chargeItem[x]", "Reference(ChargeItem)|CodeableConcept", "The ChargeItem contains information such as the billing code, date, amount etc. If no further details are required for the lineItem, inline billing codes can be added using the CodeableConcept data type instead of the Reference.", 0, 1, this.chargeItem));
            children.add(new Property("priceComponent", "MonetaryComponent", "The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice as to how the prices have been calculated.", 0, Integer.MAX_VALUE, this.priceComponent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "Sequence in which the items appear on the invoice.", 0, 1, this.sequence);
                }
                case -1927922223: {
                    return new Property("serviced[x]", "date|Period", "Date/time(s) range when this service was delivered or completed.", 0, 1, this.serviced);
                }
                case 1379209295: {
                    return new Property("serviced[x]", "date|Period", "Date/time(s) range when this service was delivered or completed.", 0, 1, this.serviced);
                }
                case 363246749: {
                    return new Property("serviced[x]", Invoice.SP_DATE, "Date/time(s) range when this service was delivered or completed.", 0, 1, this.serviced);
                }
                case 1534966512: {
                    return new Property("serviced[x]", "Period", "Date/time(s) range when this service was delivered or completed.", 0, 1, this.serviced);
                }
                case 351104825: {
                    return new Property("chargeItem[x]", "Reference(ChargeItem)|CodeableConcept", "The ChargeItem contains information such as the billing code, date, amount etc. If no further details are required for the lineItem, inline billing codes can be added using the CodeableConcept data type instead of the Reference.", 0, 1, this.chargeItem);
                }
                case 1417779175: {
                    return new Property("chargeItem[x]", "Reference(ChargeItem)|CodeableConcept", "The ChargeItem contains information such as the billing code, date, amount etc. If no further details are required for the lineItem, inline billing codes can be added using the CodeableConcept data type instead of the Reference.", 0, 1, this.chargeItem);
                }
                case 753580836: {
                    return new Property("chargeItem[x]", "Reference(ChargeItem)", "The ChargeItem contains information such as the billing code, date, amount etc. If no further details are required for the lineItem, inline billing codes can be added using the CodeableConcept data type instead of the Reference.", 0, 1, this.chargeItem);
                }
                case 1226532026: {
                    return new Property("chargeItem[x]", "CodeableConcept", "The ChargeItem contains information such as the billing code, date, amount etc. If no further details are required for the lineItem, inline billing codes can be added using the CodeableConcept data type instead of the Reference.", 0, 1, this.chargeItem);
                }
                case 1219095988: {
                    return new Property("priceComponent", "MonetaryComponent", "The price for a ChargeItem may be calculated as a base price with surcharges/deductions that apply in certain conditions. A ChargeItemDefinition resource that defines the prices, factors and conditions that apply to a billing code is currently under development. The priceComponent element can be used to offer transparency to the recipient of the Invoice as to how the prices have been calculated.", 0, Integer.MAX_VALUE, this.priceComponent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1379209295: {
                    Base[] baseArray;
                    if (this.serviced == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.serviced;
                    }
                    return baseArray;
                }
                case 1417779175: {
                    Base[] baseArray;
                    if (this.chargeItem == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.chargeItem;
                    }
                    return baseArray;
                }
                case 1219095988: {
                    return this.priceComponent == null ? new Base[]{} : this.priceComponent.toArray(new Base[this.priceComponent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 1379209295: {
                    this.serviced = TypeConvertor.castToType(value);
                    return value;
                }
                case 1417779175: {
                    this.chargeItem = TypeConvertor.castToType(value);
                    return value;
                }
                case 1219095988: {
                    this.getPriceComponent().add(TypeConvertor.castToMonetaryComponent(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("serviced[x]")) {
                this.serviced = TypeConvertor.castToType(value);
            } else if (name.equals("chargeItem[x]")) {
                this.chargeItem = TypeConvertor.castToType(value);
            } else if (name.equals("priceComponent")) {
                this.getPriceComponent().add(TypeConvertor.castToMonetaryComponent(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("serviced[x]")) {
                this.serviced = null;
            } else if (name.equals("chargeItem[x]")) {
                this.chargeItem = null;
            } else if (name.equals("priceComponent")) {
                this.getPriceComponent().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -1927922223: {
                    return this.getServiced();
                }
                case 1379209295: {
                    return this.getServiced();
                }
                case 351104825: {
                    return this.getChargeItem();
                }
                case 1417779175: {
                    return this.getChargeItem();
                }
                case 1219095988: {
                    return this.addPriceComponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1379209295: {
                    return new String[]{Invoice.SP_DATE, "Period"};
                }
                case 1417779175: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
                case 1219095988: {
                    return new String[]{"MonetaryComponent"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Invoice.lineItem.sequence");
            }
            if (name.equals("servicedDate")) {
                this.serviced = new DateType();
                return this.serviced;
            }
            if (name.equals("servicedPeriod")) {
                this.serviced = new Period();
                return this.serviced;
            }
            if (name.equals("chargeItemReference")) {
                this.chargeItem = new Reference();
                return this.chargeItem;
            }
            if (name.equals("chargeItemCodeableConcept")) {
                this.chargeItem = new CodeableConcept();
                return this.chargeItem;
            }
            if (name.equals("priceComponent")) {
                return this.addPriceComponent();
            }
            return super.addChild(name);
        }

        @Override
        public InvoiceLineItemComponent copy() {
            InvoiceLineItemComponent dst = new InvoiceLineItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InvoiceLineItemComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.serviced = this.serviced == null ? null : this.serviced.copy();
            DataType dataType = dst.chargeItem = this.chargeItem == null ? null : this.chargeItem.copy();
            if (this.priceComponent != null) {
                dst.priceComponent = new ArrayList<MonetaryComponent>();
                for (MonetaryComponent i : this.priceComponent) {
                    dst.priceComponent.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceLineItemComponent)) {
                return false;
            }
            InvoiceLineItemComponent o = (InvoiceLineItemComponent)other_;
            return InvoiceLineItemComponent.compareDeep(this.sequence, o.sequence, true) && InvoiceLineItemComponent.compareDeep(this.serviced, o.serviced, true) && InvoiceLineItemComponent.compareDeep(this.chargeItem, o.chargeItem, true) && InvoiceLineItemComponent.compareDeep(this.priceComponent, o.priceComponent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceLineItemComponent)) {
                return false;
            }
            InvoiceLineItemComponent o = (InvoiceLineItemComponent)other_;
            return InvoiceLineItemComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.serviced, this.chargeItem, this.priceComponent});
        }

        @Override
        public String fhirType() {
            return "Invoice.lineItem";
        }
    }

    @Block
    public static class InvoiceParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of involvement in creation of this Invoice", formalDefinition="Describes the type of involvement (e.g. transcriptionist, creator etc.). If the invoice has been created automatically, the Participant may be a billing engine or another kind of device.")
        protected CodeableConcept role;
        @Child(name="actor", type={Practitioner.class, Organization.class, Patient.class, PractitionerRole.class, Device.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual who was involved", formalDefinition="The device, practitioner, etc. who performed or participated in the service.")
        protected Reference actor;
        private static final long serialVersionUID = -1684441509L;

        public InvoiceParticipantComponent() {
        }

        public InvoiceParticipantComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public InvoiceParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InvoiceParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public InvoiceParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Describes the type of involvement (e.g. transcriptionist, creator etc.). If the invoice has been created automatically, the Participant may be a billing engine or another kind of device.", 0, 1, this.role));
            children.add(new Property("actor", "Reference(Practitioner|Organization|Patient|PractitionerRole|Device|RelatedPerson)", "The device, practitioner, etc. who performed or participated in the service.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Describes the type of involvement (e.g. transcriptionist, creator etc.). If the invoice has been created automatically, the Participant may be a billing engine or another kind of device.", 0, 1, this.role);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|Organization|Patient|PractitionerRole|Device|RelatedPerson)", "The device, practitioner, etc. who performed or participated in the service.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = null;
            } else if (name.equals("actor")) {
                this.actor = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public InvoiceParticipantComponent copy() {
            InvoiceParticipantComponent dst = new InvoiceParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InvoiceParticipantComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceParticipantComponent)) {
                return false;
            }
            InvoiceParticipantComponent o = (InvoiceParticipantComponent)other_;
            return InvoiceParticipantComponent.compareDeep(this.role, o.role, true) && InvoiceParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InvoiceParticipantComponent)) {
                return false;
            }
            InvoiceParticipantComponent o = (InvoiceParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.actor});
        }

        @Override
        public String fhirType() {
            return "Invoice.participant";
        }
    }

    public static class InvoiceStatusEnumFactory
    implements EnumFactory<InvoiceStatus> {
        @Override
        public InvoiceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return InvoiceStatus.DRAFT;
            }
            if ("issued".equals(codeString)) {
                return InvoiceStatus.ISSUED;
            }
            if ("balanced".equals(codeString)) {
                return InvoiceStatus.BALANCED;
            }
            if ("cancelled".equals(codeString)) {
                return InvoiceStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return InvoiceStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown InvoiceStatus code '" + codeString + "'");
        }

        public Enumeration<InvoiceStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.NULL, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.DRAFT, code);
            }
            if ("issued".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.ISSUED, code);
            }
            if ("balanced".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.BALANCED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.CANCELLED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<InvoiceStatus>(this, InvoiceStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown InvoiceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(InvoiceStatus code) {
            if (code == InvoiceStatus.DRAFT) {
                return "draft";
            }
            if (code == InvoiceStatus.ISSUED) {
                return "issued";
            }
            if (code == InvoiceStatus.BALANCED) {
                return "balanced";
            }
            if (code == InvoiceStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == InvoiceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(InvoiceStatus code) {
            return code.getSystem();
        }
    }

    public static enum InvoiceStatus {
        DRAFT,
        ISSUED,
        BALANCED,
        CANCELLED,
        ENTEREDINERROR,
        NULL;


        public static InvoiceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("issued".equals(codeString)) {
                return ISSUED;
            }
            if ("balanced".equals(codeString)) {
                return BALANCED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InvoiceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ISSUED: {
                    return "issued";
                }
                case BALANCED: {
                    return "balanced";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case ISSUED: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case BALANCED: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/invoice-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "the invoice has been prepared but not yet finalized.";
                }
                case ISSUED: {
                    return "the invoice has been finalized and sent to the recipient.";
                }
                case BALANCED: {
                    return "the invoice has been balaced / completely paid.";
                }
                case CANCELLED: {
                    return "the invoice was cancelled.";
                }
                case ENTEREDINERROR: {
                    return "the invoice was determined as entered in error before it was issued.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ISSUED: {
                    return "issued";
                }
                case BALANCED: {
                    return "balanced";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered in error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

