/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="SupplyDelivery", profile="http://hl7.org/fhir/StructureDefinition/SupplyDelivery")
public class SupplyDelivery
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External identifier", formalDefinition="Identifier for the supply delivery event that is used to identify it across multiple disparate systems.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={SupplyRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this event.")
    protected List<Reference> basedOn;
    @Child(name="partOf", type={SupplyDelivery.class, Contract.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced event", formalDefinition="A larger event of which this particular event is a component or step.")
    protected List<Reference> partOf;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | abandoned | entered-in-error", formalDefinition="A code specifying the state of the dispense event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplydelivery-status")
    protected Enumeration<SupplyDeliveryStatus> status;
    @Child(name="patient", type={Patient.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient for whom the item is supplied", formalDefinition="A link to a resource representing the person whom the delivered item is for.")
    protected Reference patient;
    @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Category of supply event", formalDefinition="Indicates the type of supply being provided.  Examples include: Medication, Device, Biologically Derived Product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplydelivery-supplyitemtype")
    protected CodeableConcept type;
    @Child(name="suppliedItem", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The item that is delivered or supplied", formalDefinition="The item that is being delivered or has been supplied.")
    protected List<SupplyDeliverySuppliedItemComponent> suppliedItem;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When event occurred", formalDefinition="The date or time(s) the activity occurred.")
    protected DataType occurrence;
    @Child(name="supplier", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The item supplier", formalDefinition="The individual or organization responsible for supplying the delivery.")
    protected Reference supplier;
    @Child(name="destination", type={Location.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the delivery was sent", formalDefinition="Identification of the facility/location where the delivery was shipped to.")
    protected Reference destination;
    @Child(name="receiver", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who received the delivery", formalDefinition="Identifies the individual or organization that received the delivery.")
    protected List<Reference> receiver;
    private static final long serialVersionUID = -734856482L;
    @SearchParamDefinition(name="receiver", path="SupplyDelivery.receiver", description="Who collected the Supply", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    public static final Include INCLUDE_RECEIVER = new Include("SupplyDelivery:receiver").toLocked();
    @SearchParamDefinition(name="status", path="SupplyDelivery.status", description="in-progress | completed | abandoned | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="supplier", path="SupplyDelivery.supplier", description="Dispenser", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_SUPPLIER = "supplier";
    public static final ReferenceClientParam SUPPLIER = new ReferenceClientParam("supplier");
    public static final Include INCLUDE_SUPPLIER = new Include("SupplyDelivery:supplier").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("SupplyDelivery:patient").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public SupplyDelivery setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public SupplyDelivery addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public SupplyDelivery setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public SupplyDelivery addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public SupplyDelivery setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public SupplyDelivery addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    public Enumeration<SupplyDeliveryStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SupplyDeliveryStatus>(new SupplyDeliveryStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SupplyDelivery setStatusElement(Enumeration<SupplyDeliveryStatus> value) {
        this.status = value;
        return this;
    }

    public SupplyDeliveryStatus getStatus() {
        return this.status == null ? null : (SupplyDeliveryStatus)((Object)this.status.getValue());
    }

    public SupplyDelivery setStatus(SupplyDeliveryStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SupplyDeliveryStatus>(new SupplyDeliveryStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public SupplyDelivery setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SupplyDelivery setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<SupplyDeliverySuppliedItemComponent> getSuppliedItem() {
        if (this.suppliedItem == null) {
            this.suppliedItem = new ArrayList<SupplyDeliverySuppliedItemComponent>();
        }
        return this.suppliedItem;
    }

    public SupplyDelivery setSuppliedItem(List<SupplyDeliverySuppliedItemComponent> theSuppliedItem) {
        this.suppliedItem = theSuppliedItem;
        return this;
    }

    public boolean hasSuppliedItem() {
        if (this.suppliedItem == null) {
            return false;
        }
        for (SupplyDeliverySuppliedItemComponent item : this.suppliedItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SupplyDeliverySuppliedItemComponent addSuppliedItem() {
        SupplyDeliverySuppliedItemComponent t = new SupplyDeliverySuppliedItemComponent();
        if (this.suppliedItem == null) {
            this.suppliedItem = new ArrayList<SupplyDeliverySuppliedItemComponent>();
        }
        this.suppliedItem.add(t);
        return t;
    }

    public SupplyDelivery addSuppliedItem(SupplyDeliverySuppliedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.suppliedItem == null) {
            this.suppliedItem = new ArrayList<SupplyDeliverySuppliedItemComponent>();
        }
        this.suppliedItem.add(t);
        return this;
    }

    public SupplyDeliverySuppliedItemComponent getSuppliedItemFirstRep() {
        if (this.getSuppliedItem().isEmpty()) {
            this.addSuppliedItem();
        }
        return this.getSuppliedItem().get(0);
    }

    public DataType getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Timing();
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public SupplyDelivery setOccurrence(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new FHIRException("Not the right type for SupplyDelivery.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public Reference getSupplier() {
        if (this.supplier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.supplier");
            }
            if (Configuration.doAutoCreate()) {
                this.supplier = new Reference();
            }
        }
        return this.supplier;
    }

    public boolean hasSupplier() {
        return this.supplier != null && !this.supplier.isEmpty();
    }

    public SupplyDelivery setSupplier(Reference value) {
        this.supplier = value;
        return this;
    }

    public Reference getDestination() {
        if (this.destination == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destination = new Reference();
            }
        }
        return this.destination;
    }

    public boolean hasDestination() {
        return this.destination != null && !this.destination.isEmpty();
    }

    public SupplyDelivery setDestination(Reference value) {
        this.destination = value;
        return this;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public SupplyDelivery setReceiver(List<Reference> theReceiver) {
        this.receiver = theReceiver;
        return this;
    }

    public boolean hasReceiver() {
        if (this.receiver == null) {
            return false;
        }
        for (Reference item : this.receiver) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReceiver() {
        Reference t = new Reference();
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return t;
    }

    public SupplyDelivery addReceiver(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return this;
    }

    public Reference getReceiverFirstRep() {
        if (this.getReceiver().isEmpty()) {
            this.addReceiver();
        }
        return this.getReceiver().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the supply delivery event that is used to identify it across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(SupplyRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(SupplyDelivery|Contract)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "A code specifying the state of the dispense event.", 0, 1, this.status));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person whom the delivered item is for.", 0, 1, this.patient));
        children.add(new Property("type", "CodeableConcept", "Indicates the type of supply being provided.  Examples include: Medication, Device, Biologically Derived Product.", 0, 1, this.type));
        children.add(new Property("suppliedItem", "", "The item that is being delivered or has been supplied.", 0, Integer.MAX_VALUE, this.suppliedItem));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence));
        children.add(new Property(SP_SUPPLIER, "Reference(Practitioner|PractitionerRole|Organization)", "The individual or organization responsible for supplying the delivery.", 0, 1, this.supplier));
        children.add(new Property("destination", "Reference(Location)", "Identification of the facility/location where the delivery was shipped to.", 0, 1, this.destination));
        children.add(new Property(SP_RECEIVER, "Reference(Practitioner|PractitionerRole|Organization)", "Identifies the individual or organization that received the delivery.", 0, Integer.MAX_VALUE, this.receiver));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the supply delivery event that is used to identify it across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(SupplyRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this event.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(SupplyDelivery|Contract)", "A larger event of which this particular event is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "A code specifying the state of the dispense event.", 0, 1, this.status);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person whom the delivered item is for.", 0, 1, this.patient);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Indicates the type of supply being provided.  Examples include: Medication, Device, Biologically Derived Product.", 0, 1, this.type);
            }
            case 1993333233: {
                return new Property("suppliedItem", "", "The item that is being delivered or has been supplied.", 0, Integer.MAX_VALUE, this.suppliedItem);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "Period", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "Timing", "The date or time(s) the activity occurred.", 0, 1, this.occurrence);
            }
            case -1663305268: {
                return new Property(SP_SUPPLIER, "Reference(Practitioner|PractitionerRole|Organization)", "The individual or organization responsible for supplying the delivery.", 0, 1, this.supplier);
            }
            case -1429847026: {
                return new Property("destination", "Reference(Location)", "Identification of the facility/location where the delivery was shipped to.", 0, 1, this.destination);
            }
            case -808719889: {
                return new Property(SP_RECEIVER, "Reference(Practitioner|PractitionerRole|Organization)", "Identifies the individual or organization that received the delivery.", 0, Integer.MAX_VALUE, this.receiver);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 1993333233: {
                return this.suppliedItem == null ? new Base[]{} : this.suppliedItem.toArray(new Base[this.suppliedItem.size()]);
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.occurrence;
                }
                return baseArray;
            }
            case -1663305268: {
                Base[] baseArray;
                if (this.supplier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.supplier;
                }
                return baseArray;
            }
            case -1429847026: {
                Base[] baseArray;
                if (this.destination == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.destination;
                }
                return baseArray;
            }
            case -808719889: {
                return this.receiver == null ? new Base[]{} : this.receiver.toArray(new Base[this.receiver.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new SupplyDeliveryStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1993333233: {
                this.getSuppliedItem().add((SupplyDeliverySuppliedItemComponent)((Object)value));
                return value;
            }
            case 1687874001: {
                this.occurrence = TypeConvertor.castToType(value);
                return value;
            }
            case -1663305268: {
                this.supplier = TypeConvertor.castToReference(value);
                return value;
            }
            case -1429847026: {
                this.destination = TypeConvertor.castToReference(value);
                return value;
            }
            case -808719889: {
                this.getReceiver().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new SupplyDeliveryStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("suppliedItem")) {
            this.getSuppliedItem().add((SupplyDeliverySuppliedItemComponent)((Object)value));
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = TypeConvertor.castToType(value);
        } else if (name.equals(SP_SUPPLIER)) {
            this.supplier = TypeConvertor.castToReference(value);
        } else if (name.equals("destination")) {
            this.destination = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_RECEIVER)) {
            this.getReceiver().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals("partOf")) {
            this.getPartOf().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new SupplyDeliveryStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals("type")) {
            this.type = null;
        } else if (name.equals("suppliedItem")) {
            this.getSuppliedItem().remove((SupplyDeliverySuppliedItemComponent)((Object)value));
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = null;
        } else if (name.equals(SP_SUPPLIER)) {
            this.supplier = null;
        } else if (name.equals("destination")) {
            this.destination = null;
        } else if (name.equals(SP_RECEIVER)) {
            this.getReceiver().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 3575610: {
                return this.getType();
            }
            case 1993333233: {
                return this.addSuppliedItem();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -1663305268: {
                return this.getSupplier();
            }
            case -1429847026: {
                return this.getDestination();
            }
            case -808719889: {
                return this.addReceiver();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 1993333233: {
                return new String[0];
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case -1663305268: {
                return new String[]{"Reference"};
            }
            case -1429847026: {
                return new String[]{"Reference"};
            }
            case -808719889: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property SupplyDelivery.status");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("suppliedItem")) {
            return this.addSuppliedItem();
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals(SP_SUPPLIER)) {
            this.supplier = new Reference();
            return this.supplier;
        }
        if (name.equals("destination")) {
            this.destination = new Reference();
            return this.destination;
        }
        if (name.equals(SP_RECEIVER)) {
            return this.addReceiver();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SupplyDelivery";
    }

    @Override
    public SupplyDelivery copy() {
        SupplyDelivery dst = new SupplyDelivery();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SupplyDelivery dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.suppliedItem != null) {
            dst.suppliedItem = new ArrayList<SupplyDeliverySuppliedItemComponent>();
            for (SupplyDeliverySuppliedItemComponent supplyDeliverySuppliedItemComponent : this.suppliedItem) {
                dst.suppliedItem.add(supplyDeliverySuppliedItemComponent.copy());
            }
        }
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.supplier = this.supplier == null ? null : this.supplier.copy();
        Reference reference = dst.destination = this.destination == null ? null : this.destination.copy();
        if (this.receiver != null) {
            dst.receiver = new ArrayList<Reference>();
            for (Reference reference2 : this.receiver) {
                dst.receiver.add(reference2.copy());
            }
        }
    }

    protected SupplyDelivery typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SupplyDelivery)) {
            return false;
        }
        SupplyDelivery o = (SupplyDelivery)other_;
        return SupplyDelivery.compareDeep(this.identifier, o.identifier, true) && SupplyDelivery.compareDeep(this.basedOn, o.basedOn, true) && SupplyDelivery.compareDeep(this.partOf, o.partOf, true) && SupplyDelivery.compareDeep(this.status, o.status, true) && SupplyDelivery.compareDeep(this.patient, o.patient, true) && SupplyDelivery.compareDeep(this.type, o.type, true) && SupplyDelivery.compareDeep(this.suppliedItem, o.suppliedItem, true) && SupplyDelivery.compareDeep(this.occurrence, o.occurrence, true) && SupplyDelivery.compareDeep(this.supplier, o.supplier, true) && SupplyDelivery.compareDeep(this.destination, o.destination, true) && SupplyDelivery.compareDeep(this.receiver, o.receiver, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SupplyDelivery)) {
            return false;
        }
        SupplyDelivery o = (SupplyDelivery)other_;
        return SupplyDelivery.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.partOf, this.status, this.patient, this.type, this.suppliedItem, this.occurrence, this.supplier, this.destination, this.receiver});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SupplyDelivery;
    }

    @Block
    public static class SupplyDeliverySuppliedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount supplied", formalDefinition="The amount of the item that has been supplied.  Unit of measure may be included.")
        protected Quantity quantity;
        @Child(name="item", type={CodeableConcept.class, Medication.class, Substance.class, Device.class, BiologicallyDerivedProduct.class, NutritionProduct.class, InventoryItem.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Medication, Substance, Device or Biologically Derived Product supplied", formalDefinition="Identifies the medication, substance, device or biologically derived product being supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplydelivery-supplyitemtype")
        protected DataType item;
        private static final long serialVersionUID = -615919419L;

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyDeliverySuppliedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SupplyDeliverySuppliedItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public DataType getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                this.item = new CodeableConcept();
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                this.item = new Reference();
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public SupplyDeliverySuppliedItemComponent setItem(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRException("Not the right type for SupplyDelivery.suppliedItem.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("quantity", "Quantity", "The amount of the item that has been supplied.  Unit of measure may be included.", 0, 1, this.quantity));
            children.add(new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device|BiologicallyDerivedProduct|NutritionProduct|InventoryItem)", "Identifies the medication, substance, device or biologically derived product being supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The amount of the item that has been supplied.  Unit of measure may be included.", 0, 1, this.quantity);
                }
                case 2116201613: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device|BiologicallyDerivedProduct|NutritionProduct|InventoryItem)", "Identifies the medication, substance, device or biologically derived product being supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device|BiologicallyDerivedProduct|NutritionProduct|InventoryItem)", "Identifies the medication, substance, device or biologically derived product being supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept", "Identifies the medication, substance, device or biologically derived product being supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "Reference(Medication|Substance|Device|BiologicallyDerivedProduct|NutritionProduct|InventoryItem)", "Identifies the medication, substance, device or biologically derived product being supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3242771: {
                    this.item = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("item[x]")) {
                this.item = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("item[x]")) {
                this.item = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return this.getQuantity();
                }
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 3242771: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public SupplyDeliverySuppliedItemComponent copy() {
            SupplyDeliverySuppliedItemComponent dst = new SupplyDeliverySuppliedItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SupplyDeliverySuppliedItemComponent dst) {
            super.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyDeliverySuppliedItemComponent)) {
                return false;
            }
            SupplyDeliverySuppliedItemComponent o = (SupplyDeliverySuppliedItemComponent)other_;
            return SupplyDeliverySuppliedItemComponent.compareDeep(this.quantity, o.quantity, true) && SupplyDeliverySuppliedItemComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyDeliverySuppliedItemComponent)) {
                return false;
            }
            SupplyDeliverySuppliedItemComponent o = (SupplyDeliverySuppliedItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.quantity, this.item});
        }

        @Override
        public String fhirType() {
            return "SupplyDelivery.suppliedItem";
        }
    }

    public static class SupplyDeliveryStatusEnumFactory
    implements EnumFactory<SupplyDeliveryStatus> {
        @Override
        public SupplyDeliveryStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return SupplyDeliveryStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return SupplyDeliveryStatus.COMPLETED;
            }
            if ("abandoned".equals(codeString)) {
                return SupplyDeliveryStatus.ABANDONED;
            }
            if ("entered-in-error".equals(codeString)) {
                return SupplyDeliveryStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        public Enumeration<SupplyDeliveryStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.NULL, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.INPROGRESS, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.COMPLETED, code);
            }
            if ("abandoned".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.ABANDONED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SupplyDeliveryStatus code) {
            if (code == SupplyDeliveryStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == SupplyDeliveryStatus.COMPLETED) {
                return "completed";
            }
            if (code == SupplyDeliveryStatus.ABANDONED) {
                return "abandoned";
            }
            if (code == SupplyDeliveryStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(SupplyDeliveryStatus code) {
            return code.getSystem();
        }
    }

    public static enum SupplyDeliveryStatus {
        INPROGRESS,
        COMPLETED,
        ABANDONED,
        ENTEREDINERROR,
        NULL;


        public static SupplyDeliveryStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("abandoned".equals(codeString)) {
                return ABANDONED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ABANDONED: {
                    return "abandoned";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case ABANDONED: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "Supply has been requested, but not delivered.";
                }
                case COMPLETED: {
                    return "Supply has been delivered (\"completed\").";
                }
                case ABANDONED: {
                    return "Delivery was not completed.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"abandoned\" rather than \"entered-in-error\".).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Delivered";
                }
                case ABANDONED: {
                    return "Abandoned";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

