/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.CodeResolver;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.IMarkdownProcessor;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlNodeList;

public class ObligationsRenderer {
    private static String STYLE_UNCHANGED = "opacity: 0.5;";
    private static String STYLE_REMOVED = STYLE_UNCHANGED + "text-decoration: line-through;";
    private List<ObligationDetail> obligations = new ArrayList<ObligationDetail>();
    private String corePath;
    private StructureDefinition profile;
    private String path;
    private RenderingContext context;
    private IMarkdownProcessor md;
    private CodeResolver cr;

    public ObligationsRenderer(String corePath, StructureDefinition profile, String path, RenderingContext context, IMarkdownProcessor md, CodeResolver cr) {
        this.corePath = corePath;
        this.profile = profile;
        this.path = path;
        this.context = context;
        this.md = md;
        this.cr = cr;
    }

    public void seeObligations(ElementDefinition element, String id) {
        this.seeObligations(element.getExtension(), null, false, id);
    }

    public void seeObligations(List<Extension> list) {
        this.seeObligations(list, null, false, "$all");
    }

    public void seeRootObligations(String eid, List<Extension> list) {
        this.seeRootObligations(eid, list, null, false, "$all");
    }

    public void seeObligations(List<Extension> list, List<Extension> compList, boolean compare, String id) {
        HashMap<String, ObligationDetail> compBindings = new HashMap<String, ObligationDetail>();
        if (compare && compList != null) {
            for (Extension ext : compList) {
                ObligationDetail abr = this.obligationDetail(ext);
                if (compBindings.containsKey(abr.getKey())) {
                    abr.incrementCount();
                }
                compBindings.put(abr.getKey(), abr);
            }
        }
        for (Extension ext : list) {
            ObligationDetail obd = this.obligationDetail(ext);
            if (!"$all".equals(id) && !obd.hasActor(id)) continue;
            if (compare && compList != null) {
                ObligationDetail match = null;
                do {
                    match = (ObligationDetail)compBindings.get(obd.getKey());
                    if (!obd.alreadyMatched()) continue;
                    obd.incrementCount();
                } while (match != null && obd.alreadyMatched());
                if (match != null) {
                    obd.setCompare(match);
                }
                this.obligations.add(obd);
                if (obd.compare == null) continue;
                compBindings.remove(obd.compare.getKey());
                continue;
            }
            this.obligations.add(obd);
        }
        for (ObligationDetail b : compBindings.values()) {
            b.removed = true;
            this.obligations.add(b);
        }
    }

    public void seeRootObligations(String eid, List<Extension> list, List<Extension> compList, boolean compare, String id) {
        HashMap<String, ObligationDetail> compBindings = new HashMap<String, ObligationDetail>();
        if (compare && compList != null) {
            for (Extension ext : compList) {
                if (!this.forElement(eid, ext)) continue;
                ObligationDetail abr = this.obligationDetail(ext);
                if (compBindings.containsKey(abr.getKey())) {
                    abr.incrementCount();
                }
                compBindings.put(abr.getKey(), abr);
            }
        }
        for (Extension ext : list) {
            if (!this.forElement(eid, ext)) continue;
            ObligationDetail obd = this.obligationDetail(ext);
            obd.elementIds.clear();
            if (!"$all".equals(id) && !obd.hasActor(id)) continue;
            if (compare && compList != null) {
                ObligationDetail match = null;
                do {
                    match = (ObligationDetail)compBindings.get(obd.getKey());
                    if (!obd.alreadyMatched()) continue;
                    obd.incrementCount();
                } while (match != null && obd.alreadyMatched());
                if (match != null) {
                    obd.setCompare(match);
                }
                this.obligations.add(obd);
                if (obd.compare == null) continue;
                compBindings.remove(obd.compare.getKey());
                continue;
            }
            this.obligations.add(obd);
        }
        for (ObligationDetail b : compBindings.values()) {
            b.removed = true;
            this.obligations.add(b);
        }
    }

    private boolean forElement(String eid, Extension ext) {
        for (Extension exid : ext.getExtensionsByUrl("elementId")) {
            if (!eid.equals(exid.getValue().primitiveValue())) continue;
            return true;
        }
        return false;
    }

    protected ObligationDetail obligationDetail(Extension ext) {
        ObligationDetail abr = new ObligationDetail(ext);
        return abr;
    }

    public String render(String defPath, String anchorPrefix, List<ElementDefinition> inScopeElements) throws IOException {
        if (this.obligations.isEmpty()) {
            return "";
        }
        XhtmlNode tbl = new XhtmlNode(NodeType.Element, "table");
        tbl.attribute("class", "grid");
        this.renderTable((List<XhtmlNode>)tbl.getChildNodes(), true, defPath, anchorPrefix, inScopeElements);
        return new XhtmlComposer(false).compose(tbl);
    }

    public void renderTable(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell c, List<ElementDefinition> inScopeElements) throws FHIRFormatError, DefinitionException, IOException {
        if (this.obligations.isEmpty()) {
            return;
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Piece piece = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "table").attr("class", "grid");
        c.getPieces().add(piece);
        this.renderTable((List<XhtmlNode>)piece.getChildren(), false, gen.getDefPath(), gen.getAnchorPrefix(), inScopeElements);
    }

    public void renderList(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell c) throws FHIRFormatError, DefinitionException, IOException {
        if (this.obligations.size() > 0) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null);
            c.addPiece(p);
            if (this.obligations.size() == 1) {
                this.renderObligationLI(p.getChildren(), this.obligations.get(0));
            } else {
                XhtmlNode ul = p.getChildren().ul();
                for (ObligationDetail ob : this.obligations) {
                    this.renderObligationLI(ul.li().getChildNodes(), ob);
                }
            }
        }
    }

    private void renderObligationLI(XhtmlNodeList children, ObligationDetail ob) throws IOException {
        this.renderCodes(children, ob.getCodeList());
        if (ob.hasFilter() || ob.hasUsage() || !ob.elementIds.isEmpty()) {
            children.tx(" (");
            boolean ffirst = !ob.hasFilter();
            boolean firstEid = true;
            for (String eid : ob.elementIds) {
                if (firstEid) {
                    children.span().i().tx("Elements: ");
                    firstEid = false;
                } else {
                    children.tx(", ");
                }
                String trimmedElement = eid.substring(eid.indexOf(".") + 1);
                children.tx(trimmedElement);
            }
            if (ob.hasFilter()) {
                children.span(null, ob.getFilterDesc()).code().tx(ob.getFilter());
            }
            for (UsageContext uc : ob.getUsage()) {
                if (ffirst) {
                    ffirst = false;
                } else {
                    children.tx(",");
                }
                if (!uc.getCode().is("http://terminology.hl7.org/CodeSystem/usage-context-type", "jurisdiction")) {
                    children.tx(this.displayForUsage(uc.getCode()));
                    children.tx("=");
                }
                CodeResolver.CodeResolution ccr = this.cr.resolveCode(uc.getValueCodeableConcept());
                children.ah(ccr.getLink(), ccr.getHint()).tx(ccr.getDisplay());
            }
            children.tx(")");
        }
    }

    public void renderTable(List<XhtmlNode> children, boolean fullDoco, String defPath, String anchorPrefix, List<ElementDefinition> inScopeElements) throws FHIRFormatError, DefinitionException, IOException {
        boolean doco = false;
        boolean usage = false;
        boolean actor = false;
        boolean filter = false;
        boolean elementId = false;
        for (ObligationDetail obligationDetail : this.obligations) {
            actor = actor || !obligationDetail.actors.isEmpty() || obligationDetail.compare != null && !obligationDetail.compare.actors.isEmpty();
            doco = doco || obligationDetail.getDoco(fullDoco) != null || obligationDetail.compare != null && obligationDetail.compare.getDoco(fullDoco) != null;
            usage = usage || !obligationDetail.usage.isEmpty() || obligationDetail.compare != null && !obligationDetail.compare.usage.isEmpty();
            filter = filter || obligationDetail.filter != null || obligationDetail.compare != null && obligationDetail.compare.filter != null;
            elementId = elementId || !obligationDetail.elementIds.isEmpty() || obligationDetail.compare != null && !obligationDetail.compare.elementIds.isEmpty();
        }
        ArrayList<String> inScopePaths = new ArrayList<String>();
        for (ElementDefinition e : inScopeElements) {
            inScopePaths.add(e.getPath());
        }
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "tr");
        children.add(xhtmlNode);
        xhtmlNode.td().style("font-size: 11px").b().tx(this.context.formatPhrase("GENERAL_OBLIG", new Object[0]));
        if (actor) {
            xhtmlNode.td().style("font-size: 11px").tx(this.context.formatPhrase("OBLIG_ACT", new Object[0]));
        }
        if (elementId) {
            xhtmlNode.td().style("font-size: 11px").tx(this.context.formatPhrase("OBLIG_ELE", new Object[0]));
        }
        if (usage) {
            xhtmlNode.td().style("font-size: 11px").tx(this.context.formatPhrase("GENERAL_USAGE", new Object[0]));
        }
        if (doco) {
            xhtmlNode.td().style("font-size: 11px").tx(this.context.formatPhrase("GENERAL_DOCUMENTATION", new Object[0]));
        }
        if (filter) {
            xhtmlNode.td().style("font-size: 11px").tx(this.context.formatPhrase("GENERAL_FILTER", new Object[0]));
        }
        for (ObligationDetail ob : this.obligations) {
            String oldD;
            XhtmlNode xhtmlNode2 = new XhtmlNode(NodeType.Element, "tr");
            if (ob.unchanged()) {
                xhtmlNode2.style(STYLE_REMOVED);
            } else if (ob.removed) {
                xhtmlNode2.style(STYLE_REMOVED);
            }
            children.add(xhtmlNode2);
            XhtmlNode code = xhtmlNode2.td().style("font-size: 11px");
            if (ob.compare != null && ob.getCodes().equals(ob.compare.getCodes())) {
                code.style("font-color: darkgray");
            }
            this.renderCodes(code.getChildNodes(), ob.getCodeList());
            if (ob.compare != null && !ob.compare.getCodeList().isEmpty() && !ob.getCodes().equals(ob.compare.getCodes())) {
                code.br();
                code = code.span(STYLE_UNCHANGED, null);
                this.renderCodes(code.getChildNodes(), ob.compare.getCodeList());
            }
            XhtmlNode actorId = xhtmlNode2.td().style("font-size: 11px");
            if (!ob.actors.isEmpty() || ob.compare.actors.isEmpty()) {
                boolean firstActor = false;
                for (CanonicalType anActor : ob.actors) {
                    boolean existingActor;
                    ActorDefinition ad = this.context.getContext().fetchResource(ActorDefinition.class, anActor.toString());
                    boolean bl = existingActor = ob.compare != null && ob.compare.actors.contains(anActor);
                    if (!firstActor) {
                        actorId.br();
                        firstActor = true;
                    }
                    if (existingActor) continue;
                    actorId.style(STYLE_UNCHANGED);
                }
                if (ob.compare != null) {
                    for (CanonicalType compActor : ob.compare.actors) {
                        if (ob.actors.contains(compActor)) continue;
                        ActorDefinition compAd = this.context.getContext().fetchResource(ActorDefinition.class, compActor.toString());
                        if (!firstActor) {
                            actorId.br();
                            firstActor = true;
                        }
                        actorId = actorId.span(STYLE_REMOVED, null);
                        if (compAd.hasWebPath()) {
                            actorId.ah(compAd.getWebPath(), compActor.toString()).tx(compAd.present());
                            continue;
                        }
                        actorId.span(null, compActor.toString()).tx(compAd.present());
                    }
                }
            }
            if (elementId) {
                XhtmlNode elementIds = xhtmlNode2.td().style("font-size: 11px");
                if (ob.compare != null && ob.elementIds.equals(ob.compare.elementIds)) {
                    elementIds.style(STYLE_UNCHANGED);
                }
                for (String eid : ob.elementIds) {
                    elementIds.sep(", ");
                    ElementDefinition ed = this.profile.getSnapshot().getElementById(eid);
                    boolean inScope = inScopePaths.contains(ed.getPath());
                    String name = eid.substring(eid.indexOf(".") + 1);
                    if (ed != null && inScope) {
                        String link = defPath + "#" + anchorPrefix + eid;
                        elementIds.ah(link).tx(name);
                        continue;
                    }
                    elementIds.code().tx(name);
                }
                if (ob.compare != null && !ob.compare.elementIds.isEmpty()) {
                    for (String eid : ob.compare.elementIds) {
                        if (ob.elementIds.contains(eid)) continue;
                        elementIds.sep(", ");
                        elementIds.span(STYLE_REMOVED, null).code().tx(eid);
                    }
                }
            }
            if (usage) {
                if (ob.usage != null) {
                    boolean first = true;
                    XhtmlNode td = xhtmlNode2.td();
                    for (UsageContext u : ob.usage) {
                        if (first) {
                            first = false;
                        } else {
                            td.tx(", ");
                        }
                        new DataRenderer(this.context).render(td, u);
                    }
                } else {
                    xhtmlNode2.td();
                }
            }
            if (doco) {
                if (ob.doco != null) {
                    String d;
                    String string = d = fullDoco ? this.md.processMarkdown("Obligation.documentation", ob.doco) : ob.docoShort;
                    oldD = ob.compare == null ? null : (fullDoco ? this.md.processMarkdown("Binding.description.compare", ob.compare.doco) : ob.compare.docoShort);
                    xhtmlNode2.td().style("font-size: 11px").innerHTML(this.compareHtml(d, oldD));
                } else {
                    xhtmlNode2.td().style("font-size: 11px");
                }
            }
            if (!filter) continue;
            if (ob.filter != null) {
                String d = "<code>" + ob.filter + "</code>" + (fullDoco ? this.md.processMarkdown("Binding.description", ob.filterDoco) : "");
                oldD = ob.compare == null ? null : "<code>" + ob.compare.filter + "</code>" + (fullDoco ? this.md.processMarkdown("Binding.description", ob.compare.filterDoco) : "");
                xhtmlNode2.td().style("font-size: 11px").innerHTML(this.compareHtml(d, oldD));
                continue;
            }
            xhtmlNode2.td().style("font-size: 11px");
        }
    }

    private XhtmlNode compareString(XhtmlNode node, String newS, String oldS) {
        if (oldS == null) {
            return node.tx(newS);
        }
        if (newS.equals(oldS)) {
            return node.style(STYLE_UNCHANGED).tx(newS);
        }
        node.tx(newS);
        node.br();
        return node.span(STYLE_REMOVED, null).tx(oldS);
    }

    private String compareHtml(String newS, String oldS) {
        if (oldS == null) {
            return newS;
        }
        if (newS.equals(oldS)) {
            return "<span style=\"" + STYLE_UNCHANGED + "\">" + newS + "</span>";
        }
        return newS + "<br/><span style=\"" + STYLE_REMOVED + "\">" + oldS + "</span>";
    }

    private void renderCodes(XhtmlNodeList children, List<String> codes) {
        if (!codes.isEmpty()) {
            boolean first = true;
            for (String code : codes) {
                if (first) {
                    first = false;
                } else {
                    children.tx(" & ");
                }
                int i = code.indexOf(":");
                if (i > -1) {
                    String c = code.substring(0, i);
                    code = code.substring(i + 1);
                    children.b().tx(c.toUpperCase());
                    children.tx(":");
                }
                CodeResolver.CodeResolution cr = this.cr.resolveCode("http://hl7.org/fhir/tools/CodeSystem/obligation", code);
                code = code.replace("will-", "").replace("can-", "");
                if (cr.getLink() != null) {
                    children.ah(cr.getLink(), cr.getHint()).tx(code);
                    continue;
                }
                children.span(null, cr.getHint()).tx(code);
            }
        } else {
            children.span(null, "No Obligation Code?").tx("??");
        }
    }

    public boolean hasObligations() {
        return !this.obligations.isEmpty();
    }

    private String displayForUsage(Coding c) {
        if (c.hasDisplay()) {
            return c.getDisplay();
        }
        if ("http://terminology.hl7.org/CodeSystem/usage-context-type".equals(c.getSystem())) {
            return c.getCode();
        }
        return c.getCode();
    }

    public static class ObligationDetail {
        private List<String> codes = new ArrayList<String>();
        private List<String> elementIds = new ArrayList<String>();
        private List<CanonicalType> actors = new ArrayList<CanonicalType>();
        private String doco;
        private String docoShort;
        private String filter;
        private String filterDoco;
        private List<UsageContext> usage = new ArrayList<UsageContext>();
        private boolean isUnchanged = false;
        private boolean matched = false;
        private boolean removed = false;
        private ValueSet vs;
        private ObligationDetail compare;
        private int count = 1;

        public ObligationDetail(Extension ext) {
            for (Extension e : ext.getExtensionsByUrl("code")) {
                this.codes.add(e.getValueStringType().toString());
            }
            for (Extension e : ext.getExtensionsByUrl("actor")) {
                this.actors.add(e.getValueCanonicalType());
            }
            this.doco = ext.getExtensionString("documentation");
            this.docoShort = ext.getExtensionString("shortDoco");
            this.filter = ext.getExtensionString("filter");
            this.filterDoco = ext.getExtensionString("filterDocumentation");
            if (this.filterDoco == null) {
                this.filterDoco = ext.getExtensionString("filter-desc");
            }
            for (Extension usage : ext.getExtensionsByUrl("usage")) {
                this.usage.add(usage.getValueUsageContext());
            }
            for (Extension eid : ext.getExtensionsByUrl("elementId")) {
                this.elementIds.add(eid.getValue().primitiveValue());
            }
            this.isUnchanged = ext.hasUserData("derivation.equals");
        }

        private String getKey() {
            return String.join((CharSequence)",", this.codes) + Integer.toString(this.count);
        }

        private void incrementCount() {
            ++this.count;
        }

        private void setCompare(ObligationDetail match) {
            this.compare = match;
            match.matched = true;
        }

        private boolean alreadyMatched() {
            return this.matched;
        }

        public String getDoco(boolean full) {
            return full ? this.doco : this.docoShort;
        }

        public String getCodes() {
            return String.join((CharSequence)",", this.codes);
        }

        public List<String> getCodeList() {
            return new ArrayList<String>(this.codes);
        }

        public boolean unchanged() {
            if (!this.isUnchanged) {
                return false;
            }
            if (this.compare == null) {
                return true;
            }
            this.isUnchanged = true;
            this.isUnchanged = this.isUnchanged && (this.codes.isEmpty() && this.compare.codes.isEmpty() || this.codes.equals(this.compare.codes));
            this.isUnchanged = this.elementIds.equals(this.compare.elementIds);
            this.isUnchanged = this.isUnchanged && (this.actors.isEmpty() && this.compare.actors.isEmpty() || this.actors.equals(this.compare.actors));
            this.isUnchanged = this.isUnchanged && (this.doco == null && this.compare.doco == null || this.doco.equals(this.compare.doco));
            this.isUnchanged = this.isUnchanged && (this.docoShort == null && this.compare.docoShort == null || this.docoShort.equals(this.compare.docoShort));
            this.isUnchanged = this.isUnchanged && (this.filter == null && this.compare.filter == null || this.filter.equals(this.compare.filter));
            this.isUnchanged = this.isUnchanged && (this.filterDoco == null && this.compare.filterDoco == null || this.filterDoco.equals(this.compare.filterDoco));
            this.isUnchanged = this.isUnchanged && (this.usage == null && this.compare.usage == null || this.usage.equals(this.compare.usage));
            return this.isUnchanged;
        }

        public boolean hasFilter() {
            return this.filter != null;
        }

        public boolean hasUsage() {
            return !this.usage.isEmpty();
        }

        public String getFilterDesc() {
            return this.filterDoco;
        }

        public String getFilter() {
            return this.filter;
        }

        public List<UsageContext> getUsage() {
            return this.usage;
        }

        public boolean hasActors() {
            return !this.actors.isEmpty();
        }

        public boolean hasActor(String id) {
            for (CanonicalType actor : this.actors) {
                if (!((String)actor.getValue()).equals(id)) continue;
                return true;
            }
            return false;
        }
    }
}

