/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ProvenanceRenderer
extends ResourceRenderer {
    public ProvenanceRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource prv) throws UnsupportedEncodingException, IOException {
        return this.render(x, (Provenance)prv);
    }

    public boolean render(XhtmlNode x, Provenance prv) throws UnsupportedEncodingException, IOException {
        XhtmlNode tr;
        boolean hasExtensions = false;
        if (!prv.getTarget().isEmpty()) {
            if (prv.getTarget().size() == 1) {
                XhtmlNode p = x.para();
                p.tx(this.context.formatPhrase("PROV_PROV", new Object[0]) + " ");
                this.renderReference(prv, p, prv.getTargetFirstRep());
            } else {
                x.para().tx(this.context.formatPhrase("PROV_PROVE", new Object[0]) + " ");
                XhtmlNode ul = x.ul();
                for (Reference ref : prv.getTarget()) {
                    this.renderReference(prv, ul.li(), ref);
                }
            }
        }
        x.para().tx(this.context.formatPhrase("GENERAL_SUMM", new Object[0]));
        XhtmlNode t = x.table("grid");
        if (prv.hasOccurred()) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("PROV_OCC", new Object[0]));
            if (prv.hasOccurredPeriod()) {
                this.renderPeriod(tr.td(), prv.getOccurredPeriod());
            } else {
                this.renderDateTime(tr.td(), prv.getOccurredDateTimeType());
            }
        }
        if (prv.hasRecorded()) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("PROV_REC", new Object[0]));
            tr.td().addText(this.displayDateTime(prv.getRecordedElement()));
        }
        if (prv.hasPolicy()) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("PROV_POL", new Object[0]));
            if (prv.getPolicy().size() == 1) {
                this.renderUri(tr.td(), prv.getPolicy().get(0));
            } else {
                XhtmlNode ul = tr.td().ul();
                for (UriType u : prv.getPolicy()) {
                    this.renderUri(ul.li(), u);
                }
            }
        }
        if (prv.hasLocation()) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_LOCATION", new Object[0]));
            this.renderReference(prv, tr.td(), prv.getLocation());
        }
        if (prv.hasActivity()) {
            tr = t.tr();
            tr.td().tx(this.context.formatPhrase("PROV_ACT", new Object[0]));
            this.renderCodeableConcept(tr.td(), prv.getActivity(), false);
        }
        boolean hasType = false;
        boolean hasRole = false;
        boolean hasOnBehalfOf = false;
        for (Provenance.ProvenanceAgentComponent a : prv.getAgent()) {
            hasType = hasType || a.hasType();
            hasRole = hasRole || a.hasRole();
            hasOnBehalfOf = hasOnBehalfOf || a.hasOnBehalfOf();
        }
        x.para().b().tx(this.context.formatPhrase("PROV_AGE", new Object[0]));
        t = x.table("grid");
        tr = t.tr();
        if (hasType) {
            tr.td().b().tx(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        }
        if (hasRole) {
            tr.td().b().tx(this.context.formatPhrase("PROV_ROLE", new Object[0]));
        }
        tr.td().b().tx(this.context.formatPhrase("PROV_WHO", new Object[0]));
        if (hasOnBehalfOf) {
            tr.td().b().tx(this.context.formatPhrase("PROV_BEHALF", new Object[0]));
        }
        for (Provenance.ProvenanceAgentComponent a : prv.getAgent()) {
            tr = t.tr();
            if (hasType) {
                if (a.hasType()) {
                    this.renderCodeableConcept(tr.td(), a.getType(), false);
                } else {
                    tr.td();
                }
            }
            if (hasRole) {
                if (a.hasRole()) {
                    if (a.getRole().size() == 1) {
                        this.renderCodeableConcept(tr.td(), a.getType(), false);
                    } else {
                        XhtmlNode ul = tr.td().ul();
                        for (CodeableConcept cc : a.getRole()) {
                            this.renderCodeableConcept(ul.li(), cc, false);
                        }
                    }
                } else {
                    tr.td();
                }
            }
            if (a.hasWho()) {
                this.renderReference(prv, tr.td(), a.getWho());
            } else {
                tr.td();
            }
            if (!hasOnBehalfOf) continue;
            if (a.hasOnBehalfOf()) {
                this.renderReference(prv, tr.td(), a.getOnBehalfOf());
                continue;
            }
            tr.td();
        }
        return hasExtensions;
    }

    @Override
    public String display(Resource dr) throws UnsupportedEncodingException, IOException {
        return this.display((Provenance)dr);
    }

    public String display(Provenance prv) throws UnsupportedEncodingException, IOException {
        return this.context.formatPhrase("PROV_FOR", new Object[]{this.displayReference(prv, prv.getTargetFirstRep())}) + " ";
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.context.formatPhrase("GENERAL_TODO", new Object[0]);
    }
}

