/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class QuestionnaireRenderer
extends TerminologyRenderer {
    public static final String EXT_QUESTIONNAIRE_ITEM_TYPE_ORIGINAL = "http://hl7.org/fhir/4.0/StructureDefinition/extension-Questionnaire.item.type";

    public QuestionnaireRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean render(XhtmlNode x, Resource q) throws UnsupportedEncodingException, IOException {
        return this.render(x, (Questionnaire)q);
    }

    public boolean render(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                return this.renderForm(x, q);
            }
            case LINKS: {
                return this.renderLinks(x, q);
            }
            case LOGIC: {
                return this.renderLogic(x, q);
            }
            case DEFNS: {
                return this.renderDefns(x, q);
            }
            case TREE: {
                return this.renderTree(x, q);
            }
        }
        throw new Error("Unknown Questionnaire Renderer Mode");
    }

    public boolean renderTree(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        boolean doOpts;
        boolean hasFlags = this.checkForFlags(q.getItem());
        boolean bl = doOpts = this.context.getDefinitionsTarget() == null && this.hasAnyOptions(q.getItem());
        if (doOpts) {
            x.b().tx(this.context.formatPhrase("QUEST_STRUCT", new Object[0]));
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator((RenderingI18nContext)this.context, this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER);
        model.setAlternating(true);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "help16.png"}));
        }
        model.setDocoRef(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.context.formatPhrase("QUEST_LINKID", new Object[0]), this.context.formatPhrase("QUEST_LINK", new Object[0]), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.context.formatPhrase("QUEST_TEXT", new Object[0]), this.context.formatPhrase("QUEST_TEXTFOR", new Object[0]), null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_CARDINALITY", new Object[0]), this.context.formatPhrase("QUEST_TIMES", new Object[0]), null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_TYPE", new Object[0]), this.context.formatPhrase("QUEST_TYPE_ITEM", new Object[0]), null, 0));
        if (hasFlags) {
            List list5 = model.getTitles();
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator6);
            list5.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator6, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_FLAGS", new Object[0]), this.context.formatPhrase("QUEST_ATTRIBUTES", new Object[0]), null, 0));
        }
        List list6 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator7);
        list6.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator7, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_DESC_CONST", new Object[0]), this.context.formatPhrase("QUEST_ADD_INFO", new Object[0]), null, 0));
        boolean hasExt = false;
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), q, hasFlags);
        for (Questionnaire.QuestionnaireItemComponent i : q.getItem()) {
            hasExt = this.renderTreeItem(gen, row.getSubRows(), q, i, hasFlags) || hasExt;
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        if (doOpts) {
            this.renderOptions(q, x);
        }
        return hasExt;
    }

    private void renderOptions(Questionnaire q, XhtmlNode x) {
        if (this.hasAnyOptions(q.getItem())) {
            x.hr();
            x.para().b().tx(this.context.formatPhrase("QUEST_OPT", new Object[0]));
            this.renderOptions(q.getItem(), x);
        }
    }

    private void renderOptions(List<Questionnaire.QuestionnaireItemComponent> items, XhtmlNode x) {
        for (Questionnaire.QuestionnaireItemComponent i : items) {
            this.renderItemOptions(x, i);
            this.renderOptions(i.getItem(), x);
        }
    }

    public void renderItemOptions(XhtmlNode x, Questionnaire.QuestionnaireItemComponent i) {
        if (i.hasAnswerOption()) {
            boolean useSelect = false;
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent opt : i.getAnswerOption()) {
                useSelect = useSelect || opt.getInitialSelected();
            }
            x.an("opt-item." + i.getLinkId());
            x.para().b().tx(this.context.formatPhrase("QUEST_ANSW", new Object[]{i.getLinkId()}) + " ");
            XhtmlNode ul = x.ul();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent opt : i.getAnswerOption()) {
                XhtmlNode li = ul.li();
                li.style("font-size: 11px");
                if (useSelect) {
                    if (opt.getInitialSelected()) {
                        li.img("icon-selected.png", "icon");
                    } else {
                        li.img("icon-not-selected.png", "icon");
                    }
                }
                if (opt.getValue().isPrimitive()) {
                    li.tx(opt.getValue().primitiveValue());
                    continue;
                }
                if (opt.getValue() instanceof Coding) {
                    String link;
                    Coding c = (Coding)opt.getValue();
                    String string = link = c.hasSystem() ? new ContextUtilities(this.context.getWorker()).getLinkForUrl(this.context.getLink(RenderingContext.KnownLinkType.SPEC), c.getSystem()) : null;
                    if (link == null) {
                        li.tx(c.getSystem() + "#" + c.getCode());
                    } else {
                        li.ah(link).tx(this.displaySystem(c.getSystem()));
                        li.tx(": " + c.getCode());
                    }
                    if (!c.hasDisplay()) continue;
                    li.tx(" (\"" + c.getDisplay() + "\")");
                    continue;
                }
                li.tx("??");
            }
        }
    }

    private boolean hasAnyOptions(List<Questionnaire.QuestionnaireItemComponent> items) {
        for (Questionnaire.QuestionnaireItemComponent i : items) {
            if (i.hasAnswerOption()) {
                return true;
            }
            if (!this.hasAnyOptions(i.getItem())) continue;
            return true;
        }
        return false;
    }

    private boolean checkForFlags(List<Questionnaire.QuestionnaireItemComponent> items) {
        for (Questionnaire.QuestionnaireItemComponent i : items) {
            if (!this.checkForFlags(i)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForFlags(Questionnaire.QuestionnaireItemComponent i) {
        if (i.getReadOnly()) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            return true;
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation")) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            return true;
        }
        return this.checkForFlags(i.getItem());
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, boolean hasFlags) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_q_root.gif", this.context.formatPhrase("QUEST_ROOT", new Object[0]));
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, q.getName(), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, q.getDescription(), null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "", null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, this.context.formatPhrase("QUEST_QUEST", new Object[0]), null, null));
        if (hasFlags) {
            List list5 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "", null, null));
        }
        List list6 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator6);
        list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, (String)(q.hasUrl() ? (q.hasVersion() ? q.getUrl() + "#" + q.getVersion() : q.getUrl()) : ""), null, null));
        return r;
    }

    private String getSpecLink(String path) {
        return Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), path});
    }

    private String getSDCLink(String url, String path) {
        StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, url);
        if (sd == null) {
            sd = this.context.getContext().fetchResource(StructureDefinition.class, path);
        }
        if (sd != null && sd.hasWebPath()) {
            return sd.getWebPath();
        }
        if (Utilities.isAbsoluteUrl((String)path)) {
            return path.replace("StructureDefinition/", "StructureDefinition-") + ".html";
        }
        return Utilities.pathURL((String[])new String[]{"http://hl7.org/fhir/uv/sdc", path});
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, Questionnaire.QuestionnaireItemComponent i, boolean hasFlags) throws IOException {
        HierarchicalTableGenerator.Piece p;
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        r.setIcon("icon-q-" + i.getType().toCode().toLowerCase() + ".png", i.getType().getDisplay());
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell c1 = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, (String)(this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i.getLinkId()), i.getLinkId(), null, null);
        c1.setId("item." + i.getLinkId());
        r.getCells().add(c1);
        String txt = (String)(i.hasPrefix() ? i.getPrefix() + ". " : "") + i.getText();
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, txt, null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, (i.getRequired() ? "1" : "0") + ".." + (i.getRepeats() ? "*" : "1"), null, null));
        if (i.getTypeElement().hasExtension(EXT_QUESTIONNAIRE_ITEM_TYPE_ORIGINAL)) {
            String t = i.getTypeElement().getExtensionString(EXT_QUESTIONNAIRE_ITEM_TYPE_ORIGINAL);
            List list3 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "codesystem-item-type.html#item-type-" + t, t, null, null));
        } else {
            List list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "codesystem-item-type.html#item-type-" + i.getType().toCode(), i.getType().toCode(), null, null));
        }
        if (hasFlags) {
            HierarchicalTableGenerator.Cell flags = new HierarchicalTableGenerator.Cell(gen);
            r.getCells().add(flags);
            if (i.getReadOnly()) {
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "questionnaire-definitions.html#Questionnaire.item.readOnly"}), null, this.context.formatPhrase("QUEST_READONLY", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-readonly.png"))));
            }
            if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator7);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", "StructureDefinition-sdc-questionnaire-isSubject.html"), null, this.context.formatPhrase("QUEST_SUBJECT", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-subject.png"))));
            }
            if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, this.getSpecLink("extension-questionnaire-hidden.html"), null, this.context.formatPhrase("QUEST_HIDDEN", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-hidden.png"))));
            }
            if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", "StructureDefinition-sdc-questionnaire-optionalDisplay.html"), null, this.context.formatPhrase("QUEST_DISPLAY", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-optional.png"))));
            }
            if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
                HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator10);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod", "StructureDefinition-sdc-questionnaire-observationLinkPeriod.html"), null, this.context.formatPhrase("QUEST_LINKED", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-observation.png"))));
            }
            if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation")) {
                String code = ToolingExtensions.readStringExtension((Element)i, "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation");
                HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator11);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, this.getSpecLink("extension-questionnaire-choiceorientation.html"), null, this.context.formatPhrase("QUEST_ORIENTATION", new Object[]{code}) + " ").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-" + code + ".png"))));
            }
            if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
                CodeableConcept cc = i.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValueCodeableConcept();
                String string = cc.getCode("http://hl7.org/fhir/questionnaire-display-category");
                HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator12);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, "https://hl7.org/fhir/R4/extension-questionnaire-displayCategory.html", null, this.context.formatPhrase("QUEST_CAT", new Object[]{string}) + " ").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-" + string + ".png"))));
            }
        }
        HierarchicalTableGenerator.Cell defn = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(defn);
        if (i.hasMaxLength()) {
            List list5 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator13);
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, this.context.formatPhrase("GENERAL_MAX_LENGTH", new Object[0]) + " ", null));
            List list6 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator14);
            list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, Integer.toString(i.getMaxLength()), null));
        }
        if (i.hasDefinition()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator15);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "br"));
            }
            List list7 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator16);
            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, this.context.formatPhrase("GENERAL_DEFINITION_COLON", new Object[0]) + " ", null));
            this.genDefinitionLink(gen, i, defn, q);
        }
        if (i.hasEnableWhen()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator17);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, "br"));
            }
            HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator18);
            p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, null, this.context.formatPhrase("QUEST_ENABLE", new Object[0]) + " ", null);
            defn.getPieces().add(p);
            if (i.getEnableWhen().size() == 1) {
                XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "span");
                p.getChildren().add(xhtmlNode);
                this.renderEnableWhen(xhtmlNode, i.getEnableWhenFirstRep());
            } else {
                XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "ul");
                p.getChildren().add(xhtmlNode);
                for (Questionnaire.QuestionnaireItemEnableWhenComponent qi : i.getEnableWhen()) {
                    this.renderEnableWhen(xhtmlNode.li(), qi);
                }
            }
        }
        if (i.hasAnswerValueSet()) {
            Object vs;
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator19);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, "br"));
            }
            List list8 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator20);
            list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, this.context.formatPhrase("QUEST_VALUE", new Object[0]) + " ", null));
            if (!Utilities.noString((String)i.getAnswerValueSet()) && i.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i.getAnswerValueSet().substring(1));
                if (vs == null) {
                    List list9 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator21);
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, i.getAnswerValueSet(), null));
                } else {
                    List list10 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, ((Resource)vs).getWebPath(), ((CanonicalResource)vs).present(), null));
                }
            } else {
                vs = this.context.getWorker().findTxResource(ValueSet.class, i.getAnswerValueSet(), q);
                if (vs == null || !((Resource)vs).hasWebPath()) {
                    List list11 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator23);
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, null, i.getAnswerValueSet(), null));
                } else {
                    List list12 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator24);
                    list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, ((Resource)vs).getWebPath(), ((CanonicalResource)vs).present(), null));
                }
            }
        }
        if (i.hasAnswerOption()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator25);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, "br"));
            }
            List list13 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator26);
            list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, null, this.context.formatPhrase("QUEST_OPTIONS", new Object[0]) + " ", null));
            if (this.context.getDefinitionsTarget() == null) {
                List list14 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator27 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator27);
                list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator27, "#opt-item." + i.getLinkId(), Integer.toString(i.getAnswerOption().size()) + " " + Utilities.pluralize((String)"option", (int)i.getAnswerOption().size()), null));
            } else {
                List list15 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator28 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator28);
                list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator28, this.context.getDefinitionsTarget() + "#item." + i.getLinkId(), Integer.toString(i.getAnswerOption().size()) + " " + Utilities.pluralize((String)"option", (int)i.getAnswerOption().size()), null));
            }
        }
        if (i.hasInitial()) {
            for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : i.getInitial()) {
                if (!defn.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator29 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator29);
                    defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator29, "br"));
                }
                List list16 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator30 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator30);
                list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator30, null, this.context.formatPhrase("QUEST_INITIAL", new Object[0]) + " ", null));
                List list17 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator31 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator31);
                list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator31, null, questionnaireItemInitialComponent.getValue().fhirType(), null));
                List list18 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator32 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator32);
                list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator32, null, " = ", null));
                if (questionnaireItemInitialComponent.getValue().isPrimitive()) {
                    List list19 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator33 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator33);
                    list19.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator33, null, questionnaireItemInitialComponent.getValue().primitiveValue(), null));
                    continue;
                }
                if (questionnaireItemInitialComponent.hasValueCoding()) {
                    this.renderCoding(gen, defn.getPieces(), questionnaireItemInitialComponent.getValueCoding());
                    continue;
                }
                if (questionnaireItemInitialComponent.hasValueQuantity()) {
                    this.renderQuantity(gen, defn.getPieces(), questionnaireItemInitialComponent.getValueQuantity(), false);
                    continue;
                }
                if (questionnaireItemInitialComponent.hasValueReference()) {
                    this.renderReference(q, gen, defn.getPieces(), questionnaireItemInitialComponent.getValueReference(), true);
                    continue;
                }
                if (!questionnaireItemInitialComponent.hasValueAttachment()) continue;
            }
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator34 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator34);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator34, "br"));
            }
            List list20 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator35 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator35);
            list20.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator35, null, this.context.formatPhrase("QUEST_EXP", new Object[0]) + " ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator36 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator36);
            p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator36, "ul");
            defn.getPieces().add(p);
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_INT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_CONT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_ITEM_CONT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_EN", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_CALC", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_CAND", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression");
            }
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : i.getItem()) {
            hasExt = this.renderTreeItem(gen, r.getSubRows(), q, questionnaireItemComponent, hasFlags) || hasExt;
        }
        return hasExt;
    }

    public void genDefinitionLink(HierarchicalTableGenerator gen, Questionnaire.QuestionnaireItemComponent i, HierarchicalTableGenerator.Cell defn, Questionnaire q) {
        StructureDefinition sd;
        String path = null;
        String d = i.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d, q)) != null) {
            String url = sd.getWebPath();
            if (url != null) {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url + "#" + path, path, null));
            } else {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.getDefinition(), null));
            }
        } else {
            List list = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.getDefinition(), null));
        }
    }

    public void genDefinitionLink(XhtmlNode x, Questionnaire.QuestionnaireItemComponent i, Questionnaire q) {
        StructureDefinition sd;
        String path = null;
        String d = i.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d, q)) != null) {
            String url = sd.getWebPath();
            if (url != null) {
                x.ah(url + "#" + path).tx(path);
            } else {
                x.tx(i.getDefinition());
            }
        } else {
            x.tx(i.getDefinition());
        }
    }

    private void addExpression(HierarchicalTableGenerator.Piece p, Expression exp, String label, String url) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "li").style("font-size: 11px");
        p.addHtml(x);
        CanonicalResource cr = (CanonicalResource)this.context.getContext().fetchResource(Resource.class, url);
        if (cr != null && cr.hasWebPath()) {
            x.ah(cr.getWebPath()).tx(label);
        } else {
            x.ah(url).tx(label);
        }
        x.tx(": ");
        x.code(exp.getExpression());
    }

    private boolean renderLogic(XhtmlNode x, Questionnaire q) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator((RenderingI18nContext)this.context, this.context.getDestDir(), this.context.isInlineGraphics(), true);
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), true);
        model.setAlternating(true);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "help16.png"}));
        }
        model.setDocoRef(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.context.formatPhrase("QUEST_LINKID", new Object[0]), this.context.formatPhrase("QUEST_LINK", new Object[0]), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_DESC_CONST", new Object[0]), this.context.formatPhrase("QUEST_ADD_INFO", new Object[0]), null, 0));
        boolean hasExt = false;
        if (!q.hasItem()) {
            gen.emptyRow(model, 2);
        } else {
            for (Questionnaire.QuestionnaireItemComponent i : q.getItem()) {
                hasExt = this.renderLogicItem(gen, model.getRows(), q, i) || hasExt;
            }
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.getChildNodes().add(xn);
        return hasExt;
    }

    private boolean renderLogicItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, Questionnaire q, Questionnaire.QuestionnaireItemComponent i) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        r.setIcon("icon-q-" + i.getType().toCode().toLowerCase() + ".png", i.getType().getDisplay());
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, (String)(this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i.getLinkId()), i.getLinkId(), null, null));
        HierarchicalTableGenerator.Cell defn = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(defn);
        if (i.hasMaxLength()) {
            List list2 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, this.context.formatPhrase("GENERAL_MAX_LENGTH", new Object[0]) + " ", null));
            List list3 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, Integer.toString(i.getMaxLength()), null));
        }
        if (i.hasDefinition()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, "br"));
            }
            List list4 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, this.context.formatPhrase("GENERAL_DEFINITION_COLON", new Object[0]) + " ", null));
            this.genDefinitionLink(gen, i, defn, q);
        }
        if (i.hasEnableWhen()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, "br"));
            }
            List list5 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, this.context.formatPhrase("QUEST_ENABLE", new Object[0]) + " ", null));
            List list6 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator8);
            list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, this.context.formatPhrase("GENERAL_TODO", new Object[0]), null));
        }
        if (i.hasAnswerValueSet()) {
            Object vs;
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "br"));
            }
            List list7 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator10);
            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, this.context.formatPhrase("QUEST_VALUE", new Object[0]) + " ", null));
            if (Utilities.noString((String)i.getAnswerValueSet()) && i.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i.getAnswerValueSet().substring(1));
                if (vs == null) {
                    List list8 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, i.getAnswerValueSet(), null));
                } else {
                    List list9 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator12);
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, ((Resource)vs).getWebPath(), ((CanonicalResource)vs).present(), null));
                }
            } else {
                vs = this.context.getWorker().findTxResource(ValueSet.class, i.getAnswerValueSet(), q);
                if (vs == null || !((Resource)vs).hasWebPath()) {
                    List list10 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator13);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, i.getAnswerValueSet(), null));
                } else {
                    List list11 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator14);
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, ((Resource)vs).getWebPath(), ((CanonicalResource)vs).present(), null));
                }
            }
        }
        if (i.hasAnswerOption()) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator15);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "br"));
            }
            List list12 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator16);
            list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, this.context.formatPhrase("QUEST_OPTIONS", new Object[0]) + " ", null));
            List list13 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator17);
            list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, this.context.getDefinitionsTarget() + "#item." + i.getLinkId(), Integer.toString(i.getAnswerOption().size()) + " " + Utilities.pluralize((String)"option", (int)i.getAnswerOption().size()), null));
        }
        if (i.hasInitial()) {
            for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : i.getInitial()) {
                if (!defn.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator18);
                    defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, "br"));
                }
                List list14 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator19);
                list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, this.context.formatPhrase("QUEST_INITIAL", new Object[0]) + " ", null));
                List list15 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator20);
                list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, questionnaireItemInitialComponent.getValue().fhirType(), null));
                List list16 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator21);
                list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, " = ", null));
                if (questionnaireItemInitialComponent.getValue().isPrimitive()) {
                    List list17 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, null, questionnaireItemInitialComponent.getValue().primitiveValue(), null));
                    continue;
                }
                if (questionnaireItemInitialComponent.hasValueCoding()) {
                    this.renderCoding(gen, defn.getPieces(), questionnaireItemInitialComponent.getValueCoding());
                    continue;
                }
                if (questionnaireItemInitialComponent.hasValueQuantity()) {
                    this.renderQuantity(gen, defn.getPieces(), questionnaireItemInitialComponent.getValueQuantity(), false);
                    continue;
                }
                if (!questionnaireItemInitialComponent.hasValueReference()) continue;
                this.renderReference(q, gen, defn.getPieces(), questionnaireItemInitialComponent.getValueReference(), false);
            }
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator23);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, "br"));
            }
            List list18 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator24);
            list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, null, this.context.formatPhrase("QUEST_EXP", new Object[0]) + " ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator25);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, "ul");
            defn.getPieces().add(p);
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_INT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_CONT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-contextExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_ITEM_CONT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemContext");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_EN", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_CALC", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression");
            }
            for (Extension e : i.getExtensionsByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression")) {
                this.addExpression(p, e.getValueExpression(), this.context.formatPhrase("QUEST_CAND", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression");
            }
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : i.getItem()) {
            hasExt = this.renderLogicItem(gen, r.getSubRows(), q, questionnaireItemComponent) || hasExt;
        }
        return hasExt;
    }

    public boolean renderForm(XhtmlNode x, Questionnaire q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div();
        boolean hasPrefix = false;
        for (Questionnaire.QuestionnaireItemComponent c : q.getItem()) {
            hasPrefix = hasPrefix || this.doesItemHavePrefix(c);
        }
        int i = 1;
        for (Questionnaire.QuestionnaireItemComponent c : q.getItem()) {
            hasExt = this.renderFormItem(d, q, c, hasPrefix ? null : Integer.toString(i), 0) || hasExt;
            ++i;
        }
        return hasExt;
    }

    private boolean doesItemHavePrefix(Questionnaire.QuestionnaireItemComponent i) {
        if (i.hasPrefix()) {
            return true;
        }
        for (Questionnaire.QuestionnaireItemComponent c : i.getItem()) {
            if (!this.doesItemHavePrefix(c)) continue;
            return true;
        }
        return false;
    }

    private boolean renderFormItem(XhtmlNode x, Questionnaire q, Questionnaire.QuestionnaireItemComponent i, String pfx, int indent) throws IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div().style("width: " + Integer.toString(900 - indent * 10) + "px; border-top: 1px #eeeeee solid");
        if (indent > 0) {
            d.style("margin-left: " + Integer.toString(10 * indent) + "px");
        }
        XhtmlNode display = d.div().style("display: inline-block; width: " + Integer.toString(500 - indent * 10) + "px");
        XhtmlNode details = d.div().style("border: 1px #ccccff solid; padding: 2px; display: inline-block; background-color: #fefce7; width: 380px");
        XhtmlNode p = display.para();
        if (i.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
            p = p.b();
        }
        if (i.hasPrefix()) {
            p.tx(i.getPrefix());
            p.tx(": ");
        }
        p.span(null, "linkId: " + i.getLinkId()).tx(i.getText());
        if (i.getRequired()) {
            p.span("color: red", this.context.formatPhrase("QUEST_MAND", new Object[0])).tx("*");
        }
        XhtmlNode input = null;
        switch (i.getType()) {
            case STRING: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "text", i.getType().getDisplay(), 60);
                break;
            }
            case ATTACHMENT: {
                break;
            }
            case BOOLEAN: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "checkbox", i.getType().getDisplay(), 1);
                break;
            }
            case CODING: {
                input = p.select(i.getLinkId());
                this.listOptions(q, i, input);
                break;
            }
            case DATE: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "date", i.getType().getDisplay(), 10);
                break;
            }
            case DATETIME: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "datetime-local", i.getType().getDisplay(), 25);
                break;
            }
            case DECIMAL: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "number", i.getType().getDisplay(), 15);
                break;
            }
            case DISPLAY: {
                break;
            }
            case GROUP: {
                break;
            }
            case INTEGER: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "number", i.getType().getDisplay(), 10);
                break;
            }
            case QUANTITY: {
                p.tx(" ");
                input = p.input(i.getLinkId(), "number", "value", 15);
                p.tx(" ");
                input = p.input(i.getLinkId(), "unit", "unit", 10);
                break;
            }
            case QUESTION: {
                break;
            }
            case REFERENCE: {
                break;
            }
            case TEXT: {
                break;
            }
            case TIME: {
                break;
            }
            case URL: {
                break;
            }
        }
        if (input != null && i.getReadOnly()) {
            input.attribute("readonly", "1");
            input.style("background-color: #eeeeee");
        }
        XhtmlNode ul = details.ul();
        boolean hasFlag = false;
        XhtmlNode flags = this.item(ul, "Flags");
        this.item(ul, "linkId", i.getLinkId());
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            hasFlag = true;
            flags.ah(this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", "StructureDefinition-sdc-questionnaire-isSubject.html"), this.context.formatPhrase("QUEST_SUBJECT", new Object[0])).img(this.getImgPath("icon-qi-subject.png"), "icon");
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            hasFlag = true;
            flags.ah(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "extension-questionnaire-hidden.html"}), this.context.formatPhrase("QUEST_HIDDEN", new Object[0])).img(this.getImgPath("icon-qi-hidden.png"), "icon");
            d.style("background-color: #eeeeee");
        }
        if (ToolingExtensions.readBoolExtension(i, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            hasFlag = true;
            flags.ah(this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", "StructureDefinition-sdc-questionnaire-optionalDisplay.html"), this.context.formatPhrase("QUEST_DISPLAY", new Object[0])).img(this.getImgPath("icon-qi-optional.png"), "icon");
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            hasFlag = true;
            flags.ah(this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod", "StructureDefinition-sdc-questionnaire-observationLinkPeriod.html"), this.context.formatPhrase("QUEST_LINKED", new Object[0])).img(this.getImgPath("icon-qi-observation.png"), "icon");
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            CodeableConcept cc = i.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValueCodeableConcept();
            String code = cc.getCode("http://hl7.org/fhir/questionnaire-display-category");
            hasFlag = true;
            flags.ah("https://hl7.org/fhir/R4/extension-questionnaire-displayCategory.html", this.context.formatPhrase("QUEST_CAT", new Object[]{code}) + " ").img(this.getImgPath("icon-qi-" + code + ".png"), "icon");
        }
        if (i.hasMaxLength()) {
            this.item(ul, this.context.formatPhrase("GENERAL_MAX_LENGTH", new Object[0]), Integer.toString(i.getMaxLength()));
        }
        if (i.hasDefinition()) {
            this.genDefinitionLink(this.item(ul, this.context.formatPhrase("GENERAL_DEFINITION_COLON", new Object[0])), i, q);
        }
        if (i.hasEnableWhen()) {
            this.item(ul, this.context.formatPhrase("QUEST_EN", new Object[0]), "todo");
        }
        if (i.hasAnswerValueSet()) {
            ValueSet vs;
            XhtmlNode ans = this.item(ul, this.context.formatPhrase("QUEST_ANSWERS", new Object[0]));
            if (!Utilities.noString((String)i.getAnswerValueSet()) && i.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i.getAnswerValueSet().substring(1));
                if (vs == null || !vs.hasWebPath()) {
                    ans.tx(i.getAnswerValueSet());
                } else {
                    ans.ah(vs.getWebPath()).tx(vs.present());
                }
            } else {
                vs = this.context.getWorker().findTxResource(ValueSet.class, i.getAnswerValueSet(), q);
                if (vs == null || !vs.hasWebPath()) {
                    ans.tx(i.getAnswerValueSet());
                } else {
                    ans.ah(vs.getWebPath()).tx(vs.present());
                }
            }
        }
        if (i.hasAnswerOption()) {
            this.item(ul, this.context.formatPhrase("QUEST_ANSWERS", new Object[0]), Integer.toString(i.getAnswerOption().size()) + " " + Utilities.pluralize((String)"option", (int)i.getAnswerOption().size()), this.context.getDefinitionsTarget() + "#item." + i.getLinkId());
        }
        if (i.hasInitial()) {
            XhtmlNode vi = this.item(ul, this.context.formatPhrase("QUEST_INT", new Object[0]));
            boolean first = true;
            for (Questionnaire.QuestionnaireItemInitialComponent v : i.getInitial()) {
                if (first) {
                    first = false;
                } else {
                    vi.tx(", ");
                }
                if (v.getValue().isPrimitive()) {
                    vi.tx(v.getValue().primitiveValue());
                    continue;
                }
                if (v.hasValueCoding()) {
                    this.renderCoding(vi, v.getValueCoding(), true);
                    continue;
                }
                if (v.hasValueReference()) {
                    this.renderReference(vi, v.getValueReference());
                    continue;
                }
                if (!v.hasValueQuantity()) continue;
                this.renderQuantity(vi, v.getValueQuantity());
            }
        }
        if (!hasFlag) {
            ul.remove(flags);
        }
        int t = 1;
        for (Questionnaire.QuestionnaireItemComponent c : i.getItem()) {
            hasExt = this.renderFormItem(x, q, c, pfx == null ? null : pfx + "." + Integer.toString(t), indent + 1) || hasExt;
            ++t;
        }
        return hasExt;
    }

    @Nonnull
    private String getImgPath(String code) throws IOException {
        return this.context.getLocalPrefix().length() > 0 ? Utilities.path((String[])new String[]{this.context.getLocalPrefix(), code}) : Utilities.path((String[])new String[]{code});
    }

    private void item(XhtmlNode ul, String name, String value, String valueLink) {
        if (!Utilities.noString((String)value)) {
            ul.li().style("font-size: 10px").ah(valueLink).tx(name + ": " + value);
        }
    }

    private void item(XhtmlNode ul, String name, String value) {
        if (!Utilities.noString((String)value)) {
            ul.li().style("font-size: 10px").tx(name + ": " + value);
        }
    }

    private XhtmlNode item(XhtmlNode ul, String name) {
        XhtmlNode li = ul.li();
        li.style("font-size: 10px").tx(name + ": ");
        return li;
    }

    private void listOptions(Questionnaire q, Questionnaire.QuestionnaireItemComponent i, XhtmlNode select) {
        if (i.hasAnswerValueSet()) {
            ValueSetExpansionOutcome exp;
            ValueSet vs = null;
            if (!Utilities.noString((String)i.getAnswerValueSet()) && i.getAnswerValueSet().startsWith("#")) {
                vs = (ValueSet)q.getContained(i.getAnswerValueSet().substring(1));
                if (vs != null && !vs.hasUrl()) {
                    vs = vs.copy();
                    vs.setUrl(q.getUrl() + "--" + q.getContained(i.getAnswerValueSet().substring(1)));
                }
            } else {
                vs = this.context.getContext().findTxResource(ValueSet.class, i.getAnswerValueSet(), q);
            }
            if (vs != null && (exp = this.context.getContext().expandVS(vs, true, false)).getValueset() != null) {
                for (ValueSet.ValueSetExpansionContainsComponent cc : exp.getValueset().getExpansion().getContains()) {
                    select.option(cc.getCode(), cc.hasDisplay() ? cc.getDisplay() : cc.getCode(), false);
                }
                return;
            }
        } else if (i.hasAnswerOption()) {
            this.renderItemOptions(select, i);
        }
        select.option("a", "??", false);
    }

    @Override
    public String display(Resource dr) throws UnsupportedEncodingException, IOException {
        return this.display((Questionnaire)dr);
    }

    public String display(Questionnaire q) throws UnsupportedEncodingException, IOException {
        return this.context.formatPhrase("QUEST_QUESTIONNAIRE", new Object[]{q.present()}) + " ";
    }

    private boolean renderLinks(XhtmlNode x, Questionnaire q) {
        x.para().tx(this.context.formatPhrase("QUEST_TRY", new Object[0]));
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SELF), "package.tgz"}) + "&q=" + q.getId() + ".json").tx(this.context.formatPhrase("QUEST_NLM", new Object[0]));
        return false;
    }

    private boolean renderDefns(XhtmlNode x, Questionnaire q) throws IOException {
        XhtmlNode tbl = x.table("dict");
        boolean ext = false;
        ext = this.renderRootDefinition(tbl, q, new ArrayList<Questionnaire.QuestionnaireItemComponent>()) || ext;
        for (Questionnaire.QuestionnaireItemComponent qi : q.getItem()) {
            ext = this.renderDefinition(tbl, q, qi, new ArrayList<Questionnaire.QuestionnaireItemComponent>()) || ext;
        }
        return ext;
    }

    private boolean renderRootDefinition(XhtmlNode tbl, Questionnaire q, List<Questionnaire.QuestionnaireItemComponent> parents) throws IOException {
        boolean first;
        boolean ext = false;
        XhtmlNode td = tbl.tr().td("structure").colspan("2").span(null, null).attribute("class", "self-link-parent");
        td.an(q.getId());
        td.img(this.getImgPath("icon_q_root.gif"), "icon");
        td.tx(" " + this.context.formatPhrase("QUEST_QUEST", new Object[0]) + " ");
        td.b().tx(q.getId());
        this.defn(tbl, this.context.formatPhrase("GENERAL_URL", new Object[0]), q.getUrl());
        this.defn(tbl, this.context.formatPhrase("GENERAL_VER", new Object[0]), q.getVersion());
        this.defn(tbl, this.context.formatPhrase("GENERAL_NAME", new Object[0]), q.getName());
        this.defn(tbl, this.context.formatPhrase("GENERAL_TITLE", new Object[0]), q.getTitle());
        if (q.hasDerivedFrom()) {
            td = this.defn(tbl, this.context.formatPhrase("QUEST_DERIVED", new Object[0]));
            first = true;
            for (CanonicalType canonicalType : q.getDerivedFrom()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.tx(canonicalType.asStringValue());
            }
        }
        this.defn(tbl, this.context.formatPhrase("GENERAL_STATUS", new Object[0]), q.getStatus().getDisplay());
        this.defn(tbl, this.context.formatPhrase("GENERAL_EXPER", new Object[0]), q.getExperimental());
        this.defn(tbl, this.context.formatPhrase("QUEST_PUB", new Object[0]), q.getDateElement().primitiveValue());
        this.defn(tbl, this.context.formatPhrase("QUEST_APP", new Object[0]), q.getApprovalDateElement().primitiveValue());
        this.defn(tbl, this.context.formatPhrase("QUEST_REV_DATE", new Object[0]), q.getLastReviewDateElement().primitiveValue());
        if (q.hasEffectivePeriod()) {
            this.renderPeriod(this.defn(tbl, this.context.formatPhrase("QUEST_EFF_PERIOD", new Object[0])), q.getEffectivePeriod());
        }
        if (q.hasSubjectType()) {
            td = this.defn(tbl, this.context.formatPhrase("QUEST_SUB_TYPE", new Object[0]));
            first = true;
            for (CodeType codeType : q.getSubjectType()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.tx(codeType.asStringValue());
            }
        }
        this.defn(tbl, this.context.formatPhrase("GENERAL_DESC", new Object[0]), q.getDescription());
        this.defn(tbl, this.context.formatPhrase("GENERAL_PURPOSE", new Object[0]), q.getPurpose());
        this.defn(tbl, this.context.formatPhrase("GENERAL_COPYRIGHT", new Object[0]), q.getCopyright());
        if (q.hasCode()) {
            td = this.defn(tbl, Utilities.pluralize((String)"Code", (int)q.getCode().size()));
            first = true;
            for (Coding coding : q.getCode()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                this.renderCodingWithDetails(td, coding);
            }
        }
        return false;
    }

    private boolean renderDefinition(XhtmlNode tbl, Questionnaire q, Questionnaire.QuestionnaireItemComponent qi, List<Questionnaire.QuestionnaireItemComponent> parents) throws IOException {
        XhtmlNode li;
        XhtmlNode ul;
        XhtmlNode tr;
        boolean ext = false;
        XhtmlNode td = tbl.tr().td("structure").colspan("2").span(null, null).attribute("class", "self-link-parent");
        td.an("item." + qi.getLinkId());
        for (Questionnaire.QuestionnaireItemComponent p : parents) {
            td.ah("#item." + p.getLinkId()).img(this.getImgPath("icon_q_item.png"), "icon");
            td.tx(" > ");
        }
        td.img(this.getImgPath("icon_q_item.png"), "icon");
        td.tx(" Item ");
        td.b().tx(qi.getLinkId());
        this.defn(tbl, this.context.formatPhrase("QUEST_ID", new Object[0]), qi.getLinkId());
        this.defn(tbl, this.context.formatPhrase("QUEST_PREFIX", new Object[0]), qi.getPrefix());
        this.defn(tbl, this.context.formatPhrase("QUEST_TEXT", new Object[0]), qi.getText());
        this.defn(tbl, this.context.formatPhrase("GENERAL_TYPE", new Object[0]), qi.getType().getDisplay());
        this.defn(tbl, this.context.formatPhrase("GENERAL_REQUIRED", new Object[0]), qi.getRequired(), true);
        this.defn(tbl, this.context.formatPhrase("QUEST_REP", new Object[0]), qi.getRepeats(), true);
        this.defn(tbl, this.context.formatPhrase("QUEST_READ_ONLY", new Object[0]), qi.getReadOnly(), false);
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject")) {
            this.defn(tbl, this.context.formatPhrase("GENERAL_SUBJ", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject", "This element changes who the subject of the question is", null);
        }
        this.defn(tbl, this.context.formatPhrase("QUEST_MAX_LENGTH", new Object[0]), qi.getMaxLength());
        if (qi.hasAnswerValueSet()) {
            this.defn(tbl, this.context.formatPhrase("GENERAL_VALUESET", new Object[0]), qi.getDefinition(), this.context.getWorker().findTxResource(ValueSet.class, qi.getAnswerValueSet(), q));
        }
        if (qi.hasAnswerOption()) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("QUEST_ALLOWED", new Object[0]));
            ul = tr.td().ul();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : qi.getAnswerOption()) {
                li = ul.li();
                this.render(li, questionnaireItemAnswerOptionComponent.getValue());
                if (!questionnaireItemAnswerOptionComponent.getInitialSelected()) continue;
                li.tx(" " + this.context.formatPhrase("QUEST_INITIALLY", new Object[0]));
            }
        }
        if (qi.hasInitial()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)this.context.formatPhrase("QUEST_INITIAL_ANSWER", new Object[0]), (int)qi.getInitial().size()));
            if (qi.getInitial().size() == 1) {
                this.render(tr.td(), qi.getInitialFirstRep().getValue());
            } else {
                ul = tr.td().ul();
                for (Questionnaire.QuestionnaireItemInitialComponent questionnaireItemInitialComponent : qi.getInitial()) {
                    li = ul.li();
                    this.render(li, questionnaireItemInitialComponent.getValue());
                }
            }
        }
        if (qi.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            tr = tbl.tr();
            tr.td().ah("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").tx("Display Category");
            this.render(tr.td(), qi.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").getValue());
        }
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden")) {
            this.defn(tbl, this.context.formatPhrase("QUEST_HIDDEN_ITEM", new Object[0]), "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory", "This item is a hidden question", null);
        }
        if (ToolingExtensions.readBoolExtension(qi, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay")) {
            this.defn(tbl, this.context.formatPhrase("QUEST_HIDDEN_ITEM", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", "This item is optional to display", null);
        }
        if (qi.hasDefinition()) {
            this.genDefinitionLink(this.defn(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0])), qi, q);
        }
        if (qi.hasCode()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)this.context.formatPhrase("GENERAL_CODE", new Object[0]), (int)qi.getCode().size()));
            ul = tr.td().ul();
            for (Coding coding : qi.getCode()) {
                this.renderCodingWithDetails(ul.li(), coding);
            }
        }
        if (qi.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            tr = tbl.tr();
            StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod");
            if (sd != null && sd.hasWebPath()) {
                tr.td().ah(sd.getWebPath()).tx(this.context.formatPhrase("QUEST_OBSERVATION", new Object[0]));
            } else {
                tr.td().ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod").tx(this.context.formatPhrase("QUEST_OBSERVATION", new Object[0]));
            }
            this.render(tr.td(), qi.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod").getValue());
        }
        if (qi.hasEnableWhen()) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("QUEST_EN", new Object[0]));
            td = tr.td();
            if (qi.getEnableWhen().size() == 1) {
                this.renderEnableWhen(td, qi.getEnableWhen().get(0));
            } else {
                if (qi.hasEnableBehavior()) {
                    td.tx(qi.getEnableBehavior().getDisplay() + " " + this.context.formatPhrase("QUEST_TRUE", new Object[0]));
                } else {
                    td.tx(this.context.formatPhrase("QUEST_ARE_TRUE", new Object[0]));
                }
                ul = td.ul();
                for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : qi.getEnableWhen()) {
                    this.renderEnableWhen(ul.li(), questionnaireItemEnableWhenComponent);
                }
            }
        }
        ArrayList<Questionnaire.QuestionnaireItemComponent> curr = new ArrayList<Questionnaire.QuestionnaireItemComponent>();
        curr.addAll(parents);
        curr.add(qi);
        for (Questionnaire.QuestionnaireItemComponent qic : qi.getItem()) {
            ext = this.renderDefinition(tbl, q, qic, curr) || ext;
        }
        return ext;
    }

    private void defn(XhtmlNode tbl, String name, String url, Resource res) throws UnsupportedEncodingException, IOException {
        if (res != null && res.hasWebPath()) {
            this.defn(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]), RendererFactory.factory(res, this.context).display(res), res.getWebPath());
        } else if (Utilities.isAbsoluteUrlLinkable((String)url)) {
            this.defn(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]), url, url);
        }
        this.defn(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]), url);
    }

    private void renderEnableWhen(XhtmlNode x, Questionnaire.QuestionnaireItemEnableWhenComponent ew) {
        x.ah("#item." + ew.getQuestion()).tx(ew.getQuestion());
        x.tx(" ");
        x.tx(ew.getOperator().toCode());
        x.tx(" ");
        x.tx(this.display(ew.getAnswer()));
    }

    private XhtmlNode defn(XhtmlNode tbl, String name) {
        XhtmlNode tr = tbl.tr();
        tr.td().tx(name);
        return tr.td();
    }

    private void defn(XhtmlNode tbl, String name, int value) {
        if (value > 0) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, boolean value) {
        XhtmlNode tr = tbl.tr();
        tr.td().tx(name);
        tr.td().tx(Boolean.toString(value));
    }

    private void defn(XhtmlNode tbl, String name, String value) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, String value, String url) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().ah(url).tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, String nurl, String value, String url) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().ah(nurl).tx(name);
            if (url != null) {
                tr.td().ah(url).tx(value);
            } else {
                tr.td().tx(value);
            }
        }
    }

    private void defn(XhtmlNode tbl, String name, boolean value, boolean ifFalse) {
        if (ifFalse || value) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(Boolean.toString(value));
        }
    }
}

