/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class RequirementsRenderer
extends ResourceRenderer {
    public RequirementsRenderer(RenderingContext context) {
        super(context);
    }

    public RequirementsRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (Requirements)dr);
    }

    public boolean render(XhtmlNode x, Requirements req) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode ul;
        Object p;
        if (req.hasActor()) {
            if (req.getActor().size() == 1) {
                ActorDefinition acd = this.context.getWorker().fetchResource(ActorDefinition.class, (String)req.getActor().get(0).getValue(), req);
                p = x.para();
                p.tx(this.context.formatPhrase("REQ_ACTOR", new Object[0]) + " ");
                if (acd == null) {
                    p.code((String)req.getActor().get(0).getValue());
                } else {
                    p.ah(acd.getWebPath()).tx(acd.present());
                }
            } else {
                x.para().tx(this.context.formatPhrase("REQ_FOLLOWING_ACTOR", new Object[0]) + " ");
                ul = x.ul();
                for (CanonicalType canonicalType : req.getActor()) {
                    ActorDefinition acd = this.context.getWorker().fetchResource(ActorDefinition.class, (String)canonicalType.getValue(), req);
                    if (acd == null) {
                        ul.li().code((String)canonicalType.getValue());
                        continue;
                    }
                    ul.li().ah(acd.getWebPath()).tx(acd.present());
                }
            }
        }
        if (req.hasDerivedFrom()) {
            if (req.getDerivedFrom().size() == 1) {
                Requirements reqd = this.context.getWorker().fetchResource(Requirements.class, (String)req.getDerivedFrom().get(0).getValue(), req);
                p = x.para();
                p.tx(this.context.formatPhrase("REQ_DERIVE", new Object[0]) + " ");
                if (reqd == null) {
                    p.code((String)req.getDerivedFrom().get(0).getValue());
                } else {
                    p.ah(reqd.getWebPath()).tx(reqd.present());
                }
            } else {
                x.para().tx(this.context.formatPhrase("REQ_FOLLOWING_REQ", new Object[0]) + " ");
                ul = x.ul();
                for (CanonicalType canonicalType : req.getDerivedFrom()) {
                    Requirements reqd = this.context.getWorker().fetchResource(Requirements.class, (String)canonicalType.getValue(), req);
                    if (reqd == null) {
                        ul.li().code((String)canonicalType.getValue());
                        continue;
                    }
                    ul.li().ah(reqd.getWebPath()).tx(reqd.present());
                }
            }
        }
        if (req.hasReference()) {
            XhtmlNode p2 = x.para();
            p2.tx(this.context.formatPhrase("GENERAL_REFS", new Object[0]) + " ");
            int i = 0;
            for (UrlType c : req.getReference()) {
                String url;
                if (++i > 1) {
                    p2.tx(", ");
                }
                if ((url = (String)c.getValue()).contains("#")) {
                    url = url.substring(0, url.indexOf("#"));
                }
                p2.ah((String)c.getValue()).tx(url);
            }
        }
        XhtmlNode tbl = x.table("grid");
        for (Requirements.RequirementsStatementComponent requirementsStatementComponent : req.getStatement()) {
            Resource r;
            String url;
            XhtmlNode li;
            XhtmlNode tr = tbl.tr();
            String lbl = requirementsStatementComponent.hasLabel() ? requirementsStatementComponent.getLabel() : requirementsStatementComponent.getKey();
            XhtmlNode td = tr.td();
            td.b().an(requirementsStatementComponent.getKey());
            td.tx(lbl);
            td = tr.td();
            boolean first = true;
            CodeSystem cs = this.context.getWorker().fetchCodeSystem("http://hl7.org/fhir/conformance-expectation");
            for (Enumeration<Requirements.ConformanceExpectation> t : requirementsStatementComponent.getConformance()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                if (cs != null) {
                    td.ah(cs.getWebPath() + "#conformance-expectation-" + t.asStringValue()).tx(t.asStringValue().toUpperCase());
                    continue;
                }
                td.tx(t.asStringValue().toUpperCase());
            }
            td = tr.td();
            this.addMarkdown(td, requirementsStatementComponent.getRequirement());
            if (!requirementsStatementComponent.hasDerivedFrom() && !requirementsStatementComponent.hasSatisfiedBy() && !requirementsStatementComponent.hasReference() && !requirementsStatementComponent.hasSource()) continue;
            td.para().tx(this.context.formatPhrase("REQ_LINKS", new Object[0]) + " ");
            XhtmlNode ul2 = td.ul();
            if (requirementsStatementComponent.hasDerivedFrom()) {
                Requirements reqr;
                String string;
                li = ul2.li();
                li.tx(this.context.formatPhrase("REQ_DERIVED", new Object[0]) + " ");
                Object url2 = requirementsStatementComponent.getDerivedFrom();
                String string2 = string = ((String)url2).contains("#") ? ((String)url2).substring(((String)url2).indexOf("#") + 1) : "";
                if (((String)url2).contains("#")) {
                    url2 = ((String)url2).substring(0, ((String)url2).indexOf("#"));
                }
                if ((reqr = this.context.getWorker().fetchResource(Requirements.class, (String)url2, req)) != null) {
                    Requirements.RequirementsStatementComponent stmtr = reqr.findStatement(string);
                    if (stmtr != null) {
                        li.ah(reqr.getWebPath() + "#" + string).tx(reqr.present() + " # " + (requirementsStatementComponent.hasLabel() ? requirementsStatementComponent.getLabel() : requirementsStatementComponent.getKey()));
                    } else {
                        li.ah(reqr.getWebPath() + "#" + string).tx(reqr.present() + " # " + string);
                    }
                } else {
                    li.code(requirementsStatementComponent.getDerivedFrom());
                }
            }
            if (requirementsStatementComponent.hasSatisfiedBy()) {
                li = ul2.li();
                li.tx(this.context.formatPhrase("REQ_SATISFIED", new Object[0]) + " ");
                first = true;
                for (UrlType urlType : requirementsStatementComponent.getSatisfiedBy()) {
                    if (first) {
                        first = false;
                    } else {
                        li.tx(", ");
                    }
                    url = (String)urlType.getValue();
                    if (url.contains("#")) {
                        url = url.substring(0, url.indexOf("#"));
                    }
                    if ((r = this.context.getWorker().fetchResource(Resource.class, url, req)) != null) {
                        String desc = this.getResourceDescription(r, null);
                        li.ah((String)urlType.getValue()).tx(desc);
                        continue;
                    }
                    li.ah((String)urlType.getValue()).tx(url);
                }
            }
            if (requirementsStatementComponent.hasReference()) {
                li = ul2.li();
                li.tx(this.context.formatPhrase("GENERAL_REFS", new Object[0]) + " ");
                int i = 0;
                for (UrlType c2 : requirementsStatementComponent.getReference()) {
                    String url3;
                    if (++i > 1) {
                        li.tx(", ");
                    }
                    if ((url3 = (String)c2.getValue()).contains("#")) {
                        url3 = url3.substring(0, url3.indexOf("#"));
                    }
                    li.ah((String)c2.getValue()).tx(url3);
                }
            }
            if (!requirementsStatementComponent.hasSource()) continue;
            li = ul2.li();
            li.tx(this.context.formatPhrase("GENERAL_SRC", new Object[0]) + " ");
            first = true;
            for (Reference reference : requirementsStatementComponent.getSource()) {
                if (first) {
                    first = false;
                } else {
                    li.tx(", ");
                }
                if (reference.hasReference()) {
                    String desc;
                    url = reference.getReference();
                    if (url.contains("#")) {
                        url = url.substring(0, url.indexOf("#"));
                    }
                    r = this.context.getWorker().fetchResource(Resource.class, url, req);
                    Resolver.ResourceWithReference t = null;
                    if (r == null && this.context.getResolver() != null) {
                        t = this.context.getResolver().resolve(this.context, url);
                    }
                    if (r != null) {
                        desc = this.getResourceDescription(r, reference.getDisplay());
                        li.ah(reference.getReference()).tx(desc);
                        continue;
                    }
                    if (t != null) {
                        desc = this.getResourceDescription(t, reference.getDisplay());
                        li.ah(t.getReference()).tx(desc);
                        continue;
                    }
                    li.ah(reference.getReference()).tx(url);
                    continue;
                }
                if (reference.hasDisplay()) {
                    li.tx(reference.getDisplay());
                    continue;
                }
                li.tx("??");
            }
        }
        return false;
    }

    private String getResourceDescription(Resolver.ResourceWithReference res, String display) throws UnsupportedEncodingException, IOException {
        if (!Utilities.noString((String)display)) {
            return display;
        }
        return RendererFactory.factory(res.getResource(), this.context).display(res.getResource());
    }

    private String getResourceDescription(Resource res, String display) throws UnsupportedEncodingException, IOException {
        if (!Utilities.noString((String)display)) {
            return display;
        }
        if (res instanceof CanonicalResource) {
            return ((CanonicalResource)res).present();
        }
        return RendererFactory.factory(res, this.context).display(res);
    }

    public void describe(XhtmlNode x, Library lib) {
        x.tx(this.display(lib));
    }

    public String display(Library lib) {
        return lib.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((Library)r).present();
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        return "??";
    }
}

