/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.ProfileDrivenRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.DirectWrappers;
import org.hl7.fhir.r5.renderers.utils.ElementWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class ResourceRenderer
extends DataRenderer {
    protected Resolver.ResourceContext rcontext;
    protected XVerExtensionManager xverManager;
    protected boolean multiLangMode;

    public ResourceRenderer(RenderingContext context) {
        super(context);
    }

    public ResourceRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context);
        this.rcontext = rcontext;
    }

    public Resolver.ResourceContext getRcontext() {
        return this.rcontext;
    }

    public ResourceRenderer setRcontext(Resolver.ResourceContext rcontext) {
        this.rcontext = rcontext;
        return this;
    }

    public boolean isMultiLangMode() {
        return this.multiLangMode;
    }

    public ResourceRenderer setMultiLangMode(boolean multiLangMode) {
        this.multiLangMode = multiLangMode;
        return this;
    }

    public XhtmlNode build(Resource dr) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        this.render(x, dr);
        return x;
    }

    public void render(DomainResource r) throws IOException, FHIRException, EOperationOutcome {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasExtensions = this.render(x, r);
        String an = r.fhirType() + "_" + r.getId();
        if (this.context.isAddName() && !this.hasAnchorName(x, an)) {
            this.injectAnchorName(x, an);
        }
        this.inject(r, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    public XhtmlNode render(BaseWrappers.ResourceWrapper r) throws IOException, FHIRException, EOperationOutcome {
        assert (r.getContext() == this.context);
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasExtensions = this.render(x, r);
        String an = r.fhirType() + "_" + r.getId();
        if (this.context.isAddName() && !this.hasAnchorName(x, an)) {
            this.injectAnchorName(x, an);
        }
        if (r.hasNarrative()) {
            r.injectNarrative(this, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
        }
        return x;
    }

    public XhtmlNode checkNarrative(BaseWrappers.ResourceWrapper r) throws IOException, FHIRException, EOperationOutcome {
        assert (r.getContext() == this.context);
        XhtmlNode x = r.getNarrative();
        String an = r.fhirType() + "_" + r.getId();
        if (this.context.isAddName() && !this.hasAnchorName(x, an)) {
            this.injectAnchorName(x, an);
        }
        return x;
    }

    private void injectAnchorName(XhtmlNode x, String an) {
        XhtmlNode ip = x;
        while (ip.hasChildren() && "div".equals(ip.getChildNodes().get(0).getName())) {
            ip = ip.getChildNodes().get(0);
        }
        ip.addTag(0, "a").setAttribute("name", an).tx(" ");
    }

    protected boolean hasAnchorName(XhtmlNode x, String an) {
        if ("a".equals(x.getName()) && an.equals(x.getAttribute("name"))) {
            return true;
        }
        if (x.hasChildren()) {
            for (XhtmlNode c : x.getChildNodes()) {
                if (!this.hasAnchorName(c, an)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract boolean render(XhtmlNode var1, Resource var2) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome;

    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        ProfileDrivenRenderer pr = new ProfileDrivenRenderer(this.context);
        return pr.render(x, r);
    }

    public void describe(XhtmlNode x, Resource r) throws UnsupportedEncodingException, IOException {
        x.tx(this.display(r));
    }

    public void describe(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        x.tx(this.display(r));
    }

    public abstract String display(Resource var1) throws UnsupportedEncodingException, IOException;

    public abstract String display(BaseWrappers.ResourceWrapper var1) throws UnsupportedEncodingException, IOException;

    public void inject(DomainResource r, XhtmlNode x, Narrative.NarrativeStatus status) {
        r.getText().setUserData("renderer.generated", true);
        if (!r.hasText() || !r.getText().hasDiv()) {
            r.setText(new Narrative());
            r.getText().setStatus(status);
        }
        if (this.multiLangMode) {
            if (!r.getText().hasDiv()) {
                XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
                div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                r.getText().setDiv(div);
            } else {
                r.getText().getDiv().getChildNodes().removeIf(c -> !"div".equals(c.getName()) || !c.hasAttribute("xml:lang"));
            }
            this.markLanguage(x);
            r.getText().getDiv().getChildNodes().add(x);
        } else {
            if (!x.hasAttribute("xmlns")) {
                x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            }
            if (r.hasLanguage()) {
                x.setAttribute("lang", r.getLanguage());
                x.setAttribute("xml:lang", r.getLanguage());
            }
            r.getText().setDiv(x);
        }
    }

    public void renderCanonical(Resource res, XhtmlNode x, String url) throws UnsupportedEncodingException, IOException {
        DirectWrappers.ResourceWrapperDirect rw = new DirectWrappers.ResourceWrapperDirect(this.context, res);
        this.renderCanonical(rw, x, url);
    }

    public void renderCanonical(BaseWrappers.ResourceWrapper rw, XhtmlNode x, String url) throws UnsupportedEncodingException, IOException {
        this.renderCanonical(rw, x, url, true, rw.getResource());
    }

    public void renderCanonical(BaseWrappers.ResourceWrapper rw, XhtmlNode x, String url, boolean allowLinks, Resource src) throws UnsupportedEncodingException, IOException {
        if (url == null) {
            return;
        }
        Resource target = this.context.getWorker().fetchResource(Resource.class, url, src);
        if (target == null || !(target instanceof CanonicalResource)) {
            x.code().tx(url);
        } else {
            CanonicalResource cr = (CanonicalResource)target;
            if (url.contains("|")) {
                if (target.hasWebPath()) {
                    x.ah(target.getWebPath()).tx(cr.present() + this.context.formatPhrase("RES_REND_VER", new Object[0]) + cr.getVersion() + ")");
                } else {
                    url = url.substring(0, url.indexOf("|"));
                    x.code().tx(url);
                    x.tx(": " + cr.present() + this.context.formatPhrase("RES_REND_VER", new Object[0]) + cr.getVersion() + ")");
                }
            } else if (target.hasWebPath()) {
                x.ah(target.getWebPath()).tx(cr.present());
            } else {
                x.code().tx(url);
                x.tx(" (" + cr.present() + ")");
            }
        }
    }

    public void render(Resource res, XhtmlNode x, DataType type) throws FHIRFormatError, DefinitionException, IOException {
        if (type instanceof Reference) {
            this.renderReference(res, x, (Reference)type);
        } else if (type instanceof CodeableReference) {
            CodeableReference cr = (CodeableReference)type;
            if (cr.hasReference()) {
                this.renderReference(res, x, cr.getReference());
            } else {
                this.render(x, type);
            }
        } else {
            this.render(x, type);
        }
    }

    public void render(BaseWrappers.ResourceWrapper res, XhtmlNode x, DataType type) throws FHIRFormatError, DefinitionException, IOException {
        if (type instanceof Reference) {
            this.renderReference(res, x, (Reference)type);
        } else if (type instanceof CodeableReference) {
            CodeableReference cr = (CodeableReference)type;
            if (cr.hasReference()) {
                this.renderReference(res, x, cr.getReference());
            } else {
                this.render(x, type);
            }
        } else {
            this.render(x, type);
        }
    }

    public void renderReference(Resource res, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        DirectWrappers.ResourceWrapperDirect rw = new DirectWrappers.ResourceWrapperDirect(this.context, res);
        this.renderReference((BaseWrappers.ResourceWrapper)rw, x, r);
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        this.renderReference(rw, x, r, true);
    }

    public void renderReference(Resource res, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Piece> pieces, Reference r, boolean allowLinks) throws UnsupportedEncodingException, IOException {
        String name;
        if (r == null) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "null!", null));
            return;
        }
        DirectWrappers.ResourceWrapperDirect rw = new DirectWrappers.ResourceWrapperDirect(this.context, res);
        Resolver.ResourceWithReference tr = null;
        String link = null;
        StringBuilder text = new StringBuilder();
        if (r.hasReferenceElement() && allowLinks) {
            tr = this.resolveReference(rw, r.getReference());
            if (!r.getReference().startsWith("#")) {
                if (tr != null && tr.getReference() != null) {
                    link = tr.getReference();
                } else if (r.getReference().contains("?")) {
                    text.append(this.context.formatPhrase("RES_REND_COND_REF", new Object[0]) + " ");
                } else {
                    link = r.getReference();
                }
            }
        }
        if (tr != null && tr.getReference() != null && tr.getReference().startsWith("#")) {
            text.append(this.context.formatPhrase("RES_REND_SEE_ON_THIS_PAGE", new Object[0]) + " ");
        }
        String display = r.hasDisplayElement() ? r.getDisplay() : null;
        String string = name = tr != null && tr.getResource() != null ? tr.getResource().getNameFromResource() : null;
        if (display == null && (tr == null || tr.getResource() == null)) {
            if (!Utilities.noString((String)r.getReference())) {
                text.append(r.getReference());
            } else if (r.hasIdentifier()) {
                text.append(this.displayIdentifier(r.getIdentifier()));
            } else {
                text.append("??");
            }
        } else if (this.context.isTechnicalMode()) {
            text.append(r.getReference());
            if (display != null) {
                text.append(": " + display);
            }
            if ((tr == null || tr.getReference() != null && !tr.getReference().startsWith("#")) && name != null) {
                text.append(" \"" + name + "\"");
            }
            if (r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetElement") || r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                text.append("(");
                for (Extension ex : r.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/targetElement")) {
                    if (!ex.hasValue()) continue;
                    text.append(", ");
                    text.append("#" + ex.getValue().primitiveValue());
                }
                for (Extension ex : r.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                    if (!ex.hasValue()) continue;
                    text.append(", ");
                    text.append("/#" + ex.getValue().primitiveValue());
                }
                text.append(")");
            }
        } else if (display != null) {
            text.append(display);
        } else if (name != null) {
            text.append(name);
        } else {
            text.append(this.context.formatPhrase("RES_REND_DESC", new Object[0]));
        }
        if (tr != null && tr.getReference() != null && tr.getReference().startsWith("#")) {
            text.append(")");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, link, text.toString(), null));
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, Reference r, boolean allowLinks) throws UnsupportedEncodingException, IOException {
        String name;
        if (r == null) {
            x.tx("null!");
            return;
        }
        XhtmlNode c = null;
        Resolver.ResourceWithReference tr = null;
        boolean onPage = false;
        if (r.hasReferenceElement() && allowLinks) {
            tr = this.resolveReference(rw, r.getReference());
            if (!r.getReference().startsWith("#")) {
                if (tr != null && tr.getReference() != null) {
                    if (tr.getReference().startsWith("#")) {
                        onPage = true;
                        c = this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER || tr != null && tr.getKind() != Resolver.ResourceReferenceKind.BUNDLE ? x.ah("#hc" + tr.getReference().substring(1)) : x;
                    } else {
                        c = x.ah(tr.getReference());
                    }
                } else if (r.getReference().contains("?")) {
                    x.tx(this.context.formatPhrase("RES_REND_COND_REF", new Object[0]) + " ");
                    c = x.code("");
                } else {
                    c = x.ah(r.getReference());
                }
            } else if ("#".equals(r.getReference())) {
                c = x.ah("#");
            } else if (this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER || tr != null && tr.getKind() != Resolver.ResourceReferenceKind.BUNDLE) {
                c = x.ah("#hc" + r.getReference().substring(1));
                onPage = true;
            } else {
                c = x;
            }
        } else {
            c = x.span(null, null);
        }
        if (onPage) {
            c.tx(this.context.formatPhrase("RES_REND_SEE_ON_THIS_PAGE", new Object[0]) + " ");
        }
        String display = r.hasDisplayElement() ? r.getDisplay() : null;
        String string = name = tr != null && tr.getResource() != null ? tr.getResource().getNameFromResource() : null;
        if (display == null && (tr == null || tr.getResource() == null)) {
            if (!Utilities.noString((String)r.getReference())) {
                c.addText(r.getReference());
            } else if (r.hasIdentifier()) {
                this.renderIdentifier(c, r.getIdentifier());
            } else {
                c.addText("??");
            }
        } else if (this.context.isTechnicalMode()) {
            c.addText(r.getReference());
            if (display != null) {
                c.addText(": " + display);
            }
            if ((tr == null || tr.getReference() != null && !tr.getReference().startsWith("#")) && name != null) {
                x.addText(" \"" + name + "\"");
            }
            if (r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetElement") || r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                x.addText("(");
                for (Extension ex : r.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/targetElement")) {
                    if (!ex.hasValue()) continue;
                    x.sep(", ");
                    x.addText("#" + ex.getValue().primitiveValue());
                }
                for (Extension ex : r.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                    if (!ex.hasValue()) continue;
                    x.sep(", ");
                    x.addText("/#" + ex.getValue().primitiveValue());
                }
                x.addText(")");
            }
        } else if (display != null) {
            c.addText(display);
        } else if (name != null) {
            c.addText(name);
        } else {
            c.tx(this.context.formatPhrase("RES_REND_GEN_SUM", new Object[0]) + " ");
            if (tr != null) {
                new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), true, r.getReference().startsWith("#"), true);
            }
        }
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, BaseWrappers.BaseWrapper r) throws UnsupportedEncodingException, IOException {
        String v;
        XhtmlNode c = x;
        Resolver.ResourceWithReference tr = null;
        if (r.has("reference")) {
            v = r.get("reference").primitiveValue();
            tr = this.resolveReference(rw, v);
            if (!v.startsWith("#")) {
                c = tr != null && tr.getReference() != null ? x.ah(tr.getReference()) : x.ah(v);
            }
        } else {
            v = "";
        }
        if (r.has("display")) {
            c.addText(r.get("display").primitiveValue());
            if (tr != null && tr.getResource() != null) {
                c.tx(this.context.formatPhrase("RES_REND_GEN_SUM", new Object[0]) + " ");
                new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), true, v.startsWith("#"), false);
            }
        } else if (tr != null && tr.getResource() != null) {
            new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), v.startsWith("#"), v.startsWith("#"), false);
        } else {
            c.addText(v);
        }
    }

    protected Resolver.ResourceWithReference resolveReference(BaseWrappers.ResourceWrapper res, String url) {
        Object ae;
        if (url == null) {
            return null;
        }
        if (url.startsWith("#") && res != null) {
            for (BaseWrappers.ResourceWrapper r : res.getContained()) {
                if (!r.getId().equals(url.substring(1))) continue;
                return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.CONTAINED, url, r);
            }
            return null;
        }
        String version = null;
        if (url.contains("/_history/")) {
            version = url.substring(url.indexOf("/_history/") + 10);
            url = url.substring(0, url.indexOf("/_history/"));
        }
        if (this.rcontext != null) {
            Bundle.BundleEntryComponent bundleResource = this.rcontext.resolve(url);
            if (bundleResource != null) {
                String id = bundleResource.getResource().getId();
                if (id == null) {
                    id = this.makeIdFromBundleEntry(bundleResource.getFullUrl());
                }
                String bundleUrl = "#" + bundleResource.getResource().getResourceType().name() + "_" + id;
                return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.BUNDLE, bundleUrl, new DirectWrappers.ResourceWrapperDirect(this.context, bundleResource.getResource()));
            }
            Element bundleElement = this.rcontext.resolveElement(url, version);
            if (bundleElement != null) {
                Object bundleUrl = null;
                Element br = bundleElement.getNamedChild("resource", false);
                bundleUrl = br.getChildValue("id") != null ? ("Bundle".equals(br.fhirType()) ? "#" : "#" + br.fhirType() + "_" + br.getChildValue("id")) : "#" + this.fullUrlToAnchor(bundleElement.getChildValue("fullUrl"));
                return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.BUNDLE, (String)bundleUrl, new ElementWrappers.ResourceWrapperMetaElement(this.context, br));
            }
        }
        if ((ae = this.getContext().getWorker().fetchResource(null, url, version)) != null) {
            return new Resolver.ResourceWithReference(Resolver.ResourceReferenceKind.EXTERNAL, url, new DirectWrappers.ResourceWrapperDirect(this.context, (Resource)ae));
        }
        if (this.context.getResolver() != null) {
            return this.context.getResolver().resolve(this.context, url);
        }
        return null;
    }

    protected String makeIdFromBundleEntry(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("urn:uuid:")) {
            return url.substring(9).toLowerCase();
        }
        return this.fullUrlToAnchor(url);
    }

    private String fullUrlToAnchor(String url) {
        return url.replace(":", "").replace("/", "_");
    }

    protected void generateCopyright(XhtmlNode x, CanonicalResource cs) {
        XhtmlNode p = x.para();
        p.b().tx(this.getContext().formatPhrase("RESOURCE_COPYRIGHT", new Object[0]));
        this.smartAddText(p, " " + cs.getCopyright());
    }

    public String displayReference(Resource res, Reference r) throws UnsupportedEncodingException, IOException {
        return this.context.formatPhrase("GENERAL_TODO", new Object[0]);
    }

    public Base parseType(String string, String type) {
        return null;
    }

    protected BaseWrappers.PropertyWrapper getProperty(BaseWrappers.ResourceWrapper res, String name) {
        for (BaseWrappers.PropertyWrapper t : res.children()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected BaseWrappers.PropertyWrapper getProperty(BaseWrappers.BaseWrapper res, String name) {
        for (BaseWrappers.PropertyWrapper t : res.children()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected boolean valued(BaseWrappers.PropertyWrapper pw) {
        return pw != null && pw.hasValues();
    }

    protected BaseWrappers.ResourceWrapper fetchResource(BaseWrappers.BaseWrapper subject) throws UnsupportedEncodingException, FHIRException, IOException {
        if (this.context.getResolver() == null) {
            return null;
        }
        BaseWrappers.PropertyWrapper ref = subject.getChildByName("reference");
        if (ref == null || !ref.hasValues()) {
            return null;
        }
        String url = ref.value().getBase().primitiveValue();
        Resolver.ResourceWithReference rr = this.context.getResolver().resolve(this.context, url);
        return rr == null ? null : rr.getResource();
    }

    protected String describeStatus(Enumerations.PublicationStatus status, boolean experimental) {
        switch (status) {
            case ACTIVE: {
                return experimental ? this.context.formatPhrase("GENERAL_EXPER", new Object[0]) : this.context.formatPhrase("RES_REND_ACT", new Object[0]);
            }
            case DRAFT: {
                return this.context.formatPhrase("RES_REND_DRAFT", new Object[0]);
            }
            case RETIRED: {
                return this.context.formatPhrase("RES_REND_RET", new Object[0]);
            }
        }
        return this.context.formatPhrase("RES_REND_UNKNOWN", new Object[0]);
    }

    protected void renderCommitteeLink(XhtmlNode x, CanonicalResource cr) {
        String code = ToolingExtensions.readStringExtension((DomainResource)cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        CodeSystem cs = this.context.getWorker().fetchCodeSystem("http://terminology.hl7.org/CodeSystem/hl7-work-group");
        if (cs == null || !cs.hasWebPath()) {
            x.tx(code);
        } else {
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.findCode(cs.getConcept(), code);
            if (cd == null) {
                x.tx(code);
            } else {
                x.ah(cs.getWebPath() + "#" + cs.getId() + "-" + cd.getCode()).tx(cd.getDisplay());
            }
        }
    }

    public static String makeInternalBundleLink(String fullUrl) {
        return fullUrl.replace(":", "-");
    }

    public boolean canRender(Resource resource) {
        return true;
    }

    protected void renderResourceHeader(BaseWrappers.ResourceWrapper r, XhtmlNode x, boolean doId) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode div = x.div().style("display: inline-block").style("background-color: #d9e0e7").style("padding: 6px").style("margin: 4px").style("border: 1px solid #8da1b4").style("border-radius: 5px").style("line-height: 60%");
        String id = this.getPrimitiveValue(r, "id");
        if (doId) {
            div.an("hc" + id);
        }
        String lang = this.getPrimitiveValue(r, "language");
        String ir = this.getPrimitiveValue(r, "implicitRules");
        BaseWrappers.BaseWrapper meta = r.getChildByName("meta").hasValues() ? r.getChildByName("meta").getValues().get(0) : null;
        String versionId = this.getPrimitiveValue(meta, "versionId");
        String lastUpdated = this.getPrimitiveValue(meta, "lastUpdated");
        String source = this.getPrimitiveValue(meta, "source");
        if (id != null || lang != null || versionId != null || lastUpdated != null) {
            XhtmlNode p = this.plateStyle(div.para());
            p.tx(this.context.formatPhrase("GENERAL_RESOURCE", new Object[0]));
            p.tx(r.fhirType());
            p.tx(" ");
            if (id != null) {
                p.tx("\"" + id + "\" ");
            }
            if (versionId != null) {
                p.tx(this.context.formatPhrase("GENERAL_VER", new Object[0]) + "\"" + versionId + "\" ");
            }
            if (lastUpdated != null) {
                p.tx(this.context.formatPhrase("RES_REND_UPDATED", new Object[0]) + "\"");
                this.renderDateTime(p, lastUpdated);
                p.tx("\" ");
            }
            if (lang != null) {
                p.tx(" " + this.context.formatPhrase("RES_REND_LANGUAGE", new Object[0]) + "\"" + lang + "\") ");
            }
        }
        if (ir != null) {
            this.plateStyle(div.para()).b().tx(this.context.formatPhrase("RES_REND_SPEC_RULES", new Object[0]) + " " + ir + "!");
        }
        if (source != null) {
            this.plateStyle(div.para()).tx(this.context.formatPhrase("RES_REND_INFO_SOURCE", new Object[0]) + " " + source + "!");
        }
        if (meta != null) {
            BaseWrappers.PropertyWrapper sl;
            BaseWrappers.PropertyWrapper tl;
            BaseWrappers.PropertyWrapper pl = meta.getChildByName("profile");
            if (pl.hasValues()) {
                XhtmlNode p = this.plateStyle(div.para());
                p.tx(Utilities.pluralize((String)this.context.formatPhrase("GENERAL_PROF", new Object[0]), (int)pl.getValues().size()) + ": ");
                boolean first = true;
                for (BaseWrappers.BaseWrapper baseWrapper : pl.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    this.renderCanonical(r, p, baseWrapper.getBase().primitiveValue());
                }
            }
            if ((tl = meta.getChildByName("tag")).hasValues()) {
                XhtmlNode p = this.plateStyle(div.para());
                p.tx(Utilities.pluralize((String)this.context.formatPhrase("RES_REND_TAG", new Object[0]), (int)tl.getValues().size()) + ": ");
                boolean first = true;
                for (BaseWrappers.BaseWrapper bw : tl.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    String system = this.getPrimitiveValue(bw, "system");
                    String version = this.getPrimitiveValue(bw, "version");
                    String code = this.getPrimitiveValue(bw, "system");
                    String display = this.getPrimitiveValue(bw, "system");
                    this.renderCoding(p, new Coding(system, version, code, display));
                }
            }
            if ((sl = meta.getChildByName("security")).hasValues()) {
                XhtmlNode p = this.plateStyle(div.para());
                p.tx(Utilities.pluralize((String)this.context.formatPhrase("GENERAL_SECURITY_LABEL", new Object[0]), (int)tl.getValues().size()) + ": ");
                boolean bl = true;
                for (BaseWrappers.BaseWrapper bw : sl.getValues()) {
                    boolean bl2;
                    if (bl2) {
                        bl2 = false;
                    } else {
                        p.tx(", ");
                    }
                    String system = this.getPrimitiveValue(bw, "system");
                    String version = this.getPrimitiveValue(bw, "version");
                    String code = this.getPrimitiveValue(bw, "system");
                    String display = this.getPrimitiveValue(bw, "system");
                    this.renderCoding(p, new Coding(system, version, code, display));
                }
            }
        }
    }

    private XhtmlNode plateStyle(XhtmlNode para) {
        return para.style("margin-bottom: 0px");
    }

    private String getPrimitiveValue(BaseWrappers.BaseWrapper b, String name) throws UnsupportedEncodingException, FHIRException, IOException {
        return b != null && b.has(name) && b.getChildByName(name).hasValues() ? b.getChildByName(name).getValues().get(0).getBase().primitiveValue() : null;
    }

    private String getPrimitiveValue(BaseWrappers.ResourceWrapper r, String name) throws UnsupportedEncodingException, FHIRException, IOException {
        return r.has(name) && r.getChildByName(name).hasValues() ? r.getChildByName(name).getValues().get(0).getBase().primitiveValue() : null;
    }

    public void renderOrError(DomainResource dr) {
        try {
            this.render(dr);
        }
        catch (Exception e) {
            XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
            x.para().tx(this.context.formatPhrase("RES_REND_ERROR", new Object[]{e.getMessage()}) + " ");
            dr.setText(null);
            this.inject(dr, x, Narrative.NarrativeStatus.GENERATED);
        }
    }

    public RendererType getRendererType() {
        return RendererType.NATIVE;
    }

    public void renderTable(TableData provider, XhtmlNode x) throws FHIRFormatError, DefinitionException, IOException {
        ArrayList<String> columns = new ArrayList<String>();
        for (String name : provider.getColumns()) {
            boolean hasData = false;
            for (TableRowData row : provider.getRows()) {
                if (!row.hasCol(name)) continue;
                hasData = true;
            }
            if (!hasData) continue;
            columns.add(name);
        }
        if (columns.size() > 0) {
            XhtmlNode table = x.table("grid");
            if (provider.getTitle() != null) {
                table.tr().td().colspan(columns.size()).b().tx(provider.getTitle());
            }
            XhtmlNode tr = table.tr();
            for (String col : columns) {
                tr.th().b().tx(col);
            }
            for (TableRowData row : provider.getRows()) {
                tr = table.tr();
                for (String col : columns) {
                    XhtmlNode td = tr.td();
                    boolean first = true;
                    List<DataType> list = row.get(col);
                    if (list == null) continue;
                    for (DataType value : list) {
                        if (first) {
                            first = false;
                        } else {
                            td.tx(", ");
                        }
                        this.render(td, value);
                    }
                }
            }
        }
    }

    public void markLanguage(XhtmlNode x) {
        x.setAttribute("lang", this.context.getLocale().toString());
        x.setAttribute("xml:lang", this.context.getLocale().toString());
        x.addTag(0, "hr");
        x.addTag(0, "p").b().tx(this.context.getLocale().getDisplayName());
        x.addTag(0, "hr");
    }

    public class TableData {
        private String title;
        private List<String> columns = new ArrayList<String>();
        private List<TableRowData> rows = new ArrayList<TableRowData>();

        public TableData(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<TableRowData> getRows() {
            return this.rows;
        }

        public void addColumn(String name) {
            this.columns.add(name);
        }

        public TableRowData addRow() {
            TableRowData res = new TableRowData();
            this.rows.add(res);
            res.data = this;
            return res;
        }
    }

    public class TableRowData {
        private Map<String, List<DataType>> cols = new HashMap<String, List<DataType>>();
        private TableData data;

        public void value(String name, DataType value) {
            if (!this.cols.containsKey(name)) {
                this.cols.put(name, new ArrayList());
            }
            if (!this.data.columns.contains(name)) {
                this.data.columns.add(name);
            }
            this.cols.get(name).add(value);
        }

        public boolean hasCol(String name) {
            return this.cols.containsKey(name);
        }

        public List<DataType> get(String name) {
            return this.cols.get(name);
        }
    }

    public static enum RendererType {
        NATIVE,
        PROFILE,
        LIQUID;

    }
}

