/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.expansion;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.LanguageUtils;
import org.hl7.fhir.r5.extensions.ExtensionsUtils;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Factory;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.expansion.AllConceptsFilter;
import org.hl7.fhir.r5.terminologies.expansion.ConceptFilter;
import org.hl7.fhir.r5.terminologies.expansion.EFinished;
import org.hl7.fhir.r5.terminologies.expansion.ETooCostly;
import org.hl7.fhir.r5.terminologies.expansion.KnownPropertyFilter;
import org.hl7.fhir.r5.terminologies.expansion.PropertyFilter;
import org.hl7.fhir.r5.terminologies.expansion.RegexFilter;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.expansion.WorkingContext;
import org.hl7.fhir.r5.terminologies.providers.CodeSystemProvider;
import org.hl7.fhir.r5.terminologies.providers.CodeSystemProviderExtension;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyOperationContext;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValueSetProcessBase;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.AcceptLanguageHeader;

public class ValueSetExpander
extends ValueSetProcessBase {
    private static final boolean REPORT_VERSION_ANYWAY = true;
    private ValueSet focus;
    private List<String> allErrors = new ArrayList<String>();
    private int maxExpansionSize = 1000;
    private WorkingContext dwc = new WorkingContext();
    private boolean checkCodesWhenExpanding;
    private boolean includeAbstract = true;
    private boolean debug;
    private AcceptLanguageHeader langs;
    private List<Token> designations = new ArrayList<Token>();

    public ValueSetExpander(IWorkerContext context, TerminologyOperationContext opContext) {
        super(context, opContext);
    }

    public ValueSetExpander(IWorkerContext context, TerminologyOperationContext opContext, List<String> allErrors) {
        super(context, opContext);
        this.allErrors = allErrors;
    }

    public void setMaxExpansionSize(int theMaxExpansionSize) {
        this.maxExpansionSize = theMaxExpansionSize;
    }

    private ValueSet.ValueSetExpansionContainsComponent addCode(WorkingContext wc, String system, String code, String display, String dispLang, ValueSet.ValueSetExpansionContainsComponent parent, List<CodeSystem.ConceptDefinitionDesignationComponent> designations, Parameters expParams, boolean isAbstract, boolean inactive, List<ValueSet> filters, boolean noInactive, boolean deprecated, List<ValueSet.ValueSetExpansionPropertyComponent> vsProp, List<CodeSystem.ConceptPropertyComponent> csProps, CodeSystem cs, List<ValueSet.ConceptPropertyComponent> expProps, List<Extension> csExtList, List<Extension> vsExtList, ValueSet.ValueSetExpansionComponent exp, boolean countToTotal) throws ETooCostly {
        this.opContext.deadCheck();
        if (filters != null && !filters.isEmpty() && !this.filterContainsCode(filters, system, code, exp)) {
            return null;
        }
        if (noInactive && inactive) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(system);
        n.setCode(code);
        if (isAbstract) {
            n.setAbstract(true);
        }
        if (inactive) {
            n.setInactive(true);
        }
        if (deprecated) {
            ValueSetUtilities.setDeprecated(vsProp, n);
        }
        if (ExtensionsUtils.hasExtension(csExtList, "http://hl7.org/fhir/StructureDefinition/codesystem-label")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#label", "label", ExtensionsUtils.getExtensionValue(csExtList, "http://hl7.org/fhir/StructureDefinition/codesystem-label"));
        }
        if (ExtensionsUtils.hasExtension(vsExtList, "http://hl7.org/fhir/StructureDefinition/valueset-label")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#label", "label", ExtensionsUtils.getExtensionValue(vsExtList, "http://hl7.org/fhir/StructureDefinition/valueset-label"));
        }
        if (ExtensionsUtils.hasExtension(csExtList, "http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#order", "order", this.convertToDecimal(ExtensionsUtils.getExtensionValue(csExtList, "http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder")));
        }
        if (ExtensionsUtils.hasExtension(vsExtList, "http://hl7.org/fhir/StructureDefinition/valueset-conceptOrder")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#order", "order", this.convertToDecimal(ExtensionsUtils.getExtensionValue(vsExtList, "http://hl7.org/fhir/StructureDefinition/valueset-conceptOrder")));
        }
        if (ExtensionsUtils.hasExtension(csExtList, "http://hl7.org/fhir/StructureDefinition/itemWeight")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#itemWeight", "weight", ExtensionsUtils.getExtensionValue(csExtList, "http://hl7.org/fhir/StructureDefinition/itemWeight"));
        }
        if (ExtensionsUtils.hasExtension(vsExtList, "http://hl7.org/fhir/StructureDefinition/itemWeight")) {
            ValueSetUtilities.addProperty(this.focus, n, "http://hl7.org/fhir/concept-properties#itemWeight", "weight", ExtensionsUtils.getExtensionValue(vsExtList, "http://hl7.org/fhir/StructureDefinition/itemWeight"));
        }
        ExtensionsUtils.copyExtensions(csExtList, n.getExtension(), "http://hl7.org/fhir/StructureDefinition/coding-sctdescid", "http://hl7.org/fhir/StructureDefinition/rendering-style", "http://hl7.org/fhir/StructureDefinition/rendering-xhtml", "http://hl7.org/fhir/StructureDefinition/codesystem-alternate");
        ExtensionsUtils.copyExtensions(vsExtList, n.getExtension(), "http://hl7.org/fhir/StructureDefinition/valueset-supplement", "http://hl7.org/fhir/StructureDefinition/valueset-deprecated", "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition", "http://hl7.org/fhir/StructureDefinition/coding-sctdescid", "http://hl7.org/fhir/StructureDefinition/rendering-style", "http://hl7.org/fhir/StructureDefinition/rendering-xhtml");
        CodeSystem.ConceptDefinitionDesignationComponent pref = null;
        if (this.langs == null) {
            n.setDisplay(display);
        } else {
            if (designations == null) {
                designations = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
            }
            designations.add(new CodeSystem.ConceptDefinitionDesignationComponent().setLanguage(dispLang).setValue(display).setUse(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/designation-usage").setCode("display")));
            pref = this.findMatchingDesignation(designations);
            if (pref != null) {
                n.setDisplay(pref.getValue());
            }
        }
        if (expParams.getParameterBool("includeDesignations") && designations != null) {
            for (CodeSystem.ConceptDefinitionDesignationComponent t : designations) {
                if (t == pref || !t.hasLanguage() && !t.hasUse() || t.getValue() == null || !this.passesDesignationFilter(t)) continue;
                ValueSet.ConceptReferenceDesignationComponent d = n.addDesignation();
                if (t.getLanguage() != null) {
                    d.setLanguage(t.getLanguage().trim());
                }
                if (t.getValue() != null) {
                    d.setValue(t.getValue().trim());
                }
                if (t.getUse() != null) {
                    d.setUse(t.getUse());
                }
                for (Extension ext : t.getExtension()) {
                    if (!Utilities.existsInList((String)ext.getUrl(), (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/coding-sctdescid"})) continue;
                    d.addExtension(ext);
                }
            }
        }
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            if (!"property".equals(p.getName())) continue;
            if (csProps != null && p.hasValue()) {
                for (CodeSystem.ConceptPropertyComponent conceptPropertyComponent : csProps) {
                    String url;
                    if (!p.getValue().primitiveValue().equals(conceptPropertyComponent.getCode())) continue;
                    CodeSystem.PropertyComponent pd = cs.getProperty(conceptPropertyComponent.getCode());
                    String string = url = pd == null ? null : pd.getUri();
                    if (url == null && "definition".equals(conceptPropertyComponent.getCode())) {
                        url = "http://hl7.org/fhir/concept-properties#definition";
                    }
                    ValueSetUtilities.addProperty(this.focus, n, url, conceptPropertyComponent.getCode(), conceptPropertyComponent.getValue()).copyExtensions(conceptPropertyComponent, "http://hl7.org/fhir/StructureDefinition/alternate-code-use", "http://hl7.org/fhir/StructureDefinition/alternate-code-status");
                }
            }
            if (expProps == null || !p.hasValue()) continue;
            for (ValueSet.ConceptPropertyComponent conceptPropertyComponent : expProps) {
                if (!p.getValue().primitiveValue().equals(conceptPropertyComponent.getCode())) continue;
                String url = null;
                for (ValueSet.ValueSetExpansionPropertyComponent t : vsProp) {
                    if (!t.hasCode() || !t.getCode().equals(conceptPropertyComponent.getCode())) continue;
                    url = t.getUri();
                }
                if (url == null && "definition".equals(conceptPropertyComponent.getCode())) {
                    url = "http://hl7.org/fhir/concept-properties#definition";
                }
                ValueSetUtilities.addProperty(this.focus, n, url, conceptPropertyComponent.getCode(), conceptPropertyComponent.getValue()).copyExtensions(conceptPropertyComponent, "http://hl7.org/fhir/StructureDefinition/alternate-code-use", "http://hl7.org/fhir/StructureDefinition/alternate-code-status");
            }
        }
        String s = this.key(n);
        if (wc.getMap().containsKey(s) || wc.getExcludeKeys().contains(s)) {
            wc.setCanBeHierarchy(false);
        } else {
            wc.getCodes().add(n);
            wc.getMap().put(s, n);
            if (countToTotal) {
                wc.incTotal();
            }
        }
        if (wc.isCanBeHierarchy() && parent != null) {
            parent.getContains().add(n);
        } else if (!wc.getRootMap().containsKey(s)) {
            wc.getRootMap().put(s, n);
            wc.getRoots().add(n);
        }
        return n;
    }

    private DataType convertToDecimal(DataType v) {
        if (v == null) {
            return null;
        }
        if (v instanceof DecimalType) {
            return v;
        }
        if (v instanceof IntegerType) {
            return new DecimalType(((IntegerType)v).asStringValue());
        }
        return null;
    }

    private boolean passesDesignationFilter(CodeSystem.ConceptDefinitionDesignationComponent d) {
        if (this.designations.isEmpty()) {
            return true;
        }
        for (Token t : this.designations) {
            if (t.matches(d.getUse()) || t.matchesLang(d.getLanguage())) {
                return true;
            }
            for (Coding c : d.getAdditionalUse()) {
                if (!t.matches(c)) continue;
                return true;
            }
        }
        return false;
    }

    private CodeSystem.ConceptDefinitionDesignationComponent findMatchingDesignation(List<CodeSystem.ConceptDefinitionDesignationComponent> designations) {
        if (this.langs == null) {
            return null;
        }
        for (AcceptLanguageHeader.LanguagePreference lang : this.langs.getLangs()) {
            if (!(lang.getValue() > 0.0)) continue;
            for (CodeSystem.ConceptDefinitionDesignationComponent cd : designations) {
                if (!this.isDisplay(cd) || !LanguageUtils.langsMatchExact(cd.getLanguage(), lang.getLang())) continue;
                return cd;
            }
            for (CodeSystem.ConceptDefinitionDesignationComponent cd : designations) {
                if (!this.isDisplay(cd) || !LanguageUtils.langsMatch(cd.getLanguage(), lang.getLang())) continue;
                return cd;
            }
            for (CodeSystem.ConceptDefinitionDesignationComponent cd : designations) {
                if (!LanguageUtils.langsMatchExact(cd.getLanguage(), lang.getLang())) continue;
                return cd;
            }
            for (CodeSystem.ConceptDefinitionDesignationComponent cd : designations) {
                if (!LanguageUtils.langsMatch(cd.getLanguage(), lang.getLang())) continue;
                return cd;
            }
        }
        return null;
    }

    private boolean isDisplay(CodeSystem.ConceptDefinitionDesignationComponent cd) {
        return cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display");
    }

    private boolean filterContainsCode(List<ValueSet> filters, String system, String code, ValueSet.ValueSetExpansionComponent exp) {
        for (ValueSet vse : filters) {
            this.checkCanonical(exp, vse, this.focus);
            if (!this.expansionContainsCode(vse.getExpansion().getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean expansionContainsCode(List<ValueSet.ValueSetExpansionContainsComponent> contains, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (system.equals(cc.getSystem()) && code.equals(cc.getCode())) {
                return true;
            }
            if (!this.expansionContainsCode(cc.getContains(), system, code)) continue;
            return true;
        }
        return false;
    }

    private CodeSystem.ConceptDefinitionDesignationComponent getMatchingLang(List<CodeSystem.ConceptDefinitionDesignationComponent> list, AcceptLanguageHeader langs) {
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!LanguageUtils.langsMatchExact(langs, t.getLanguage())) continue;
            return t;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : list) {
            if (!LanguageUtils.langsMatch(langs, t.getLanguage())) continue;
            return t;
        }
        return null;
    }

    private void addCodeAndDescendents(WorkingContext wc, ValueSet.ValueSetExpansionContainsComponent focus, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filters, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps, ValueSet vsSrc, ValueSet.ValueSetExpansionComponent exp, boolean countToTotal) throws FHIRException, ETooCostly {
        this.opContext.deadCheck();
        focus.checkNoModifiers("Expansion.contains", "expanding");
        ValueSet.ValueSetExpansionContainsComponent np = null;
        for (String code : this.getCodesForConcept(focus, expParams)) {
            ValueSet.ValueSetExpansionContainsComponent t = this.addCode(wc, focus.getSystem(), code, focus.getDisplay(), vsSrc.getLanguage(), parent, this.convert(focus.getDesignation()), expParams, focus.getAbstract(), focus.getInactive(), filters, noInactive, false, vsProps, this.makeCSProps(focus.getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"), null), null, focus.getProperty(), null, focus.getExtension(), exp, countToTotal);
            if (np != null) continue;
            np = t;
        }
        for (ValueSet.ValueSetExpansionContainsComponent c : focus.getContains()) {
            this.addCodeAndDescendents(wc, c, np, expParams, filters, noInactive, vsProps, vsSrc, exp, countToTotal);
        }
    }

    private List<CodeSystem.ConceptPropertyComponent> makeCSProps(String definition, List<CodeSystem.ConceptPropertyComponent> list) {
        ArrayList<CodeSystem.ConceptPropertyComponent> res = new ArrayList<CodeSystem.ConceptPropertyComponent>();
        if (!Utilities.noString((String)definition)) {
            res.add(new CodeSystem.ConceptPropertyComponent("definition", new StringType(definition)));
        }
        if (list != null) {
            res.addAll(list);
        }
        return res;
    }

    private List<String> getCodesForConcept(ValueSet.ValueSetExpansionContainsComponent focus, Parameters expParams) {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(focus.getCode());
        for (ValueSet.ConceptPropertyComponent p : focus.getProperty()) {
            if (!"alternateCode".equals(p.getCode()) || !this.altCodeParams.passes(p.getExtension()) || !p.getValue().isPrimitive()) continue;
            codes.add(p.getValue().primitiveValue());
        }
        return codes;
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convert(List<ValueSet.ConceptReferenceDesignationComponent> designations) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> list = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent d : designations) {
            CodeSystem.ConceptDefinitionDesignationComponent n = new CodeSystem.ConceptDefinitionDesignationComponent();
            n.setLanguage(d.getLanguage());
            n.setUse(d.getUse());
            n.setValue(d.getValue());
            list.add(n);
        }
        return list;
    }

    private void addCodeAndDescendents(WorkingContext wc, CodeSystem cs, String system, CodeSystem.ConceptDefinitionComponent def, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filters, CodeSystem.ConceptDefinitionComponent exclusion, ConceptFilter filterFunc, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps, List<WorkingContext> otherFilters, ValueSet.ValueSetExpansionComponent exp) throws FHIRException, ETooCostly {
        this.opContext.deadCheck();
        def.checkNoModifiers("Code in Code System", "expanding");
        if (exclusion != null && exclusion.getCode().equals(def.getCode())) {
            return;
        }
        ValueSet.ValueSetExpansionContainsComponent np = null;
        boolean abs = CodeSystemUtilities.isNotSelectable(cs, def);
        boolean inc = CodeSystemUtilities.isInactive(cs, def);
        boolean dep = CodeSystemUtilities.isDeprecated(cs, def, false);
        if ((this.includeAbstract || !abs) && filterFunc.includeConcept(cs, def) && this.passesOtherFilters(otherFilters, cs, def.getCode())) {
            for (String code : this.getCodesForConcept(def, expParams)) {
                ValueSet.ValueSetExpansionContainsComponent t = this.addCode(wc, system, code, def.getDisplay(), cs.getLanguage(), parent, def.getDesignation(), expParams, abs, inc, filters, noInactive, dep, vsProps, this.makeCSProps(def.getDefinition(), def.getProperty()), cs, null, def.getExtension(), null, exp, true);
                if (np != null) continue;
                np = t;
            }
        }
        for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
            this.addCodeAndDescendents(wc, cs, system, c, np, expParams, filters, exclusion, filterFunc, noInactive, vsProps, otherFilters, exp);
        }
        if (def.hasUserData("cs.utils.cross.link")) {
            List children = (List)def.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                this.addCodeAndDescendents(wc, cs, system, c, np, expParams, filters, exclusion, filterFunc, noInactive, vsProps, otherFilters, exp);
            }
        }
    }

    private void excludeCodeAndDescendents(WorkingContext wc, CodeSystem cs, String system, CodeSystem.ConceptDefinitionComponent def, Parameters expParams, List<ValueSet> filters, CodeSystem.ConceptDefinitionComponent exclusion, ConceptFilter filterFunc, List<WorkingContext> otherFilters, ValueSet.ValueSetExpansionComponent exp) throws FHIRException, ETooCostly {
        this.opContext.deadCheck();
        def.checkNoModifiers("Code in Code System", "expanding");
        if (exclusion != null && exclusion.getCode().equals(def.getCode())) {
            return;
        }
        boolean abs = CodeSystemUtilities.isNotSelectable(cs, def);
        if ((this.includeAbstract || !abs) && filterFunc.includeConcept(cs, def) && this.passesOtherFilters(otherFilters, cs, def.getCode())) {
            for (String code : this.getCodesForConcept(def, expParams)) {
                if (filters != null && !filters.isEmpty() && !this.filterContainsCode(filters, system, code, exp)) continue;
                this.excludeCode(wc, system, code);
            }
        }
        for (CodeSystem.ConceptDefinitionComponent c : def.getConcept()) {
            this.excludeCodeAndDescendents(wc, cs, system, c, expParams, filters, exclusion, filterFunc, otherFilters, exp);
        }
        if (def.hasUserData("cs.utils.cross.link")) {
            List children = (List)def.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                this.excludeCodeAndDescendents(wc, cs, system, c, expParams, filters, exclusion, filterFunc, otherFilters, exp);
            }
        }
    }

    private List<String> getCodesForConcept(CodeSystem.ConceptDefinitionComponent focus, Parameters expParams) {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(focus.getCode());
        for (CodeSystem.ConceptPropertyComponent p : focus.getProperty()) {
            if (!"alternateCode".equals(p.getCode()) || !this.altCodeParams.passes(p.getExtension()) || !p.getValue().isPrimitive()) continue;
            codes.add(p.getValue().primitiveValue());
        }
        return codes;
    }

    private static boolean hasUse(CodeSystem.ConceptPropertyComponent p, List<String> uses) {
        for (Extension ext : p.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/alternate-code-use")) {
            if (!ext.hasValueCoding() || !Utilities.existsInList((String)ext.getValueCoding().getCode(), uses)) continue;
            return true;
        }
        return false;
    }

    private void addCodes(ValueSet.ValueSetExpansionComponent expand, List<ValueSet.ValueSetExpansionParameterComponent> params, Parameters expParams, List<ValueSet> filters, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps, ValueSet vsSrc, ValueSet.ValueSetExpansionComponent exp) throws ETooCostly, FHIRException {
        if (expand != null) {
            if (expand.getContains().size() > this.maxExpansionSize) {
                throw this.failCostly(this.context.formatMessage("VALUESET_TOO_COSTLY", vsSrc.getUrl(), ">" + Integer.toString(expand.getContains().size())));
            }
            for (ValueSet.ValueSetExpansionParameterComponent p : expand.getParameter()) {
                if (this.existsInParams(params, p.getName(), p.getValue())) continue;
                params.add(p);
            }
            this.copyImportContains(expand.getContains(), null, expParams, filters, noInactive, vsProps, vsSrc, exp);
        }
    }

    private void excludeCode(WorkingContext wc, String theSystem, String theCode) {
        ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
        n.setSystem(theSystem);
        n.setCode(theCode);
        String s = this.key(n);
        wc.getExcludeKeys().add(s);
    }

    private void excludeCodes(WorkingContext wc, ValueSet.ConceptSetComponent exc, Parameters expParams, ValueSet.ValueSetExpansionComponent exp, ValueSet vs) throws FHIRException, FileNotFoundException, ETooCostly, IOException {
        this.opContext.deadCheck();
        exc.checkNoModifiers("Compose.exclude", "expanding");
        if (exc.hasSystem() && exc.getConcept().size() == 0 && exc.getFilter().size() == 0) {
            wc.getExcludeSystems().add(exc.getSystem());
        }
        for (UriType uriType : exc.getValueSet()) {
            this.excludeCodes(wc, this.importValueSetForExclude(wc, (String)uriType.getValue(), exp, expParams, false, vs).getExpansion());
        }
        CodeSystem cs = this.context.fetchSupplementedCodeSystem(exc.getSystem());
        if ((cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE) && this.context.supportsSystem(exc.getSystem(), this.opContext.getOptions().getFhirVersion())) {
            ValueSetExpansionOutcome valueSetExpansionOutcome = this.context.expandVS(exc, false, false);
            ValueSet valueset = valueSetExpansionOutcome.getValueset();
            if (valueset == null) {
                throw this.failTSE("Error Expanding ValueSet: " + valueSetExpansionOutcome.getError());
            }
            this.excludeCodes(wc, valueset.getExpansion());
            return;
        }
        for (ValueSet.ConceptReferenceComponent c : exc.getConcept()) {
            this.excludeCode(wc, exc.getSystem(), c.getCode());
        }
        if (exc.getFilter().size() > 0) {
            WorkingContext wc1;
            if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                this.addFragmentWarning(exp, cs);
            }
            ArrayList<WorkingContext> arrayList = new ArrayList<WorkingContext>();
            for (int i = 1; i < exc.getFilter().size(); ++i) {
                wc1 = new WorkingContext();
                arrayList.add(wc1);
                this.processFilter(exc, exp, expParams, null, cs, false, exc.getFilter().get(i), wc1, null, true);
            }
            ValueSet.ConceptSetFilterComponent fc = exc.getFilter().get(0);
            wc1 = this.dwc;
            this.processFilter(exc, exp, expParams, null, cs, false, fc, wc1, arrayList, true);
        }
    }

    private void excludeCodes(WorkingContext wc, ValueSet.ValueSetExpansionComponent expand) {
        this.opContext.deadCheck();
        for (ValueSet.ValueSetExpansionContainsComponent c : expand.getContains()) {
            this.excludeCode(wc, c.getSystem(), c.getCode());
        }
    }

    private boolean existsInParams(List<ValueSet.ValueSetExpansionParameterComponent> params, String name, DataType value) {
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            if (!p.getName().equals(name) || !PrimitiveType.compareDeep(p.getValue(), value, false)) continue;
            return true;
        }
        return false;
    }

    public ValueSetExpansionOutcome expand(ValueSet source, Parameters expParams) {
        this.allErrors.clear();
        try {
            this.opContext.seeContext(source.getVersionedUrl());
            return this.expandInternal(source, expParams);
        }
        catch (NoTerminologyServiceException e) {
            return new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.NOSERVICE, this.allErrors, false);
        }
        catch (CodeSystemProviderExtension e) {
            return new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.INTERNAL_ERROR, this.allErrors, false);
        }
        catch (TerminologyOperationContext.TerminologyServiceProtectionException e) {
            if (this.opContext.isOriginal()) {
                return new ValueSetExpansionOutcome(e.getMessage(), e.getError(), this.allErrors, false);
            }
            throw e;
        }
        catch (ETooCostly e) {
            return new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.TOO_COSTLY, this.allErrors, false);
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.UNKNOWN, this.allErrors, e instanceof EFhirClientException || e instanceof TerminologyServiceException);
        }
    }

    public ValueSetExpansionOutcome expandInternal(ValueSet source, Parameters expParams) throws FHIRException, FileNotFoundException, ETooCostly, IOException, CodeSystemProviderExtension {
        return this.doExpand(source, expParams);
    }

    private void processParameter(String name, DataType value) {
        if (Utilities.existsInList((String)name, (String[])new String[]{"includeDesignations", "excludeNested", "activeOnly", "offset", "count"})) {
            this.focus.getExpansion().getParameter().removeIf(p -> p.getName().equals(name));
            this.focus.getExpansion().addParameter().setName(name).setValue(value);
        }
        if ("displayLanguage".equals(name)) {
            this.langs = new AcceptLanguageHeader(value.primitiveValue(), true);
            this.focus.getExpansion().getParameter().removeIf(p -> p.getName().equals(name));
            this.focus.getExpansion().addParameter().setName(name).setValue(new CodeType(value.primitiveValue()));
        }
        if ("designation".equals(name)) {
            String[] v = value.primitiveValue().split("\\|");
            if (v.length != 2 || !Utilities.isAbsoluteUrl((String)v[0]) || Utilities.noString((String)v[1])) {
                throw new NoTerminologyServiceException("Unable to understand designation parameter " + value.primitiveValue());
            }
            this.designations.add(new Token(v[0], v[1]));
            this.focus.getExpansion().addParameter().setName(name).setValue(new StringType(value.primitiveValue()));
        }
        if ("offset".equals(name) && value instanceof IntegerType) {
            this.focus.getExpansion().getParameter().removeIf(p -> p.getName().equals(name));
            this.focus.getExpansion().addParameter().setName(name).setValue(value);
            this.dwc.setOffsetParam((Integer)((IntegerType)value).getValue());
            if (this.dwc.getOffsetParam() < 0) {
                this.dwc.setOffsetParam(0);
            }
        }
        if ("count".equals(name)) {
            this.focus.getExpansion().getParameter().removeIf(p -> p.getName().equals(name));
            this.focus.getExpansion().addParameter().setName(name).setValue(value);
            this.dwc.setCountParam((Integer)((IntegerType)value).getValue());
            if (this.dwc.getCountParam() < 0) {
                this.dwc.setCountParam(0);
            }
        }
    }

    public ValueSetExpansionOutcome doExpand(ValueSet source, Parameters expParams) throws FHIRException, ETooCostly, FileNotFoundException, IOException, CodeSystemProviderExtension {
        if (expParams == null) {
            expParams = this.makeDefaultExpansion();
        }
        this.altCodeParams.seeParameters(expParams);
        this.altCodeParams.seeValueSet(source);
        source.checkNoModifiers("ValueSet", "expanding");
        this.focus = source.copy();
        this.focus.setIdBase(null);
        this.focus.setExpansion(new ValueSet.ValueSetExpansionComponent());
        this.focus.getExpansion().setTimestampElement(DateTimeType.now());
        this.focus.getExpansion().setIdentifier(Factory.createUUID());
        this.checkCanonical(this.focus.getExpansion(), this.focus, this.focus);
        for (Extension ext : this.focus.getCompose().getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinion/valueset-expansion-param")) {
            this.processParameter(ext.getExtensionString("name"), ext.getExtensionByUrl("value").getValue());
        }
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            this.processParameter(p.getName(), p.getValue());
        }
        for (Extension s : this.focus.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-supplement")) {
            this.requiredSupplements.add(s.getValue().primitiveValue());
        }
        if (this.langs == null && this.focus.hasLanguage()) {
            this.langs = new AcceptLanguageHeader(this.focus.getLanguage(), true);
        }
        try {
            if (source.hasCompose()) {
                this.handleCompose(source.getCompose(), this.focus.getExpansion(), expParams, source.getUrl(), this.focus.getExpansion().getExtension(), source);
            }
        }
        catch (EFinished eFinished) {
            // empty catch block
        }
        if (this.dwc.getTotal() > this.maxExpansionSize && this.dwc.getOffsetParam() + this.dwc.getCountParam() == 0) {
            if (this.dwc.isNoTotal()) {
                throw this.failCostly(this.context.formatMessage("VALUESET_TOO_COSTLY", this.focus.getVersionedUrl(), ">" + MessageFormat.format("{0,number,#}", this.maxExpansionSize)));
            }
            throw this.failCostly(this.context.formatMessage("VALUESET_TOO_COSTLY_COUNT", this.focus.getVersionedUrl(), ">" + MessageFormat.format("{0,number,#}", this.maxExpansionSize), MessageFormat.format("{0,number,#}", this.dwc.getTotal())));
        }
        if (this.dwc.isCanBeHierarchy() && (this.dwc.getCountParam() == 0 || this.dwc.getCountParam() > this.dwc.getCodes().size())) {
            for (ValueSet.ValueSetExpansionContainsComponent c : this.dwc.getRoots()) {
                this.focus.getExpansion().getContains().add(c);
            }
        } else {
            int i = 0;
            int cc = 0;
            for (ValueSet.ValueSetExpansionContainsComponent c : this.dwc.getCodes()) {
                c.getContains().clear();
                if (!this.dwc.getMap().containsKey(this.key(c)) || !this.includeAbstract && c.getAbstract()) continue;
                if (this.dwc.getOffsetParam() == 0 || i >= this.dwc.getOffsetParam()) {
                    this.focus.getExpansion().getContains().add(c);
                    if (++cc == this.dwc.getCountParam()) break;
                }
                ++i;
            }
        }
        if (this.dwc.hasOffsetParam()) {
            this.focus.getExpansion().setOffset(this.dwc.getOffsetParam());
        }
        if (!this.dwc.isNoTotal()) {
            this.focus.getExpansion().setTotal(this.dwc.getTotal());
        }
        if (!this.requiredSupplements.isEmpty()) {
            return new ValueSetExpansionOutcome(this.context.formatMessagePlural(this.requiredSupplements.size(), "VALUESET_SUPPLEMENT_MISSING", CommaSeparatedStringBuilder.build((List)this.requiredSupplements)), TerminologyServiceErrorClass.BUSINESS_RULE, this.allErrors, false);
        }
        if (!expParams.hasParameter("includeDefinition") || !expParams.getParameterBool("includeDefinition")) {
            this.focus.setCompose(null);
            this.focus.getExtension().clear();
            this.focus.setPublisher(null);
            this.focus.setDescription(null);
            this.focus.setPurpose(null);
            this.focus.getContact().clear();
            this.focus.setCopyright(null);
            this.focus.setText(null);
        }
        return new ValueSetExpansionOutcome(this.focus);
    }

    private Parameters makeDefaultExpansion() {
        Parameters res = new Parameters();
        res.addParameter("excludeNested", true);
        res.addParameter("includeDesignations", false);
        return res;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> clist, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : clist) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private void handleCompose(ValueSet.ValueSetComposeComponent compose, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, String ctxt, List<Extension> extensions, ValueSet valueSet) throws ETooCostly, FileNotFoundException, IOException, FHIRException, CodeSystemProviderExtension {
        compose.checkNoModifiers("ValueSet.compose", "expanding");
        for (ValueSet.ConceptSetComponent inc : compose.getExclude()) {
            this.excludeCodes(this.dwc, inc, expParams, exp, valueSet);
        }
        this.dwc.setCanBeHierarchy(!expParams.getParameterBool("excludeNested") && this.dwc.getExcludeKeys().isEmpty() && this.dwc.getExcludeSystems().isEmpty() && this.dwc.getOffsetParam() == 0);
        this.includeAbstract = !expParams.getParameterBool("excludeNotForUI");
        boolean first = true;
        for (ValueSet.ConceptSetComponent inc : compose.getInclude()) {
            if (first) {
                first = false;
            } else {
                this.dwc.setCanBeHierarchy(false);
            }
            this.includeCodes(inc, exp, expParams, this.dwc.isCanBeHierarchy(), compose.hasInactive() ? !compose.getInactive() : this.checkNoInActiveFromParam(expParams), extensions, valueSet);
        }
    }

    private boolean checkNoInActiveFromParam(Parameters expParams) {
        for (Parameters.ParametersParameterComponent p : expParams.getParameter()) {
            if (!p.getName().equals("activeOnly")) continue;
            return (Boolean)p.getValueBooleanType().getValue();
        }
        return false;
    }

    private ValueSet importValueSet(WorkingContext wc, String value, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, boolean noInactive, ValueSet valueSet) throws ETooCostly, TerminologyServiceException, FileNotFoundException, IOException, FHIRFormatError {
        ValueSetExpansionOutcome vso;
        if (value == null) {
            throw this.fail("unable to find value set with no identity");
        }
        ValueSet vs = this.context.findTxResource(ValueSet.class, value, valueSet);
        if (vs == null) {
            if (this.context.fetchResource(CodeSystem.class, value, valueSet) != null) {
                throw this.fail("Cannot include value set " + value + " because it's actually a code system");
            }
            throw this.fail("Unable to find imported value set " + value);
        }
        this.checkCanonical(exp, vs, this.focus);
        if (noInactive) {
            expParams = expParams.copy();
            expParams.addParameter("activeOnly", true);
        }
        if ((vso = new ValueSetExpander(this.context, this.opContext.copy(), this.allErrors).expand(vs, expParams)).getError() != null) {
            this.addErrors(vso.getAllErrors());
            throw this.fail("Unable to expand imported value set " + vs.getUrl() + ": " + vso.getError());
        }
        if (vso.getValueset() == null) {
            throw this.fail("Unable to expand imported value set " + vs.getUrl() + " but no error");
        }
        if (!vs.hasVersion()) {
            // empty if block
        }
        UriType u = new UriType(vs.getUrl() + (String)(vs.hasVersion() ? "|" + vs.getVersion() : ""));
        if (!this.existsInParams(exp.getParameter(), "used-valueset", u)) {
            exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("used-valueset").setValue(u));
        }
        ValueSet.ValueSetExpansionComponent evs = vso.getValueset().getExpansion();
        for (Extension ex : evs.getExtension()) {
            if (!ex.getUrl().equals("http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) continue;
            if (ex.getValue() instanceof BooleanType) {
                exp.getExtension().add(new Extension("http://hl7.org/fhir/StructureDefinition/valueset-toocostly").setValue(new CanonicalType(value)));
                continue;
            }
            exp.getExtension().add(ex);
        }
        if (evs.hasTotal()) {
            this.dwc.incTotal(evs.getTotal());
        } else {
            this.dwc.setNoTotal(true);
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : evs.getParameter()) {
            if (this.existsInParams(exp.getParameter(), p.getName(), p.getValue())) continue;
            exp.getParameter().add(p);
        }
        if (this.isValueSetUnionImports(valueSet)) {
            this.copyExpansion(wc, evs.getContains());
        }
        wc.setCanBeHierarchy(false);
        return vso.getValueset();
    }

    private ValueSet importValueSetForExclude(WorkingContext wc, String value, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, boolean noInactive, ValueSet valueSet) throws ETooCostly, TerminologyServiceException, FileNotFoundException, IOException, FHIRFormatError {
        ValueSetExpansionOutcome vso;
        if (value == null) {
            throw this.fail("unable to find value set with no identity");
        }
        ValueSet vs = this.context.findTxResource(ValueSet.class, value, valueSet);
        if (vs == null) {
            if (this.context.fetchResource(CodeSystem.class, value, valueSet) != null) {
                throw this.fail("Cannot include value set " + value + " because it's actually a code system");
            }
            throw this.fail("Unable to find imported value set " + value);
        }
        this.checkCanonical(exp, vs, this.focus);
        if (noInactive) {
            expParams = expParams.copy();
            expParams.addParameter("activeOnly", true);
        }
        if ((vso = new ValueSetExpander(this.context, this.opContext.copy(), this.allErrors).expand(vs, expParams)).getError() != null) {
            this.addErrors(vso.getAllErrors());
            throw this.fail("Unable to expand imported value set " + vs.getUrl() + ": " + vso.getError());
        }
        if (!vs.hasVersion()) {
            // empty if block
        }
        UriType u = new UriType(vs.getUrl() + (String)(vs.hasVersion() ? "|" + vs.getVersion() : ""));
        if (!this.existsInParams(exp.getParameter(), "used-valueset", u)) {
            exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("used-valueset").setValue(u));
        }
        for (Extension ex : vso.getValueset().getExpansion().getExtension()) {
            if (!ex.getUrl().equals("http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) continue;
            throw this.fail("Unable to expand imported value set " + vs.getUrl() + " for exclude: too costly");
        }
        return vso.getValueset();
    }

    protected boolean isValueSetUnionImports(ValueSet valueSet) {
        PackageInformation p = valueSet.getSourcePackage();
        if (p != null) {
            return p.getDate().before(new GregorianCalendar(2022, 2, 31).getTime());
        }
        return false;
    }

    public void copyExpansion(WorkingContext wc, List<ValueSet.ValueSetExpansionContainsComponent> list) {
        this.opContext.deadCheck();
        for (ValueSet.ValueSetExpansionContainsComponent cc : list) {
            ValueSet.ValueSetExpansionContainsComponent n = new ValueSet.ValueSetExpansionContainsComponent();
            n.setSystem(cc.getSystem());
            n.setCode(cc.getCode());
            n.setAbstract(cc.getAbstract());
            n.setInactive(cc.getInactive());
            n.setDisplay(cc.getDisplay());
            n.getDesignation().addAll(cc.getDesignation());
            String s = this.key(n);
            if (!wc.getMap().containsKey(s) && !wc.getExcludeKeys().contains(s)) {
                wc.getCodes().add(n);
                wc.getMap().put(s, n);
                wc.incTotal();
            }
            this.copyExpansion(wc, cc.getContains());
        }
    }

    private void addErrors(List<String> errs) {
        for (String s : errs) {
            if (this.allErrors.contains(s)) continue;
            this.allErrors.add(s);
        }
    }

    private int copyImportContains(List<ValueSet.ValueSetExpansionContainsComponent> list, ValueSet.ValueSetExpansionContainsComponent parent, Parameters expParams, List<ValueSet> filter, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps, ValueSet vsSrc, ValueSet.ValueSetExpansionComponent exp) throws FHIRException, ETooCostly {
        int count = 0;
        this.opContext.deadCheck();
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            c.checkNoModifiers("Imported Expansion in Code System", "expanding");
            ValueSet.ValueSetExpansionContainsComponent np = this.addCode(this.dwc, c.getSystem(), c.getCode(), c.getDisplay(), vsSrc.getLanguage(), parent, null, expParams, c.getAbstract(), c.getInactive(), filter, noInactive, false, vsProps, this.makeCSProps(c.getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"), null), null, c.getProperty(), null, c.getExtension(), exp, false);
            if (np != null) {
                ++count;
            }
            count += this.copyImportContains(c.getContains(), np, expParams, filter, noInactive, vsProps, vsSrc, exp);
        }
        return count;
    }

    private void includeCodes(ValueSet.ConceptSetComponent inc, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, boolean heirarchical, boolean noInactive, List<Extension> extensions, ValueSet valueSet) throws ETooCostly, FileNotFoundException, IOException, FHIRException, CodeSystemProviderExtension {
        this.opContext.deadCheck();
        inc.checkNoModifiers("Compose.include", "expanding");
        ArrayList<ValueSet> imports = new ArrayList<ValueSet>();
        for (CanonicalType imp : inc.getValueSet()) {
            imports.add(this.importValueSet(this.dwc, (String)imp.getValue(), exp, expParams, noInactive, valueSet));
        }
        if (!inc.hasSystem()) {
            if (imports.isEmpty()) {
                return;
            }
            this.dwc.resetTotal();
            ValueSet base = (ValueSet)imports.get(0);
            this.checkCanonical(exp, base, this.focus);
            imports.remove(0);
            base.checkNoModifiers("Imported ValueSet", "expanding");
            this.dwc.incTotal(this.copyImportContains(base.getExpansion().getContains(), null, expParams, imports, noInactive, base.getExpansion().getProperty(), base, exp));
        } else {
            CodeSystem cs = this.context.fetchSupplementedCodeSystem(inc.getSystem());
            if (ValueSetUtilities.isServerSide(inc.getSystem()) || cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
                this.doServerIncludeCodes(inc, heirarchical, exp, imports, expParams, extensions, noInactive, valueSet.getExpansion().getProperty());
            } else {
                if (cs.hasUserData("supplements.installed")) {
                    for (String s : cs.getUserString("supplements.installed").split("\\,")) {
                        this.requiredSupplements.remove(s);
                    }
                }
                this.doInternalIncludeCodes(inc, exp, expParams, imports, cs, noInactive, valueSet);
            }
        }
    }

    private void doServerIncludeCodes(ValueSet.ConceptSetComponent inc, boolean heirarchical, ValueSet.ValueSetExpansionComponent exp, List<ValueSet> imports, Parameters expParams, List<Extension> extensions, boolean noInactive, List<ValueSet.ValueSetExpansionPropertyComponent> vsProps) throws FHIRException, CodeSystemProviderExtension, ETooCostly {
        this.opContext.deadCheck();
        CodeSystemProvider csp = CodeSystemProvider.factory(inc.getSystem());
        if (csp != null) {
            csp.includeCodes(inc, heirarchical, exp, imports, expParams, extensions, noInactive, vsProps);
            return;
        }
        ValueSetExpansionOutcome vso = this.context.expandVS(inc, heirarchical, noInactive);
        if (vso.getError() != null) {
            throw this.failTSE("Unable to expand imported value set: " + vso.getError());
        }
        ValueSet vs = vso.getValueset();
        if (!vs.hasVersion()) {
            // empty if block
        }
        UriType u = new UriType(vs.getUrl() + (String)(vs.hasVersion() ? "|" + vs.getVersion() : ""));
        if (!this.existsInParams(exp.getParameter(), "used-valueset", u)) {
            exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("used-valueset").setValue(u));
        }
        if (vs.getExpansion().hasTotal()) {
            this.dwc.incTotal(vs.getExpansion().getTotal());
        } else {
            this.dwc.setNoTotal(true);
        }
        for (ValueSet.ValueSetExpansionParameterComponent p : vso.getValueset().getExpansion().getParameter()) {
            if (this.existsInParams(exp.getParameter(), p.getName(), p.getValue())) continue;
            exp.getParameter().add(p);
        }
        for (Extension ex : vs.getExpansion().getExtension()) {
            if (!Utilities.existsInList((String)ex.getUrl(), (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/valueset-toocostly", "http://hl7.org/fhir/StructureDefinition/valueset-unclosed"}) || ExtensionsUtils.hasExtension(extensions, ex.getUrl())) continue;
            extensions.add(ex);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            this.addCodeAndDescendents(this.dwc, cc, null, expParams, imports, noInactive, vsProps, vs, exp, !vs.getExpansion().hasTotal());
        }
    }

    public void doInternalIncludeCodes(ValueSet.ConceptSetComponent inc, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, List<ValueSet> imports, CodeSystem cs, boolean noInactive, Resource vsSrc) throws NoTerminologyServiceException, TerminologyServiceException, FHIRException, ETooCostly {
        this.opContext.deadCheck();
        if (cs == null) {
            if (this.context.isNoTerminologyServer()) {
                throw this.failTSE("Unable to find code system " + inc.getSystem().toString());
            }
            throw this.failTSE("Unable to find code system " + inc.getSystem().toString());
        }
        this.checkCanonical(exp, cs, this.focus);
        cs.checkNoModifiers("Code System", "expanding");
        if (cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
            throw this.failTSE("Code system " + inc.getSystem().toString() + " is incomplete");
        }
        if (!cs.hasVersion()) {
            // empty if block
        }
        Object u = new UriType(cs.getUrl() + (String)(cs.hasVersion() ? "|" + cs.getVersion() : ""));
        if (!this.existsInParams(exp.getParameter(), "used-codesystem", (DataType)u)) {
            exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("used-codesystem").setValue((DataType)u));
        }
        if (cs.hasUserData("supplements.installed")) {
            for (String s : cs.getUserString("supplements.installed").split("\\,")) {
                u = new UriType(s);
                if (this.existsInParams(exp.getParameter(), "used-supplement", (DataType)u)) continue;
                exp.getParameter().add(new ValueSet.ValueSetExpansionParameterComponent().setName("used-supplement").setValue((DataType)u));
            }
        }
        if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                this.addCodeAndDescendents(this.dwc, cs, inc.getSystem(), def, null, expParams, imports, null, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), null, exp);
            }
            if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                this.addFragmentWarning(exp, cs);
            }
            if (cs.getContent() == Enumerations.CodeSystemContentMode.EXAMPLE) {
                this.addExampleWarning(exp, cs);
            }
        }
        if (!inc.getConcept().isEmpty()) {
            this.dwc.setCanBeHierarchy(false);
            for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                c.checkNoModifiers("Code in Value Set", "expanding");
                CodeSystem.ConceptDefinitionComponent def = CodeSystemUtilities.findCodeOrAltCode(cs.getConcept(), c.getCode(), null);
                boolean inactive = false;
                boolean isAbstract = false;
                if (def == null) {
                    if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                        this.addFragmentWarning(exp, cs);
                        continue;
                    }
                    if (cs.getContent() == Enumerations.CodeSystemContentMode.EXAMPLE) {
                        this.addExampleWarning(exp, cs);
                        continue;
                    }
                    if (!this.checkCodesWhenExpanding) continue;
                    throw this.failTSE("Unable to find code '" + c.getCode() + "' in code system " + cs.getUrl());
                }
                def.checkNoModifiers("Code in Code System", "expanding");
                inactive = CodeSystemUtilities.isInactive(cs, def);
                isAbstract = CodeSystemUtilities.isNotSelectable(cs, def);
                this.addCode(this.dwc, inc.getSystem(), c.getCode(), !Utilities.noString((String)c.getDisplay()) ? c.getDisplay() : def.getDisplay(), c.hasDisplay() ? vsSrc.getLanguage() : cs.getLanguage(), null, this.mergeDesignations(def, this.convertDesignations(c.getDesignation())), expParams, isAbstract, inactive, imports, noInactive, false, exp.getProperty(), this.makeCSProps(def.getDefinition(), def.getProperty()), cs, null, def.getExtension(), c.getExtension(), exp, true);
            }
        }
        if (inc.getFilter().size() > 0) {
            if (inc.getFilter().size() > 1) {
                this.dwc.setCanBeHierarchy(false);
            }
            if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                this.addFragmentWarning(exp, cs);
            }
            ArrayList<WorkingContext> filters = new ArrayList<WorkingContext>();
            for (int i = 1; i < inc.getFilter().size(); ++i) {
                WorkingContext wc = new WorkingContext();
                filters.add(wc);
                this.processFilter(inc, exp, expParams, imports, cs, noInactive, inc.getFilter().get(i), wc, null, false);
            }
            ValueSet.ConceptSetFilterComponent fc = inc.getFilter().get(0);
            WorkingContext wc = this.dwc;
            this.processFilter(inc, exp, expParams, imports, cs, noInactive, fc, wc, filters, false);
        }
    }

    private void processFilter(ValueSet.ConceptSetComponent inc, ValueSet.ValueSetExpansionComponent exp, Parameters expParams, List<ValueSet> imports, CodeSystem cs, boolean noInactive, ValueSet.ConceptSetFilterComponent fc, WorkingContext wc, List<WorkingContext> filters, boolean exclude) throws ETooCostly {
        this.opContext.deadCheck();
        if ("concept".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.ISA) {
            CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), fc.getValue());
            if (def == null) {
                throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
            }
            if (exclude) {
                this.excludeCodeAndDescendents(wc, cs, inc.getSystem(), def, null, imports, null, new AllConceptsFilter(this.allErrors), filters, exp);
            } else {
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), def, null, expParams, imports, null, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), filters, exp);
            }
        } else if ("concept".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.ISNOTA) {
            CodeSystem.ConceptDefinitionComponent defEx = this.getConceptForCode(cs.getConcept(), fc.getValue());
            if (defEx == null) {
                throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
            }
            for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : cs.getConcept()) {
                if (exclude) {
                    this.excludeCodeAndDescendents(wc, cs, inc.getSystem(), conceptDefinitionComponent, null, imports, defEx, new AllConceptsFilter(this.allErrors), filters, exp);
                    continue;
                }
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), conceptDefinitionComponent, null, expParams, imports, defEx, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), filters, exp);
            }
        } else if ("concept".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.DESCENDENTOF) {
            CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), fc.getValue());
            if (def == null) {
                throw this.failTSE("Code '" + fc.getValue() + "' not found in system '" + inc.getSystem() + "'");
            }
            for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : def.getConcept()) {
                if (exclude) {
                    this.excludeCodeAndDescendents(wc, cs, inc.getSystem(), conceptDefinitionComponent, null, imports, null, new AllConceptsFilter(this.allErrors), filters, exp);
                    continue;
                }
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), conceptDefinitionComponent, null, expParams, imports, null, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), filters, exp);
            }
            if (def.hasUserData("cs.utils.cross.link")) {
                List children = (List)def.getUserData("cs.utils.cross.link");
                for (CodeSystem.ConceptDefinitionComponent c : children) {
                    if (exclude) {
                        this.excludeCodeAndDescendents(wc, cs, inc.getSystem(), c, null, imports, null, new AllConceptsFilter(this.allErrors), filters, exp);
                        continue;
                    }
                    this.addCodeAndDescendents(wc, cs, inc.getSystem(), c, null, expParams, imports, null, new AllConceptsFilter(this.allErrors), noInactive, exp.getProperty(), filters, exp);
                }
            }
        } else if ("display".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.EQUAL) {
            this.dwc.setCanBeHierarchy(false);
            CodeSystem.ConceptDefinitionComponent def = this.getConceptForCode(cs.getConcept(), fc.getValue());
            if (def != null && StringUtils.isNotBlank((CharSequence)def.getDisplay()) && StringUtils.isNotBlank((CharSequence)fc.getValue()) && def.getDisplay().contains(fc.getValue()) && this.passesOtherFilters(filters, cs, def.getCode())) {
                for (String string : this.getCodesForConcept(def, expParams)) {
                    this.opContext.deadCheck();
                    if (exclude) {
                        this.excludeCode(wc, inc.getSystem(), string);
                        continue;
                    }
                    this.addCode(wc, inc.getSystem(), string, def.getDisplay(), cs.getLanguage(), null, def.getDesignation(), expParams, CodeSystemUtilities.isNotSelectable(cs, def), CodeSystemUtilities.isInactive(cs, def), imports, noInactive, false, exp.getProperty(), this.makeCSProps(def.getDefinition(), def.getProperty()), cs, null, def.getExtension(), null, exp, true);
                }
            }
        } else if (CodeSystemUtilities.isDefinedProperty(cs, fc.getProperty())) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                PropertyFilter propertyFilter = new PropertyFilter(this.allErrors, fc, CodeSystemUtilities.getPropertyDefinition(cs, fc.getProperty()));
                if (exclude) {
                    this.excludeCodeAndDescendents(wc, cs, inc.getSystem(), def, null, imports, null, propertyFilter, filters, exp);
                    continue;
                }
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), def, null, expParams, imports, null, propertyFilter, noInactive, exp.getProperty(), filters, exp);
            }
        } else if (this.isKnownProperty(fc.getProperty(), cs)) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                KnownPropertyFilter knownPropertyFilter = new KnownPropertyFilter(this.allErrors, fc, fc.getProperty());
                if (exclude) {
                    this.excludeCodeAndDescendents(wc, cs, inc.getSystem(), def, null, imports, null, knownPropertyFilter, filters, exp);
                    continue;
                }
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), def, null, expParams, imports, null, knownPropertyFilter, noInactive, exp.getProperty(), filters, exp);
            }
        } else if ("code".equals(fc.getProperty()) && fc.getOp() == Enumerations.FilterOperator.REGEX) {
            for (CodeSystem.ConceptDefinitionComponent def : cs.getConcept()) {
                if (exclude) {
                    this.excludeCodeAndDescendents(wc, cs, inc.getSystem(), def, null, imports, null, new RegexFilter(this.allErrors, fc.getValue()), filters, exp);
                    continue;
                }
                this.addCodeAndDescendents(wc, cs, inc.getSystem(), def, null, expParams, imports, null, new RegexFilter(this.allErrors, fc.getValue()), noInactive, exp.getProperty(), filters, exp);
            }
        } else {
            throw this.fail("Filter by property[" + fc.getProperty() + "] and op[" + fc.getOp() + "] is not supported yet");
        }
    }

    private boolean isKnownProperty(String property, CodeSystem cs) {
        return Utilities.existsInList((String)property, (String[])new String[]{"notSelectable"});
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> mergeDesignations(CodeSystem.ConceptDefinitionComponent def, List<CodeSystem.ConceptDefinitionDesignationComponent> list) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> res = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        if (def != null) {
            res.addAll(def.getDesignation());
        }
        res.addAll(list);
        return res;
    }

    private void addFragmentWarning(ValueSet.ValueSetExpansionComponent exp, CodeSystem cs) {
        String url = cs.getVersionedUrl();
        for (ValueSet.ValueSetExpansionParameterComponent p : exp.getParameter()) {
            if (!"fragment".equals(p.getName()) || !p.hasValueUriType() || !url.equals(p.getValue().primitiveValue())) continue;
            return;
        }
        exp.addParameter().setName("fragment").setValue(new CanonicalType(url));
    }

    private void addExampleWarning(ValueSet.ValueSetExpansionComponent exp, CodeSystem cs) {
        String url = cs.getVersionedUrl();
        for (ValueSet.ValueSetExpansionParameterComponent p : exp.getParameter()) {
            if (!"example".equals(p.getName()) || !p.hasValueUriType() || !url.equals(p.getValue().primitiveValue())) continue;
            return;
        }
        exp.addParameter().setName("example").setValue(new CanonicalType(url));
    }

    private List<CodeSystem.ConceptDefinitionDesignationComponent> convertDesignations(List<ValueSet.ConceptReferenceDesignationComponent> list) {
        ArrayList<CodeSystem.ConceptDefinitionDesignationComponent> res = new ArrayList<CodeSystem.ConceptDefinitionDesignationComponent>();
        for (ValueSet.ConceptReferenceDesignationComponent t : list) {
            CodeSystem.ConceptDefinitionDesignationComponent c = new CodeSystem.ConceptDefinitionDesignationComponent();
            c.setLanguage(t.getLanguage());
            c.setUse(t.getUse());
            c.setValue(t.getValue());
            c.getExtension().addAll(t.getExtension());
            res.add(c);
        }
        return res;
    }

    private String key(String uri, String code) {
        return "{" + uri + "}" + code;
    }

    private String key(ValueSet.ValueSetExpansionContainsComponent c) {
        return this.key(c.getSystem(), c.getCode());
    }

    private FHIRException fail(String msg) {
        this.allErrors.add(msg);
        return new FHIRException(msg);
    }

    private ETooCostly failCostly(String msg) {
        this.allErrors.add(msg);
        return new ETooCostly(msg);
    }

    private TerminologyServiceException failTSE(String msg) {
        this.allErrors.add(msg);
        return new TerminologyServiceException(msg);
    }

    public Collection<? extends String> getAllErrors() {
        return this.allErrors;
    }

    public boolean isCheckCodesWhenExpanding() {
        return this.checkCodesWhenExpanding;
    }

    public void setCheckCodesWhenExpanding(boolean checkCodesWhenExpanding) {
        this.checkCodesWhenExpanding = checkCodesWhenExpanding;
    }

    private boolean passesOtherFilters(List<WorkingContext> otherFilters, CodeSystem cs, String code) {
        if (otherFilters == null) {
            return true;
        }
        String key = this.key(cs.getUrl(), code);
        for (WorkingContext wc : otherFilters) {
            if (wc.getMap().containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ValueSetExpander setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public class Token {
        private String system;
        private String code;

        public Token(String system, String code) {
            this.system = system;
            this.code = code;
        }

        public String getSystem() {
            return this.system;
        }

        public String getCode() {
            return this.code;
        }

        public boolean matches(Coding use) {
            return this.system.equals(use.getSystem()) && this.code.equals(use.getCode());
        }

        public boolean matchesLang(String language) {
            return this.system.equals("urn:ietf:bcp:47") && this.code.equals(language);
        }
    }
}

