/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class TerminologyCache {
    public static final boolean TRANSIENT = false;
    public static final boolean PERMANENT = true;
    private static final String NAME_FOR_NO_SYSTEM = "all-systems";
    private static final String ENTRY_MARKER = "-------------------------------------------------------------------------------------";
    private static final String BREAK = "####";
    private static final String CACHE_FILE_EXTENSION = ".cache";
    private static final String CAPABILITY_STATEMENT_TITLE = ".capabilityStatement";
    private static final String TERMINOLOGY_CAPABILITIES_TITLE = ".terminologyCapabilities";
    private static final String FIXED_CACHE_VERSION = "4";
    private SystemNameKeyGenerator systemNameKeyGenerator = new SystemNameKeyGenerator();
    private Object lock;
    private String folder;
    private int requestCount;
    private int hitCount;
    private int networkCount;
    private Map<String, CapabilityStatement> capabilityStatementCache = new HashMap<String, CapabilityStatement>();
    private Map<String, TerminologyCapabilities> terminologyCapabilitiesCache = new HashMap<String, TerminologyCapabilities>();
    private Map<String, NamedCache> caches = new HashMap<String, NamedCache>();
    private Map<String, SourcedValueSetEntry> vsCache = new HashMap<String, SourcedValueSetEntry>();
    private Map<String, SourcedCodeSystemEntry> csCache = new HashMap<String, SourcedCodeSystemEntry>();
    private Map<String, String> serverMap = new HashMap<String, String>();
    private static boolean noCaching;
    private static boolean cacheErrors;

    protected SystemNameKeyGenerator getSystemNameKeyGenerator() {
        return this.systemNameKeyGenerator;
    }

    public TerminologyCache(Object lock, String folder) throws FileNotFoundException, IOException, FHIRException {
        this.lock = lock;
        if (folder == null) {
            folder = Utilities.path((String[])new String[]{"[tmp]", "default-tx-cache"});
        }
        this.folder = folder;
        this.requestCount = 0;
        this.hitCount = 0;
        this.networkCount = 0;
        File f = ManagedFileAccess.file((String)folder);
        if (!f.exists()) {
            Utilities.createDirectory((String)folder);
        }
        if (!f.exists()) {
            throw new IOException("Unable to create terminology cache at " + folder);
        }
        this.checkVersion();
        this.load();
    }

    private void checkVersion() throws IOException {
        File verFile = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.folder, "version.ctl"}));
        if (verFile.exists()) {
            String ver = TextFile.fileToString((File)verFile);
            if (!ver.equals(FIXED_CACHE_VERSION)) {
                System.out.println("Terminology Cache Version has changed from 1 to 4, so clearing txCache");
                this.clear();
            }
            TextFile.stringToFile((String)FIXED_CACHE_VERSION, (File)verFile);
        } else {
            TextFile.stringToFile((String)FIXED_CACHE_VERSION, (File)verFile);
        }
    }

    public String getServerId(String address) throws IOException {
        if (this.serverMap.containsKey(address)) {
            return this.serverMap.get(address);
        }
        Object id = address.replace("http://", "").replace("https://", "").replace("/", ".");
        int i = 1;
        while (this.serverMap.containsValue(id)) {
            id = address.replace("https:", "").replace("https:", "").replace("/", ".") + ++i;
        }
        this.serverMap.put(address, (String)id);
        if (this.folder != null) {
            IniFile ini = new IniFile(Utilities.path((String[])new String[]{this.folder, "servers.ini"}));
            ini.setStringProperty("servers", (String)id, address, null);
            ini.save();
        }
        return id;
    }

    public void unload() {
        this.caches.clear();
        this.vsCache.clear();
        this.csCache.clear();
    }

    private void clear() throws IOException {
        Utilities.clearDirectory((String)this.folder, (String[])new String[0]);
        this.caches.clear();
        this.vsCache.clear();
        this.csCache.clear();
    }

    public boolean hasCapabilityStatement(String address) {
        return this.capabilityStatementCache.containsKey(address);
    }

    public CapabilityStatement getCapabilityStatement(String address) {
        return this.capabilityStatementCache.get(address);
    }

    public void cacheCapabilityStatement(String address, CapabilityStatement capabilityStatement) throws IOException {
        if (noCaching) {
            return;
        }
        this.capabilityStatementCache.put(address, capabilityStatement);
        this.save(capabilityStatement, ".capabilityStatement." + this.getServerId(address));
    }

    public boolean hasTerminologyCapabilities(String address) {
        return this.terminologyCapabilitiesCache.containsKey(address);
    }

    public TerminologyCapabilities getTerminologyCapabilities(String address) {
        return this.terminologyCapabilitiesCache.get(address);
    }

    public void cacheTerminologyCapabilities(String address, TerminologyCapabilities terminologyCapabilities) throws IOException {
        if (noCaching) {
            return;
        }
        this.terminologyCapabilitiesCache.put(address, terminologyCapabilities);
        this.save(terminologyCapabilities, ".terminologyCapabilities." + this.getServerId(address));
    }

    public CacheToken generateValidationToken(ValidationOptions options, Coding code, ValueSet vs, Parameters expParameters) {
        try {
            CacheToken ct = new CacheToken();
            if (code.hasSystem()) {
                ct.setName(code.getSystem());
                ct.hasVersion = code.hasVersion();
            } else {
                ct.name = NAME_FOR_NO_SYSTEM;
            }
            this.nameCacheToken(vs, ct);
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            String expJS = json.composeString(expParameters);
            if (vs != null && vs.hasUrl() && vs.hasVersion()) {
                ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + ", \"url\": \"" + Utilities.escapeJson((String)vs.getUrl()) + "\", \"version\": \"" + Utilities.escapeJson((String)vs.getVersion()) + "\"" + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}\r\n";
            } else if (options.getVsAsUrl()) {
                ct.request = "{\"code\" : " + json.composeString(code, "code") + ", \"valueSet\" :" + this.extracted(json, vs) + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            } else {
                ValueSet vsc = this.getVSEssense(vs);
                ct.request = "{\"code\" : " + json.composeString(code, "code") + ", \"valueSet\" :" + (vsc == null ? "null" : this.extracted(json, vsc)) + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            }
            ct.key = String.valueOf(this.hashJson(ct.request));
            return ct;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public CacheToken generateValidationToken(ValidationOptions options, Coding code, String vsUrl, Parameters expParameters) {
        try {
            CacheToken ct = new CacheToken();
            if (code.hasSystem()) {
                ct.setName(code.getSystem());
                ct.hasVersion = code.hasVersion();
            } else {
                ct.name = NAME_FOR_NO_SYSTEM;
            }
            ct.setName(vsUrl);
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            String expJS = json.composeString(expParameters);
            ct.request = "{\"code\" : " + json.composeString(code, "code") + ", \"valueSet\" :" + (vsUrl == null ? "null" : vsUrl) + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            ct.key = String.valueOf(this.hashJson(ct.request));
            return ct;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public String extracted(JsonParser json, ValueSet vsc) throws IOException {
        String s = null;
        s = vsc.getExpansion().getContains().size() > 1000 || vsc.getCompose().getIncludeFirstRep().getConcept().size() > 1000 ? vsc.getUrl() : json.composeString(vsc);
        return s;
    }

    public CacheToken generateValidationToken(ValidationOptions options, CodeableConcept code, ValueSet vs, Parameters expParameters) {
        try {
            CacheToken ct = new CacheToken();
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem()) continue;
                ct.setName(c.getSystem());
                ct.hasVersion = c.hasVersion();
            }
            this.nameCacheToken(vs, ct);
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            String expJS = json.composeString(expParameters);
            if (vs != null && vs.hasUrl() && vs.hasVersion()) {
                ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + ", \"url\": \"" + Utilities.escapeJson((String)vs.getUrl()) + "\", \"version\": \"" + Utilities.escapeJson((String)vs.getVersion()) + "\"" + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}\r\n";
            } else if (vs == null) {
                ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            } else {
                ValueSet vsc = this.getVSEssense(vs);
                ct.request = "{\"code\" : " + json.composeString(code, "codeableConcept") + ", \"valueSet\" :" + this.extracted(json, vsc) + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            }
            ct.key = String.valueOf(this.hashJson(ct.request));
            return ct;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public ValueSet getVSEssense(ValueSet vs) {
        if (vs == null) {
            return null;
        }
        ValueSet vsc = new ValueSet();
        vsc.setCompose(vs.getCompose());
        if (vs.hasExpansion()) {
            vsc.getExpansion().getParameter().addAll(vs.getExpansion().getParameter());
            vsc.getExpansion().getContains().addAll(vs.getExpansion().getContains());
        }
        return vsc;
    }

    public CacheToken generateExpandToken(ValueSet vs, boolean hierarchical) {
        CacheToken ct = new CacheToken();
        this.nameCacheToken(vs, ct);
        if (vs.hasUrl() && vs.hasVersion()) {
            ct.request = "{\"hierarchical\" : " + (hierarchical ? "true" : "false") + ", \"url\": \"" + Utilities.escapeJson((String)vs.getUrl()) + "\", \"version\": \"" + Utilities.escapeJson((String)vs.getVersion()) + "\"}\r\n";
        } else {
            ValueSet vsc = this.getVSEssense(vs);
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            try {
                ct.request = "{\"hierarchical\" : " + (hierarchical ? "true" : "false") + ", \"valueSet\" :" + this.extracted(json, vsc) + "}\r\n";
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        ct.key = String.valueOf(this.hashJson(ct.request));
        return ct;
    }

    public void nameCacheToken(ValueSet vs, CacheToken ct) {
        if (vs != null) {
            for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getInclude()) {
                if (!conceptSetComponent.hasSystem()) continue;
                ct.setName(conceptSetComponent.getSystem());
                ct.hasVersion = conceptSetComponent.hasVersion();
            }
            for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getExclude()) {
                if (!conceptSetComponent.hasSystem()) continue;
                ct.setName(conceptSetComponent.getSystem());
                ct.hasVersion = conceptSetComponent.hasVersion();
            }
            for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : vs.getExpansion().getContains()) {
                if (!valueSetExpansionContainsComponent.hasSystem()) continue;
                ct.setName(valueSetExpansionContainsComponent.getSystem());
                ct.hasVersion = valueSetExpansionContainsComponent.hasVersion();
            }
        }
    }

    private String normalizeSystemPath(String path) {
        return path.replace("/", "").replace('|', 'X');
    }

    public NamedCache getNamedCache(CacheToken cacheToken) {
        String cacheName = cacheToken.name == null ? "null" : cacheToken.name;
        NamedCache nc = this.caches.get(cacheName);
        if (nc == null) {
            nc = new NamedCache();
            nc.name = cacheName;
            this.caches.put(nc.name, nc);
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSetExpansionOutcome getExpansion(CacheToken cacheToken) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = nc.map.get(cacheToken.key);
            if (e == null) {
                return null;
            }
            return e.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheExpansion(CacheToken cacheToken, ValueSetExpansionOutcome res, boolean persistent) {
        Object object = this.lock;
        synchronized (object) {
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = new CacheEntry();
            e.request = cacheToken.request;
            e.persistent = persistent;
            e.e = res;
            this.store(cacheToken, persistent, nc, e);
        }
    }

    public void store(CacheToken cacheToken, boolean persistent, NamedCache nc, CacheEntry e) {
        if (noCaching) {
            return;
        }
        if (!cacheErrors && e.v != null && e.v.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED && !cacheToken.hasVersion) {
            return;
        }
        boolean n = nc.map.containsKey(cacheToken.key);
        nc.map.put(cacheToken.key, e);
        if (persistent) {
            if (n) {
                for (int i = nc.list.size() - 1; i >= 0; --i) {
                    if (!nc.list.get((int)i).request.equals(e.request)) continue;
                    nc.list.remove(i);
                }
            }
            nc.list.add(e);
            this.save(nc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult getValidation(CacheToken cacheToken) {
        if (cacheToken.key == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            ++this.requestCount;
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = nc.map.get(cacheToken.key);
            if (e == null) {
                ++this.networkCount;
                return null;
            }
            ++this.hitCount;
            return e.v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheValidation(CacheToken cacheToken, ValidationResult res, boolean persistent) {
        if (cacheToken.key != null) {
            Object object = this.lock;
            synchronized (object) {
                NamedCache nc = this.getNamedCache(cacheToken);
                CacheEntry e = new CacheEntry();
                e.request = cacheToken.request;
                e.persistent = persistent;
                e.v = res;
                this.store(cacheToken, persistent, nc, e);
            }
        }
    }

    public void save() {
    }

    private <K extends Resource> void save(K resource, String title) {
        if (this.folder == null) {
            return;
        }
        try {
            OutputStreamWriter sw = new OutputStreamWriter((OutputStream)ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, title + CACHE_FILE_EXTENSION})), "UTF-8");
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            sw.write(json.composeString(resource).trim());
            sw.close();
        }
        catch (Exception e) {
            System.out.println("error saving capability statement " + e.getMessage());
        }
    }

    private void save(NamedCache nc) {
        if (this.folder == null) {
            return;
        }
        try {
            OutputStreamWriter sw = new OutputStreamWriter((OutputStream)ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, nc.name + CACHE_FILE_EXTENSION})), "UTF-8");
            sw.write("-------------------------------------------------------------------------------------\r\n");
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            for (CacheEntry ce : nc.list) {
                sw.write(ce.request.trim());
                sw.write("####\r\n");
                if (ce.e != null) {
                    sw.write("e: {\r\n");
                    if (ce.e.isFromServer()) {
                        sw.write("  \"from-server\" : true,\r\n");
                    }
                    if (ce.e.getValueset() != null) {
                        sw.write("  \"valueSet\" : " + json.composeString(ce.e.getValueset()).trim() + ",\r\n");
                    }
                    sw.write("  \"error\" : \"" + Utilities.escapeJson((String)ce.e.getError()).trim() + "\"\r\n}\r\n");
                } else if (ce.s != null) {
                    sw.write("s: {\r\n");
                    sw.write("  \"result\" : " + ce.s.result + "\r\n}\r\n");
                } else {
                    sw.write("v: {\r\n");
                    boolean first = true;
                    if (ce.v.getDisplay() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"display\" : \"" + Utilities.escapeJson((String)ce.v.getDisplay()).trim() + "\"");
                    }
                    if (ce.v.getCode() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"code\" : \"" + Utilities.escapeJson((String)ce.v.getCode()).trim() + "\"");
                    }
                    if (ce.v.getSystem() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"system\" : \"" + Utilities.escapeJson((String)ce.v.getSystem()).trim() + "\"");
                    }
                    if (ce.v.getVersion() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"version\" : \"" + Utilities.escapeJson((String)ce.v.getVersion()).trim() + "\"");
                    }
                    if (ce.v.getSeverity() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"severity\" : \"" + ce.v.getSeverity().toCode().trim() + "\"");
                    }
                    if (ce.v.getMessage() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"error\" : \"" + Utilities.escapeJson((String)ce.v.getMessage()).trim() + "\"");
                    }
                    if (ce.v.getErrorClass() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"class\" : \"" + Utilities.escapeJson((String)ce.v.getErrorClass().toString()) + "\"");
                    }
                    if (ce.v.getDefinition() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"definition\" : \"" + Utilities.escapeJson((String)ce.v.getDefinition()).trim() + "\"");
                    }
                    if (ce.v.getStatus() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"status\" : \"" + Utilities.escapeJson((String)ce.v.getStatus()).trim() + "\"");
                    }
                    if (ce.v.getServer() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"server\" : \"" + Utilities.escapeJson((String)ce.v.getServer()).trim() + "\"");
                    }
                    if (ce.v.isInactive()) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"inactive\" : true");
                    }
                    if (ce.v.getUnknownSystems() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        sw.write("  \"unknown-systems\" : \"" + Utilities.escapeJson((String)CommaSeparatedStringBuilder.join((String)",", ce.v.getUnknownSystems())).trim() + "\"");
                    }
                    if (ce.v.getIssues() != null) {
                        if (first) {
                            first = false;
                        } else {
                            sw.write(",\r\n");
                        }
                        OperationOutcome oo = new OperationOutcome();
                        oo.setIssue(ce.v.getIssues());
                        sw.write("  \"issues\" : " + json.composeString(oo).trim() + "\r\n");
                    }
                    sw.write("\r\n}\r\n");
                }
                sw.write("-------------------------------------------------------------------------------------\r\n");
            }
            sw.close();
        }
        catch (Exception e) {
            System.out.println("error saving " + nc.name + ": " + e.getMessage());
        }
    }

    private boolean isCapabilityCache(String fn) {
        if (fn == null) {
            return false;
        }
        return fn.startsWith(CAPABILITY_STATEMENT_TITLE) || fn.startsWith(TERMINOLOGY_CAPABILITIES_TITLE);
    }

    private void loadCapabilityCache(String fn) {
        try {
            String src = TextFile.fileToString((String)Utilities.path((String[])new String[]{this.folder, fn}));
            String serverId = Utilities.getFileNameForName((String)fn).replace(CACHE_FILE_EXTENSION, "");
            serverId = serverId.substring(serverId.indexOf(".") + 1);
            serverId = serverId.substring(serverId.indexOf(".") + 1);
            String address = this.getServerForId(serverId);
            if (address != null) {
                JsonObject o = (JsonObject)new com.google.gson.JsonParser().parse(src);
                Resource resource = new JsonParser().parse(o);
                if (fn.startsWith(CAPABILITY_STATEMENT_TITLE)) {
                    this.capabilityStatementCache.put(address, (CapabilityStatement)resource);
                } else if (fn.startsWith(TERMINOLOGY_CAPABILITIES_TITLE)) {
                    this.terminologyCapabilitiesCache.put(address, (TerminologyCapabilities)resource);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FHIRException("Error loading " + fn + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private String getServerForId(String serverId) {
        for (String n : this.serverMap.keySet()) {
            if (!this.serverMap.get(n).equals(serverId)) continue;
            return n;
        }
        return null;
    }

    private CacheEntry getCacheEntry(String request, String resultString) throws IOException {
        CacheEntry ce = new CacheEntry();
        ce.persistent = true;
        ce.request = request;
        char e = resultString.charAt(0);
        resultString = resultString.substring(3);
        JsonObject o = (JsonObject)new com.google.gson.JsonParser().parse(resultString);
        String error = this.loadJS(o.get("error"));
        if (e == 'e') {
            ce.e = o.has("valueSet") ? new ValueSetExpansionOutcome((ValueSet)new JsonParser().parse(o.getAsJsonObject("valueSet")), error, TerminologyServiceErrorClass.UNKNOWN, o.has("from-server")) : new ValueSetExpansionOutcome(error, TerminologyServiceErrorClass.UNKNOWN, o.has("from-server"));
        } else if (e == 's') {
            ce.s = new SubsumesResult(o.get("result").getAsBoolean());
        } else {
            String t = this.loadJS(o.get("severity"));
            ValidationMessage.IssueSeverity severity = t == null ? null : ValidationMessage.IssueSeverity.fromCode((String)t);
            String display = this.loadJS(o.get("display"));
            String code = this.loadJS(o.get("code"));
            String system = this.loadJS(o.get("system"));
            String version = this.loadJS(o.get("version"));
            String definition = this.loadJS(o.get("definition"));
            String server = this.loadJS(o.get("server"));
            String status = this.loadJS(o.get("status"));
            boolean inactive = "true".equals(this.loadJS(o.get("inactive")));
            String unknownSystems = this.loadJS(o.get("unknown-systems"));
            OperationOutcome oo = o.has("issues") ? (OperationOutcome)new JsonParser().parse(o.getAsJsonObject("issues")) : null;
            t = this.loadJS(o.get("class"));
            TerminologyServiceErrorClass errorClass = t == null ? null : TerminologyServiceErrorClass.valueOf(t);
            ce.v = new ValidationResult(severity, error, system, version, new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setDefinition(definition).setCode(code), display, null).setErrorClass(errorClass);
            ce.v.setUnknownSystems(CommaSeparatedStringBuilder.toSet((String)unknownSystems));
            ce.v.setServer(server);
            ce.v.setStatus(inactive, status);
            if (oo != null) {
                ce.v.setIssues(oo.getIssue());
            }
        }
        return ce;
    }

    private void loadNamedCache(String fn) {
        int c = 0;
        try {
            String src = TextFile.fileToString((String)Utilities.path((String[])new String[]{this.folder, fn}));
            String title = fn.substring(0, fn.lastIndexOf("."));
            NamedCache nc = new NamedCache();
            nc.name = title;
            if (src.startsWith("?")) {
                src = src.substring(1);
            }
            int i = src.indexOf(ENTRY_MARKER);
            while (i > -1) {
                ++c;
                String s = src.substring(0, i);
                src = src.substring(i + ENTRY_MARKER.length() + 1);
                i = src.indexOf(ENTRY_MARKER);
                if (!Utilities.noString((String)s)) {
                    int j = s.indexOf(BREAK);
                    String request = s.substring(0, j);
                    String p = s.substring(j + BREAK.length() + 1).trim();
                    CacheEntry cacheEntry = this.getCacheEntry(request, p);
                    nc.map.put(String.valueOf(this.hashJson(cacheEntry.request)), cacheEntry);
                    nc.list.add(cacheEntry);
                }
                this.caches.put(nc.name, nc);
            }
        }
        catch (Exception e) {
            System.out.println("Error loading " + fn + ": " + e.getMessage() + " entry " + c + " - ignoring it");
            e.printStackTrace();
        }
    }

    private void load() throws FHIRException, IOException {
        org.hl7.fhir.utilities.json.model.JsonObject j;
        File f;
        IniFile ini = new IniFile(Utilities.path((String[])new String[]{this.folder, "servers.ini"}));
        if (ini.hasSection("servers")) {
            for (String n : ini.getPropertyNames("servers")) {
                this.serverMap.put(ini.getStringProperty("servers", n), n);
            }
        }
        for (String fn : ManagedFileAccess.file((String)this.folder).list()) {
            if (!fn.endsWith(CACHE_FILE_EXTENSION) || fn.equals("validation.cache")) continue;
            if (this.isCapabilityCache(fn)) {
                this.loadCapabilityCache(fn);
                continue;
            }
            this.loadNamedCache(fn);
        }
        try {
            f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.folder, "vs-externals.json"}));
            if (f.exists()) {
                org.hl7.fhir.utilities.json.model.JsonObject json = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((File)f);
                for (JsonProperty p : json.getProperties()) {
                    if (p.getValue().isJsonNull()) {
                        this.vsCache.put(p.getName(), null);
                        continue;
                    }
                    j = p.getValue().asJsonObject();
                    this.vsCache.put(p.getName(), new SourcedValueSetEntry(j.asString("server"), j.asString("filename")));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error loading vs external cache: " + e.getMessage());
        }
        try {
            f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.folder, "cs-externals.json"}));
            if (f.exists()) {
                org.hl7.fhir.utilities.json.model.JsonObject json = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((File)f);
                for (JsonProperty p : json.getProperties()) {
                    if (p.getValue().isJsonNull()) {
                        this.csCache.put(p.getName(), null);
                        continue;
                    }
                    j = p.getValue().asJsonObject();
                    this.csCache.put(p.getName(), new SourcedCodeSystemEntry(j.asString("server"), j.asString("filename")));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error loading vs external cache: " + e.getMessage());
        }
    }

    private String loadJS(com.google.gson.JsonElement e) {
        if (e == null) {
            return null;
        }
        if (!(e instanceof JsonPrimitive)) {
            return null;
        }
        String s = e.getAsString();
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    public String hashJson(String s) {
        return String.valueOf(s.trim().hashCode());
    }

    public String summary(ValueSet vs) {
        if (vs == null) {
            return "null";
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            b.append("Include " + this.getIncSummary(cc));
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getExclude()) {
            b.append("Exclude " + this.getIncSummary(cc));
        }
        return b.toString();
    }

    private String getIncSummary(ValueSet.ConceptSetComponent cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (UriType uriType : cc.getValueSet()) {
            b.append(uriType.asStringValue());
        }
        String vsd = b.length() > 0 ? " where the codes are in the value sets (" + b.toString() + ")" : "";
        String string = cc.getSystem();
        if (cc.hasConcept()) {
            return Integer.toString(cc.getConcept().size()) + " codes from " + string + vsd;
        }
        if (cc.hasFilter()) {
            Object s = "";
            for (ValueSet.ConceptSetFilterComponent f : cc.getFilter()) {
                if (!Utilities.noString((String)s)) {
                    s = (String)s + " & ";
                }
                s = (String)s + f.getProperty() + " " + (f.hasOp() ? f.getOp().toCode() : "?") + " " + f.getValue();
            }
            return "from " + string + " where " + (String)s + vsd;
        }
        return "All codes from " + string + vsd;
    }

    public String summary(Coding code) {
        return code.getSystem() + "#" + code.getCode() + (String)(code.hasDisplay() ? ": \"" + code.getDisplay() + "\"" : "");
    }

    public String summary(CodeableConcept code) {
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (Coding c : code.getCoding()) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(this.summary(c));
        }
        b.append("}: \"");
        b.append(code.getText());
        b.append("\"");
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCS(String url) {
        Object object = this.lock;
        synchronized (object) {
            String name = this.getSystemNameKeyGenerator().getNameForSystem(url);
            if (this.caches.containsKey(name)) {
                this.caches.remove(name);
            }
        }
    }

    public String getFolder() {
        return this.folder;
    }

    public Map<String, String> servers() {
        HashMap<String, String> servers = new HashMap<String, String>();
        servers.put("http://tx.fhir.org/r2", "tx.fhir.org");
        servers.put("http://tx.fhir.org/r3", "tx.fhir.org");
        servers.put("http://tx.fhir.org/r4", "tx.fhir.org");
        servers.put("http://tx.fhir.org/r5", "tx.fhir.org");
        return servers;
    }

    public boolean hasValueSet(String canonical) {
        return this.vsCache.containsKey(canonical);
    }

    public boolean hasCodeSystem(String canonical) {
        return this.csCache.containsKey(canonical);
    }

    public SourcedValueSet getValueSet(String canonical) {
        SourcedValueSetEntry sp = this.vsCache.get(canonical);
        if (sp == null) {
            return null;
        }
        try {
            return new SourcedValueSet(sp.getServer(), sp.getFilename() == null ? null : (ValueSet)new JsonParser().parse(ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{this.folder, sp.getFilename()}))));
        }
        catch (Exception e) {
            return null;
        }
    }

    public SourcedCodeSystem getCodeSystem(String canonical) {
        SourcedCodeSystemEntry sp = this.csCache.get(canonical);
        if (sp == null) {
            return null;
        }
        try {
            return new SourcedCodeSystem(sp.getServer(), sp.getFilename() == null ? null : (CodeSystem)new JsonParser().parse(ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{this.folder, sp.getFilename()}))));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void cacheValueSet(String canonical, SourcedValueSet svs) {
        if (canonical == null) {
            return;
        }
        try {
            if (svs == null) {
                this.vsCache.put(canonical, null);
            } else {
                String uuid = Utilities.makeUuidLC();
                String fn = "vs-" + uuid + ".json";
                new JsonParser().compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, fn})), (Resource)svs.getVs());
                this.vsCache.put(canonical, new SourcedValueSetEntry(svs.getServer(), fn));
            }
            org.hl7.fhir.utilities.json.model.JsonObject j = new org.hl7.fhir.utilities.json.model.JsonObject();
            for (String k : this.vsCache.keySet()) {
                SourcedValueSetEntry sve = this.vsCache.get(k);
                if (sve == null) {
                    j.add(k, (JsonElement)new JsonNull());
                    continue;
                }
                org.hl7.fhir.utilities.json.model.JsonObject e = new org.hl7.fhir.utilities.json.model.JsonObject();
                e.set("server", sve.getServer());
                if (sve.getFilename() != null) {
                    e.set("filename", sve.getFilename());
                }
                j.add(k, (JsonElement)e);
            }
            org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)j, (File)ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.folder, "vs-externals.json"})), (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cacheCodeSystem(String canonical, SourcedCodeSystem scs) {
        if (canonical == null) {
            return;
        }
        try {
            if (scs == null) {
                this.csCache.put(canonical, null);
            } else {
                String uuid = Utilities.makeUuidLC();
                String fn = "cs-" + uuid + ".json";
                new JsonParser().compose(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.folder, fn})), (Resource)scs.getCs());
                this.csCache.put(canonical, new SourcedCodeSystemEntry(scs.getServer(), fn));
            }
            org.hl7.fhir.utilities.json.model.JsonObject j = new org.hl7.fhir.utilities.json.model.JsonObject();
            for (String k : this.csCache.keySet()) {
                SourcedCodeSystemEntry sve = this.csCache.get(k);
                if (sve == null) {
                    j.add(k, (JsonElement)new JsonNull());
                    continue;
                }
                org.hl7.fhir.utilities.json.model.JsonObject e = new org.hl7.fhir.utilities.json.model.JsonObject();
                e.set("server", sve.getServer());
                if (sve.getFilename() != null) {
                    e.set("filename", sve.getFilename());
                }
                j.add(k, (JsonElement)e);
            }
            org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)j, (File)ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.folder, "cs-externals.json"})), (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CacheToken generateSubsumesToken(ValidationOptions options, Coding parent, Coding child, Parameters expParameters) {
        try {
            CacheToken ct = new CacheToken();
            if (parent.hasSystem()) {
                ct.setName(parent.getSystem());
            }
            if (child.hasSystem()) {
                ct.setName(child.getSystem());
            }
            ct.hasVersion = parent.hasVersion() || child.hasVersion();
            JsonParser json = new JsonParser();
            json.setOutputStyle(IParser.OutputStyle.PRETTY);
            String expJS = json.composeString(expParameters);
            ct.request = "{\"op\": \"subsumes\", \"parent\" : " + json.composeString(parent, "code") + ", \"child\" :" + json.composeString(child, "code") + (String)(options == null ? "" : ", " + options.toJson()) + ", \"profile\": " + expJS + "}";
            ct.key = String.valueOf(this.hashJson(ct.request));
            return ct;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getSubsumes(CacheToken cacheToken) {
        if (cacheToken.key == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            ++this.requestCount;
            NamedCache nc = this.getNamedCache(cacheToken);
            CacheEntry e = nc.map.get(cacheToken.key);
            if (e == null) {
                ++this.networkCount;
                return null;
            }
            ++this.hitCount;
            return e.s.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheSubsumes(CacheToken cacheToken, Boolean b, boolean persistent) {
        if (cacheToken.key != null) {
            Object object = this.lock;
            synchronized (object) {
                NamedCache nc = this.getNamedCache(cacheToken);
                CacheEntry e = new CacheEntry();
                e.request = cacheToken.request;
                e.persistent = persistent;
                e.s = new SubsumesResult(b);
                this.store(cacheToken, persistent, nc, e);
            }
        }
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getNetworkCount() {
        return this.networkCount;
    }

    public static boolean isNoCaching() {
        return noCaching;
    }

    public static void setNoCaching(boolean noCaching) {
        TerminologyCache.noCaching = noCaching;
    }

    public static boolean isCacheErrors() {
        return cacheErrors;
    }

    public static void setCacheErrors(boolean cacheErrors) {
        TerminologyCache.cacheErrors = cacheErrors;
    }

    private class NamedCache {
        private String name;
        private List<CacheEntry> list = new ArrayList<CacheEntry>();
        private Map<String, CacheEntry> map = new HashMap<String, CacheEntry>();

        private NamedCache() {
        }
    }

    private class CacheEntry {
        private String request;
        private boolean persistent;
        private ValidationResult v;
        private ValueSetExpansionOutcome e;
        private SubsumesResult s;

        private CacheEntry() {
        }
    }

    public class SystemNameKeyGenerator {
        public static final String SNOMED_SCT_CODESYSTEM_URL = "http://snomed.info/sct";
        public static final String RXNORM_CODESYSTEM_URL = "http://www.nlm.nih.gov/research/umls/rxnorm";
        public static final String LOINC_CODESYSTEM_URL = "http://loinc.org";
        public static final String UCUM_CODESYSTEM_URL = "http://unitsofmeasure.org";
        public static final String HL7_TERMINOLOGY_CODESYSTEM_BASE_URL = "http://terminology.hl7.org/CodeSystem/";
        public static final String HL7_SID_CODESYSTEM_BASE_URL = "http://hl7.org/fhir/sid/";
        public static final String HL7_FHIR_CODESYSTEM_BASE_URL = "http://hl7.org/fhir/";
        public static final String ISO_CODESYSTEM_URN = "urn:iso:std:iso:";
        public static final String LANG_CODESYSTEM_URN = "urn:ietf:bcp:47";
        public static final String MIMETYPES_CODESYSTEM_URN = "urn:ietf:bcp:13";
        public static final String _11073_CODESYSTEM_URN = "urn:iso:std:iso:11073:10101";
        public static final String DICOM_CODESYSTEM_URL = "http://dicom.nema.org/resources/ontology/DCM";

        public String getNameForSystem(String system) {
            String systemVersion;
            int lastPipe = system.lastIndexOf(124);
            String systemBaseName = lastPipe == -1 ? system : system.substring(0, lastPipe);
            String string = systemVersion = lastPipe == -1 ? null : system.substring(lastPipe + 1);
            if (systemBaseName.equals(SNOMED_SCT_CODESYSTEM_URL)) {
                return this.getVersionedSystem("snomed", systemVersion);
            }
            if (systemBaseName.equals(RXNORM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("rxnorm", systemVersion);
            }
            if (systemBaseName.equals(LOINC_CODESYSTEM_URL)) {
                return this.getVersionedSystem("loinc", systemVersion);
            }
            if (systemBaseName.equals(UCUM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("ucum", systemVersion);
            }
            if (systemBaseName.startsWith(HL7_SID_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_SID_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.equals(_11073_CODESYSTEM_URN)) {
                return this.getVersionedSystem("11073", systemVersion);
            }
            if (systemBaseName.startsWith(ISO_CODESYSTEM_URN)) {
                return this.getVersionedSystem("iso" + systemBaseName.substring(ISO_CODESYSTEM_URN.length()).replace(":", ""), systemVersion);
            }
            if (systemBaseName.startsWith(HL7_TERMINOLOGY_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_TERMINOLOGY_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.startsWith(HL7_FHIR_CODESYSTEM_BASE_URL)) {
                return this.getVersionedSystem(this.normalizeBaseURL(HL7_FHIR_CODESYSTEM_BASE_URL, systemBaseName), systemVersion);
            }
            if (systemBaseName.equals(LANG_CODESYSTEM_URN)) {
                return this.getVersionedSystem("lang", systemVersion);
            }
            if (systemBaseName.equals(MIMETYPES_CODESYSTEM_URN)) {
                return this.getVersionedSystem("mimetypes", systemVersion);
            }
            if (systemBaseName.equals(DICOM_CODESYSTEM_URL)) {
                return this.getVersionedSystem("dicom", systemVersion);
            }
            return this.getVersionedSystem(systemBaseName.replace("/", "_").replace(":", "_").replace("?", "X").replace("#", "X"), systemVersion);
        }

        public String normalizeBaseURL(String baseUrl, String fullUrl) {
            return fullUrl.substring(baseUrl.length()).replace("/", "");
        }

        public String getVersionedSystem(String baseSystem, String version) {
            if (version != null) {
                return baseSystem + "_" + version;
            }
            return baseSystem;
        }
    }

    public static class SubsumesResult {
        private Boolean result;

        protected SubsumesResult(Boolean result) {
            this.result = result;
        }

        public Boolean getResult() {
            return this.result;
        }
    }

    public class CacheToken {
        private String name;
        private String key;
        private String request;
        private boolean hasVersion;

        public void setName(String n) {
            String systemName = TerminologyCache.this.getSystemNameKeyGenerator().getNameForSystem(n);
            if (this.name == null) {
                this.name = systemName;
            } else if (!systemName.equals(this.name)) {
                this.name = TerminologyCache.NAME_FOR_NO_SYSTEM;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getRequest() {
            return this.request;
        }

        public boolean hasVersion() {
            return this.hasVersion;
        }
    }

    public static class SourcedValueSetEntry {
        private String server;
        private String filename;

        public SourcedValueSetEntry(String server, String filename) {
            this.server = server;
            this.filename = filename;
        }

        public String getServer() {
            return this.server;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public static class SourcedValueSet {
        private String server;
        private ValueSet vs;

        public SourcedValueSet(String server, ValueSet vs) {
            this.server = server;
            this.vs = vs;
        }

        public String getServer() {
            return this.server;
        }

        public ValueSet getVs() {
            return this.vs;
        }
    }

    public static class SourcedCodeSystemEntry {
        private String server;
        private String filename;

        public SourcedCodeSystemEntry(String server, String filename) {
            this.server = server;
            this.filename = filename;
        }

        public String getServer() {
            return this.server;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public static class SourcedCodeSystem {
        private String server;
        private CodeSystem cs;

        public SourcedCodeSystem(String server, CodeSystem cs) {
            this.server = server;
            this.cs = cs;
        }

        public String getServer() {
            return this.server;
        }

        public CodeSystem getCs() {
            return this.cs;
        }
    }
}

