/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValidationResult {
    private CodeSystem.ConceptDefinitionComponent definition;
    private String preferredDisplay;
    private String system;
    private String version;
    private ValidationMessage.IssueSeverity severity;
    private List<String> messages = new ArrayList<String>();
    private TerminologyServiceErrorClass errorClass;
    private String txLink;
    private String diagnostics;
    private List<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
    private CodeableConcept codeableConcept;
    private Set<String> unknownSystems;
    private boolean inactive;
    private String status;
    private String server;

    public String toString() {
        return "ValidationResult [definition=" + this.definition + ", system=" + this.system + ", severity=" + this.severity + ", message=" + this.getMessage() + ", errorClass=" + this.errorClass + ", txLink=" + this.txLink + "]";
    }

    public ValidationResult(ValidationMessage.IssueSeverity severity, String message, List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
        this.severity = severity;
        if (message != null) {
            this.messages.add(message);
        }
        if (issues != null) {
            this.issues.addAll(issues);
        }
    }

    public ValidationResult(String system, String version, CodeSystem.ConceptDefinitionComponent definition, String preferredDisplay) {
        this.system = system;
        this.version = version;
        this.definition = definition;
        this.preferredDisplay = preferredDisplay;
    }

    public ValidationResult(ValidationMessage.IssueSeverity severity, String message, String system, String version, CodeSystem.ConceptDefinitionComponent definition, String preferredDisplay, List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
        this.severity = severity;
        if (message != null) {
            this.messages.add(message);
        }
        this.system = system;
        this.version = version;
        this.definition = definition;
        this.preferredDisplay = preferredDisplay;
        if (issues != null) {
            this.issues.addAll(issues);
        }
    }

    public ValidationResult(ValidationMessage.IssueSeverity severity, List<String> messages, String system, String version, CodeSystem.ConceptDefinitionComponent definition, String preferredDisplay, List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
        this.severity = severity;
        this.messages.addAll(messages);
        this.system = system;
        this.version = version;
        this.definition = definition;
        this.preferredDisplay = preferredDisplay;
        if (issues != null) {
            this.issues.addAll(issues);
        }
    }

    public ValidationResult(ValidationMessage.IssueSeverity severity, String message, TerminologyServiceErrorClass errorClass, List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
        this.severity = severity;
        if (message != null) {
            this.messages.add(message);
        }
        this.errorClass = errorClass;
        if (issues != null) {
            this.issues.addAll(issues);
        }
    }

    public boolean isOk() {
        return this.severity == null || this.severity == ValidationMessage.IssueSeverity.INFORMATION || this.severity == ValidationMessage.IssueSeverity.WARNING;
    }

    public String getSystem() {
        return this.system;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDisplay() {
        if (this.preferredDisplay != null) {
            return this.preferredDisplay;
        }
        return this.definition == null ? null : this.definition.getDisplay();
    }

    public void setDisplay(String display) {
        this.preferredDisplay = display;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCode() {
        return this.definition == null ? null : this.definition.getCode();
    }

    public String getDefinition() {
        return this.definition == null ? null : this.definition.getDefinition();
    }

    public void setDefinition(CodeSystem.ConceptDefinitionComponent definition) {
        this.definition = definition;
    }

    public CodeSystem.ConceptDefinitionComponent asConceptDefinition() {
        return this.definition;
    }

    public ValidationMessage.IssueSeverity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        if (this.messages.size() == 0) {
            return null;
        }
        Collections.sort(this.messages);
        return CommaSeparatedStringBuilder.join((String)"; ", this.messages);
    }

    public String getTrimmedMessage() {
        ArrayList<String> toTrim = new ArrayList<String>();
        for (OperationOutcome.OperationOutcomeIssueComponent iss : this.getIssues()) {
            toTrim.add(iss.getDetails().getText());
        }
        ArrayList<String> trimmed = new ArrayList<String>();
        trimmed.addAll(this.messages);
        trimmed.removeAll(toTrim);
        if (trimmed.size() == 0) {
            return null;
        }
        Collections.sort(trimmed);
        return CommaSeparatedStringBuilder.join((String)"; ", trimmed);
    }

    public boolean IsNoService() {
        return this.errorClass == TerminologyServiceErrorClass.NOSERVICE;
    }

    public TerminologyServiceErrorClass getErrorClass() {
        return this.errorClass;
    }

    public ValidationResult setSeverity(ValidationMessage.IssueSeverity severity) {
        this.severity = severity;
        return this;
    }

    public ValidationResult setMessage(String message) {
        this.messages.clear();
        if (message != null) {
            this.messages.add(message);
        }
        return this;
    }

    public ValidationResult addMessage(String message) {
        if (message != null) {
            this.messages.add(message);
        }
        return this;
    }

    public ValidationResult setErrorClass(TerminologyServiceErrorClass errorClass) {
        this.errorClass = errorClass;
        return this;
    }

    public String getTxLink() {
        return this.txLink;
    }

    public ValidationResult setTxLink(String txLink) {
        this.txLink = txLink;
        return this;
    }

    public boolean hasMessage() {
        return !this.messages.isEmpty();
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(String diagnostics) {
        this.diagnostics = diagnostics;
    }

    public Coding asCoding() {
        if (this.isOk() && this.definition != null && this.definition.getCode() != null) {
            return new Coding(this.system, this.definition.getCode(), this.definition.getDisplay());
        }
        return null;
    }

    public List<OperationOutcome.OperationOutcomeIssueComponent> getIssues() {
        return this.issues;
    }

    public ValidationResult addCodeableConcept(CodeableConcept vcc) {
        if (!vcc.isEmpty()) {
            this.codeableConcept = vcc;
        }
        return this;
    }

    public CodeableConcept getCodeableConcept() {
        return this.codeableConcept;
    }

    public Set<String> getUnknownSystems() {
        return this.unknownSystems;
    }

    public ValidationResult setUnknownSystems(Set<String> unknownSystems) {
        this.unknownSystems = unknownSystems;
        return this;
    }

    public String unknownSystems() {
        if (this.unknownSystems == null) {
            return null;
        }
        if (this.unknownSystems.size() == 1) {
            return this.unknownSystems.iterator().next();
        }
        return String.join((CharSequence)",", this.unknownSystems);
    }

    public void setIssues(List<OperationOutcome.OperationOutcomeIssueComponent> issues) {
        if (this.issues != null) {
            issues.addAll(this.issues);
        }
        this.issues = issues;
    }

    public void trimPath(String prefix) {
        if (this.issues != null) {
            for (OperationOutcome.OperationOutcomeIssueComponent iss : this.issues) {
                String s;
                int i;
                for (i = iss.getLocation().size() - 1; i >= 0; --i) {
                    s = iss.getLocation().get(i).primitiveValue();
                    if (prefix.equals(s)) {
                        iss.getLocation().remove(i);
                        continue;
                    }
                    if (!s.startsWith(prefix + ".")) continue;
                    iss.getLocation().get(i).setValueAsString(s.substring(prefix.length() + 1));
                }
                for (i = iss.getExpression().size() - 1; i >= 0; --i) {
                    s = iss.getExpression().get(i).primitiveValue();
                    if (prefix.equals(s)) {
                        iss.getExpression().remove(i);
                        continue;
                    }
                    if (!s.startsWith(prefix + ".")) continue;
                    iss.getExpression().get(i).setValueAsString(s.substring(prefix.length() + 1));
                }
            }
        }
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public String getStatus() {
        return this.status;
    }

    public ValidationResult setStatus(boolean inactive, String status) {
        this.inactive = inactive;
        if (!"inactive".equals(status)) {
            this.status = status;
        }
        return this;
    }

    public boolean messageIsInIssues() {
        for (String s : this.messages) {
            boolean found = false;
            for (OperationOutcome.OperationOutcomeIssueComponent iss : this.issues) {
                if (iss.getSeverity().ordinal() > this.getSeverity().ordinal() || !s.equals(iss.getDetails().getText())) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }
}

