/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.VersionUtilities;

public class StructureDefinitionHacker {
    private String version;

    public StructureDefinitionHacker(String version) {
        this.version = version;
    }

    public Resource fixSD(StructureDefinition sd) {
        if (VersionUtilities.isR4Ver((String)this.version) && "http://hl7.org/fhir/StructureDefinition/example-composition".equals(sd.getUrl())) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                this.fixDocSecURL(ed);
            }
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                this.fixDocSecURL(ed);
                if (!"ClinicalImpression.problem".equals(ed.getPath())) continue;
                ed.setComment("e.g. The patient is a pregnant, has congestive heart failure, has an Adenocarcinoma, and is allergic to penicillin.");
            }
        }
        if (VersionUtilities.isR4Ver((String)this.version) && "http://hl7.org/fhir/StructureDefinition/ClinicalImpression".equals(sd.getUrl())) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!"ClinicalImpression.problem".equals(ed.getPath())) continue;
                ed.setComment("e.g. The patient is a pregnant, has congestive heart failure, has an Adenocarcinoma, and is allergic to penicillin.");
            }
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                if (!"ClinicalImpression.problem".equals(ed.getPath())) continue;
                ed.setComment("e.g. The patient is a pregnant, has congestive heart failure, has an Adenocarcinoma, and is allergic to penicillin.");
            }
        }
        if (VersionUtilities.isR4Ver((String)this.version) && "http://hl7.org/fhir/StructureDefinition/Consent".equals(sd.getUrl())) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!"Consent.identifier".equals(ed.getPath())) continue;
                ed.getExampleFirstRep().getValueIdentifier().setSystem("http://acme.org/identifier/local/eCMS");
            }
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                if (!"Consent.identifier".equals(ed.getPath())) continue;
                ed.getExampleFirstRep().getValueIdentifier().setSystem("http://acme.org/identifier/local/eCMS");
            }
        }
        if (VersionUtilities.isR4Ver((String)this.version) && "http://hl7.org/fhir/StructureDefinition/ExplanationOfBenefit".equals(sd.getUrl())) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!ed.hasBinding() || !"http://terminology.hl7.org/CodeSystem/processpriority".equals(ed.getBinding().getValueSet())) continue;
                ed.getBinding().setValueSet("http://hl7.org/fhir/ValueSet/process-priority");
            }
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                if (!ed.hasBinding() || !"http://terminology.hl7.org/CodeSystem/processpriority".equals(ed.getBinding().getValueSet())) continue;
                ed.getBinding().setValueSet("http://hl7.org/fhir/ValueSet/process-priority");
            }
        }
        if (sd.getUrl().startsWith("http://hl7.org/fhir/uv/subscriptions-backport")) {
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                this.fixMarkdownR4BURLs(ed);
            }
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                this.fixMarkdownR4BURLs(ed);
            }
        }
        if ("http://hl7.org/fhir/StructureDefinition/vitalsigns".equals(sd.getUrl()) || "http://hl7.org/fhir/StructureDefinition/vitalsigns".equals(sd.getBaseDefinition())) {
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                this.checkVSConstraint(ed);
            }
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                this.checkVSConstraint(ed);
            }
        }
        return sd;
    }

    private void checkVSConstraint(ElementDefinition ed) {
        for (ElementDefinition.ElementDefinitionConstraintComponent constraint : ed.getConstraint()) {
            if (!"vs-1".equals(constraint.getKey())) continue;
            constraint.setExpression("$this is dateTime implies $this.toString().length() >= 10");
        }
    }

    private void fixMarkdownR4BURLs(ElementDefinition ed) {
        if (ed.hasDefinition()) {
            ed.setDefinition(ed.getDefinition().replace("http://hl7.org/fhir/R4B/", "http://hl7.org/fhir/R4/"));
        }
        if (ed.hasComment()) {
            ed.setComment(ed.getComment().replace("http://hl7.org/fhir/R4B/", "http://hl7.org/fhir/R4/"));
        }
        if (ed.hasRequirements()) {
            ed.setRequirements(ed.getRequirements().replace("http://hl7.org/fhir/R4B/", "http://hl7.org/fhir/R4/"));
        }
    }

    private void fixDocSecURL(ElementDefinition ed) {
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            for (CanonicalType c : tr.getProfile()) {
                if (!"http://hl7.org/fhir/StructureDefinition/document-section-library".equals(c.getValue())) continue;
                c.setValue("http://hl7.org/fhir/StructureDefinition/example-section-library");
            }
        }
    }
}

