/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.r5.context.BaseLogger;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class TextClientLogger
extends BaseLogger
implements ToolingClientLogger {
    private PrintStream file;

    public TextClientLogger(String log) throws IOException {
        if (log != null) {
            try {
                this.file = new PrintStream(ManagedFileAccess.outStream((String)log));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void logRequest(String method, String url, List<String> headers, byte[] body) {
        if (this.file == null) {
            return;
        }
        String id = this.nextId();
        this.file.println("\r\n--- " + id + " -----------------\r\nRequest: \r\n");
        this.file.println(method + " " + url + " HTTP/1.0");
        if (headers != null) {
            for (String s : headers) {
                this.file.println(s);
            }
        }
        if (body != null) {
            this.file.println("");
            try {
                this.file.println(new String(body, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public void logResponse(String outcome, List<String> headers, byte[] body, long length) {
        if (this.file == null) {
            return;
        }
        this.file.println("\r\n\r\nResponse (" + Utilities.describeDuration((long)length) + "): \r\n");
        this.file.println(outcome);
        for (String s : headers) {
            this.file.println(s);
        }
        if (body != null) {
            this.file.println("");
            try {
                this.file.println(new String(body, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

