/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ArtifactAssessment", profile="http://hl7.org/fhir/StructureDefinition/ArtifactAssessment")
public class ArtifactAssessment
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the artifact assessment", formalDefinition="A formal identifier that is used to identify this artifact assessment when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A short title for the assessment for use in displaying and selecting", formalDefinition="A short title for the assessment for use in displaying and selecting.")
    protected StringType title;
    @Child(name="citeAs", type={Citation.class, MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How to cite the comment or rating", formalDefinition="Display of or reference to the bibliographic citation of the comment, classifier, or rating.")
    protected DataType citeAs;
    @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the artifact assessment was published. The date must change when the disposition changes and it must change if the workflow status code changes. In addition, it should change when the substantive content of the artifact assessment changes.")
    protected DateTimeType date;
    @Child(name="copyright", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the artifact assessment and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the artifact assessment.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the artifact assessment was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the artifact assessment was last reviewed by the publisher", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="artifact", type={Reference.class, CanonicalType.class, UriType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The artifact assessed, commented upon or rated", formalDefinition="A reference to a resource, canonical resource, or non-FHIR resource which the comment or assessment is about.")
    protected DataType artifact;
    @Child(name="content", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comment, classifier, or rating content", formalDefinition="A component comment, classifier, or rating of the artifact.")
    protected List<ArtifactAssessmentContentComponent> content;
    @Child(name="workflowStatus", type={CodeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="submitted | triaged | waiting-for-input | resolved-no-change | resolved-change-required | deferred | duplicate | applied | published | entered-in-error", formalDefinition="Indicates the workflow status of the comment or change request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifactassessment-workflow-status")
    protected Enumeration<ArtifactAssessmentWorkflowStatus> workflowStatus;
    @Child(name="disposition", type={CodeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="unresolved | not-persuasive | persuasive | persuasive-with-modification | not-persuasive-with-modification", formalDefinition="Indicates the disposition of the responsible party to the comment or change request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifactassessment-disposition")
    protected Enumeration<ArtifactAssessmentDisposition> disposition;
    private static final long serialVersionUID = 525457507L;
    @SearchParamDefinition(name="date", path="ArtifactAssessment.date", description="The artifact assessment publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ArtifactAssessment.identifier", description="The artifact assessment identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public ArtifactAssessment() {
    }

    public ArtifactAssessment(DataType artifact) {
        this.setArtifact(artifact);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ArtifactAssessment setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ArtifactAssessment addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ArtifactAssessment.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ArtifactAssessment setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ArtifactAssessment setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public DataType getCiteAs() {
        return this.citeAs;
    }

    public Reference getCiteAsReference() throws FHIRException {
        if (this.citeAs == null) {
            this.citeAs = new Reference();
        }
        if (!(this.citeAs instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.citeAs.getClass().getName() + " was encountered");
        }
        return (Reference)this.citeAs;
    }

    public boolean hasCiteAsReference() {
        return this != null && this.citeAs instanceof Reference;
    }

    public MarkdownType getCiteAsMarkdownType() throws FHIRException {
        if (this.citeAs == null) {
            this.citeAs = new MarkdownType();
        }
        if (!(this.citeAs instanceof MarkdownType)) {
            throw new FHIRException("Type mismatch: the type MarkdownType was expected, but " + this.citeAs.getClass().getName() + " was encountered");
        }
        return (MarkdownType)this.citeAs;
    }

    public boolean hasCiteAsMarkdownType() {
        return this != null && this.citeAs instanceof MarkdownType;
    }

    public boolean hasCiteAs() {
        return this.citeAs != null && !this.citeAs.isEmpty();
    }

    public ArtifactAssessment setCiteAs(DataType value) {
        if (value != null && !(value instanceof Reference) && !(value instanceof MarkdownType)) {
            throw new FHIRException("Not the right type for ArtifactAssessment.citeAs[x]: " + value.fhirType());
        }
        this.citeAs = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ArtifactAssessment.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ArtifactAssessment setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ArtifactAssessment setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ArtifactAssessment.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ArtifactAssessment setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ArtifactAssessment setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ArtifactAssessment.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public ArtifactAssessment setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public ArtifactAssessment setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ArtifactAssessment.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public ArtifactAssessment setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public ArtifactAssessment setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public DataType getArtifact() {
        return this.artifact;
    }

    public Reference getArtifactReference() throws FHIRException {
        if (this.artifact == null) {
            this.artifact = new Reference();
        }
        if (!(this.artifact instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.artifact.getClass().getName() + " was encountered");
        }
        return (Reference)this.artifact;
    }

    public boolean hasArtifactReference() {
        return this != null && this.artifact instanceof Reference;
    }

    public CanonicalType getArtifactCanonicalType() throws FHIRException {
        if (this.artifact == null) {
            this.artifact = new CanonicalType();
        }
        if (!(this.artifact instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.artifact.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.artifact;
    }

    public boolean hasArtifactCanonicalType() {
        return this != null && this.artifact instanceof CanonicalType;
    }

    public UriType getArtifactUriType() throws FHIRException {
        if (this.artifact == null) {
            this.artifact = new UriType();
        }
        if (!(this.artifact instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.artifact.getClass().getName() + " was encountered");
        }
        return (UriType)this.artifact;
    }

    public boolean hasArtifactUriType() {
        return this != null && this.artifact instanceof UriType;
    }

    public boolean hasArtifact() {
        return this.artifact != null && !this.artifact.isEmpty();
    }

    public ArtifactAssessment setArtifact(DataType value) {
        if (!(value == null || value instanceof Reference || value instanceof CanonicalType || value instanceof UriType)) {
            throw new FHIRException("Not the right type for ArtifactAssessment.artifact[x]: " + value.fhirType());
        }
        this.artifact = value;
        return this;
    }

    public List<ArtifactAssessmentContentComponent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<ArtifactAssessmentContentComponent>();
        }
        return this.content;
    }

    public ArtifactAssessment setContent(List<ArtifactAssessmentContentComponent> theContent) {
        this.content = theContent;
        return this;
    }

    public boolean hasContent() {
        if (this.content == null) {
            return false;
        }
        for (ArtifactAssessmentContentComponent item : this.content) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ArtifactAssessmentContentComponent addContent() {
        ArtifactAssessmentContentComponent t = new ArtifactAssessmentContentComponent();
        if (this.content == null) {
            this.content = new ArrayList<ArtifactAssessmentContentComponent>();
        }
        this.content.add(t);
        return t;
    }

    public ArtifactAssessment addContent(ArtifactAssessmentContentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.content == null) {
            this.content = new ArrayList<ArtifactAssessmentContentComponent>();
        }
        this.content.add(t);
        return this;
    }

    public ArtifactAssessmentContentComponent getContentFirstRep() {
        if (this.getContent().isEmpty()) {
            this.addContent();
        }
        return this.getContent().get(0);
    }

    public Enumeration<ArtifactAssessmentWorkflowStatus> getWorkflowStatusElement() {
        if (this.workflowStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ArtifactAssessment.workflowStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.workflowStatus = new Enumeration<ArtifactAssessmentWorkflowStatus>(new ArtifactAssessmentWorkflowStatusEnumFactory());
            }
        }
        return this.workflowStatus;
    }

    public boolean hasWorkflowStatusElement() {
        return this.workflowStatus != null && !this.workflowStatus.isEmpty();
    }

    public boolean hasWorkflowStatus() {
        return this.workflowStatus != null && !this.workflowStatus.isEmpty();
    }

    public ArtifactAssessment setWorkflowStatusElement(Enumeration<ArtifactAssessmentWorkflowStatus> value) {
        this.workflowStatus = value;
        return this;
    }

    public ArtifactAssessmentWorkflowStatus getWorkflowStatus() {
        return this.workflowStatus == null ? null : (ArtifactAssessmentWorkflowStatus)((Object)this.workflowStatus.getValue());
    }

    public ArtifactAssessment setWorkflowStatus(ArtifactAssessmentWorkflowStatus value) {
        if (value == null) {
            this.workflowStatus = null;
        } else {
            if (this.workflowStatus == null) {
                this.workflowStatus = new Enumeration<ArtifactAssessmentWorkflowStatus>(new ArtifactAssessmentWorkflowStatusEnumFactory());
            }
            this.workflowStatus.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<ArtifactAssessmentDisposition> getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ArtifactAssessment.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new Enumeration<ArtifactAssessmentDisposition>(new ArtifactAssessmentDispositionEnumFactory());
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ArtifactAssessment setDispositionElement(Enumeration<ArtifactAssessmentDisposition> value) {
        this.disposition = value;
        return this;
    }

    public ArtifactAssessmentDisposition getDisposition() {
        return this.disposition == null ? null : (ArtifactAssessmentDisposition)((Object)this.disposition.getValue());
    }

    public ArtifactAssessment setDisposition(ArtifactAssessmentDisposition value) {
        if (value == null) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new Enumeration<ArtifactAssessmentDisposition>(new ArtifactAssessmentDispositionEnumFactory());
            }
            this.disposition.setValue((Object)value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this artifact assessment when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("title", "string", "A short title for the assessment for use in displaying and selecting.", 0, 1, this.title));
        children.add(new Property("citeAs[x]", "Reference(Citation)|markdown", "Display of or reference to the bibliographic citation of the comment, classifier, or rating.", 0, 1, this.citeAs));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the artifact assessment was published. The date must change when the disposition changes and it must change if the workflow status code changes. In addition, it should change when the substantive content of the artifact assessment changes.", 0, 1, this.date));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the artifact assessment and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the artifact assessment.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("artifact[x]", "Reference(Any)|canonical|uri", "A reference to a resource, canonical resource, or non-FHIR resource which the comment or assessment is about.", 0, 1, this.artifact));
        children.add(new Property("content", "", "A component comment, classifier, or rating of the artifact.", 0, Integer.MAX_VALUE, this.content));
        children.add(new Property("workflowStatus", "code", "Indicates the workflow status of the comment or change request.", 0, 1, this.workflowStatus));
        children.add(new Property("disposition", "code", "Indicates the disposition of the responsible party to the comment or change request.", 0, 1, this.disposition));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this artifact assessment when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 110371416: {
                return new Property("title", "string", "A short title for the assessment for use in displaying and selecting.", 0, 1, this.title);
            }
            case -1706539017: {
                return new Property("citeAs[x]", "Reference(Citation)|markdown", "Display of or reference to the bibliographic citation of the comment, classifier, or rating.", 0, 1, this.citeAs);
            }
            case -1360156695: {
                return new Property("citeAs[x]", "Reference(Citation)|markdown", "Display of or reference to the bibliographic citation of the comment, classifier, or rating.", 0, 1, this.citeAs);
            }
            case 1269009762: {
                return new Property("citeAs[x]", "Reference(Citation)", "Display of or reference to the bibliographic citation of the comment, classifier, or rating.", 0, 1, this.citeAs);
            }
            case 456265720: {
                return new Property("citeAs[x]", "markdown", "Display of or reference to the bibliographic citation of the comment, classifier, or rating.", 0, 1, this.citeAs);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the artifact assessment was published. The date must change when the disposition changes and it must change if the workflow status code changes. In addition, it should change when the substantive content of the artifact assessment changes.", 0, 1, this.date);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the artifact assessment and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the artifact assessment.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -1130056338: {
                return new Property("artifact[x]", "Reference(Any)|canonical|uri", "A reference to a resource, canonical resource, or non-FHIR resource which the comment or assessment is about.", 0, 1, this.artifact);
            }
            case -1228798510: {
                return new Property("artifact[x]", "Reference(Any)|canonical|uri", "A reference to a resource, canonical resource, or non-FHIR resource which the comment or assessment is about.", 0, 1, this.artifact);
            }
            case -683686503: {
                return new Property("artifact[x]", "Reference(Any)", "A reference to a resource, canonical resource, or non-FHIR resource which the comment or assessment is about.", 0, 1, this.artifact);
            }
            case 1069820738: {
                return new Property("artifact[x]", "canonical", "A reference to a resource, canonical resource, or non-FHIR resource which the comment or assessment is about.", 0, 1, this.artifact);
            }
            case -1130062278: {
                return new Property("artifact[x]", "uri", "A reference to a resource, canonical resource, or non-FHIR resource which the comment or assessment is about.", 0, 1, this.artifact);
            }
            case 951530617: {
                return new Property("content", "", "A component comment, classifier, or rating of the artifact.", 0, Integer.MAX_VALUE, this.content);
            }
            case 697796753: {
                return new Property("workflowStatus", "code", "Indicates the workflow status of the comment or change request.", 0, 1, this.workflowStatus);
            }
            case 583380919: {
                return new Property("disposition", "code", "Indicates the disposition of the responsible party to the comment or change request.", 0, 1, this.disposition);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.title;
                }
                return baseArray;
            }
            case -1360156695: {
                Base[] baseArray;
                if (this.citeAs == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.citeAs;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.date;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -1228798510: {
                Base[] baseArray;
                if (this.artifact == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.artifact;
                }
                return baseArray;
            }
            case 951530617: {
                return this.content == null ? new Base[]{} : this.content.toArray(new Base[this.content.size()]);
            }
            case 697796753: {
                Base[] baseArray;
                if (this.workflowStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.workflowStatus;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.disposition;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -1360156695: {
                this.citeAs = TypeConvertor.castToType(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1228798510: {
                this.artifact = TypeConvertor.castToType(value);
                return value;
            }
            case 951530617: {
                this.getContent().add((ArtifactAssessmentContentComponent)((Object)value));
                return value;
            }
            case 697796753: {
                value = new ArtifactAssessmentWorkflowStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.workflowStatus = value;
                return value;
            }
            case 583380919: {
                value = new ArtifactAssessmentDispositionEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.disposition = value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("title")) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("citeAs[x]")) {
            this.citeAs = TypeConvertor.castToType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("artifact[x]")) {
            this.artifact = TypeConvertor.castToType(value);
        } else if (name.equals("content")) {
            this.getContent().add((ArtifactAssessmentContentComponent)((Object)value));
        } else if (name.equals("workflowStatus")) {
            value = new ArtifactAssessmentWorkflowStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.workflowStatus = value;
        } else if (name.equals("disposition")) {
            value = new ArtifactAssessmentDispositionEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.disposition = value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("title")) {
            this.title = null;
        } else if (name.equals("citeAs[x]")) {
            this.citeAs = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("approvalDate")) {
            this.approvalDate = null;
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = null;
        } else if (name.equals("artifact[x]")) {
            this.artifact = null;
        } else if (name.equals("content")) {
            this.getContent().remove((ArtifactAssessmentContentComponent)((Object)value));
        } else if (name.equals("workflowStatus")) {
            value = new ArtifactAssessmentWorkflowStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.workflowStatus = value;
        } else if (name.equals("disposition")) {
            value = new ArtifactAssessmentDispositionEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.disposition = value;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -1706539017: {
                return this.getCiteAs();
            }
            case -1360156695: {
                return this.getCiteAs();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -1130056338: {
                return this.getArtifact();
            }
            case -1228798510: {
                return this.getArtifact();
            }
            case 951530617: {
                return this.addContent();
            }
            case 697796753: {
                return this.getWorkflowStatusElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -1360156695: {
                return new String[]{"Reference", "markdown"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -1228798510: {
                return new String[]{"Reference", "canonical", "uri"};
            }
            case 951530617: {
                return new String[0];
            }
            case 697796753: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"code"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.title");
        }
        if (name.equals("citeAsReference")) {
            this.citeAs = new Reference();
            return this.citeAs;
        }
        if (name.equals("citeAsMarkdown")) {
            this.citeAs = new MarkdownType();
            return this.citeAs;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.date");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.lastReviewDate");
        }
        if (name.equals("artifactReference")) {
            this.artifact = new Reference();
            return this.artifact;
        }
        if (name.equals("artifactCanonical")) {
            this.artifact = new CanonicalType();
            return this.artifact;
        }
        if (name.equals("artifactUri")) {
            this.artifact = new UriType();
            return this.artifact;
        }
        if (name.equals("content")) {
            return this.addContent();
        }
        if (name.equals("workflowStatus")) {
            throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.workflowStatus");
        }
        if (name.equals("disposition")) {
            throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.disposition");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ArtifactAssessment";
    }

    @Override
    public ArtifactAssessment copy() {
        ArtifactAssessment dst = new ArtifactAssessment();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ArtifactAssessment dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.title = this.title == null ? null : this.title.copy();
        dst.citeAs = this.citeAs == null ? null : this.citeAs.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        DataType dataType = dst.artifact = this.artifact == null ? null : this.artifact.copy();
        if (this.content != null) {
            dst.content = new ArrayList<ArtifactAssessmentContentComponent>();
            for (ArtifactAssessmentContentComponent artifactAssessmentContentComponent : this.content) {
                dst.content.add(artifactAssessmentContentComponent.copy());
            }
        }
        dst.workflowStatus = this.workflowStatus == null ? null : this.workflowStatus.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
    }

    protected ArtifactAssessment typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ArtifactAssessment)) {
            return false;
        }
        ArtifactAssessment o = (ArtifactAssessment)other_;
        return ArtifactAssessment.compareDeep(this.identifier, o.identifier, true) && ArtifactAssessment.compareDeep(this.title, o.title, true) && ArtifactAssessment.compareDeep(this.citeAs, o.citeAs, true) && ArtifactAssessment.compareDeep(this.date, o.date, true) && ArtifactAssessment.compareDeep(this.copyright, o.copyright, true) && ArtifactAssessment.compareDeep(this.approvalDate, o.approvalDate, true) && ArtifactAssessment.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ArtifactAssessment.compareDeep(this.artifact, o.artifact, true) && ArtifactAssessment.compareDeep(this.content, o.content, true) && ArtifactAssessment.compareDeep(this.workflowStatus, o.workflowStatus, true) && ArtifactAssessment.compareDeep(this.disposition, o.disposition, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ArtifactAssessment)) {
            return false;
        }
        ArtifactAssessment o = (ArtifactAssessment)other_;
        return ArtifactAssessment.compareValues(this.title, o.title, true) && ArtifactAssessment.compareValues(this.date, o.date, true) && ArtifactAssessment.compareValues(this.copyright, o.copyright, true) && ArtifactAssessment.compareValues(this.approvalDate, o.approvalDate, true) && ArtifactAssessment.compareValues(this.lastReviewDate, o.lastReviewDate, true) && ArtifactAssessment.compareValues(this.workflowStatus, o.workflowStatus, true) && ArtifactAssessment.compareValues(this.disposition, o.disposition, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.title, this.citeAs, this.date, this.copyright, this.approvalDate, this.lastReviewDate, this.artifact, this.content, this.workflowStatus, this.disposition});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ArtifactAssessment;
    }

    @Block
    public static class ArtifactAssessmentContentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="informationType", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="comment | classifier | rating | container | response | change-request", formalDefinition="The type of information this component of the content represents.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/artifactassessment-information-type")
        protected Enumeration<ArtifactAssessmentInformationType> informationType;
        @Child(name="summary", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Brief summary of the content", formalDefinition="A brief summary of the content of this component.")
        protected MarkdownType summary;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What type of content", formalDefinition="Indicates what type of content this component represents.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-type")
        protected CodeableConcept type;
        @Child(name="classifier", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rating, classifier, or assessment", formalDefinition="Represents a rating, classifier, or assessment of the artifact.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/certainty-rating")
        protected List<CodeableConcept> classifier;
        @Child(name="quantity", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantitative rating", formalDefinition="A quantitative rating of the artifact.")
        protected Quantity quantity;
        @Child(name="author", type={Patient.class, Practitioner.class, PractitionerRole.class, Organization.class, Device.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who authored the content", formalDefinition="Indicates who or what authored the content.")
        protected Reference author;
        @Child(name="path", type={UriType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What the comment is directed to", formalDefinition="A URI that points to what the comment is about, such as a line of text in the CQL, or a specific element in a resource.")
        protected List<UriType> path;
        @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information", formalDefinition="Additional related artifacts that provide supporting documentation, additional evidence, or further information related to the content.")
        protected List<RelatedArtifact> relatedArtifact;
        @Child(name="freeToShare", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Acceptable to publicly share the resource content", formalDefinition="Acceptable to publicly share the comment, classifier or rating.")
        protected BooleanType freeToShare;
        @Child(name="component", type={ArtifactAssessmentContentComponent.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contained content", formalDefinition="If the informationType is container, the components of the content.")
        protected List<ArtifactAssessmentContentComponent> component;
        private static final long serialVersionUID = -111630435L;

        public Enumeration<ArtifactAssessmentInformationType> getInformationTypeElement() {
            if (this.informationType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ArtifactAssessmentContentComponent.informationType");
                }
                if (Configuration.doAutoCreate()) {
                    this.informationType = new Enumeration<ArtifactAssessmentInformationType>(new ArtifactAssessmentInformationTypeEnumFactory());
                }
            }
            return this.informationType;
        }

        public boolean hasInformationTypeElement() {
            return this.informationType != null && !this.informationType.isEmpty();
        }

        public boolean hasInformationType() {
            return this.informationType != null && !this.informationType.isEmpty();
        }

        public ArtifactAssessmentContentComponent setInformationTypeElement(Enumeration<ArtifactAssessmentInformationType> value) {
            this.informationType = value;
            return this;
        }

        public ArtifactAssessmentInformationType getInformationType() {
            return this.informationType == null ? null : (ArtifactAssessmentInformationType)((Object)this.informationType.getValue());
        }

        public ArtifactAssessmentContentComponent setInformationType(ArtifactAssessmentInformationType value) {
            if (value == null) {
                this.informationType = null;
            } else {
                if (this.informationType == null) {
                    this.informationType = new Enumeration<ArtifactAssessmentInformationType>(new ArtifactAssessmentInformationTypeEnumFactory());
                }
                this.informationType.setValue((Object)value);
            }
            return this;
        }

        public MarkdownType getSummaryElement() {
            if (this.summary == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ArtifactAssessmentContentComponent.summary");
                }
                if (Configuration.doAutoCreate()) {
                    this.summary = new MarkdownType();
                }
            }
            return this.summary;
        }

        public boolean hasSummaryElement() {
            return this.summary != null && !this.summary.isEmpty();
        }

        public boolean hasSummary() {
            return this.summary != null && !this.summary.isEmpty();
        }

        public ArtifactAssessmentContentComponent setSummaryElement(MarkdownType value) {
            this.summary = value;
            return this;
        }

        public String getSummary() {
            return this.summary == null ? null : (String)this.summary.getValue();
        }

        public ArtifactAssessmentContentComponent setSummary(String value) {
            if (Utilities.noString((String)value)) {
                this.summary = null;
            } else {
                if (this.summary == null) {
                    this.summary = new MarkdownType();
                }
                this.summary.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ArtifactAssessmentContentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ArtifactAssessmentContentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getClassifier() {
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            return this.classifier;
        }

        public ArtifactAssessmentContentComponent setClassifier(List<CodeableConcept> theClassifier) {
            this.classifier = theClassifier;
            return this;
        }

        public boolean hasClassifier() {
            if (this.classifier == null) {
                return false;
            }
            for (CodeableConcept item : this.classifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return t;
        }

        public ArtifactAssessmentContentComponent addClassifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classifier == null) {
                this.classifier = new ArrayList<CodeableConcept>();
            }
            this.classifier.add(t);
            return this;
        }

        public CodeableConcept getClassifierFirstRep() {
            if (this.getClassifier().isEmpty()) {
                this.addClassifier();
            }
            return this.getClassifier().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ArtifactAssessmentContentComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ArtifactAssessmentContentComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Reference getAuthor() {
            if (this.author == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ArtifactAssessmentContentComponent.author");
                }
                if (Configuration.doAutoCreate()) {
                    this.author = new Reference();
                }
            }
            return this.author;
        }

        public boolean hasAuthor() {
            return this.author != null && !this.author.isEmpty();
        }

        public ArtifactAssessmentContentComponent setAuthor(Reference value) {
            this.author = value;
            return this;
        }

        public List<UriType> getPath() {
            if (this.path == null) {
                this.path = new ArrayList<UriType>();
            }
            return this.path;
        }

        public ArtifactAssessmentContentComponent setPath(List<UriType> thePath) {
            this.path = thePath;
            return this;
        }

        public boolean hasPath() {
            if (this.path == null) {
                return false;
            }
            for (UriType item : this.path) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addPathElement() {
            UriType t = new UriType();
            if (this.path == null) {
                this.path = new ArrayList<UriType>();
            }
            this.path.add(t);
            return t;
        }

        public ArtifactAssessmentContentComponent addPath(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.path == null) {
                this.path = new ArrayList<UriType>();
            }
            this.path.add(t);
            return this;
        }

        public boolean hasPath(String value) {
            if (this.path == null) {
                return false;
            }
            for (UriType v : this.path) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<RelatedArtifact> getRelatedArtifact() {
            if (this.relatedArtifact == null) {
                this.relatedArtifact = new ArrayList<RelatedArtifact>();
            }
            return this.relatedArtifact;
        }

        public ArtifactAssessmentContentComponent setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
            this.relatedArtifact = theRelatedArtifact;
            return this;
        }

        public boolean hasRelatedArtifact() {
            if (this.relatedArtifact == null) {
                return false;
            }
            for (RelatedArtifact item : this.relatedArtifact) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addRelatedArtifact() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.relatedArtifact == null) {
                this.relatedArtifact = new ArrayList<RelatedArtifact>();
            }
            this.relatedArtifact.add(t);
            return t;
        }

        public ArtifactAssessmentContentComponent addRelatedArtifact(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.relatedArtifact == null) {
                this.relatedArtifact = new ArrayList<RelatedArtifact>();
            }
            this.relatedArtifact.add(t);
            return this;
        }

        public RelatedArtifact getRelatedArtifactFirstRep() {
            if (this.getRelatedArtifact().isEmpty()) {
                this.addRelatedArtifact();
            }
            return this.getRelatedArtifact().get(0);
        }

        public BooleanType getFreeToShareElement() {
            if (this.freeToShare == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ArtifactAssessmentContentComponent.freeToShare");
                }
                if (Configuration.doAutoCreate()) {
                    this.freeToShare = new BooleanType();
                }
            }
            return this.freeToShare;
        }

        public boolean hasFreeToShareElement() {
            return this.freeToShare != null && !this.freeToShare.isEmpty();
        }

        public boolean hasFreeToShare() {
            return this.freeToShare != null && !this.freeToShare.isEmpty();
        }

        public ArtifactAssessmentContentComponent setFreeToShareElement(BooleanType value) {
            this.freeToShare = value;
            return this;
        }

        public boolean getFreeToShare() {
            return this.freeToShare == null || this.freeToShare.isEmpty() ? false : (Boolean)this.freeToShare.getValue();
        }

        public ArtifactAssessmentContentComponent setFreeToShare(boolean value) {
            if (this.freeToShare == null) {
                this.freeToShare = new BooleanType();
            }
            this.freeToShare.setValue((Object)value);
            return this;
        }

        public List<ArtifactAssessmentContentComponent> getComponent() {
            if (this.component == null) {
                this.component = new ArrayList<ArtifactAssessmentContentComponent>();
            }
            return this.component;
        }

        public ArtifactAssessmentContentComponent setComponent(List<ArtifactAssessmentContentComponent> theComponent) {
            this.component = theComponent;
            return this;
        }

        public boolean hasComponent() {
            if (this.component == null) {
                return false;
            }
            for (ArtifactAssessmentContentComponent item : this.component) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ArtifactAssessmentContentComponent addComponent() {
            ArtifactAssessmentContentComponent t = new ArtifactAssessmentContentComponent();
            if (this.component == null) {
                this.component = new ArrayList<ArtifactAssessmentContentComponent>();
            }
            this.component.add(t);
            return t;
        }

        public ArtifactAssessmentContentComponent addComponent(ArtifactAssessmentContentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.component == null) {
                this.component = new ArrayList<ArtifactAssessmentContentComponent>();
            }
            this.component.add(t);
            return this;
        }

        public ArtifactAssessmentContentComponent getComponentFirstRep() {
            if (this.getComponent().isEmpty()) {
                this.addComponent();
            }
            return this.getComponent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("informationType", "code", "The type of information this component of the content represents.", 0, 1, this.informationType));
            children.add(new Property("summary", "markdown", "A brief summary of the content of this component.", 0, 1, this.summary));
            children.add(new Property("type", "CodeableConcept", "Indicates what type of content this component represents.", 0, 1, this.type));
            children.add(new Property("classifier", "CodeableConcept", "Represents a rating, classifier, or assessment of the artifact.", 0, Integer.MAX_VALUE, this.classifier));
            children.add(new Property("quantity", "Quantity", "A quantitative rating of the artifact.", 0, 1, this.quantity));
            children.add(new Property("author", "Reference(Patient|Practitioner|PractitionerRole|Organization|Device)", "Indicates who or what authored the content.", 0, 1, this.author));
            children.add(new Property("path", "uri", "A URI that points to what the comment is about, such as a line of text in the CQL, or a specific element in a resource.", 0, Integer.MAX_VALUE, this.path));
            children.add(new Property("relatedArtifact", "RelatedArtifact", "Additional related artifacts that provide supporting documentation, additional evidence, or further information related to the content.", 0, Integer.MAX_VALUE, this.relatedArtifact));
            children.add(new Property("freeToShare", "boolean", "Acceptable to publicly share the comment, classifier or rating.", 0, 1, this.freeToShare));
            children.add(new Property("component", "@ArtifactAssessment.content", "If the informationType is container, the components of the content.", 0, Integer.MAX_VALUE, this.component));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1302856326: {
                    return new Property("informationType", "code", "The type of information this component of the content represents.", 0, 1, this.informationType);
                }
                case -1857640538: {
                    return new Property("summary", "markdown", "A brief summary of the content of this component.", 0, 1, this.summary);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Indicates what type of content this component represents.", 0, 1, this.type);
                }
                case -281470431: {
                    return new Property("classifier", "CodeableConcept", "Represents a rating, classifier, or assessment of the artifact.", 0, Integer.MAX_VALUE, this.classifier);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "A quantitative rating of the artifact.", 0, 1, this.quantity);
                }
                case -1406328437: {
                    return new Property("author", "Reference(Patient|Practitioner|PractitionerRole|Organization|Device)", "Indicates who or what authored the content.", 0, 1, this.author);
                }
                case 3433509: {
                    return new Property("path", "uri", "A URI that points to what the comment is about, such as a line of text in the CQL, or a specific element in a resource.", 0, Integer.MAX_VALUE, this.path);
                }
                case 666807069: {
                    return new Property("relatedArtifact", "RelatedArtifact", "Additional related artifacts that provide supporting documentation, additional evidence, or further information related to the content.", 0, Integer.MAX_VALUE, this.relatedArtifact);
                }
                case -1268656616: {
                    return new Property("freeToShare", "boolean", "Acceptable to publicly share the comment, classifier or rating.", 0, 1, this.freeToShare);
                }
                case -1399907075: {
                    return new Property("component", "@ArtifactAssessment.content", "If the informationType is container, the components of the content.", 0, Integer.MAX_VALUE, this.component);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1302856326: {
                    Base[] baseArray;
                    if (this.informationType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.informationType;
                    }
                    return baseArray;
                }
                case -1857640538: {
                    Base[] baseArray;
                    if (this.summary == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.summary;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case -281470431: {
                    return this.classifier == null ? new Base[]{} : this.classifier.toArray(new Base[this.classifier.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    Base[] baseArray;
                    if (this.author == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.author;
                    }
                    return baseArray;
                }
                case 3433509: {
                    return this.path == null ? new Base[]{} : this.path.toArray(new Base[this.path.size()]);
                }
                case 666807069: {
                    return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
                }
                case -1268656616: {
                    Base[] baseArray;
                    if (this.freeToShare == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.freeToShare;
                    }
                    return baseArray;
                }
                case -1399907075: {
                    return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1302856326: {
                    value = new ArtifactAssessmentInformationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.informationType = value;
                    return value;
                }
                case -1857640538: {
                    this.summary = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -281470431: {
                    this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1406328437: {
                    this.author = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3433509: {
                    this.getPath().add(TypeConvertor.castToUri(value));
                    return value;
                }
                case 666807069: {
                    this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                    return value;
                }
                case -1268656616: {
                    this.freeToShare = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1399907075: {
                    this.getComponent().add((ArtifactAssessmentContentComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("informationType")) {
                value = new ArtifactAssessmentInformationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.informationType = value;
            } else if (name.equals("summary")) {
                this.summary = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("classifier")) {
                this.getClassifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("author")) {
                this.author = TypeConvertor.castToReference(value);
            } else if (name.equals("path")) {
                this.getPath().add(TypeConvertor.castToUri(value));
            } else if (name.equals("relatedArtifact")) {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
            } else if (name.equals("freeToShare")) {
                this.freeToShare = TypeConvertor.castToBoolean(value);
            } else if (name.equals("component")) {
                this.getComponent().add((ArtifactAssessmentContentComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("informationType")) {
                value = new ArtifactAssessmentInformationTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.informationType = value;
            } else if (name.equals("summary")) {
                this.summary = null;
            } else if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("classifier")) {
                this.getClassifier().remove(value);
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("author")) {
                this.author = null;
            } else if (name.equals("path")) {
                this.getPath().remove(value);
            } else if (name.equals("relatedArtifact")) {
                this.getRelatedArtifact().remove(value);
            } else if (name.equals("freeToShare")) {
                this.freeToShare = null;
            } else if (name.equals("component")) {
                this.getComponent().remove((ArtifactAssessmentContentComponent)((Object)value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1302856326: {
                    return this.getInformationTypeElement();
                }
                case -1857640538: {
                    return this.getSummaryElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -281470431: {
                    return this.addClassifier();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1406328437: {
                    return this.getAuthor();
                }
                case 3433509: {
                    return this.addPathElement();
                }
                case 666807069: {
                    return this.addRelatedArtifact();
                }
                case -1268656616: {
                    return this.getFreeToShareElement();
                }
                case -1399907075: {
                    return this.addComponent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1302856326: {
                    return new String[]{"code"};
                }
                case -1857640538: {
                    return new String[]{"markdown"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -281470431: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -1406328437: {
                    return new String[]{"Reference"};
                }
                case 3433509: {
                    return new String[]{"uri"};
                }
                case 666807069: {
                    return new String[]{"RelatedArtifact"};
                }
                case -1268656616: {
                    return new String[]{"boolean"};
                }
                case -1399907075: {
                    return new String[]{"@ArtifactAssessment.content"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("informationType")) {
                throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.content.informationType");
            }
            if (name.equals("summary")) {
                throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.content.summary");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("classifier")) {
                return this.addClassifier();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("author")) {
                this.author = new Reference();
                return this.author;
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.content.path");
            }
            if (name.equals("relatedArtifact")) {
                return this.addRelatedArtifact();
            }
            if (name.equals("freeToShare")) {
                throw new FHIRException("Cannot call addChild on a singleton property ArtifactAssessment.content.freeToShare");
            }
            if (name.equals("component")) {
                return this.addComponent();
            }
            return super.addChild(name);
        }

        @Override
        public ArtifactAssessmentContentComponent copy() {
            ArtifactAssessmentContentComponent dst = new ArtifactAssessmentContentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ArtifactAssessmentContentComponent dst) {
            super.copyValues(dst);
            dst.informationType = this.informationType == null ? null : this.informationType.copy();
            dst.summary = this.summary == null ? null : this.summary.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.classifier != null) {
                dst.classifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.classifier) {
                    dst.classifier.add(codeableConcept2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            Reference reference = dst.author = this.author == null ? null : this.author.copy();
            if (this.path != null) {
                dst.path = new ArrayList<UriType>();
                for (UriType uriType : this.path) {
                    dst.path.add(uriType.copy());
                }
            }
            if (this.relatedArtifact != null) {
                dst.relatedArtifact = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                    dst.relatedArtifact.add(relatedArtifact.copy());
                }
            }
            BooleanType booleanType = dst.freeToShare = this.freeToShare == null ? null : this.freeToShare.copy();
            if (this.component != null) {
                dst.component = new ArrayList<ArtifactAssessmentContentComponent>();
                for (ArtifactAssessmentContentComponent artifactAssessmentContentComponent : this.component) {
                    dst.component.add(artifactAssessmentContentComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ArtifactAssessmentContentComponent)) {
                return false;
            }
            ArtifactAssessmentContentComponent o = (ArtifactAssessmentContentComponent)other_;
            return ArtifactAssessmentContentComponent.compareDeep(this.informationType, o.informationType, true) && ArtifactAssessmentContentComponent.compareDeep(this.summary, o.summary, true) && ArtifactAssessmentContentComponent.compareDeep(this.type, o.type, true) && ArtifactAssessmentContentComponent.compareDeep(this.classifier, o.classifier, true) && ArtifactAssessmentContentComponent.compareDeep(this.quantity, o.quantity, true) && ArtifactAssessmentContentComponent.compareDeep(this.author, o.author, true) && ArtifactAssessmentContentComponent.compareDeep(this.path, o.path, true) && ArtifactAssessmentContentComponent.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ArtifactAssessmentContentComponent.compareDeep(this.freeToShare, o.freeToShare, true) && ArtifactAssessmentContentComponent.compareDeep(this.component, o.component, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ArtifactAssessmentContentComponent)) {
                return false;
            }
            ArtifactAssessmentContentComponent o = (ArtifactAssessmentContentComponent)other_;
            return ArtifactAssessmentContentComponent.compareValues(this.informationType, o.informationType, true) && ArtifactAssessmentContentComponent.compareValues(this.summary, o.summary, true) && ArtifactAssessmentContentComponent.compareValues(this.path, o.path, true) && ArtifactAssessmentContentComponent.compareValues(this.freeToShare, o.freeToShare, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.informationType, this.summary, this.type, this.classifier, this.quantity, this.author, this.path, this.relatedArtifact, this.freeToShare, this.component});
        }

        @Override
        public String fhirType() {
            return "ArtifactAssessment.content";
        }
    }

    public static class ArtifactAssessmentWorkflowStatusEnumFactory
    implements EnumFactory<ArtifactAssessmentWorkflowStatus> {
        @Override
        public ArtifactAssessmentWorkflowStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("submitted".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.SUBMITTED;
            }
            if ("triaged".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.TRIAGED;
            }
            if ("waiting-for-input".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.WAITINGFORINPUT;
            }
            if ("resolved-no-change".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.RESOLVEDNOCHANGE;
            }
            if ("resolved-change-required".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.RESOLVEDCHANGEREQUIRED;
            }
            if ("deferred".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.DEFERRED;
            }
            if ("duplicate".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.DUPLICATE;
            }
            if ("applied".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.APPLIED;
            }
            if ("published".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.PUBLISHED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ArtifactAssessmentWorkflowStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ArtifactAssessmentWorkflowStatus code '" + codeString + "'");
        }

        public Enumeration<ArtifactAssessmentWorkflowStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.NULL, code);
            }
            if ("submitted".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.SUBMITTED, code);
            }
            if ("triaged".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.TRIAGED, code);
            }
            if ("waiting-for-input".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.WAITINGFORINPUT, code);
            }
            if ("resolved-no-change".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.RESOLVEDNOCHANGE, code);
            }
            if ("resolved-change-required".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.RESOLVEDCHANGEREQUIRED, code);
            }
            if ("deferred".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.DEFERRED, code);
            }
            if ("duplicate".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.DUPLICATE, code);
            }
            if ("applied".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.APPLIED, code);
            }
            if ("published".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.PUBLISHED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentWorkflowStatus>(this, ArtifactAssessmentWorkflowStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown ArtifactAssessmentWorkflowStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ArtifactAssessmentWorkflowStatus code) {
            if (code == ArtifactAssessmentWorkflowStatus.NULL) {
                return null;
            }
            if (code == ArtifactAssessmentWorkflowStatus.SUBMITTED) {
                return "submitted";
            }
            if (code == ArtifactAssessmentWorkflowStatus.TRIAGED) {
                return "triaged";
            }
            if (code == ArtifactAssessmentWorkflowStatus.WAITINGFORINPUT) {
                return "waiting-for-input";
            }
            if (code == ArtifactAssessmentWorkflowStatus.RESOLVEDNOCHANGE) {
                return "resolved-no-change";
            }
            if (code == ArtifactAssessmentWorkflowStatus.RESOLVEDCHANGEREQUIRED) {
                return "resolved-change-required";
            }
            if (code == ArtifactAssessmentWorkflowStatus.DEFERRED) {
                return "deferred";
            }
            if (code == ArtifactAssessmentWorkflowStatus.DUPLICATE) {
                return "duplicate";
            }
            if (code == ArtifactAssessmentWorkflowStatus.APPLIED) {
                return "applied";
            }
            if (code == ArtifactAssessmentWorkflowStatus.PUBLISHED) {
                return "published";
            }
            if (code == ArtifactAssessmentWorkflowStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ArtifactAssessmentWorkflowStatus code) {
            return code.getSystem();
        }
    }

    public static enum ArtifactAssessmentWorkflowStatus {
        SUBMITTED,
        TRIAGED,
        WAITINGFORINPUT,
        RESOLVEDNOCHANGE,
        RESOLVEDCHANGEREQUIRED,
        DEFERRED,
        DUPLICATE,
        APPLIED,
        PUBLISHED,
        ENTEREDINERROR,
        NULL;


        public static ArtifactAssessmentWorkflowStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("submitted".equals(codeString)) {
                return SUBMITTED;
            }
            if ("triaged".equals(codeString)) {
                return TRIAGED;
            }
            if ("waiting-for-input".equals(codeString)) {
                return WAITINGFORINPUT;
            }
            if ("resolved-no-change".equals(codeString)) {
                return RESOLVEDNOCHANGE;
            }
            if ("resolved-change-required".equals(codeString)) {
                return RESOLVEDCHANGEREQUIRED;
            }
            if ("deferred".equals(codeString)) {
                return DEFERRED;
            }
            if ("duplicate".equals(codeString)) {
                return DUPLICATE;
            }
            if ("applied".equals(codeString)) {
                return APPLIED;
            }
            if ("published".equals(codeString)) {
                return PUBLISHED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ArtifactAssessmentWorkflowStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SUBMITTED: {
                    return "submitted";
                }
                case TRIAGED: {
                    return "triaged";
                }
                case WAITINGFORINPUT: {
                    return "waiting-for-input";
                }
                case RESOLVEDNOCHANGE: {
                    return "resolved-no-change";
                }
                case RESOLVEDCHANGEREQUIRED: {
                    return "resolved-change-required";
                }
                case DEFERRED: {
                    return "deferred";
                }
                case DUPLICATE: {
                    return "duplicate";
                }
                case APPLIED: {
                    return "applied";
                }
                case PUBLISHED: {
                    return "published";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SUBMITTED: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case TRIAGED: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case WAITINGFORINPUT: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case RESOLVEDNOCHANGE: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case RESOLVEDCHANGEREQUIRED: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case DEFERRED: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case DUPLICATE: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case APPLIED: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case PUBLISHED: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/artifactassessment-workflow-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SUBMITTED: {
                    return "The comment has been submitted, but the responsible party has not yet been determined, or the responsible party has not yet determined the next steps to be taken.";
                }
                case TRIAGED: {
                    return "The comment has been triaged, meaning the responsible party has been determined and next steps have been identified to address the comment.";
                }
                case WAITINGFORINPUT: {
                    return "The comment is waiting for input from a specific party before next steps can be taken.";
                }
                case RESOLVEDNOCHANGE: {
                    return "The comment has been resolved and no changes resulted from the resolution";
                }
                case RESOLVEDCHANGEREQUIRED: {
                    return "The comment has been resolved and changes are required to address the comment";
                }
                case DEFERRED: {
                    return "The comment is acceptable, but resolution of the comment and application of any associated changes have been deferred";
                }
                case DUPLICATE: {
                    return "The comment is a duplicate of another comment already received";
                }
                case APPLIED: {
                    return "The comment is resolved and any necessary changes have been applied";
                }
                case PUBLISHED: {
                    return "The necessary changes to the artifact have been published in a new version of the artifact";
                }
                case ENTEREDINERROR: {
                    return "The assessment was entered in error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SUBMITTED: {
                    return "Submitted";
                }
                case TRIAGED: {
                    return "Triaged";
                }
                case WAITINGFORINPUT: {
                    return "Waiting for Input";
                }
                case RESOLVEDNOCHANGE: {
                    return "Resolved - No Change";
                }
                case RESOLVEDCHANGEREQUIRED: {
                    return "Resolved - Change Required";
                }
                case DEFERRED: {
                    return "Deferred";
                }
                case DUPLICATE: {
                    return "Duplicate";
                }
                case APPLIED: {
                    return "Applied";
                }
                case PUBLISHED: {
                    return "Published";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ArtifactAssessmentInformationTypeEnumFactory
    implements EnumFactory<ArtifactAssessmentInformationType> {
        @Override
        public ArtifactAssessmentInformationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("comment".equals(codeString)) {
                return ArtifactAssessmentInformationType.COMMENT;
            }
            if ("classifier".equals(codeString)) {
                return ArtifactAssessmentInformationType.CLASSIFIER;
            }
            if ("rating".equals(codeString)) {
                return ArtifactAssessmentInformationType.RATING;
            }
            if ("container".equals(codeString)) {
                return ArtifactAssessmentInformationType.CONTAINER;
            }
            if ("response".equals(codeString)) {
                return ArtifactAssessmentInformationType.RESPONSE;
            }
            if ("change-request".equals(codeString)) {
                return ArtifactAssessmentInformationType.CHANGEREQUEST;
            }
            throw new IllegalArgumentException("Unknown ArtifactAssessmentInformationType code '" + codeString + "'");
        }

        public Enumeration<ArtifactAssessmentInformationType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ArtifactAssessmentInformationType>(this, ArtifactAssessmentInformationType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentInformationType>(this, ArtifactAssessmentInformationType.NULL, code);
            }
            if ("comment".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentInformationType>(this, ArtifactAssessmentInformationType.COMMENT, code);
            }
            if ("classifier".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentInformationType>(this, ArtifactAssessmentInformationType.CLASSIFIER, code);
            }
            if ("rating".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentInformationType>(this, ArtifactAssessmentInformationType.RATING, code);
            }
            if ("container".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentInformationType>(this, ArtifactAssessmentInformationType.CONTAINER, code);
            }
            if ("response".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentInformationType>(this, ArtifactAssessmentInformationType.RESPONSE, code);
            }
            if ("change-request".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentInformationType>(this, ArtifactAssessmentInformationType.CHANGEREQUEST, code);
            }
            throw new FHIRException("Unknown ArtifactAssessmentInformationType code '" + codeString + "'");
        }

        @Override
        public String toCode(ArtifactAssessmentInformationType code) {
            if (code == ArtifactAssessmentInformationType.NULL) {
                return null;
            }
            if (code == ArtifactAssessmentInformationType.COMMENT) {
                return "comment";
            }
            if (code == ArtifactAssessmentInformationType.CLASSIFIER) {
                return "classifier";
            }
            if (code == ArtifactAssessmentInformationType.RATING) {
                return "rating";
            }
            if (code == ArtifactAssessmentInformationType.CONTAINER) {
                return "container";
            }
            if (code == ArtifactAssessmentInformationType.RESPONSE) {
                return "response";
            }
            if (code == ArtifactAssessmentInformationType.CHANGEREQUEST) {
                return "change-request";
            }
            return "?";
        }

        @Override
        public String toSystem(ArtifactAssessmentInformationType code) {
            return code.getSystem();
        }
    }

    public static enum ArtifactAssessmentInformationType {
        COMMENT,
        CLASSIFIER,
        RATING,
        CONTAINER,
        RESPONSE,
        CHANGEREQUEST,
        NULL;


        public static ArtifactAssessmentInformationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("comment".equals(codeString)) {
                return COMMENT;
            }
            if ("classifier".equals(codeString)) {
                return CLASSIFIER;
            }
            if ("rating".equals(codeString)) {
                return RATING;
            }
            if ("container".equals(codeString)) {
                return CONTAINER;
            }
            if ("response".equals(codeString)) {
                return RESPONSE;
            }
            if ("change-request".equals(codeString)) {
                return CHANGEREQUEST;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ArtifactAssessmentInformationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMMENT: {
                    return "comment";
                }
                case CLASSIFIER: {
                    return "classifier";
                }
                case RATING: {
                    return "rating";
                }
                case CONTAINER: {
                    return "container";
                }
                case RESPONSE: {
                    return "response";
                }
                case CHANGEREQUEST: {
                    return "change-request";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMMENT: {
                    return "http://hl7.org/fhir/artifactassessment-information-type";
                }
                case CLASSIFIER: {
                    return "http://hl7.org/fhir/artifactassessment-information-type";
                }
                case RATING: {
                    return "http://hl7.org/fhir/artifactassessment-information-type";
                }
                case CONTAINER: {
                    return "http://hl7.org/fhir/artifactassessment-information-type";
                }
                case RESPONSE: {
                    return "http://hl7.org/fhir/artifactassessment-information-type";
                }
                case CHANGEREQUEST: {
                    return "http://hl7.org/fhir/artifactassessment-information-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMMENT: {
                    return "A comment on the artifact";
                }
                case CLASSIFIER: {
                    return "A classifier of the artifact";
                }
                case RATING: {
                    return "A rating of the artifact";
                }
                case CONTAINER: {
                    return "A container for multiple components";
                }
                case RESPONSE: {
                    return "A response to a comment";
                }
                case CHANGEREQUEST: {
                    return "A change request for the artifact";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMMENT: {
                    return "Comment";
                }
                case CLASSIFIER: {
                    return "Classifier";
                }
                case RATING: {
                    return "Rating";
                }
                case CONTAINER: {
                    return "Container";
                }
                case RESPONSE: {
                    return "Response";
                }
                case CHANGEREQUEST: {
                    return "Change Request";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ArtifactAssessmentDispositionEnumFactory
    implements EnumFactory<ArtifactAssessmentDisposition> {
        @Override
        public ArtifactAssessmentDisposition fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("unresolved".equals(codeString)) {
                return ArtifactAssessmentDisposition.UNRESOLVED;
            }
            if ("not-persuasive".equals(codeString)) {
                return ArtifactAssessmentDisposition.NOTPERSUASIVE;
            }
            if ("persuasive".equals(codeString)) {
                return ArtifactAssessmentDisposition.PERSUASIVE;
            }
            if ("persuasive-with-modification".equals(codeString)) {
                return ArtifactAssessmentDisposition.PERSUASIVEWITHMODIFICATION;
            }
            if ("not-persuasive-with-modification".equals(codeString)) {
                return ArtifactAssessmentDisposition.NOTPERSUASIVEWITHMODIFICATION;
            }
            throw new IllegalArgumentException("Unknown ArtifactAssessmentDisposition code '" + codeString + "'");
        }

        public Enumeration<ArtifactAssessmentDisposition> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ArtifactAssessmentDisposition>(this, ArtifactAssessmentDisposition.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentDisposition>(this, ArtifactAssessmentDisposition.NULL, code);
            }
            if ("unresolved".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentDisposition>(this, ArtifactAssessmentDisposition.UNRESOLVED, code);
            }
            if ("not-persuasive".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentDisposition>(this, ArtifactAssessmentDisposition.NOTPERSUASIVE, code);
            }
            if ("persuasive".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentDisposition>(this, ArtifactAssessmentDisposition.PERSUASIVE, code);
            }
            if ("persuasive-with-modification".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentDisposition>(this, ArtifactAssessmentDisposition.PERSUASIVEWITHMODIFICATION, code);
            }
            if ("not-persuasive-with-modification".equals(codeString)) {
                return new Enumeration<ArtifactAssessmentDisposition>(this, ArtifactAssessmentDisposition.NOTPERSUASIVEWITHMODIFICATION, code);
            }
            throw new FHIRException("Unknown ArtifactAssessmentDisposition code '" + codeString + "'");
        }

        @Override
        public String toCode(ArtifactAssessmentDisposition code) {
            if (code == ArtifactAssessmentDisposition.NULL) {
                return null;
            }
            if (code == ArtifactAssessmentDisposition.UNRESOLVED) {
                return "unresolved";
            }
            if (code == ArtifactAssessmentDisposition.NOTPERSUASIVE) {
                return "not-persuasive";
            }
            if (code == ArtifactAssessmentDisposition.PERSUASIVE) {
                return "persuasive";
            }
            if (code == ArtifactAssessmentDisposition.PERSUASIVEWITHMODIFICATION) {
                return "persuasive-with-modification";
            }
            if (code == ArtifactAssessmentDisposition.NOTPERSUASIVEWITHMODIFICATION) {
                return "not-persuasive-with-modification";
            }
            return "?";
        }

        @Override
        public String toSystem(ArtifactAssessmentDisposition code) {
            return code.getSystem();
        }
    }

    public static enum ArtifactAssessmentDisposition {
        UNRESOLVED,
        NOTPERSUASIVE,
        PERSUASIVE,
        PERSUASIVEWITHMODIFICATION,
        NOTPERSUASIVEWITHMODIFICATION,
        NULL;


        public static ArtifactAssessmentDisposition fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unresolved".equals(codeString)) {
                return UNRESOLVED;
            }
            if ("not-persuasive".equals(codeString)) {
                return NOTPERSUASIVE;
            }
            if ("persuasive".equals(codeString)) {
                return PERSUASIVE;
            }
            if ("persuasive-with-modification".equals(codeString)) {
                return PERSUASIVEWITHMODIFICATION;
            }
            if ("not-persuasive-with-modification".equals(codeString)) {
                return NOTPERSUASIVEWITHMODIFICATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ArtifactAssessmentDisposition code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UNRESOLVED: {
                    return "unresolved";
                }
                case NOTPERSUASIVE: {
                    return "not-persuasive";
                }
                case PERSUASIVE: {
                    return "persuasive";
                }
                case PERSUASIVEWITHMODIFICATION: {
                    return "persuasive-with-modification";
                }
                case NOTPERSUASIVEWITHMODIFICATION: {
                    return "not-persuasive-with-modification";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UNRESOLVED: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case NOTPERSUASIVE: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case PERSUASIVE: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case PERSUASIVEWITHMODIFICATION: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case NOTPERSUASIVEWITHMODIFICATION: {
                    return "http://hl7.org/fhir/artifactassessment-disposition";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UNRESOLVED: {
                    return "The comment is unresolved";
                }
                case NOTPERSUASIVE: {
                    return "The comment is not persuasive (rejected in full)";
                }
                case PERSUASIVE: {
                    return "The comment is persuasive (accepted in full)";
                }
                case PERSUASIVEWITHMODIFICATION: {
                    return "The comment is persuasive with modification (partially accepted)";
                }
                case NOTPERSUASIVEWITHMODIFICATION: {
                    return "The comment is not persuasive with modification (partially rejected)";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UNRESOLVED: {
                    return "Unresolved";
                }
                case NOTPERSUASIVE: {
                    return "Not Persuasive";
                }
                case PERSUASIVE: {
                    return "Persuasive";
                }
                case PERSUASIVEWITHMODIFICATION: {
                    return "Persuasive with Modification";
                }
                case NOTPERSUASIVEWITHMODIFICATION: {
                    return "Not Persuasive with Modification";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

