/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingSelection", profile="http://hl7.org/fhir/StructureDefinition/ImagingSelection")
public class ImagingSelection
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for Imaging Selection", formalDefinition="A unique identifier assigned to this imaging selection.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="available | entered-in-error | unknown", formalDefinition="The current state of the ImagingSelection resource. This is not the status of any ImagingStudy, ServiceRequest, or Task resources associated with the ImagingSelection.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/imagingselection-status")
    protected Enumeration<ImagingSelectionStatus> status;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Procedure.class, Practitioner.class, Medication.class, Substance.class, Specimen.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subject of the selected instances", formalDefinition="The patient, or group of patients, location, device, organization, procedure or practitioner this imaging selection is about and into whose or what record the imaging selection is placed.")
    protected Reference subject;
    @Child(name="issued", type={InstantType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date / Time when this imaging selection was created", formalDefinition="The date and time this imaging selection was created.")
    protected InstantType issued;
    @Child(name="performer", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Selector of the instances (human or machine)", formalDefinition="Selector of the instances \u2013 human or machine.")
    protected List<ImagingSelectionPerformerComponent> performer;
    @Child(name="basedOn", type={CarePlan.class, ServiceRequest.class, Appointment.class, AppointmentResponse.class, Task.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Associated request", formalDefinition="A list of the diagnostic requests that resulted in this imaging selection being performed.")
    protected List<Reference> basedOn;
    @Child(name="category", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classifies the imaging selection", formalDefinition="Classifies the imaging selection.")
    @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_7010.html")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Imaging Selection purpose text or code", formalDefinition="Reason for referencing the selected content.")
    @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_7010.html")
    protected CodeableConcept code;
    @Child(name="studyUid", type={IdType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DICOM Study Instance UID", formalDefinition="The Study Instance UID for the DICOM Study from which the images were selected.")
    protected IdType studyUid;
    @Child(name="derivedFrom", type={ImagingStudy.class, DocumentReference.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The imaging study from which the imaging selection is derived", formalDefinition="The imaging study from which the imaging selection is made.")
    protected List<Reference> derivedFrom;
    @Child(name="endpoint", type={Endpoint.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The network service providing retrieval for the images referenced in the imaging selection", formalDefinition="The network service providing retrieval access to the selected images, frames, etc. See implementation notes for information about using DICOM endpoints.")
    protected List<Reference> endpoint;
    @Child(name="seriesUid", type={IdType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DICOM Series Instance UID", formalDefinition="The Series Instance UID for the DICOM Series from which the images were selected.")
    protected IdType seriesUid;
    @Child(name="seriesNumber", type={UnsignedIntType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DICOM Series Number", formalDefinition="The Series Number for the DICOM Series from which the images were selected.")
    protected UnsignedIntType seriesNumber;
    @Child(name="frameOfReferenceUid", type={IdType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The Frame of Reference UID for the selected images", formalDefinition="The Frame of Reference UID identifying the coordinate system that conveys spatial and/or temporal information for the selected images or frames.")
    protected IdType frameOfReferenceUid;
    @Child(name="bodySite", type={CodeableReference.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Body part examined", formalDefinition="The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableReference bodySite;
    @Child(name="focus", type={ImagingSelection.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Related resource that is the focus for the imaging selection", formalDefinition="The actual focus of an observation when it is not the patient of record representing something or someone associated with the patient such as a spouse, parent, fetus, or donor. For example, fetus observations in a mother's record.  The focus of an observation could also be an existing condition,  an intervention, the subject's diet,  another observation of the subject,  or a body structure such as tumor or implanted device.   An example use case would be using the Observation resource to capture whether the mother is trained to change her child's tracheostomy tube. In this example, the child is the patient of record and the mother is the focus.")
    protected List<Reference> focus;
    @Child(name="instance", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The selected instances", formalDefinition="Each imaging selection includes one or more selected DICOM SOP instances.")
    protected List<ImagingSelectionInstanceComponent> instance;
    private static final long serialVersionUID = -1733487270L;
    @SearchParamDefinition(name="based-on", path="ImagingSelection.basedOn", description="The request associated with an imaging selection", type="reference", target={Appointment.class, AppointmentResponse.class, CarePlan.class, ServiceRequest.class, Task.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("ImagingSelection:based-on").toLocked();
    @SearchParamDefinition(name="body-site", path="ImagingSelection.bodySite.concept", description="The body site code associated with the imaging selection", type="token")
    public static final String SP_BODY_SITE = "body-site";
    public static final TokenClientParam BODY_SITE = new TokenClientParam("body-site");
    @SearchParamDefinition(name="body-structure", path="ImagingSelection.bodySite.reference", description="The body structure associated with the imaging selection", type="reference", target={BodyStructure.class})
    public static final String SP_BODY_STRUCTURE = "body-structure";
    public static final ReferenceClientParam BODY_STRUCTURE = new ReferenceClientParam("body-structure");
    public static final Include INCLUDE_BODY_STRUCTURE = new Include("ImagingSelection:body-structure").toLocked();
    @SearchParamDefinition(name="derived-from", path="ImagingSelection.derivedFrom", description="The imaging study from which the imaging selection was derived", type="reference", target={DocumentReference.class, ImagingStudy.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("ImagingSelection:derived-from").toLocked();
    @SearchParamDefinition(name="issued", path="ImagingSelection.issued", description="The date / time the imaging selection was created", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="status", path="ImagingSelection.status", description="The status of the imaging selection", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="study-uid", path="ImagingSelection.studyUid", description="The DICOM Study Instance UID from which the images were selected", type="token")
    public static final String SP_STUDY_UID = "study-uid";
    public static final TokenClientParam STUDY_UID = new TokenClientParam("study-uid");
    @SearchParamDefinition(name="subject", path="ImagingSelection.subject", description="The subject of the Imaging Selection, such as the associated Patient", type="reference", target={Device.class, Group.class, Location.class, Medication.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Specimen.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ImagingSelection:subject").toLocked();
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImagingSelection:patient").toLocked();

    public ImagingSelection() {
    }

    public ImagingSelection(ImagingSelectionStatus status, CodeableConcept code) {
        this.setStatus(status);
        this.setCode(code);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ImagingSelection setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImagingSelection addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ImagingSelectionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ImagingSelectionStatus>(new ImagingSelectionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ImagingSelection setStatusElement(Enumeration<ImagingSelectionStatus> value) {
        this.status = value;
        return this;
    }

    public ImagingSelectionStatus getStatus() {
        return this.status == null ? null : (ImagingSelectionStatus)((Object)this.status.getValue());
    }

    public ImagingSelection setStatus(ImagingSelectionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ImagingSelectionStatus>(new ImagingSelectionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ImagingSelection setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public ImagingSelection setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public ImagingSelection setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<ImagingSelectionPerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ImagingSelectionPerformerComponent>();
        }
        return this.performer;
    }

    public ImagingSelection setPerformer(List<ImagingSelectionPerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (ImagingSelectionPerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImagingSelectionPerformerComponent addPerformer() {
        ImagingSelectionPerformerComponent t = new ImagingSelectionPerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<ImagingSelectionPerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public ImagingSelection addPerformer(ImagingSelectionPerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<ImagingSelectionPerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public ImagingSelectionPerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public ImagingSelection setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public ImagingSelection addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public ImagingSelection setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public ImagingSelection addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ImagingSelection setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public IdType getStudyUidElement() {
        if (this.studyUid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.studyUid");
            }
            if (Configuration.doAutoCreate()) {
                this.studyUid = new IdType();
            }
        }
        return this.studyUid;
    }

    public boolean hasStudyUidElement() {
        return this.studyUid != null && !this.studyUid.isEmpty();
    }

    public boolean hasStudyUid() {
        return this.studyUid != null && !this.studyUid.isEmpty();
    }

    public ImagingSelection setStudyUidElement(IdType value) {
        this.studyUid = value;
        return this;
    }

    public String getStudyUid() {
        return this.studyUid == null ? null : this.studyUid.getValue();
    }

    public ImagingSelection setStudyUid(String value) {
        if (Utilities.noString((String)value)) {
            this.studyUid = null;
        } else {
            if (this.studyUid == null) {
                this.studyUid = new IdType();
            }
            this.studyUid.setValue(value);
        }
        return this;
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public ImagingSelection setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public ImagingSelection addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public ImagingSelection setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public ImagingSelection addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    public IdType getSeriesUidElement() {
        if (this.seriesUid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.seriesUid");
            }
            if (Configuration.doAutoCreate()) {
                this.seriesUid = new IdType();
            }
        }
        return this.seriesUid;
    }

    public boolean hasSeriesUidElement() {
        return this.seriesUid != null && !this.seriesUid.isEmpty();
    }

    public boolean hasSeriesUid() {
        return this.seriesUid != null && !this.seriesUid.isEmpty();
    }

    public ImagingSelection setSeriesUidElement(IdType value) {
        this.seriesUid = value;
        return this;
    }

    public String getSeriesUid() {
        return this.seriesUid == null ? null : this.seriesUid.getValue();
    }

    public ImagingSelection setSeriesUid(String value) {
        if (Utilities.noString((String)value)) {
            this.seriesUid = null;
        } else {
            if (this.seriesUid == null) {
                this.seriesUid = new IdType();
            }
            this.seriesUid.setValue(value);
        }
        return this;
    }

    public UnsignedIntType getSeriesNumberElement() {
        if (this.seriesNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.seriesNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.seriesNumber = new UnsignedIntType();
            }
        }
        return this.seriesNumber;
    }

    public boolean hasSeriesNumberElement() {
        return this.seriesNumber != null && !this.seriesNumber.isEmpty();
    }

    public boolean hasSeriesNumber() {
        return this.seriesNumber != null && !this.seriesNumber.isEmpty();
    }

    public ImagingSelection setSeriesNumberElement(UnsignedIntType value) {
        this.seriesNumber = value;
        return this;
    }

    public int getSeriesNumber() {
        return this.seriesNumber == null || this.seriesNumber.isEmpty() ? 0 : (Integer)this.seriesNumber.getValue();
    }

    public ImagingSelection setSeriesNumber(int value) {
        if (this.seriesNumber == null) {
            this.seriesNumber = new UnsignedIntType();
        }
        this.seriesNumber.setValue((Object)value);
        return this;
    }

    public IdType getFrameOfReferenceUidElement() {
        if (this.frameOfReferenceUid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.frameOfReferenceUid");
            }
            if (Configuration.doAutoCreate()) {
                this.frameOfReferenceUid = new IdType();
            }
        }
        return this.frameOfReferenceUid;
    }

    public boolean hasFrameOfReferenceUidElement() {
        return this.frameOfReferenceUid != null && !this.frameOfReferenceUid.isEmpty();
    }

    public boolean hasFrameOfReferenceUid() {
        return this.frameOfReferenceUid != null && !this.frameOfReferenceUid.isEmpty();
    }

    public ImagingSelection setFrameOfReferenceUidElement(IdType value) {
        this.frameOfReferenceUid = value;
        return this;
    }

    public String getFrameOfReferenceUid() {
        return this.frameOfReferenceUid == null ? null : this.frameOfReferenceUid.getValue();
    }

    public ImagingSelection setFrameOfReferenceUid(String value) {
        if (Utilities.noString((String)value)) {
            this.frameOfReferenceUid = null;
        } else {
            if (this.frameOfReferenceUid == null) {
                this.frameOfReferenceUid = new IdType();
            }
            this.frameOfReferenceUid.setValue(value);
        }
        return this;
    }

    public CodeableReference getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingSelection.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableReference();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public ImagingSelection setBodySite(CodeableReference value) {
        this.bodySite = value;
        return this;
    }

    public List<Reference> getFocus() {
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        return this.focus;
    }

    public ImagingSelection setFocus(List<Reference> theFocus) {
        this.focus = theFocus;
        return this;
    }

    public boolean hasFocus() {
        if (this.focus == null) {
            return false;
        }
        for (Reference item : this.focus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addFocus() {
        Reference t = new Reference();
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return t;
    }

    public ImagingSelection addFocus(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.focus == null) {
            this.focus = new ArrayList<Reference>();
        }
        this.focus.add(t);
        return this;
    }

    public Reference getFocusFirstRep() {
        if (this.getFocus().isEmpty()) {
            this.addFocus();
        }
        return this.getFocus().get(0);
    }

    public List<ImagingSelectionInstanceComponent> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<ImagingSelectionInstanceComponent>();
        }
        return this.instance;
    }

    public ImagingSelection setInstance(List<ImagingSelectionInstanceComponent> theInstance) {
        this.instance = theInstance;
        return this;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (ImagingSelectionInstanceComponent item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImagingSelectionInstanceComponent addInstance() {
        ImagingSelectionInstanceComponent t = new ImagingSelectionInstanceComponent();
        if (this.instance == null) {
            this.instance = new ArrayList<ImagingSelectionInstanceComponent>();
        }
        this.instance.add(t);
        return t;
    }

    public ImagingSelection addInstance(ImagingSelectionInstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<ImagingSelectionInstanceComponent>();
        }
        this.instance.add(t);
        return this;
    }

    public ImagingSelectionInstanceComponent getInstanceFirstRep() {
        if (this.getInstance().isEmpty()) {
            this.addInstance();
        }
        return this.getInstance().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this imaging selection.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, SP_CODE, "The current state of the ImagingSelection resource. This is not the status of any ImagingStudy, ServiceRequest, or Task resources associated with the ImagingSelection.", 0, 1, this.status));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|Specimen)", "The patient, or group of patients, location, device, organization, procedure or practitioner this imaging selection is about and into whose or what record the imaging selection is placed.", 0, 1, this.subject));
        children.add(new Property(SP_ISSUED, "instant", "The date and time this imaging selection was created.", 0, 1, this.issued));
        children.add(new Property("performer", "", "Selector of the instances \u2013 human or machine.", 0, Integer.MAX_VALUE, this.performer));
        children.add(new Property("basedOn", "Reference(CarePlan|ServiceRequest|Appointment|AppointmentResponse|Task)", "A list of the diagnostic requests that resulted in this imaging selection being performed.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("category", "CodeableConcept", "Classifies the imaging selection.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "Reason for referencing the selected content.", 0, 1, this.code));
        children.add(new Property("studyUid", "id", "The Study Instance UID for the DICOM Study from which the images were selected.", 0, 1, this.studyUid));
        children.add(new Property("derivedFrom", "Reference(ImagingStudy|DocumentReference)", "The imaging study from which the imaging selection is made.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("endpoint", "Reference(Endpoint)", "The network service providing retrieval access to the selected images, frames, etc. See implementation notes for information about using DICOM endpoints.", 0, Integer.MAX_VALUE, this.endpoint));
        children.add(new Property("seriesUid", "id", "The Series Instance UID for the DICOM Series from which the images were selected.", 0, 1, this.seriesUid));
        children.add(new Property("seriesNumber", "unsignedInt", "The Series Number for the DICOM Series from which the images were selected.", 0, 1, this.seriesNumber));
        children.add(new Property("frameOfReferenceUid", "id", "The Frame of Reference UID identifying the coordinate system that conveys spatial and/or temporal information for the selected images or frames.", 0, 1, this.frameOfReferenceUid));
        children.add(new Property("bodySite", "CodeableReference(BodyStructure)", "The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings.", 0, 1, this.bodySite));
        children.add(new Property("focus", "Reference(ImagingSelection)", "The actual focus of an observation when it is not the patient of record representing something or someone associated with the patient such as a spouse, parent, fetus, or donor. For example, fetus observations in a mother's record.  The focus of an observation could also be an existing condition,  an intervention, the subject's diet,  another observation of the subject,  or a body structure such as tumor or implanted device.   An example use case would be using the Observation resource to capture whether the mother is trained to change her child's tracheostomy tube. In this example, the child is the patient of record and the mother is the focus.", 0, Integer.MAX_VALUE, this.focus));
        children.add(new Property("instance", "", "Each imaging selection includes one or more selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this imaging selection.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The current state of the ImagingSelection resource. This is not the status of any ImagingStudy, ServiceRequest, or Task resources associated with the ImagingSelection.", 0, 1, this.status);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|Specimen)", "The patient, or group of patients, location, device, organization, procedure or practitioner this imaging selection is about and into whose or what record the imaging selection is placed.", 0, 1, this.subject);
            }
            case -1179159893: {
                return new Property(SP_ISSUED, "instant", "The date and time this imaging selection was created.", 0, 1, this.issued);
            }
            case 481140686: {
                return new Property("performer", "", "Selector of the instances \u2013 human or machine.", 0, Integer.MAX_VALUE, this.performer);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ServiceRequest|Appointment|AppointmentResponse|Task)", "A list of the diagnostic requests that resulted in this imaging selection being performed.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "Classifies the imaging selection.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Reason for referencing the selected content.", 0, 1, this.code);
            }
            case 1876590023: {
                return new Property("studyUid", "id", "The Study Instance UID for the DICOM Study from which the images were selected.", 0, 1, this.studyUid);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(ImagingStudy|DocumentReference)", "The imaging study from which the imaging selection is made.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case 1741102485: {
                return new Property("endpoint", "Reference(Endpoint)", "The network service providing retrieval access to the selected images, frames, etc. See implementation notes for information about using DICOM endpoints.", 0, Integer.MAX_VALUE, this.endpoint);
            }
            case -569596327: {
                return new Property("seriesUid", "id", "The Series Instance UID for the DICOM Series from which the images were selected.", 0, 1, this.seriesUid);
            }
            case 382652576: {
                return new Property("seriesNumber", "unsignedInt", "The Series Number for the DICOM Series from which the images were selected.", 0, 1, this.seriesNumber);
            }
            case 828378953: {
                return new Property("frameOfReferenceUid", "id", "The Frame of Reference UID identifying the coordinate system that conveys spatial and/or temporal information for the selected images or frames.", 0, 1, this.frameOfReferenceUid);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableReference(BodyStructure)", "The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings.", 0, 1, this.bodySite);
            }
            case 97604824: {
                return new Property("focus", "Reference(ImagingSelection)", "The actual focus of an observation when it is not the patient of record representing something or someone associated with the patient such as a spouse, parent, fetus, or donor. For example, fetus observations in a mother's record.  The focus of an observation could also be an existing condition,  an intervention, the subject's diet,  another observation of the subject,  or a body structure such as tumor or implanted device.   An example use case would be using the Observation resource to capture whether the mother is trained to change her child's tracheostomy tube. In this example, the child is the patient of record and the mother is the focus.", 0, Integer.MAX_VALUE, this.focus);
            }
            case 555127957: {
                return new Property("instance", "", "Each imaging selection includes one or more selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.issued;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.code;
                }
                return baseArray;
            }
            case 1876590023: {
                Base[] baseArray;
                if (this.studyUid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.studyUid;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
            case -569596327: {
                Base[] baseArray;
                if (this.seriesUid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.seriesUid;
                }
                return baseArray;
            }
            case 382652576: {
                Base[] baseArray;
                if (this.seriesNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.seriesNumber;
                }
                return baseArray;
            }
            case 828378953: {
                Base[] baseArray;
                if (this.frameOfReferenceUid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.frameOfReferenceUid;
                }
                return baseArray;
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.bodySite;
                }
                return baseArray;
            }
            case 97604824: {
                return this.focus == null ? new Base[]{} : this.focus.toArray(new Base[this.focus.size()]);
            }
            case 555127957: {
                return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ImagingSelectionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case -1179159893: {
                this.issued = TypeConvertor.castToInstant(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((ImagingSelectionPerformerComponent)((Object)value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1876590023: {
                this.studyUid = TypeConvertor.castToId(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -569596327: {
                this.seriesUid = TypeConvertor.castToId(value);
                return value;
            }
            case 382652576: {
                this.seriesNumber = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case 828378953: {
                this.frameOfReferenceUid = TypeConvertor.castToId(value);
                return value;
            }
            case 1702620169: {
                this.bodySite = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case 97604824: {
                this.getFocus().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 555127957: {
                this.getInstance().add((ImagingSelectionInstanceComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ImagingSelectionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ISSUED)) {
            this.issued = TypeConvertor.castToInstant(value);
        } else if (name.equals("performer")) {
            this.getPerformer().add((ImagingSelectionPerformerComponent)((Object)value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("studyUid")) {
            this.studyUid = TypeConvertor.castToId(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToReference(value));
        } else if (name.equals("endpoint")) {
            this.getEndpoint().add(TypeConvertor.castToReference(value));
        } else if (name.equals("seriesUid")) {
            this.seriesUid = TypeConvertor.castToId(value);
        } else if (name.equals("seriesNumber")) {
            this.seriesNumber = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("frameOfReferenceUid")) {
            this.frameOfReferenceUid = TypeConvertor.castToId(value);
        } else if (name.equals("bodySite")) {
            this.bodySite = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("focus")) {
            this.getFocus().add(TypeConvertor.castToReference(value));
        } else if (name.equals("instance")) {
            this.getInstance().add((ImagingSelectionInstanceComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new ImagingSelectionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals(SP_ISSUED)) {
            this.issued = null;
        } else if (name.equals("performer")) {
            this.getPerformer().remove((ImagingSelectionPerformerComponent)((Object)value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals("category")) {
            this.getCategory().remove(value);
        } else if (name.equals(SP_CODE)) {
            this.code = null;
        } else if (name.equals("studyUid")) {
            this.studyUid = null;
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().remove(value);
        } else if (name.equals("endpoint")) {
            this.getEndpoint().remove(value);
        } else if (name.equals("seriesUid")) {
            this.seriesUid = null;
        } else if (name.equals("seriesNumber")) {
            this.seriesNumber = null;
        } else if (name.equals("frameOfReferenceUid")) {
            this.frameOfReferenceUid = null;
        } else if (name.equals("bodySite")) {
            this.bodySite = null;
        } else if (name.equals("focus")) {
            this.getFocus().remove(value);
        } else if (name.equals("instance")) {
            this.getInstance().remove((ImagingSelectionInstanceComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1876590023: {
                return this.getStudyUidElement();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
            case -569596327: {
                return this.getSeriesUidElement();
            }
            case 382652576: {
                return this.getSeriesNumberElement();
            }
            case 828378953: {
                return this.getFrameOfReferenceUidElement();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case 97604824: {
                return this.addFocus();
            }
            case 555127957: {
                return this.addInstance();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -1179159893: {
                return new String[]{"instant"};
            }
            case 481140686: {
                return new String[0];
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 1876590023: {
                return new String[]{"id"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
            case -569596327: {
                return new String[]{"id"};
            }
            case 382652576: {
                return new String[]{"unsignedInt"};
            }
            case 828378953: {
                return new String[]{"id"};
            }
            case 1702620169: {
                return new String[]{"CodeableReference"};
            }
            case 97604824: {
                return new String[]{"Reference"};
            }
            case 555127957: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.status");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.issued");
        }
        if (name.equals("performer")) {
            return this.addPerformer();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("studyUid")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.studyUid");
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("endpoint")) {
            return this.addEndpoint();
        }
        if (name.equals("seriesUid")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.seriesUid");
        }
        if (name.equals("seriesNumber")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.seriesNumber");
        }
        if (name.equals("frameOfReferenceUid")) {
            throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.frameOfReferenceUid");
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableReference();
            return this.bodySite;
        }
        if (name.equals("focus")) {
            return this.addFocus();
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingSelection";
    }

    @Override
    public ImagingSelection copy() {
        ImagingSelection dst = new ImagingSelection();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ImagingSelection dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        InstantType instantType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<ImagingSelectionPerformerComponent>();
            for (ImagingSelectionPerformerComponent imagingSelectionPerformerComponent : this.performer) {
                dst.performer.add(imagingSelectionPerformerComponent.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        IdType idType = dst.studyUid = this.studyUid == null ? null : this.studyUid.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference : this.derivedFrom) {
                dst.derivedFrom.add(reference.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference : this.endpoint) {
                dst.endpoint.add(reference.copy());
            }
        }
        dst.seriesUid = this.seriesUid == null ? null : this.seriesUid.copy();
        dst.seriesNumber = this.seriesNumber == null ? null : this.seriesNumber.copy();
        dst.frameOfReferenceUid = this.frameOfReferenceUid == null ? null : this.frameOfReferenceUid.copy();
        CodeableReference codeableReference = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        if (this.focus != null) {
            dst.focus = new ArrayList<Reference>();
            for (Reference reference : this.focus) {
                dst.focus.add(reference.copy());
            }
        }
        if (this.instance != null) {
            dst.instance = new ArrayList<ImagingSelectionInstanceComponent>();
            for (ImagingSelectionInstanceComponent imagingSelectionInstanceComponent : this.instance) {
                dst.instance.add(imagingSelectionInstanceComponent.copy());
            }
        }
    }

    protected ImagingSelection typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingSelection)) {
            return false;
        }
        ImagingSelection o = (ImagingSelection)other_;
        return ImagingSelection.compareDeep(this.identifier, o.identifier, true) && ImagingSelection.compareDeep(this.status, o.status, true) && ImagingSelection.compareDeep(this.subject, o.subject, true) && ImagingSelection.compareDeep(this.issued, o.issued, true) && ImagingSelection.compareDeep(this.performer, o.performer, true) && ImagingSelection.compareDeep(this.basedOn, o.basedOn, true) && ImagingSelection.compareDeep(this.category, o.category, true) && ImagingSelection.compareDeep(this.code, o.code, true) && ImagingSelection.compareDeep(this.studyUid, o.studyUid, true) && ImagingSelection.compareDeep(this.derivedFrom, o.derivedFrom, true) && ImagingSelection.compareDeep(this.endpoint, o.endpoint, true) && ImagingSelection.compareDeep(this.seriesUid, o.seriesUid, true) && ImagingSelection.compareDeep(this.seriesNumber, o.seriesNumber, true) && ImagingSelection.compareDeep(this.frameOfReferenceUid, o.frameOfReferenceUid, true) && ImagingSelection.compareDeep(this.bodySite, o.bodySite, true) && ImagingSelection.compareDeep(this.focus, o.focus, true) && ImagingSelection.compareDeep(this.instance, o.instance, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingSelection)) {
            return false;
        }
        ImagingSelection o = (ImagingSelection)other_;
        return ImagingSelection.compareValues(this.status, o.status, true) && ImagingSelection.compareValues(this.issued, o.issued, true) && ImagingSelection.compareValues(this.studyUid, o.studyUid, true) && ImagingSelection.compareValues(this.seriesUid, o.seriesUid, true) && ImagingSelection.compareValues(this.seriesNumber, o.seriesNumber, true) && ImagingSelection.compareValues(this.frameOfReferenceUid, o.frameOfReferenceUid, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.subject, this.issued, this.performer, this.basedOn, this.category, this.code, this.studyUid, this.derivedFrom, this.endpoint, this.seriesUid, this.seriesNumber, this.frameOfReferenceUid, this.bodySite, this.focus, this.instance});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingSelection;
    }

    @Block
    public static class ImageRegion3DComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="regionType", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="point | multipoint | polyline | polygon | ellipse | ellipsoid", formalDefinition="Specifies the type of image region.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/imagingselection-3dgraphictype")
        protected Enumeration<ImagingSelection3DGraphicType> regionType;
        @Child(name="coordinate", type={DecimalType.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the coordinates that define the image region", formalDefinition="The coordinates describing the image region. Encoded as an ordered set of (x,y,z) triplets (in mm and may be negative) that define a region of interest in the patient-relative Reference Coordinate System defined by ImagingSelection.frameOfReferenceUid element.")
        protected List<DecimalType> coordinate;
        private static final long serialVersionUID = 1532227853L;

        public ImageRegion3DComponent() {
        }

        public ImageRegion3DComponent(ImagingSelection3DGraphicType regionType, BigDecimal coordinate) {
            this.setRegionType(regionType);
            this.addCoordinate(coordinate);
        }

        public Enumeration<ImagingSelection3DGraphicType> getRegionTypeElement() {
            if (this.regionType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImageRegion3DComponent.regionType");
                }
                if (Configuration.doAutoCreate()) {
                    this.regionType = new Enumeration<ImagingSelection3DGraphicType>(new ImagingSelection3DGraphicTypeEnumFactory());
                }
            }
            return this.regionType;
        }

        public boolean hasRegionTypeElement() {
            return this.regionType != null && !this.regionType.isEmpty();
        }

        public boolean hasRegionType() {
            return this.regionType != null && !this.regionType.isEmpty();
        }

        public ImageRegion3DComponent setRegionTypeElement(Enumeration<ImagingSelection3DGraphicType> value) {
            this.regionType = value;
            return this;
        }

        public ImagingSelection3DGraphicType getRegionType() {
            return this.regionType == null ? null : (ImagingSelection3DGraphicType)((Object)this.regionType.getValue());
        }

        public ImageRegion3DComponent setRegionType(ImagingSelection3DGraphicType value) {
            if (this.regionType == null) {
                this.regionType = new Enumeration<ImagingSelection3DGraphicType>(new ImagingSelection3DGraphicTypeEnumFactory());
            }
            this.regionType.setValue((Object)value);
            return this;
        }

        public List<DecimalType> getCoordinate() {
            if (this.coordinate == null) {
                this.coordinate = new ArrayList<DecimalType>();
            }
            return this.coordinate;
        }

        public ImageRegion3DComponent setCoordinate(List<DecimalType> theCoordinate) {
            this.coordinate = theCoordinate;
            return this;
        }

        public boolean hasCoordinate() {
            if (this.coordinate == null) {
                return false;
            }
            for (DecimalType item : this.coordinate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DecimalType addCoordinateElement() {
            DecimalType t = new DecimalType();
            if (this.coordinate == null) {
                this.coordinate = new ArrayList<DecimalType>();
            }
            this.coordinate.add(t);
            return t;
        }

        public ImageRegion3DComponent addCoordinate(BigDecimal value) {
            DecimalType t = new DecimalType();
            t.setValue(value);
            if (this.coordinate == null) {
                this.coordinate = new ArrayList<DecimalType>();
            }
            this.coordinate.add(t);
            return this;
        }

        public boolean hasCoordinate(BigDecimal value) {
            if (this.coordinate == null) {
                return false;
            }
            for (DecimalType v : this.coordinate) {
                if (!((BigDecimal)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("regionType", ImagingSelection.SP_CODE, "Specifies the type of image region.", 0, 1, this.regionType));
            children.add(new Property("coordinate", "decimal", "The coordinates describing the image region. Encoded as an ordered set of (x,y,z) triplets (in mm and may be negative) that define a region of interest in the patient-relative Reference Coordinate System defined by ImagingSelection.frameOfReferenceUid element.", 0, Integer.MAX_VALUE, this.coordinate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1990487986: {
                    return new Property("regionType", ImagingSelection.SP_CODE, "Specifies the type of image region.", 0, 1, this.regionType);
                }
                case 198931832: {
                    return new Property("coordinate", "decimal", "The coordinates describing the image region. Encoded as an ordered set of (x,y,z) triplets (in mm and may be negative) that define a region of interest in the patient-relative Reference Coordinate System defined by ImagingSelection.frameOfReferenceUid element.", 0, Integer.MAX_VALUE, this.coordinate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    Base[] baseArray;
                    if (this.regionType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.regionType;
                    }
                    return baseArray;
                }
                case 198931832: {
                    return this.coordinate == null ? new Base[]{} : this.coordinate.toArray(new Base[this.coordinate.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    value = new ImagingSelection3DGraphicTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.regionType = value;
                    return value;
                }
                case 198931832: {
                    this.getCoordinate().add(TypeConvertor.castToDecimal(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("regionType")) {
                value = new ImagingSelection3DGraphicTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.regionType = value;
            } else if (name.equals("coordinate")) {
                this.getCoordinate().add(TypeConvertor.castToDecimal(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("regionType")) {
                value = new ImagingSelection3DGraphicTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.regionType = value;
            } else if (name.equals("coordinate")) {
                this.getCoordinate().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    return this.getRegionTypeElement();
                }
                case 198931832: {
                    return this.addCoordinateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    return new String[]{ImagingSelection.SP_CODE};
                }
                case 198931832: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("regionType")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.instance.imageRegion3D.regionType");
            }
            if (name.equals("coordinate")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.instance.imageRegion3D.coordinate");
            }
            return super.addChild(name);
        }

        @Override
        public ImageRegion3DComponent copy() {
            ImageRegion3DComponent dst = new ImageRegion3DComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImageRegion3DComponent dst) {
            super.copyValues(dst);
            Enumeration<ImagingSelection3DGraphicType> enumeration = dst.regionType = this.regionType == null ? null : this.regionType.copy();
            if (this.coordinate != null) {
                dst.coordinate = new ArrayList<DecimalType>();
                for (DecimalType i : this.coordinate) {
                    dst.coordinate.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImageRegion3DComponent)) {
                return false;
            }
            ImageRegion3DComponent o = (ImageRegion3DComponent)other_;
            return ImageRegion3DComponent.compareDeep(this.regionType, o.regionType, true) && ImageRegion3DComponent.compareDeep(this.coordinate, o.coordinate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImageRegion3DComponent)) {
                return false;
            }
            ImageRegion3DComponent o = (ImageRegion3DComponent)other_;
            return ImageRegion3DComponent.compareValues(this.regionType, o.regionType, true) && ImageRegion3DComponent.compareValues(this.coordinate, o.coordinate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.regionType, this.coordinate});
        }

        @Override
        public String fhirType() {
            return "ImagingSelection.instance.imageRegion3D";
        }
    }

    @Block
    public static class ImageRegion2DComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="regionType", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="point | polyline | interpolated | circle | ellipse", formalDefinition="Specifies the type of image region.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/imagingselection-2dgraphictype")
        protected Enumeration<ImagingSelection2DGraphicType> regionType;
        @Child(name="coordinate", type={DecimalType.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specifies the coordinates that define the image region", formalDefinition="The coordinates describing the image region. Encoded as a set of (column, row) pairs that denote positions in the selected image / frames specified with sub-pixel resolution.\n       The origin at the TLHC of the TLHC pixel is 0.0\\0.0, the BRHC of the TLHC pixel is 1.0\\1.0, and the BRHC of the BRHC pixel is the number of columns\\rows in the image / frames. The values must be within the range 0\\0 to the number of columns\\rows in the image / frames.")
        protected List<DecimalType> coordinate;
        private static final long serialVersionUID = 1518695052L;

        public ImageRegion2DComponent() {
        }

        public ImageRegion2DComponent(ImagingSelection2DGraphicType regionType, BigDecimal coordinate) {
            this.setRegionType(regionType);
            this.addCoordinate(coordinate);
        }

        public Enumeration<ImagingSelection2DGraphicType> getRegionTypeElement() {
            if (this.regionType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImageRegion2DComponent.regionType");
                }
                if (Configuration.doAutoCreate()) {
                    this.regionType = new Enumeration<ImagingSelection2DGraphicType>(new ImagingSelection2DGraphicTypeEnumFactory());
                }
            }
            return this.regionType;
        }

        public boolean hasRegionTypeElement() {
            return this.regionType != null && !this.regionType.isEmpty();
        }

        public boolean hasRegionType() {
            return this.regionType != null && !this.regionType.isEmpty();
        }

        public ImageRegion2DComponent setRegionTypeElement(Enumeration<ImagingSelection2DGraphicType> value) {
            this.regionType = value;
            return this;
        }

        public ImagingSelection2DGraphicType getRegionType() {
            return this.regionType == null ? null : (ImagingSelection2DGraphicType)((Object)this.regionType.getValue());
        }

        public ImageRegion2DComponent setRegionType(ImagingSelection2DGraphicType value) {
            if (this.regionType == null) {
                this.regionType = new Enumeration<ImagingSelection2DGraphicType>(new ImagingSelection2DGraphicTypeEnumFactory());
            }
            this.regionType.setValue((Object)value);
            return this;
        }

        public List<DecimalType> getCoordinate() {
            if (this.coordinate == null) {
                this.coordinate = new ArrayList<DecimalType>();
            }
            return this.coordinate;
        }

        public ImageRegion2DComponent setCoordinate(List<DecimalType> theCoordinate) {
            this.coordinate = theCoordinate;
            return this;
        }

        public boolean hasCoordinate() {
            if (this.coordinate == null) {
                return false;
            }
            for (DecimalType item : this.coordinate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DecimalType addCoordinateElement() {
            DecimalType t = new DecimalType();
            if (this.coordinate == null) {
                this.coordinate = new ArrayList<DecimalType>();
            }
            this.coordinate.add(t);
            return t;
        }

        public ImageRegion2DComponent addCoordinate(BigDecimal value) {
            DecimalType t = new DecimalType();
            t.setValue(value);
            if (this.coordinate == null) {
                this.coordinate = new ArrayList<DecimalType>();
            }
            this.coordinate.add(t);
            return this;
        }

        public boolean hasCoordinate(BigDecimal value) {
            if (this.coordinate == null) {
                return false;
            }
            for (DecimalType v : this.coordinate) {
                if (!((BigDecimal)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("regionType", ImagingSelection.SP_CODE, "Specifies the type of image region.", 0, 1, this.regionType));
            children.add(new Property("coordinate", "decimal", "The coordinates describing the image region. Encoded as a set of (column, row) pairs that denote positions in the selected image / frames specified with sub-pixel resolution.\n       The origin at the TLHC of the TLHC pixel is 0.0\\0.0, the BRHC of the TLHC pixel is 1.0\\1.0, and the BRHC of the BRHC pixel is the number of columns\\rows in the image / frames. The values must be within the range 0\\0 to the number of columns\\rows in the image / frames.", 0, Integer.MAX_VALUE, this.coordinate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1990487986: {
                    return new Property("regionType", ImagingSelection.SP_CODE, "Specifies the type of image region.", 0, 1, this.regionType);
                }
                case 198931832: {
                    return new Property("coordinate", "decimal", "The coordinates describing the image region. Encoded as a set of (column, row) pairs that denote positions in the selected image / frames specified with sub-pixel resolution.\n       The origin at the TLHC of the TLHC pixel is 0.0\\0.0, the BRHC of the TLHC pixel is 1.0\\1.0, and the BRHC of the BRHC pixel is the number of columns\\rows in the image / frames. The values must be within the range 0\\0 to the number of columns\\rows in the image / frames.", 0, Integer.MAX_VALUE, this.coordinate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    Base[] baseArray;
                    if (this.regionType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.regionType;
                    }
                    return baseArray;
                }
                case 198931832: {
                    return this.coordinate == null ? new Base[]{} : this.coordinate.toArray(new Base[this.coordinate.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    value = new ImagingSelection2DGraphicTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.regionType = value;
                    return value;
                }
                case 198931832: {
                    this.getCoordinate().add(TypeConvertor.castToDecimal(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("regionType")) {
                value = new ImagingSelection2DGraphicTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.regionType = value;
            } else if (name.equals("coordinate")) {
                this.getCoordinate().add(TypeConvertor.castToDecimal(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("regionType")) {
                value = new ImagingSelection2DGraphicTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.regionType = value;
            } else if (name.equals("coordinate")) {
                this.getCoordinate().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    return this.getRegionTypeElement();
                }
                case 198931832: {
                    return this.addCoordinateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1990487986: {
                    return new String[]{ImagingSelection.SP_CODE};
                }
                case 198931832: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("regionType")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.instance.imageRegion2D.regionType");
            }
            if (name.equals("coordinate")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.instance.imageRegion2D.coordinate");
            }
            return super.addChild(name);
        }

        @Override
        public ImageRegion2DComponent copy() {
            ImageRegion2DComponent dst = new ImageRegion2DComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImageRegion2DComponent dst) {
            super.copyValues(dst);
            Enumeration<ImagingSelection2DGraphicType> enumeration = dst.regionType = this.regionType == null ? null : this.regionType.copy();
            if (this.coordinate != null) {
                dst.coordinate = new ArrayList<DecimalType>();
                for (DecimalType i : this.coordinate) {
                    dst.coordinate.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImageRegion2DComponent)) {
                return false;
            }
            ImageRegion2DComponent o = (ImageRegion2DComponent)other_;
            return ImageRegion2DComponent.compareDeep(this.regionType, o.regionType, true) && ImageRegion2DComponent.compareDeep(this.coordinate, o.coordinate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImageRegion2DComponent)) {
                return false;
            }
            ImageRegion2DComponent o = (ImageRegion2DComponent)other_;
            return ImageRegion2DComponent.compareValues(this.regionType, o.regionType, true) && ImageRegion2DComponent.compareValues(this.coordinate, o.coordinate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.regionType, this.coordinate});
        }

        @Override
        public String fhirType() {
            return "ImagingSelection.instance.imageRegion2D";
        }
    }

    @Block
    public static class ImagingSelectionInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="DICOM SOP Instance UID", formalDefinition="The SOP Instance UID for the selected DICOM instance.")
        protected IdType uid;
        @Child(name="number", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="DICOM Instance Number", formalDefinition="The Instance Number for the selected DICOM instance.")
        protected UnsignedIntType number;
        @Child(name="sopClass", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="DICOM SOP Class UID", formalDefinition="The SOP Class UID for the selected DICOM instance.")
        @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part04/sect_B.5.html#table_B.5-1")
        protected Coding sopClass;
        @Child(name="subset", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The selected subset of the SOP Instance", formalDefinition="Selected subset of the SOP Instance. The content and format of the subset item is determined by the SOP Class of the selected instance.\n       May be one of:\n       - A list of frame numbers selected from a multiframe SOP Instance.\n       - A list of Content Item Observation UID values selected from a DICOM SR or other structured document SOP Instance.\n       - A list of segment numbers selected from a segmentation SOP Instance.\n       - A list of Region of Interest (ROI) numbers selected from a radiotherapy structure set SOP Instance.")
        protected List<StringType> subset;
        @Child(name="imageRegion2D", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A specific 2D region in a DICOM image / frame", formalDefinition="Each imaging selection instance or frame list might includes an image region, specified by a region type and a set of 2D coordinates.\n       If the parent imagingSelection.instance contains a subset element of type frame, the image region applies to all frames in the subset list.")
        protected List<ImageRegion2DComponent> imageRegion2D;
        @Child(name="imageRegion3D", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A specific 3D region in a DICOM frame of reference", formalDefinition="Each imaging selection might includes a 3D image region, specified by a region type and a set of 3D coordinates.")
        protected List<ImageRegion3DComponent> imageRegion3D;
        private static final long serialVersionUID = 1783712351L;

        public ImagingSelectionInstanceComponent() {
        }

        public ImagingSelectionInstanceComponent(String uid) {
            this.setUid(uid);
        }

        public IdType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionInstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new IdType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public ImagingSelectionInstanceComponent setUidElement(IdType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : this.uid.getValue();
        }

        public ImagingSelectionInstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new IdType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UnsignedIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionInstanceComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new UnsignedIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ImagingSelectionInstanceComponent setNumberElement(UnsignedIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public ImagingSelectionInstanceComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new UnsignedIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Coding getSopClass() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionInstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new Coding();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public ImagingSelectionInstanceComponent setSopClass(Coding value) {
            this.sopClass = value;
            return this;
        }

        public List<StringType> getSubset() {
            if (this.subset == null) {
                this.subset = new ArrayList<StringType>();
            }
            return this.subset;
        }

        public ImagingSelectionInstanceComponent setSubset(List<StringType> theSubset) {
            this.subset = theSubset;
            return this;
        }

        public boolean hasSubset() {
            if (this.subset == null) {
                return false;
            }
            for (StringType item : this.subset) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addSubsetElement() {
            StringType t = new StringType();
            if (this.subset == null) {
                this.subset = new ArrayList<StringType>();
            }
            this.subset.add(t);
            return t;
        }

        public ImagingSelectionInstanceComponent addSubset(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.subset == null) {
                this.subset = new ArrayList<StringType>();
            }
            this.subset.add(t);
            return this;
        }

        public boolean hasSubset(String value) {
            if (this.subset == null) {
                return false;
            }
            for (StringType v : this.subset) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ImageRegion2DComponent> getImageRegion2D() {
            if (this.imageRegion2D == null) {
                this.imageRegion2D = new ArrayList<ImageRegion2DComponent>();
            }
            return this.imageRegion2D;
        }

        public ImagingSelectionInstanceComponent setImageRegion2D(List<ImageRegion2DComponent> theImageRegion2D) {
            this.imageRegion2D = theImageRegion2D;
            return this;
        }

        public boolean hasImageRegion2D() {
            if (this.imageRegion2D == null) {
                return false;
            }
            for (ImageRegion2DComponent item : this.imageRegion2D) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImageRegion2DComponent addImageRegion2D() {
            ImageRegion2DComponent t = new ImageRegion2DComponent();
            if (this.imageRegion2D == null) {
                this.imageRegion2D = new ArrayList<ImageRegion2DComponent>();
            }
            this.imageRegion2D.add(t);
            return t;
        }

        public ImagingSelectionInstanceComponent addImageRegion2D(ImageRegion2DComponent t) {
            if (t == null) {
                return this;
            }
            if (this.imageRegion2D == null) {
                this.imageRegion2D = new ArrayList<ImageRegion2DComponent>();
            }
            this.imageRegion2D.add(t);
            return this;
        }

        public ImageRegion2DComponent getImageRegion2DFirstRep() {
            if (this.getImageRegion2D().isEmpty()) {
                this.addImageRegion2D();
            }
            return this.getImageRegion2D().get(0);
        }

        public List<ImageRegion3DComponent> getImageRegion3D() {
            if (this.imageRegion3D == null) {
                this.imageRegion3D = new ArrayList<ImageRegion3DComponent>();
            }
            return this.imageRegion3D;
        }

        public ImagingSelectionInstanceComponent setImageRegion3D(List<ImageRegion3DComponent> theImageRegion3D) {
            this.imageRegion3D = theImageRegion3D;
            return this;
        }

        public boolean hasImageRegion3D() {
            if (this.imageRegion3D == null) {
                return false;
            }
            for (ImageRegion3DComponent item : this.imageRegion3D) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImageRegion3DComponent addImageRegion3D() {
            ImageRegion3DComponent t = new ImageRegion3DComponent();
            if (this.imageRegion3D == null) {
                this.imageRegion3D = new ArrayList<ImageRegion3DComponent>();
            }
            this.imageRegion3D.add(t);
            return t;
        }

        public ImagingSelectionInstanceComponent addImageRegion3D(ImageRegion3DComponent t) {
            if (t == null) {
                return this;
            }
            if (this.imageRegion3D == null) {
                this.imageRegion3D = new ArrayList<ImageRegion3DComponent>();
            }
            this.imageRegion3D.add(t);
            return this;
        }

        public ImageRegion3DComponent getImageRegion3DFirstRep() {
            if (this.getImageRegion3D().isEmpty()) {
                this.addImageRegion3D();
            }
            return this.getImageRegion3D().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uid", "id", "The SOP Instance UID for the selected DICOM instance.", 0, 1, this.uid));
            children.add(new Property("number", "unsignedInt", "The Instance Number for the selected DICOM instance.", 0, 1, this.number));
            children.add(new Property("sopClass", "Coding", "The SOP Class UID for the selected DICOM instance.", 0, 1, this.sopClass));
            children.add(new Property("subset", "string", "Selected subset of the SOP Instance. The content and format of the subset item is determined by the SOP Class of the selected instance.\n       May be one of:\n       - A list of frame numbers selected from a multiframe SOP Instance.\n       - A list of Content Item Observation UID values selected from a DICOM SR or other structured document SOP Instance.\n       - A list of segment numbers selected from a segmentation SOP Instance.\n       - A list of Region of Interest (ROI) numbers selected from a radiotherapy structure set SOP Instance.", 0, Integer.MAX_VALUE, this.subset));
            children.add(new Property("imageRegion2D", "", "Each imaging selection instance or frame list might includes an image region, specified by a region type and a set of 2D coordinates.\n       If the parent imagingSelection.instance contains a subset element of type frame, the image region applies to all frames in the subset list.", 0, Integer.MAX_VALUE, this.imageRegion2D));
            children.add(new Property("imageRegion3D", "", "Each imaging selection might includes a 3D image region, specified by a region type and a set of 3D coordinates.", 0, Integer.MAX_VALUE, this.imageRegion3D));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 115792: {
                    return new Property("uid", "id", "The SOP Instance UID for the selected DICOM instance.", 0, 1, this.uid);
                }
                case -1034364087: {
                    return new Property("number", "unsignedInt", "The Instance Number for the selected DICOM instance.", 0, 1, this.number);
                }
                case 1560041540: {
                    return new Property("sopClass", "Coding", "The SOP Class UID for the selected DICOM instance.", 0, 1, this.sopClass);
                }
                case -891529694: {
                    return new Property("subset", "string", "Selected subset of the SOP Instance. The content and format of the subset item is determined by the SOP Class of the selected instance.\n       May be one of:\n       - A list of frame numbers selected from a multiframe SOP Instance.\n       - A list of Content Item Observation UID values selected from a DICOM SR or other structured document SOP Instance.\n       - A list of segment numbers selected from a segmentation SOP Instance.\n       - A list of Region of Interest (ROI) numbers selected from a radiotherapy structure set SOP Instance.", 0, Integer.MAX_VALUE, this.subset);
                }
                case 675922625: {
                    return new Property("imageRegion2D", "", "Each imaging selection instance or frame list might includes an image region, specified by a region type and a set of 2D coordinates.\n       If the parent imagingSelection.instance contains a subset element of type frame, the image region applies to all frames in the subset list.", 0, Integer.MAX_VALUE, this.imageRegion2D);
                }
                case 675922656: {
                    return new Property("imageRegion3D", "", "Each imaging selection might includes a 3D image region, specified by a region type and a set of 3D coordinates.", 0, Integer.MAX_VALUE, this.imageRegion3D);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.number;
                    }
                    return baseArray;
                }
                case 1560041540: {
                    Base[] baseArray;
                    if (this.sopClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.sopClass;
                    }
                    return baseArray;
                }
                case -891529694: {
                    return this.subset == null ? new Base[]{} : this.subset.toArray(new Base[this.subset.size()]);
                }
                case 675922625: {
                    return this.imageRegion2D == null ? new Base[]{} : this.imageRegion2D.toArray(new Base[this.imageRegion2D.size()]);
                }
                case 675922656: {
                    return this.imageRegion3D == null ? new Base[]{} : this.imageRegion3D.toArray(new Base[this.imageRegion3D.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = TypeConvertor.castToId(value);
                    return value;
                }
                case -1034364087: {
                    this.number = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case 1560041540: {
                    this.sopClass = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -891529694: {
                    this.getSubset().add(TypeConvertor.castToString(value));
                    return value;
                }
                case 675922625: {
                    this.getImageRegion2D().add((ImageRegion2DComponent)value);
                    return value;
                }
                case 675922656: {
                    this.getImageRegion3D().add((ImageRegion3DComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = TypeConvertor.castToId(value);
            } else if (name.equals("number")) {
                this.number = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("sopClass")) {
                this.sopClass = TypeConvertor.castToCoding(value);
            } else if (name.equals("subset")) {
                this.getSubset().add(TypeConvertor.castToString(value));
            } else if (name.equals("imageRegion2D")) {
                this.getImageRegion2D().add((ImageRegion2DComponent)value);
            } else if (name.equals("imageRegion3D")) {
                this.getImageRegion3D().add((ImageRegion3DComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = null;
            } else if (name.equals("number")) {
                this.number = null;
            } else if (name.equals("sopClass")) {
                this.sopClass = null;
            } else if (name.equals("subset")) {
                this.getSubset().remove(value);
            } else if (name.equals("imageRegion2D")) {
                this.getImageRegion2D().remove((ImageRegion2DComponent)value);
            } else if (name.equals("imageRegion3D")) {
                this.getImageRegion3D().remove((ImageRegion3DComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return this.getUidElement();
                }
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 1560041540: {
                    return this.getSopClass();
                }
                case -891529694: {
                    return this.addSubsetElement();
                }
                case 675922625: {
                    return this.addImageRegion2D();
                }
                case 675922656: {
                    return this.addImageRegion3D();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return new String[]{"id"};
                }
                case -1034364087: {
                    return new String[]{"unsignedInt"};
                }
                case 1560041540: {
                    return new String[]{"Coding"};
                }
                case -891529694: {
                    return new String[]{"string"};
                }
                case 675922625: {
                    return new String[0];
                }
                case 675922656: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.instance.uid");
            }
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.instance.number");
            }
            if (name.equals("sopClass")) {
                this.sopClass = new Coding();
                return this.sopClass;
            }
            if (name.equals("subset")) {
                throw new FHIRException("Cannot call addChild on a singleton property ImagingSelection.instance.subset");
            }
            if (name.equals("imageRegion2D")) {
                return this.addImageRegion2D();
            }
            if (name.equals("imageRegion3D")) {
                return this.addImageRegion3D();
            }
            return super.addChild(name);
        }

        @Override
        public ImagingSelectionInstanceComponent copy() {
            ImagingSelectionInstanceComponent dst = new ImagingSelectionInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingSelectionInstanceComponent dst) {
            super.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.number = this.number == null ? null : this.number.copy();
            Coding coding = dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            if (this.subset != null) {
                dst.subset = new ArrayList<StringType>();
                for (StringType stringType : this.subset) {
                    dst.subset.add(stringType.copy());
                }
            }
            if (this.imageRegion2D != null) {
                dst.imageRegion2D = new ArrayList<ImageRegion2DComponent>();
                for (ImageRegion2DComponent imageRegion2DComponent : this.imageRegion2D) {
                    dst.imageRegion2D.add(imageRegion2DComponent.copy());
                }
            }
            if (this.imageRegion3D != null) {
                dst.imageRegion3D = new ArrayList<ImageRegion3DComponent>();
                for (ImageRegion3DComponent imageRegion3DComponent : this.imageRegion3D) {
                    dst.imageRegion3D.add(imageRegion3DComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionInstanceComponent)) {
                return false;
            }
            ImagingSelectionInstanceComponent o = (ImagingSelectionInstanceComponent)other_;
            return ImagingSelectionInstanceComponent.compareDeep(this.uid, o.uid, true) && ImagingSelectionInstanceComponent.compareDeep(this.number, o.number, true) && ImagingSelectionInstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && ImagingSelectionInstanceComponent.compareDeep(this.subset, o.subset, true) && ImagingSelectionInstanceComponent.compareDeep(this.imageRegion2D, o.imageRegion2D, true) && ImagingSelectionInstanceComponent.compareDeep(this.imageRegion3D, o.imageRegion3D, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionInstanceComponent)) {
                return false;
            }
            ImagingSelectionInstanceComponent o = (ImagingSelectionInstanceComponent)other_;
            return ImagingSelectionInstanceComponent.compareValues(this.uid, o.uid, true) && ImagingSelectionInstanceComponent.compareValues(this.number, o.number, true) && ImagingSelectionInstanceComponent.compareValues(this.subset, o.subset, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.number, this.sopClass, this.subset, this.imageRegion2D, this.imageRegion3D});
        }

        @Override
        public String fhirType() {
            return "ImagingSelection.instance";
        }
    }

    @Block
    public static class ImagingSelectionPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of performer", formalDefinition="Distinguishes the type of involvement of the performer.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/series-performer-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Device.class, Organization.class, CareTeam.class, Patient.class, RelatedPerson.class, HealthcareService.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Author (human or machine)", formalDefinition="Author \u2013 human or machine.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionPerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public ImagingSelectionPerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingSelectionPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ImagingSelectionPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Device|Organization|CareTeam|Patient|RelatedPerson|HealthcareService)", "Author \u2013 human or machine.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Device|Organization|CareTeam|Patient|RelatedPerson|HealthcareService)", "Author \u2013 human or machine.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = null;
            } else if (name.equals("actor")) {
                this.actor = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public ImagingSelectionPerformerComponent copy() {
            ImagingSelectionPerformerComponent dst = new ImagingSelectionPerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingSelectionPerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionPerformerComponent)) {
                return false;
            }
            ImagingSelectionPerformerComponent o = (ImagingSelectionPerformerComponent)other_;
            return ImagingSelectionPerformerComponent.compareDeep(this.function, o.function, true) && ImagingSelectionPerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingSelectionPerformerComponent)) {
                return false;
            }
            ImagingSelectionPerformerComponent o = (ImagingSelectionPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "ImagingSelection.performer";
        }
    }

    public static class ImagingSelectionStatusEnumFactory
    implements EnumFactory<ImagingSelectionStatus> {
        @Override
        public ImagingSelectionStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("available".equals(codeString)) {
                return ImagingSelectionStatus.AVAILABLE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ImagingSelectionStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ImagingSelectionStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ImagingSelectionStatus code '" + codeString + "'");
        }

        public Enumeration<ImagingSelectionStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ImagingSelectionStatus>(this, ImagingSelectionStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ImagingSelectionStatus>(this, ImagingSelectionStatus.NULL, code);
            }
            if ("available".equals(codeString)) {
                return new Enumeration<ImagingSelectionStatus>(this, ImagingSelectionStatus.AVAILABLE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ImagingSelectionStatus>(this, ImagingSelectionStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ImagingSelectionStatus>(this, ImagingSelectionStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown ImagingSelectionStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ImagingSelectionStatus code) {
            if (code == ImagingSelectionStatus.NULL) {
                return null;
            }
            if (code == ImagingSelectionStatus.AVAILABLE) {
                return "available";
            }
            if (code == ImagingSelectionStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ImagingSelectionStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ImagingSelectionStatus code) {
            return code.getSystem();
        }
    }

    public static enum ImagingSelectionStatus {
        AVAILABLE,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ImagingSelectionStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return AVAILABLE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ImagingSelectionStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AVAILABLE: {
                    return "available";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AVAILABLE: {
                    return "http://hl7.org/fhir/imagingselection-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/imagingselection-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/imagingselection-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AVAILABLE: {
                    return "The selected resources are available..";
                }
                case ENTEREDINERROR: {
                    return "The imaging selection has been withdrawn following a release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The system does not know which of the status values currently applies for this request. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AVAILABLE: {
                    return "Available";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ImagingSelection3DGraphicTypeEnumFactory
    implements EnumFactory<ImagingSelection3DGraphicType> {
        @Override
        public ImagingSelection3DGraphicType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("point".equals(codeString)) {
                return ImagingSelection3DGraphicType.POINT;
            }
            if ("multipoint".equals(codeString)) {
                return ImagingSelection3DGraphicType.MULTIPOINT;
            }
            if ("polyline".equals(codeString)) {
                return ImagingSelection3DGraphicType.POLYLINE;
            }
            if ("polygon".equals(codeString)) {
                return ImagingSelection3DGraphicType.POLYGON;
            }
            if ("ellipse".equals(codeString)) {
                return ImagingSelection3DGraphicType.ELLIPSE;
            }
            if ("ellipsoid".equals(codeString)) {
                return ImagingSelection3DGraphicType.ELLIPSOID;
            }
            throw new IllegalArgumentException("Unknown ImagingSelection3DGraphicType code '" + codeString + "'");
        }

        public Enumeration<ImagingSelection3DGraphicType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ImagingSelection3DGraphicType>(this, ImagingSelection3DGraphicType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ImagingSelection3DGraphicType>(this, ImagingSelection3DGraphicType.NULL, code);
            }
            if ("point".equals(codeString)) {
                return new Enumeration<ImagingSelection3DGraphicType>(this, ImagingSelection3DGraphicType.POINT, code);
            }
            if ("multipoint".equals(codeString)) {
                return new Enumeration<ImagingSelection3DGraphicType>(this, ImagingSelection3DGraphicType.MULTIPOINT, code);
            }
            if ("polyline".equals(codeString)) {
                return new Enumeration<ImagingSelection3DGraphicType>(this, ImagingSelection3DGraphicType.POLYLINE, code);
            }
            if ("polygon".equals(codeString)) {
                return new Enumeration<ImagingSelection3DGraphicType>(this, ImagingSelection3DGraphicType.POLYGON, code);
            }
            if ("ellipse".equals(codeString)) {
                return new Enumeration<ImagingSelection3DGraphicType>(this, ImagingSelection3DGraphicType.ELLIPSE, code);
            }
            if ("ellipsoid".equals(codeString)) {
                return new Enumeration<ImagingSelection3DGraphicType>(this, ImagingSelection3DGraphicType.ELLIPSOID, code);
            }
            throw new FHIRException("Unknown ImagingSelection3DGraphicType code '" + codeString + "'");
        }

        @Override
        public String toCode(ImagingSelection3DGraphicType code) {
            if (code == ImagingSelection3DGraphicType.NULL) {
                return null;
            }
            if (code == ImagingSelection3DGraphicType.POINT) {
                return "point";
            }
            if (code == ImagingSelection3DGraphicType.MULTIPOINT) {
                return "multipoint";
            }
            if (code == ImagingSelection3DGraphicType.POLYLINE) {
                return "polyline";
            }
            if (code == ImagingSelection3DGraphicType.POLYGON) {
                return "polygon";
            }
            if (code == ImagingSelection3DGraphicType.ELLIPSE) {
                return "ellipse";
            }
            if (code == ImagingSelection3DGraphicType.ELLIPSOID) {
                return "ellipsoid";
            }
            return "?";
        }

        @Override
        public String toSystem(ImagingSelection3DGraphicType code) {
            return code.getSystem();
        }
    }

    public static enum ImagingSelection3DGraphicType {
        POINT,
        MULTIPOINT,
        POLYLINE,
        POLYGON,
        ELLIPSE,
        ELLIPSOID,
        NULL;


        public static ImagingSelection3DGraphicType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("point".equals(codeString)) {
                return POINT;
            }
            if ("multipoint".equals(codeString)) {
                return MULTIPOINT;
            }
            if ("polyline".equals(codeString)) {
                return POLYLINE;
            }
            if ("polygon".equals(codeString)) {
                return POLYGON;
            }
            if ("ellipse".equals(codeString)) {
                return ELLIPSE;
            }
            if ("ellipsoid".equals(codeString)) {
                return ELLIPSOID;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ImagingSelection3DGraphicType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case POINT: {
                    return "point";
                }
                case MULTIPOINT: {
                    return "multipoint";
                }
                case POLYLINE: {
                    return "polyline";
                }
                case POLYGON: {
                    return "polygon";
                }
                case ELLIPSE: {
                    return "ellipse";
                }
                case ELLIPSOID: {
                    return "ellipsoid";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case POINT: {
                    return "http://hl7.org/fhir/imagingselection-3dgraphictype";
                }
                case MULTIPOINT: {
                    return "http://hl7.org/fhir/imagingselection-3dgraphictype";
                }
                case POLYLINE: {
                    return "http://hl7.org/fhir/imagingselection-3dgraphictype";
                }
                case POLYGON: {
                    return "http://hl7.org/fhir/imagingselection-3dgraphictype";
                }
                case ELLIPSE: {
                    return "http://hl7.org/fhir/imagingselection-3dgraphictype";
                }
                case ELLIPSOID: {
                    return "http://hl7.org/fhir/imagingselection-3dgraphictype";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case POINT: {
                    return "A single location denoted by a single (x,y,z) triplet.";
                }
                case MULTIPOINT: {
                    return "multiple locations each denoted by an (x,y,z) triplet; the points need not be coplanar.";
                }
                case POLYLINE: {
                    return "a series of connected line segments with ordered vertices denoted by (x,y,z) triplets; the points need not be coplanar.";
                }
                case POLYGON: {
                    return "a series of connected line segments with ordered vertices denoted by (x,y,z) triplets, where the first and last vertices shall be the same forming a polygon; the points shall be coplanar.";
                }
                case ELLIPSE: {
                    return "an ellipse defined by four (x,y,z) triplets, the first two triplets specifying the endpoints of the major axis and the second two triplets specifying the endpoints of the minor axis.";
                }
                case ELLIPSOID: {
                    return "a three-dimensional geometric surface whose plane sections are either ellipses or circles and contains three intersecting orthogonal axes, \"a\", \"b\", and \"c\"; the ellipsoid is defined by six (x,y,z) triplets, the first and second triplets specifying the endpoints of axis \"a\", the third and fourth triplets specifying the endpoints of axis \"b\", and the fifth and sixth triplets specifying the endpoints of axis \"c\".";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case POINT: {
                    return "POINT";
                }
                case MULTIPOINT: {
                    return "MULTIPOINT";
                }
                case POLYLINE: {
                    return "POLYLINE";
                }
                case POLYGON: {
                    return "POLYGON";
                }
                case ELLIPSE: {
                    return "ELLIPSE";
                }
                case ELLIPSOID: {
                    return "ELLIPSOID";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ImagingSelection2DGraphicTypeEnumFactory
    implements EnumFactory<ImagingSelection2DGraphicType> {
        @Override
        public ImagingSelection2DGraphicType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("point".equals(codeString)) {
                return ImagingSelection2DGraphicType.POINT;
            }
            if ("polyline".equals(codeString)) {
                return ImagingSelection2DGraphicType.POLYLINE;
            }
            if ("interpolated".equals(codeString)) {
                return ImagingSelection2DGraphicType.INTERPOLATED;
            }
            if ("circle".equals(codeString)) {
                return ImagingSelection2DGraphicType.CIRCLE;
            }
            if ("ellipse".equals(codeString)) {
                return ImagingSelection2DGraphicType.ELLIPSE;
            }
            throw new IllegalArgumentException("Unknown ImagingSelection2DGraphicType code '" + codeString + "'");
        }

        public Enumeration<ImagingSelection2DGraphicType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ImagingSelection2DGraphicType>(this, ImagingSelection2DGraphicType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ImagingSelection2DGraphicType>(this, ImagingSelection2DGraphicType.NULL, code);
            }
            if ("point".equals(codeString)) {
                return new Enumeration<ImagingSelection2DGraphicType>(this, ImagingSelection2DGraphicType.POINT, code);
            }
            if ("polyline".equals(codeString)) {
                return new Enumeration<ImagingSelection2DGraphicType>(this, ImagingSelection2DGraphicType.POLYLINE, code);
            }
            if ("interpolated".equals(codeString)) {
                return new Enumeration<ImagingSelection2DGraphicType>(this, ImagingSelection2DGraphicType.INTERPOLATED, code);
            }
            if ("circle".equals(codeString)) {
                return new Enumeration<ImagingSelection2DGraphicType>(this, ImagingSelection2DGraphicType.CIRCLE, code);
            }
            if ("ellipse".equals(codeString)) {
                return new Enumeration<ImagingSelection2DGraphicType>(this, ImagingSelection2DGraphicType.ELLIPSE, code);
            }
            throw new FHIRException("Unknown ImagingSelection2DGraphicType code '" + codeString + "'");
        }

        @Override
        public String toCode(ImagingSelection2DGraphicType code) {
            if (code == ImagingSelection2DGraphicType.NULL) {
                return null;
            }
            if (code == ImagingSelection2DGraphicType.POINT) {
                return "point";
            }
            if (code == ImagingSelection2DGraphicType.POLYLINE) {
                return "polyline";
            }
            if (code == ImagingSelection2DGraphicType.INTERPOLATED) {
                return "interpolated";
            }
            if (code == ImagingSelection2DGraphicType.CIRCLE) {
                return "circle";
            }
            if (code == ImagingSelection2DGraphicType.ELLIPSE) {
                return "ellipse";
            }
            return "?";
        }

        @Override
        public String toSystem(ImagingSelection2DGraphicType code) {
            return code.getSystem();
        }
    }

    public static enum ImagingSelection2DGraphicType {
        POINT,
        POLYLINE,
        INTERPOLATED,
        CIRCLE,
        ELLIPSE,
        NULL;


        public static ImagingSelection2DGraphicType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("point".equals(codeString)) {
                return POINT;
            }
            if ("polyline".equals(codeString)) {
                return POLYLINE;
            }
            if ("interpolated".equals(codeString)) {
                return INTERPOLATED;
            }
            if ("circle".equals(codeString)) {
                return CIRCLE;
            }
            if ("ellipse".equals(codeString)) {
                return ELLIPSE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ImagingSelection2DGraphicType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case POINT: {
                    return "point";
                }
                case POLYLINE: {
                    return "polyline";
                }
                case INTERPOLATED: {
                    return "interpolated";
                }
                case CIRCLE: {
                    return "circle";
                }
                case ELLIPSE: {
                    return "ellipse";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case POINT: {
                    return "http://hl7.org/fhir/imagingselection-2dgraphictype";
                }
                case POLYLINE: {
                    return "http://hl7.org/fhir/imagingselection-2dgraphictype";
                }
                case INTERPOLATED: {
                    return "http://hl7.org/fhir/imagingselection-2dgraphictype";
                }
                case CIRCLE: {
                    return "http://hl7.org/fhir/imagingselection-2dgraphictype";
                }
                case ELLIPSE: {
                    return "http://hl7.org/fhir/imagingselection-2dgraphictype";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case POINT: {
                    return "A single location denoted by a single (x,y) pair.";
                }
                case POLYLINE: {
                    return "A series of connected line segments with ordered vertices denoted by (x,y) triplets; the points need not be coplanar.";
                }
                case INTERPOLATED: {
                    return "An n-tuple list of (x,y) pair end points between which some form of implementation dependent curved lines are to be drawn. The rendered line shall pass through all the specified points.";
                }
                case CIRCLE: {
                    return "Two points shall be present; the first point is to be interpreted as the center and the second point as a point on the circumference of a circle, some form of implementation dependent representation of which is to be drawn.";
                }
                case ELLIPSE: {
                    return "An ellipse defined by four (x,y) pairs, the first two pairs specifying the endpoints of the major axis and the second two pairs specifying the endpoints of the minor axis.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case POINT: {
                    return "POINT";
                }
                case POLYLINE: {
                    return "POLYLINE";
                }
                case INTERPOLATED: {
                    return "INTERPOLATED";
                }
                case CIRCLE: {
                    return "CIRCLE";
                }
                case ELLIPSE: {
                    return "ELLIPSE";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

