/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PackagedProductDefinition", profile="http://hl7.org/fhir/StructureDefinition/PackagedProductDefinition")
public class PackagedProductDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A unique identifier for this package as whole - not for the content of the package", formalDefinition="A unique identifier for this package as whole - not the the content of the package. Unique instance identifiers assigned to a package by manufacturers, regulators, drug catalogue custodians or other organizations.")
    protected List<Identifier> identifier;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A name for this package. Typically as listed in a drug formulary, catalogue, inventory etc", formalDefinition="A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc.")
    protected StringType name;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A high level category e.g. medicinal product, raw material, shipping container etc", formalDefinition="A high level category e.g. medicinal product, raw material, shipping/transport container, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/package-type")
    protected CodeableConcept type;
    @Child(name="packageFor", type={MedicinalProductDefinition.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product that this is a pack for", formalDefinition="The product this package model relates to, not the contents of the package (for which see package.containedItem).")
    protected List<Reference> packageFor;
    @Child(name="status", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="The status within the lifecycle of this item. High level - not intended to duplicate details elsewhere e.g. legal status, or authorization/marketing status", formalDefinition="The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected CodeableConcept status;
    @Child(name="statusDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date at which the given status became applicable", formalDefinition="The date at which the given status became applicable.")
    protected DateTimeType statusDate;
    @Child(name="containedItemQuantity", type={Quantity.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A total of the complete count of contained items of a particular type/form, independent of sub-packaging or organization. This can be considered as the pack size. See also packaging.containedItem.amount (especially the long definition)", formalDefinition="A total of the complete count of contained items of a particular type/form, independent of sub-packaging or organization. This can be considered as the pack size. This attribute differs from containedItem.amount in that it can give a single aggregated count of all tablet types in a pack, even when these are different manufactured items. For example a pill pack of 21 tablets plus 7 sugar tablets, can be denoted here as '28 tablets'. This attribute is repeatable so that the different item types in one pack type can be counted (e.g. a count of vials and count of syringes). Each repeat must have different units, so that it is clear what the different sets of counted items are, and it is not intended to allow different counts of similar items (e.g. not '2 tubes and 3 tubes'). Repeats are not to be used to represent different pack sizes (e.g. 20 pack vs. 50 pack) - which would be different instances of this resource.")
    protected List<Quantity> containedItemQuantity;
    @Child(name="description", type={MarkdownType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description. Note that this is not the name of the package or product", formalDefinition="Textual description. Note that this is not the name of the package or product.")
    protected MarkdownType description;
    @Child(name="legalStatusOfSupply", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The legal status of supply of the packaged item as classified by the regulator", formalDefinition="The legal status of supply of the packaged item as classified by the regulator.")
    protected List<PackagedProductDefinitionLegalStatusOfSupplyComponent> legalStatusOfSupply;
    @Child(name="marketingStatus", type={MarketingStatus.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows specifying that an item is on the market for sale, or that it is not available, and the dates and locations associated", formalDefinition="Allows specifying that an item is on the market for sale, or that it is not available, and the dates and locations associated.")
    protected List<MarketingStatus> marketingStatus;
    @Child(name="copackagedIndicator", type={BooleanType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies if the drug product is supplied with another item such as a diluent or adjuvant", formalDefinition="Identifies if the package contains different items, such as when a drug product is supplied with another item e.g. a diluent or adjuvant.")
    protected BooleanType copackagedIndicator;
    @Child(name="manufacturer", type={Organization.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of this package type (multiple means these are all possible manufacturers)", formalDefinition="Manufacturer of this package type. When there are multiple it means these are all possible manufacturers.")
    protected List<Reference> manufacturer;
    @Child(name="attachedDocument", type={DocumentReference.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional information or supporting documentation about the packaged product", formalDefinition="Additional information or supporting documentation about the packaged product.")
    protected List<Reference> attachedDocument;
    @Child(name="packaging", type={}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A packaging item, as a container for medically related items, possibly with other packaging items within, or a packaging component, such as bottle cap", formalDefinition="A packaging item, as a container for medically related items, possibly with other packaging items within, or a packaging component, such as bottle cap (which is not a device or a medication manufactured item).")
    protected PackagedProductDefinitionPackagingComponent packaging;
    @Child(name="characteristic", type={PackagedProductDefinitionPackagingPropertyComponent.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows the key features to be recorded, such as \"hospital pack\", \"nurse prescribable\"", formalDefinition="Allows the key features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".")
    protected List<PackagedProductDefinitionPackagingPropertyComponent> characteristic;
    private static final long serialVersionUID = -1670129447L;
    @SearchParamDefinition(name="biological", path="PackagedProductDefinition.packaging.containedItem.item.reference", description="A biologically derived product within this packaged product", type="reference", target={BiologicallyDerivedProduct.class, DeviceDefinition.class, ManufacturedItemDefinition.class, NutritionProduct.class, PackagedProductDefinition.class})
    public static final String SP_BIOLOGICAL = "biological";
    public static final ReferenceClientParam BIOLOGICAL = new ReferenceClientParam("biological");
    public static final Include INCLUDE_BIOLOGICAL = new Include("PackagedProductDefinition:biological").toLocked();
    @SearchParamDefinition(name="contained-item", path="PackagedProductDefinition.packaging.containedItem.item.reference", description="Any of the contained items within this packaged product", type="reference", target={BiologicallyDerivedProduct.class, DeviceDefinition.class, ManufacturedItemDefinition.class, NutritionProduct.class, PackagedProductDefinition.class})
    public static final String SP_CONTAINED_ITEM = "contained-item";
    public static final ReferenceClientParam CONTAINED_ITEM = new ReferenceClientParam("contained-item");
    public static final Include INCLUDE_CONTAINED_ITEM = new Include("PackagedProductDefinition:contained-item").toLocked();
    @SearchParamDefinition(name="device", path="PackagedProductDefinition.packaging.containedItem.item.reference", description="A device within this packaged product", type="reference", target={BiologicallyDerivedProduct.class, DeviceDefinition.class, ManufacturedItemDefinition.class, NutritionProduct.class, PackagedProductDefinition.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("PackagedProductDefinition:device").toLocked();
    @SearchParamDefinition(name="identifier", path="PackagedProductDefinition.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="manufactured-item", path="PackagedProductDefinition.packaging.containedItem.item.reference", description="A manufactured item of medication within this packaged product", type="reference", target={BiologicallyDerivedProduct.class, DeviceDefinition.class, ManufacturedItemDefinition.class, NutritionProduct.class, PackagedProductDefinition.class})
    public static final String SP_MANUFACTURED_ITEM = "manufactured-item";
    public static final ReferenceClientParam MANUFACTURED_ITEM = new ReferenceClientParam("manufactured-item");
    public static final Include INCLUDE_MANUFACTURED_ITEM = new Include("PackagedProductDefinition:manufactured-item").toLocked();
    @SearchParamDefinition(name="medication", path="PackagedProductDefinition.packaging.containedItem.item.reference", description="A manufactured item of medication within this packaged product", type="reference", target={BiologicallyDerivedProduct.class, DeviceDefinition.class, ManufacturedItemDefinition.class, NutritionProduct.class, PackagedProductDefinition.class})
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("PackagedProductDefinition:medication").toLocked();
    @SearchParamDefinition(name="name", path="PackagedProductDefinition.name", description="A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc.", type="token")
    public static final String SP_NAME = "name";
    public static final TokenClientParam NAME = new TokenClientParam("name");
    @SearchParamDefinition(name="nutrition", path="PackagedProductDefinition.packaging.containedItem.item.reference", description="A nutrition product within this packaged product", type="reference", target={BiologicallyDerivedProduct.class, DeviceDefinition.class, ManufacturedItemDefinition.class, NutritionProduct.class, PackagedProductDefinition.class})
    public static final String SP_NUTRITION = "nutrition";
    public static final ReferenceClientParam NUTRITION = new ReferenceClientParam("nutrition");
    public static final Include INCLUDE_NUTRITION = new Include("PackagedProductDefinition:nutrition").toLocked();
    @SearchParamDefinition(name="package-for", path="PackagedProductDefinition.packageFor", description="The product that this is a pack for", type="reference", target={MedicinalProductDefinition.class})
    public static final String SP_PACKAGE_FOR = "package-for";
    public static final ReferenceClientParam PACKAGE_FOR = new ReferenceClientParam("package-for");
    public static final Include INCLUDE_PACKAGE_FOR = new Include("PackagedProductDefinition:package-for").toLocked();
    @SearchParamDefinition(name="package", path="PackagedProductDefinition.packaging.containedItem.item.reference", description="A complete packaged product within this packaged product", type="reference", target={BiologicallyDerivedProduct.class, DeviceDefinition.class, ManufacturedItemDefinition.class, NutritionProduct.class, PackagedProductDefinition.class})
    public static final String SP_PACKAGE = "package";
    public static final ReferenceClientParam PACKAGE = new ReferenceClientParam("package");
    public static final Include INCLUDE_PACKAGE = new Include("PackagedProductDefinition:package").toLocked();
    @SearchParamDefinition(name="status", path="PackagedProductDefinition.status", description="The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PackagedProductDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PackagedProductDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public PackagedProductDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public PackagedProductDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public PackagedProductDefinition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<Reference> getPackageFor() {
        if (this.packageFor == null) {
            this.packageFor = new ArrayList<Reference>();
        }
        return this.packageFor;
    }

    public PackagedProductDefinition setPackageFor(List<Reference> thePackageFor) {
        this.packageFor = thePackageFor;
        return this;
    }

    public boolean hasPackageFor() {
        if (this.packageFor == null) {
            return false;
        }
        for (Reference item : this.packageFor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPackageFor() {
        Reference t = new Reference();
        if (this.packageFor == null) {
            this.packageFor = new ArrayList<Reference>();
        }
        this.packageFor.add(t);
        return t;
    }

    public PackagedProductDefinition addPackageFor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.packageFor == null) {
            this.packageFor = new ArrayList<Reference>();
        }
        this.packageFor.add(t);
        return this;
    }

    public Reference getPackageForFirstRep() {
        if (this.getPackageFor().isEmpty()) {
            this.addPackageFor();
        }
        return this.getPackageFor().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public PackagedProductDefinition setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public DateTimeType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateTimeType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public PackagedProductDefinition setStatusDateElement(DateTimeType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public PackagedProductDefinition setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateTimeType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public List<Quantity> getContainedItemQuantity() {
        if (this.containedItemQuantity == null) {
            this.containedItemQuantity = new ArrayList<Quantity>();
        }
        return this.containedItemQuantity;
    }

    public PackagedProductDefinition setContainedItemQuantity(List<Quantity> theContainedItemQuantity) {
        this.containedItemQuantity = theContainedItemQuantity;
        return this;
    }

    public boolean hasContainedItemQuantity() {
        if (this.containedItemQuantity == null) {
            return false;
        }
        for (Quantity item : this.containedItemQuantity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Quantity addContainedItemQuantity() {
        Quantity t = new Quantity();
        if (this.containedItemQuantity == null) {
            this.containedItemQuantity = new ArrayList<Quantity>();
        }
        this.containedItemQuantity.add(t);
        return t;
    }

    public PackagedProductDefinition addContainedItemQuantity(Quantity t) {
        if (t == null) {
            return this;
        }
        if (this.containedItemQuantity == null) {
            this.containedItemQuantity = new ArrayList<Quantity>();
        }
        this.containedItemQuantity.add(t);
        return this;
    }

    public Quantity getContainedItemQuantityFirstRep() {
        if (this.getContainedItemQuantity().isEmpty()) {
            this.addContainedItemQuantity();
        }
        return this.getContainedItemQuantity().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public PackagedProductDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public PackagedProductDefinition setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<PackagedProductDefinitionLegalStatusOfSupplyComponent> getLegalStatusOfSupply() {
        if (this.legalStatusOfSupply == null) {
            this.legalStatusOfSupply = new ArrayList<PackagedProductDefinitionLegalStatusOfSupplyComponent>();
        }
        return this.legalStatusOfSupply;
    }

    public PackagedProductDefinition setLegalStatusOfSupply(List<PackagedProductDefinitionLegalStatusOfSupplyComponent> theLegalStatusOfSupply) {
        this.legalStatusOfSupply = theLegalStatusOfSupply;
        return this;
    }

    public boolean hasLegalStatusOfSupply() {
        if (this.legalStatusOfSupply == null) {
            return false;
        }
        for (PackagedProductDefinitionLegalStatusOfSupplyComponent item : this.legalStatusOfSupply) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PackagedProductDefinitionLegalStatusOfSupplyComponent addLegalStatusOfSupply() {
        PackagedProductDefinitionLegalStatusOfSupplyComponent t = new PackagedProductDefinitionLegalStatusOfSupplyComponent();
        if (this.legalStatusOfSupply == null) {
            this.legalStatusOfSupply = new ArrayList<PackagedProductDefinitionLegalStatusOfSupplyComponent>();
        }
        this.legalStatusOfSupply.add(t);
        return t;
    }

    public PackagedProductDefinition addLegalStatusOfSupply(PackagedProductDefinitionLegalStatusOfSupplyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.legalStatusOfSupply == null) {
            this.legalStatusOfSupply = new ArrayList<PackagedProductDefinitionLegalStatusOfSupplyComponent>();
        }
        this.legalStatusOfSupply.add(t);
        return this;
    }

    public PackagedProductDefinitionLegalStatusOfSupplyComponent getLegalStatusOfSupplyFirstRep() {
        if (this.getLegalStatusOfSupply().isEmpty()) {
            this.addLegalStatusOfSupply();
        }
        return this.getLegalStatusOfSupply().get(0);
    }

    public List<MarketingStatus> getMarketingStatus() {
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        return this.marketingStatus;
    }

    public PackagedProductDefinition setMarketingStatus(List<MarketingStatus> theMarketingStatus) {
        this.marketingStatus = theMarketingStatus;
        return this;
    }

    public boolean hasMarketingStatus() {
        if (this.marketingStatus == null) {
            return false;
        }
        for (MarketingStatus item : this.marketingStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarketingStatus addMarketingStatus() {
        MarketingStatus t = new MarketingStatus();
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return t;
    }

    public PackagedProductDefinition addMarketingStatus(MarketingStatus t) {
        if (t == null) {
            return this;
        }
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return this;
    }

    public MarketingStatus getMarketingStatusFirstRep() {
        if (this.getMarketingStatus().isEmpty()) {
            this.addMarketingStatus();
        }
        return this.getMarketingStatus().get(0);
    }

    public BooleanType getCopackagedIndicatorElement() {
        if (this.copackagedIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.copackagedIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.copackagedIndicator = new BooleanType();
            }
        }
        return this.copackagedIndicator;
    }

    public boolean hasCopackagedIndicatorElement() {
        return this.copackagedIndicator != null && !this.copackagedIndicator.isEmpty();
    }

    public boolean hasCopackagedIndicator() {
        return this.copackagedIndicator != null && !this.copackagedIndicator.isEmpty();
    }

    public PackagedProductDefinition setCopackagedIndicatorElement(BooleanType value) {
        this.copackagedIndicator = value;
        return this;
    }

    public boolean getCopackagedIndicator() {
        return this.copackagedIndicator == null || this.copackagedIndicator.isEmpty() ? false : (Boolean)this.copackagedIndicator.getValue();
    }

    public PackagedProductDefinition setCopackagedIndicator(boolean value) {
        if (this.copackagedIndicator == null) {
            this.copackagedIndicator = new BooleanType();
        }
        this.copackagedIndicator.setValue((Object)value);
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public PackagedProductDefinition setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public PackagedProductDefinition addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<Reference> getAttachedDocument() {
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        return this.attachedDocument;
    }

    public PackagedProductDefinition setAttachedDocument(List<Reference> theAttachedDocument) {
        this.attachedDocument = theAttachedDocument;
        return this;
    }

    public boolean hasAttachedDocument() {
        if (this.attachedDocument == null) {
            return false;
        }
        for (Reference item : this.attachedDocument) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAttachedDocument() {
        Reference t = new Reference();
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return t;
    }

    public PackagedProductDefinition addAttachedDocument(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return this;
    }

    public Reference getAttachedDocumentFirstRep() {
        if (this.getAttachedDocument().isEmpty()) {
            this.addAttachedDocument();
        }
        return this.getAttachedDocument().get(0);
    }

    public PackagedProductDefinitionPackagingComponent getPackaging() {
        if (this.packaging == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PackagedProductDefinition.packaging");
            }
            if (Configuration.doAutoCreate()) {
                this.packaging = new PackagedProductDefinitionPackagingComponent();
            }
        }
        return this.packaging;
    }

    public boolean hasPackaging() {
        return this.packaging != null && !this.packaging.isEmpty();
    }

    public PackagedProductDefinition setPackaging(PackagedProductDefinitionPackagingComponent value) {
        this.packaging = value;
        return this;
    }

    public List<PackagedProductDefinitionPackagingPropertyComponent> getCharacteristic() {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<PackagedProductDefinitionPackagingPropertyComponent>();
        }
        return this.characteristic;
    }

    public PackagedProductDefinition setCharacteristic(List<PackagedProductDefinitionPackagingPropertyComponent> theCharacteristic) {
        this.characteristic = theCharacteristic;
        return this;
    }

    public boolean hasCharacteristic() {
        if (this.characteristic == null) {
            return false;
        }
        for (PackagedProductDefinitionPackagingPropertyComponent item : this.characteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PackagedProductDefinitionPackagingPropertyComponent addCharacteristic() {
        PackagedProductDefinitionPackagingPropertyComponent t = new PackagedProductDefinitionPackagingPropertyComponent();
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<PackagedProductDefinitionPackagingPropertyComponent>();
        }
        this.characteristic.add(t);
        return t;
    }

    public PackagedProductDefinition addCharacteristic(PackagedProductDefinitionPackagingPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<PackagedProductDefinitionPackagingPropertyComponent>();
        }
        this.characteristic.add(t);
        return this;
    }

    public PackagedProductDefinitionPackagingPropertyComponent getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier for this package as whole - not the the content of the package. Unique instance identifiers assigned to a package by manufacturers, regulators, drug catalogue custodians or other organizations.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_NAME, "string", "A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc.", 0, 1, this.name));
        children.add(new Property("type", "CodeableConcept", "A high level category e.g. medicinal product, raw material, shipping/transport container, etc.", 0, 1, this.type));
        children.add(new Property("packageFor", "Reference(MedicinalProductDefinition)", "The product this package model relates to, not the contents of the package (for which see package.containedItem).", 0, Integer.MAX_VALUE, this.packageFor));
        children.add(new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status.", 0, 1, this.status));
        children.add(new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate));
        children.add(new Property("containedItemQuantity", "Quantity", "A total of the complete count of contained items of a particular type/form, independent of sub-packaging or organization. This can be considered as the pack size. This attribute differs from containedItem.amount in that it can give a single aggregated count of all tablet types in a pack, even when these are different manufactured items. For example a pill pack of 21 tablets plus 7 sugar tablets, can be denoted here as '28 tablets'. This attribute is repeatable so that the different item types in one pack type can be counted (e.g. a count of vials and count of syringes). Each repeat must have different units, so that it is clear what the different sets of counted items are, and it is not intended to allow different counts of similar items (e.g. not '2 tubes and 3 tubes'). Repeats are not to be used to represent different pack sizes (e.g. 20 pack vs. 50 pack) - which would be different instances of this resource.", 0, Integer.MAX_VALUE, this.containedItemQuantity));
        children.add(new Property("description", "markdown", "Textual description. Note that this is not the name of the package or product.", 0, 1, this.description));
        children.add(new Property("legalStatusOfSupply", "", "The legal status of supply of the packaged item as classified by the regulator.", 0, Integer.MAX_VALUE, this.legalStatusOfSupply));
        children.add(new Property("marketingStatus", "MarketingStatus", "Allows specifying that an item is on the market for sale, or that it is not available, and the dates and locations associated.", 0, Integer.MAX_VALUE, this.marketingStatus));
        children.add(new Property("copackagedIndicator", "boolean", "Identifies if the package contains different items, such as when a drug product is supplied with another item e.g. a diluent or adjuvant.", 0, 1, this.copackagedIndicator));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this package type. When there are multiple it means these are all possible manufacturers.", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property("attachedDocument", "Reference(DocumentReference)", "Additional information or supporting documentation about the packaged product.", 0, Integer.MAX_VALUE, this.attachedDocument));
        children.add(new Property("packaging", "", "A packaging item, as a container for medically related items, possibly with other packaging items within, or a packaging component, such as bottle cap (which is not a device or a medication manufactured item).", 0, 1, this.packaging));
        children.add(new Property("characteristic", "@PackagedProductDefinition.packaging.property", "Allows the key features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".", 0, Integer.MAX_VALUE, this.characteristic));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier for this package as whole - not the the content of the package. Unique instance identifiers assigned to a package by manufacturers, regulators, drug catalogue custodians or other organizations.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A name for this package. Typically what it would be listed as in a drug formulary or catalogue, inventory etc.", 0, 1, this.name);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "A high level category e.g. medicinal product, raw material, shipping/transport container, etc.", 0, 1, this.type);
            }
            case 29307555: {
                return new Property("packageFor", "Reference(MedicinalProductDefinition)", "The product this package model relates to, not the contents of the package (for which see package.containedItem).", 0, Integer.MAX_VALUE, this.packageFor);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "The status within the lifecycle of this item. A high level status, this is not intended to duplicate details carried elsewhere such as legal status, or authorization or marketing status.", 0, 1, this.status);
            }
            case 247524032: {
                return new Property("statusDate", "dateTime", "The date at which the given status became applicable.", 0, 1, this.statusDate);
            }
            case -1686893359: {
                return new Property("containedItemQuantity", "Quantity", "A total of the complete count of contained items of a particular type/form, independent of sub-packaging or organization. This can be considered as the pack size. This attribute differs from containedItem.amount in that it can give a single aggregated count of all tablet types in a pack, even when these are different manufactured items. For example a pill pack of 21 tablets plus 7 sugar tablets, can be denoted here as '28 tablets'. This attribute is repeatable so that the different item types in one pack type can be counted (e.g. a count of vials and count of syringes). Each repeat must have different units, so that it is clear what the different sets of counted items are, and it is not intended to allow different counts of similar items (e.g. not '2 tubes and 3 tubes'). Repeats are not to be used to represent different pack sizes (e.g. 20 pack vs. 50 pack) - which would be different instances of this resource.", 0, Integer.MAX_VALUE, this.containedItemQuantity);
            }
            case -1724546052: {
                return new Property("description", "markdown", "Textual description. Note that this is not the name of the package or product.", 0, 1, this.description);
            }
            case -844874031: {
                return new Property("legalStatusOfSupply", "", "The legal status of supply of the packaged item as classified by the regulator.", 0, Integer.MAX_VALUE, this.legalStatusOfSupply);
            }
            case 70767032: {
                return new Property("marketingStatus", "MarketingStatus", "Allows specifying that an item is on the market for sale, or that it is not available, and the dates and locations associated.", 0, Integer.MAX_VALUE, this.marketingStatus);
            }
            case -1638663195: {
                return new Property("copackagedIndicator", "boolean", "Identifies if the package contains different items, such as when a drug product is supplied with another item e.g. a diluent or adjuvant.", 0, 1, this.copackagedIndicator);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this package type. When there are multiple it means these are all possible manufacturers.", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -513945889: {
                return new Property("attachedDocument", "Reference(DocumentReference)", "Additional information or supporting documentation about the packaged product.", 0, Integer.MAX_VALUE, this.attachedDocument);
            }
            case 1802065795: {
                return new Property("packaging", "", "A packaging item, as a container for medically related items, possibly with other packaging items within, or a packaging component, such as bottle cap (which is not a device or a medication manufactured item).", 0, 1, this.packaging);
            }
            case 366313883: {
                return new Property("characteristic", "@PackagedProductDefinition.packaging.property", "Allows the key features to be recorded, such as \"hospital pack\", \"nurse prescribable\", \"calendar pack\".", 0, Integer.MAX_VALUE, this.characteristic);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 29307555: {
                return this.packageFor == null ? new Base[]{} : this.packageFor.toArray(new Base[this.packageFor.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.statusDate;
                }
                return baseArray;
            }
            case -1686893359: {
                return this.containedItemQuantity == null ? new Base[]{} : this.containedItemQuantity.toArray(new Base[this.containedItemQuantity.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case -844874031: {
                return this.legalStatusOfSupply == null ? new Base[]{} : this.legalStatusOfSupply.toArray(new Base[this.legalStatusOfSupply.size()]);
            }
            case 70767032: {
                return this.marketingStatus == null ? new Base[]{} : this.marketingStatus.toArray(new Base[this.marketingStatus.size()]);
            }
            case -1638663195: {
                Base[] baseArray;
                if (this.copackagedIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.copackagedIndicator;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -513945889: {
                return this.attachedDocument == null ? new Base[]{} : this.attachedDocument.toArray(new Base[this.attachedDocument.size()]);
            }
            case 1802065795: {
                Base[] baseArray;
                if (this.packaging == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.packaging;
                }
                return baseArray;
            }
            case 366313883: {
                return this.characteristic == null ? new Base[]{} : this.characteristic.toArray(new Base[this.characteristic.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 29307555: {
                this.getPackageFor().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 247524032: {
                this.statusDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1686893359: {
                this.getContainedItemQuantity().add(TypeConvertor.castToQuantity(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -844874031: {
                this.getLegalStatusOfSupply().add((PackagedProductDefinitionLegalStatusOfSupplyComponent)value);
                return value;
            }
            case 70767032: {
                this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
                return value;
            }
            case -1638663195: {
                this.copackagedIndicator = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -513945889: {
                this.getAttachedDocument().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1802065795: {
                this.packaging = (PackagedProductDefinitionPackagingComponent)value;
                return value;
            }
            case 366313883: {
                this.getCharacteristic().add((PackagedProductDefinitionPackagingPropertyComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("packageFor")) {
            this.getPackageFor().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("containedItemQuantity")) {
            this.getContainedItemQuantity().add(TypeConvertor.castToQuantity(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("legalStatusOfSupply")) {
            this.getLegalStatusOfSupply().add((PackagedProductDefinitionLegalStatusOfSupplyComponent)value);
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().add(TypeConvertor.castToMarketingStatus(value));
        } else if (name.equals("copackagedIndicator")) {
            this.copackagedIndicator = TypeConvertor.castToBoolean(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals("attachedDocument")) {
            this.getAttachedDocument().add(TypeConvertor.castToReference(value));
        } else if (name.equals("packaging")) {
            this.packaging = (PackagedProductDefinitionPackagingComponent)value;
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().add((PackagedProductDefinitionPackagingPropertyComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals("type")) {
            this.type = null;
        } else if (name.equals("packageFor")) {
            this.getPackageFor().remove(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("statusDate")) {
            this.statusDate = null;
        } else if (name.equals("containedItemQuantity")) {
            this.getContainedItemQuantity().remove(value);
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("legalStatusOfSupply")) {
            this.getLegalStatusOfSupply().remove((PackagedProductDefinitionLegalStatusOfSupplyComponent)value);
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().remove(value);
        } else if (name.equals("copackagedIndicator")) {
            this.copackagedIndicator = null;
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().remove(value);
        } else if (name.equals("attachedDocument")) {
            this.getAttachedDocument().remove(value);
        } else if (name.equals("packaging")) {
            this.packaging = (PackagedProductDefinitionPackagingComponent)value;
        } else if (name.equals("characteristic")) {
            this.getCharacteristic().remove((PackagedProductDefinitionPackagingPropertyComponent)value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 29307555: {
                return this.addPackageFor();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case -1686893359: {
                return this.addContainedItemQuantity();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -844874031: {
                return this.addLegalStatusOfSupply();
            }
            case 70767032: {
                return this.addMarketingStatus();
            }
            case -1638663195: {
                return this.getCopackagedIndicatorElement();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -513945889: {
                return this.addAttachedDocument();
            }
            case 1802065795: {
                return this.getPackaging();
            }
            case 366313883: {
                return this.addCharacteristic();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 29307555: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[]{"dateTime"};
            }
            case -1686893359: {
                return new String[]{"Quantity"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -844874031: {
                return new String[0];
            }
            case 70767032: {
                return new String[]{"MarketingStatus"};
            }
            case -1638663195: {
                return new String[]{"boolean"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -513945889: {
                return new String[]{"Reference"};
            }
            case 1802065795: {
                return new String[0];
            }
            case 366313883: {
                return new String[]{"@PackagedProductDefinition.packaging.property"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property PackagedProductDefinition.name");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("packageFor")) {
            return this.addPackageFor();
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property PackagedProductDefinition.statusDate");
        }
        if (name.equals("containedItemQuantity")) {
            return this.addContainedItemQuantity();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property PackagedProductDefinition.description");
        }
        if (name.equals("legalStatusOfSupply")) {
            return this.addLegalStatusOfSupply();
        }
        if (name.equals("marketingStatus")) {
            return this.addMarketingStatus();
        }
        if (name.equals("copackagedIndicator")) {
            throw new FHIRException("Cannot call addChild on a singleton property PackagedProductDefinition.copackagedIndicator");
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals("attachedDocument")) {
            return this.addAttachedDocument();
        }
        if (name.equals("packaging")) {
            this.packaging = new PackagedProductDefinitionPackagingComponent();
            return this.packaging;
        }
        if (name.equals("characteristic")) {
            return this.addCharacteristic();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PackagedProductDefinition";
    }

    @Override
    public PackagedProductDefinition copy() {
        PackagedProductDefinition dst = new PackagedProductDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PackagedProductDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.packageFor != null) {
            dst.packageFor = new ArrayList<Reference>();
            for (Reference reference : this.packageFor) {
                dst.packageFor.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        DateTimeType dateTimeType = dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        if (this.containedItemQuantity != null) {
            dst.containedItemQuantity = new ArrayList<Quantity>();
            for (Quantity quantity : this.containedItemQuantity) {
                dst.containedItemQuantity.add(quantity.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.legalStatusOfSupply != null) {
            dst.legalStatusOfSupply = new ArrayList<PackagedProductDefinitionLegalStatusOfSupplyComponent>();
            for (PackagedProductDefinitionLegalStatusOfSupplyComponent packagedProductDefinitionLegalStatusOfSupplyComponent : this.legalStatusOfSupply) {
                dst.legalStatusOfSupply.add(packagedProductDefinitionLegalStatusOfSupplyComponent.copy());
            }
        }
        if (this.marketingStatus != null) {
            dst.marketingStatus = new ArrayList<MarketingStatus>();
            for (MarketingStatus marketingStatus : this.marketingStatus) {
                dst.marketingStatus.add(marketingStatus.copy());
            }
        }
        BooleanType booleanType = dst.copackagedIndicator = this.copackagedIndicator == null ? null : this.copackagedIndicator.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.attachedDocument != null) {
            dst.attachedDocument = new ArrayList<Reference>();
            for (Reference reference : this.attachedDocument) {
                dst.attachedDocument.add(reference.copy());
            }
        }
        PackagedProductDefinitionPackagingComponent packagedProductDefinitionPackagingComponent = dst.packaging = this.packaging == null ? null : this.packaging.copy();
        if (this.characteristic != null) {
            dst.characteristic = new ArrayList<PackagedProductDefinitionPackagingPropertyComponent>();
            for (PackagedProductDefinitionPackagingPropertyComponent packagedProductDefinitionPackagingPropertyComponent : this.characteristic) {
                dst.characteristic.add(packagedProductDefinitionPackagingPropertyComponent.copy());
            }
        }
    }

    protected PackagedProductDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PackagedProductDefinition)) {
            return false;
        }
        PackagedProductDefinition o = (PackagedProductDefinition)other_;
        return PackagedProductDefinition.compareDeep(this.identifier, o.identifier, true) && PackagedProductDefinition.compareDeep(this.name, o.name, true) && PackagedProductDefinition.compareDeep(this.type, o.type, true) && PackagedProductDefinition.compareDeep(this.packageFor, o.packageFor, true) && PackagedProductDefinition.compareDeep(this.status, o.status, true) && PackagedProductDefinition.compareDeep(this.statusDate, o.statusDate, true) && PackagedProductDefinition.compareDeep(this.containedItemQuantity, o.containedItemQuantity, true) && PackagedProductDefinition.compareDeep(this.description, o.description, true) && PackagedProductDefinition.compareDeep(this.legalStatusOfSupply, o.legalStatusOfSupply, true) && PackagedProductDefinition.compareDeep(this.marketingStatus, o.marketingStatus, true) && PackagedProductDefinition.compareDeep(this.copackagedIndicator, o.copackagedIndicator, true) && PackagedProductDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && PackagedProductDefinition.compareDeep(this.attachedDocument, o.attachedDocument, true) && PackagedProductDefinition.compareDeep(this.packaging, o.packaging, true) && PackagedProductDefinition.compareDeep(this.characteristic, o.characteristic, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PackagedProductDefinition)) {
            return false;
        }
        PackagedProductDefinition o = (PackagedProductDefinition)other_;
        return PackagedProductDefinition.compareValues(this.name, o.name, true) && PackagedProductDefinition.compareValues(this.statusDate, o.statusDate, true) && PackagedProductDefinition.compareValues(this.description, o.description, true) && PackagedProductDefinition.compareValues(this.copackagedIndicator, o.copackagedIndicator, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.name, this.type, this.packageFor, this.status, this.statusDate, this.containedItemQuantity, this.description, this.legalStatusOfSupply, this.marketingStatus, this.copackagedIndicator, this.manufacturer, this.attachedDocument, this.packaging, this.characteristic});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PackagedProductDefinition;
    }

    @Block
    public static class PackagedProductDefinitionPackagingContainedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual item(s) of medication, as manufactured, or a device, or other medically related item (food, biologicals, raw materials, medical fluids, gases etc.), as contained in the package", formalDefinition="The actual item(s) of medication, as manufactured, or a device (typically, but not necessarily, a co-packaged one), or other medically related item (such as food, biologicals, raw materials, medical fluids, gases etc.), as contained in the package. This also allows another whole packaged product to be included, which is solely for the case where a package of other entire packages is wanted - such as a wholesale or distribution pack (for layers within one package, use PackagedProductDefinition.packaging.packaging).")
        protected CodeableReference item;
        @Child(name="amount", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The number of this type of item within this packaging or for continuous items such as liquids it is the quantity (for example 25ml). See also PackagedProductDefinition.containedItemQuantity (especially the long definition)", formalDefinition="The number of this type of item within this packaging or for continuous items such as liquids it is the quantity (for example 25ml). See also PackagedProductDefinition.containedItemQuantity (especially the long definition).")
        protected Quantity amount;
        private static final long serialVersionUID = 443863028L;

        public PackagedProductDefinitionPackagingContainedItemComponent() {
        }

        public PackagedProductDefinitionPackagingContainedItemComponent(CodeableReference item) {
            this.setItem(item);
        }

        public CodeableReference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackagingContainedItemComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableReference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public PackagedProductDefinitionPackagingContainedItemComponent setItem(CodeableReference value) {
            this.item = value;
            return this;
        }

        public Quantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackagingContainedItemComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Quantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PackagedProductDefinitionPackagingContainedItemComponent setAmount(Quantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item", "CodeableReference(ManufacturedItemDefinition|DeviceDefinition|PackagedProductDefinition|BiologicallyDerivedProduct|NutritionProduct)", "The actual item(s) of medication, as manufactured, or a device (typically, but not necessarily, a co-packaged one), or other medically related item (such as food, biologicals, raw materials, medical fluids, gases etc.), as contained in the package. This also allows another whole packaged product to be included, which is solely for the case where a package of other entire packages is wanted - such as a wholesale or distribution pack (for layers within one package, use PackagedProductDefinition.packaging.packaging).", 0, 1, this.item));
            children.add(new Property("amount", "Quantity", "The number of this type of item within this packaging or for continuous items such as liquids it is the quantity (for example 25ml). See also PackagedProductDefinition.containedItemQuantity (especially the long definition).", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3242771: {
                    return new Property("item", "CodeableReference(ManufacturedItemDefinition|DeviceDefinition|PackagedProductDefinition|BiologicallyDerivedProduct|NutritionProduct)", "The actual item(s) of medication, as manufactured, or a device (typically, but not necessarily, a co-packaged one), or other medically related item (such as food, biologicals, raw materials, medical fluids, gases etc.), as contained in the package. This also allows another whole packaged product to be included, which is solely for the case where a package of other entire packages is wanted - such as a wholesale or distribution pack (for layers within one package, use PackagedProductDefinition.packaging.packaging).", 0, 1, this.item);
                }
                case -1413853096: {
                    return new Property("amount", "Quantity", "The number of this type of item within this packaging or for continuous items such as liquids it is the quantity (for example 25ml). See also PackagedProductDefinition.containedItemQuantity (especially the long definition).", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("item")) {
                this.item = null;
            } else if (name.equals("amount")) {
                this.amount = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return this.getItem();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
                case -1413853096: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("item")) {
                this.item = new CodeableReference();
                return this.item;
            }
            if (name.equals("amount")) {
                this.amount = new Quantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackagingContainedItemComponent copy() {
            PackagedProductDefinitionPackagingContainedItemComponent dst = new PackagedProductDefinitionPackagingContainedItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackagingContainedItemComponent dst) {
            super.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagingContainedItemComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagingContainedItemComponent o = (PackagedProductDefinitionPackagingContainedItemComponent)other_;
            return PackagedProductDefinitionPackagingContainedItemComponent.compareDeep(this.item, o.item, true) && PackagedProductDefinitionPackagingContainedItemComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagingContainedItemComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagingContainedItemComponent o = (PackagedProductDefinitionPackagingContainedItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.amount});
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.packaging.containedItem";
        }
    }

    @Block
    public static class PackagedProductDefinitionPackagingPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code expressing the type of characteristic", formalDefinition="A code expressing the type of characteristic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/product-characteristic-codes")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, DateType.class, BooleanType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the characteristic", formalDefinition="A value for the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public PackagedProductDefinitionPackagingPropertyComponent() {
        }

        public PackagedProductDefinitionPackagingPropertyComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackagingPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PackagedProductDefinitionPackagingPropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public PackagedProductDefinitionPackagingPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof DateType || value instanceof BooleanType || value instanceof Attachment)) {
                throw new FHIRException("Not the right type for PackagedProductDefinition.packaging.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "A value for the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "date", "boolean", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackagingPropertyComponent copy() {
            PackagedProductDefinitionPackagingPropertyComponent dst = new PackagedProductDefinitionPackagingPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackagingPropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagingPropertyComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagingPropertyComponent o = (PackagedProductDefinitionPackagingPropertyComponent)other_;
            return PackagedProductDefinitionPackagingPropertyComponent.compareDeep(this.type, o.type, true) && PackagedProductDefinitionPackagingPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagingPropertyComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagingPropertyComponent o = (PackagedProductDefinitionPackagingPropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.packaging.property";
        }
    }

    @Block
    public static class PackagedProductDefinitionPackagingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="An identifier that is specific to this particular part of the packaging. Including possibly a Data Carrier Identifier", formalDefinition="A business identifier that is specific to this particular part of the packaging, often assigned by the manufacturer. Including possibly Data Carrier Identifier (a GS1 barcode).")
        protected List<Identifier> identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The physical type of the container of the items", formalDefinition="The physical type of the container of the items.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/packaging-type")
        protected CodeableConcept type;
        @Child(name="componentPart", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Is this a part of the packaging (e.g. a cap or bottle stopper), rather than the packaging itself (e.g. a bottle or vial)", formalDefinition="Is this a part of the packaging (e.g. a cap or bottle stopper), rather than the packaging itself (e.g. a bottle or vial). The latter type are designed be a container, but the former are not.")
        protected BooleanType componentPart;
        @Child(name="quantity", type={IntegerType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of this level of packaging in the package that contains it (with the outermost level being 1)", formalDefinition="The quantity of packaging items contained at this layer of the package. This does not relate to the number of contained items but relates solely to the number of packaging items. When looking at the outermost layer it is always 1. If there are two boxes within, at the next layer it would be 2.")
        protected IntegerType quantity;
        @Child(name="material", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Material type of the package item", formalDefinition="Material type of the package item.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/package-material")
        protected List<CodeableConcept> material;
        @Child(name="alternateMaterial", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A possible alternate material for this part of the packaging, that is allowed to be used instead of the usual material", formalDefinition="A possible alternate material for this part of the packaging, that is allowed to be used instead of the usual material (e.g. different types of plastic for a blister sleeve).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/package-material")
        protected List<CodeableConcept> alternateMaterial;
        @Child(name="shelfLifeStorage", type={ProductShelfLife.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Shelf Life and storage information", formalDefinition="Shelf Life and storage information.")
        protected List<ProductShelfLife> shelfLifeStorage;
        @Child(name="manufacturer", type={Organization.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Manufacturer of this packaging item (multiple means these are all potential manufacturers)", formalDefinition="Manufacturer of this packaging item. When there are multiple values each one is a potential manufacturer of this packaging item.")
        protected List<Reference> manufacturer;
        @Child(name="property", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="General characteristics of this item", formalDefinition="General characteristics of this item.")
        protected List<PackagedProductDefinitionPackagingPropertyComponent> property;
        @Child(name="containedItem", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The item(s) within the packaging", formalDefinition="The item(s) within the packaging.")
        protected List<PackagedProductDefinitionPackagingContainedItemComponent> containedItem;
        @Child(name="packaging", type={PackagedProductDefinitionPackagingComponent.class}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Allows containers (and parts of containers) within containers, still as a part of single packaged product", formalDefinition="Allows containers (and parts of containers) within containers, still as a part of a single packaged product. See also PackagedProductDefinition.packaging.containedItem.item(PackagedProductDefinition).")
        protected List<PackagedProductDefinitionPackagingComponent> packaging;
        private static final long serialVersionUID = 2121836225L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public PackagedProductDefinitionPackagingComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public PackagedProductDefinitionPackagingComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackagingComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PackagedProductDefinitionPackagingComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public BooleanType getComponentPartElement() {
            if (this.componentPart == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackagingComponent.componentPart");
                }
                if (Configuration.doAutoCreate()) {
                    this.componentPart = new BooleanType();
                }
            }
            return this.componentPart;
        }

        public boolean hasComponentPartElement() {
            return this.componentPart != null && !this.componentPart.isEmpty();
        }

        public boolean hasComponentPart() {
            return this.componentPart != null && !this.componentPart.isEmpty();
        }

        public PackagedProductDefinitionPackagingComponent setComponentPartElement(BooleanType value) {
            this.componentPart = value;
            return this;
        }

        public boolean getComponentPart() {
            return this.componentPart == null || this.componentPart.isEmpty() ? false : (Boolean)this.componentPart.getValue();
        }

        public PackagedProductDefinitionPackagingComponent setComponentPart(boolean value) {
            if (this.componentPart == null) {
                this.componentPart = new BooleanType();
            }
            this.componentPart.setValue((Object)value);
            return this;
        }

        public IntegerType getQuantityElement() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionPackagingComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new IntegerType();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantityElement() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public PackagedProductDefinitionPackagingComponent setQuantityElement(IntegerType value) {
            this.quantity = value;
            return this;
        }

        public int getQuantity() {
            return this.quantity == null || this.quantity.isEmpty() ? 0 : (Integer)this.quantity.getValue();
        }

        public PackagedProductDefinitionPackagingComponent setQuantity(int value) {
            if (this.quantity == null) {
                this.quantity = new IntegerType();
            }
            this.quantity.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getMaterial() {
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            return this.material;
        }

        public PackagedProductDefinitionPackagingComponent setMaterial(List<CodeableConcept> theMaterial) {
            this.material = theMaterial;
            return this;
        }

        public boolean hasMaterial() {
            if (this.material == null) {
                return false;
            }
            for (CodeableConcept item : this.material) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return t;
        }

        public PackagedProductDefinitionPackagingComponent addMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return this;
        }

        public CodeableConcept getMaterialFirstRep() {
            if (this.getMaterial().isEmpty()) {
                this.addMaterial();
            }
            return this.getMaterial().get(0);
        }

        public List<CodeableConcept> getAlternateMaterial() {
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            return this.alternateMaterial;
        }

        public PackagedProductDefinitionPackagingComponent setAlternateMaterial(List<CodeableConcept> theAlternateMaterial) {
            this.alternateMaterial = theAlternateMaterial;
            return this;
        }

        public boolean hasAlternateMaterial() {
            if (this.alternateMaterial == null) {
                return false;
            }
            for (CodeableConcept item : this.alternateMaterial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAlternateMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return t;
        }

        public PackagedProductDefinitionPackagingComponent addAlternateMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return this;
        }

        public CodeableConcept getAlternateMaterialFirstRep() {
            if (this.getAlternateMaterial().isEmpty()) {
                this.addAlternateMaterial();
            }
            return this.getAlternateMaterial().get(0);
        }

        public List<ProductShelfLife> getShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            return this.shelfLifeStorage;
        }

        public PackagedProductDefinitionPackagingComponent setShelfLifeStorage(List<ProductShelfLife> theShelfLifeStorage) {
            this.shelfLifeStorage = theShelfLifeStorage;
            return this;
        }

        public boolean hasShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                return false;
            }
            for (ProductShelfLife item : this.shelfLifeStorage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductShelfLife addShelfLifeStorage() {
            ProductShelfLife t = new ProductShelfLife();
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return t;
        }

        public PackagedProductDefinitionPackagingComponent addShelfLifeStorage(ProductShelfLife t) {
            if (t == null) {
                return this;
            }
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return this;
        }

        public ProductShelfLife getShelfLifeStorageFirstRep() {
            if (this.getShelfLifeStorage().isEmpty()) {
                this.addShelfLifeStorage();
            }
            return this.getShelfLifeStorage().get(0);
        }

        public List<Reference> getManufacturer() {
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            return this.manufacturer;
        }

        public PackagedProductDefinitionPackagingComponent setManufacturer(List<Reference> theManufacturer) {
            this.manufacturer = theManufacturer;
            return this;
        }

        public boolean hasManufacturer() {
            if (this.manufacturer == null) {
                return false;
            }
            for (Reference item : this.manufacturer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addManufacturer() {
            Reference t = new Reference();
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return t;
        }

        public PackagedProductDefinitionPackagingComponent addManufacturer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return this;
        }

        public Reference getManufacturerFirstRep() {
            if (this.getManufacturer().isEmpty()) {
                this.addManufacturer();
            }
            return this.getManufacturer().get(0);
        }

        public List<PackagedProductDefinitionPackagingPropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagingPropertyComponent>();
            }
            return this.property;
        }

        public PackagedProductDefinitionPackagingComponent setProperty(List<PackagedProductDefinitionPackagingPropertyComponent> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (PackagedProductDefinitionPackagingPropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackagingPropertyComponent addProperty() {
            PackagedProductDefinitionPackagingPropertyComponent t = new PackagedProductDefinitionPackagingPropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagingPropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public PackagedProductDefinitionPackagingComponent addProperty(PackagedProductDefinitionPackagingPropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<PackagedProductDefinitionPackagingPropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public PackagedProductDefinitionPackagingPropertyComponent getPropertyFirstRep() {
            if (this.getProperty().isEmpty()) {
                this.addProperty();
            }
            return this.getProperty().get(0);
        }

        public List<PackagedProductDefinitionPackagingContainedItemComponent> getContainedItem() {
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackagingContainedItemComponent>();
            }
            return this.containedItem;
        }

        public PackagedProductDefinitionPackagingComponent setContainedItem(List<PackagedProductDefinitionPackagingContainedItemComponent> theContainedItem) {
            this.containedItem = theContainedItem;
            return this;
        }

        public boolean hasContainedItem() {
            if (this.containedItem == null) {
                return false;
            }
            for (PackagedProductDefinitionPackagingContainedItemComponent item : this.containedItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackagingContainedItemComponent addContainedItem() {
            PackagedProductDefinitionPackagingContainedItemComponent t = new PackagedProductDefinitionPackagingContainedItemComponent();
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackagingContainedItemComponent>();
            }
            this.containedItem.add(t);
            return t;
        }

        public PackagedProductDefinitionPackagingComponent addContainedItem(PackagedProductDefinitionPackagingContainedItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.containedItem == null) {
                this.containedItem = new ArrayList<PackagedProductDefinitionPackagingContainedItemComponent>();
            }
            this.containedItem.add(t);
            return this;
        }

        public PackagedProductDefinitionPackagingContainedItemComponent getContainedItemFirstRep() {
            if (this.getContainedItem().isEmpty()) {
                this.addContainedItem();
            }
            return this.getContainedItem().get(0);
        }

        public List<PackagedProductDefinitionPackagingComponent> getPackaging() {
            if (this.packaging == null) {
                this.packaging = new ArrayList<PackagedProductDefinitionPackagingComponent>();
            }
            return this.packaging;
        }

        public PackagedProductDefinitionPackagingComponent setPackaging(List<PackagedProductDefinitionPackagingComponent> thePackaging) {
            this.packaging = thePackaging;
            return this;
        }

        public boolean hasPackaging() {
            if (this.packaging == null) {
                return false;
            }
            for (PackagedProductDefinitionPackagingComponent item : this.packaging) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagedProductDefinitionPackagingComponent addPackaging() {
            PackagedProductDefinitionPackagingComponent t = new PackagedProductDefinitionPackagingComponent();
            if (this.packaging == null) {
                this.packaging = new ArrayList<PackagedProductDefinitionPackagingComponent>();
            }
            this.packaging.add(t);
            return t;
        }

        public PackagedProductDefinitionPackagingComponent addPackaging(PackagedProductDefinitionPackagingComponent t) {
            if (t == null) {
                return this;
            }
            if (this.packaging == null) {
                this.packaging = new ArrayList<PackagedProductDefinitionPackagingComponent>();
            }
            this.packaging.add(t);
            return this;
        }

        public PackagedProductDefinitionPackagingComponent getPackagingFirstRep() {
            if (this.getPackaging().isEmpty()) {
                this.addPackaging();
            }
            return this.getPackaging().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PackagedProductDefinition.SP_IDENTIFIER, "Identifier", "A business identifier that is specific to this particular part of the packaging, often assigned by the manufacturer. Including possibly Data Carrier Identifier (a GS1 barcode).", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("type", "CodeableConcept", "The physical type of the container of the items.", 0, 1, this.type));
            children.add(new Property("componentPart", "boolean", "Is this a part of the packaging (e.g. a cap or bottle stopper), rather than the packaging itself (e.g. a bottle or vial). The latter type are designed be a container, but the former are not.", 0, 1, this.componentPart));
            children.add(new Property("quantity", "integer", "The quantity of packaging items contained at this layer of the package. This does not relate to the number of contained items but relates solely to the number of packaging items. When looking at the outermost layer it is always 1. If there are two boxes within, at the next layer it would be 2.", 0, 1, this.quantity));
            children.add(new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material));
            children.add(new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for this part of the packaging, that is allowed to be used instead of the usual material (e.g. different types of plastic for a blister sleeve).", 0, Integer.MAX_VALUE, this.alternateMaterial));
            children.add(new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage));
            children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this packaging item. When there are multiple values each one is a potential manufacturer of this packaging item.", 0, Integer.MAX_VALUE, this.manufacturer));
            children.add(new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property));
            children.add(new Property("containedItem", "", "The item(s) within the packaging.", 0, Integer.MAX_VALUE, this.containedItem));
            children.add(new Property("packaging", "@PackagedProductDefinition.packaging", "Allows containers (and parts of containers) within containers, still as a part of a single packaged product. See also PackagedProductDefinition.packaging.containedItem.item(PackagedProductDefinition).", 0, Integer.MAX_VALUE, this.packaging));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(PackagedProductDefinition.SP_IDENTIFIER, "Identifier", "A business identifier that is specific to this particular part of the packaging, often assigned by the manufacturer. Including possibly Data Carrier Identifier (a GS1 barcode).", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The physical type of the container of the items.", 0, 1, this.type);
                }
                case 1706307216: {
                    return new Property("componentPart", "boolean", "Is this a part of the packaging (e.g. a cap or bottle stopper), rather than the packaging itself (e.g. a bottle or vial). The latter type are designed be a container, but the former are not.", 0, 1, this.componentPart);
                }
                case -1285004149: {
                    return new Property("quantity", "integer", "The quantity of packaging items contained at this layer of the package. This does not relate to the number of contained items but relates solely to the number of packaging items. When looking at the outermost layer it is always 1. If there are two boxes within, at the next layer it would be 2.", 0, 1, this.quantity);
                }
                case 299066663: {
                    return new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material);
                }
                case -1021448255: {
                    return new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for this part of the packaging, that is allowed to be used instead of the usual material (e.g. different types of plastic for a blister sleeve).", 0, Integer.MAX_VALUE, this.alternateMaterial);
                }
                case 172049237: {
                    return new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage);
                }
                case -1969347631: {
                    return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this packaging item. When there are multiple values each one is a potential manufacturer of this packaging item.", 0, Integer.MAX_VALUE, this.manufacturer);
                }
                case -993141291: {
                    return new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property);
                }
                case 1953679910: {
                    return new Property("containedItem", "", "The item(s) within the packaging.", 0, Integer.MAX_VALUE, this.containedItem);
                }
                case 1802065795: {
                    return new Property("packaging", "@PackagedProductDefinition.packaging", "Allows containers (and parts of containers) within containers, still as a part of a single packaged product. See also PackagedProductDefinition.packaging.containedItem.item(PackagedProductDefinition).", 0, Integer.MAX_VALUE, this.packaging);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1706307216: {
                    Base[] baseArray;
                    if (this.componentPart == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.componentPart;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 299066663: {
                    return this.material == null ? new Base[]{} : this.material.toArray(new Base[this.material.size()]);
                }
                case -1021448255: {
                    return this.alternateMaterial == null ? new Base[]{} : this.alternateMaterial.toArray(new Base[this.alternateMaterial.size()]);
                }
                case 172049237: {
                    return this.shelfLifeStorage == null ? new Base[]{} : this.shelfLifeStorage.toArray(new Base[this.shelfLifeStorage.size()]);
                }
                case -1969347631: {
                    return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case 1953679910: {
                    return this.containedItem == null ? new Base[]{} : this.containedItem.toArray(new Base[this.containedItem.size()]);
                }
                case 1802065795: {
                    return this.packaging == null ? new Base[]{} : this.packaging.toArray(new Base[this.packaging.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1706307216: {
                    this.componentPart = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 299066663: {
                    this.getMaterial().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1021448255: {
                    this.getAlternateMaterial().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 172049237: {
                    this.getShelfLifeStorage().add(TypeConvertor.castToProductShelfLife(value));
                    return value;
                }
                case -1969347631: {
                    this.getManufacturer().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -993141291: {
                    this.getProperty().add((PackagedProductDefinitionPackagingPropertyComponent)value);
                    return value;
                }
                case 1953679910: {
                    this.getContainedItem().add((PackagedProductDefinitionPackagingContainedItemComponent)value);
                    return value;
                }
                case 1802065795: {
                    this.getPackaging().add((PackagedProductDefinitionPackagingComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PackagedProductDefinition.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("componentPart")) {
                this.componentPart = TypeConvertor.castToBoolean(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToInteger(value);
            } else if (name.equals("material")) {
                this.getMaterial().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("alternateMaterial")) {
                this.getAlternateMaterial().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("shelfLifeStorage")) {
                this.getShelfLifeStorage().add(TypeConvertor.castToProductShelfLife(value));
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
            } else if (name.equals("property")) {
                this.getProperty().add((PackagedProductDefinitionPackagingPropertyComponent)value);
            } else if (name.equals("containedItem")) {
                this.getContainedItem().add((PackagedProductDefinitionPackagingContainedItemComponent)value);
            } else if (name.equals("packaging")) {
                this.getPackaging().add((PackagedProductDefinitionPackagingComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(PackagedProductDefinition.SP_IDENTIFIER)) {
                this.getIdentifier().remove(value);
            } else if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("componentPart")) {
                this.componentPart = null;
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("material")) {
                this.getMaterial().remove(value);
            } else if (name.equals("alternateMaterial")) {
                this.getAlternateMaterial().remove(value);
            } else if (name.equals("shelfLifeStorage")) {
                this.getShelfLifeStorage().remove(value);
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().remove(value);
            } else if (name.equals("property")) {
                this.getProperty().remove((PackagedProductDefinitionPackagingPropertyComponent)value);
            } else if (name.equals("containedItem")) {
                this.getContainedItem().remove((PackagedProductDefinitionPackagingContainedItemComponent)value);
            } else if (name.equals("packaging")) {
                this.getPackaging().remove((PackagedProductDefinitionPackagingComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case 1706307216: {
                    return this.getComponentPartElement();
                }
                case -1285004149: {
                    return this.getQuantityElement();
                }
                case 299066663: {
                    return this.addMaterial();
                }
                case -1021448255: {
                    return this.addAlternateMaterial();
                }
                case 172049237: {
                    return this.addShelfLifeStorage();
                }
                case -1969347631: {
                    return this.addManufacturer();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case 1953679910: {
                    return this.addContainedItem();
                }
                case 1802065795: {
                    return this.addPackaging();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1706307216: {
                    return new String[]{"boolean"};
                }
                case -1285004149: {
                    return new String[]{"integer"};
                }
                case 299066663: {
                    return new String[]{"CodeableConcept"};
                }
                case -1021448255: {
                    return new String[]{"CodeableConcept"};
                }
                case 172049237: {
                    return new String[]{"ProductShelfLife"};
                }
                case -1969347631: {
                    return new String[]{"Reference"};
                }
                case -993141291: {
                    return new String[0];
                }
                case 1953679910: {
                    return new String[0];
                }
                case 1802065795: {
                    return new String[]{"@PackagedProductDefinition.packaging"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PackagedProductDefinition.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("componentPart")) {
                throw new FHIRException("Cannot call addChild on a singleton property PackagedProductDefinition.packaging.componentPart");
            }
            if (name.equals("quantity")) {
                throw new FHIRException("Cannot call addChild on a singleton property PackagedProductDefinition.packaging.quantity");
            }
            if (name.equals("material")) {
                return this.addMaterial();
            }
            if (name.equals("alternateMaterial")) {
                return this.addAlternateMaterial();
            }
            if (name.equals("shelfLifeStorage")) {
                return this.addShelfLifeStorage();
            }
            if (name.equals("manufacturer")) {
                return this.addManufacturer();
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("containedItem")) {
                return this.addContainedItem();
            }
            if (name.equals("packaging")) {
                return this.addPackaging();
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionPackagingComponent copy() {
            PackagedProductDefinitionPackagingComponent dst = new PackagedProductDefinitionPackagingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionPackagingComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.componentPart = this.componentPart == null ? null : this.componentPart.copy();
            IntegerType integerType = dst.quantity = this.quantity == null ? null : this.quantity.copy();
            if (this.material != null) {
                dst.material = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.material) {
                    dst.material.add(codeableConcept.copy());
                }
            }
            if (this.alternateMaterial != null) {
                dst.alternateMaterial = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.alternateMaterial) {
                    dst.alternateMaterial.add(codeableConcept.copy());
                }
            }
            if (this.shelfLifeStorage != null) {
                dst.shelfLifeStorage = new ArrayList<ProductShelfLife>();
                for (ProductShelfLife productShelfLife : this.shelfLifeStorage) {
                    dst.shelfLifeStorage.add(productShelfLife.copy());
                }
            }
            if (this.manufacturer != null) {
                dst.manufacturer = new ArrayList<Reference>();
                for (Reference reference : this.manufacturer) {
                    dst.manufacturer.add(reference.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<PackagedProductDefinitionPackagingPropertyComponent>();
                for (PackagedProductDefinitionPackagingPropertyComponent packagedProductDefinitionPackagingPropertyComponent : this.property) {
                    dst.property.add(packagedProductDefinitionPackagingPropertyComponent.copy());
                }
            }
            if (this.containedItem != null) {
                dst.containedItem = new ArrayList<PackagedProductDefinitionPackagingContainedItemComponent>();
                for (PackagedProductDefinitionPackagingContainedItemComponent packagedProductDefinitionPackagingContainedItemComponent : this.containedItem) {
                    dst.containedItem.add(packagedProductDefinitionPackagingContainedItemComponent.copy());
                }
            }
            if (this.packaging != null) {
                dst.packaging = new ArrayList<PackagedProductDefinitionPackagingComponent>();
                for (PackagedProductDefinitionPackagingComponent packagedProductDefinitionPackagingComponent : this.packaging) {
                    dst.packaging.add(packagedProductDefinitionPackagingComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagingComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagingComponent o = (PackagedProductDefinitionPackagingComponent)other_;
            return PackagedProductDefinitionPackagingComponent.compareDeep(this.identifier, o.identifier, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.type, o.type, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.componentPart, o.componentPart, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.quantity, o.quantity, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.material, o.material, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.alternateMaterial, o.alternateMaterial, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.shelfLifeStorage, o.shelfLifeStorage, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.manufacturer, o.manufacturer, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.property, o.property, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.containedItem, o.containedItem, true) && PackagedProductDefinitionPackagingComponent.compareDeep(this.packaging, o.packaging, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionPackagingComponent)) {
                return false;
            }
            PackagedProductDefinitionPackagingComponent o = (PackagedProductDefinitionPackagingComponent)other_;
            return PackagedProductDefinitionPackagingComponent.compareValues(this.componentPart, o.componentPart, true) && PackagedProductDefinitionPackagingComponent.compareValues(this.quantity, o.quantity, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.componentPart, this.quantity, this.material, this.alternateMaterial, this.shelfLifeStorage, this.manufacturer, this.property, this.containedItem, this.packaging});
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.packaging";
        }
    }

    @Block
    public static class PackagedProductDefinitionLegalStatusOfSupplyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual status of supply. In what situation this package type may be supplied for use", formalDefinition="The actual status of supply. Conveys in what situation this package type may be supplied for use.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/legal-status-of-supply")
        protected CodeableConcept code;
        @Child(name="jurisdiction", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The place where the legal status of supply applies", formalDefinition="The place where the legal status of supply applies. When not specified, this indicates it is unknown in this context.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
        protected CodeableConcept jurisdiction;
        private static final long serialVersionUID = 1072410156L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionLegalStatusOfSupplyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public PackagedProductDefinitionLegalStatusOfSupplyComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getJurisdiction() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagedProductDefinitionLegalStatusOfSupplyComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new CodeableConcept();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public PackagedProductDefinitionLegalStatusOfSupplyComponent setJurisdiction(CodeableConcept value) {
            this.jurisdiction = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The actual status of supply. Conveys in what situation this package type may be supplied for use.", 0, 1, this.code));
            children.add(new Property("jurisdiction", "CodeableConcept", "The place where the legal status of supply applies. When not specified, this indicates it is unknown in this context.", 0, 1, this.jurisdiction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The actual status of supply. Conveys in what situation this package type may be supplied for use.", 0, 1, this.code);
                }
                case -507075711: {
                    return new Property("jurisdiction", "CodeableConcept", "The place where the legal status of supply applies. When not specified, this indicates it is unknown in this context.", 0, 1, this.jurisdiction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -507075711: {
                    return this.getJurisdiction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -507075711: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("jurisdiction")) {
                this.jurisdiction = new CodeableConcept();
                return this.jurisdiction;
            }
            return super.addChild(name);
        }

        @Override
        public PackagedProductDefinitionLegalStatusOfSupplyComponent copy() {
            PackagedProductDefinitionLegalStatusOfSupplyComponent dst = new PackagedProductDefinitionLegalStatusOfSupplyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagedProductDefinitionLegalStatusOfSupplyComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionLegalStatusOfSupplyComponent)) {
                return false;
            }
            PackagedProductDefinitionLegalStatusOfSupplyComponent o = (PackagedProductDefinitionLegalStatusOfSupplyComponent)other_;
            return PackagedProductDefinitionLegalStatusOfSupplyComponent.compareDeep(this.code, o.code, true) && PackagedProductDefinitionLegalStatusOfSupplyComponent.compareDeep(this.jurisdiction, o.jurisdiction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagedProductDefinitionLegalStatusOfSupplyComponent)) {
                return false;
            }
            PackagedProductDefinitionLegalStatusOfSupplyComponent o = (PackagedProductDefinitionLegalStatusOfSupplyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.jurisdiction});
        }

        @Override
        public String fhirType() {
            return "PackagedProductDefinition.legalStatusOfSupply";
        }
    }
}

