/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.profilemodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.profilemodel.PEDefinition;
import org.hl7.fhir.r5.profilemodel.PEType;

public class PEInstance {
    private PEBuilder builder;
    private PEDefinition definition;
    private Resource resource;
    private Base data;
    private String path;

    protected PEInstance(PEBuilder builder, PEDefinition definition, Resource resource, Base data, String path) {
        this.builder = builder;
        this.definition = definition;
        this.resource = resource;
        this.data = data;
        this.path = path;
    }

    public PEDefinition definition() {
        return this.definition;
    }

    public PEType type() {
        return this.definition.types().get(0);
    }

    public List<PEInstance> children() {
        ArrayList<PEInstance> res = new ArrayList<PEInstance>();
        for (PEDefinition child : this.definition.children()) {
            List<Base> instances = this.builder.exec(this.resource, this.data, child.fhirpath());
            int i = 0;
            for (Base b : instances) {
                res.add(new PEInstance(this.builder, child, this.resource, b, this.path + "." + child.name() + (String)(child.repeats() ? "[" + i + "]" : "")));
                ++i;
            }
        }
        return res;
    }

    public PEInstance child(String name) {
        PEDefinition child = this.byName(this.definition.children(), name);
        List<Base> instances = this.builder.exec(this.resource, this.data, child.fhirpath());
        if (instances.isEmpty()) {
            return null;
        }
        if (instances.size() == 1) {
            return new PEInstance(this.builder, child, this.resource, instances.get(0), this.path + "." + child.name() + (child.repeats() ? "[0]" : ""));
        }
        throw new FHIRException("Found multiple instances for " + name + "@ " + this.path);
    }

    public List<PEInstance> children(String name) {
        PEDefinition child = this.byName(this.definition.children(), name);
        ArrayList<PEInstance> res = new ArrayList<PEInstance>();
        List<Base> instances = this.builder.exec(this.resource, this.data, child.fhirpath());
        int i = 0;
        for (Base b : instances) {
            res.add(new PEInstance(this.builder, child, this.resource, b, this.path + "." + child.name() + (String)(child.repeats() ? "[" + i + "]" : "")));
            ++i;
        }
        return res;
    }

    private PEDefinition byName(List<PEDefinition> children, String name) {
        for (PEDefinition defn : children) {
            if (defn.name().equals(name)) {
                return defn;
            }
            if (!defn.name().equals(name + "[x]")) continue;
            return defn;
        }
        throw new FHIRException("No children with the name '" + name + "'");
    }

    public PEInstance makeChild(String name) {
        PEDefinition child = this.byName(this.definition.children(), name);
        Base b = child.isBaseList() || !child.isBasePrimitive() ? this.data.addChild(child.schemaNameWithType()) : this.data.makeProperty(child.schemaNameWithType().hashCode(), child.schemaNameWithType());
        this.builder.populateByProfile(b, child);
        return new PEInstance(this.builder, child, this.resource, b, this.path + "." + child.name());
    }

    public PEInstance forceChild(String name) {
        PEDefinition child = this.byName(this.definition.children(), name);
        List<Base> instances = this.builder.exec(this.resource, this.data, child.fhirpath());
        if (instances.isEmpty()) {
            Base b = this.data.addChild(child.schemaName());
            this.builder.populateByProfile(b, child);
            return new PEInstance(this.builder, child, this.resource, b, this.path + "." + child.name() + (child.isList() ? "[0]" : ""));
        }
        return new PEInstance(this.builder, child, this.resource, instances.get(0), this.path + "." + child.name() + (child.repeats() ? "[0]" : ""));
    }

    public void removeChild(PEInstance child) {
        this.data.removeChild(child.definition().schemaName(), child.data);
    }

    public void clear(String name) {
        List<PEInstance> children = this.children(name);
        for (PEInstance child : children) {
            this.removeChild(child);
        }
    }

    public PEInstanceDataKind getDataKind() {
        if (this.data instanceof Resource) {
            return PEInstanceDataKind.Resource;
        }
        if (this.data instanceof PrimitiveType) {
            return PEInstanceDataKind.Primitive;
        }
        if (this.data instanceof DataType) {
            return PEInstanceDataKind.DataType;
        }
        return PEInstanceDataKind.Complex;
    }

    public Base data() {
        return this.data;
    }

    public Resource asResource() {
        return (Resource)this.data;
    }

    public DataType asDataType() {
        return (DataType)this.data;
    }

    public BackboneElement asElement() {
        return (BackboneElement)this.data;
    }

    public CodeableConcept asCodeableConcept() {
        return (CodeableConcept)this.asDataType();
    }

    public Identifier Identifier() {
        return (Identifier)this.asDataType();
    }

    public Quantity asQuantity() {
        return (Quantity)this.asDataType();
    }

    public HumanName asHumanName() {
        return (HumanName)this.asDataType();
    }

    public Address Address() {
        return (Address)this.asDataType();
    }

    public ContactPoint asContactPoint() {
        return (ContactPoint)this.asDataType();
    }

    public Reference asReference() {
        return (Reference)this.asDataType();
    }

    public String getPrimitiveAsString() {
        return this.data.primitiveValue();
    }

    public Date getPrimitiveAsDate() {
        if (this.data instanceof BaseDateTimeType) {
            return (Date)((DateTimeType)this.data).getValue();
        }
        return null;
    }

    public void setPrimitiveValue(String value) {
        PrimitiveType pt = (PrimitiveType)this.data;
        pt.setValueAsString(value);
    }

    public String getPath() {
        return this.path;
    }

    public Base getBase() {
        return this.data;
    }

    public boolean hasChild(String name) {
        PEDefinition child = this.byName(this.definition.children(), name);
        List<Base> instances = this.builder.exec(this.resource, this.data, child.fhirpath());
        return !instances.isEmpty();
    }

    public IWorkerContext getContext() {
        return this.builder.getContext();
    }

    public Base addChild(String name, DataType value) {
        PEDefinition child = this.byName(this.definition.children(), name);
        Base b = this.data.setProperty(child.schemaName(), value);
        return b;
    }

    public Base addChild(String name, BackboneElement value) {
        PEDefinition child = this.byName(this.definition.children(), name);
        Base b = this.data.setProperty(child.schemaName(), value);
        return b;
    }

    public Base addChild(String name, String value) {
        PEDefinition child = this.byName(this.definition.children(), name);
        Base b = this.data.setProperty(child.schemaName(), new StringType(value));
        return b;
    }

    public Base addChild(String name, Date value) {
        PEDefinition child = this.byName(this.definition.children(), name);
        Base b = this.data.setProperty(child.schemaName(), new DateType(value));
        return b;
    }

    public static enum PEInstanceDataKind {
        Resource,
        Complex,
        DataType,
        Primitive;

    }
}

