/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class NamingSystemRenderer
extends ResourceRenderer {
    public NamingSystemRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (r.isDirect()) {
            this.renderResourceTechDetails(r, x);
            this.genSummaryTable(status, x, (NamingSystem)r.getBase());
            this.render(status, x, (NamingSystem)r.getBase());
        } else {
            x.para().tx("NamingSystemRenderer only renders native resources directly");
        }
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, NamingSystem ns) throws FHIRFormatError, DefinitionException, IOException {
        x.h3().tx(this.context.formatPhrase("GENERAL_SUMM", new Object[0]));
        XhtmlNode tbl = x.table("grid");
        this.row(tbl, this.context.formatPhrase("GENERAL_DEFINING_URL", new Object[0]), ns.getUrl());
        if (ns.hasVersion()) {
            this.row(tbl, this.context.formatPhrase("GENERAL_VER", new Object[0]), ns.getVersion());
        }
        if (ns.hasName()) {
            this.row(tbl, this.context.formatPhrase("GENERAL_NAME", new Object[0]), this.gt(ns.getNameElement()));
        }
        if (ns.hasTitle()) {
            this.row(tbl, this.context.formatPhrase("GENERAL_TITLE", new Object[0]), this.gt(ns.getTitleElement()));
        }
        this.row(tbl, this.context.formatPhrase("GENERAL_STATUS", new Object[0]), ns.getStatus().toCode());
        if (ns.hasDescription()) {
            this.addMarkdown(this.row(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0])), ns.getDescription());
        }
        if (ns.hasPublisher()) {
            this.row(tbl, this.context.formatPhrase("CANON_REND_PUBLISHER", new Object[0]), this.gt(ns.getPublisherElement()));
        }
        if (ns.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg")) {
            this.renderCommitteeLink(this.row(tbl, "Committee"), ns);
        }
        if (CodeSystemUtilities.hasOID(ns)) {
            this.row(tbl, this.context.formatPhrase("GENERAL_OID", new Object[0])).tx(this.context.formatPhrase("CODE_SYS_FOR_OID", new Object[]{CodeSystemUtilities.getOID(ns)}));
        }
        if (ns.hasCopyright()) {
            this.addMarkdown(this.row(tbl, this.context.formatPhrase("GENERAL_COPYRIGHT", new Object[0])), ns.getCopyright());
        }
        boolean hasPreferred = false;
        boolean hasPeriod = false;
        boolean hasComment = false;
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            hasPreferred = hasPreferred || id.hasPreferred();
            hasPeriod = hasPeriod || id.hasPeriod();
            hasComment = hasComment || id.hasComment();
        }
        x.h3().tx(this.context.formatPhrase("NAME_SYS_IDEN", new Object[0]));
        tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("GENERAL_VALUE", new Object[0]));
        if (hasPreferred) {
            tr.td().b().tx(this.context.formatPhrase("GENERAL_PREFERRED", new Object[0]));
        }
        if (hasPeriod) {
            tr.td().b().tx(this.context.formatPhrase("NAME_SYS_PER", new Object[0]));
        }
        if (hasComment) {
            tr.td().b().tx(this.context.formatPhrase("GENERAL_COMMENT", new Object[0]));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            tr = tbl.tr();
            tr.td().tx(id.getType().getDisplay());
            tr.td().tx(id.getValue());
            if (hasPreferred) {
                tr.td().tx(id.getPreferredElement().primitiveValue());
            }
            if (hasPeriod) {
                tr.td().tx(this.displayDataType(id.getPeriod()));
            }
            if (!hasComment) continue;
            tr.td().tx(id.getComment());
        }
    }

    private XhtmlNode row(XhtmlNode tbl, String name) {
        XhtmlNode tr = tbl.tr();
        XhtmlNode td = tr.td();
        td.tx(name);
        return tr.td();
    }

    private XhtmlNode row(XhtmlNode tbl, String name, String value) {
        XhtmlNode td = this.row(tbl, name);
        td.tx(value);
        return td;
    }

    public void describe(XhtmlNode x, NamingSystem ns) {
        x.tx(this.display(ns));
    }

    public String display(NamingSystem ns) {
        return ns.present();
    }
}

