/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class QuestionnaireRenderer
extends TerminologyRenderer {
    public static final String EXT_QUESTIONNAIRE_ITEM_TYPE_ORIGINAL = "http://hl7.org/fhir/4.0/StructureDefinition/extension-questionnaire.item.type";

    public QuestionnaireRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(q, x);
        this.genSummaryTable(status, x, (CanonicalResource)q.getResourceNative());
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                this.renderForm(status, x, q);
                break;
            }
            case LINKS: {
                this.renderLinks(status, x, q);
                break;
            }
            case LOGIC: {
                this.renderLogic(status, x, q);
                break;
            }
            case DEFNS: {
                this.renderDefns(status, x, q);
                break;
            }
            case TREE: {
                this.renderTree(status, x, q);
                break;
            }
            default: {
                throw new Error("Unknown questionnaire Renderer Mode");
            }
        }
        boolean first = true;
        for (ResourceWrapper cont : q.children("contained")) {
            if (first) {
                x.h2().tx("Contained Resources");
                first = false;
            }
            x.hr();
            RendererFactory.factory(cont, this.context.forContained()).buildNarrative(status, x, cont);
        }
    }

    public void renderTree(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        boolean doOpts;
        boolean hasFlags = this.checkForFlags(q.children("item"));
        boolean bl = doOpts = this.context.getDefinitionsTarget() == null && this.hasAnyOptions(q.children("item"));
        if (doOpts) {
            x.b().tx(this.context.formatPhrase("QUEST_STRUCT", new Object[0]));
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator((RenderingI18nContext)this.context, this.context.getDestDir(), this.context.isInlineGraphics(), true, "");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER);
        model.setAlternating(true);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "help16.png"}));
        }
        model.setDocoRef(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.context.formatPhrase("QUEST_LINKID", new Object[0]), this.context.formatPhrase("QUEST_LINK", new Object[0]), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.context.formatPhrase("QUEST_TEXT", new Object[0]), this.context.formatPhrase("QUEST_TEXTFOR", new Object[0]), null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_CARDINALITY", new Object[0]), this.context.formatPhrase("QUEST_TIMES", new Object[0]), null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_TYPE", new Object[0]), this.context.formatPhrase("QUEST_TYPE_ITEM", new Object[0]), null, 0));
        if (hasFlags) {
            List list5 = model.getTitles();
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator6);
            list5.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator6, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_FLAGS", new Object[0]), this.context.formatPhrase("QUEST_ATTRIBUTES", new Object[0]), null, 0));
        }
        List list6 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator7);
        list6.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator7, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_DESC_CONST", new Object[0]), this.context.formatPhrase("QUEST_ADD_INFO", new Object[0]), null, 0));
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), q, hasFlags);
        for (ResourceWrapper i : q.children("item")) {
            this.renderTreeItem(status, gen, row.getSubRows(), q, i, hasFlags);
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.addChildNode(xn);
        if (doOpts) {
            this.renderOptions(q, x);
        }
    }

    private void renderOptions(ResourceWrapper q, XhtmlNode x) {
        if (this.hasAnyOptions(q.children("item"))) {
            x.hr();
            x.para().b().tx(this.context.formatPhrase("QUEST_OPT", new Object[0]));
            this.renderOptions(q.children("item"), x);
        }
    }

    private void renderOptions(List<ResourceWrapper> items, XhtmlNode x) {
        for (ResourceWrapper i : items) {
            this.renderItemOptionsList(x, i);
            this.renderOptions(i.children("item"), x);
        }
    }

    public void renderItemOptions(XhtmlNode x, ResourceWrapper i) {
        if (i.has("answerOption")) {
            for (ResourceWrapper opt : i.children("answerOption")) {
                Object value = "??";
                String text = "??";
                ResourceWrapper v = opt.child("value");
                if (v.isPrimitive()) {
                    value = v.primitiveValue();
                    text = v.primitiveValue();
                } else if (v.fhirType().equals("Coding")) {
                    value = v.has("system") ? v.primitiveValue("system") + "#" + v.primitiveValue("code") : v.primitiveValue("code");
                    text = v.has("display") ? v.primitiveValue("display") : v.primitiveValue("code");
                }
                if (value == null) {
                    value = "??";
                }
                if (text == null) {
                    text = "??";
                }
                boolean selected = "true".equals(opt.primitiveValue("initialSelected"));
                x.option((String)value, text, selected);
            }
        }
    }

    public void renderItemOptionsList(XhtmlNode x, ResourceWrapper i) {
        if (i.has("answerOption")) {
            x.an(this.context.prefixAnchor("opt-item." + i.primitiveValue("linkId")));
            x.para().b().tx(this.context.formatPhrase("QUEST_ANSW", new Object[]{i.primitiveValue("linkId")}) + " ");
            XhtmlNode ul = x.ul();
            for (ResourceWrapper opt : i.children("answerOption")) {
                XhtmlNode li = ul.li();
                li.style("font-size: 11px");
                ResourceWrapper v = opt.child("value");
                if (v.isPrimitive()) {
                    li.tx(v.primitiveValue());
                    continue;
                }
                if (v.fhirType().equals("Coding")) {
                    String link;
                    String string = link = v.has("system") ? new ContextUtilities(this.context.getWorker()).getLinkForUrl(this.context.getLink(RenderingContext.KnownLinkType.SPEC), v.primitiveValue("system")) : null;
                    if (link == null) {
                        li.tx(v.primitiveValue("system") + "#" + v.primitiveValue("code"));
                    } else {
                        li.ah(link).tx(this.displaySystem(v.primitiveValue("system")));
                        li.tx(": " + v.primitiveValue("code"));
                    }
                    if (!v.has("display")) continue;
                    li.tx(" (\"" + v.primitiveValue("display") + "\")");
                    continue;
                }
                li.tx("??");
            }
        }
    }

    private boolean hasAnyOptions(List<ResourceWrapper> items) {
        for (ResourceWrapper i : items) {
            if (i.has("answerOption")) {
                return true;
            }
            if (!this.hasAnyOptions(i.children("item"))) continue;
            return true;
        }
        return false;
    }

    private boolean checkForFlags(List<ResourceWrapper> items) {
        for (ResourceWrapper i : items) {
            if (!this.checkForFlags(i)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForFlags(ResourceWrapper i) {
        if (i.has("readOnly")) {
            return true;
        }
        if ("true".equals(i.extensionString("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject"))) {
            return true;
        }
        if ("true".equals(i.extensionString("http://hl7.org/fhir/StructureDefinition/questionnaire-hidden"))) {
            return true;
        }
        if ("true".equals(i.extensionString("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay"))) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod")) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation")) {
            return true;
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            return true;
        }
        return this.checkForFlags(i.children("item"));
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper q, boolean hasFlags) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_q_root.gif", this.context.formatPhrase("QUEST_ROOT", new Object[0]));
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, q.primitiveValue("name"), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, q.primitiveValue("description"), null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "", null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, this.context.formatPhrase("QUEST_QUEST", new Object[0]), null, null));
        if (hasFlags) {
            List list5 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "", null, null));
        }
        List list6 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator6);
        list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, (String)(q.has("url") ? (q.has("version") ? q.primitiveValue("url") + "#" + q.primitiveValue("version") : q.primitiveValue("url")) : ""), null, null));
        return r;
    }

    private String getSpecLink(String path) {
        return Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), path});
    }

    private String getSDCLink(String url, String path) {
        StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, url);
        if (sd == null) {
            sd = this.context.getContext().fetchResource(StructureDefinition.class, path);
        }
        if (sd != null && sd.hasWebPath()) {
            return sd.getWebPath();
        }
        if (Utilities.isAbsoluteUrl((String)path)) {
            return path.replace("StructureDefinition/", "StructureDefinition-") + ".html";
        }
        if ("http://hl7.org/fhir/uv/sdc".equals(this.context.getPkp().getCanonicalForDefaultContext())) {
            return Utilities.pathURL((String[])new String[]{path});
        }
        return Utilities.pathURL((String[])new String[]{"http://hl7.org/fhir/uv/sdc", path});
    }

    private void renderTreeItem(Renderer.RenderingStatus status, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper q, ResourceWrapper i, boolean hasFlags) throws IOException {
        HierarchicalTableGenerator.Piece p;
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        String type = i.primitiveValue("type");
        r.setIcon("icon-q-" + type.toLowerCase() + ".png", type);
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell c1 = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, (String)(this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i.primitiveValue("linkId")), i.primitiveValue("linkId"), null, null);
        c1.setId("item." + i.primitiveValue("linkId"));
        r.getCells().add(c1);
        String txt = (String)(i.has("prefix") ? i.primitiveValue("prefix") + ". " : "") + i.primitiveValue("text");
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, txt, null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, ("true".equals(i.primitiveValue("required")) ? "1" : "0") + ".." + ("true".equals(i.primitiveValue("repeats")) ? "*" : "1"), null, null));
        if (i.child("type").hasExtension(EXT_QUESTIONNAIRE_ITEM_TYPE_ORIGINAL)) {
            status.setExtensions(true);
            String t = i.child("type").extensionString(EXT_QUESTIONNAIRE_ITEM_TYPE_ORIGINAL);
            List list3 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "codesystem-item-type.html#item-type-" + t, t, null, null));
        } else {
            List list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "codesystem-item-type.html#item-type-" + type, type, null, null));
        }
        if (hasFlags) {
            HierarchicalTableGenerator.Cell flags = new HierarchicalTableGenerator.Cell(gen);
            r.getCells().add(flags);
            if ("true".equals(i.primitiveValue("readOnly"))) {
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "questionnaire-definitions.html#Questionnaire.item.readOnly"}), null, this.context.formatPhrase("QUEST_READONLY", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-readonly.png"))));
            }
            if ("true".equals(i.extensionString("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-isSubject"))) {
                status.setExtensions(true);
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator7);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-isSubject", "StructureDefinition-sdc-questionnaire-isSubject.html"), null, this.context.formatPhrase("QUEST_SUBJECT", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-subject.png"))));
            }
            if ("true".equals(i.extensionString("http://hl7.org/fhir/StructureDefinition/questionnaire-hidden"))) {
                status.setExtensions(true);
                HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator8);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, this.getSpecLink("extension-questionnaire-hidden.html"), null, this.context.formatPhrase("QUEST_HIDDEN", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-hidden.png"))));
            }
            if ("true".equals(i.extensionString("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay"))) {
                status.setExtensions(true);
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-optionalDisplay", "StructureDefinition-sdc-questionnaire-optionalDisplay.html"), null, this.context.formatPhrase("QUEST_DISPLAY", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-optional.png"))));
            }
            if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-observationLinkPeriod")) {
                status.setExtensions(true);
                HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator10);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-observationLinkPeriod", "StructureDefinition-sdc-questionnaire-observationLinkPeriod.html"), null, this.context.formatPhrase("QUEST_LINKED", new Object[0])).addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-observation.png"))));
            }
            if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation")) {
                status.setExtensions(true);
                String code = i.extensionString("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation");
                HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator11);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, this.getSpecLink("extension-questionnaire-choiceorientation.html"), null, this.context.formatPhrase("QUEST_ORIENTATION", new Object[]{code}) + " ").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-" + code + ".png"))));
            }
            if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
                status.setExtensions(true);
                ResourceWrapper cc = i.extensionValue("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory");
                String string = this.getCodeFromCC(cc, "http://hl7.org/fhir/questionnaire-display-category");
                HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator12);
                flags.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, "https://hl7.org/fhir/R4/extension-questionnaire-displayCategory.html", null, this.context.formatPhrase("QUEST_CAT", new Object[]{string}) + " ").addHtml(new XhtmlNode(NodeType.Element, "img").attribute("alt", "icon").attribute("src", this.getImgPath("icon-qi-" + string + ".png"))));
            }
        }
        HierarchicalTableGenerator.Cell defn = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(defn);
        if (i.has("maxLength")) {
            List list5 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator13);
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, this.context.formatPhrase("GENERAL_MAX_LENGTH", new Object[0]) + " ", null));
            List list6 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator14);
            list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, null, i.primitiveValue("maxLength"), null));
        }
        if (i.has("definition")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator15);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "br"));
            }
            List list7 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator16);
            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, this.context.formatPhrase("GENERAL_DEFINITION_COLON", new Object[0]) + " ", null));
            this.genDefinitionLink(gen, i, defn, q);
        }
        if (i.has("enableWhen")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator17);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, "br"));
            }
            HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator18);
            p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, null, this.context.formatPhrase("QUEST_ENABLE", new Object[0]) + " ", null);
            defn.getPieces().add(p);
            if (i.children("enableWhen").size() == 1) {
                XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "span");
                p.getChildren().add(xhtmlNode);
                this.renderEnableWhen(xhtmlNode, i.firstChild("enableWhen"));
            } else {
                XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "ul");
                p.getChildren().add(xhtmlNode);
                for (ResourceWrapper qi : i.children("enableWhen")) {
                    this.renderEnableWhen(xhtmlNode.li(), qi);
                }
            }
        }
        if (i.has("answerValueSet")) {
            Object vs;
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator19);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, "br"));
            }
            List list8 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator20);
            list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, this.context.formatPhrase("QUEST_VALUE", new Object[0]) + " ", null));
            if (i.hasPrimitiveValue("answerValueSet") && i.primitiveValue("answerValueSet").startsWith("#")) {
                vs = q.getContained(i.primitiveValue("answerValueSet").substring(1));
                if (vs == null) {
                    List list9 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator21);
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, i.primitiveValue("answerValueSet"), null));
                } else {
                    List list10 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, ((ResourceWrapper)vs).getWebPath(), RendererFactory.factory((ResourceWrapper)vs, this.context.forContained()).buildSummary((ResourceWrapper)vs), null));
                }
            } else {
                vs = this.context.getWorker().findTxResource(ValueSet.class, i.primitiveValue("answerValueSet"));
                if (vs == null || !((Resource)vs).hasWebPath()) {
                    List list11 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator23);
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, null, i.primitiveValue("answerValueSet"), null));
                } else {
                    List list12 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator24);
                    list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, ((Resource)vs).getWebPath(), ((CanonicalResource)vs).present(), null));
                }
            }
        }
        if (i.has("answerOption")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator25);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, "br"));
            }
            List list13 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator26 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator26);
            list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator26, null, this.context.formatPhrase("QUEST_OPTIONS", new Object[0]) + " ", null));
            if (this.context.getDefinitionsTarget() == null) {
                List list14 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator27 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator27);
                list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator27, "#" + this.context.prefixAnchor("opt-item." + i.primitiveValue("linkId")), Integer.toString(i.children("answerOption").size()) + " " + Utilities.pluralize((String)"option", (int)i.children("answerOption").size()), null));
            } else {
                List list15 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator28 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator28);
                list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator28, this.context.getDefinitionsTarget() + "#item." + i.primitiveValue("linkId"), Integer.toString(i.children("answerOption").size()) + " " + Utilities.pluralize((String)"option", (int)i.children("answerOption").size()), null));
            }
        }
        if (i.has("initial")) {
            for (ResourceWrapper resourceWrapper : i.children("initial")) {
                ResourceWrapper vv = resourceWrapper.child("value");
                if (!defn.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator29 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator29);
                    defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator29, "br"));
                }
                List list16 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator30 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator30);
                list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator30, null, this.context.formatPhrase("QUEST_INITIAL", new Object[0]) + " ", null));
                List list17 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator31 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator31);
                list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator31, null, vv.fhirType(), null));
                List list18 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator32 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator32);
                list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator32, null, " = ", null));
                if (vv.isPrimitive()) {
                    List list19 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator33 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator33);
                    list19.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator33, null, vv.primitiveValue(), null));
                    continue;
                }
                if (vv.fhirType().equals("Coding")) {
                    this.renderCoding(gen, (List<HierarchicalTableGenerator.Piece>)defn.getPieces(), vv);
                    continue;
                }
                if (vv.fhirType().equals("Quantity")) {
                    this.renderQuantity(gen, (List<HierarchicalTableGenerator.Piece>)defn.getPieces(), vv, false);
                    continue;
                }
                if (vv.fhirType().equals("Reference")) {
                    this.renderReference(q, gen, (List<HierarchicalTableGenerator.Piece>)defn.getPieces(), vv, true);
                    continue;
                }
                if (!vv.fhirType().equals("Attachment")) continue;
            }
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-enableWhenExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-itemContext") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-calculatedExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-contextExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-candidateExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-initialExpression")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator34 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator34);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator34, "br"));
            }
            List list20 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator35 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator35);
            list20.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator35, null, this.context.formatPhrase("QUEST_EXP", new Object[0]) + " ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator36 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator36);
            p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator36, "ul");
            defn.getPieces().add(p);
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-initialExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_INT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-initialExpression");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-contextExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_CONT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-contextExpression");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-itemContext")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_ITEM_CONT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-itemContext");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-enableWhenExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_EN", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-enableWhenExpression");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-calculatedExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_CALC", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-calculatedExpression");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-candidateExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_CAND", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-candidateExpression");
            }
        }
        for (ResourceWrapper resourceWrapper : i.children("item")) {
            this.renderTreeItem(status, gen, r.getSubRows(), q, resourceWrapper, hasFlags);
        }
    }

    private String getCodeFromCC(ResourceWrapper cc, String system) {
        for (ResourceWrapper coding : cc.children("coding")) {
            if (!system.equals(coding.primitiveValue("system"))) continue;
            return coding.primitiveValue("code");
        }
        return null;
    }

    public void genDefinitionLink(HierarchicalTableGenerator gen, ResourceWrapper i, HierarchicalTableGenerator.Cell defn, ResourceWrapper q) {
        StructureDefinition sd;
        String path = null;
        String d = i.primitiveValue("definition");
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d, q.getResourceNative())) != null) {
            String url = sd.getWebPath();
            if (url != null) {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url + "#" + path, path, null));
            } else {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.primitiveValue("definition"), null));
            }
        } else {
            List list = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.primitiveValue("definition"), null));
        }
    }

    public void genDefinitionLink(XhtmlNode x, ResourceWrapper i, ResourceWrapper q) {
        StructureDefinition sd;
        String path = null;
        String d = i.primitiveValue("definition");
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d, q.getResourceNative())) != null) {
            String url = sd.getWebPath();
            if (url != null) {
                x.ah(url + "#" + path).tx(path);
            } else {
                x.tx(i.primitiveValue("definition"));
            }
        } else {
            x.tx(i.primitiveValue("definition"));
        }
    }

    private void addExpression(HierarchicalTableGenerator.Piece p, ResourceWrapper exp, String label, String url) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "li").style("font-size: 11px");
        p.addHtml(x);
        CanonicalResource cr = (CanonicalResource)this.context.getContext().fetchResource(Resource.class, url);
        if (cr != null && cr.hasWebPath()) {
            x.ah(cr.getWebPath()).tx(label);
        } else {
            x.ah(url).tx(label);
        }
        x.tx(": ");
        x.code(exp.primitiveValue("expression"));
    }

    private void renderLogic(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator((RenderingI18nContext)this.context, this.context.getDestDir(), this.context.isInlineGraphics(), true, "");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + q.getId(), true);
        model.setAlternating(true);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "help16.png"}));
        }
        model.setDocoRef(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.context.formatPhrase("QUEST_LINKID", new Object[0]), this.context.formatPhrase("QUEST_LINK", new Object[0]), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_DESC_CONST", new Object[0]), this.context.formatPhrase("QUEST_ADD_INFO", new Object[0]), null, 0));
        if (!q.has("item")) {
            gen.emptyRow(model, 2);
        } else {
            for (ResourceWrapper i : q.children("item")) {
                this.renderLogicItem(status, gen, model.getRows(), q, i);
            }
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.addChildNode(xn);
    }

    private void renderLogicItem(Renderer.RenderingStatus status, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper q, ResourceWrapper i) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        String type = i.primitiveValue("type");
        r.setIcon("icon-q-" + type.toLowerCase() + ".png", type);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, (String)(this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i.primitiveValue("linkId")), i.primitiveValue("linkId"), null, null));
        HierarchicalTableGenerator.Cell defn = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(defn);
        if (i.has("maxLength")) {
            List list2 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, this.context.formatPhrase("GENERAL_MAX_LENGTH", new Object[0]) + " ", null));
            List list3 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, i.primitiveValue("maxLength"), null));
        }
        if (i.has("definition")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, "br"));
            }
            List list4 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, this.context.formatPhrase("GENERAL_DEFINITION_COLON", new Object[0]) + " ", null));
            this.genDefinitionLink(gen, i, defn, q);
        }
        if (i.has("enableWhen")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, "br"));
            }
            List list5 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, this.context.formatPhrase("QUEST_ENABLE", new Object[0]) + " ", null));
            List list6 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator8);
            list6.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, this.context.formatPhrase("GENERAL_TODO", new Object[0]), null));
        }
        if (i.has("answerValueSet")) {
            Object vs;
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator9);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "br"));
            }
            List list7 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator10);
            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, this.context.formatPhrase("QUEST_VALUE", new Object[0]) + " ", null));
            if (Utilities.noString((String)i.primitiveValue("answerValueSet")) && i.primitiveValue("answerValueSet").startsWith("#")) {
                vs = q.getContained(i.primitiveValue("answerValueSet").substring(1));
                if (vs == null) {
                    List list8 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator11);
                    list8.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, i.primitiveValue("answerValueSet"), null));
                } else {
                    List list9 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator12);
                    list9.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, ((ResourceWrapper)vs).getWebPath(), RendererFactory.factory((ResourceWrapper)vs, this.context.forContained()).buildSummary((ResourceWrapper)vs), null));
                }
            } else {
                vs = this.context.getWorker().findTxResource(ValueSet.class, i.primitiveValue("answerValueSet"), q.getResourceNative());
                if (vs == null || !((Resource)vs).hasWebPath()) {
                    List list10 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator13 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator13);
                    list10.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator13, null, i.primitiveValue("answerValueSet"), null));
                } else {
                    List list11 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator14 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator14);
                    list11.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator14, ((Resource)vs).getWebPath(), ((CanonicalResource)vs).present(), null));
                }
            }
        }
        if (i.has("answerOption")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator15 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator15);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator15, "br"));
            }
            List list12 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator16 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator16);
            list12.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator16, null, this.context.formatPhrase("QUEST_OPTIONS", new Object[0]) + " ", null));
            List list13 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator17 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator17);
            list13.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator17, this.context.getDefinitionsTarget() + "#item." + i.primitiveValue("linkId"), Integer.toString(i.children("answerOption").size()) + " " + Utilities.pluralize((String)"option", (int)i.children("answerOption").size()), null));
        }
        if (i.has("initial")) {
            for (ResourceWrapper resourceWrapper : i.children("initial")) {
                if (!defn.getPieces().isEmpty()) {
                    HierarchicalTableGenerator hierarchicalTableGenerator18 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator18);
                    defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator18, "br"));
                }
                ResourceWrapper vv = resourceWrapper.child("value");
                List list14 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator19 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator19);
                list14.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator19, null, this.context.formatPhrase("QUEST_INITIAL", new Object[0]) + " ", null));
                List list15 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator20 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator20);
                list15.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator20, null, vv.fhirType(), null));
                List list16 = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator21 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator21);
                list16.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator21, null, " = ", null));
                if (vv.isPrimitive()) {
                    List list17 = defn.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator22 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator22);
                    list17.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator22, null, vv.primitiveValue(), null));
                    continue;
                }
                if (vv.fhirType().equals("Coding")) {
                    this.renderCoding(gen, (List<HierarchicalTableGenerator.Piece>)defn.getPieces(), vv);
                    continue;
                }
                if (vv.fhirType().equals("Coding")) {
                    this.renderQuantity(gen, (List<HierarchicalTableGenerator.Piece>)defn.getPieces(), vv, false);
                    continue;
                }
                if (!vv.fhirType().equals("Coding")) continue;
                this.renderReference(q, gen, (List<HierarchicalTableGenerator.Piece>)defn.getPieces(), vv, false);
            }
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-enableWhenExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-itemContext") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-calculatedExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-contextExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-candidateExpression") || i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-initialExpression")) {
            if (!defn.getPieces().isEmpty()) {
                HierarchicalTableGenerator hierarchicalTableGenerator23 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator23);
                defn.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator23, "br"));
            }
            List list18 = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator24 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator24);
            list18.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator24, null, this.context.formatPhrase("QUEST_EXP", new Object[0]) + " ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator25 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator25);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator25, "ul");
            defn.getPieces().add(p);
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-initialExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_INT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-initialExpression");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-contextExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_CONT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-contextExpression");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-itemContext")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_ITEM_CONT", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-itemContext");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-enableWhenExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_EN", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-enableWhenExpression");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-calculatedExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_CALC", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-calculatedExpression");
            }
            for (ResourceWrapper e : i.extensions("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-candidateExpression")) {
                this.addExpression(p, e.child("value"), this.context.formatPhrase("QUEST_CAND", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-candidateExpression");
            }
        }
        for (ResourceWrapper resourceWrapper : i.children("item")) {
            this.renderLogicItem(status, gen, r.getSubRows(), q, resourceWrapper);
        }
    }

    public void renderForm(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) throws UnsupportedEncodingException, IOException {
        XhtmlNode d = x.div();
        boolean hasPrefix = false;
        for (ResourceWrapper c : q.children("item")) {
            hasPrefix = hasPrefix || this.doesItemHavePrefix(c);
        }
        int i = 1;
        for (ResourceWrapper c : q.children("item")) {
            this.renderFormItem(status, d, q, c, hasPrefix ? null : Integer.toString(i), 0);
            ++i;
        }
    }

    private boolean doesItemHavePrefix(ResourceWrapper i) {
        if (i.has("prefix")) {
            return true;
        }
        for (ResourceWrapper c : i.children("item")) {
            if (!this.doesItemHavePrefix(c)) continue;
            return true;
        }
        return false;
    }

    private void renderFormItem(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q, ResourceWrapper i, String pfx, int indent) throws IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div().style("width: " + Integer.toString(900 - indent * 10) + "px; border-top: 1px #eeeeee solid");
        if (indent > 0) {
            d.style("margin-left: " + Integer.toString(10 * indent) + "px");
        }
        XhtmlNode display = d.div().style("display: inline-block; width: " + Integer.toString(500 - indent * 10) + "px");
        XhtmlNode details = d.div().style("border: 1px #ccccff solid; padding: 2px; display: inline-block; background-color: #fefce7; width: 380px");
        XhtmlNode p = display.para();
        String type = i.primitiveValue("type");
        String typeT = this.getTranslatedCode(i.child("type"));
        if ("group".equals(type)) {
            p = p.b();
        }
        if (i.has("prefix")) {
            p.tx(i.primitiveValue("prefix"));
            p.tx(": ");
        }
        p.span(null, "linkId: " + i.primitiveValue("linkId")).tx(i.primitiveValue("text"));
        if ("true".equals(i.primitiveValue("required"))) {
            p.span("color: red", this.context.formatPhrase("QUEST_MAND", new Object[0])).tx("*");
        }
        XhtmlNode input = null;
        switch (type) {
            case "string": {
                p.tx(" ");
                input = p.input(i.primitiveValue("linkId"), "text", typeT, 60);
                break;
            }
            case "attachment": {
                break;
            }
            case "boolean": {
                p.tx(" ");
                input = p.input(i.primitiveValue("linkId"), "checkbox", typeT, 1);
                break;
            }
            case "coding": {
                input = p.select(i.primitiveValue("linkId"));
                this.listOptions(q, i, input);
                break;
            }
            case "date": {
                p.tx(" ");
                input = p.input(i.primitiveValue("linkId"), "date", typeT, 10);
                break;
            }
            case "dateTime": {
                p.tx(" ");
                input = p.input(i.primitiveValue("linkId"), "datetime-local", typeT, 25);
                break;
            }
            case "decimal": {
                p.tx(" ");
                input = p.input(i.primitiveValue("linkId"), "number", typeT, 15);
                break;
            }
            case "display": {
                break;
            }
            case "group": {
                break;
            }
            case "integer": {
                p.tx(" ");
                input = p.input(i.primitiveValue("linkId"), "number", typeT, 10);
                break;
            }
            case "qantity": {
                p.tx(" ");
                input = p.input(i.primitiveValue("linkId"), "number", "value", 15);
                p.tx(" ");
                input = p.input(i.primitiveValue("linkId"), "unit", "unit", 10);
                break;
            }
            case "question": {
                break;
            }
            case "reference": {
                break;
            }
            case "text": {
                break;
            }
            case "time": {
                break;
            }
            case "url": {
                break;
            }
        }
        if (input != null && "true".equals(i.primitiveValue("readOnly"))) {
            input.attribute("readonly", "1");
            input.style("background-color: #eeeeee");
        }
        XhtmlNode ul = details.ul();
        boolean hasFlag = false;
        XhtmlNode flags = this.item(ul, "Flags");
        this.item(ul, "linkId", i.primitiveValue("linkId"));
        if ("true".equals(i.extensionString("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-isSubject"))) {
            hasFlag = true;
            flags.ah(this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-isSubject", "StructureDefinition-sdc-questionnaire-isSubject.html"), this.context.formatPhrase("QUEST_SUBJECT", new Object[0])).img(this.getImgPath("icon-qi-subject.png"), "icon");
        }
        if ("true".equals(i.extensionString("http://hl7.org/fhir/StructureDefinition/questionnaire-hidden"))) {
            hasFlag = true;
            flags.ah(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "extension-questionnaire-hidden.html"}), this.context.formatPhrase("QUEST_HIDDEN", new Object[0])).img(this.getImgPath("icon-qi-hidden.png"), "icon");
            d.style("background-color: #eeeeee");
        }
        if ("true".equals(i.extensionString("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay"))) {
            hasFlag = true;
            flags.ah(this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-optionalDisplay", "StructureDefinition-sdc-questionnaire-optionalDisplay.html"), this.context.formatPhrase("QUEST_DISPLAY", new Object[0])).img(this.getImgPath("icon-qi-optional.png"), "icon");
        }
        if (i.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-observationLinkPeriod")) {
            hasFlag = true;
            flags.ah(this.getSDCLink("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-observationLinkPeriod", "StructureDefinition-sdc-questionnaire-observationLinkPeriod.html"), this.context.formatPhrase("QUEST_LINKED", new Object[0])).img(this.getImgPath("icon-qi-observation.png"), "icon");
        }
        if (i.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            ResourceWrapper cc = i.extension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").child("value");
            String code = this.getCodeFromCC(cc, "http://hl7.org/fhir/questionnaire-display-category");
            hasFlag = true;
            flags.ah("https://hl7.org/fhir/R4/extension-questionnaire-displayCategory.html", this.context.formatPhrase("QUEST_CAT", new Object[]{code}) + " ").img(this.getImgPath("icon-qi-" + code + ".png"), "icon");
        }
        if (i.has("maxLength")) {
            this.item(ul, this.context.formatPhrase("GENERAL_MAX_LENGTH", new Object[0]), i.primitiveValue("maxLength"));
        }
        if (i.has("definition")) {
            this.genDefinitionLink(this.item(ul, this.context.formatPhrase("GENERAL_DEFINITION_COLON", new Object[0])), i, q);
        }
        if (i.has("enableWhen")) {
            this.item(ul, this.context.formatPhrase("QUEST_EN", new Object[0]), "todo");
        }
        if (i.has("answerValueSet")) {
            Object vs;
            XhtmlNode ans = this.item(ul, this.context.formatPhrase("QUEST_ANSWERS", new Object[0]));
            if (!Utilities.noString((String)i.primitiveValue("answerValueSet")) && i.primitiveValue("answerValueSet").startsWith("#")) {
                vs = q.getContained(i.primitiveValue("answerValueSet").substring(1));
                if (vs == null) {
                    ans.tx(i.primitiveValue("answerValueSet"));
                } else if (((ResourceWrapper)vs).getWebPath() == null) {
                    ans.ah(this.context.prefixLocalHref("#hc" + ((ResourceWrapper)vs).getScopedId())).tx(RendererFactory.factory((ResourceWrapper)vs, this.context.forContained()).buildSummary((ResourceWrapper)vs));
                } else {
                    ans.ah(this.context.prefixLocalHref(((ResourceWrapper)vs).getWebPath())).tx(RendererFactory.factory((ResourceWrapper)vs, this.context.forContained()).buildSummary((ResourceWrapper)vs));
                }
            } else {
                vs = this.context.getWorker().findTxResource(ValueSet.class, i.primitiveValue("answerValueSet"), q.getResourceNative());
                if (vs == null || !((Resource)vs).hasWebPath()) {
                    ans.tx(i.primitiveValue("answerValueSet"));
                } else {
                    ans.ah(((Resource)vs).getWebPath()).tx(((CanonicalResource)vs).present());
                }
            }
        }
        if (i.has("answerOption")) {
            this.item(ul, this.context.formatPhrase("QUEST_ANSWERS", new Object[0]), Integer.toString(i.children("answerOption").size()) + " " + Utilities.pluralize((String)"option", (int)i.children("answerOption").size()), this.context.getDefinitionsTarget() + "#item." + i.primitiveValue("linkId"));
        }
        if (i.has("initial")) {
            XhtmlNode vi = this.item(ul, this.context.formatPhrase("QUEST_INT", new Object[0]));
            boolean first = true;
            for (ResourceWrapper v : i.children("initial")) {
                if (first) {
                    first = false;
                } else {
                    vi.tx(", ");
                }
                ResourceWrapper vv = v.child("value");
                if (vv.isPrimitive()) {
                    vi.tx(vv.primitiveValue());
                    continue;
                }
                if (vv.fhirType().equals("Coding")) {
                    this.renderCoding(status, vi, vv);
                    continue;
                }
                if (vv.fhirType().equals("Reference")) {
                    this.renderReference(status, vi, vv);
                    continue;
                }
                if (!vv.fhirType().equals("Quantity")) continue;
                this.renderQuantity(status, vi, vv);
            }
        }
        if (!hasFlag) {
            ul.remove(flags);
        }
        int t = 1;
        for (ResourceWrapper c : i.children("item")) {
            this.renderFormItem(status, x, q, c, pfx == null ? null : pfx + "." + Integer.toString(t), indent + 1);
            ++t;
        }
    }

    @Nonnull
    private String getImgPath(String code) throws IOException {
        return this.context.getLocalPrefix().length() > 0 ? Utilities.path((String[])new String[]{this.context.getLocalPrefix(), code}) : Utilities.path((String[])new String[]{code});
    }

    private void item(XhtmlNode ul, String name, String value, String valueLink) {
        if (!Utilities.noString((String)value)) {
            ul.li().style("font-size: 10px").ah(this.context.prefixLocalHref(valueLink)).tx(name + ": " + value);
        }
    }

    private void item(XhtmlNode ul, String name, String value) {
        if (!Utilities.noString((String)value)) {
            ul.li().style("font-size: 10px").tx(name + ": " + value);
        }
    }

    private XhtmlNode item(XhtmlNode ul, String name) {
        XhtmlNode li = ul.li();
        li.style("font-size: 10px").tx(name + ": ");
        return li;
    }

    private void listOptions(ResourceWrapper q, ResourceWrapper i, XhtmlNode select) {
        if (i.has("answerValueSet")) {
            ValueSetExpansionOutcome exp;
            ValueSet vs = null;
            if (!Utilities.noString((String)i.primitiveValue("answerValueSet")) && i.primitiveValue("answerValueSet").startsWith("#")) {
                ResourceWrapper contained = q.getContained(i.primitiveValue("answerValueSet").substring(1));
                ValueSet valueSet = vs = contained == null ? null : (ValueSet)contained.getResourceNative();
                if (vs != null && !vs.hasUrl()) {
                    vs = vs.copy();
                    vs.setUrl(q.primitiveValue("url") + "--" + contained);
                }
            } else {
                vs = this.context.getContext().findTxResource(ValueSet.class, i.primitiveValue("answerValueSet"), q.getResourceNative());
            }
            if (vs != null && (exp = this.context.getContext().expandVS(vs, true, false)).getValueset() != null) {
                for (ValueSet.ValueSetExpansionContainsComponent cc : exp.getValueset().getExpansion().getContains()) {
                    select.option(cc.getCode(), cc.hasDisplay() ? cc.getDisplay() : cc.getCode(), false);
                }
                return;
            }
        } else if (i.has("answerOption")) {
            this.renderItemOptions(select, i);
        }
        select.option("a", "??", false);
    }

    private void renderLinks(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) {
        x.para().tx(this.context.formatPhrase("QUEST_TRY", new Object[0]));
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SELF), "package.tgz"}) + "&q=" + q.getId() + ".json").tx(this.context.formatPhrase("QUEST_NLM", new Object[0]));
    }

    private void renderDefns(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) throws IOException {
        XhtmlNode tbl = x.table("dict");
        this.renderRootDefinition(status, tbl, q, new ArrayList<ResourceWrapper>());
        for (ResourceWrapper qi : q.children("item")) {
            this.renderDefinition(status, tbl, q, qi, new ArrayList<ResourceWrapper>());
        }
    }

    private void renderRootDefinition(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper q, List<ResourceWrapper> parents) throws IOException {
        boolean first;
        boolean ext = false;
        XhtmlNode td = tbl.tr().td("structure").colspan("2").span(null, null).attribute("class", "self-link-parent");
        td.an(this.context.prefixAnchor(q.getId()));
        td.img(this.getImgPath("icon_q_root.gif"), "icon");
        td.tx(" " + this.context.formatPhrase("QUEST_QUEST", new Object[0]) + " ");
        td.b().tx(q.getId());
        this.defn(tbl, this.context.formatPhrase("GENERAL_URL", new Object[0]), q.primitiveValue("url"));
        this.defn(tbl, this.context.formatPhrase("GENERAL_VER", new Object[0]), q.primitiveValue("version"));
        this.defn(tbl, this.context.formatPhrase("GENERAL_NAME", new Object[0]), q.primitiveValue("name"));
        this.defn(tbl, this.context.formatPhrase("GENERAL_TITLE", new Object[0]), q.primitiveValue("title"));
        if (q.has("derivedFrom")) {
            td = this.defn(tbl, this.context.formatPhrase("QUEST_DERIVED", new Object[0]));
            first = true;
            for (ResourceWrapper c : q.children("derivedFrom")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.tx(c.primitiveValue());
            }
        }
        this.defn(tbl, this.context.formatPhrase("GENERAL_STATUS", new Object[0]), q.primitiveValue("status"));
        this.defn(tbl, this.context.formatPhrase("GENERAL_EXPER", new Object[0]), q.primitiveValue("experimental"));
        this.defn(tbl, this.context.formatPhrase("QUEST_PUB", new Object[0]), q.primitiveValue("date"));
        this.defn(tbl, this.context.formatPhrase("QUEST_APP", new Object[0]), q.primitiveValue("approvalDate"));
        this.defn(tbl, this.context.formatPhrase("QUEST_REV_DATE", new Object[0]), q.primitiveValue("lastReviewDate"));
        if (q.has("effectivePeriod")) {
            this.renderPeriod(status, this.defn(tbl, this.context.formatPhrase("QUEST_EFF_PERIOD", new Object[0])), q.child("effectivePeriod"));
        }
        if (q.has("subjectType")) {
            td = this.defn(tbl, this.context.formatPhrase("QUEST_SUB_TYPE", new Object[0]));
            first = true;
            for (ResourceWrapper c : q.children("subjectType")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                td.tx(c.primitiveValue());
            }
        }
        this.defn(tbl, this.context.formatPhrase("GENERAL_DESC", new Object[0]), q.primitiveValue("description"));
        this.defn(tbl, this.context.formatPhrase("GENERAL_PURPOSE", new Object[0]), q.primitiveValue("purpose"));
        this.defn(tbl, this.context.formatPhrase("GENERAL_COPYRIGHT", new Object[0]), q.primitiveValue("copyright"));
        if (q.has("code")) {
            td = this.defn(tbl, Utilities.pluralize((String)"Code", (int)q.children("code").size()));
            first = true;
            for (ResourceWrapper c : q.children("code")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                this.renderCodingWithDetails(status, td, c);
            }
        }
    }

    private void renderDefinition(Renderer.RenderingStatus status, XhtmlNode tbl, ResourceWrapper q, ResourceWrapper qi, List<ResourceWrapper> parents) throws IOException {
        XhtmlNode li;
        XhtmlNode ul;
        XhtmlNode tr;
        XhtmlNode td = tbl.tr().td("structure").colspan("2").span(null, null).attribute("class", "self-link-parent");
        td.an(this.context.prefixAnchor("item." + qi.primitiveValue("linkId")));
        for (ResourceWrapper p : parents) {
            td.ah(this.context.prefixLocalHref("#item." + p.primitiveValue("linkId"))).img(this.getImgPath("icon_q_item.png"), "icon");
            td.tx(" > ");
        }
        td.img(this.getImgPath("icon_q_item.png"), "icon");
        td.tx(" Item ");
        td.b().tx(qi.primitiveValue("linkId"));
        String type = qi.primitiveValue("type");
        this.defn(tbl, this.context.formatPhrase("QUEST_ID", new Object[0]), qi.primitiveValue("linkId"));
        this.defn(tbl, this.context.formatPhrase("QUEST_PREFIX", new Object[0]), qi.primitiveValue("prefix"));
        this.defn(tbl, this.context.formatPhrase("QUEST_TEXT", new Object[0]), qi.primitiveValue("text"));
        this.defn(tbl, this.context.formatPhrase("GENERAL_TYPE", new Object[0]), type);
        this.defn(tbl, this.context.formatPhrase("GENERAL_REQUIRED", new Object[0]), qi.primitiveValue("required"));
        this.defn(tbl, this.context.formatPhrase("QUEST_REP", new Object[0]), qi.primitiveValue("repeats"));
        this.defn(tbl, this.context.formatPhrase("QUEST_READ_ONLY", new Object[0]), qi.primitiveValue("readOnly"));
        if ("true".equals(qi.extensionString("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-isSubject"))) {
            this.defn(tbl, this.context.formatPhrase("GENERAL_SUBJ", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-isSubject", "This element changes who the subject of the question is", null);
        }
        this.defn(tbl, this.context.formatPhrase("QUEST_MAX_LENGTH", new Object[0]), qi.primitiveValue("maxLength"));
        if (qi.has("answerValueSet")) {
            this.defn(tbl, this.context.formatPhrase("GENERAL_VALUESET", new Object[0]), qi.primitiveValue("definition"), this.context.getWorker().findTxResource(ValueSet.class, qi.primitiveValue("answerValueSet"), q.getResourceNative()));
        }
        if (qi.has("answerOption")) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("QUEST_ALLOWED", new Object[0]));
            ul = tr.td().ul();
            for (ResourceWrapper ans : qi.children("answerOption")) {
                li = ul.li();
                this.renderDataType(status, li, ans.child("value"));
                if (!"true".equals(ans.primitiveValue("initialSelected"))) continue;
                li.tx(" " + this.context.formatPhrase("QUEST_INITIALLY", new Object[0]));
            }
        }
        if (qi.has("initial")) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)this.context.formatPhrase("QUEST_INITIAL_ANSWER", new Object[0]), (int)qi.children("initial").size()));
            if (qi.children("initial").size() == 1) {
                this.renderDataType(status, tr.td(), qi.firstChild("initial").child("value"));
            } else {
                ul = tr.td().ul();
                for (ResourceWrapper ans : qi.children("initial")) {
                    li = ul.li();
                    this.renderDataType(status, li, ans.child("value"));
                }
            }
        }
        if (qi.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory")) {
            tr = tbl.tr();
            tr.td().ah("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").tx("Display Category");
            this.renderDataType(status, tr.td(), qi.extension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").child("value"));
        }
        if ("true".equals(qi.extensionString("http://hl7.org/fhir/StructureDefinition/questionnaire-hidden"))) {
            this.defn(tbl, this.context.formatPhrase("QUEST_HIDDEN_ITEM", new Object[0]), "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory", "This item is a hidden question", null);
        }
        if ("true".equals(qi.extensionString("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay"))) {
            this.defn(tbl, this.context.formatPhrase("QUEST_HIDDEN_ITEM", new Object[0]), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay", "This item is optional to display", null);
        }
        if (qi.has("definition")) {
            this.genDefinitionLink(this.defn(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0])), qi, q);
        }
        if (qi.has("code")) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)this.context.formatPhrase("GENERAL_CODE", new Object[0]), (int)qi.children("code").size()));
            ul = tr.td().ul();
            for (ResourceWrapper c : qi.children("code")) {
                this.renderCodingWithDetails(status, ul.li(), c);
            }
        }
        if (qi.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-observationLinkPeriod")) {
            tr = tbl.tr();
            StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod");
            if (sd != null && sd.hasWebPath()) {
                tr.td().ah(sd.getWebPath()).tx(this.context.formatPhrase("QUEST_OBSERVATION", new Object[0]));
            } else {
                tr.td().ah("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-observationLinkPeriod").tx(this.context.formatPhrase("QUEST_OBSERVATION", new Object[0]));
            }
            this.renderDataType(status, tr.td(), qi.extension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-Questionnaire-observationLinkPeriod").child("value"));
        }
        if (qi.has("enableWhen")) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("QUEST_EN", new Object[0]));
            td = tr.td();
            if (qi.children("enableWhen").size() == 1) {
                this.renderEnableWhen(td, qi.children("enableWhen").get(0));
            } else {
                if (qi.has("enableBehavior")) {
                    td.tx(qi.primitiveValue("enableBehavior") + " " + this.context.formatPhrase("QUEST_TRUE", new Object[0]));
                } else {
                    td.tx(this.context.formatPhrase("QUEST_ARE_TRUE", new Object[0]));
                }
                ul = td.ul();
                for (ResourceWrapper ew : qi.children("enableWhen")) {
                    this.renderEnableWhen(ul.li(), ew);
                }
            }
        }
        ArrayList<ResourceWrapper> curr = new ArrayList<ResourceWrapper>();
        curr.addAll(parents);
        curr.add(qi);
        for (ResourceWrapper qic : qi.children("item")) {
            this.renderDefinition(status, tbl, q, qic, curr);
        }
    }

    private void defn(XhtmlNode tbl, String name, String url, Resource res) throws UnsupportedEncodingException, IOException {
        if (res != null && res.hasWebPath()) {
            this.defn(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]), RendererFactory.factory(res, this.context.forContained()).buildSummary(this.wrap(res)), res.getWebPath());
        } else if (Utilities.isAbsoluteUrlLinkable((String)url)) {
            this.defn(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]), url, url);
        }
        this.defn(tbl, this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]), url);
    }

    private void renderEnableWhen(XhtmlNode x, ResourceWrapper ew) {
        x.ah(this.context.prefixLocalHref("#item." + ew.primitiveValue("question"))).tx(ew.primitiveValue("question"));
        x.tx(" ");
        x.tx(ew.primitiveValue("operator"));
        x.tx(" ");
        x.tx(this.displayDataType(ew.child("Answer")));
    }

    private XhtmlNode defn(XhtmlNode tbl, String name) {
        XhtmlNode tr = tbl.tr();
        tr.td().tx(name);
        return tr.td();
    }

    private void defn(XhtmlNode tbl, String name, int value) {
        if (value > 0) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, boolean value) {
        XhtmlNode tr = tbl.tr();
        tr.td().tx(name);
        tr.td().tx(Boolean.toString(value));
    }

    private void defn(XhtmlNode tbl, String name, String value) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, String value, String url) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().ah(this.context.prefixLocalHref(url)).tx(value);
        }
    }

    private void defn(XhtmlNode tbl, String name, String nurl, String value, String url) {
        if (!Utilities.noString((String)value)) {
            XhtmlNode tr = tbl.tr();
            tr.td().ah(this.context.prefixLocalHref(nurl)).tx(name);
            if (url != null) {
                tr.td().ah(this.context.prefixLocalHref(url)).tx(value);
            } else {
                tr.td().tx(value);
            }
        }
    }

    private void defn(XhtmlNode tbl, String name, boolean value, boolean ifFalse) {
        if (ifFalse || value) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(name);
            tr.td().tx(Boolean.toString(value));
        }
    }
}

