/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class QuestionnaireResponseRenderer
extends ResourceRenderer {
    public QuestionnaireResponseRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        ResourceWrapper q = r.child("questionnaire");
        String qd = q == null ? this.context.formatPhrase("QUEST_UNSPECIFIED_QUESTIONNAIRE", new Object[0]) : this.displayCanonical(q);
        ResourceWrapper s = r.child("subject");
        String sd = s == null ? this.context.formatPhrase("QUEST_UNSPECIFIED_SUBJECT", new Object[0]) : this.displayReference(s);
        return this.context.formatPhrase("QUEST_SUMMARY", new Object[]{qd, sd});
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper qr) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(qr, x);
        switch (this.context.getQuestionnaireMode()) {
            case FORM: {
                this.renderTree(status, x, qr);
                break;
            }
            case LINKS: {
                this.renderLinks(status, x, qr);
                break;
            }
            case TREE: {
                this.renderTree(status, x, qr);
                break;
            }
            default: {
                throw new Error(this.context.formatPhrase("QUEST_UNKNOWN_MODE", new Object[0]));
            }
        }
    }

    public void renderTree(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper qr) throws UnsupportedEncodingException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator((RenderingI18nContext)this.context, this.context.getDestDir(), this.context.isInlineGraphics(), true, "");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "qtree=" + qr.getId(), false);
        model.setAlternating(true);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC), "help16.png"}));
        }
        model.setDocoRef(this.context.getLink(RenderingContext.KnownLinkType.SPEC) + "formats.html#table");
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.context.formatPhrase("QUEST_LINKID", new Object[0]), this.context.formatPhrase("QUEST_LINK", new Object[0]), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.context.formatPhrase("QUEST_TEXT", new Object[0]), this.context.formatPhrase("QUEST_TEXTFOR", new Object[0]), null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]), this.context.formatPhrase("QUEST_TIMES", new Object[0]), null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), this.context.formatPhrase("QUEST_ANSWER", new Object[0]), this.context.formatPhrase("QUEST_TYPE_ITEM", new Object[0]), null, 0));
        HierarchicalTableGenerator.Row row = this.addTreeRoot(gen, model.getRows(), qr);
        List<ResourceWrapper> items = qr.children("item");
        for (ResourceWrapper i : items) {
            this.renderTreeItem(status, gen, row.getSubRows(), qr, i);
        }
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.addChildNode(xn);
    }

    private HierarchicalTableGenerator.Row addTreeRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper qr) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        ResourceWrapper b = qr.child("questionnaire");
        String ref = b == null ? null : b.primitiveValue();
        Questionnaire q = this.context.getContext().fetchResource(Questionnaire.class, ref);
        r.setIcon("icon_q_root.gif", this.context.formatPhrase("QUEST_RESP_ROOT", new Object[0]));
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, qr.getId(), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        if (ref == null) {
            List list3 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "", null, null));
            List list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, this.context.formatPhrase("QUEST_QUESTION", new Object[0]), null, this.context.formatPhrase("QUEST_NONE_SPEC", new Object[0]), null, null));
        } else if (q == null || !q.hasWebPath()) {
            List list5 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "", null, null));
            List list6 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator6);
            list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, this.context.formatPhrase("QUEST_QUESTION", new Object[0]), null, ref, null, null));
        } else {
            List list7 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, "", null, null));
            List list8 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator8);
            list8.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator8, this.context.formatPhrase("QUEST_QUESTION", new Object[0]), q.getWebPath(), q.present(), null, null));
        }
        return r;
    }

    private boolean renderTreeItem(Renderer.RenderingStatus status, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper qr, ResourceWrapper i) throws IOException {
        boolean hasExt;
        block9: {
            String text;
            List<ResourceWrapper> answers;
            HierarchicalTableGenerator.Row r;
            block8: {
                boolean hasItem;
                r = new HierarchicalTableGenerator.Row(gen);
                rows.add(r);
                hasExt = false;
                List<ResourceWrapper> items = i.children("item");
                answers = i.children("answer");
                boolean bl = hasItem = items != null && !items.isEmpty();
                if (answers != null) {
                    for (ResourceWrapper a : answers) {
                        hasItem = a.has("item");
                    }
                }
                if (hasItem) {
                    r.setIcon("icon-q-group.png", this.context.formatPhrase("QUEST_GROUP", new Object[0]));
                } else {
                    r.setIcon("icon-q-string.png", this.context.formatPhrase("QUEST_ITEM", new Object[0]));
                }
                String linkId = i.has("linkId") ? i.primitiveValue("linkId") : "??";
                text = i.has("text") ? i.primitiveValue("text") : "";
                List list = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, (String)(this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + linkId), linkId, null, null));
                List list2 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, text, null, null));
                List list3 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator3);
                list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, null, null, null));
                if (answers != null && answers.size() != 0) break block8;
                List list4 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null));
                if (items == null) break block9;
                for (ResourceWrapper si : items) {
                    this.renderTreeItem(status, gen, r.getSubRows(), qr, si);
                }
                break block9;
            }
            if (answers.size() == 1) {
                ResourceWrapper ans = answers.get(0);
                this.renderAnswer(status, gen, qr, r, ans);
            } else {
                List list = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null));
                for (ResourceWrapper ans : answers) {
                    HierarchicalTableGenerator.Row ar = new HierarchicalTableGenerator.Row(gen);
                    ar.setIcon("icon-q-string.png", "Item");
                    ar.getSubRows().add(ar);
                    List list5 = ar.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator5);
                    list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, null, null, null));
                    List list6 = ar.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator6);
                    list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, text, null, null));
                    List list7 = ar.getCells();
                    HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator7);
                    list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, null, null, null));
                    this.renderAnswer(status, gen, qr, ar, ans);
                }
            }
        }
        return hasExt;
    }

    public void renderAnswer(Renderer.RenderingStatus status, HierarchicalTableGenerator gen, ResourceWrapper qr, HierarchicalTableGenerator.Row r, ResourceWrapper ans) throws UnsupportedEncodingException, IOException {
        ResourceWrapper b = ans.child("value[x]");
        if (b == null) {
            List list = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "null!", null, null));
        } else if (b.isPrimitive()) {
            List list = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, b.primitiveValue(), null, null));
        } else {
            XhtmlNode x = new XhtmlNode(NodeType.Element, "span");
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null);
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            HierarchicalTableGenerator.Piece p = new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, "span");
            p.getChildren().add(x);
            cell.addPiece(p);
            this.renderDataType(status, x, b);
            r.getCells().add(cell);
        }
        for (ResourceWrapper si : ans.children("item")) {
            this.renderTreeItem(status, gen, r.getSubRows(), qr, si);
        }
    }

    private boolean renderTreeItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, QuestionnaireResponse q, QuestionnaireResponse.QuestionnaireResponseItemComponent i) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        boolean hasExt = false;
        boolean hasItem = i.hasItem();
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent a : i.getAnswer()) {
            hasItem = a.hasItem();
        }
        if (hasItem) {
            r.setIcon("icon-q-group.png", this.context.formatPhrase("QUEST_GROUP", new Object[0]));
        } else {
            r.setIcon("icon-q-string.png", this.context.formatPhrase("QUEST_ITEM", new Object[0]));
        }
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, (String)(this.context.getDefinitionsTarget() == null ? "" : this.context.getDefinitionsTarget() + "#item." + i.getLinkId()), i.getLinkId(), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, i.getText(), null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, null, null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null));
        return hasExt;
    }

    public void genDefinitionLink(HierarchicalTableGenerator gen, QuestionnaireResponse.QuestionnaireResponseItemComponent i, HierarchicalTableGenerator.Cell defn, Resource src) {
        StructureDefinition sd;
        String path = null;
        String d = i.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d, src)) != null) {
            String url = sd.getWebPath();
            if (url != null) {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url + "#" + path, path, null));
            } else {
                List list = defn.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.getDefinition(), null));
            }
        } else {
            List list = defn.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, i.getDefinition(), null));
        }
    }

    public void genDefinitionLink(XhtmlNode x, QuestionnaireResponse.QuestionnaireResponseItemComponent i, Resource src) {
        StructureDefinition sd;
        String path = null;
        String d = i.getDefinition();
        if (d.contains("#")) {
            path = d.substring(d.indexOf("#") + 1);
            d = d.substring(0, d.indexOf("#"));
        }
        if ((sd = this.context.getWorker().fetchResource(StructureDefinition.class, d, src)) != null) {
            String url = sd.getWebPath();
            if (url != null) {
                x.ah(this.context.prefixLocalHref(url + "#" + path)).tx(path);
            } else {
                x.tx(i.getDefinition());
            }
        } else {
            x.tx(i.getDefinition());
        }
    }

    private void addExpression(HierarchicalTableGenerator.Piece p, Expression exp, String label, String url) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "li").style("font-size: 11px");
        p.addHtml(x);
        x.ah(this.context.prefixLocalHref(url)).tx(label);
        x.tx(": ");
        x.code(exp.getExpression());
    }

    public boolean renderForm(XhtmlNode x, QuestionnaireResponse q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        return false;
    }

    public boolean renderForm(XhtmlNode x, ResourceWrapper q) throws UnsupportedEncodingException, IOException {
        boolean hasExt = false;
        XhtmlNode d = x.div();
        d.tx(this.context.formatPhrase("GENERAL_TODO", new Object[0]));
        return hasExt;
    }

    private boolean renderLinks(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) {
        x.para().tx(this.context.formatPhrase("QUEST_TRY_QUEST", new Object[0]));
        XhtmlNode ul = x.ul();
        ul.li().ah("http://todo.nlm.gov/path?mode=ig&src=" + Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SELF), "package.tgz"}) + "&q=" + q.getId() + ".json").tx(this.context.formatPhrase("QUEST_NLM", new Object[0]));
        return false;
    }
}

