/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import java.util.Collection;
import java.util.Locale;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ResourceWrapperNative
extends ResourceWrapper {
    protected Base element;

    ResourceWrapperNative() {
    }

    private ResourceWrapper makeChild(String name, int index, ResourceWrapper.ElementKind kind, Base element) {
        ResourceWrapperNative self = new ResourceWrapperNative();
        self.contextUtils = this.contextUtils;
        self.parent = this;
        self.name = name;
        self.index = index;
        self.kind = kind;
        self.element = element;
        return self;
    }

    @Override
    public String fhirVersion() {
        return this.element.getFHIRPublicationVersion().toCode();
    }

    @Override
    public String fhirType() {
        if (this.kind == ResourceWrapper.ElementKind.BackboneElement) {
            return this.basePath();
        }
        return this.element.fhirType();
    }

    @Override
    public boolean isPrimitive() {
        return this.element.isPrimitive();
    }

    @Override
    public boolean hasPrimitiveValue() {
        return this.element.hasPrimitiveValue();
    }

    @Override
    public String primitiveValue() {
        return this.element.primitiveValue();
    }

    @Override
    protected void loadTheChildren() {
        for (Property p : this.element.children()) {
            String name = p.getName();
            int i = 0;
            for (Base v : p.getValues()) {
                this.loadElementChild(p, name, i, v);
                ++i;
            }
        }
    }

    private void loadElementChild(Property p, String name, int i, Base v) {
        ResourceWrapper.ElementKind kind = this.determineModelKind(p, v);
        int index = p.isList() ? i : -1;
        Object ed = null;
        this.children.add(this.makeChild(name, index, kind, v));
    }

    private ResourceWrapper.ElementKind determineModelKind(Property p, Base v) {
        if (v.isPrimitive()) {
            return ResourceWrapper.ElementKind.PrimitiveType;
        }
        if (this.contextUtils.isDatatype(v.fhirType())) {
            return ResourceWrapper.ElementKind.DataType;
        }
        if (!v.isResource()) {
            return ResourceWrapper.ElementKind.BackboneElement;
        }
        if ("Bundle.entry".equals(this.fhirType()) && "resource".equals(p.getName())) {
            return ResourceWrapper.ElementKind.BundleEntry;
        }
        if ("Bundle".equals(this.fhirType()) && "outcome".equals(p.getName())) {
            return ResourceWrapper.ElementKind.InlineResource;
        }
        if ("Bundle".equals(this.fhirType()) && "issues".equals(p.getName())) {
            return ResourceWrapper.ElementKind.InlineResource;
        }
        if (this.isResource() && "contained".equals(p.getName())) {
            return ResourceWrapper.ElementKind.ContainedResource;
        }
        return ResourceWrapper.ElementKind.InlineResource;
    }

    @Override
    public boolean isResource() {
        return this.element.isResource();
    }

    @Override
    public boolean canHaveNarrative() {
        if (!this.isResource()) {
            return false;
        }
        return this.element instanceof DomainResource;
    }

    @Override
    public XhtmlNode getNarrative() {
        if (!this.canHaveNarrative()) {
            return null;
        }
        ResourceWrapper text = this.child("text");
        if (text == null) {
            return null;
        }
        ResourceWrapper div = text.child("div");
        if (div == null) {
            return null;
        }
        return ((ResourceWrapperNative)div).element.getXhtml();
    }

    @Override
    public boolean hasNarrative() {
        if (!this.canHaveNarrative()) {
            return false;
        }
        ResourceWrapper text = this.child("text");
        if (text == null) {
            return false;
        }
        ResourceWrapper div = text.child("div");
        if (div == null) {
            return false;
        }
        return ((ResourceWrapperNative)div).element.getXhtml() != null;
    }

    @Override
    public void setNarrative(XhtmlNode x, String status, boolean multiLangMode, Locale locale, boolean isPretty) {
        if (this.element instanceof DomainResource) {
            DomainResource r = (DomainResource)this.element;
            r.getText().setUserData("renderer.generated", true);
            if (!r.hasText() || !r.getText().hasDiv()) {
                r.setText(new Narrative());
                r.getText().setStatusAsString(status);
            }
            if (multiLangMode) {
                if (!r.getText().hasDiv()) {
                    XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
                    div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                    r.getText().setDiv(div);
                } else {
                    r.getText().getDiv().getChildNodes().removeIf(c -> !"div".equals(c.getName()) || !c.hasAttribute("xml:lang"));
                }
                this.markLanguage(x, locale);
                r.getText().getDiv().addChildNode(x);
            } else {
                if (!x.hasAttribute("xmlns")) {
                    x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                }
                if (r.hasLanguage()) {
                    x.setAttribute("lang", r.getLanguage());
                    x.setAttribute("xml:lang", r.getLanguage());
                }
                r.getText().setDiv(x);
            }
        } else {
            throw new Error("Cannot call setNarrative on a " + this.element.fhirType());
        }
    }

    @Override
    public void markLanguage(XhtmlNode x, Locale locale) {
        x.setAttribute("lang", locale.toString());
        x.setAttribute("xml:lang", locale.toString());
        x.addTag(0, "hr");
        x.addTag(0, "p").b().tx(locale.getDisplayName());
        x.addTag(0, "hr");
    }

    @Override
    public String getId() {
        return this.element.getIdBase();
    }

    public String toString() {
        return this.name + (String)(this.index == -1 ? "" : "[" + this.index + "]") + ": " + this.fhirType() + " (" + this.kind + "/" + this.path() + "): native = " + this.element.fhirType() + " -> " + this.element.toString();
    }

    @Override
    public Resource getResourceNative() {
        ResourceWrapper focus = this.getResourceWrapper();
        return focus == null ? null : (Resource)((ResourceWrapperNative)focus).element;
    }

    @Override
    public boolean hasFormatComment() {
        return this.element.hasFormatComment();
    }

    @Override
    public Collection<String> getFormatCommentsPre() {
        return this.element.getFormatCommentsPre();
    }

    @Override
    public XhtmlNode getXhtml() {
        return this.element.getXhtml();
    }

    @Override
    public Base getBase() {
        return this.element;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public String getWebPath() {
        if (this.isResource()) {
            return ((Resource)this.element).getWebPath();
        }
        return null;
    }

    @Override
    public String getCodeSystemUri() {
        if (this.element instanceof Enumeration) {
            return ((Enumeration)this.element).getSystem();
        }
        return null;
    }
}

