/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.validation;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.LanguageUtils;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.providers.CodeSystemProvider;
import org.hl7.fhir.r5.terminologies.providers.SpecialCodeSystem;
import org.hl7.fhir.r5.terminologies.providers.URICodeSystem;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyOperationContext;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.terminologies.utilities.ValueSetProcessBase;
import org.hl7.fhir.r5.terminologies.validation.ConceptReferencePair;
import org.hl7.fhir.r5.terminologies.validation.VSCheckerException;
import org.hl7.fhir.r5.terminologies.validation.ValidationProcessInfo;
import org.hl7.fhir.r5.terminologies.validation.VersionInfo;
import org.hl7.fhir.r5.utils.OperationOutcomeUtilities;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.i18n.AcceptLanguageHeader;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class ValueSetValidator
extends ValueSetProcessBase {
    public static final String NO_TRY_THE_SERVER = "The local terminology server cannot handle this request";
    private ValueSet valueset;
    private Map<String, ValueSetValidator> inner = new HashMap<String, ValueSetValidator>();
    private ValidationOptions options;
    private ValidationContextCarrier localContext;
    private List<CodeSystem> localSystems = new ArrayList<CodeSystem>();
    protected Parameters expansionProfile;
    private TerminologyClientManager tcm;
    private Set<String> unknownSystems;
    private Set<String> unknownValueSets = new HashSet<String>();
    private boolean throwToServer;
    private static final Set<String> SERVER_SIDE_LIST = new HashSet<String>(Arrays.asList("http://fdasis.nlm.nih.gov", "http://hl7.org/fhir/sid/ndc", "http://loinc.org", "http://snomed.info/sct", "http://unitsofmeasure.org", "http://unstats.un.org/unsd/methods/m49/m49.htm", "http://varnomen.hgvs.org", "http://www.nlm.nih.gov/research/umls/rxnorm", "https://www.usps.com/", "urn:ietf:bcp:13", "urn:ietf:bcp:47", "urn:ietf:rfc:3986", "urn:iso:std:iso:3166", "urn:iso:std:iso:4217", "urn:oid:1.2.36.1.2001.1005.17"));

    public ValueSetValidator(IWorkerContext context, TerminologyOperationContext opContext, ValidationOptions options, ValueSet source, Parameters expansionProfile, TerminologyClientManager tcm) {
        super(context, opContext);
        this.valueset = source;
        this.options = options;
        this.expansionProfile = expansionProfile;
        this.tcm = tcm;
        this.analyseValueSet();
    }

    public ValueSetValidator(IWorkerContext context, TerminologyOperationContext opContext, ValidationOptions options, ValueSet source, ValidationContextCarrier ctxt, Parameters expansionProfile, TerminologyClientManager tcm) {
        super(context, opContext);
        this.valueset = source;
        this.options = options.copy();
        this.options.setEnglishOk(true);
        this.localContext = ctxt;
        this.expansionProfile = expansionProfile;
        this.tcm = tcm;
        this.analyseValueSet();
    }

    public Set<String> getUnknownSystems() {
        return this.unknownSystems;
    }

    public void setUnknownSystems(Set<String> unknownSystems) {
        this.unknownSystems = unknownSystems;
    }

    public boolean isThrowToServer() {
        return this.throwToServer;
    }

    public void setThrowToServer(boolean throwToServer) {
        this.throwToServer = throwToServer;
    }

    private void analyseValueSet() {
        this.opContext.note("analyse");
        if (this.valueset != null) {
            this.opContext.note("vs = " + this.valueset.getVersionedUrl());
            this.opContext.seeContext(this.valueset.getVersionedUrl());
            for (Extension s : this.valueset.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-supplement")) {
                this.requiredSupplements.add(s.getValue().primitiveValue());
            }
        } else {
            this.opContext.note("vs = null");
        }
        this.altCodeParams.seeParameters(this.expansionProfile);
        this.altCodeParams.seeValueSet(this.valueset);
        if (this.localContext != null && this.valueset != null) {
            for (ValueSet.ConceptSetComponent i : this.valueset.getCompose().getInclude()) {
                this.analyseComponent(i, "inc" + i);
            }
            for (ValueSet.ConceptSetComponent i : this.valueset.getCompose().getExclude()) {
                this.analyseComponent(i, "exc" + i);
            }
        }
        this.opContext.note("analysed");
    }

    private void analyseComponent(ValueSet.ConceptSetComponent i, String name) {
        this.opContext.deadCheck("analyse Component " + name);
        if (i.getSystemElement().hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-system")) {
            String ref = i.getSystemElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-system");
            if (ref.startsWith("#")) {
                String id = ref.substring(1);
                for (ValidationContextCarrier.ValidationContextResourceProxy t : this.localContext.getResources()) {
                    CodeSystem cs = (CodeSystem)t.loadContainedResource(id, CodeSystem.class);
                    if (cs == null) continue;
                    this.localSystems.add(cs);
                }
            } else {
                throw new Error("Not done yet #2: " + ref);
            }
        }
    }

    public ValidationResult validateCode(CodeableConcept code) throws FHIRException {
        return this.validateCode("CodeableConcept", code);
    }

    public ValidationResult validateCode(String path, CodeableConcept code) throws FHIRException {
        Object cd;
        this.opContext.deadCheck("validate " + code.toString());
        this.checkValueSetOptions();
        ValidationProcessInfo info = new ValidationProcessInfo();
        if (this.throwToServer) {
            this.checkValueSetLoad(info);
        }
        CodeableConcept vcc = new CodeableConcept();
        ArrayList<ValidationResult> resList = new ArrayList<ValidationResult>();
        if (!this.options.isMembershipOnly()) {
            int i = 0;
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem() && !c.hasUserData("val.sys.error")) {
                    c.setUserData("val.sys.error", true);
                    info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.INVALID, path + ".coding[" + i + "]", this.context.formatMessage("Coding_has_no_system__cannot_validate", new Object[0]), ValueSetProcessBase.OpIssueCode.InvalidData, null));
                } else {
                    VersionInfo vi = new VersionInfo(this);
                    this.checkExpansion(c, vi);
                    this.checkInclude(c, vi);
                    CodeSystem cs = this.resolveCodeSystem(c.getSystem(), vi.getVersion(c.getSystem(), c.getVersion()));
                    ValidationResult res = null;
                    if (cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE) {
                        Object msg;
                        if (this.context.isNoTerminologyServer()) {
                            if (c.hasVersion()) {
                                msg = this.context.formatMessage("UNKNOWN_CODESYSTEM_VERSION", c.getSystem(), c.getVersion(), this.resolveCodeSystemVersions(c.getSystem()).toString());
                                this.unknownSystems.add(c.getSystem() + "|" + c.getVersion());
                                res = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, (String)msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path + ".coding[" + i + "].system", (String)msg, ValueSetProcessBase.OpIssueCode.NotFound, null)).setUnknownSystems(this.unknownSystems);
                            } else {
                                msg = this.context.formatMessage("UNKNOWN_CODESYSTEM", c.getSystem(), c.getVersion());
                                this.unknownSystems.add(c.getSystem());
                                res = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, (String)msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, path + ".coding[" + i + "].system", (String)msg, ValueSetProcessBase.OpIssueCode.NotFound, null)).setUnknownSystems(this.unknownSystems);
                            }
                        } else {
                            res = this.context.validateCode(this.options.withNoClient(), c, null);
                            if (res.isOk()) {
                                vcc.addCoding(new Coding().setCode(res.getCode()).setVersion(res.getVersion()).setSystem(res.getSystem()).setDisplay(res.getDisplay()));
                            }
                            for (OperationOutcome.OperationOutcomeIssueComponent iss : res.getIssues()) {
                                if (iss.getSeverity() == OperationOutcome.IssueSeverity.ERROR && iss.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "not-found")) {
                                    iss.setSeverity(OperationOutcome.IssueSeverity.WARNING);
                                    res.setSeverity(ValidationMessage.IssueSeverity.WARNING);
                                }
                                iss.resetPath("Coding", path + ".coding[" + i + "]");
                            }
                            if (res.isInactive()) {
                                msg = this.context.formatMessage("STATUS_CODE_WARNING_CODE", "not active", c.getCode());
                                res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.INFORMATION, OperationOutcome.IssueType.INVALID, path + ".coding[" + i + "].code", (String)msg, ValueSetProcessBase.OpIssueCode.CodeRule, res.getServer()));
                            }
                        }
                    } else {
                        c.setUserData("cs", cs);
                        this.checkCanonical(info.getIssues(), path, cs, this.valueset);
                        res = this.validateCode(path + ".coding[" + i + "]", c, cs, vcc, info);
                    }
                    info.getIssues().addAll(res.getIssues());
                    if (res != null) {
                        resList.add(res);
                        if (!res.isOk() && !res.messageIsInIssues()) {
                            if (res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                                info.getIssues().addAll(this.makeIssue(res.getSeverity(), OperationOutcome.IssueType.NOTFOUND, path + ".coding[" + i + "]", res.getMessage(), ValueSetProcessBase.OpIssueCode.NotFound, res.getServer()));
                            } else {
                                info.getIssues().addAll(this.makeIssue(res.getSeverity(), OperationOutcome.IssueType.CODEINVALID, path + ".coding[" + i + "]", res.getMessage(), ValueSetProcessBase.OpIssueCode.InvalidCode, res.getServer()));
                            }
                        }
                    }
                }
                ++i;
            }
        }
        Coding foundCoding = null;
        String msg = null;
        Boolean result = false;
        if (this.valueset != null) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(", ");
            ArrayList<CallSite> cpath = new ArrayList<CallSite>();
            int i = 0;
            for (Coding c : code.getCoding()) {
                String cs = "'" + c.getSystem() + (String)(c.hasVersion() ? "|" + c.getVersion() : "") + "#" + c.getCode() + (String)(c.hasDisplay() ? " ('" + c.getDisplay() + "')" : "") + "'";
                String cs2 = c.getSystem() + (String)(c.hasVersion() ? "|" + c.getVersion() : "");
                cpath.add((CallSite)((Object)(path + ".coding[" + i + "]")));
                b.append(cs2);
                Boolean ok = this.codeInValueSet(path, c.getSystem(), c.getVersion(), c.getCode(), info);
                if (ok == null && result != null && !result.booleanValue()) {
                    result = null;
                } else if (ok != null && ok.booleanValue()) {
                    result = true;
                    foundCoding = c;
                    if (!this.options.isMembershipOnly()) {
                        vcc.addCoding().setSystem(c.getSystem()).setVersion(c.getVersion()).setCode(c.getCode());
                    }
                }
                if (ok == null || !ok.booleanValue()) {
                    vcc.removeCoding(c.getSystem(), c.getVersion(), c.getCode());
                }
                if (ok != null && !ok.booleanValue()) {
                    msg = this.context.formatMessage("None_of_the_provided_codes_are_in_the_value_set_one", null, this.valueset.getVersionedUrl(), cs);
                    info.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.INFORMATION, OperationOutcome.IssueType.CODEINVALID, path + ".coding[" + i + "].code", msg, ValueSetProcessBase.OpIssueCode.ThisNotInVS, null));
                }
                ++i;
            }
            if (result == null) {
                msg = !this.unknownValueSets.isEmpty() ? this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_VS", this.valueset.getVersionedUrl(), CommaSeparatedStringBuilder.join((String)", ", this.unknownValueSets)) : this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_CS", this.valueset.getVersionedUrl(), b.toString());
                info.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, this.unknownSystems.isEmpty() && this.unknownValueSets.isEmpty() ? OperationOutcome.IssueType.CODEINVALID : OperationOutcome.IssueType.NOTFOUND, null, msg, ValueSetProcessBase.OpIssueCode.VSProcessing, null));
            } else if (!result.booleanValue()) {
                OperationOutcome.OperationOutcomeIssueComponent iss = new OperationOutcome.OperationOutcomeIssueComponent(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID);
                iss.getDetails().setText(this.context.formatMessage("TX_GENERAL_CC_ERROR_MESSAGE", this.valueset.getVersionedUrl()));
                iss.getDetails().addCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", ValueSetProcessBase.OpIssueCode.NotInVS.toCode(), null);
                info.getIssues().add(iss);
            }
        }
        if (vcc.hasCoding() && code.hasText()) {
            vcc.setText(code.getText());
        }
        if (!this.checkRequiredSupplements(info)) {
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, info.getIssues().get(info.getIssues().size() - 1).getDetails().getText(), info.getIssues());
        }
        if (info.hasErrors()) {
            ValidationResult res = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, info.summary(), info.getIssues());
            if (foundCoding != null) {
                cd = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
                ((CodeSystem.ConceptDefinitionComponent)cd).setDisplay(this.lookupDisplay(foundCoding));
                res.setDefinition((CodeSystem.ConceptDefinitionComponent)cd);
                res.setSystem(foundCoding.getSystem());
                res.setVersion(foundCoding.hasVersion() ? foundCoding.getVersion() : (foundCoding.hasUserData("cs") ? ((CodeSystem)foundCoding.getUserData("cs")).getVersion() : null));
                res.setDisplay(((CodeSystem.ConceptDefinitionComponent)cd).getDisplay());
            }
            if (info.getErr() != null) {
                res.setErrorClass(info.getErr());
            }
            res.setUnknownSystems(this.unknownSystems);
            res.addCodeableConcept(vcc);
            return res;
        }
        if (result == null) {
            return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, info.summary(), info.getIssues());
        }
        if (foundCoding == null && this.valueset != null) {
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Internal Error that should not happen", this.makeIssue(ValidationMessage.IssueSeverity.FATAL, OperationOutcome.IssueType.EXCEPTION, path, "Internal Error that should not happen", ValueSetProcessBase.OpIssueCode.VSProcessing, null));
        }
        if (info.getIssues().size() > 0) {
            if (foundCoding == null) {
                ValidationMessage.IssueSeverity lvl = ValidationMessage.IssueSeverity.INFORMATION;
                for (OperationOutcome.OperationOutcomeIssueComponent iss : info.getIssues()) {
                    lvl = ValidationMessage.IssueSeverity.max((ValidationMessage.IssueSeverity)lvl, (ValidationMessage.IssueSeverity)OperationOutcomeUtilities.convert(iss.getSeverity()));
                }
                return new ValidationResult(lvl, info.summary(), info.getIssues());
            }
            String disp = this.lookupDisplay(foundCoding);
            cd = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
            ((CodeSystem.ConceptDefinitionComponent)cd).setDisplay(disp);
            return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, info.summaryList(), foundCoding.getSystem(), this.getVersion(foundCoding), (CodeSystem.ConceptDefinitionComponent)cd, disp, info.getIssues()).addCodeableConcept(vcc);
        }
        if (!result.booleanValue()) {
            if (this.valueset != null) {
                throw new Error("what?");
            }
            if (vcc.hasCoding()) {
                return new ValidationResult(vcc.getCodingFirstRep().getSystem(), this.getVersion(vcc.getCodingFirstRep()), new CodeSystem.ConceptDefinitionComponent(vcc.getCodingFirstRep().getCode()).setDisplay(vcc.getCodingFirstRep().getDisplay()), vcc.getCodingFirstRep().getDisplay()).addCodeableConcept(vcc);
            }
            throw new Error("what?");
        }
        if (foundCoding != null) {
            CodeSystem.ConceptDefinitionComponent cd2 = new CodeSystem.ConceptDefinitionComponent(foundCoding.getCode());
            cd2.setDisplay(this.lookupDisplay(foundCoding));
            return new ValidationResult(foundCoding.getSystem(), this.getVersion(foundCoding), cd2, this.getPreferredDisplay(cd2, null)).addCodeableConcept(vcc);
        }
        throw new Error("what?");
    }

    private void checkValueSetLoad(ValidationProcessInfo info) {
        int serverCount = this.getServerLoad(info);
        if (serverCount > 2) {
            throw new VSCheckerException("This value set is better processed on the server for performance reasons", null, true);
        }
    }

    private int getServerLoad(ValidationProcessInfo info) {
        int serverCount = 0;
        if (this.valueset != null) {
            for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
                serverCount += this.checkValueSetLoad(inc, info);
            }
            for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getExclude()) {
                serverCount += this.checkValueSetLoad(inc, info);
            }
        }
        return serverCount;
    }

    private int checkValueSetLoad(ValueSet.ConceptSetComponent inc, ValidationProcessInfo info) {
        int serverCount = 0;
        for (UriType uriType : inc.getValueSet()) {
            ValueSetValidator vsv = this.getVs((String)uriType.getValue(), info);
            serverCount += vsv.getServerLoad(info);
        }
        CodeSystem cs = this.resolveCodeSystem(inc.getSystem(), inc.getVersion());
        if (cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
            ++serverCount;
        }
        return serverCount;
    }

    private boolean checkRequiredSupplements(ValidationProcessInfo info) {
        if (!this.requiredSupplements.isEmpty()) {
            String msg = this.context.formatMessagePlural(this.requiredSupplements.size(), "VALUESET_SUPPLEMENT_MISSING", CommaSeparatedStringBuilder.build((List)this.requiredSupplements));
            throw new TerminologyOperationContext.TerminologyServiceProtectionException(msg, TerminologyServiceErrorClass.BUSINESS_RULE, OperationOutcome.IssueType.NOTFOUND);
        }
        return this.requiredSupplements.isEmpty();
    }

    private boolean valueSetDependsOn(String system, String version) {
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!system.equals(inc.getSystem()) || version != null && inc.getVersion() != null && !version.equals(inc.getVersion())) continue;
            return true;
        }
        return false;
    }

    private String getVersion(Coding c) {
        if (c.hasVersion()) {
            return c.getVersion();
        }
        if (c.hasUserData("cs")) {
            return ((CodeSystem)c.getUserData("cs")).getVersion();
        }
        return null;
    }

    private String lookupDisplay(Coding c) {
        CodeSystem.ConceptDefinitionComponent cd;
        CodeSystem cs = this.resolveCodeSystem(c.getSystem(), c.getVersion());
        if (cs != null && (cd = CodeSystemUtilities.findCodeOrAltCode(cs.getConcept(), c.getCode(), null)) != null) {
            return this.getPreferredDisplay(cd, cs);
        }
        return null;
    }

    public CodeSystem resolveCodeSystem(String system, String version) {
        for (CodeSystem t : this.localSystems) {
            if (!t.getUrl().equals(system) || !this.versionsMatch(version, t.getVersion())) continue;
            return t;
        }
        CodeSystem cs = this.context.fetchSupplementedCodeSystem(system, version);
        if (cs == null) {
            cs = this.findSpecialCodeSystem(system, version);
        }
        return cs;
    }

    public List<String> resolveCodeSystemVersions(String system) {
        ArrayList<String> res = new ArrayList<String>();
        for (CodeSystem t : this.localSystems) {
            if (!t.getUrl().equals(system) || !t.hasVersion()) continue;
            res.add(t.getVersion());
        }
        res.addAll(new ContextUtilities(this.context).fetchCodeSystemVersions(system));
        return res;
    }

    private boolean versionsMatch(String versionTest, String versionActual) {
        return versionTest == null && VersionUtilities.versionsMatch((String)versionTest, (String)versionActual);
    }

    public ValidationResult validateCode(Coding code) throws FHIRException {
        return this.validateCode("Coding", code);
    }

    /*
     * WARNING - void declaration
     */
    public ValidationResult validateCode(String path, Coding code) throws FHIRException {
        String msg;
        String wv;
        this.opContext.deadCheck("validate " + code.toString());
        this.checkValueSetOptions();
        Object warningMessage = null;
        ValidationResult res = null;
        boolean inExpansion = false;
        boolean inInclude = false;
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        ValidationProcessInfo info = new ValidationProcessInfo(issues);
        VersionInfo vi = new VersionInfo(this);
        this.checkCanonical(issues, path, this.valueset, this.valueset);
        String system = code.getSystem();
        if (!this.options.isMembershipOnly()) {
            if (system == null && !code.hasDisplay() && this.options.isGuessSystem()) {
                ArrayList<StringWithCode> problems = new ArrayList<StringWithCode>();
                system = this.systemForCodeInValueSet(code.getCode(), problems);
                if (system == null) {
                    if (problems.size() == 0) {
                        throw new Error("Unable to resolve systems but no reason why");
                    }
                    if (problems.size() == 1) {
                        String msg2 = this.context.formatMessagePlural(1, "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getVersionedUrl(), "'" + code.toString() + "'");
                        issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, "code", msg2, ValueSetProcessBase.OpIssueCode.NotInVS, null));
                        issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, "code", ((StringWithCode)problems.get(0)).getMessage(), ((StringWithCode)problems.get(0)).getCode(), null));
                        return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((StringWithCode)problems.get(0)).getMessage() + "; " + msg2, issues);
                    }
                    CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("; ");
                    for (StringWithCode stringWithCode : problems) {
                        b.append(stringWithCode.getMessage());
                    }
                    ValidationResult vr = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, b.toString(), null);
                    for (StringWithCode s : problems) {
                        vr.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.UNKNOWN, path, s.getMessage(), s.getCode(), vr.getServer()));
                    }
                    return vr;
                }
            }
            if (!code.hasSystem()) {
                if (this.options.isGuessSystem() && system == null && Utilities.isAbsoluteUrl((String)code.getCode())) {
                    system = "urn:ietf:rfc:3986";
                }
                code.setSystem(system);
            }
            if (!code.hasSystem()) {
                res = new ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.context.formatMessage("Coding_has_no_system__cannot_validate", new Object[0]), null);
                if (!code.hasUserData("val.sys.error")) {
                    code.setUserData("val.sys.error", true);
                    res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.INVALID, path, this.context.formatMessage("Coding_has_no_system__cannot_validate", new Object[0]), ValueSetProcessBase.OpIssueCode.InvalidData, null));
                }
            } else {
                if (!Utilities.isAbsoluteUrl((String)system)) {
                    String msg3 = this.context.formatMessage("Terminology_TX_System_Relative", new Object[0]);
                    issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path + ".system", msg3, ValueSetProcessBase.OpIssueCode.InvalidData, null));
                }
                inExpansion = this.checkExpansion(code, vi);
                inInclude = this.checkInclude(code, vi);
                wv = vi.getVersion(system, code.getVersion());
                CodeSystem cs = this.resolveCodeSystem(system, wv);
                if (cs == null) {
                    ValueSetProcessBase.OpIssueCode oic = ValueSetProcessBase.OpIssueCode.NotFound;
                    OperationOutcome.IssueType issueType = OperationOutcome.IssueType.NOTFOUND;
                    ValueSet vs = this.context.fetchResource(ValueSet.class, system);
                    if (vs != null) {
                        warningMessage = this.context.formatMessage("Terminology_TX_System_ValueSet2", system);
                        oic = ValueSetProcessBase.OpIssueCode.InvalidData;
                        OperationOutcome.IssueType issueType2 = OperationOutcome.IssueType.INVALID;
                    } else if (wv == null) {
                        warningMessage = this.context.formatMessage("UNKNOWN_CODESYSTEM", system);
                        this.unknownSystems.add(system);
                    } else {
                        warningMessage = this.context.formatMessage("UNKNOWN_CODESYSTEM_VERSION", system, wv, this.resolveCodeSystemVersions(system).toString());
                        this.unknownSystems.add(system + "|" + wv);
                    }
                    if (!inExpansion) {
                        void var14_21;
                        if (this.valueset != null && this.valueset.hasExpansion()) {
                            String msg4 = this.context.formatMessage("CODESYSTEM_CS_UNK_EXPANSION", this.valueset.getUrl(), code.getSystem(), code.getCode().toString());
                            issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, (OperationOutcome.IssueType)var14_21, path, msg4, ValueSetProcessBase.OpIssueCode.VSProcessing, null));
                            throw new VSCheckerException(msg4, issues, TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
                        }
                        issues.addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, (OperationOutcome.IssueType)var14_21, path + ".system", (String)warningMessage, oic, null));
                        res = new ValidationResult(ValidationMessage.IssueSeverity.WARNING, (String)warningMessage, issues);
                        if (this.valueset == null) {
                            throw new VSCheckerException((String)warningMessage, issues, TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
                        }
                    }
                } else {
                    this.checkCanonical(issues, path, cs, this.valueset);
                }
                if (cs != null && cs.hasSupplements()) {
                    msg = this.context.formatMessage("CODESYSTEM_CS_NO_SUPPLEMENT", cs.getUrl());
                    return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.INVALID, path + ".system", msg, ValueSetProcessBase.OpIssueCode.InvalidData, null));
                }
                if (cs != null && cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE) {
                    warningMessage = "Resolved system " + system + (String)(cs.hasVersion() ? " (v" + cs.getVersion() + ")" : "") + ", but the definition ";
                    switch (cs.getContent()) {
                        case EXAMPLE: {
                            warningMessage = (String)warningMessage + "only has example content";
                            break;
                        }
                        case FRAGMENT: {
                            warningMessage = (String)warningMessage + "is only a fragment";
                            break;
                        }
                        case NOTPRESENT: {
                            warningMessage = (String)warningMessage + "doesn't include any codes";
                            break;
                        }
                        case SUPPLEMENT: {
                            warningMessage = (String)warningMessage + " is for a supplement to " + cs.getSupplements();
                            break;
                        }
                    }
                    warningMessage = (String)warningMessage + ", so the code has not been validated";
                    if (!this.options.isExampleOK() && !inExpansion && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
                        throw new VSCheckerException((String)warningMessage, null, true);
                    }
                }
                if (cs != null) {
                    if (!(cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE || cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT || this.options.isExampleOK() && cs.getContent() == Enumerations.CodeSystemContentMode.EXAMPLE)) {
                        ValueSet.ConceptReferenceComponent cc;
                        if (inInclude && (cc = this.findInInclude(code)) != null) {
                            String string = this.getPreferredDisplay(cc);
                            res = new ValidationResult(system, cs.getVersion(), new CodeSystem.ConceptDefinitionComponent().setCode(cc.getCode()).setDisplay(string), string);
                            res.addMessage("Resolved system " + system + ", but the definition is not complete, so assuming value set include is correct");
                            return res;
                        }
                        throw new FHIRException("Unable to evaluate based on code system with status = " + cs.getContent().toCode());
                    }
                    res = this.validateCode(path, code, cs, null, info);
                    res.setIssues(issues);
                } else if (cs == null && this.valueset.hasExpansion() && inExpansion) {
                    res = new ValidationResult(system, wv, new CodeSystem.ConceptDefinitionComponent().setCode(code.getCode()).setDisplay(code.getDisplay()), code.getDisplay());
                    if (!this.preferServerSide(system)) {
                        res.addMessage("Code System unknown, so assuming value set expansion is correct (" + (String)warningMessage + ")");
                    }
                } else if (this.throwToServer) {
                    throw new FHIRException(NO_TRY_THE_SERVER);
                }
            }
        } else {
            inExpansion = this.checkExpansion(code, vi);
            inInclude = this.checkInclude(code, vi);
        }
        wv = vi.getVersion(system, code.getVersion());
        if (!this.checkRequiredSupplements(info)) {
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((OperationOutcome.OperationOutcomeIssueComponent)issues.get(issues.size() - 1)).getDetails().getText(), issues);
        }
        if (this.valueset != null) {
            if (res == null || res.isOk()) {
                Boolean ok = this.codeInValueSet(path, system, wv, code.getCode(), info);
                if (ok == null || !ok.booleanValue()) {
                    if (res == null) {
                        res = new ValidationResult(null, null, info.getIssues());
                    }
                    if (info.getErr() != null) {
                        res.setErrorClass(info.getErr());
                    }
                    if (ok == null) {
                        String m = null;
                        if (!this.unknownSystems.isEmpty()) {
                            m = this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_CS", this.valueset.getVersionedUrl(), CommaSeparatedStringBuilder.join((String)",", this.unknownSystems));
                        } else if (!this.unknownValueSets.isEmpty()) {
                            res.addMessage(info.getIssues().get(0).getDetails().getText());
                            m = this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_VS", this.valueset.getVersionedUrl(), CommaSeparatedStringBuilder.join((String)",", this.unknownValueSets));
                        } else {
                            m = this.context.formatMessage("UNABLE_TO_CHECK_IF_THE_PROVIDED_CODES_ARE_IN_THE_VALUE_SET_", this.valueset.getVersionedUrl());
                        }
                        res.addMessage(m);
                        res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.NOTFOUND, null, m, ValueSetProcessBase.OpIssueCode.VSProcessing, null));
                        res.setUnknownSystems(this.unknownSystems);
                        res.setSeverity(ValidationMessage.IssueSeverity.ERROR);
                        res.setErrorClass(TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
                    } else if (!inExpansion && !inInclude) {
                        msg = this.context.formatMessagePlural(1, "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getVersionedUrl(), "'" + code.toString() + "'");
                        res.addMessage(msg).setSeverity(ValidationMessage.IssueSeverity.ERROR);
                        res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, path + ".code", msg, ValueSetProcessBase.OpIssueCode.NotInVS, null));
                        res.setDefinition(null);
                        res.setSystem(null);
                        res.setDisplay(null);
                        res.setUnknownSystems(this.unknownSystems);
                    } else if (warningMessage != null) {
                        msg = this.context.formatMessage("Code_found_in_expansion_however_", warningMessage);
                        res = new ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg, this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, msg, ValueSetProcessBase.OpIssueCode.VSProcessing, null));
                    } else if (inExpansion) {
                        res.setMessage("Code found in expansion, however: " + res.getMessage());
                        res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, res.getMessage(), ValueSetProcessBase.OpIssueCode.VSProcessing, null));
                    } else if (inInclude) {
                        res.setMessage("Code found in include, however: " + res.getMessage());
                        res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.EXCEPTION, path, res.getMessage(), ValueSetProcessBase.OpIssueCode.VSProcessing, null));
                    }
                } else if (res == null) {
                    res = new ValidationResult(system, wv, null, null);
                }
            } else if (res != null && !res.isOk()) {
                String msg5 = this.context.formatMessagePlural(1, "None_of_the_provided_codes_are_in_the_value_set", this.valueset.getVersionedUrl(), "'" + code.toString() + "'");
                res.addMessage(msg5);
                res.getIssues().addAll(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, path + ".code", msg5, ValueSetProcessBase.OpIssueCode.NotInVS, null));
            }
        }
        if (res != null && res.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION && res.getMessage() != null) {
            res.setSeverity(ValidationMessage.IssueSeverity.ERROR);
        }
        return res;
    }

    private void checkValueSetOptions() {
        if (this.valueset != null) {
            for (Extension ext : this.valueset.getCompose().getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinion/valueset-expansion-param")) {
                String name = ext.getExtensionString("name");
                DataType value = ext.getExtensionByUrl("value").getValue();
                if (!"displayLanguage".equals(name)) continue;
                this.options.setLanguages(value.primitiveValue());
            }
            if (!this.options.hasLanguages() && this.valueset.hasLanguage()) {
                this.options.addLanguage(this.valueset.getLanguage());
            }
        }
    }

    private boolean preferServerSide(String system) {
        if (SERVER_SIDE_LIST.contains(system)) {
            return true;
        }
        try {
            if (this.tcm.supportsSystem(system)) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkInclude(Coding code, VersionInfo vi) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return false;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getExclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return false;
            }
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            vi.setComposeVersion(inc.getVersion());
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSet.ConceptReferenceComponent findInInclude(Coding code) {
        if (this.valueset == null || code.getSystem() == null || code.getCode() == null) {
            return null;
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (!inc.hasSystem() || !inc.getSystem().equals(code.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                if (!cc.hasCode() || !cc.getCode().equals(code.getCode())) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem findSpecialCodeSystem(String system, String version) {
        if ("urn:ietf:rfc:3986".equals(system)) {
            CodeSystem cs = new CodeSystem();
            cs.setUrl(system);
            cs.setUserData("tx.cs.special", new URICodeSystem());
            cs.setContent(Enumerations.CodeSystemContentMode.COMPLETE);
            return cs;
        }
        return null;
    }

    private ValidationResult findCodeInExpansion(Coding code) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return null;
        }
        return this.findCodeInExpansion(code, this.valueset.getExpansion().getContains());
    }

    private ValidationResult findCodeInExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            ValidationResult res;
            this.opContext.deadCheck("findCodeInExpansion");
            if (containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                CodeSystem.ConceptDefinitionComponent ccd = new CodeSystem.ConceptDefinitionComponent();
                ccd.setCode(containsComponent.getCode());
                ccd.setDisplay(containsComponent.getDisplay());
                ValidationResult res2 = new ValidationResult(code.getSystem(), code.hasVersion() ? code.getVersion() : containsComponent.getVersion(), ccd, this.getPreferredDisplay(ccd, null));
                return res2;
            }
            if (!containsComponent.hasContains() || (res = this.findCodeInExpansion(code, containsComponent.getContains())) == null) continue;
            return res;
        }
        return null;
    }

    private boolean checkExpansion(Coding code, VersionInfo vi) {
        if (this.valueset == null || !this.valueset.hasExpansion()) {
            return false;
        }
        return this.checkExpansion(code, this.valueset.getExpansion().getContains(), vi);
    }

    private boolean checkExpansion(Coding code, List<ValueSet.ValueSetExpansionContainsComponent> contains, VersionInfo vi) {
        for (ValueSet.ValueSetExpansionContainsComponent containsComponent : contains) {
            this.opContext.deadCheck("checkExpansion: " + code.toString());
            if (containsComponent.hasSystem() && containsComponent.hasCode() && containsComponent.getSystem().equals(code.getSystem()) && containsComponent.getCode().equals(code.getCode())) {
                vi.setExpansionVersion(containsComponent.getVersion());
                return true;
            }
            if (!containsComponent.hasContains() || !this.checkExpansion(code, containsComponent.getContains(), vi)) continue;
            return true;
        }
        return false;
    }

    private ValidationResult validateCode(String path, Coding code, CodeSystem cs, CodeableConcept vcc, ValidationProcessInfo info) {
        String msg;
        ConceptReferencePair vs;
        boolean inactive;
        CodeSystem.ConceptDefinitionComponent cc;
        CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent = cc = cs.hasUserData("tx.cs.special") ? ((SpecialCodeSystem)cs.getUserData("tx.cs.special")).findConcept(code) : this.findCodeInConcept(cs.getConcept(), code.getCode(), cs.getCaseSensitive(), this.allAltCodes);
        if (cc == null) {
            cc = this.findSpecialConcept(code, cs);
        }
        if (cc == null) {
            if (cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT) {
                String msg2 = this.context.formatMessage("UNKNOWN_CODE_IN_FRAGMENT", code.getCode(), cs.getUrl(), cs.getVersion());
                return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg2, this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.CODEINVALID, path + ".code", msg2, ValueSetProcessBase.OpIssueCode.InvalidCode, null));
            }
            String msg3 = this.context.formatMessage("Unknown_Code_in_Version", code.getCode(), cs.getUrl(), cs.getVersion());
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, msg3, this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.CODEINVALID, path + ".code", msg3, ValueSetProcessBase.OpIssueCode.InvalidCode, null));
        }
        if (!cc.getCode().equals(code.getCode())) {
            String msg4 = this.context.formatMessage("CODE_CASE_DIFFERENCE", code.getCode(), cc.getCode(), cs.getVersionedUrl());
            info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.INFORMATION, OperationOutcome.IssueType.BUSINESSRULE, path + ".code", msg4, ValueSetProcessBase.OpIssueCode.CodeRule, null));
        }
        Coding vc = new Coding().setCode(cc.getCode()).setSystem(cs.getUrl()).setVersion(cs.getVersion()).setDisplay(this.getPreferredDisplay(cc, cs));
        if (vcc != null) {
            vcc.addCoding(vc);
        }
        String status = (inactive = CodeSystemUtilities.isInactive(cs, cc)) ? CodeSystemUtilities.getStatus(cs, cc) : null;
        boolean isDefaultLang = false;
        boolean ws = false;
        if (code.getDisplay() == null) {
            return new ValidationResult(code.getSystem(), cs.getVersion(), cc, vc.getDisplay()).setStatus(inactive, status);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(", ", " or ");
        if (cc.hasDisplay() && this.isOkLanguage(cs.getLanguage())) {
            b.append("'" + cc.getDisplay() + "'" + (String)(cs.hasLanguage() ? " (" + cs.getLanguage() + ")" : ""));
            if (code.getDisplay().equalsIgnoreCase(cc.getDisplay())) {
                return new ValidationResult(code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs)).setStatus(inactive, status);
            }
            if (Utilities.normalize((String)code.getDisplay()).equals(Utilities.normalize((String)cc.getDisplay()))) {
                ws = true;
            }
        } else if (cc.hasDisplay() && code.getDisplay().equalsIgnoreCase(cc.getDisplay())) {
            isDefaultLang = true;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : cc.getDesignation()) {
            this.opContext.deadCheck("validateCode1 " + conceptDefinitionDesignationComponent.toString());
            if (!this.isOkLanguage(conceptDefinitionDesignationComponent.getLanguage())) continue;
            b.append("'" + conceptDefinitionDesignationComponent.getValue() + "' (" + conceptDefinitionDesignationComponent.getLanguage() + ")");
            if (code.getDisplay().equalsIgnoreCase(conceptDefinitionDesignationComponent.getValue())) {
                return new ValidationResult(code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs)).setStatus(inactive, status);
            }
            if (!Utilities.normalize((String)code.getDisplay()).equalsIgnoreCase(Utilities.normalize((String)conceptDefinitionDesignationComponent.getValue()))) continue;
            ws = true;
        }
        if (this.options.isUseValueSetDisplays() && (vs = this.findValueSetRef(code.getSystem(), code.getCode())) != null && (vs.getCc().hasDisplay() || vs.getCc().hasDesignation())) {
            if (vs.getCc().hasDisplay() && this.isOkLanguage(vs.getValueset().getLanguage())) {
                b.append("'" + vs.getCc().getDisplay() + "'");
                if (code.getDisplay().equalsIgnoreCase(vs.getCc().getDisplay())) {
                    return new ValidationResult(code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs)).setStatus(inactive, status);
                }
            }
            for (ValueSet.ConceptReferenceDesignationComponent ds : vs.getCc().getDesignation()) {
                this.opContext.deadCheck("validateCode2 " + ds.toString());
                if (!this.isOkLanguage(ds.getLanguage())) continue;
                b.append("'" + ds.getValue() + "'");
                if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
                return new ValidationResult(code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs)).setStatus(inactive, status);
            }
        }
        if (b.count() > 0) {
            msg = this.context.formatMessagePlural(b.count(), ws ? "Display_Name_WS_for__should_be_one_of__instead_of" : "Display_Name_for__should_be_one_of__instead_of", code.getSystem(), code.getCode(), b.toString(), code.getDisplay(), this.options.langSummary());
            return new ValidationResult(this.dispWarningStatus(), msg, code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs), this.makeIssue(this.dispWarning(), OperationOutcome.IssueType.INVALID, path + ".display", msg, ValueSetProcessBase.OpIssueCode.Display, null)).setStatus(inactive, status);
        }
        if (isDefaultLang) {
            boolean none = this.options.getLanguages().getLangs().size() == 1 && !this.hasLanguage(cs, (AcceptLanguageHeader.LanguagePreference)this.options.getLanguages().getLangs().get(0));
            String string = this.context.formatMessagePlural(this.options.getLanguages().getLangs().size(), none ? "NO_VALID_DISPLAY_FOUND_LANG_NONE" : "NO_VALID_DISPLAY_FOUND_LANG_SOME", code.getSystem(), code.getCode(), code.getDisplay(), this.options.langSummary(), code.getDisplay());
            String n = null;
            return new ValidationResult(ValidationMessage.IssueSeverity.INFORMATION, n, code.getSystem(), cs.getVersion(), cc, this.getPreferredDisplay(cc, cs), this.makeIssue(ValidationMessage.IssueSeverity.INFORMATION, OperationOutcome.IssueType.INVALID, path + ".display", string, ValueSetProcessBase.OpIssueCode.DisplayComment, null)).setStatus(inactive, status);
        }
        msg = this.context.formatMessagePlural(this.options.getLanguages().getLangs().size(), "NO_VALID_DISPLAY_FOUND", code.getSystem(), code.getCode(), code.getDisplay(), this.options.langSummary());
        return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, msg, code.getSystem(), cs.getVersion(), cc, cc.getDisplay(), this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.INVALID, path + ".display", msg, ValueSetProcessBase.OpIssueCode.Display, null)).setStatus(inactive, status);
    }

    private boolean hasLanguage(CodeSystem cs, AcceptLanguageHeader.LanguagePreference languagePreference) {
        String lang = languagePreference.getLang();
        if (lang == null) {
            return false;
        }
        for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
            boolean hl = this.hasLanguage(cs, cc, lang);
            if (!hl) continue;
            return true;
        }
        return false;
    }

    private boolean hasLanguage(CodeSystem cs, CodeSystem.ConceptDefinitionComponent cc, String lang) {
        if (lang.equals(cs.getLanguage()) && cc.hasDisplay()) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cc.getDesignation()) {
            if (!lang.equals(d.getLanguage())) continue;
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent cc1 : cc.getConcept()) {
            boolean hl = this.hasLanguage(cs, cc1, lang);
            if (!hl) continue;
            return true;
        }
        return false;
    }

    private CodeSystem.ConceptDefinitionComponent findSpecialConcept(Coding c, CodeSystem cs) {
        CodeSystem.ConceptDefinitionComponent cd;
        String code;
        if ("http://terminology.hl7.org/CodeSystem/v2-0203".equals(cs.getUrl()) && (code = c.getCode()) != null && code.startsWith("NN") && code.length() > 3 && (cd = this.findCountryCode(code.substring(2))) != null) {
            return new CodeSystem.ConceptDefinitionComponent(code).setDisplay("National Identifier for " + cd.getDisplay());
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCountryCode(String code) {
        ValidationResult vr = this.context.validateCode(new ValidationOptions(FhirPublication.R5), "urn:iso:std:iso:3166", null, code, null);
        return vr == null || !vr.isOk() ? null : new CodeSystem.ConceptDefinitionComponent(code).setDisplay(vr.getDisplay()).setDefinition(vr.getDefinition());
    }

    private ValidationMessage.IssueSeverity dispWarning() {
        return this.options.isDisplayWarningMode() ? ValidationMessage.IssueSeverity.WARNING : ValidationMessage.IssueSeverity.ERROR;
    }

    private ValidationMessage.IssueSeverity dispWarningStatus() {
        return this.options.isDisplayWarningMode() ? ValidationMessage.IssueSeverity.WARNING : ValidationMessage.IssueSeverity.INFORMATION;
    }

    private boolean isOkLanguage(String language) {
        if (!this.options.hasLanguages()) {
            return true;
        }
        if (LanguageUtils.langsMatch(this.options.getLanguages(), language)) {
            return true;
        }
        return language == null && (this.options.langSummary().contains("en") || this.options.langSummary().contains("en-US") || this.options.isEnglishOk());
    }

    private ConceptReferencePair findValueSetRef(String system, String code) {
        if (this.valueset == null) {
            return null;
        }
        for (ValueSet.ValueSetExpansionContainsComponent exp : this.valueset.getExpansion().getContains()) {
            this.opContext.deadCheck("findValueSetRef " + exp.toString());
            if (!system.equals(exp.getSystem()) || !code.equals(exp.getCode())) continue;
            ValueSet.ConceptReferenceComponent cc = new ValueSet.ConceptReferenceComponent();
            cc.setDisplay(exp.getDisplay());
            cc.setDesignation(exp.getDesignation());
            return new ConceptReferencePair(this.valueset, cc);
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (system.equals(inc.getSystem())) {
                for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
                    if (!cc.getCode().equals(code)) continue;
                    return new ConceptReferencePair(this.valueset, cc);
                }
            }
            for (CanonicalType url : inc.getValueSet()) {
                ConceptReferencePair cc = this.getVs(url.asStringValue(), null).findValueSetRef(system, code);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private boolean checkSystem(List<ValueSet.ValueSetExpansionContainsComponent> containsList, String system) {
        for (ValueSet.ValueSetExpansionContainsComponent contains : containsList) {
            if (contains.getSystem().equals(system) && (!contains.hasContains() || this.checkSystem(contains.getContains(), system))) continue;
            return false;
        }
        return true;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(CodeSystem.ConceptDefinitionComponent concept, String code, boolean caseSensitive, ValueSetProcessBase.AlternateCodesProcessingRules altCodeRules) {
        this.opContext.deadCheck("findCodeInConcept: " + code.toString() + ", " + concept.toString());
        if (code.equals(concept.getCode())) {
            return concept;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(concept.getConcept(), code, caseSensitive, altCodeRules);
        if (cc != null) {
            return cc;
        }
        if (concept.hasUserData("cs.utils.cross.link")) {
            List children = (List)concept.getUserData("cs.utils.cross.link");
            for (CodeSystem.ConceptDefinitionComponent c : children) {
                cc = this.findCodeInConcept(c, code, caseSensitive, altCodeRules);
                if (cc == null) continue;
                return cc;
            }
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code, boolean caseSensitive, ValueSetProcessBase.AlternateCodesProcessingRules altCodeRules) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode()) || !caseSensitive && code.equalsIgnoreCase(cc.getCode())) {
                return cc;
            }
            if (Utilities.existsInList((String)code, this.alternateCodes(cc, altCodeRules))) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc, code, caseSensitive, altCodeRules);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private List<String> alternateCodes(CodeSystem.ConceptDefinitionComponent focus, ValueSetProcessBase.AlternateCodesProcessingRules altCodeRules) {
        ArrayList<String> codes = new ArrayList<String>();
        for (CodeSystem.ConceptPropertyComponent p : focus.getProperty()) {
            if (!"alternateCode".equals(p.getCode()) || !altCodeRules.passes(p.getExtension()) || !p.getValue().isPrimitive()) continue;
            codes.add(p.getValue().primitiveValue());
        }
        return codes;
    }

    private String systemForCodeInValueSet(String code, List<StringWithCode> problems) {
        HashSet<String> sys = new HashSet<String>();
        if (!this.scanForCodeInValueSet(code, sys, problems)) {
            return null;
        }
        if (sys.size() == 0) {
            problems.add(new StringWithCode(ValueSetProcessBase.OpIssueCode.InferFailed, this.context.formatMessage("UNABLE_TO_INFER_CODESYSTEM", code, this.valueset.getVersionedUrl())));
            return null;
        }
        if (sys.size() > 1) {
            problems.add(new StringWithCode(ValueSetProcessBase.OpIssueCode.InferFailed, this.context.formatMessage("Unable_to_resolve_system__value_set_has_multiple_matches", code, this.valueset.getVersionedUrl(), ((Object)sys).toString())));
            return null;
        }
        return (String)sys.iterator().next();
    }

    private boolean scanForCodeInValueSet(String code, Set<String> sys, List<StringWithCode> problems) {
        if (this.valueset.hasCompose()) {
            if (!this.valueset.getCompose().hasInclude() && !this.valueset.getExpansion().hasContains()) {
                problems.add(new StringWithCode(ValueSetProcessBase.OpIssueCode.InferFailed, this.context.formatMessage("Unable_to_resolve_system__value_set_has_no_includes_or_expansion", code, this.valueset.getVersionedUrl())));
            }
            int i = 0;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                this.opContext.deadCheck("scanForCodeInValueSet: " + code.toString());
                if (this.scanForCodeInValueSetInclude(code, sys, problems, i, vsi)) {
                    return true;
                }
                ++i;
            }
        } else if (this.valueset.hasExpansion() && !this.checkSystems(this.valueset.getExpansion().getContains(), code, sys, problems)) {
            return false;
        }
        return true;
    }

    private boolean scanForCodeInValueSetInclude(String code, Set<String> sys, List<StringWithCode> problems, int i, ValueSet.ConceptSetComponent vsi) {
        if (vsi.hasValueSet()) {
            for (CanonicalType u : vsi.getValueSet()) {
                if (this.checkForCodeInValueSet(code, (String)u.getValue(), sys, problems)) continue;
                return false;
            }
        } else if (!vsi.hasSystem()) {
            problems.add(new StringWithCode(ValueSetProcessBase.OpIssueCode.InferFailed, this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_no_system", code, this.valueset.getVersionedUrl(), i)));
            return false;
        }
        if (vsi.hasSystem()) {
            CodeSystemProvider csp;
            if (vsi.hasFilter()) {
                ValueSet vsDummy = new ValueSet();
                vsDummy.setUrl(Utilities.makeUuidUrn());
                vsDummy.setStatus(Enumerations.PublicationStatus.ACTIVE);
                vsDummy.getCompose().addInclude(vsi);
                Coding c = new Coding().setCode(code).setSystem(vsi.getSystem());
                ValidationResult vr = this.context.validateCode(this.options.withGuessSystem(false), c, vsDummy);
                if (vr.isOk()) {
                    sys.add(vsi.getSystem());
                } else {
                    return false;
                }
            }
            if ((csp = CodeSystemProvider.factory(vsi.getSystem())) != null) {
                Boolean ok = csp.checkCode(code);
                if (ok == null) {
                    problems.add(new StringWithCode(ValueSetProcessBase.OpIssueCode.InferFailed, this.context.formatMessage("UNABLE_TO_RESOLVE_SYSTEM_SYSTEM_IS_INDETERMINATE", code, this.valueset.getVersionedUrl(), vsi.getSystem())));
                    sys.add(vsi.getSystem());
                } else if (ok.booleanValue()) {
                    sys.add(vsi.getSystem());
                }
            } else {
                CodeSystem cs = this.resolveCodeSystem(vsi.getSystem(), vsi.getVersion());
                if (cs != null && cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE) {
                    if (vsi.hasConcept()) {
                        for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                            boolean match = cs.getCaseSensitive() ? cc.getCode().equals(code) : cc.getCode().equalsIgnoreCase(code);
                            if (!match) continue;
                            sys.add(vsi.getSystem());
                        }
                    } else {
                        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code, cs.getCaseSensitive(), this.allAltCodes);
                        if (cc != null) {
                            sys.add(vsi.getSystem());
                        }
                    }
                } else if (vsi.hasConcept()) {
                    for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                        boolean match = cc.getCode().equals(code);
                        if (!match) continue;
                        sys.add(vsi.getSystem());
                    }
                } else {
                    ValueSet vsDummy = new ValueSet();
                    vsDummy.setUrl(Utilities.makeUuidUrn());
                    vsDummy.setStatus(Enumerations.PublicationStatus.ACTIVE);
                    vsDummy.getCompose().addInclude(vsi);
                    ValidationResult vr = this.context.validateCode(this.options.withNoClient(), code, vsDummy);
                    if (vr.isOk()) {
                        sys.add(vsi.getSystem());
                    } else {
                        ValueSetExpansionOutcome vse = this.context.expandVS(vsi, false, false);
                        if (vse.isOk()) {
                            if (!this.checkSystems(vse.getValueset().getExpansion().getContains(), code, sys, problems)) {
                                return false;
                            }
                        } else {
                            problems.add(new StringWithCode(ValueSetProcessBase.OpIssueCode.NotFound, this.context.formatMessage("Unable_to_resolve_system__value_set_has_include_with_unknown_system", code, this.valueset.getVersionedUrl(), i, vsi.getSystem(), vse.getAllErrors().toString())));
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

    private String filterSummary(ValueSet.ConceptSetComponent vsi) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValueSet.ConceptSetFilterComponent f : vsi.getFilter()) {
            b.append(f.getProperty() + f.getOp().toCode() + f.getValue());
        }
        return b.toString();
    }

    private boolean checkForCodeInValueSet(String code, String uri, Set<String> sys, List<StringWithCode> problems) {
        ValueSetValidator vs = this.getVs(uri, null);
        return vs.scanForCodeInValueSet(code, sys, problems);
    }

    private boolean checkSystems(List<ValueSet.ValueSetExpansionContainsComponent> contains, String code, Set<String> systems, List<StringWithCode> problems) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            this.opContext.deadCheck("checkSystems " + code.toString());
            if (c.getCode().equals(code)) {
                systems.add(c.getSystem());
            }
            if (!c.hasContains()) continue;
            this.checkSystems(c.getContains(), code, systems, problems);
        }
        return true;
    }

    public Boolean codeInValueSet(String path, String system, String version, String code, ValidationProcessInfo info) throws FHIRException {
        if (this.valueset == null) {
            return null;
        }
        this.opContext.deadCheck("codeInValueSet: " + system + "#" + code);
        this.checkCanonical(info.getIssues(), path, this.valueset, this.valueset);
        Boolean result = false;
        VersionInfo vi = new VersionInfo(this);
        if (this.valueset.hasExpansion()) {
            return this.checkExpansion(new Coding(system, code, null), vi);
        }
        if (this.valueset.hasCompose()) {
            int i = 0;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                Boolean ok = this.inComponent(path, vsi, i, system, version, code, this.valueset.getCompose().getInclude().size() == 1, info);
                ++i;
                if (ok == null && result != null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (ok == null || !ok.booleanValue()) continue;
                result = true;
                break;
            }
            i = this.valueset.getCompose().getInclude().size();
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                Boolean nok = this.inComponent(path, vsi, i, system, version, code, this.valueset.getCompose().getInclude().size() == 1, info);
                ++i;
                if (nok == null && result != null && !result.booleanValue()) {
                    result = null;
                    continue;
                }
                if (nok == null || !nok.booleanValue()) continue;
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Boolean inComponent(String path, ValueSet.ConceptSetComponent vsi, int vsiIndex, String system, String version, String code, boolean only, ValidationProcessInfo info) throws FHIRException {
        List<CodeSystem.ConceptDefinitionComponent> list;
        this.opContext.deadCheck("inComponent " + vsiIndex);
        boolean ok = true;
        if (vsi.hasValueSet()) {
            if (this.isValueSetUnionImports()) {
                ok = false;
                for (UriType uriType : vsi.getValueSet()) {
                    if (!this.inImport(path, (String)uriType.getValue(), system, version, code, info).booleanValue()) continue;
                    return true;
                }
            } else {
                void var11_13;
                Boolean bok = this.inImport(path, (String)vsi.getValueSet().get(0).getValue(), system, version, code, info);
                if (bok == null) {
                    return bok;
                }
                ok = bok;
                boolean bl = true;
                while (var11_13 < vsi.getValueSet().size()) {
                    UriType uri = vsi.getValueSet().get((int)var11_13);
                    ok = ok && this.inImport(path, (String)uri.getValue(), system, version, code, info) != false;
                    ++var11_13;
                }
            }
        }
        if (!vsi.hasSystem() || !ok) {
            return ok;
        }
        if (only && system == null) {
            for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
                if (!conceptReferenceComponent.getCode().equals(code)) continue;
                return true;
            }
        }
        if (system == null || !system.equals(vsi.getSystem())) {
            return false;
        }
        CodeSystem cs = this.resolveCodeSystem(system, version);
        if (cs == null || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
            if (this.throwToServer) {
                ValueSet valueSet = new ValueSet();
                valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
                valueSet.setUrl(this.valueset.getUrl() + "--" + vsiIndex);
                valueSet.setVersion(this.valueset.getVersion());
                valueSet.getCompose().addInclude(vsi);
                this.opContext.deadCheck("hit server " + valueSet.getVersionedUrl());
                ValidationResult res = this.context.validateCode(this.options.withNoClient(), new Coding(system, code, null), valueSet);
                if (res.getErrorClass() == TerminologyServiceErrorClass.UNKNOWN || res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED || res.getErrorClass() == TerminologyServiceErrorClass.VALUESET_UNSUPPORTED) {
                    if (info != null && res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                        if (!info.hasNotFound(system)) {
                            String msg = this.context.formatMessage("UNKNOWN_CODESYSTEM", system);
                            info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.WARNING, OperationOutcome.IssueType.UNKNOWN, path, msg, ValueSetProcessBase.OpIssueCode.NotFound, null));
                            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                                if (!cc.getCode().equals(code)) continue;
                                this.opContext.deadCheck("server true");
                                return true;
                            }
                        }
                        info.setErr(TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
                        this.opContext.deadCheck("server codesystem unsupported");
                        return null;
                    }
                    this.opContext.deadCheck("server not found");
                    return false;
                }
                if (res.getErrorClass() == TerminologyServiceErrorClass.NOSERVICE) {
                    this.opContext.deadCheck("server no server");
                    throw new NoTerminologyServiceException();
                }
                return res.isOk();
            }
            info.setErr(TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED);
            if (this.unknownSystems != null) {
                if (version == null) {
                    this.unknownSystems.add(system);
                } else {
                    this.unknownSystems.add(system + "|" + version);
                }
            }
            return null;
        }
        this.checkCanonical(info.getIssues(), path, cs, this.valueset);
        if ((this.valueset.getCompose().hasInactive() && !this.valueset.getCompose().getInactive() || this.options.isActiveOnly()) && CodeSystemUtilities.isInactive(cs, code)) {
            info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.BUSINESSRULE, path + ".code", this.context.formatMessage("STATUS_CODE_WARNING_CODE", "not active", code), ValueSetProcessBase.OpIssueCode.CodeRule, null));
            return false;
        }
        if (vsi.hasFilter()) {
            ok = true;
            for (ValueSet.ConceptSetFilterComponent f : vsi.getFilter()) {
                if (this.codeInFilter(cs, system, f, code)) continue;
                return false;
            }
        }
        if ((ok = this.validateCodeInConceptList(code, cs, list = cs.getConcept(), this.allAltCodes)) && vsi.hasConcept()) {
            for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                if (!cc.getCode().equals(code)) continue;
                return true;
            }
            return false;
        }
        ok = this.validateCodeInConceptList(code, cs, list, this.altCodeParams);
        return ok;
    }

    protected boolean isValueSetUnionImports() {
        PackageInformation p = this.valueset.getSourcePackage();
        if (p != null) {
            return p.getDate().before(new GregorianCalendar(2022, 2, 31).getTime());
        }
        return false;
    }

    private boolean codeInFilter(CodeSystem cs, String system, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        if ("concept".equals(f.getProperty())) {
            return this.codeInConceptFilter(cs, f, code);
        }
        if ("code".equals(f.getProperty()) && f.getOp() == Enumerations.FilterOperator.REGEX) {
            return this.codeInRegexFilter(cs, f, code);
        }
        if (CodeSystemUtilities.isDefinedProperty(cs, f.getProperty())) {
            return this.codeInPropertyFilter(cs, f, code);
        }
        if (this.isKnownProperty(f.getProperty())) {
            return this.codeInKnownPropertyFilter(cs, f, code);
        }
        System.out.println("todo: handle filters with property = " + f.getProperty() + " " + f.getOp().toCode());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__filter_with_property__", cs.getUrl(), f.getProperty(), f.getOp().toCode()));
    }

    private boolean isKnownProperty(String code) {
        return Utilities.existsInList((String)code, (String[])new String[]{"notSelectable"});
    }

    private boolean codeInPropertyFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) {
        switch (f.getOp()) {
            case EQUAL: {
                if (f.getValue() == null) {
                    return false;
                }
                DataType d = CodeSystemUtilities.getProperty(cs, code, f.getProperty());
                return d != null && f.getValue().equals(d.primitiveValue());
            }
            case EXISTS: {
                return CodeSystemUtilities.getProperty(cs, code, f.getProperty()) != null;
            }
            case REGEX: {
                if (f.getValue() == null) {
                    return false;
                }
                DataType d = CodeSystemUtilities.getProperty(cs, code, f.getProperty());
                return d != null && d.primitiveValue() != null && d.primitiveValue().matches(f.getValue());
            }
            case IN: {
                if (f.getValue() == null) {
                    return false;
                }
                String[] values = f.getValue().split("\\,");
                DataType d = CodeSystemUtilities.getProperty(cs, code, f.getProperty());
                if (d != null) {
                    String v = d.primitiveValue();
                    for (String value : values) {
                        if (v == null || !v.equals(value.trim())) continue;
                        return true;
                    }
                }
                return false;
            }
            case NOTIN: {
                if (f.getValue() == null) {
                    return true;
                }
                String[] values = f.getValue().split("\\,");
                DataType d = CodeSystemUtilities.getProperty(cs, code, f.getProperty());
                if (d != null) {
                    String v = d.primitiveValue();
                    for (String value : values) {
                        if (v == null || !v.equals(value.trim())) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        System.out.println("todo: handle property filters with op = " + f.getOp());
        throw new FHIRException(this.context.formatMessage("UNABLE_TO_HANDLE_SYSTEM__PROPERTY_FILTER_WITH_OP__", new Object[]{cs.getUrl(), f.getOp()}));
    }

    private boolean codeInKnownPropertyFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) {
        switch (f.getOp()) {
            case EQUAL: {
                if (f.getValue() == null) {
                    return false;
                }
                DataType d = CodeSystemUtilities.getProperty(cs, code, f.getProperty());
                return d != null && f.getValue().equals(d.primitiveValue());
            }
            case EXISTS: {
                return CodeSystemUtilities.getProperty(cs, code, f.getProperty()) != null;
            }
            case REGEX: {
                if (f.getValue() == null) {
                    return false;
                }
                DataType d = CodeSystemUtilities.getProperty(cs, code, f.getProperty());
                return d != null && d.primitiveValue() != null && d.primitiveValue().matches(f.getValue());
            }
        }
        System.out.println("todo: handle known property filters with op = " + f.getOp());
        throw new FHIRException(this.context.formatMessage("UNABLE_TO_HANDLE_SYSTEM__PROPERTY_FILTER_WITH_OP__", new Object[]{cs.getUrl(), f.getOp()}));
    }

    private boolean codeInRegexFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) {
        return code.matches(f.getValue());
    }

    private boolean codeInConceptFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code) throws FHIRException {
        switch (f.getOp()) {
            case ISA: {
                return this.codeInConceptIsAFilter(cs, f, code, false);
            }
            case ISNOTA: {
                return !this.codeInConceptIsAFilter(cs, f, code, false);
            }
            case DESCENDENTOF: {
                return this.codeInConceptIsAFilter(cs, f, code, true);
            }
        }
        System.out.println("todo: handle concept filters with op = " + f.getOp());
        throw new FHIRException(this.context.formatMessage("Unable_to_handle_system__concept_filter_with_op__", new Object[]{cs.getUrl(), f.getOp()}));
    }

    private boolean codeInConceptIsAFilter(CodeSystem cs, ValueSet.ConceptSetFilterComponent f, String code, boolean excludeRoot) {
        if (!excludeRoot && code.equals(f.getValue())) {
            return true;
        }
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), f.getValue(), cs.getCaseSensitive(), this.altCodeParams);
        if (cc == null) {
            return false;
        }
        CodeSystem.ConceptDefinitionComponent cc2 = this.findCodeInConcept(cc, code, cs.getCaseSensitive(), this.altCodeParams);
        return cc2 != null && cc2 != cc;
    }

    public boolean validateCodeInConceptList(String code, CodeSystem def, List<CodeSystem.ConceptDefinitionComponent> list, ValueSetProcessBase.AlternateCodesProcessingRules altCodeRules) {
        this.opContext.deadCheck("validateCodeInConceptList");
        if (def.hasUserData("tx.cs.special")) {
            return ((SpecialCodeSystem)def.getUserData("tx.cs.special")).findConcept(new Coding().setCode(code)) != null;
        }
        if (def.getCaseSensitive()) {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equals(code)) {
                    return true;
                }
                if (Utilities.existsInList((String)code, this.alternateCodes(cc, altCodeRules))) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept(), altCodeRules)) continue;
                return true;
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equalsIgnoreCase(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept(), altCodeRules)) continue;
                return true;
            }
        }
        return false;
    }

    private ValueSetValidator getVs(String url, ValidationProcessInfo info) {
        if (this.inner.containsKey(url)) {
            return this.inner.get(url);
        }
        ValueSet vs = this.context.findTxResource(ValueSet.class, url, this.valueset);
        if (vs == null && info != null) {
            this.unknownValueSets.add(url);
            info.addIssue(this.makeIssue(ValidationMessage.IssueSeverity.ERROR, OperationOutcome.IssueType.NOTFOUND, null, this.context.formatMessage("Unable_to_resolve_value_Set_", url), ValueSetProcessBase.OpIssueCode.NotFound, null));
        }
        ValueSetValidator vsc = new ValueSetValidator(this.context, this.opContext.copy(), this.options, vs, this.localContext, this.expansionProfile, this.tcm);
        vsc.setThrowToServer(this.throwToServer);
        this.inner.put(url, vsc);
        return vsc;
    }

    private Boolean inImport(String path, String uri, String system, String version, String code, ValidationProcessInfo info) throws FHIRException {
        ValueSetValidator vs = this.getVs(uri, info);
        if (vs == null) {
            return false;
        }
        Boolean ok = vs.codeInValueSet(path, system, version, code, info);
        return ok;
    }

    private String getPreferredDisplay(ValueSet.ConceptReferenceComponent cc) {
        if (!this.options.hasLanguages()) {
            return cc.getDisplay();
        }
        if (LanguageUtils.langsMatch(this.options.getLanguages(), this.valueset.getLanguage())) {
            return cc.getDisplay();
        }
        if (this.valueset.getLanguage() == null && (this.options.langSummary().contains("en") || this.options.langSummary().contains("en-US"))) {
            return cc.getDisplay();
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
            if (d.hasUse() || !LanguageUtils.langsMatch(this.options.getLanguages(), d.getLanguage())) continue;
            return d.getValue();
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
            if (!LanguageUtils.langsMatch(this.options.getLanguages(), d.getLanguage())) continue;
            return d.getValue();
        }
        return cc.getDisplay();
    }

    private String getPreferredDisplay(CodeSystem.ConceptDefinitionComponent cc, CodeSystem cs) {
        if (!this.options.hasLanguages()) {
            return cc.getDisplay();
        }
        if (cs != null && LanguageUtils.langsMatch(this.options.getLanguages(), cs.getLanguage())) {
            return cc.getDisplay();
        }
        if ((cs == null || cs.getLanguage() == null) && (this.options.langSummary().contains("en") || this.options.langSummary().contains("en-US"))) {
            return cc.getDisplay();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cc.getDesignation()) {
            if (d.hasUse() || !LanguageUtils.langsMatch(this.options.getLanguages(), d.getLanguage())) continue;
            return d.getValue();
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cc.getDesignation()) {
            if (!LanguageUtils.langsMatch(this.options.getLanguages(), d.getLanguage())) continue;
            return d.getValue();
        }
        return cc.getDisplay();
    }

    public class StringWithCode {
        private ValueSetProcessBase.OpIssueCode code;
        private String message;

        protected StringWithCode(ValueSetProcessBase.OpIssueCode code, String message) {
            this.code = code;
            this.message = message;
        }

        public ValueSetProcessBase.OpIssueCode getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

