/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance.profile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.TypesUtilities;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;

public class SnapshotGenerationPreProcessor {
    private IWorkerContext context;
    private ProfileUtilities utils;
    Set<String> typeNames;
    private List<SliceInfo> slicings = new ArrayList<SliceInfo>();

    public SnapshotGenerationPreProcessor(ProfileUtilities utils) {
        this.utils = utils;
        this.context = utils.getContext();
    }

    public void process(StructureDefinition.StructureDefinitionDifferentialComponent diff) {
        for (int cursor = 0; cursor < diff.getElement().size(); ++cursor) {
            ElementDefinition ed = diff.getElement().get(cursor);
            SliceInfo si = this.getSlicing(ed);
            if (si == null) {
                if (!ed.hasSlicing() || this.isExtensionSlicing(ed)) continue;
                si = new SliceInfo(null, ed);
                this.slicings.add(si);
                continue;
            }
            if (ed.hasSliceName() && ed.getPath().equals(si.path)) {
                si.newSlice(ed);
                continue;
            }
            if (ed.hasSlicing() && !this.isExtensionSlicing(ed)) {
                si = new SliceInfo(si, ed);
                this.slicings.add(si);
                continue;
            }
            si.add(ed);
        }
        for (SliceInfo si : this.slicings) {
            if (si.sliceStuff.isEmpty() || si.slices == null) continue;
            for (ElementDefinition ed : si.sliceStuff) {
                if (!ed.hasSlicing() || this.isExtensionSlicing(ed)) continue;
                String message = this.context.formatMessage("UNSUPPORTED_SLICING_COMPLEXITY", si.slicer.getPath(), ed.getPath(), ed.getSlicing().summary());
                System.out.println(message);
                return;
            }
        }
        for (int i = this.slicings.size() - 1; i >= 0; --i) {
            SliceInfo si;
            si = this.slicings.get(i);
            if (si.sliceStuff.isEmpty() || si.slices == null) continue;
            for (ElementDefinition slice : si.slices) {
                this.mergeElements(diff.getElement(), si.sliceStuff, slice, si.slicer);
            }
        }
    }

    private void mergeElements(List<ElementDefinition> elements, List<ElementDefinition> allSlices, ElementDefinition slice, ElementDefinition slicer) {
        int sliceIndex = elements.indexOf(slice);
        int startOfSlice = sliceIndex + 1;
        int endOfSlice = this.findEndOfSlice(elements, slice);
        HashSet<String> missing = new HashSet<String>();
        boolean allFound = true;
        for (int i = 0; i < allSlices.size(); ++i) {
            boolean found = false;
            for (int j = startOfSlice; j <= endOfSlice; ++j) {
                if (!elements.get(j).getPath().equals(allSlices.get(i).getPath())) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(allSlices.get(i).getPath());
            allFound = false;
        }
        if (allFound) {
            for (int j = startOfSlice; j <= endOfSlice; ++j) {
                for (int i = 0; i < allSlices.size(); ++i) {
                    if (!elements.get(j).getPath().equals(allSlices.get(i).getPath())) continue;
                    this.merge(elements.get(j), allSlices.get(i));
                }
            }
        } else {
            HashSet<ElementDefinition> handled = new HashSet<ElementDefinition>();
            for (int j = startOfSlice; j <= endOfSlice; ++j) {
                for (int i = 0; i < allSlices.size(); ++i) {
                    if (!elements.get(j).getPath().equals(allSlices.get(i).getPath())) continue;
                    handled.add(allSlices.get(i));
                    this.merge(elements.get(j), allSlices.get(i));
                }
            }
            for (ElementDefinition ed : allSlices) {
                if (handled.contains(ed)) continue;
                List<ElementAnalysis> edDef = this.analysePath(ed);
                String id = ed.getId().replace(slicer.getId(), slice.getId());
                int index = this.determineInsertionPoint(elements, startOfSlice, endOfSlice, id, ed.getPath(), edDef);
                ElementDefinition edc = ed.copy();
                edc.setUserData("SNAPSHOT_PREPROCESS_INJECTED", true);
                edc.setId(id);
                elements.add(index, edc);
                ++endOfSlice;
            }
        }
    }

    private int determineInsertionPoint(List<ElementDefinition> elements, int startOfSlice, int endOfSlice, String id, String path, List<ElementAnalysis> edDef) {
        String[] p = id.split("\\.");
        for (int i = p.length - 1; i >= 1; --i) {
            Object subId = p[0];
            for (int j = 1; j <= i; ++j) {
                subId = (String)subId + "." + p[j];
            }
            List<ElementDefinition> peers = this.findPeers(elements, startOfSlice, endOfSlice, (String)subId);
            if (peers.isEmpty()) continue;
            for (ElementDefinition ed : peers) {
                if (!this.comesAfterThis(id, path, edDef, ed)) continue;
                return elements.indexOf(ed);
            }
            return elements.indexOf(peers.get(peers.size() - 1)) + 1;
        }
        return endOfSlice + 1;
    }

    private List<ElementDefinition> findPeers(List<ElementDefinition> elements, int startOfSlice, int endOfSlice, String subId) {
        ArrayList<ElementDefinition> peers = new ArrayList<ElementDefinition>();
        for (int i = startOfSlice; i <= endOfSlice; ++i) {
            ElementDefinition ed = elements.get(i);
            if (!ed.getId().startsWith(subId)) continue;
            peers.add(ed);
        }
        return peers;
    }

    private String summary(List<ElementAnalysis> edDef) {
        ArrayList<String> s = new ArrayList<String>();
        for (ElementAnalysis ed : edDef) {
            s.add(ed.summary());
        }
        return CommaSeparatedStringBuilder.join((String)",", s);
    }

    private boolean comesAfterThis(String id, String path, List<ElementAnalysis> edDef, ElementDefinition ed) {
        String[] p1 = id.split("\\.");
        String[] p2 = ed.getId().split("\\.");
        for (int i = 0; i < Integer.min(p1.length, p2.length); ++i) {
            int i2;
            if (p1[i].equals(p2[i])) continue;
            ElementAnalysis sed = edDef.get(i - 1);
            int i1 = this.indexOfName(sed, p1[i]);
            return i1 < (i2 = this.indexOfName(sed, p2[i]));
        }
        return p1.length < p2.length;
    }

    private int indexOfName(ElementAnalysis sed, String name) {
        if (name.contains(":")) {
            name = name.substring(0, name.indexOf(":"));
        }
        for (int i = 0; i < sed.getChildren().getList().size(); ++i) {
            if (!name.equals(sed.getChildren().getList().get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    private List<ElementAnalysis> analysePath(ElementDefinition ed) {
        ArrayList<ElementAnalysis> res = new ArrayList<ElementAnalysis>();
        for (String pn : ed.getPath().split("\\.")) {
            if (res.isEmpty()) {
                StructureDefinition sd = this.context.fetchTypeDefinition(pn);
                if (sd == null) {
                    String message = this.context.formatMessage("Unknown_type__at_", pn, ed.getId());
                    throw new DefinitionException(message);
                }
                res.add(new ElementAnalysis(sd, sd.getSnapshot().getElementFirstRep(), null));
                continue;
            }
            ElementAnalysis sed = (ElementAnalysis)res.get(res.size() - 1);
            sed.setChildren(this.utils.getChildMap(sed.getStructure(), sed.getElement(), true, sed.getType()));
            ElementDefinition t = null;
            String type = null;
            for (ElementDefinition child : sed.getChildren().getList()) {
                String rn;
                if (pn.equals(child.getName())) {
                    t = child;
                    break;
                }
                if (!child.getName().endsWith("[x]") || !pn.startsWith(rn = child.getName().substring(0, child.getName().length() - 3))) continue;
                t = child;
                String tn = pn.substring(rn.length());
                if (TypesUtilities.isPrimitive(Utilities.uncapitalize((String)tn))) {
                    type = Utilities.uncapitalize((String)tn);
                    break;
                }
                type = tn;
                break;
            }
            if (t == null) {
                String message = this.context.formatMessage("UNKNOWN_PROPERTY", pn, ed.getPath());
                throw new DefinitionException("Unknown path " + pn + " in path " + ed.getPath() + ": " + message);
            }
            res.add(new ElementAnalysis(sed.getChildren().getSource(), t, type));
        }
        return res;
    }

    private int findEndOfSlice(List<ElementDefinition> elements, ElementDefinition slice) {
        for (int i = elements.indexOf(slice); i < elements.size(); ++i) {
            ElementDefinition e = elements.get(i);
            if (e.getPath().length() >= slice.getPath().length() && (!e.getPath().equals(slice.getPath()) || slice.getSliceName().equals(e.getSliceName()))) continue;
            return i - 1;
        }
        return elements.size() - 1;
    }

    private void merge(ElementDefinition focus, ElementDefinition base) {
        if (base.hasLabel() && !focus.hasLabel()) {
            focus.setLabelElement(base.getLabelElement());
        }
        if (base.hasCode() && !focus.hasCode()) {
            focus.getCode().addAll(base.getCode());
        }
        if (base.hasShort() && !focus.hasShort()) {
            focus.setShortElement(base.getShortElement());
        }
        if (base.hasDefinition() && !focus.hasDefinition()) {
            focus.setDefinitionElement(base.getDefinitionElement());
        }
        if (base.hasComment() && !focus.hasComment()) {
            focus.setCommentElement(base.getCommentElement());
        }
        if (base.hasRequirements() && !focus.hasRequirements()) {
            focus.setRequirementsElement(base.getRequirementsElement());
        }
        if (base.hasAlias() && !focus.hasAlias()) {
            focus.getAlias().addAll(base.getAlias());
        }
        if (base.hasMin() && !focus.hasMin()) {
            focus.setMinElement(base.getMinElement());
        }
        if (base.hasMax() && !focus.hasMax()) {
            focus.setMaxElement(base.getMaxElement());
        }
        if (base.hasType() && !focus.hasType()) {
            focus.getType().addAll(base.getType());
        }
        if (base.hasDefaultValue() && !focus.hasDefaultValue()) {
            focus.setDefaultValue(base.getDefaultValue());
        }
        if (base.hasMeaningWhenMissing() && !focus.hasMeaningWhenMissing()) {
            focus.setMeaningWhenMissingElement(base.getMeaningWhenMissingElement());
        }
        if (base.hasOrderMeaning() && !focus.hasOrderMeaning()) {
            focus.setOrderMeaningElement(base.getOrderMeaningElement());
        }
        if (base.hasFixed() && !focus.hasFixed()) {
            focus.setFixed(base.getFixed());
        }
        if (base.hasPattern() && !focus.hasPattern()) {
            focus.setPattern(base.getPattern());
        }
        if (base.hasExample() && !focus.hasExample()) {
            focus.getExample().addAll(base.getExample());
        }
        if (base.hasMinValue() && !focus.hasMinValue()) {
            focus.setMinValue(base.getMinValue());
        }
        if (base.hasMaxValue() && !focus.hasMaxValue()) {
            focus.setMaxValue(base.getMaxValue());
        }
        if (base.hasMaxLength() && !focus.hasMaxLength()) {
            focus.setMaxLengthElement(base.getMaxLengthElement());
        }
        if (base.hasConstraint() && !focus.hasConstraint()) {
            focus.getConstraint().addAll(base.getConstraint());
        }
        if (base.hasMustHaveValue() && !focus.hasMustHaveValue()) {
            focus.setMustHaveValueElement(base.getMustHaveValueElement());
        }
        if (base.hasValueAlternatives() && !focus.hasValueAlternatives()) {
            focus.getValueAlternatives().addAll(base.getValueAlternatives());
        }
        if (base.hasMustSupport() && !focus.hasMustSupport()) {
            focus.setMustSupportElement(base.getMustSupportElement());
        }
        if (base.hasIsModifier() && !focus.hasIsModifier()) {
            focus.setIsModifierElement(base.getIsModifierElement());
        }
        if (base.hasIsModifierReason() && !focus.hasIsModifierReason()) {
            focus.setIsModifierReasonElement(base.getIsModifierReasonElement());
        }
        if (base.hasIsSummary() && !focus.hasIsSummary()) {
            focus.setIsSummaryElement(base.getIsSummaryElement());
        }
        if (base.hasBinding() && !focus.hasBinding()) {
            focus.setBinding(base.getBinding());
        }
    }

    private boolean isExtensionSlicing(ElementDefinition ed) {
        if (!Utilities.existsInList((String)ed.getName(), (String[])new String[]{"extension", "modiferExtension"})) {
            return false;
        }
        if (ed.getSlicing().getRules() != ElementDefinition.SlicingRules.OPEN || !ed.getSlicing().hasOrdered() || ed.getSlicing().getOrdered() || ed.getSlicing().getDiscriminator().size() != 1) {
            return false;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent d = ed.getSlicing().getDiscriminatorFirstRep();
        return d.getType() == ElementDefinition.DiscriminatorType.VALUE && "url".equals(d.getPath());
    }

    private SliceInfo getSlicing(ElementDefinition ed) {
        for (int i = this.slicings.size() - 1; i >= 0; --i) {
            SliceInfo si = this.slicings.get(i);
            if (si.closed) continue;
            if (si.path.length() > ed.getPath().length()) {
                si.closed = true;
                continue;
            }
            if (!ed.getPath().startsWith(si.path)) continue;
            return si;
        }
        return null;
    }

    public class SliceInfo {
        SliceInfo parent;
        String path;
        boolean closed;
        ElementDefinition slicer;
        List<ElementDefinition> sliceStuff;
        List<ElementDefinition> slices;

        public SliceInfo(SliceInfo parent, ElementDefinition ed) {
            this.parent = parent;
            this.path = ed.getPath();
            this.slicer = ed;
            this.sliceStuff = new ArrayList<ElementDefinition>();
            if (parent != null) {
                parent.add(ed);
            }
        }

        public void newSlice(ElementDefinition ed) {
            if (this.slices == null) {
                this.slices = new ArrayList<ElementDefinition>();
            }
            this.slices.add(ed);
            if (this.parent != null) {
                this.parent.add(ed);
            }
        }

        public void add(ElementDefinition ed) {
            if (this.slices == null) {
                this.sliceStuff.add(ed);
            }
            if (this.parent != null) {
                this.parent.add(ed);
            }
        }
    }

    public class ElementAnalysis {
        private StructureDefinition structure;
        private ElementDefinition element;
        private String type;
        public ProfileUtilities.SourcedChildDefinitions children;

        protected ElementAnalysis(StructureDefinition structure, ElementDefinition element, String type) {
            this.structure = structure;
            this.element = element;
            this.type = type;
        }

        public StructureDefinition getStructure() {
            return this.structure;
        }

        public ElementDefinition getElement() {
            return this.element;
        }

        public ProfileUtilities.SourcedChildDefinitions getChildren() {
            return this.children;
        }

        public void setChildren(ProfileUtilities.SourcedChildDefinitions children) {
            this.children = children;
        }

        public String getType() {
            return this.type;
        }

        public String summary() {
            return this.element.getName() + ":" + this.type;
        }
    }
}

