/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

@MarkedToMoveToAdjunctPackage
public interface IWorkerContext {
    public String getVersion();

    public UcumService getUcumService();

    public void setUcumService(UcumService var1);

    public IResourceValidator newValidator() throws FHIRException;

    public <T extends Resource> T fetchResource(Class<T> var1, String var2);

    public <T extends Resource> T fetchResourceRaw(Class<T> var1, String var2);

    public <T extends Resource> T fetchResourceWithException(Class<T> var1, String var2) throws FHIRException;

    public <T extends Resource> T fetchResourceWithException(Class<T> var1, String var2, Resource var3) throws FHIRException;

    public <T extends Resource> T fetchResource(Class<T> var1, String var2, String var3);

    public <T extends Resource> T fetchResource(Class<T> var1, String var2, FhirPublication var3);

    public <T extends Resource> T fetchResource(Class<T> var1, String var2, String var3, FhirPublication var4);

    public <T extends Resource> T fetchResource(Class<T> var1, String var2, Resource var3);

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> var1, FhirPublication var2);

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> var1);

    public <T extends Resource> List<T> fetchResourcesByUrl(Class<T> var1, String var2);

    public Resource fetchResourceById(String var1, String var2);

    public Resource fetchResourceById(String var1, String var2, FhirPublication var3);

    public <T extends Resource> boolean hasResource(Class<T> var1, String var2);

    public <T extends Resource> boolean hasResource(Class<T> var1, String var2, Resource var3);

    public <T extends Resource> boolean hasResource(Class<T> var1, String var2, FhirPublication var3);

    public void cacheResource(Resource var1) throws FHIRException;

    public void cacheResourceFromPackage(Resource var1, PackageInformation var2) throws FHIRException;

    public void cachePackage(PackageInformation var1);

    public List<String> getResourceNames();

    public List<String> getResourceNames(FhirPublication var1);

    public Set<String> getResourceNamesAsSet();

    public Set<String> getResourceNamesAsSet(FhirPublication var1);

    public Parameters getExpansionParameters();

    public void setExpansionParameters(Parameters var1);

    public CodeSystem fetchCodeSystem(String var1);

    public CodeSystem fetchCodeSystem(String var1, String var2);

    public CodeSystem fetchCodeSystem(String var1, FhirPublication var2);

    public CodeSystem fetchCodeSystem(String var1, String var2, FhirPublication var3);

    public CodeSystem fetchSupplementedCodeSystem(String var1);

    public CodeSystem fetchSupplementedCodeSystem(String var1, String var2);

    public CodeSystem fetchSupplementedCodeSystem(String var1, FhirPublication var2);

    public CodeSystem fetchSupplementedCodeSystem(String var1, String var2, FhirPublication var3);

    public boolean supportsSystem(String var1) throws TerminologyServiceException;

    public boolean supportsSystem(String var1, FhirPublication var2) throws TerminologyServiceException;

    public ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2, boolean var3);

    public ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2, boolean var3, int var4);

    public ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2, boolean var3, boolean var4);

    public ValueSetExpansionOutcome expandVS(String var1, boolean var2, boolean var3, int var4);

    public ValueSetExpansionOutcome expandVS(Resource var1, ElementDefinition.ElementDefinitionBindingComponent var2, boolean var3, boolean var4) throws FHIRException;

    public ValueSetExpansionOutcome expandVS(ITerminologyOperationDetails var1, ValueSet.ConceptSetComponent var2, boolean var3, boolean var4) throws TerminologyServiceException;

    public Locale getLocale();

    public void setLocale(Locale var1);

    public void setValidationMessageLanguage(Locale var1);

    public String formatMessage(String var1, Object ... var2);

    public String formatMessagePlural(Integer var1, String var2, Object ... var3);

    public ValidationResult validateCode(ValidationOptions var1, String var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, String var2, String var3, String var4, String var5);

    public ValidationResult validateCode(ValidationOptions var1, String var2, String var3, String var4, String var5, ValueSet var6);

    public ValidationResult validateCode(ValidationOptions var1, CodeableConcept var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, Coding var2, ValueSet var3);

    public ValidationResult validateCode(ValidationOptions var1, Coding var2, ValueSet var3, ValidationContextCarrier var4);

    public void validateCodeBatch(ValidationOptions var1, List<? extends CodingValidationRequest> var2, ValueSet var3);

    public void validateCodeBatchByRef(ValidationOptions var1, List<? extends CodingValidationRequest> var2, String var3);

    public Map<String, NamingSystem> getNSUrlMap();

    public void setLogger(@Nonnull org.hl7.fhir.r5.context.ILoggingService var1);

    public org.hl7.fhir.r5.context.ILoggingService getLogger();

    public boolean isNoTerminologyServer();

    public Set<String> getCodeSystemsUsed();

    public int getClientRetryCount();

    public IWorkerContext setClientRetryCount(int var1);

    public TimeTracker clock();

    public StructureDefinition fetchTypeDefinition(String var1);

    public StructureDefinition fetchTypeDefinition(String var1, FhirPublication var2);

    public List<StructureDefinition> fetchTypeDefinitions(String var1);

    public List<StructureDefinition> fetchTypeDefinitions(String var1, FhirPublication var2);

    public boolean isPrimitiveType(String var1);

    public boolean isDataType(String var1);

    public Set<String> getBinaryKeysAsSet();

    public boolean hasBinaryKey(String var1);

    public byte[] getBinaryForKey(String var1);

    public int loadFromPackage(NpmPackage var1, IContextResourceLoader var2) throws FileNotFoundException, IOException, FHIRException;

    @Deprecated
    public int loadFromPackage(NpmPackage var1, IContextResourceLoader var2, List<String> var3) throws FileNotFoundException, IOException, FHIRException;

    public int loadFromPackageAndDependencies(NpmPackage var1, IContextResourceLoader var2, BasePackageCacheManager var3) throws FileNotFoundException, IOException, FHIRException;

    public boolean hasPackage(String var1, String var2);

    public boolean hasPackage(PackageInformation var1);

    public PackageInformation getPackage(String var1, String var2);

    public PackageInformation getPackageForUrl(String var1);

    public IWorkerContextManager.IPackageLoadingTracker getPackageTracker();

    public IWorkerContext setPackageTracker(IWorkerContextManager.IPackageLoadingTracker var1);

    public String getSpecUrl();

    public PEBuilder getProfiledElementBuilder(PEBuilder.PEElementPropertiesPolicy var1, boolean var2);

    public boolean isForPublication();

    public void setForPublication(boolean var1);

    public OIDSummary urlsForOid(String var1, String var2);

    public <T extends Resource> T findTxResource(Class<T> var1, String var2, Resource var3);

    public <T extends Resource> T findTxResource(Class<T> var1, String var2);

    public <T extends Resource> T findTxResource(Class<T> var1, String var2, String var3);

    public Boolean subsumes(ValidationOptions var1, Coding var2, Coding var3);

    public boolean isServerSideSystem(String var1);

    public static class OIDSummary {
        private List<OIDDefinition> definitions = new ArrayList<OIDDefinition>();
        private List<String> urls = new ArrayList<String>();

        public void addOID(OIDDefinition d) {
            for (OIDDefinition t : this.definitions) {
                if (!d.matches(t)) continue;
                return;
            }
            this.definitions.add(d);
            if (!this.urls.contains(d.getUrl())) {
                this.urls.add(d.getUrl());
            }
        }

        public void addOIDs(Collection<OIDDefinition> collection) {
            for (OIDDefinition t : collection) {
                this.addOID(t);
            }
        }

        public List<OIDDefinition> getDefinitions() {
            return this.definitions;
        }

        public void sort() {
            Collections.sort(this.definitions, new OIDDefinitionComparer());
            Collections.sort(this.urls);
        }

        public String describe() {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (OIDDefinition d : this.definitions) {
                b.append(d.summary());
            }
            return b.toString();
        }

        public String chooseBestUrl() {
            for (OIDDefinition d : this.definitions) {
                if (d.getPackageSrc() != null) continue;
                return d.getUrl();
            }
            for (OIDDefinition d : this.definitions) {
                if (!d.getUrl().startsWith("http://hl7.org/fhir/")) continue;
                return d.getUrl();
            }
            for (OIDDefinition d : this.definitions) {
                if (d.getUrl().contains("vsac")) continue;
                return d.getUrl();
            }
            return null;
        }

        public int urlCount() {
            return this.urls.size();
        }

        public String getUrl() {
            return this.urls.iterator().next();
        }
    }

    public static class OIDDefinition {
        private String type;
        private String oid;
        private String url;
        private String version;
        private String packageSrc;
        private String status;

        protected OIDDefinition(String type, String oid, String url, String version, String status, String packageSrc) {
            this.type = type;
            this.oid = oid;
            this.url = url;
            this.version = version == null ? "" : version;
            this.packageSrc = packageSrc;
            this.status = status;
        }

        public String getType() {
            return this.type;
        }

        public String getOid() {
            return this.oid;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getStatus() {
            return this.status;
        }

        public String getPackageSrc() {
            return this.packageSrc;
        }

        public String summary() {
            return this.url + (String)(this.version == null ? "" : "|" + this.version) + (String)(this.packageSrc != null ? "(" + this.packageSrc + ")" : "");
        }

        public boolean matches(OIDDefinition t) {
            return this.url.equals(t.url) && this.version.equals(t.version);
        }
    }

    public static class OIDDefinitionComparer
    implements Comparator<OIDDefinition> {
        @Override
        public int compare(OIDDefinition o1, OIDDefinition o2) {
            if (o1.getUrl().equals(o2.getUrl())) {
                return -o1.getVersion().compareTo(o2.getVersion());
            }
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }

    @Deprecated(forRemoval=true)
    public static interface ILoggingService
    extends org.hl7.fhir.r5.context.ILoggingService {
    }

    public static interface ITerminologyOperationDetails {
        public void seeSupplement(CodeSystem var1);
    }
}

