/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class SystemOutLoggingService
implements ILoggingService {
    private final boolean debug;

    public SystemOutLoggingService() {
        this(false);
    }

    @Override
    public void logMessage(String message) {
        System.out.println(message);
    }

    @Override
    public void logDebugMessage(ILoggingService.LogCategory category, String message) {
        if (this.debug) {
            System.out.println(" -" + category.name().toLowerCase() + ": " + message);
        }
    }

    @Override
    public boolean isDebugLogging() {
        return this.debug;
    }

    public SystemOutLoggingService(boolean debug) {
        this.debug = debug;
    }
}

