/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.CanonicalResourceManager;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class TypeManager {
    private CanonicalResourceManager<StructureDefinition> structures;
    private Map<String, Set<StructureDefinition>> typeDefinitions = new HashMap<String, Set<StructureDefinition>>();
    private Map<String, Set<StructureDefinition>> fhirTypeDefinitions = new HashMap<String, Set<StructureDefinition>>();
    private Set<String> primitiveNames = new HashSet<String>();
    private Set<String> dataTypeNames = new HashSet<String>();

    public TypeManager(CanonicalResourceManager<StructureDefinition> structures) {
        this.structures = structures;
        this.reload();
    }

    public void reload() {
        this.typeDefinitions.clear();
        this.primitiveNames.clear();
        this.dataTypeNames.clear();
        for (CanonicalResourceManager.CachedCanonicalResource<StructureDefinition> cr : this.structures.getCachedList()) {
            if ("constraint".equals(cr.getDerivation())) continue;
            this.see(cr.getResource());
        }
    }

    protected Iterable<String> getTypeNames() {
        return this.typeDefinitions.keySet();
    }

    public void see(CanonicalResourceManager.CanonicalResourceProxy r) {
        if (!"constraint".equals(r.getDerivation())) {
            this.see((StructureDefinition)r.getResource());
        }
    }

    public void see(StructureDefinition sd) {
        if (!(sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT || sd.getSourcePackage() != null && sd.getSourcePackage().isExamplesPackage())) {
            String type = sd.getType();
            Set<StructureDefinition> types = this.typeDefinitions.get(type);
            if (types == null) {
                types = new HashSet<StructureDefinition>();
                this.typeDefinitions.put(type, types);
            }
            types.add(sd);
            if (sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/") || "true".equals(sd.getUserString("loader-custom-resource"))) {
                types = this.fhirTypeDefinitions.get(type);
                if (types == null) {
                    types = new HashSet<StructureDefinition>();
                    this.fhirTypeDefinitions.put(type, types);
                }
                types.add(sd);
            }
            if (Utilities.isAbsoluteUrl((String)type)) {
                type = sd.getTypeTail();
                types = this.typeDefinitions.get(type);
                if (types == null) {
                    types = new HashSet<StructureDefinition>();
                    this.typeDefinitions.put(type, types);
                }
                types.add(sd);
            }
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                this.primitiveNames.add(sd.getType());
            } else if (sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE) {
                this.dataTypeNames.add(sd.getType());
            }
        }
    }

    public List<StructureDefinition> getDefinitions(String typeName) {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        Set<StructureDefinition> defined = this.typeDefinitions.get(typeName);
        if (defined != null) {
            list.addAll(defined);
        }
        return list;
    }

    public StructureDefinition fetchTypeDefinition(String typeName) {
        Set<StructureDefinition> types = this.typeDefinitions.get(typeName);
        if (types == null) {
            return null;
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        types = this.fhirTypeDefinitions.get(typeName);
        if (types == null) {
            return null;
        }
        if (types.size() != 1) {
            throw new FHIRException("Ambiguous type " + typeName + " (" + types.toString() + ") (contact Grahame Grieve for investigation)");
        }
        return types.iterator().next();
    }

    public boolean isPrimitive(String type) {
        if (this.primitiveNames.contains(type) || Utilities.existsInList((String)type, (String[])new String[]{"boolean", "integer", "integer64", "string", "decimal", "uri", "base64Binary", "instant", "date", "dateTime", "time", "code", "oid", "id", "markdown", "unsignedInt", "positiveInt", "uuid", "xhtml", "url", "canonical"})) {
            return true;
        }
        StructureDefinition sd = this.structures.get(type);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    public boolean isDataType(String type) {
        if (this.dataTypeNames.contains(type) || Utilities.existsInList((String)type, (String[])new String[]{"Address", "Age", "Annotation", "Attachment", "CodeableConcept", "Coding", "ContactPoint", "Count", "Distance", "Duration", "HumanName", "Identifier", "Money", "Period", "Quantity", "Range", "Ratio", "Reference", "SampledData", "Signature", "Timing", "ContactDetail", "Contributor", "DataRequirement", "Expression", "ParameterDefinition", "RelatedArtifact", "TriggerDefinition", "UsageContext"})) {
            return true;
        }
        StructureDefinition sd = this.structures.get(type);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE;
    }

    public void unload() {
        this.structures.unload();
        this.typeDefinitions.clear();
        this.fhirTypeDefinitions.clear();
        this.primitiveNames.clear();
        this.dataTypeNames.clear();
    }
}

