/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.SnomedExpressions;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.NamedItemList;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.turtle.Turtle;
import org.hl7.fhir.utilities.validation.ValidationMessage;

@MarkedToMoveToAdjunctPackage
public class TurtleParser
extends ParserBase {
    private String base;
    private IParser.OutputStyle style;
    public static String FHIR_URI_BASE = "http://hl7.org/fhir/";
    public static String FHIR_VERSION_BASE = "http://build.fhir.org/";

    public TurtleParser(IWorkerContext context) {
        super(context);
    }

    @Override
    public List<ValidatedFragment> parse(InputStream inStream) throws IOException, FHIRException {
        byte[] content = FileUtilities.streamToBytes((InputStream)inStream);
        ValidatedFragment focusFragment = new ValidatedFragment("focus", "ttl", content, false);
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        Turtle src = new Turtle();
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            try {
                src.parse(FileUtilities.streamToString((InputStream)stream));
            }
            catch (Exception e) {
                this.logError(focusFragment.getErrors(), ValidationMessage.NO_RULE_DATE, -1, -1, "(document)", ValidationMessage.IssueType.INVALID, this.context.formatMessage("Error_parsing_Turtle_", e.getMessage()), ValidationMessage.IssueSeverity.FATAL);
                return null;
            }
            focusFragment.setElement(this.parse(focusFragment.getErrors(), src));
        } else {
            src.parse(FileUtilities.streamToString((InputStream)stream));
            focusFragment.setElement(this.parse(focusFragment.getErrors(), src));
        }
        ArrayList<ValidatedFragment> res = new ArrayList<ValidatedFragment>();
        res.add(focusFragment);
        return res;
    }

    private Element parse(List<ValidationMessage> errors, Turtle src) throws FHIRException {
        for (Turtle.TTLComplex cmp : src.getObjects().values()) {
            for (String p : cmp.getPredicates().keySet()) {
                if (!(FHIR_URI_BASE + "nodeRole").equals(p) || !((Turtle.TTLObject)cmp.getPredicates().get(p)).hasValue(FHIR_URI_BASE + "treeRoot")) continue;
                return this.parse(errors, src, cmp);
            }
        }
        String msg = "Error parsing Turtle: unable to find any node maked as the entry point (where " + FHIR_URI_BASE + "nodeRole = " + FHIR_URI_BASE + "treeRoot)";
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, -1, -1, "(document)", ValidationMessage.IssueType.INVALID, msg, ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        throw new FHIRFormatError(msg);
    }

    private Element parse(List<ValidationMessage> errors, Turtle src, Turtle.TTLComplex cmp) throws FHIRException {
        Turtle.TTLObject type = (Turtle.TTLObject)cmp.getPredicates().get("http://www.w3.org/2000/01/rdf-schema#type");
        if (type == null) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, cmp.getLine(), cmp.getCol(), "(document)", ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unknown_resource_type_missing_rdfstype", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        if (type instanceof Turtle.TTLList) {
            for (Turtle.TTLObject obj : ((Turtle.TTLList)type).getList()) {
                if (!(obj instanceof Turtle.TTLURL) || !((Turtle.TTLURL)obj).getUri().startsWith(FHIR_URI_BASE)) continue;
                type = obj;
                break;
            }
        }
        if (!(type instanceof Turtle.TTLURL)) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, cmp.getLine(), cmp.getCol(), "(document)", ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unexpected_datatype_for_rdfstype", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        String name = ((Turtle.TTLURL)type).getUri();
        String ns = name.substring(0, name.lastIndexOf("/"));
        name = name.substring(name.lastIndexOf("/") + 1);
        String path = "/" + name;
        StructureDefinition sd = this.getDefinition(errors, cmp.getLine(), cmp.getCol(), ns, name);
        if (sd == null) {
            return null;
        }
        Element result = new Element(name, new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.getProfileUtilities(), this.getContextUtilities())).setFormat(Manager.FhirFormat.TURTLE);
        result.markLocation(cmp.getLine(), cmp.getCol());
        result.setType(name);
        this.parseChildren(errors, src, path, cmp, result, false);
        result.numberChildren();
        return result;
    }

    private void parseChildren(List<ValidationMessage> errors, Turtle src, String path, Turtle.TTLComplex object, Element element, boolean primitive) throws FHIRException {
        List<Property> properties = element.getProperty().getChildProperties(element.getName(), null);
        HashSet<String> processed = new HashSet<String>();
        if (primitive) {
            processed.add(FHIR_URI_BASE + "value");
        }
        for (Property property : properties) {
            if (property.isChoice()) {
                for (ElementDefinition.TypeRefComponent type : property.getDefinition().getType()) {
                    String eName = property.getName().substring(0, property.getName().length() - 3) + Utilities.capitalize((String)type.getCode());
                    this.parseChild(errors, src, object, element, processed, property, path, this.getFormalName(property, eName));
                }
                continue;
            }
            this.parseChild(errors, src, object, element, processed, property, path, this.getFormalName(property));
        }
        if (this.policy != ParserBase.ValidationPolicy.NONE) {
            for (String u : object.getPredicates().keySet()) {
                if (processed.contains(u)) continue;
                Turtle.TTLObject n = (Turtle.TTLObject)object.getPredicates().get(u);
                this.logError(errors, ValidationMessage.NO_RULE_DATE, n.getLine(), n.getCol(), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Unrecognised_predicate_", u), ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private void parseChild(List<ValidationMessage> errors, Turtle src, Turtle.TTLComplex object, Element context, Set<String> processed, Property property, String path, String name) throws FHIRException {
        processed.add(name);
        String npath = path + "/" + property.getName();
        Turtle.TTLObject e = (Turtle.TTLObject)object.getPredicates().get(FHIR_URI_BASE + name);
        if (e == null) {
            return;
        }
        if (property.isList() && e instanceof Turtle.TTLList) {
            Turtle.TTLList arr = (Turtle.TTLList)e;
            for (Turtle.TTLObject am : arr.getList()) {
                this.parseChildInstance(errors, src, npath, object, context, property, name, am);
            }
        } else {
            this.parseChildInstance(errors, src, npath, object, context, property, name, e);
        }
    }

    private void parseChildInstance(List<ValidationMessage> errors, Turtle src, String npath, Turtle.TTLComplex object, Element element, Property property, String name, Turtle.TTLObject e) throws FHIRException {
        if (property.isResource()) {
            this.parseResource(errors, src, npath, object, element, property, name, e);
        } else if (e instanceof Turtle.TTLComplex) {
            Turtle.TTLComplex child = (Turtle.TTLComplex)e;
            Element n = new Element(this.tail(name), property).markLocation(e.getLine(), e.getCol()).setFormat(Manager.FhirFormat.TURTLE);
            element.getChildren().add((NamedItemList.NamedItem)n);
            if (property.isPrimitive(property.getType(this.tail(name)))) {
                this.parseChildren(errors, src, npath, child, n, true);
                Turtle.TTLObject val = (Turtle.TTLObject)child.getPredicates().get(FHIR_URI_BASE + "value");
                if (val != null) {
                    if (val instanceof Turtle.TTLLiteral) {
                        String value = ((Turtle.TTLLiteral)val).getValue();
                        String type = ((Turtle.TTLLiteral)val).getType();
                        n.setValue(value);
                    } else {
                        this.logError(errors, ValidationMessage.NO_RULE_DATE, object.getLine(), object.getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_a_Literal_not_", "a " + e.getClass().getName()), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            } else {
                this.parseChildren(errors, src, npath, child, n, false);
            }
        } else {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, object.getLine(), object.getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("This_property_must_be_a_URI_or_bnode_not_", "a " + e.getClass().getName()), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private String tail(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private void parseResource(List<ValidationMessage> errors, Turtle src, String npath, Turtle.TTLComplex object, Element element, Property property, String name, Turtle.TTLObject e) throws FHIRException {
        Turtle.TTLComplex obj;
        if (e instanceof Turtle.TTLComplex) {
            obj = (Turtle.TTLComplex)e;
        } else if (e instanceof Turtle.TTLURL) {
            String url = ((Turtle.TTLURL)e).getUri();
            obj = src.getObject(url);
            if (obj == null) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, e.getLine(), e.getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("reference_to__cannot_be_resolved", url), ValidationMessage.IssueSeverity.FATAL);
                return;
            }
        } else {
            throw new FHIRFormatError(this.context.formatMessage("Wrong_type_for_resource", new Object[0]));
        }
        Turtle.TTLObject type = (Turtle.TTLObject)obj.getPredicates().get("http://www.w3.org/2000/01/rdf-schema#type");
        if (type == null) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, object.getLine(), object.getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unknown_resource_type_missing_rdfstype", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return;
        }
        if (type instanceof Turtle.TTLList) {
            for (Turtle.TTLObject tobj : ((Turtle.TTLList)type).getList()) {
                if (!(tobj instanceof Turtle.TTLURL) || !((Turtle.TTLURL)tobj).getUri().startsWith(FHIR_URI_BASE)) continue;
                type = tobj;
                break;
            }
        }
        if (!(type instanceof Turtle.TTLURL)) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, object.getLine(), object.getCol(), npath, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Unexpected_datatype_for_rdfstype", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return;
        }
        String rt = ((Turtle.TTLURL)type).getUri();
        String ns = rt.substring(0, rt.lastIndexOf("/"));
        rt = rt.substring(rt.lastIndexOf("/") + 1);
        StructureDefinition sd = this.getDefinition(errors, object.getLine(), object.getCol(), ns, rt);
        if (sd == null) {
            return;
        }
        Element n = new Element(this.tail(name), property).markLocation(object.getLine(), object.getCol()).setFormat(Manager.FhirFormat.TURTLE);
        element.getChildren().add((NamedItemList.NamedItem)n);
        n.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.getProfileUtilities(), this.getContextUtilities()), Element.SpecialElement.fromProperty(n.getProperty()), property);
        n.setType(rt);
        this.parseChildren(errors, src, npath, obj, n, false);
    }

    private String getFormalName(Property property) {
        String en = property.getDefinition().getBase().getPath();
        if (en == null) {
            en = property.getDefinition().getPath();
        }
        return en;
    }

    private String getFormalName(Property property, String elementName) {
        String en = property.getDefinition().getBase().getPath();
        if (en == null) {
            en = property.getDefinition().getPath();
        }
        if (!en.endsWith("[x]")) {
            throw new Error(this.context.formatMessage("Attempt_to_replace_element_name_for_a_nonchoice_type", new Object[0]));
        }
        return en.substring(0, en.lastIndexOf(".") + 1) + elementName;
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String base) throws IOException, FHIRException {
        this.base = base != null ? base : "http://hl7.org/fhir/";
        this.style = style;
        Turtle ttl = new Turtle();
        this.compose(e, ttl, base);
        ttl.commit(stream, false);
    }

    public void compose(Element e, Turtle ttl, String base) throws FHIRException {
        if (e.getPath() == null) {
            e.populatePaths(null);
        }
        ttl.prefix("fhir", FHIR_URI_BASE);
        ttl.prefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ttl.prefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        ttl.prefix("owl", "http://www.w3.org/2002/07/owl#");
        ttl.prefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        Turtle.Section section = ttl.section("resource");
        if (this.style == IParser.OutputStyle.PRETTY) {
            for (String s : e.getComments()) {
                section.stringComment(s);
            }
        }
        String subjId = this.genSubjectId(e);
        Turtle.Subject subject = this.hasModifierExtension(e) ? section.triple(subjId, "a", "fhir:_" + e.getType()) : section.triple(subjId, "a", "fhir:" + e.getType());
        subject.linkedPredicate("fhir:nodeRole", "fhir:treeRoot", this.linkResolver == null ? null : this.linkResolver.resolvePage("rdf.html#tree-root"), null);
        for (Element child : e.getChildren()) {
            this.composeElement(section, (Turtle.Complex)subject, child, null);
        }
    }

    private boolean hasModifierExtension(Element e) {
        return e.getChildren().stream().anyMatch(p -> p.getName().equals("modifierExtension"));
    }

    protected String getURIType(String uri) {
        if (uri.startsWith("<" + FHIR_URI_BASE) && uri.substring(FHIR_URI_BASE.length() + 1).contains("/")) {
            return uri.substring(FHIR_URI_BASE.length() + 1, uri.indexOf(47, FHIR_URI_BASE.length() + 1));
        }
        return null;
    }

    protected String getReferenceURI(String ref) {
        if (ref != null && (ref.startsWith("http://") || ref.startsWith("https://"))) {
            return "<" + ref + ">";
        }
        if (this.base != null && ref != null && ref.contains("/")) {
            return "<" + Utilities.appendForwardSlash((String)this.base) + ref + ">";
        }
        return null;
    }

    protected void decorateReference(Turtle.Complex t, Element coding) {
        String refURI = this.getReferenceURI(coding.getChildValue("reference"));
        if (refURI != null) {
            t.linkedPredicate("fhir:link", refURI, this.linkResolver == null ? null : this.linkResolver.resolvePage("rdf.html#reference"), null);
        }
    }

    protected void decorateCanonical(Turtle.Complex t, Element canonical) {
        String refURI = this.getReferenceURI(canonical.primitiveValue());
        if (refURI != null) {
            t.linkedPredicate("fhir:link", refURI, this.linkResolver == null ? null : this.linkResolver.resolvePage("rdf.html#reference"), null);
        }
    }

    private String genSubjectId(Element e) {
        String id = e.getChildValue("id");
        if (this.base == null || id == null) {
            return "";
        }
        if (this.base.endsWith("#")) {
            return "<" + this.base + e.getType() + "-" + id + ">";
        }
        return "<" + Utilities.pathURL((String[])new String[]{this.base, e.getType(), id}) + ">";
    }

    private String urlescape(String s) {
        StringBuilder b = new StringBuilder();
        for (char ch : s.toCharArray()) {
            if (Utilities.charInSet((char)ch, (char[])new char[]{':', ';', '=', ','})) {
                b.append("%" + Integer.toHexString(ch));
                continue;
            }
            b.append(ch);
        }
        return b.toString();
    }

    private void composeElement(Turtle.Section section, Turtle.Complex ctxt, Element element, Element parent) throws FHIRException {
        String uriType;
        String refURI;
        Turtle.Complex t;
        String en = this.getFormalName(element);
        if (!this.wantCompose(parent == null ? "" : parent.getPath(), element)) {
            return;
        }
        String comment = null;
        if (this.style == IParser.OutputStyle.PRETTY) {
            comment = String.join((CharSequence)", ", element.getComments());
        }
        if (element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY && parent != null && parent.getNamedChildValue("fullUrl") != null) {
            String url = "<" + parent.getNamedChildValue("fullUrl") + ">";
            ctxt.linkedPredicate("fhir:" + en, url, this.linkResolver == null ? null : this.linkResolver.resolveProperty(element.getProperty()), comment, element.getProperty().isList());
            t = section.subject(url);
        } else {
            t = ctxt.linkedPredicate("fhir:" + en, this.linkResolver == null ? null : this.linkResolver.resolveProperty(element.getProperty()), comment, element.getProperty().isList());
        }
        if (element.getProperty().getName().endsWith("[x]")) {
            t.linkedPredicate("a", "fhir:" + element.fhirType(), this.linkResolver == null ? null : this.linkResolver.resolveType(element.fhirType()), null);
        }
        if (element.getSpecial() != null) {
            t.linkedPredicate("a", "fhir:" + element.fhirType(), this.linkResolver == null ? null : this.linkResolver.resolveType(element.fhirType()), null);
        }
        if (element.hasValue()) {
            t.linkedPredicate("fhir:v", TurtleParser.ttlLiteral(element.getValue(), element.getType()), this.linkResolver == null ? null : this.linkResolver.resolveType(element.getType()), null);
        }
        if ("Coding".equals(element.getType())) {
            this.decorateCoding(t, element, section);
        }
        if (Utilities.existsInList((String)element.getType(), (String[])new String[]{"Reference"})) {
            this.decorateReference(t, element);
        } else if (Utilities.existsInList((String)element.getType(), (String[])new String[]{"canonical"})) {
            this.decorateCanonical(t, element);
        }
        if ("canonical".equals(element.getType()) && (refURI = element.primitiveValue()) != null && (uriType = this.getURIType(refURI)) != null && !section.hasSubject(refURI)) {
            section.triple(refURI, "a", "fhir:" + uriType);
        }
        if ("Reference".equals(element.getType()) && (refURI = this.getReferenceURI(element.getChildValue("reference"))) != null && (uriType = this.getURIType(refURI)) != null && !section.hasSubject(refURI)) {
            section.triple(refURI, "a", "fhir:" + uriType);
        }
        for (Element child : element.getChildren()) {
            if ("xhtml".equals(child.getType())) {
                String childfn = this.getFormalName(child);
                t.predicate("fhir:" + childfn, TurtleParser.ttlLiteral(child.getValue(), child.getType()));
                continue;
            }
            this.composeElement(section, t, child, element);
        }
    }

    private String getFormalName(Element element) {
        String en = null;
        en = element.getSpecial() == null ? element.getProperty().getName() : (element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY ? "resource" : (element.getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME ? "outcome" : (element.getSpecial() == Element.SpecialElement.BUNDLE_ISSUES ? "issues" : (element.getSpecial() == Element.SpecialElement.PARAMETER ? element.getElementProperty().getDefinition().getPath() : "contained"))));
        if (en == null) {
            en = element.getProperty().getName();
        }
        if (en.endsWith("[x]")) {
            en = en.substring(0, en.length() - 3);
        }
        if (this.hasModifierExtension(element)) {
            return "_" + en;
        }
        return en;
    }

    public static String ttlLiteral(String value, String type) {
        boolean quote = true;
        String xst = "";
        if (type.equals("boolean")) {
            quote = false;
        } else if (type.equals("integer")) {
            quote = false;
        } else if (type.equals("integer64")) {
            xst = "^^xsd:long";
        } else if (type.equals("unsignedInt")) {
            xst = "^^xsd:nonNegativeInteger";
        } else if (type.equals("positiveInt")) {
            xst = "^^xsd:positiveInteger";
        } else if (type.equals("decimal")) {
            if (value.contains(".")) {
                quote = false;
            } else {
                xst = "^^xsd:decimal";
            }
        } else if (type.equals("base64Binary")) {
            xst = "^^xsd:base64Binary";
        } else if (type.equals("canonical") || type.equals("oid") || type.equals("uri") || type.equals("url") || type.equals("uuid")) {
            xst = "^^xsd:anyURI";
        } else if (type.equals("xhtml")) {
            xst = "^^rdf:XMLLiteral";
        } else if (type.equals("instant")) {
            xst = "^^xsd:dateTime";
        } else if (type.equals("time")) {
            xst = "^^xsd:time";
        } else if (type.equals("date") || type.equals("dateTime")) {
            String v = value;
            if (v.length() > 10) {
                int i = value.substring(10).indexOf("-");
                if (i == -1) {
                    i = value.substring(10).indexOf("+");
                }
                String string = v = i == -1 ? value : value.substring(0, 10 + i);
            }
            if (v.length() > 10) {
                xst = "^^xsd:dateTime";
            } else if (v.length() == 10) {
                xst = "^^xsd:date";
            } else if (v.length() == 7) {
                xst = "^^xsd:gYearMonth";
            } else if (v.length() == 4) {
                xst = "^^xsd:gYear";
            }
        }
        if (quote) {
            return "\"" + Turtle.escape((String)value, (boolean)true) + "\"" + xst;
        }
        return value;
    }

    protected void decorateCoding(Turtle.Complex t, Element coding, Turtle.Section section) throws FHIRException {
        String system = coding.getChildValue("system");
        String code = coding.getChildValue("code");
        if (system == null || code == null) {
            return;
        }
        if ("http://snomed.info/sct".equals(system)) {
            t.prefix("sct", "http://snomed.info/id/");
            if (code.contains(":") || code.contains("=")) {
                this.generateLinkedPredicate(t, code);
            } else {
                t.linkedPredicate("a", "sct:" + this.urlescape(code), null, null);
            }
        } else if ("http://loinc.org".equals(system)) {
            t.prefix("loinc", "https://loinc.org/rdf/");
            t.linkedPredicate("a", "loinc:" + this.urlescape(code).toUpperCase(), null, null);
        } else if ("https://www.nlm.nih.gov/mesh".equals(system)) {
            t.prefix("mesh", "http://id.nlm.nih.gov/mesh/");
            t.linkedPredicate("a", "mesh:" + this.urlescape(code), null, null);
        }
    }

    private void generateLinkedPredicate(Turtle.Complex t, String code) throws FHIRException {
        SnomedExpressions.Expression expression = SnomedExpressions.parse(code);
    }

    public IParser.OutputStyle getStyle() {
        return this.style;
    }

    public void setStyle(IParser.OutputStyle style) {
        this.style = style;
    }
}

