/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.ips;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class IPSRenderer {
    private ITerminologyClient tx;
    private String folder;
    private Map<String, byte[]> binaries;
    private ITemplateImplementer templater;
    private Map<String, String> headers;

    public IPSRenderer(ITerminologyClient tx, String folder, Map<String, byte[]> binaries, ITemplateImplementer templater) {
        this.tx = tx;
        this.folder = folder;
        this.binaries = binaries;
        this.templater = templater;
    }

    public IPSRenderer(ITerminologyClient tx, String folder, Map<String, byte[]> binaries) {
        this.tx = tx;
        this.folder = folder;
        this.binaries = binaries;
        this.templater = new InternalTemplateEngine();
    }

    public String render(Bundle document) throws IOException {
        this.headers = new HashMap<String, String>();
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        this.generate(x, document);
        return this.templater.buildPage(this.headers, new XhtmlComposer(false, true).compose(x));
    }

    private void generate(XhtmlNode x, Bundle document) {
        Composition cmp = (Composition)document.getEntryFirstRep().getResource();
        int sectionDepth = this.findSectionDepth(cmp.getSection());
        XhtmlNode table = x.table("grid", false);
        XhtmlNode tr = table.tr();
        XhtmlNode td = tr.td().colspan(1 + sectionDepth);
        td.b().tx("Provided");
        td = tr.td().colspan(1 + sectionDepth);
        td.b().tx("Generated");
        DomainResource subject = this.findResource(document, cmp.getSubjectFirstRep());
        tr = table.tr();
        td = tr.td().colspan(1 + sectionDepth);
        td = tr.td().colspan(1 + sectionDepth);
        td.b().tx("Generated");
    }

    private DomainResource findResource(Bundle document, Reference subject) {
        return null;
    }

    private int findSectionDepth(List<Composition.SectionComponent> list) {
        int i = 1;
        for (Composition.SectionComponent sect : list) {
            i = Integer.max(i, 1 + this.findSectionDepth(sect.getSection()));
        }
        return i;
    }

    private static interface ITemplateImplementer {
        public String buildPage(Map<String, String> var1, String var2);
    }

    public class InternalTemplateEngine
    implements ITemplateImplementer {
        @Override
        public String buildPage(Map<String, String> headers, String content) {
            return null;
        }
    }
}

