/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.liquid;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;

@MarkedToMoveToAdjunctPackage
public class BaseJsonWrapper
extends Base {
    private static final long serialVersionUID = 1L;
    private JsonElement j;

    public BaseJsonWrapper(JsonElement j) {
        this.j = j;
    }

    @Override
    public String fhirType() {
        switch (this.j.type()) {
            case BOOLEAN: {
                return "boolean";
            }
            case NUMBER: {
                return "decimal";
            }
            case OBJECT: {
                return "Object";
            }
            case STRING: {
                return "string";
            }
        }
        throw new Error("Shouldn't get here");
    }

    @Override
    public String getIdBase() {
        if (this.j.isJsonObject()) {
            return this.j.asJsonObject().asString("id");
        }
        return null;
    }

    @Override
    public void setIdBase(String value) {
        throw new Error("BaseJsonWrapper is read only");
    }

    @Override
    public Base copy() {
        throw new Error("BaseJsonWrapper is read only");
    }

    @Override
    public FhirPublication getFHIRPublicationVersion() {
        return FhirPublication.R5;
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if (this.j.isJsonObject() && this.j.asJsonObject().has(name)) {
            JsonElement e = this.j.asJsonObject().get(name);
            if (e.isJsonArray()) {
                JsonArray a = e.asJsonArray();
                Base[] l = new Base[a.size().intValue()];
                for (int i = 0; i < a.size(); ++i) {
                    l[i] = new BaseJsonWrapper(a.get(i));
                }
                return l;
            }
            Base[] l = new Base[]{new BaseJsonWrapper(e)};
            return l;
        }
        return super.getProperty(hash, name, checkValid);
    }

    public String toString() {
        if (this.j.isJsonPrimitive()) {
            return this.j.asString();
        }
        return super.toString();
    }

    @Override
    public boolean isPrimitive() {
        return this.j.isJsonPrimitive();
    }

    @Override
    public String primitiveValue() {
        return this.toString();
    }
}

