/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VirtualServiceDetail;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Appointment", profile="http://hl7.org/fhir/StructureDefinition/Appointment")
public class Appointment
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | pending | booked | arrived | fulfilled | cancelled | noshow | entered-in-error | checked-in | waitlist", formalDefinition="The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/appointmentstatus")
    protected Enumeration<AppointmentStatus> status;
    @Child(name="cancellationReason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The coded reason for the appointment being cancelled", formalDefinition="The coded reason for the appointment being cancelled. This is often used in reporting/billing/futher processing to determine if further actions are required, or specific fees apply.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/appointment-cancellation-reason")
    protected CodeableConcept cancellationReason;
    @Child(name="class", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification when becoming an encounter", formalDefinition="Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/EncounterClass")
    protected List<CodeableConcept> class_;
    @Child(name="serviceCategory", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A broad categorization of the service that is to be performed during this appointment", formalDefinition="A broad categorization of the service that is to be performed during this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-category")
    protected List<CodeableConcept> serviceCategory;
    @Child(name="serviceType", type={CodeableReference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The specific service that is to be performed during this appointment", formalDefinition="The specific service that is to be performed during this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected List<CodeableReference> serviceType;
    @Child(name="specialty", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment", formalDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="appointmentType", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The style of appointment or patient that has been booked in the slot (not service type)", formalDefinition="The style of appointment or patient that has been booked in the slot (not service type).")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0276")
    protected CodeableConcept appointmentType;
    @Child(name="reason", type={CodeableReference.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason this appointment is scheduled", formalDefinition="The reason that this appointment is being scheduled. This is more clinical than administrative. This can be coded, or as specified using information from another resource. When the patient arrives and the encounter begins it may be used as the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-reason")
    protected List<CodeableReference> reason;
    @Child(name="priority", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Used to make informed decisions if needing to re-prioritize", formalDefinition="The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActPriority")
    protected CodeableConcept priority;
    @Child(name="description", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Shown on a subject line in a meeting request, or appointment list", formalDefinition="The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the note field.")
    protected StringType description;
    @Child(name="replaces", type={Appointment.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Appointment replaced by this Appointment", formalDefinition="Appointment replaced by this Appointment in cases where there is a cancellation, the details of the cancellation can be found in the cancellationReason property (on the referenced resource).")
    protected List<Reference> replaces;
    @Child(name="virtualService", type={VirtualServiceDetail.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Connection details of a virtual service (e.g. conference call)", formalDefinition="Connection details of a virtual service (e.g. conference call).")
    protected List<VirtualServiceDetail> virtualService;
    @Child(name="supportingInformation", type={Reference.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information to support the appointment", formalDefinition="Additional information to support the appointment provided when making the appointment.")
    protected List<Reference> supportingInformation;
    @Child(name="previousAppointment", type={Appointment.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The previous appointment in a series", formalDefinition="The previous appointment in a series of related appointments.")
    protected Reference previousAppointment;
    @Child(name="originatingAppointment", type={Appointment.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The originating appointment in a recurring set of appointments", formalDefinition="The originating appointment in a recurring set of related appointments.")
    protected Reference originatingAppointment;
    @Child(name="start", type={InstantType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When appointment is to take place", formalDefinition="Date/Time that the appointment is to take place.")
    protected InstantType start;
    @Child(name="end", type={InstantType.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When appointment is to conclude", formalDefinition="Date/Time that the appointment is to conclude.")
    protected InstantType end;
    @Child(name="minutesDuration", type={PositiveIntType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Can be less than start/end (e.g. estimate)", formalDefinition="Number of minutes that the appointment is to take. This can be less than the duration between the start and end times.  For example, where the actual time of appointment is only an estimate or if a 30 minute appointment is being requested, but any time would work.  Also, if there is, for example, a planned 15 minute break in the middle of a long appointment, the duration may be 15 minutes less than the difference between the start and end.")
    protected PositiveIntType minutesDuration;
    @Child(name="requestedPeriod", type={Period.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Potential date/time interval(s) requested to allocate the appointment within", formalDefinition="A set of date ranges (potentially including times) that the appointment is preferred to be scheduled within.\n\nThe duration (usually in minutes) could also be provided to indicate the length of the appointment to fill and populate the start/end times for the actual allocated time. However, in other situations the duration may be calculated by the scheduling system.")
    protected List<Period> requestedPeriod;
    @Child(name="slot", type={Slot.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The slots that this appointment is filling", formalDefinition="The slots from the participants' schedules that will be filled by the appointment.")
    protected List<Reference> slot;
    @Child(name="account", type={Account.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The set of accounts that may be used for billing for this Appointment", formalDefinition="The set of accounts that is expected to be used for billing the activities that result from this Appointment.")
    protected List<Reference> account;
    @Child(name="created", type={DateTimeType.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The date that this appointment was initially created", formalDefinition="The date that this appointment was initially created. This could be different to the meta.lastModified value on the initial entry, as this could have been before the resource was created on the FHIR server, and should remain unchanged over the lifespan of the appointment.")
    protected DateTimeType created;
    @Child(name="cancellationDate", type={DateTimeType.class}, order=23, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the appointment was cancelled", formalDefinition="The date/time describing when the appointment was cancelled.")
    protected DateTimeType cancellationDate;
    @Child(name="note", type={Annotation.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional comments", formalDefinition="Additional notes/comments about the appointment.")
    protected List<Annotation> note;
    @Child(name="patientInstruction", type={CodeableReference.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Detailed information and instructions for the patient", formalDefinition="While Appointment.note contains information for internal use, Appointment.patientInstructions is used to capture patient facing information about the Appointment (e.g. please bring your referral or fast from 8pm night before).")
    protected List<CodeableReference> patientInstruction;
    @Child(name="basedOn", type={CarePlan.class, DeviceRequest.class, MedicationRequest.class, ServiceRequest.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The request this appointment is allocated to assess", formalDefinition="The request this appointment is allocated to assess (e.g. incoming referral or procedure request).")
    protected List<Reference> basedOn;
    @Child(name="subject", type={Patient.class, Group.class}, order=27, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient or group associated with the appointment", formalDefinition="The patient or group associated with the appointment, if they are to be present (usually) then they should also be included in the participant backbone element.")
    protected Reference subject;
    @Child(name="participant", type={}, order=28, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Participants involved in appointment", formalDefinition="List of participants involved in the appointment.")
    protected List<AppointmentParticipantComponent> participant;
    @Child(name="recurrenceId", type={PositiveIntType.class}, order=29, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The sequence number in the recurrence", formalDefinition="The sequence number that identifies a specific appointment in a recurring pattern.")
    protected PositiveIntType recurrenceId;
    @Child(name="occurrenceChanged", type={BooleanType.class}, order=30, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates that this appointment varies from a recurrence pattern", formalDefinition="This appointment varies from the recurring pattern.")
    protected BooleanType occurrenceChanged;
    @Child(name="recurrenceTemplate", type={}, order=31, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details of the recurrence pattern/template used to generate occurrences", formalDefinition="The details of the recurrence pattern or template that is used to generate recurring appointments.")
    protected List<AppointmentRecurrenceTemplateComponent> recurrenceTemplate;
    private static final long serialVersionUID = 883088259L;
    @SearchParamDefinition(name="actor", path="Appointment.participant.actor", description="Any one of the individuals participating in the appointment", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, Group.class, HealthcareService.class, Location.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("Appointment:actor").toLocked();
    @SearchParamDefinition(name="appointment-type", path="Appointment.appointmentType", description="The style of appointment or patient that has been booked in the slot (not service type)", type="token")
    public static final String SP_APPOINTMENT_TYPE = "appointment-type";
    public static final TokenClientParam APPOINTMENT_TYPE = new TokenClientParam("appointment-type");
    @SearchParamDefinition(name="based-on", path="Appointment.basedOn", description="The service request this appointment is allocated to assess", type="reference", target={CarePlan.class, DeviceRequest.class, MedicationRequest.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Appointment:based-on").toLocked();
    @SearchParamDefinition(name="group", path="Appointment.participant.actor.where(resolve() is Group) | Appointment.subject.where(resolve() is Group)", description="One of the individuals of the appointment is this patient", type="reference", target={Group.class})
    public static final String SP_GROUP = "group";
    public static final ReferenceClientParam GROUP = new ReferenceClientParam("group");
    public static final Include INCLUDE_GROUP = new Include("Appointment:group").toLocked();
    @SearchParamDefinition(name="location", path="Appointment.participant.actor.where(resolve() is Location)", description="This location is listed in the participants of the appointment", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Appointment:location").toLocked();
    @SearchParamDefinition(name="part-status", path="Appointment.participant.status", description="The Participation status of the subject, or other participant on the appointment. Can be used to locate participants that have not responded to meeting requests.", type="token")
    public static final String SP_PART_STATUS = "part-status";
    public static final TokenClientParam PART_STATUS = new TokenClientParam("part-status");
    @SearchParamDefinition(name="practitioner", path="Appointment.participant.actor.where(resolve() is Practitioner)", description="One of the individuals of the appointment is this practitioner", type="reference", target={Practitioner.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("Appointment:practitioner").toLocked();
    @SearchParamDefinition(name="reason-code", path="Appointment.reason.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_REASON_CODE = "reason-code";
    public static final TokenClientParam REASON_CODE = new TokenClientParam("reason-code");
    @SearchParamDefinition(name="reason-reference", path="Appointment.reason.reference", description="Reference to a resource (by instance)", type="reference", target={Condition.class, ImmunizationRecommendation.class, Observation.class, Procedure.class})
    public static final String SP_REASON_REFERENCE = "reason-reference";
    public static final ReferenceClientParam REASON_REFERENCE = new ReferenceClientParam("reason-reference");
    public static final Include INCLUDE_REASON_REFERENCE = new Include("Appointment:reason-reference").toLocked();
    @SearchParamDefinition(name="requested-period", path="requestedPeriod", description="During what period was the Appointment requested to take place", type="date")
    public static final String SP_REQUESTED_PERIOD = "requested-period";
    public static final DateClientParam REQUESTED_PERIOD = new DateClientParam("requested-period");
    @SearchParamDefinition(name="service-category", path="Appointment.serviceCategory", description="A broad categorization of the service that is to be performed during this appointment", type="token")
    public static final String SP_SERVICE_CATEGORY = "service-category";
    public static final TokenClientParam SERVICE_CATEGORY = new TokenClientParam("service-category");
    @SearchParamDefinition(name="service-type-reference", path="Appointment.serviceType.reference", description="The specific service (by HealthcareService) that is to be performed during this appointment", type="reference", target={HealthcareService.class})
    public static final String SP_SERVICE_TYPE_REFERENCE = "service-type-reference";
    public static final ReferenceClientParam SERVICE_TYPE_REFERENCE = new ReferenceClientParam("service-type-reference");
    public static final Include INCLUDE_SERVICE_TYPE_REFERENCE = new Include("Appointment:service-type-reference").toLocked();
    @SearchParamDefinition(name="service-type", path="Appointment.serviceType.concept", description="The specific service (by coding) that is to be performed during this appointment", type="token")
    public static final String SP_SERVICE_TYPE = "service-type";
    public static final TokenClientParam SERVICE_TYPE = new TokenClientParam("service-type");
    @SearchParamDefinition(name="slot", path="Appointment.slot", description="The slots that this appointment is filling", type="reference", target={Slot.class})
    public static final String SP_SLOT = "slot";
    public static final ReferenceClientParam SLOT = new ReferenceClientParam("slot");
    public static final Include INCLUDE_SLOT = new Include("Appointment:slot").toLocked();
    @SearchParamDefinition(name="specialty", path="Appointment.specialty", description="The specialty of a practitioner that would be required to perform the service requested in this appointment", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="status", path="Appointment.status", description="The overall status of the appointment", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Appointment.subject", description="One of the individuals of the appointment is this patient", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Appointment:subject").toLocked();
    @SearchParamDefinition(name="supporting-info", path="Appointment.supportingInformation", description="Additional information to support the appointment", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUPPORTING_INFO = "supporting-info";
    public static final ReferenceClientParam SUPPORTING_INFO = new ReferenceClientParam("supporting-info");
    public static final Include INCLUDE_SUPPORTING_INFO = new Include("Appointment:supporting-info").toLocked();
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Appointment:patient").toLocked();

    public Appointment() {
    }

    public Appointment(AppointmentStatus status, AppointmentParticipantComponent participant) {
        this.setStatus(status);
        this.addParticipant(participant);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Appointment setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Appointment addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<AppointmentStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<AppointmentStatus>(new AppointmentStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Appointment setStatusElement(Enumeration<AppointmentStatus> value) {
        this.status = value;
        return this;
    }

    public AppointmentStatus getStatus() {
        return this.status == null ? null : (AppointmentStatus)((Object)this.status.getValue());
    }

    public Appointment setStatus(AppointmentStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<AppointmentStatus>(new AppointmentStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCancellationReason() {
        if (this.cancellationReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.cancellationReason");
            }
            if (Configuration.doAutoCreate()) {
                this.cancellationReason = new CodeableConcept();
            }
        }
        return this.cancellationReason;
    }

    public boolean hasCancellationReason() {
        return this.cancellationReason != null && !this.cancellationReason.isEmpty();
    }

    public Appointment setCancellationReason(CodeableConcept value) {
        this.cancellationReason = value;
        return this;
    }

    public List<CodeableConcept> getClass_() {
        if (this.class_ == null) {
            this.class_ = new ArrayList<CodeableConcept>();
        }
        return this.class_;
    }

    public Appointment setClass_(List<CodeableConcept> theClass_) {
        this.class_ = theClass_;
        return this;
    }

    public boolean hasClass_() {
        if (this.class_ == null) {
            return false;
        }
        for (CodeableConcept item : this.class_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addClass_() {
        CodeableConcept t = new CodeableConcept();
        if (this.class_ == null) {
            this.class_ = new ArrayList<CodeableConcept>();
        }
        this.class_.add(t);
        return t;
    }

    public Appointment addClass_(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.class_ == null) {
            this.class_ = new ArrayList<CodeableConcept>();
        }
        this.class_.add(t);
        return this;
    }

    public CodeableConcept getClass_FirstRep() {
        if (this.getClass_().isEmpty()) {
            this.addClass_();
        }
        return this.getClass_().get(0);
    }

    public List<CodeableConcept> getServiceCategory() {
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        return this.serviceCategory;
    }

    public Appointment setServiceCategory(List<CodeableConcept> theServiceCategory) {
        this.serviceCategory = theServiceCategory;
        return this;
    }

    public boolean hasServiceCategory() {
        if (this.serviceCategory == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceCategory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        this.serviceCategory.add(t);
        return t;
    }

    public Appointment addServiceCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceCategory == null) {
            this.serviceCategory = new ArrayList<CodeableConcept>();
        }
        this.serviceCategory.add(t);
        return this;
    }

    public CodeableConcept getServiceCategoryFirstRep() {
        if (this.getServiceCategory().isEmpty()) {
            this.addServiceCategory();
        }
        return this.getServiceCategory().get(0);
    }

    public List<CodeableReference> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        return this.serviceType;
    }

    public Appointment setServiceType(List<CodeableReference> theServiceType) {
        this.serviceType = theServiceType;
        return this;
    }

    public boolean hasServiceType() {
        if (this.serviceType == null) {
            return false;
        }
        for (CodeableReference item : this.serviceType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addServiceType() {
        CodeableReference t = new CodeableReference();
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        this.serviceType.add(t);
        return t;
    }

    public Appointment addServiceType(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        this.serviceType.add(t);
        return this;
    }

    public CodeableReference getServiceTypeFirstRep() {
        if (this.getServiceType().isEmpty()) {
            this.addServiceType();
        }
        return this.getServiceType().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public Appointment setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public Appointment addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public CodeableConcept getAppointmentType() {
        if (this.appointmentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.appointmentType");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentType = new CodeableConcept();
            }
        }
        return this.appointmentType;
    }

    public boolean hasAppointmentType() {
        return this.appointmentType != null && !this.appointmentType.isEmpty();
    }

    public Appointment setAppointmentType(CodeableConcept value) {
        this.appointmentType = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public Appointment setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public Appointment addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Appointment setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Appointment setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Appointment setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public Appointment setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public Appointment addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    public List<VirtualServiceDetail> getVirtualService() {
        if (this.virtualService == null) {
            this.virtualService = new ArrayList<VirtualServiceDetail>();
        }
        return this.virtualService;
    }

    public Appointment setVirtualService(List<VirtualServiceDetail> theVirtualService) {
        this.virtualService = theVirtualService;
        return this;
    }

    public boolean hasVirtualService() {
        if (this.virtualService == null) {
            return false;
        }
        for (VirtualServiceDetail item : this.virtualService) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public VirtualServiceDetail addVirtualService() {
        VirtualServiceDetail t = new VirtualServiceDetail();
        if (this.virtualService == null) {
            this.virtualService = new ArrayList<VirtualServiceDetail>();
        }
        this.virtualService.add(t);
        return t;
    }

    public Appointment addVirtualService(VirtualServiceDetail t) {
        if (t == null) {
            return this;
        }
        if (this.virtualService == null) {
            this.virtualService = new ArrayList<VirtualServiceDetail>();
        }
        this.virtualService.add(t);
        return this;
    }

    public VirtualServiceDetail getVirtualServiceFirstRep() {
        if (this.getVirtualService().isEmpty()) {
            this.addVirtualService();
        }
        return this.getVirtualService().get(0);
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public Appointment setSupportingInformation(List<Reference> theSupportingInformation) {
        this.supportingInformation = theSupportingInformation;
        return this;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public Appointment addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public Reference getSupportingInformationFirstRep() {
        if (this.getSupportingInformation().isEmpty()) {
            this.addSupportingInformation();
        }
        return this.getSupportingInformation().get(0);
    }

    public Reference getPreviousAppointment() {
        if (this.previousAppointment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.previousAppointment");
            }
            if (Configuration.doAutoCreate()) {
                this.previousAppointment = new Reference();
            }
        }
        return this.previousAppointment;
    }

    public boolean hasPreviousAppointment() {
        return this.previousAppointment != null && !this.previousAppointment.isEmpty();
    }

    public Appointment setPreviousAppointment(Reference value) {
        this.previousAppointment = value;
        return this;
    }

    public Reference getOriginatingAppointment() {
        if (this.originatingAppointment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.originatingAppointment");
            }
            if (Configuration.doAutoCreate()) {
                this.originatingAppointment = new Reference();
            }
        }
        return this.originatingAppointment;
    }

    public boolean hasOriginatingAppointment() {
        return this.originatingAppointment != null && !this.originatingAppointment.isEmpty();
    }

    public Appointment setOriginatingAppointment(Reference value) {
        this.originatingAppointment = value;
        return this;
    }

    public InstantType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new InstantType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public Appointment setStartElement(InstantType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public Appointment setStart(Date value) {
        if (value == null) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new InstantType();
            }
            this.start.setValue(value);
        }
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Appointment setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Appointment setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public PositiveIntType getMinutesDurationElement() {
        if (this.minutesDuration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.minutesDuration");
            }
            if (Configuration.doAutoCreate()) {
                this.minutesDuration = new PositiveIntType();
            }
        }
        return this.minutesDuration;
    }

    public boolean hasMinutesDurationElement() {
        return this.minutesDuration != null && !this.minutesDuration.isEmpty();
    }

    public boolean hasMinutesDuration() {
        return this.minutesDuration != null && !this.minutesDuration.isEmpty();
    }

    public Appointment setMinutesDurationElement(PositiveIntType value) {
        this.minutesDuration = value;
        return this;
    }

    public int getMinutesDuration() {
        return this.minutesDuration == null || this.minutesDuration.isEmpty() ? 0 : (Integer)this.minutesDuration.getValue();
    }

    public Appointment setMinutesDuration(int value) {
        if (this.minutesDuration == null) {
            this.minutesDuration = new PositiveIntType();
        }
        this.minutesDuration.setValue((Object)value);
        return this;
    }

    public List<Period> getRequestedPeriod() {
        if (this.requestedPeriod == null) {
            this.requestedPeriod = new ArrayList<Period>();
        }
        return this.requestedPeriod;
    }

    public Appointment setRequestedPeriod(List<Period> theRequestedPeriod) {
        this.requestedPeriod = theRequestedPeriod;
        return this;
    }

    public boolean hasRequestedPeriod() {
        if (this.requestedPeriod == null) {
            return false;
        }
        for (Period item : this.requestedPeriod) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Period addRequestedPeriod() {
        Period t = new Period();
        if (this.requestedPeriod == null) {
            this.requestedPeriod = new ArrayList<Period>();
        }
        this.requestedPeriod.add(t);
        return t;
    }

    public Appointment addRequestedPeriod(Period t) {
        if (t == null) {
            return this;
        }
        if (this.requestedPeriod == null) {
            this.requestedPeriod = new ArrayList<Period>();
        }
        this.requestedPeriod.add(t);
        return this;
    }

    public Period getRequestedPeriodFirstRep() {
        if (this.getRequestedPeriod().isEmpty()) {
            this.addRequestedPeriod();
        }
        return this.getRequestedPeriod().get(0);
    }

    public List<Reference> getSlot() {
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        return this.slot;
    }

    public Appointment setSlot(List<Reference> theSlot) {
        this.slot = theSlot;
        return this;
    }

    public boolean hasSlot() {
        if (this.slot == null) {
            return false;
        }
        for (Reference item : this.slot) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSlot() {
        Reference t = new Reference();
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        this.slot.add(t);
        return t;
    }

    public Appointment addSlot(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        this.slot.add(t);
        return this;
    }

    public Reference getSlotFirstRep() {
        if (this.getSlot().isEmpty()) {
            this.addSlot();
        }
        return this.getSlot().get(0);
    }

    public List<Reference> getAccount() {
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        return this.account;
    }

    public Appointment setAccount(List<Reference> theAccount) {
        this.account = theAccount;
        return this;
    }

    public boolean hasAccount() {
        if (this.account == null) {
            return false;
        }
        for (Reference item : this.account) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAccount() {
        Reference t = new Reference();
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return t;
    }

    public Appointment addAccount(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return this;
    }

    public Reference getAccountFirstRep() {
        if (this.getAccount().isEmpty()) {
            this.addAccount();
        }
        return this.getAccount().get(0);
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public Appointment setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public Appointment setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public DateTimeType getCancellationDateElement() {
        if (this.cancellationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.cancellationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.cancellationDate = new DateTimeType();
            }
        }
        return this.cancellationDate;
    }

    public boolean hasCancellationDateElement() {
        return this.cancellationDate != null && !this.cancellationDate.isEmpty();
    }

    public boolean hasCancellationDate() {
        return this.cancellationDate != null && !this.cancellationDate.isEmpty();
    }

    public Appointment setCancellationDateElement(DateTimeType value) {
        this.cancellationDate = value;
        return this;
    }

    public Date getCancellationDate() {
        return this.cancellationDate == null ? null : (Date)this.cancellationDate.getValue();
    }

    public Appointment setCancellationDate(Date value) {
        if (value == null) {
            this.cancellationDate = null;
        } else {
            if (this.cancellationDate == null) {
                this.cancellationDate = new DateTimeType();
            }
            this.cancellationDate.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Appointment setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Appointment addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableReference> getPatientInstruction() {
        if (this.patientInstruction == null) {
            this.patientInstruction = new ArrayList<CodeableReference>();
        }
        return this.patientInstruction;
    }

    public Appointment setPatientInstruction(List<CodeableReference> thePatientInstruction) {
        this.patientInstruction = thePatientInstruction;
        return this;
    }

    public boolean hasPatientInstruction() {
        if (this.patientInstruction == null) {
            return false;
        }
        for (CodeableReference item : this.patientInstruction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addPatientInstruction() {
        CodeableReference t = new CodeableReference();
        if (this.patientInstruction == null) {
            this.patientInstruction = new ArrayList<CodeableReference>();
        }
        this.patientInstruction.add(t);
        return t;
    }

    public Appointment addPatientInstruction(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.patientInstruction == null) {
            this.patientInstruction = new ArrayList<CodeableReference>();
        }
        this.patientInstruction.add(t);
        return this;
    }

    public CodeableReference getPatientInstructionFirstRep() {
        if (this.getPatientInstruction().isEmpty()) {
            this.addPatientInstruction();
        }
        return this.getPatientInstruction().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Appointment setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Appointment addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Appointment setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public List<AppointmentParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        return this.participant;
    }

    public Appointment setParticipant(List<AppointmentParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (AppointmentParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AppointmentParticipantComponent addParticipant() {
        AppointmentParticipantComponent t = new AppointmentParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Appointment addParticipant(AppointmentParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public AppointmentParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public PositiveIntType getRecurrenceIdElement() {
        if (this.recurrenceId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.recurrenceId");
            }
            if (Configuration.doAutoCreate()) {
                this.recurrenceId = new PositiveIntType();
            }
        }
        return this.recurrenceId;
    }

    public boolean hasRecurrenceIdElement() {
        return this.recurrenceId != null && !this.recurrenceId.isEmpty();
    }

    public boolean hasRecurrenceId() {
        return this.recurrenceId != null && !this.recurrenceId.isEmpty();
    }

    public Appointment setRecurrenceIdElement(PositiveIntType value) {
        this.recurrenceId = value;
        return this;
    }

    public int getRecurrenceId() {
        return this.recurrenceId == null || this.recurrenceId.isEmpty() ? 0 : (Integer)this.recurrenceId.getValue();
    }

    public Appointment setRecurrenceId(int value) {
        if (this.recurrenceId == null) {
            this.recurrenceId = new PositiveIntType();
        }
        this.recurrenceId.setValue((Object)value);
        return this;
    }

    public BooleanType getOccurrenceChangedElement() {
        if (this.occurrenceChanged == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.occurrenceChanged");
            }
            if (Configuration.doAutoCreate()) {
                this.occurrenceChanged = new BooleanType();
            }
        }
        return this.occurrenceChanged;
    }

    public boolean hasOccurrenceChangedElement() {
        return this.occurrenceChanged != null && !this.occurrenceChanged.isEmpty();
    }

    public boolean hasOccurrenceChanged() {
        return this.occurrenceChanged != null && !this.occurrenceChanged.isEmpty();
    }

    public Appointment setOccurrenceChangedElement(BooleanType value) {
        this.occurrenceChanged = value;
        return this;
    }

    public boolean getOccurrenceChanged() {
        return this.occurrenceChanged == null || this.occurrenceChanged.isEmpty() ? false : (Boolean)this.occurrenceChanged.getValue();
    }

    public Appointment setOccurrenceChanged(boolean value) {
        if (this.occurrenceChanged == null) {
            this.occurrenceChanged = new BooleanType();
        }
        this.occurrenceChanged.setValue((Object)value);
        return this;
    }

    public List<AppointmentRecurrenceTemplateComponent> getRecurrenceTemplate() {
        if (this.recurrenceTemplate == null) {
            this.recurrenceTemplate = new ArrayList<AppointmentRecurrenceTemplateComponent>();
        }
        return this.recurrenceTemplate;
    }

    public Appointment setRecurrenceTemplate(List<AppointmentRecurrenceTemplateComponent> theRecurrenceTemplate) {
        this.recurrenceTemplate = theRecurrenceTemplate;
        return this;
    }

    public boolean hasRecurrenceTemplate() {
        if (this.recurrenceTemplate == null) {
            return false;
        }
        for (AppointmentRecurrenceTemplateComponent item : this.recurrenceTemplate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AppointmentRecurrenceTemplateComponent addRecurrenceTemplate() {
        AppointmentRecurrenceTemplateComponent t = new AppointmentRecurrenceTemplateComponent();
        if (this.recurrenceTemplate == null) {
            this.recurrenceTemplate = new ArrayList<AppointmentRecurrenceTemplateComponent>();
        }
        this.recurrenceTemplate.add(t);
        return t;
    }

    public Appointment addRecurrenceTemplate(AppointmentRecurrenceTemplateComponent t) {
        if (t == null) {
            return this;
        }
        if (this.recurrenceTemplate == null) {
            this.recurrenceTemplate = new ArrayList<AppointmentRecurrenceTemplateComponent>();
        }
        this.recurrenceTemplate.add(t);
        return this;
    }

    public AppointmentRecurrenceTemplateComponent getRecurrenceTemplateFirstRep() {
        if (this.getRecurrenceTemplate().isEmpty()) {
            this.addRecurrenceTemplate();
        }
        return this.getRecurrenceTemplate().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.", 0, 1, this.status));
        children.add(new Property("cancellationReason", "CodeableConcept", "The coded reason for the appointment being cancelled. This is often used in reporting/billing/futher processing to determine if further actions are required, or specific fees apply.", 0, 1, this.cancellationReason));
        children.add(new Property("class", "CodeableConcept", "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.", 0, Integer.MAX_VALUE, this.class_));
        children.add(new Property("serviceCategory", "CodeableConcept", "A broad categorization of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory));
        children.add(new Property("serviceType", "CodeableReference(HealthcareService)", "The specific service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceType));
        children.add(new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property("appointmentType", "CodeableConcept", "The style of appointment or patient that has been booked in the slot (not service type).", 0, 1, this.appointmentType));
        children.add(new Property("reason", "CodeableReference(Condition|Procedure|Observation|ImmunizationRecommendation)", "The reason that this appointment is being scheduled. This is more clinical than administrative. This can be coded, or as specified using information from another resource. When the patient arrives and the encounter begins it may be used as the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("priority", "CodeableConcept", "The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).", 0, 1, this.priority));
        children.add(new Property("description", "string", "The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the note field.", 0, 1, this.description));
        children.add(new Property("replaces", "Reference(Appointment)", "Appointment replaced by this Appointment in cases where there is a cancellation, the details of the cancellation can be found in the cancellationReason property (on the referenced resource).", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property("virtualService", "VirtualServiceDetail", "Connection details of a virtual service (e.g. conference call).", 0, Integer.MAX_VALUE, this.virtualService));
        children.add(new Property("supportingInformation", "Reference(Any)", "Additional information to support the appointment provided when making the appointment.", 0, Integer.MAX_VALUE, this.supportingInformation));
        children.add(new Property("previousAppointment", "Reference(Appointment)", "The previous appointment in a series of related appointments.", 0, 1, this.previousAppointment));
        children.add(new Property("originatingAppointment", "Reference(Appointment)", "The originating appointment in a recurring set of related appointments.", 0, 1, this.originatingAppointment));
        children.add(new Property("start", "instant", "Date/Time that the appointment is to take place.", 0, 1, this.start));
        children.add(new Property("end", "instant", "Date/Time that the appointment is to conclude.", 0, 1, this.end));
        children.add(new Property("minutesDuration", "positiveInt", "Number of minutes that the appointment is to take. This can be less than the duration between the start and end times.  For example, where the actual time of appointment is only an estimate or if a 30 minute appointment is being requested, but any time would work.  Also, if there is, for example, a planned 15 minute break in the middle of a long appointment, the duration may be 15 minutes less than the difference between the start and end.", 0, 1, this.minutesDuration));
        children.add(new Property("requestedPeriod", "Period", "A set of date ranges (potentially including times) that the appointment is preferred to be scheduled within.\n\nThe duration (usually in minutes) could also be provided to indicate the length of the appointment to fill and populate the start/end times for the actual allocated time. However, in other situations the duration may be calculated by the scheduling system.", 0, Integer.MAX_VALUE, this.requestedPeriod));
        children.add(new Property(SP_SLOT, "Reference(Slot)", "The slots from the participants' schedules that will be filled by the appointment.", 0, Integer.MAX_VALUE, this.slot));
        children.add(new Property("account", "Reference(Account)", "The set of accounts that is expected to be used for billing the activities that result from this Appointment.", 0, Integer.MAX_VALUE, this.account));
        children.add(new Property("created", "dateTime", "The date that this appointment was initially created. This could be different to the meta.lastModified value on the initial entry, as this could have been before the resource was created on the FHIR server, and should remain unchanged over the lifespan of the appointment.", 0, 1, this.created));
        children.add(new Property("cancellationDate", "dateTime", "The date/time describing when the appointment was cancelled.", 0, 1, this.cancellationDate));
        children.add(new Property("note", "Annotation", "Additional notes/comments about the appointment.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("patientInstruction", "CodeableReference(DocumentReference|Binary|Communication)", "While Appointment.note contains information for internal use, Appointment.patientInstructions is used to capture patient facing information about the Appointment (e.g. please bring your referral or fast from 8pm night before).", 0, Integer.MAX_VALUE, this.patientInstruction));
        children.add(new Property("basedOn", "Reference(CarePlan|DeviceRequest|MedicationRequest|ServiceRequest)", "The request this appointment is allocated to assess (e.g. incoming referral or procedure request).", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group associated with the appointment, if they are to be present (usually) then they should also be included in the participant backbone element.", 0, 1, this.subject));
        children.add(new Property("participant", "", "List of participants involved in the appointment.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("recurrenceId", "positiveInt", "The sequence number that identifies a specific appointment in a recurring pattern.", 0, 1, this.recurrenceId));
        children.add(new Property("occurrenceChanged", "boolean", "This appointment varies from the recurring pattern.", 0, 1, this.occurrenceChanged));
        children.add(new Property("recurrenceTemplate", "", "The details of the recurrence pattern or template that is used to generate recurring appointments.", 0, Integer.MAX_VALUE, this.recurrenceTemplate));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.", 0, 1, this.status);
            }
            case 2135095591: {
                return new Property("cancellationReason", "CodeableConcept", "The coded reason for the appointment being cancelled. This is often used in reporting/billing/futher processing to determine if further actions are required, or specific fees apply.", 0, 1, this.cancellationReason);
            }
            case 94742904: {
                return new Property("class", "CodeableConcept", "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.", 0, Integer.MAX_VALUE, this.class_);
            }
            case 1281188563: {
                return new Property("serviceCategory", "CodeableConcept", "A broad categorization of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory);
            }
            case -1928370289: {
                return new Property("serviceType", "CodeableReference(HealthcareService)", "The specific service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceType);
            }
            case -1694759682: {
                return new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case -1596426375: {
                return new Property("appointmentType", "CodeableConcept", "The style of appointment or patient that has been booked in the slot (not service type).", 0, 1, this.appointmentType);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Procedure|Observation|ImmunizationRecommendation)", "The reason that this appointment is being scheduled. This is more clinical than administrative. This can be coded, or as specified using information from another resource. When the patient arrives and the encounter begins it may be used as the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, Integer.MAX_VALUE, this.reason);
            }
            case -1165461084: {
                return new Property("priority", "CodeableConcept", "The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).", 0, 1, this.priority);
            }
            case -1724546052: {
                return new Property("description", "string", "The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the note field.", 0, 1, this.description);
            }
            case -430332865: {
                return new Property("replaces", "Reference(Appointment)", "Appointment replaced by this Appointment in cases where there is a cancellation, the details of the cancellation can be found in the cancellationReason property (on the referenced resource).", 0, Integer.MAX_VALUE, this.replaces);
            }
            case 1420774698: {
                return new Property("virtualService", "VirtualServiceDetail", "Connection details of a virtual service (e.g. conference call).", 0, Integer.MAX_VALUE, this.virtualService);
            }
            case -1248768647: {
                return new Property("supportingInformation", "Reference(Any)", "Additional information to support the appointment provided when making the appointment.", 0, Integer.MAX_VALUE, this.supportingInformation);
            }
            case -1676044248: {
                return new Property("previousAppointment", "Reference(Appointment)", "The previous appointment in a series of related appointments.", 0, 1, this.previousAppointment);
            }
            case 1841882230: {
                return new Property("originatingAppointment", "Reference(Appointment)", "The originating appointment in a recurring set of related appointments.", 0, 1, this.originatingAppointment);
            }
            case 109757538: {
                return new Property("start", "instant", "Date/Time that the appointment is to take place.", 0, 1, this.start);
            }
            case 100571: {
                return new Property("end", "instant", "Date/Time that the appointment is to conclude.", 0, 1, this.end);
            }
            case -413630573: {
                return new Property("minutesDuration", "positiveInt", "Number of minutes that the appointment is to take. This can be less than the duration between the start and end times.  For example, where the actual time of appointment is only an estimate or if a 30 minute appointment is being requested, but any time would work.  Also, if there is, for example, a planned 15 minute break in the middle of a long appointment, the duration may be 15 minutes less than the difference between the start and end.", 0, 1, this.minutesDuration);
            }
            case -897241393: {
                return new Property("requestedPeriod", "Period", "A set of date ranges (potentially including times) that the appointment is preferred to be scheduled within.\n\nThe duration (usually in minutes) could also be provided to indicate the length of the appointment to fill and populate the start/end times for the actual allocated time. However, in other situations the duration may be calculated by the scheduling system.", 0, Integer.MAX_VALUE, this.requestedPeriod);
            }
            case 3533310: {
                return new Property(SP_SLOT, "Reference(Slot)", "The slots from the participants' schedules that will be filled by the appointment.", 0, Integer.MAX_VALUE, this.slot);
            }
            case -1177318867: {
                return new Property("account", "Reference(Account)", "The set of accounts that is expected to be used for billing the activities that result from this Appointment.", 0, Integer.MAX_VALUE, this.account);
            }
            case 1028554472: {
                return new Property("created", "dateTime", "The date that this appointment was initially created. This could be different to the meta.lastModified value on the initial entry, as this could have been before the resource was created on the FHIR server, and should remain unchanged over the lifespan of the appointment.", 0, 1, this.created);
            }
            case 806269777: {
                return new Property("cancellationDate", "dateTime", "The date/time describing when the appointment was cancelled.", 0, 1, this.cancellationDate);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Additional notes/comments about the appointment.", 0, Integer.MAX_VALUE, this.note);
            }
            case 737543241: {
                return new Property("patientInstruction", "CodeableReference(DocumentReference|Binary|Communication)", "While Appointment.note contains information for internal use, Appointment.patientInstructions is used to capture patient facing information about the Appointment (e.g. please bring your referral or fast from 8pm night before).", 0, Integer.MAX_VALUE, this.patientInstruction);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|DeviceRequest|MedicationRequest|ServiceRequest)", "The request this appointment is allocated to assess (e.g. incoming referral or procedure request).", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group associated with the appointment, if they are to be present (usually) then they should also be included in the participant backbone element.", 0, 1, this.subject);
            }
            case 767422259: {
                return new Property("participant", "", "List of participants involved in the appointment.", 0, Integer.MAX_VALUE, this.participant);
            }
            case -362407829: {
                return new Property("recurrenceId", "positiveInt", "The sequence number that identifies a specific appointment in a recurring pattern.", 0, 1, this.recurrenceId);
            }
            case 1779864483: {
                return new Property("occurrenceChanged", "boolean", "This appointment varies from the recurring pattern.", 0, 1, this.occurrenceChanged);
            }
            case 597629898: {
                return new Property("recurrenceTemplate", "", "The details of the recurrence pattern or template that is used to generate recurring appointments.", 0, Integer.MAX_VALUE, this.recurrenceTemplate);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2135095591: {
                Base[] baseArray;
                if (this.cancellationReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.cancellationReason;
                }
                return baseArray;
            }
            case 94742904: {
                return this.class_ == null ? new Base[]{} : this.class_.toArray(new Base[this.class_.size()]);
            }
            case 1281188563: {
                return this.serviceCategory == null ? new Base[]{} : this.serviceCategory.toArray(new Base[this.serviceCategory.size()]);
            }
            case -1928370289: {
                return this.serviceType == null ? new Base[]{} : this.serviceType.toArray(new Base[this.serviceType.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case -1596426375: {
                Base[] baseArray;
                if (this.appointmentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.appointmentType;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.description;
                }
                return baseArray;
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case 1420774698: {
                return this.virtualService == null ? new Base[]{} : this.virtualService.toArray(new Base[this.virtualService.size()]);
            }
            case -1248768647: {
                return this.supportingInformation == null ? new Base[]{} : this.supportingInformation.toArray(new Base[this.supportingInformation.size()]);
            }
            case -1676044248: {
                Base[] baseArray;
                if (this.previousAppointment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.previousAppointment;
                }
                return baseArray;
            }
            case 1841882230: {
                Base[] baseArray;
                if (this.originatingAppointment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.originatingAppointment;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.start;
                }
                return baseArray;
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.end;
                }
                return baseArray;
            }
            case -413630573: {
                Base[] baseArray;
                if (this.minutesDuration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.minutesDuration;
                }
                return baseArray;
            }
            case -897241393: {
                return this.requestedPeriod == null ? new Base[]{} : this.requestedPeriod.toArray(new Base[this.requestedPeriod.size()]);
            }
            case 3533310: {
                return this.slot == null ? new Base[]{} : this.slot.toArray(new Base[this.slot.size()]);
            }
            case -1177318867: {
                return this.account == null ? new Base[]{} : this.account.toArray(new Base[this.account.size()]);
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.created;
                }
                return baseArray;
            }
            case 806269777: {
                Base[] baseArray;
                if (this.cancellationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.cancellationDate;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 737543241: {
                return this.patientInstruction == null ? new Base[]{} : this.patientInstruction.toArray(new Base[this.patientInstruction.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.subject;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -362407829: {
                Base[] baseArray;
                if (this.recurrenceId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.recurrenceId;
                }
                return baseArray;
            }
            case 1779864483: {
                Base[] baseArray;
                if (this.occurrenceChanged == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.occurrenceChanged;
                }
                return baseArray;
            }
            case 597629898: {
                return this.recurrenceTemplate == null ? new Base[]{} : this.recurrenceTemplate.toArray(new Base[this.recurrenceTemplate.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new AppointmentStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 2135095591: {
                this.cancellationReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 94742904: {
                this.getClass_().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1281188563: {
                this.getServiceCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1928370289: {
                this.getServiceType().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1596426375: {
                this.appointmentType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -1165461084: {
                this.priority = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case -430332865: {
                this.getReplaces().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1420774698: {
                this.getVirtualService().add(TypeConvertor.castToVirtualServiceDetail(value));
                return value;
            }
            case -1248768647: {
                this.getSupportingInformation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1676044248: {
                this.previousAppointment = TypeConvertor.castToReference(value);
                return value;
            }
            case 1841882230: {
                this.originatingAppointment = TypeConvertor.castToReference(value);
                return value;
            }
            case 109757538: {
                this.start = TypeConvertor.castToInstant(value);
                return value;
            }
            case 100571: {
                this.end = TypeConvertor.castToInstant(value);
                return value;
            }
            case -413630573: {
                this.minutesDuration = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case -897241393: {
                this.getRequestedPeriod().add(TypeConvertor.castToPeriod(value));
                return value;
            }
            case 3533310: {
                this.getSlot().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1177318867: {
                this.getAccount().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1028554472: {
                this.created = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 806269777: {
                this.cancellationDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 737543241: {
                this.getPatientInstruction().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((AppointmentParticipantComponent)((Object)value));
                return value;
            }
            case -362407829: {
                this.recurrenceId = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case 1779864483: {
                this.occurrenceChanged = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 597629898: {
                this.getRecurrenceTemplate().add((AppointmentRecurrenceTemplateComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new AppointmentStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("cancellationReason")) {
            this.cancellationReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("class")) {
            this.getClass_().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("serviceCategory")) {
            this.getServiceCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("serviceType")) {
            this.getServiceType().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("appointmentType")) {
            this.appointmentType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("priority")) {
            this.priority = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals("replaces")) {
            this.getReplaces().add(TypeConvertor.castToReference(value));
        } else if (name.equals("virtualService")) {
            this.getVirtualService().add(TypeConvertor.castToVirtualServiceDetail(value));
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("previousAppointment")) {
            this.previousAppointment = TypeConvertor.castToReference(value);
        } else if (name.equals("originatingAppointment")) {
            this.originatingAppointment = TypeConvertor.castToReference(value);
        } else if (name.equals("start")) {
            this.start = TypeConvertor.castToInstant(value);
        } else if (name.equals("end")) {
            this.end = TypeConvertor.castToInstant(value);
        } else if (name.equals("minutesDuration")) {
            this.minutesDuration = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("requestedPeriod")) {
            this.getRequestedPeriod().add(TypeConvertor.castToPeriod(value));
        } else if (name.equals(SP_SLOT)) {
            this.getSlot().add(TypeConvertor.castToReference(value));
        } else if (name.equals("account")) {
            this.getAccount().add(TypeConvertor.castToReference(value));
        } else if (name.equals("created")) {
            this.created = TypeConvertor.castToDateTime(value);
        } else if (name.equals("cancellationDate")) {
            this.cancellationDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("patientInstruction")) {
            this.getPatientInstruction().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("participant")) {
            this.getParticipant().add((AppointmentParticipantComponent)((Object)value));
        } else if (name.equals("recurrenceId")) {
            this.recurrenceId = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("occurrenceChanged")) {
            this.occurrenceChanged = TypeConvertor.castToBoolean(value);
        } else if (name.equals("recurrenceTemplate")) {
            this.getRecurrenceTemplate().add((AppointmentRecurrenceTemplateComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new AppointmentStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("cancellationReason")) {
            this.cancellationReason = null;
        } else if (name.equals("class")) {
            this.getClass_().remove(value);
        } else if (name.equals("serviceCategory")) {
            this.getServiceCategory().remove(value);
        } else if (name.equals("serviceType")) {
            this.getServiceType().remove(value);
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().remove(value);
        } else if (name.equals("appointmentType")) {
            this.appointmentType = null;
        } else if (name.equals("reason")) {
            this.getReason().remove(value);
        } else if (name.equals("priority")) {
            this.priority = null;
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("replaces")) {
            this.getReplaces().remove(value);
        } else if (name.equals("virtualService")) {
            this.getVirtualService().remove(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().remove(value);
        } else if (name.equals("previousAppointment")) {
            this.previousAppointment = null;
        } else if (name.equals("originatingAppointment")) {
            this.originatingAppointment = null;
        } else if (name.equals("start")) {
            this.start = null;
        } else if (name.equals("end")) {
            this.end = null;
        } else if (name.equals("minutesDuration")) {
            this.minutesDuration = null;
        } else if (name.equals("requestedPeriod")) {
            this.getRequestedPeriod().remove(value);
        } else if (name.equals(SP_SLOT)) {
            this.getSlot().remove(value);
        } else if (name.equals("account")) {
            this.getAccount().remove(value);
        } else if (name.equals("created")) {
            this.created = null;
        } else if (name.equals("cancellationDate")) {
            this.cancellationDate = null;
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("patientInstruction")) {
            this.getPatientInstruction().remove(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals("participant")) {
            this.getParticipant().remove((AppointmentParticipantComponent)((Object)value));
        } else if (name.equals("recurrenceId")) {
            this.recurrenceId = null;
        } else if (name.equals("occurrenceChanged")) {
            this.occurrenceChanged = null;
        } else if (name.equals("recurrenceTemplate")) {
            this.getRecurrenceTemplate().remove((AppointmentRecurrenceTemplateComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2135095591: {
                return this.getCancellationReason();
            }
            case 94742904: {
                return this.addClass_();
            }
            case 1281188563: {
                return this.addServiceCategory();
            }
            case -1928370289: {
                return this.addServiceType();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case -1596426375: {
                return this.getAppointmentType();
            }
            case -934964668: {
                return this.addReason();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case 1420774698: {
                return this.addVirtualService();
            }
            case -1248768647: {
                return this.addSupportingInformation();
            }
            case -1676044248: {
                return this.getPreviousAppointment();
            }
            case 1841882230: {
                return this.getOriginatingAppointment();
            }
            case 109757538: {
                return this.getStartElement();
            }
            case 100571: {
                return this.getEndElement();
            }
            case -413630573: {
                return this.getMinutesDurationElement();
            }
            case -897241393: {
                return this.addRequestedPeriod();
            }
            case 3533310: {
                return this.addSlot();
            }
            case -1177318867: {
                return this.addAccount();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 806269777: {
                return this.getCancellationDateElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case 737543241: {
                return this.addPatientInstruction();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -362407829: {
                return this.getRecurrenceIdElement();
            }
            case 1779864483: {
                return this.getOccurrenceChangedElement();
            }
            case 597629898: {
                return this.addRecurrenceTemplate();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2135095591: {
                return new String[]{"CodeableConcept"};
            }
            case 94742904: {
                return new String[]{"CodeableConcept"};
            }
            case 1281188563: {
                return new String[]{"CodeableConcept"};
            }
            case -1928370289: {
                return new String[]{"CodeableReference"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case -1596426375: {
                return new String[]{"CodeableConcept"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case 1420774698: {
                return new String[]{"VirtualServiceDetail"};
            }
            case -1248768647: {
                return new String[]{"Reference"};
            }
            case -1676044248: {
                return new String[]{"Reference"};
            }
            case 1841882230: {
                return new String[]{"Reference"};
            }
            case 109757538: {
                return new String[]{"instant"};
            }
            case 100571: {
                return new String[]{"instant"};
            }
            case -413630573: {
                return new String[]{"positiveInt"};
            }
            case -897241393: {
                return new String[]{"Period"};
            }
            case 3533310: {
                return new String[]{"Reference"};
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 806269777: {
                return new String[]{"dateTime"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 737543241: {
                return new String[]{"CodeableReference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 767422259: {
                return new String[0];
            }
            case -362407829: {
                return new String[]{"positiveInt"};
            }
            case 1779864483: {
                return new String[]{"boolean"};
            }
            case 597629898: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.status");
        }
        if (name.equals("cancellationReason")) {
            this.cancellationReason = new CodeableConcept();
            return this.cancellationReason;
        }
        if (name.equals("class")) {
            return this.addClass_();
        }
        if (name.equals("serviceCategory")) {
            return this.addServiceCategory();
        }
        if (name.equals("serviceType")) {
            return this.addServiceType();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals("appointmentType")) {
            this.appointmentType = new CodeableConcept();
            return this.appointmentType;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.description");
        }
        if (name.equals("replaces")) {
            return this.addReplaces();
        }
        if (name.equals("virtualService")) {
            return this.addVirtualService();
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("previousAppointment")) {
            this.previousAppointment = new Reference();
            return this.previousAppointment;
        }
        if (name.equals("originatingAppointment")) {
            this.originatingAppointment = new Reference();
            return this.originatingAppointment;
        }
        if (name.equals("start")) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.end");
        }
        if (name.equals("minutesDuration")) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.minutesDuration");
        }
        if (name.equals("requestedPeriod")) {
            return this.addRequestedPeriod();
        }
        if (name.equals(SP_SLOT)) {
            return this.addSlot();
        }
        if (name.equals("account")) {
            return this.addAccount();
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.created");
        }
        if (name.equals("cancellationDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.cancellationDate");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("patientInstruction")) {
            return this.addPatientInstruction();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        if (name.equals("recurrenceId")) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceId");
        }
        if (name.equals("occurrenceChanged")) {
            throw new FHIRException("Cannot call addChild on a singleton property Appointment.occurrenceChanged");
        }
        if (name.equals("recurrenceTemplate")) {
            return this.addRecurrenceTemplate();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Appointment";
    }

    @Override
    public Appointment copy() {
        Appointment dst = new Appointment();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Appointment dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.cancellationReason = this.cancellationReason == null ? null : this.cancellationReason.copy();
        if (this.class_ != null) {
            dst.class_ = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.class_) {
                dst.class_.add(codeableConcept2.copy());
            }
        }
        if (this.serviceCategory != null) {
            dst.serviceCategory = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.serviceCategory) {
                dst.serviceCategory.add(codeableConcept3.copy());
            }
        }
        if (this.serviceType != null) {
            dst.serviceType = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.serviceType) {
                dst.serviceType.add(codeableReference.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.specialty) {
                dst.specialty.add(codeableConcept4.copy());
            }
        }
        CodeableConcept codeableConcept5 = dst.appointmentType = this.appointmentType == null ? null : this.appointmentType.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        dst.priority = this.priority == null ? null : this.priority.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        if (this.virtualService != null) {
            dst.virtualService = new ArrayList<VirtualServiceDetail>();
            for (VirtualServiceDetail virtualServiceDetail : this.virtualService) {
                dst.virtualService.add(virtualServiceDetail.copy());
            }
        }
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference : this.supportingInformation) {
                dst.supportingInformation.add(reference.copy());
            }
        }
        dst.previousAppointment = this.previousAppointment == null ? null : this.previousAppointment.copy();
        dst.originatingAppointment = this.originatingAppointment == null ? null : this.originatingAppointment.copy();
        dst.start = this.start == null ? null : this.start.copy();
        dst.end = this.end == null ? null : this.end.copy();
        PositiveIntType positiveIntType = dst.minutesDuration = this.minutesDuration == null ? null : this.minutesDuration.copy();
        if (this.requestedPeriod != null) {
            dst.requestedPeriod = new ArrayList<Period>();
            for (Period period : this.requestedPeriod) {
                dst.requestedPeriod.add(period.copy());
            }
        }
        if (this.slot != null) {
            dst.slot = new ArrayList<Reference>();
            for (Reference reference : this.slot) {
                dst.slot.add(reference.copy());
            }
        }
        if (this.account != null) {
            dst.account = new ArrayList<Reference>();
            for (Reference reference : this.account) {
                dst.account.add(reference.copy());
            }
        }
        dst.created = this.created == null ? null : this.created.copy();
        DateTimeType dateTimeType = dst.cancellationDate = this.cancellationDate == null ? null : this.cancellationDate.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.patientInstruction != null) {
            dst.patientInstruction = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.patientInstruction) {
                dst.patientInstruction.add(codeableReference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<AppointmentParticipantComponent>();
            for (AppointmentParticipantComponent appointmentParticipantComponent : this.participant) {
                dst.participant.add(appointmentParticipantComponent.copy());
            }
        }
        dst.recurrenceId = this.recurrenceId == null ? null : this.recurrenceId.copy();
        BooleanType booleanType = dst.occurrenceChanged = this.occurrenceChanged == null ? null : this.occurrenceChanged.copy();
        if (this.recurrenceTemplate != null) {
            dst.recurrenceTemplate = new ArrayList<AppointmentRecurrenceTemplateComponent>();
            for (AppointmentRecurrenceTemplateComponent appointmentRecurrenceTemplateComponent : this.recurrenceTemplate) {
                dst.recurrenceTemplate.add(appointmentRecurrenceTemplateComponent.copy());
            }
        }
    }

    protected Appointment typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Appointment)) {
            return false;
        }
        Appointment o = (Appointment)other_;
        return Appointment.compareDeep(this.identifier, o.identifier, true) && Appointment.compareDeep(this.status, o.status, true) && Appointment.compareDeep(this.cancellationReason, o.cancellationReason, true) && Appointment.compareDeep(this.class_, o.class_, true) && Appointment.compareDeep(this.serviceCategory, o.serviceCategory, true) && Appointment.compareDeep(this.serviceType, o.serviceType, true) && Appointment.compareDeep(this.specialty, o.specialty, true) && Appointment.compareDeep(this.appointmentType, o.appointmentType, true) && Appointment.compareDeep(this.reason, o.reason, true) && Appointment.compareDeep(this.priority, o.priority, true) && Appointment.compareDeep(this.description, o.description, true) && Appointment.compareDeep(this.replaces, o.replaces, true) && Appointment.compareDeep(this.virtualService, o.virtualService, true) && Appointment.compareDeep(this.supportingInformation, o.supportingInformation, true) && Appointment.compareDeep(this.previousAppointment, o.previousAppointment, true) && Appointment.compareDeep(this.originatingAppointment, o.originatingAppointment, true) && Appointment.compareDeep(this.start, o.start, true) && Appointment.compareDeep(this.end, o.end, true) && Appointment.compareDeep(this.minutesDuration, o.minutesDuration, true) && Appointment.compareDeep(this.requestedPeriod, o.requestedPeriod, true) && Appointment.compareDeep(this.slot, o.slot, true) && Appointment.compareDeep(this.account, o.account, true) && Appointment.compareDeep(this.created, o.created, true) && Appointment.compareDeep(this.cancellationDate, o.cancellationDate, true) && Appointment.compareDeep(this.note, o.note, true) && Appointment.compareDeep(this.patientInstruction, o.patientInstruction, true) && Appointment.compareDeep(this.basedOn, o.basedOn, true) && Appointment.compareDeep(this.subject, o.subject, true) && Appointment.compareDeep(this.participant, o.participant, true) && Appointment.compareDeep(this.recurrenceId, o.recurrenceId, true) && Appointment.compareDeep(this.occurrenceChanged, o.occurrenceChanged, true) && Appointment.compareDeep(this.recurrenceTemplate, o.recurrenceTemplate, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Appointment)) {
            return false;
        }
        Appointment o = (Appointment)other_;
        return Appointment.compareValues(this.status, o.status, true) && Appointment.compareValues(this.description, o.description, true) && Appointment.compareValues(this.start, o.start, true) && Appointment.compareValues(this.end, o.end, true) && Appointment.compareValues(this.minutesDuration, o.minutesDuration, true) && Appointment.compareValues(this.created, o.created, true) && Appointment.compareValues(this.cancellationDate, o.cancellationDate, true) && Appointment.compareValues(this.recurrenceId, o.recurrenceId, true) && Appointment.compareValues(this.occurrenceChanged, o.occurrenceChanged, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.cancellationReason, this.class_, this.serviceCategory, this.serviceType, this.specialty, this.appointmentType, this.reason, this.priority, this.description, this.replaces, this.virtualService, this.supportingInformation, this.previousAppointment, this.originatingAppointment, this.start, this.end, this.minutesDuration, this.requestedPeriod, this.slot, this.account, this.created, this.cancellationDate, this.note, this.patientInstruction, this.basedOn, this.subject, this.participant, this.recurrenceId, this.occurrenceChanged, this.recurrenceTemplate});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Appointment;
    }

    @Block
    public static class AppointmentRecurrenceTemplateYearlyTemplateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="yearInterval", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs every nth year", formalDefinition="Appointment recurs every nth year.")
        protected PositiveIntType yearInterval;
        private static final long serialVersionUID = -120794476L;

        public AppointmentRecurrenceTemplateYearlyTemplateComponent() {
        }

        public AppointmentRecurrenceTemplateYearlyTemplateComponent(int yearInterval) {
            this.setYearInterval(yearInterval);
        }

        public PositiveIntType getYearIntervalElement() {
            if (this.yearInterval == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateYearlyTemplateComponent.yearInterval");
                }
                if (Configuration.doAutoCreate()) {
                    this.yearInterval = new PositiveIntType();
                }
            }
            return this.yearInterval;
        }

        public boolean hasYearIntervalElement() {
            return this.yearInterval != null && !this.yearInterval.isEmpty();
        }

        public boolean hasYearInterval() {
            return this.yearInterval != null && !this.yearInterval.isEmpty();
        }

        public AppointmentRecurrenceTemplateYearlyTemplateComponent setYearIntervalElement(PositiveIntType value) {
            this.yearInterval = value;
            return this;
        }

        public int getYearInterval() {
            return this.yearInterval == null || this.yearInterval.isEmpty() ? 0 : (Integer)this.yearInterval.getValue();
        }

        public AppointmentRecurrenceTemplateYearlyTemplateComponent setYearInterval(int value) {
            if (this.yearInterval == null) {
                this.yearInterval = new PositiveIntType();
            }
            this.yearInterval.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("yearInterval", "positiveInt", "Appointment recurs every nth year.", 0, 1, this.yearInterval));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 492389410: {
                    return new Property("yearInterval", "positiveInt", "Appointment recurs every nth year.", 0, 1, this.yearInterval);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 492389410: {
                    Base[] baseArray;
                    if (this.yearInterval == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.yearInterval;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 492389410: {
                    this.yearInterval = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("yearInterval")) {
                return super.setProperty(name, value);
            }
            this.yearInterval = TypeConvertor.castToPositiveInt(value);
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("yearInterval")) {
                this.yearInterval = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 492389410: {
                    return this.getYearIntervalElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 492389410: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("yearInterval")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.yearlyTemplate.yearInterval");
            }
            return super.addChild(name);
        }

        @Override
        public AppointmentRecurrenceTemplateYearlyTemplateComponent copy() {
            AppointmentRecurrenceTemplateYearlyTemplateComponent dst = new AppointmentRecurrenceTemplateYearlyTemplateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AppointmentRecurrenceTemplateYearlyTemplateComponent dst) {
            super.copyValues(dst);
            dst.yearInterval = this.yearInterval == null ? null : this.yearInterval.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentRecurrenceTemplateYearlyTemplateComponent)) {
                return false;
            }
            AppointmentRecurrenceTemplateYearlyTemplateComponent o = (AppointmentRecurrenceTemplateYearlyTemplateComponent)other_;
            return AppointmentRecurrenceTemplateYearlyTemplateComponent.compareDeep(this.yearInterval, o.yearInterval, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentRecurrenceTemplateYearlyTemplateComponent)) {
                return false;
            }
            AppointmentRecurrenceTemplateYearlyTemplateComponent o = (AppointmentRecurrenceTemplateYearlyTemplateComponent)other_;
            return AppointmentRecurrenceTemplateYearlyTemplateComponent.compareValues(this.yearInterval, o.yearInterval, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.yearInterval});
        }

        @Override
        public String fhirType() {
            return "Appointment.recurrenceTemplate.yearlyTemplate";
        }
    }

    @Block
    public static class AppointmentRecurrenceTemplateMonthlyTemplateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="dayOfMonth", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs on a specific day of the month", formalDefinition="Indicates that appointments in the series of recurring appointments should occur on a specific day of the month.")
        protected PositiveIntType dayOfMonth;
        @Child(name="nthWeekOfMonth", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates which week of the month the appointment should occur", formalDefinition="Indicates which week within a month the appointments in the series of recurring appointments should occur on.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/week-of-month")
        protected Coding nthWeekOfMonth;
        @Child(name="dayOfWeek", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates which day of the week the appointment should occur", formalDefinition="Indicates which day of the week the recurring appointments should occur each nth week.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/days-of-week")
        protected Coding dayOfWeek;
        @Child(name="monthInterval", type={PositiveIntType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs every nth month", formalDefinition="Indicates that recurring appointments should occur every nth month.")
        protected PositiveIntType monthInterval;
        private static final long serialVersionUID = -1234046272L;

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent() {
        }

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent(int monthInterval) {
            this.setMonthInterval(monthInterval);
        }

        public PositiveIntType getDayOfMonthElement() {
            if (this.dayOfMonth == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateMonthlyTemplateComponent.dayOfMonth");
                }
                if (Configuration.doAutoCreate()) {
                    this.dayOfMonth = new PositiveIntType();
                }
            }
            return this.dayOfMonth;
        }

        public boolean hasDayOfMonthElement() {
            return this.dayOfMonth != null && !this.dayOfMonth.isEmpty();
        }

        public boolean hasDayOfMonth() {
            return this.dayOfMonth != null && !this.dayOfMonth.isEmpty();
        }

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent setDayOfMonthElement(PositiveIntType value) {
            this.dayOfMonth = value;
            return this;
        }

        public int getDayOfMonth() {
            return this.dayOfMonth == null || this.dayOfMonth.isEmpty() ? 0 : (Integer)this.dayOfMonth.getValue();
        }

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent setDayOfMonth(int value) {
            if (this.dayOfMonth == null) {
                this.dayOfMonth = new PositiveIntType();
            }
            this.dayOfMonth.setValue((Object)value);
            return this;
        }

        public Coding getNthWeekOfMonth() {
            if (this.nthWeekOfMonth == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateMonthlyTemplateComponent.nthWeekOfMonth");
                }
                if (Configuration.doAutoCreate()) {
                    this.nthWeekOfMonth = new Coding();
                }
            }
            return this.nthWeekOfMonth;
        }

        public boolean hasNthWeekOfMonth() {
            return this.nthWeekOfMonth != null && !this.nthWeekOfMonth.isEmpty();
        }

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent setNthWeekOfMonth(Coding value) {
            this.nthWeekOfMonth = value;
            return this;
        }

        public Coding getDayOfWeek() {
            if (this.dayOfWeek == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateMonthlyTemplateComponent.dayOfWeek");
                }
                if (Configuration.doAutoCreate()) {
                    this.dayOfWeek = new Coding();
                }
            }
            return this.dayOfWeek;
        }

        public boolean hasDayOfWeek() {
            return this.dayOfWeek != null && !this.dayOfWeek.isEmpty();
        }

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent setDayOfWeek(Coding value) {
            this.dayOfWeek = value;
            return this;
        }

        public PositiveIntType getMonthIntervalElement() {
            if (this.monthInterval == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateMonthlyTemplateComponent.monthInterval");
                }
                if (Configuration.doAutoCreate()) {
                    this.monthInterval = new PositiveIntType();
                }
            }
            return this.monthInterval;
        }

        public boolean hasMonthIntervalElement() {
            return this.monthInterval != null && !this.monthInterval.isEmpty();
        }

        public boolean hasMonthInterval() {
            return this.monthInterval != null && !this.monthInterval.isEmpty();
        }

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent setMonthIntervalElement(PositiveIntType value) {
            this.monthInterval = value;
            return this;
        }

        public int getMonthInterval() {
            return this.monthInterval == null || this.monthInterval.isEmpty() ? 0 : (Integer)this.monthInterval.getValue();
        }

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent setMonthInterval(int value) {
            if (this.monthInterval == null) {
                this.monthInterval = new PositiveIntType();
            }
            this.monthInterval.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("dayOfMonth", "positiveInt", "Indicates that appointments in the series of recurring appointments should occur on a specific day of the month.", 0, 1, this.dayOfMonth));
            children.add(new Property("nthWeekOfMonth", "Coding", "Indicates which week within a month the appointments in the series of recurring appointments should occur on.", 0, 1, this.nthWeekOfMonth));
            children.add(new Property("dayOfWeek", "Coding", "Indicates which day of the week the recurring appointments should occur each nth week.", 0, 1, this.dayOfWeek));
            children.add(new Property("monthInterval", "positiveInt", "Indicates that recurring appointments should occur every nth month.", 0, 1, this.monthInterval));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1181204563: {
                    return new Property("dayOfMonth", "positiveInt", "Indicates that appointments in the series of recurring appointments should occur on a specific day of the month.", 0, 1, this.dayOfMonth);
                }
                case 724728723: {
                    return new Property("nthWeekOfMonth", "Coding", "Indicates which week within a month the appointments in the series of recurring appointments should occur on.", 0, 1, this.nthWeekOfMonth);
                }
                case -730552025: {
                    return new Property("dayOfWeek", "Coding", "Indicates which day of the week the recurring appointments should occur each nth week.", 0, 1, this.dayOfWeek);
                }
                case -251401371: {
                    return new Property("monthInterval", "positiveInt", "Indicates that recurring appointments should occur every nth month.", 0, 1, this.monthInterval);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1181204563: {
                    Base[] baseArray;
                    if (this.dayOfMonth == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.dayOfMonth;
                    }
                    return baseArray;
                }
                case 724728723: {
                    Base[] baseArray;
                    if (this.nthWeekOfMonth == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.nthWeekOfMonth;
                    }
                    return baseArray;
                }
                case -730552025: {
                    Base[] baseArray;
                    if (this.dayOfWeek == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dayOfWeek;
                    }
                    return baseArray;
                }
                case -251401371: {
                    Base[] baseArray;
                    if (this.monthInterval == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.monthInterval;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1181204563: {
                    this.dayOfMonth = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 724728723: {
                    this.nthWeekOfMonth = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -730552025: {
                    this.dayOfWeek = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -251401371: {
                    this.monthInterval = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("dayOfMonth")) {
                this.dayOfMonth = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("nthWeekOfMonth")) {
                this.nthWeekOfMonth = TypeConvertor.castToCoding(value);
            } else if (name.equals("dayOfWeek")) {
                this.dayOfWeek = TypeConvertor.castToCoding(value);
            } else if (name.equals("monthInterval")) {
                this.monthInterval = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("dayOfMonth")) {
                this.dayOfMonth = null;
            } else if (name.equals("nthWeekOfMonth")) {
                this.nthWeekOfMonth = null;
            } else if (name.equals("dayOfWeek")) {
                this.dayOfWeek = null;
            } else if (name.equals("monthInterval")) {
                this.monthInterval = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1181204563: {
                    return this.getDayOfMonthElement();
                }
                case 724728723: {
                    return this.getNthWeekOfMonth();
                }
                case -730552025: {
                    return this.getDayOfWeek();
                }
                case -251401371: {
                    return this.getMonthIntervalElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1181204563: {
                    return new String[]{"positiveInt"};
                }
                case 724728723: {
                    return new String[]{"Coding"};
                }
                case -730552025: {
                    return new String[]{"Coding"};
                }
                case -251401371: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("dayOfMonth")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.monthlyTemplate.dayOfMonth");
            }
            if (name.equals("nthWeekOfMonth")) {
                this.nthWeekOfMonth = new Coding();
                return this.nthWeekOfMonth;
            }
            if (name.equals("dayOfWeek")) {
                this.dayOfWeek = new Coding();
                return this.dayOfWeek;
            }
            if (name.equals("monthInterval")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.monthlyTemplate.monthInterval");
            }
            return super.addChild(name);
        }

        @Override
        public AppointmentRecurrenceTemplateMonthlyTemplateComponent copy() {
            AppointmentRecurrenceTemplateMonthlyTemplateComponent dst = new AppointmentRecurrenceTemplateMonthlyTemplateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AppointmentRecurrenceTemplateMonthlyTemplateComponent dst) {
            super.copyValues(dst);
            dst.dayOfMonth = this.dayOfMonth == null ? null : this.dayOfMonth.copy();
            dst.nthWeekOfMonth = this.nthWeekOfMonth == null ? null : this.nthWeekOfMonth.copy();
            dst.dayOfWeek = this.dayOfWeek == null ? null : this.dayOfWeek.copy();
            dst.monthInterval = this.monthInterval == null ? null : this.monthInterval.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentRecurrenceTemplateMonthlyTemplateComponent)) {
                return false;
            }
            AppointmentRecurrenceTemplateMonthlyTemplateComponent o = (AppointmentRecurrenceTemplateMonthlyTemplateComponent)other_;
            return AppointmentRecurrenceTemplateMonthlyTemplateComponent.compareDeep(this.dayOfMonth, o.dayOfMonth, true) && AppointmentRecurrenceTemplateMonthlyTemplateComponent.compareDeep(this.nthWeekOfMonth, o.nthWeekOfMonth, true) && AppointmentRecurrenceTemplateMonthlyTemplateComponent.compareDeep(this.dayOfWeek, o.dayOfWeek, true) && AppointmentRecurrenceTemplateMonthlyTemplateComponent.compareDeep(this.monthInterval, o.monthInterval, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentRecurrenceTemplateMonthlyTemplateComponent)) {
                return false;
            }
            AppointmentRecurrenceTemplateMonthlyTemplateComponent o = (AppointmentRecurrenceTemplateMonthlyTemplateComponent)other_;
            return AppointmentRecurrenceTemplateMonthlyTemplateComponent.compareValues(this.dayOfMonth, o.dayOfMonth, true) && AppointmentRecurrenceTemplateMonthlyTemplateComponent.compareValues(this.monthInterval, o.monthInterval, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.dayOfMonth, this.nthWeekOfMonth, this.dayOfWeek, this.monthInterval});
        }

        @Override
        public String fhirType() {
            return "Appointment.recurrenceTemplate.monthlyTemplate";
        }
    }

    @Block
    public static class AppointmentRecurrenceTemplateWeeklyTemplateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="monday", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs on Mondays", formalDefinition="Indicates that recurring appointments should occur on Mondays.")
        protected BooleanType monday;
        @Child(name="tuesday", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs on Tuesday", formalDefinition="Indicates that recurring appointments should occur on Tuesdays.")
        protected BooleanType tuesday;
        @Child(name="wednesday", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs on Wednesday", formalDefinition="Indicates that recurring appointments should occur on Wednesdays.")
        protected BooleanType wednesday;
        @Child(name="thursday", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs on Thursday", formalDefinition="Indicates that recurring appointments should occur on Thursdays.")
        protected BooleanType thursday;
        @Child(name="friday", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs on Friday", formalDefinition="Indicates that recurring appointments should occur on Fridays.")
        protected BooleanType friday;
        @Child(name="saturday", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs on Saturday", formalDefinition="Indicates that recurring appointments should occur on Saturdays.")
        protected BooleanType saturday;
        @Child(name="sunday", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs on Sunday", formalDefinition="Indicates that recurring appointments should occur on Sundays.")
        protected BooleanType sunday;
        @Child(name="weekInterval", type={PositiveIntType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recurs every nth week", formalDefinition="The interval defines if the recurrence is every nth week. The default is every week, so it is expected that this value will be 2 or more.\r\re.g. For recurring every second week this interval would be 2, or every third week the interval would be 3.")
        protected PositiveIntType weekInterval;
        private static final long serialVersionUID = 588795188L;

        public BooleanType getMondayElement() {
            if (this.monday == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateWeeklyTemplateComponent.monday");
                }
                if (Configuration.doAutoCreate()) {
                    this.monday = new BooleanType();
                }
            }
            return this.monday;
        }

        public boolean hasMondayElement() {
            return this.monday != null && !this.monday.isEmpty();
        }

        public boolean hasMonday() {
            return this.monday != null && !this.monday.isEmpty();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setMondayElement(BooleanType value) {
            this.monday = value;
            return this;
        }

        public boolean getMonday() {
            return this.monday == null || this.monday.isEmpty() ? false : (Boolean)this.monday.getValue();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setMonday(boolean value) {
            if (this.monday == null) {
                this.monday = new BooleanType();
            }
            this.monday.setValue((Object)value);
            return this;
        }

        public BooleanType getTuesdayElement() {
            if (this.tuesday == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateWeeklyTemplateComponent.tuesday");
                }
                if (Configuration.doAutoCreate()) {
                    this.tuesday = new BooleanType();
                }
            }
            return this.tuesday;
        }

        public boolean hasTuesdayElement() {
            return this.tuesday != null && !this.tuesday.isEmpty();
        }

        public boolean hasTuesday() {
            return this.tuesday != null && !this.tuesday.isEmpty();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setTuesdayElement(BooleanType value) {
            this.tuesday = value;
            return this;
        }

        public boolean getTuesday() {
            return this.tuesday == null || this.tuesday.isEmpty() ? false : (Boolean)this.tuesday.getValue();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setTuesday(boolean value) {
            if (this.tuesday == null) {
                this.tuesday = new BooleanType();
            }
            this.tuesday.setValue((Object)value);
            return this;
        }

        public BooleanType getWednesdayElement() {
            if (this.wednesday == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateWeeklyTemplateComponent.wednesday");
                }
                if (Configuration.doAutoCreate()) {
                    this.wednesday = new BooleanType();
                }
            }
            return this.wednesday;
        }

        public boolean hasWednesdayElement() {
            return this.wednesday != null && !this.wednesday.isEmpty();
        }

        public boolean hasWednesday() {
            return this.wednesday != null && !this.wednesday.isEmpty();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setWednesdayElement(BooleanType value) {
            this.wednesday = value;
            return this;
        }

        public boolean getWednesday() {
            return this.wednesday == null || this.wednesday.isEmpty() ? false : (Boolean)this.wednesday.getValue();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setWednesday(boolean value) {
            if (this.wednesday == null) {
                this.wednesday = new BooleanType();
            }
            this.wednesday.setValue((Object)value);
            return this;
        }

        public BooleanType getThursdayElement() {
            if (this.thursday == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateWeeklyTemplateComponent.thursday");
                }
                if (Configuration.doAutoCreate()) {
                    this.thursday = new BooleanType();
                }
            }
            return this.thursday;
        }

        public boolean hasThursdayElement() {
            return this.thursday != null && !this.thursday.isEmpty();
        }

        public boolean hasThursday() {
            return this.thursday != null && !this.thursday.isEmpty();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setThursdayElement(BooleanType value) {
            this.thursday = value;
            return this;
        }

        public boolean getThursday() {
            return this.thursday == null || this.thursday.isEmpty() ? false : (Boolean)this.thursday.getValue();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setThursday(boolean value) {
            if (this.thursday == null) {
                this.thursday = new BooleanType();
            }
            this.thursday.setValue((Object)value);
            return this;
        }

        public BooleanType getFridayElement() {
            if (this.friday == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateWeeklyTemplateComponent.friday");
                }
                if (Configuration.doAutoCreate()) {
                    this.friday = new BooleanType();
                }
            }
            return this.friday;
        }

        public boolean hasFridayElement() {
            return this.friday != null && !this.friday.isEmpty();
        }

        public boolean hasFriday() {
            return this.friday != null && !this.friday.isEmpty();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setFridayElement(BooleanType value) {
            this.friday = value;
            return this;
        }

        public boolean getFriday() {
            return this.friday == null || this.friday.isEmpty() ? false : (Boolean)this.friday.getValue();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setFriday(boolean value) {
            if (this.friday == null) {
                this.friday = new BooleanType();
            }
            this.friday.setValue((Object)value);
            return this;
        }

        public BooleanType getSaturdayElement() {
            if (this.saturday == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateWeeklyTemplateComponent.saturday");
                }
                if (Configuration.doAutoCreate()) {
                    this.saturday = new BooleanType();
                }
            }
            return this.saturday;
        }

        public boolean hasSaturdayElement() {
            return this.saturday != null && !this.saturday.isEmpty();
        }

        public boolean hasSaturday() {
            return this.saturday != null && !this.saturday.isEmpty();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setSaturdayElement(BooleanType value) {
            this.saturday = value;
            return this;
        }

        public boolean getSaturday() {
            return this.saturday == null || this.saturday.isEmpty() ? false : (Boolean)this.saturday.getValue();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setSaturday(boolean value) {
            if (this.saturday == null) {
                this.saturday = new BooleanType();
            }
            this.saturday.setValue((Object)value);
            return this;
        }

        public BooleanType getSundayElement() {
            if (this.sunday == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateWeeklyTemplateComponent.sunday");
                }
                if (Configuration.doAutoCreate()) {
                    this.sunday = new BooleanType();
                }
            }
            return this.sunday;
        }

        public boolean hasSundayElement() {
            return this.sunday != null && !this.sunday.isEmpty();
        }

        public boolean hasSunday() {
            return this.sunday != null && !this.sunday.isEmpty();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setSundayElement(BooleanType value) {
            this.sunday = value;
            return this;
        }

        public boolean getSunday() {
            return this.sunday == null || this.sunday.isEmpty() ? false : (Boolean)this.sunday.getValue();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setSunday(boolean value) {
            if (this.sunday == null) {
                this.sunday = new BooleanType();
            }
            this.sunday.setValue((Object)value);
            return this;
        }

        public PositiveIntType getWeekIntervalElement() {
            if (this.weekInterval == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateWeeklyTemplateComponent.weekInterval");
                }
                if (Configuration.doAutoCreate()) {
                    this.weekInterval = new PositiveIntType();
                }
            }
            return this.weekInterval;
        }

        public boolean hasWeekIntervalElement() {
            return this.weekInterval != null && !this.weekInterval.isEmpty();
        }

        public boolean hasWeekInterval() {
            return this.weekInterval != null && !this.weekInterval.isEmpty();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setWeekIntervalElement(PositiveIntType value) {
            this.weekInterval = value;
            return this;
        }

        public int getWeekInterval() {
            return this.weekInterval == null || this.weekInterval.isEmpty() ? 0 : (Integer)this.weekInterval.getValue();
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent setWeekInterval(int value) {
            if (this.weekInterval == null) {
                this.weekInterval = new PositiveIntType();
            }
            this.weekInterval.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("monday", "boolean", "Indicates that recurring appointments should occur on Mondays.", 0, 1, this.monday));
            children.add(new Property("tuesday", "boolean", "Indicates that recurring appointments should occur on Tuesdays.", 0, 1, this.tuesday));
            children.add(new Property("wednesday", "boolean", "Indicates that recurring appointments should occur on Wednesdays.", 0, 1, this.wednesday));
            children.add(new Property("thursday", "boolean", "Indicates that recurring appointments should occur on Thursdays.", 0, 1, this.thursday));
            children.add(new Property("friday", "boolean", "Indicates that recurring appointments should occur on Fridays.", 0, 1, this.friday));
            children.add(new Property("saturday", "boolean", "Indicates that recurring appointments should occur on Saturdays.", 0, 1, this.saturday));
            children.add(new Property("sunday", "boolean", "Indicates that recurring appointments should occur on Sundays.", 0, 1, this.sunday));
            children.add(new Property("weekInterval", "positiveInt", "The interval defines if the recurrence is every nth week. The default is every week, so it is expected that this value will be 2 or more.\r\re.g. For recurring every second week this interval would be 2, or every third week the interval would be 3.", 0, 1, this.weekInterval));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1068502768: {
                    return new Property("monday", "boolean", "Indicates that recurring appointments should occur on Mondays.", 0, 1, this.monday);
                }
                case -977343923: {
                    return new Property("tuesday", "boolean", "Indicates that recurring appointments should occur on Tuesdays.", 0, 1, this.tuesday);
                }
                case 1393530710: {
                    return new Property("wednesday", "boolean", "Indicates that recurring appointments should occur on Wednesdays.", 0, 1, this.wednesday);
                }
                case 1572055514: {
                    return new Property("thursday", "boolean", "Indicates that recurring appointments should occur on Thursdays.", 0, 1, this.thursday);
                }
                case -1266285217: {
                    return new Property("friday", "boolean", "Indicates that recurring appointments should occur on Fridays.", 0, 1, this.friday);
                }
                case -2114201671: {
                    return new Property("saturday", "boolean", "Indicates that recurring appointments should occur on Saturdays.", 0, 1, this.saturday);
                }
                case -891186736: {
                    return new Property("sunday", "boolean", "Indicates that recurring appointments should occur on Sundays.", 0, 1, this.sunday);
                }
                case -784550695: {
                    return new Property("weekInterval", "positiveInt", "The interval defines if the recurrence is every nth week. The default is every week, so it is expected that this value will be 2 or more.\r\re.g. For recurring every second week this interval would be 2, or every third week the interval would be 3.", 0, 1, this.weekInterval);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1068502768: {
                    Base[] baseArray;
                    if (this.monday == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.monday;
                    }
                    return baseArray;
                }
                case -977343923: {
                    Base[] baseArray;
                    if (this.tuesday == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.tuesday;
                    }
                    return baseArray;
                }
                case 1393530710: {
                    Base[] baseArray;
                    if (this.wednesday == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.wednesday;
                    }
                    return baseArray;
                }
                case 1572055514: {
                    Base[] baseArray;
                    if (this.thursday == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.thursday;
                    }
                    return baseArray;
                }
                case -1266285217: {
                    Base[] baseArray;
                    if (this.friday == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.friday;
                    }
                    return baseArray;
                }
                case -2114201671: {
                    Base[] baseArray;
                    if (this.saturday == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.saturday;
                    }
                    return baseArray;
                }
                case -891186736: {
                    Base[] baseArray;
                    if (this.sunday == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.sunday;
                    }
                    return baseArray;
                }
                case -784550695: {
                    Base[] baseArray;
                    if (this.weekInterval == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.weekInterval;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1068502768: {
                    this.monday = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -977343923: {
                    this.tuesday = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1393530710: {
                    this.wednesday = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1572055514: {
                    this.thursday = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1266285217: {
                    this.friday = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -2114201671: {
                    this.saturday = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -891186736: {
                    this.sunday = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -784550695: {
                    this.weekInterval = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("monday")) {
                this.monday = TypeConvertor.castToBoolean(value);
            } else if (name.equals("tuesday")) {
                this.tuesday = TypeConvertor.castToBoolean(value);
            } else if (name.equals("wednesday")) {
                this.wednesday = TypeConvertor.castToBoolean(value);
            } else if (name.equals("thursday")) {
                this.thursday = TypeConvertor.castToBoolean(value);
            } else if (name.equals("friday")) {
                this.friday = TypeConvertor.castToBoolean(value);
            } else if (name.equals("saturday")) {
                this.saturday = TypeConvertor.castToBoolean(value);
            } else if (name.equals("sunday")) {
                this.sunday = TypeConvertor.castToBoolean(value);
            } else if (name.equals("weekInterval")) {
                this.weekInterval = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("monday")) {
                this.monday = null;
            } else if (name.equals("tuesday")) {
                this.tuesday = null;
            } else if (name.equals("wednesday")) {
                this.wednesday = null;
            } else if (name.equals("thursday")) {
                this.thursday = null;
            } else if (name.equals("friday")) {
                this.friday = null;
            } else if (name.equals("saturday")) {
                this.saturday = null;
            } else if (name.equals("sunday")) {
                this.sunday = null;
            } else if (name.equals("weekInterval")) {
                this.weekInterval = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1068502768: {
                    return this.getMondayElement();
                }
                case -977343923: {
                    return this.getTuesdayElement();
                }
                case 1393530710: {
                    return this.getWednesdayElement();
                }
                case 1572055514: {
                    return this.getThursdayElement();
                }
                case -1266285217: {
                    return this.getFridayElement();
                }
                case -2114201671: {
                    return this.getSaturdayElement();
                }
                case -891186736: {
                    return this.getSundayElement();
                }
                case -784550695: {
                    return this.getWeekIntervalElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1068502768: {
                    return new String[]{"boolean"};
                }
                case -977343923: {
                    return new String[]{"boolean"};
                }
                case 1393530710: {
                    return new String[]{"boolean"};
                }
                case 1572055514: {
                    return new String[]{"boolean"};
                }
                case -1266285217: {
                    return new String[]{"boolean"};
                }
                case -2114201671: {
                    return new String[]{"boolean"};
                }
                case -891186736: {
                    return new String[]{"boolean"};
                }
                case -784550695: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("monday")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.weeklyTemplate.monday");
            }
            if (name.equals("tuesday")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.weeklyTemplate.tuesday");
            }
            if (name.equals("wednesday")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.weeklyTemplate.wednesday");
            }
            if (name.equals("thursday")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.weeklyTemplate.thursday");
            }
            if (name.equals("friday")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.weeklyTemplate.friday");
            }
            if (name.equals("saturday")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.weeklyTemplate.saturday");
            }
            if (name.equals("sunday")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.weeklyTemplate.sunday");
            }
            if (name.equals("weekInterval")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.weeklyTemplate.weekInterval");
            }
            return super.addChild(name);
        }

        @Override
        public AppointmentRecurrenceTemplateWeeklyTemplateComponent copy() {
            AppointmentRecurrenceTemplateWeeklyTemplateComponent dst = new AppointmentRecurrenceTemplateWeeklyTemplateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AppointmentRecurrenceTemplateWeeklyTemplateComponent dst) {
            super.copyValues(dst);
            dst.monday = this.monday == null ? null : this.monday.copy();
            dst.tuesday = this.tuesday == null ? null : this.tuesday.copy();
            dst.wednesday = this.wednesday == null ? null : this.wednesday.copy();
            dst.thursday = this.thursday == null ? null : this.thursday.copy();
            dst.friday = this.friday == null ? null : this.friday.copy();
            dst.saturday = this.saturday == null ? null : this.saturday.copy();
            dst.sunday = this.sunday == null ? null : this.sunday.copy();
            dst.weekInterval = this.weekInterval == null ? null : this.weekInterval.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentRecurrenceTemplateWeeklyTemplateComponent)) {
                return false;
            }
            AppointmentRecurrenceTemplateWeeklyTemplateComponent o = (AppointmentRecurrenceTemplateWeeklyTemplateComponent)other_;
            return AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareDeep(this.monday, o.monday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareDeep(this.tuesday, o.tuesday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareDeep(this.wednesday, o.wednesday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareDeep(this.thursday, o.thursday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareDeep(this.friday, o.friday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareDeep(this.saturday, o.saturday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareDeep(this.sunday, o.sunday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareDeep(this.weekInterval, o.weekInterval, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentRecurrenceTemplateWeeklyTemplateComponent)) {
                return false;
            }
            AppointmentRecurrenceTemplateWeeklyTemplateComponent o = (AppointmentRecurrenceTemplateWeeklyTemplateComponent)other_;
            return AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareValues(this.monday, o.monday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareValues(this.tuesday, o.tuesday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareValues(this.wednesday, o.wednesday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareValues(this.thursday, o.thursday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareValues(this.friday, o.friday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareValues(this.saturday, o.saturday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareValues(this.sunday, o.sunday, true) && AppointmentRecurrenceTemplateWeeklyTemplateComponent.compareValues(this.weekInterval, o.weekInterval, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday, this.sunday, this.weekInterval});
        }

        @Override
        public String fhirType() {
            return "Appointment.recurrenceTemplate.weeklyTemplate";
        }
    }

    @Block
    public static class AppointmentRecurrenceTemplateComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="timezone", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The timezone of the occurrences", formalDefinition="The timezone of the recurring appointment occurrences.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/timezones")
        protected CodeableConcept timezone;
        @Child(name="recurrenceType", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The frequency of the recurrence", formalDefinition="How often the appointment series should recur.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/appointment-recurrrence-type")
        protected CodeableConcept recurrenceType;
        @Child(name="lastOccurrenceDate", type={DateType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date when the recurrence should end", formalDefinition="Recurring appointments will not occur after this date.")
        protected DateType lastOccurrenceDate;
        @Child(name="occurrenceCount", type={PositiveIntType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of planned occurrences", formalDefinition="How many appointments are planned in the recurrence.")
        protected PositiveIntType occurrenceCount;
        @Child(name="occurrenceDate", type={DateType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specific dates for a recurring set of appointments (no template)", formalDefinition="The list of specific dates that will have appointments generated.")
        protected List<DateType> occurrenceDate;
        @Child(name="weeklyTemplate", type={}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information about weekly recurring appointments", formalDefinition="Information about weekly recurring appointments.")
        protected AppointmentRecurrenceTemplateWeeklyTemplateComponent weeklyTemplate;
        @Child(name="monthlyTemplate", type={}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information about monthly recurring appointments", formalDefinition="Information about monthly recurring appointments.")
        protected AppointmentRecurrenceTemplateMonthlyTemplateComponent monthlyTemplate;
        @Child(name="yearlyTemplate", type={}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information about yearly recurring appointments", formalDefinition="Information about yearly recurring appointments.")
        protected AppointmentRecurrenceTemplateYearlyTemplateComponent yearlyTemplate;
        @Child(name="excludingDate", type={DateType.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Any dates that should be excluded from the series", formalDefinition="Any dates, such as holidays, that should be excluded from the recurrence.")
        protected List<DateType> excludingDate;
        @Child(name="excludingRecurrenceId", type={PositiveIntType.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Any recurrence IDs that should be excluded from the recurrence", formalDefinition="Any dates, such as holidays, that should be excluded from the recurrence.")
        protected List<PositiveIntType> excludingRecurrenceId;
        private static final long serialVersionUID = -1582999176L;

        public AppointmentRecurrenceTemplateComponent() {
        }

        public AppointmentRecurrenceTemplateComponent(CodeableConcept recurrenceType) {
            this.setRecurrenceType(recurrenceType);
        }

        public CodeableConcept getTimezone() {
            if (this.timezone == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateComponent.timezone");
                }
                if (Configuration.doAutoCreate()) {
                    this.timezone = new CodeableConcept();
                }
            }
            return this.timezone;
        }

        public boolean hasTimezone() {
            return this.timezone != null && !this.timezone.isEmpty();
        }

        public AppointmentRecurrenceTemplateComponent setTimezone(CodeableConcept value) {
            this.timezone = value;
            return this;
        }

        public CodeableConcept getRecurrenceType() {
            if (this.recurrenceType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateComponent.recurrenceType");
                }
                if (Configuration.doAutoCreate()) {
                    this.recurrenceType = new CodeableConcept();
                }
            }
            return this.recurrenceType;
        }

        public boolean hasRecurrenceType() {
            return this.recurrenceType != null && !this.recurrenceType.isEmpty();
        }

        public AppointmentRecurrenceTemplateComponent setRecurrenceType(CodeableConcept value) {
            this.recurrenceType = value;
            return this;
        }

        public DateType getLastOccurrenceDateElement() {
            if (this.lastOccurrenceDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateComponent.lastOccurrenceDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastOccurrenceDate = new DateType();
                }
            }
            return this.lastOccurrenceDate;
        }

        public boolean hasLastOccurrenceDateElement() {
            return this.lastOccurrenceDate != null && !this.lastOccurrenceDate.isEmpty();
        }

        public boolean hasLastOccurrenceDate() {
            return this.lastOccurrenceDate != null && !this.lastOccurrenceDate.isEmpty();
        }

        public AppointmentRecurrenceTemplateComponent setLastOccurrenceDateElement(DateType value) {
            this.lastOccurrenceDate = value;
            return this;
        }

        public Date getLastOccurrenceDate() {
            return this.lastOccurrenceDate == null ? null : (Date)this.lastOccurrenceDate.getValue();
        }

        public AppointmentRecurrenceTemplateComponent setLastOccurrenceDate(Date value) {
            if (value == null) {
                this.lastOccurrenceDate = null;
            } else {
                if (this.lastOccurrenceDate == null) {
                    this.lastOccurrenceDate = new DateType();
                }
                this.lastOccurrenceDate.setValue(value);
            }
            return this;
        }

        public PositiveIntType getOccurrenceCountElement() {
            if (this.occurrenceCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateComponent.occurrenceCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.occurrenceCount = new PositiveIntType();
                }
            }
            return this.occurrenceCount;
        }

        public boolean hasOccurrenceCountElement() {
            return this.occurrenceCount != null && !this.occurrenceCount.isEmpty();
        }

        public boolean hasOccurrenceCount() {
            return this.occurrenceCount != null && !this.occurrenceCount.isEmpty();
        }

        public AppointmentRecurrenceTemplateComponent setOccurrenceCountElement(PositiveIntType value) {
            this.occurrenceCount = value;
            return this;
        }

        public int getOccurrenceCount() {
            return this.occurrenceCount == null || this.occurrenceCount.isEmpty() ? 0 : (Integer)this.occurrenceCount.getValue();
        }

        public AppointmentRecurrenceTemplateComponent setOccurrenceCount(int value) {
            if (this.occurrenceCount == null) {
                this.occurrenceCount = new PositiveIntType();
            }
            this.occurrenceCount.setValue((Object)value);
            return this;
        }

        public List<DateType> getOccurrenceDate() {
            if (this.occurrenceDate == null) {
                this.occurrenceDate = new ArrayList<DateType>();
            }
            return this.occurrenceDate;
        }

        public AppointmentRecurrenceTemplateComponent setOccurrenceDate(List<DateType> theOccurrenceDate) {
            this.occurrenceDate = theOccurrenceDate;
            return this;
        }

        public boolean hasOccurrenceDate() {
            if (this.occurrenceDate == null) {
                return false;
            }
            for (DateType item : this.occurrenceDate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DateType addOccurrenceDateElement() {
            DateType t = new DateType();
            if (this.occurrenceDate == null) {
                this.occurrenceDate = new ArrayList<DateType>();
            }
            this.occurrenceDate.add(t);
            return t;
        }

        public AppointmentRecurrenceTemplateComponent addOccurrenceDate(Date value) {
            DateType t = new DateType();
            t.setValue(value);
            if (this.occurrenceDate == null) {
                this.occurrenceDate = new ArrayList<DateType>();
            }
            this.occurrenceDate.add(t);
            return this;
        }

        public boolean hasOccurrenceDate(Date value) {
            if (this.occurrenceDate == null) {
                return false;
            }
            for (DateType v : this.occurrenceDate) {
                if (!((Date)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public AppointmentRecurrenceTemplateWeeklyTemplateComponent getWeeklyTemplate() {
            if (this.weeklyTemplate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateComponent.weeklyTemplate");
                }
                if (Configuration.doAutoCreate()) {
                    this.weeklyTemplate = new AppointmentRecurrenceTemplateWeeklyTemplateComponent();
                }
            }
            return this.weeklyTemplate;
        }

        public boolean hasWeeklyTemplate() {
            return this.weeklyTemplate != null && !this.weeklyTemplate.isEmpty();
        }

        public AppointmentRecurrenceTemplateComponent setWeeklyTemplate(AppointmentRecurrenceTemplateWeeklyTemplateComponent value) {
            this.weeklyTemplate = value;
            return this;
        }

        public AppointmentRecurrenceTemplateMonthlyTemplateComponent getMonthlyTemplate() {
            if (this.monthlyTemplate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateComponent.monthlyTemplate");
                }
                if (Configuration.doAutoCreate()) {
                    this.monthlyTemplate = new AppointmentRecurrenceTemplateMonthlyTemplateComponent();
                }
            }
            return this.monthlyTemplate;
        }

        public boolean hasMonthlyTemplate() {
            return this.monthlyTemplate != null && !this.monthlyTemplate.isEmpty();
        }

        public AppointmentRecurrenceTemplateComponent setMonthlyTemplate(AppointmentRecurrenceTemplateMonthlyTemplateComponent value) {
            this.monthlyTemplate = value;
            return this;
        }

        public AppointmentRecurrenceTemplateYearlyTemplateComponent getYearlyTemplate() {
            if (this.yearlyTemplate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentRecurrenceTemplateComponent.yearlyTemplate");
                }
                if (Configuration.doAutoCreate()) {
                    this.yearlyTemplate = new AppointmentRecurrenceTemplateYearlyTemplateComponent();
                }
            }
            return this.yearlyTemplate;
        }

        public boolean hasYearlyTemplate() {
            return this.yearlyTemplate != null && !this.yearlyTemplate.isEmpty();
        }

        public AppointmentRecurrenceTemplateComponent setYearlyTemplate(AppointmentRecurrenceTemplateYearlyTemplateComponent value) {
            this.yearlyTemplate = value;
            return this;
        }

        public List<DateType> getExcludingDate() {
            if (this.excludingDate == null) {
                this.excludingDate = new ArrayList<DateType>();
            }
            return this.excludingDate;
        }

        public AppointmentRecurrenceTemplateComponent setExcludingDate(List<DateType> theExcludingDate) {
            this.excludingDate = theExcludingDate;
            return this;
        }

        public boolean hasExcludingDate() {
            if (this.excludingDate == null) {
                return false;
            }
            for (DateType item : this.excludingDate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DateType addExcludingDateElement() {
            DateType t = new DateType();
            if (this.excludingDate == null) {
                this.excludingDate = new ArrayList<DateType>();
            }
            this.excludingDate.add(t);
            return t;
        }

        public AppointmentRecurrenceTemplateComponent addExcludingDate(Date value) {
            DateType t = new DateType();
            t.setValue(value);
            if (this.excludingDate == null) {
                this.excludingDate = new ArrayList<DateType>();
            }
            this.excludingDate.add(t);
            return this;
        }

        public boolean hasExcludingDate(Date value) {
            if (this.excludingDate == null) {
                return false;
            }
            for (DateType v : this.excludingDate) {
                if (!((Date)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getExcludingRecurrenceId() {
            if (this.excludingRecurrenceId == null) {
                this.excludingRecurrenceId = new ArrayList<PositiveIntType>();
            }
            return this.excludingRecurrenceId;
        }

        public AppointmentRecurrenceTemplateComponent setExcludingRecurrenceId(List<PositiveIntType> theExcludingRecurrenceId) {
            this.excludingRecurrenceId = theExcludingRecurrenceId;
            return this;
        }

        public boolean hasExcludingRecurrenceId() {
            if (this.excludingRecurrenceId == null) {
                return false;
            }
            for (PositiveIntType item : this.excludingRecurrenceId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addExcludingRecurrenceIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.excludingRecurrenceId == null) {
                this.excludingRecurrenceId = new ArrayList<PositiveIntType>();
            }
            this.excludingRecurrenceId.add(t);
            return t;
        }

        public AppointmentRecurrenceTemplateComponent addExcludingRecurrenceId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.excludingRecurrenceId == null) {
                this.excludingRecurrenceId = new ArrayList<PositiveIntType>();
            }
            this.excludingRecurrenceId.add(t);
            return this;
        }

        public boolean hasExcludingRecurrenceId(int value) {
            if (this.excludingRecurrenceId == null) {
                return false;
            }
            for (PositiveIntType v : this.excludingRecurrenceId) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("timezone", "CodeableConcept", "The timezone of the recurring appointment occurrences.", 0, 1, this.timezone));
            children.add(new Property("recurrenceType", "CodeableConcept", "How often the appointment series should recur.", 0, 1, this.recurrenceType));
            children.add(new Property("lastOccurrenceDate", Appointment.SP_DATE, "Recurring appointments will not occur after this date.", 0, 1, this.lastOccurrenceDate));
            children.add(new Property("occurrenceCount", "positiveInt", "How many appointments are planned in the recurrence.", 0, 1, this.occurrenceCount));
            children.add(new Property("occurrenceDate", Appointment.SP_DATE, "The list of specific dates that will have appointments generated.", 0, Integer.MAX_VALUE, this.occurrenceDate));
            children.add(new Property("weeklyTemplate", "", "Information about weekly recurring appointments.", 0, 1, this.weeklyTemplate));
            children.add(new Property("monthlyTemplate", "", "Information about monthly recurring appointments.", 0, 1, this.monthlyTemplate));
            children.add(new Property("yearlyTemplate", "", "Information about yearly recurring appointments.", 0, 1, this.yearlyTemplate));
            children.add(new Property("excludingDate", Appointment.SP_DATE, "Any dates, such as holidays, that should be excluded from the recurrence.", 0, Integer.MAX_VALUE, this.excludingDate));
            children.add(new Property("excludingRecurrenceId", "positiveInt", "Any dates, such as holidays, that should be excluded from the recurrence.", 0, Integer.MAX_VALUE, this.excludingRecurrenceId));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -2076227591: {
                    return new Property("timezone", "CodeableConcept", "The timezone of the recurring appointment occurrences.", 0, 1, this.timezone);
                }
                case -381221238: {
                    return new Property("recurrenceType", "CodeableConcept", "How often the appointment series should recur.", 0, 1, this.recurrenceType);
                }
                case -1262346923: {
                    return new Property("lastOccurrenceDate", Appointment.SP_DATE, "Recurring appointments will not occur after this date.", 0, 1, this.lastOccurrenceDate);
                }
                case 1834480062: {
                    return new Property("occurrenceCount", "positiveInt", "How many appointments are planned in the recurrence.", 0, 1, this.occurrenceCount);
                }
                case 1721761055: {
                    return new Property("occurrenceDate", Appointment.SP_DATE, "The list of specific dates that will have appointments generated.", 0, Integer.MAX_VALUE, this.occurrenceDate);
                }
                case 887136283: {
                    return new Property("weeklyTemplate", "", "Information about weekly recurring appointments.", 0, 1, this.weeklyTemplate);
                }
                case 2142528423: {
                    return new Property("monthlyTemplate", "", "Information about monthly recurring appointments.", 0, 1, this.monthlyTemplate);
                }
                case -334069468: {
                    return new Property("yearlyTemplate", "", "Information about yearly recurring appointments.", 0, 1, this.yearlyTemplate);
                }
                case 596601957: {
                    return new Property("excludingDate", Appointment.SP_DATE, "Any dates, such as holidays, that should be excluded from the recurrence.", 0, Integer.MAX_VALUE, this.excludingDate);
                }
                case -797577694: {
                    return new Property("excludingRecurrenceId", "positiveInt", "Any dates, such as holidays, that should be excluded from the recurrence.", 0, Integer.MAX_VALUE, this.excludingRecurrenceId);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -2076227591: {
                    Base[] baseArray;
                    if (this.timezone == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.timezone;
                    }
                    return baseArray;
                }
                case -381221238: {
                    Base[] baseArray;
                    if (this.recurrenceType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.recurrenceType;
                    }
                    return baseArray;
                }
                case -1262346923: {
                    Base[] baseArray;
                    if (this.lastOccurrenceDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.lastOccurrenceDate;
                    }
                    return baseArray;
                }
                case 1834480062: {
                    Base[] baseArray;
                    if (this.occurrenceCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.occurrenceCount;
                    }
                    return baseArray;
                }
                case 1721761055: {
                    return this.occurrenceDate == null ? new Base[]{} : this.occurrenceDate.toArray(new Base[this.occurrenceDate.size()]);
                }
                case 887136283: {
                    Base[] baseArray;
                    if (this.weeklyTemplate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.weeklyTemplate;
                    }
                    return baseArray;
                }
                case 2142528423: {
                    Base[] baseArray;
                    if (this.monthlyTemplate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.monthlyTemplate;
                    }
                    return baseArray;
                }
                case -334069468: {
                    Base[] baseArray;
                    if (this.yearlyTemplate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.yearlyTemplate;
                    }
                    return baseArray;
                }
                case 596601957: {
                    return this.excludingDate == null ? new Base[]{} : this.excludingDate.toArray(new Base[this.excludingDate.size()]);
                }
                case -797577694: {
                    return this.excludingRecurrenceId == null ? new Base[]{} : this.excludingRecurrenceId.toArray(new Base[this.excludingRecurrenceId.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -2076227591: {
                    this.timezone = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -381221238: {
                    this.recurrenceType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1262346923: {
                    this.lastOccurrenceDate = TypeConvertor.castToDate(value);
                    return value;
                }
                case 1834480062: {
                    this.occurrenceCount = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 1721761055: {
                    this.getOccurrenceDate().add(TypeConvertor.castToDate(value));
                    return value;
                }
                case 887136283: {
                    this.weeklyTemplate = (AppointmentRecurrenceTemplateWeeklyTemplateComponent)value;
                    return value;
                }
                case 2142528423: {
                    this.monthlyTemplate = (AppointmentRecurrenceTemplateMonthlyTemplateComponent)value;
                    return value;
                }
                case -334069468: {
                    this.yearlyTemplate = (AppointmentRecurrenceTemplateYearlyTemplateComponent)value;
                    return value;
                }
                case 596601957: {
                    this.getExcludingDate().add(TypeConvertor.castToDate(value));
                    return value;
                }
                case -797577694: {
                    this.getExcludingRecurrenceId().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("timezone")) {
                this.timezone = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("recurrenceType")) {
                this.recurrenceType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("lastOccurrenceDate")) {
                this.lastOccurrenceDate = TypeConvertor.castToDate(value);
            } else if (name.equals("occurrenceCount")) {
                this.occurrenceCount = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("occurrenceDate")) {
                this.getOccurrenceDate().add(TypeConvertor.castToDate(value));
            } else if (name.equals("weeklyTemplate")) {
                this.weeklyTemplate = (AppointmentRecurrenceTemplateWeeklyTemplateComponent)value;
            } else if (name.equals("monthlyTemplate")) {
                this.monthlyTemplate = (AppointmentRecurrenceTemplateMonthlyTemplateComponent)value;
            } else if (name.equals("yearlyTemplate")) {
                this.yearlyTemplate = (AppointmentRecurrenceTemplateYearlyTemplateComponent)value;
            } else if (name.equals("excludingDate")) {
                this.getExcludingDate().add(TypeConvertor.castToDate(value));
            } else if (name.equals("excludingRecurrenceId")) {
                this.getExcludingRecurrenceId().add(TypeConvertor.castToPositiveInt(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("timezone")) {
                this.timezone = null;
            } else if (name.equals("recurrenceType")) {
                this.recurrenceType = null;
            } else if (name.equals("lastOccurrenceDate")) {
                this.lastOccurrenceDate = null;
            } else if (name.equals("occurrenceCount")) {
                this.occurrenceCount = null;
            } else if (name.equals("occurrenceDate")) {
                this.getOccurrenceDate().remove(value);
            } else if (name.equals("weeklyTemplate")) {
                this.weeklyTemplate = (AppointmentRecurrenceTemplateWeeklyTemplateComponent)value;
            } else if (name.equals("monthlyTemplate")) {
                this.monthlyTemplate = (AppointmentRecurrenceTemplateMonthlyTemplateComponent)value;
            } else if (name.equals("yearlyTemplate")) {
                this.yearlyTemplate = (AppointmentRecurrenceTemplateYearlyTemplateComponent)value;
            } else if (name.equals("excludingDate")) {
                this.getExcludingDate().remove(value);
            } else if (name.equals("excludingRecurrenceId")) {
                this.getExcludingRecurrenceId().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2076227591: {
                    return this.getTimezone();
                }
                case -381221238: {
                    return this.getRecurrenceType();
                }
                case -1262346923: {
                    return this.getLastOccurrenceDateElement();
                }
                case 1834480062: {
                    return this.getOccurrenceCountElement();
                }
                case 1721761055: {
                    return this.addOccurrenceDateElement();
                }
                case 887136283: {
                    return this.getWeeklyTemplate();
                }
                case 2142528423: {
                    return this.getMonthlyTemplate();
                }
                case -334069468: {
                    return this.getYearlyTemplate();
                }
                case 596601957: {
                    return this.addExcludingDateElement();
                }
                case -797577694: {
                    return this.addExcludingRecurrenceIdElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2076227591: {
                    return new String[]{"CodeableConcept"};
                }
                case -381221238: {
                    return new String[]{"CodeableConcept"};
                }
                case -1262346923: {
                    return new String[]{Appointment.SP_DATE};
                }
                case 1834480062: {
                    return new String[]{"positiveInt"};
                }
                case 1721761055: {
                    return new String[]{Appointment.SP_DATE};
                }
                case 887136283: {
                    return new String[0];
                }
                case 2142528423: {
                    return new String[0];
                }
                case -334069468: {
                    return new String[0];
                }
                case 596601957: {
                    return new String[]{Appointment.SP_DATE};
                }
                case -797577694: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("timezone")) {
                this.timezone = new CodeableConcept();
                return this.timezone;
            }
            if (name.equals("recurrenceType")) {
                this.recurrenceType = new CodeableConcept();
                return this.recurrenceType;
            }
            if (name.equals("lastOccurrenceDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.lastOccurrenceDate");
            }
            if (name.equals("occurrenceCount")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.occurrenceCount");
            }
            if (name.equals("occurrenceDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.occurrenceDate");
            }
            if (name.equals("weeklyTemplate")) {
                this.weeklyTemplate = new AppointmentRecurrenceTemplateWeeklyTemplateComponent();
                return this.weeklyTemplate;
            }
            if (name.equals("monthlyTemplate")) {
                this.monthlyTemplate = new AppointmentRecurrenceTemplateMonthlyTemplateComponent();
                return this.monthlyTemplate;
            }
            if (name.equals("yearlyTemplate")) {
                this.yearlyTemplate = new AppointmentRecurrenceTemplateYearlyTemplateComponent();
                return this.yearlyTemplate;
            }
            if (name.equals("excludingDate")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.excludingDate");
            }
            if (name.equals("excludingRecurrenceId")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.recurrenceTemplate.excludingRecurrenceId");
            }
            return super.addChild(name);
        }

        @Override
        public AppointmentRecurrenceTemplateComponent copy() {
            AppointmentRecurrenceTemplateComponent dst = new AppointmentRecurrenceTemplateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AppointmentRecurrenceTemplateComponent dst) {
            super.copyValues(dst);
            dst.timezone = this.timezone == null ? null : this.timezone.copy();
            dst.recurrenceType = this.recurrenceType == null ? null : this.recurrenceType.copy();
            dst.lastOccurrenceDate = this.lastOccurrenceDate == null ? null : this.lastOccurrenceDate.copy();
            PositiveIntType positiveIntType = dst.occurrenceCount = this.occurrenceCount == null ? null : this.occurrenceCount.copy();
            if (this.occurrenceDate != null) {
                dst.occurrenceDate = new ArrayList<DateType>();
                for (DateType dateType : this.occurrenceDate) {
                    dst.occurrenceDate.add(dateType.copy());
                }
            }
            dst.weeklyTemplate = this.weeklyTemplate == null ? null : this.weeklyTemplate.copy();
            dst.monthlyTemplate = this.monthlyTemplate == null ? null : this.monthlyTemplate.copy();
            AppointmentRecurrenceTemplateYearlyTemplateComponent appointmentRecurrenceTemplateYearlyTemplateComponent = dst.yearlyTemplate = this.yearlyTemplate == null ? null : this.yearlyTemplate.copy();
            if (this.excludingDate != null) {
                dst.excludingDate = new ArrayList<DateType>();
                for (DateType dateType : this.excludingDate) {
                    dst.excludingDate.add(dateType.copy());
                }
            }
            if (this.excludingRecurrenceId != null) {
                dst.excludingRecurrenceId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.excludingRecurrenceId) {
                    dst.excludingRecurrenceId.add(positiveIntType2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentRecurrenceTemplateComponent)) {
                return false;
            }
            AppointmentRecurrenceTemplateComponent o = (AppointmentRecurrenceTemplateComponent)other_;
            return AppointmentRecurrenceTemplateComponent.compareDeep(this.timezone, o.timezone, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.recurrenceType, o.recurrenceType, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.lastOccurrenceDate, o.lastOccurrenceDate, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.occurrenceCount, o.occurrenceCount, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.occurrenceDate, o.occurrenceDate, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.weeklyTemplate, o.weeklyTemplate, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.monthlyTemplate, o.monthlyTemplate, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.yearlyTemplate, o.yearlyTemplate, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.excludingDate, o.excludingDate, true) && AppointmentRecurrenceTemplateComponent.compareDeep(this.excludingRecurrenceId, o.excludingRecurrenceId, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentRecurrenceTemplateComponent)) {
                return false;
            }
            AppointmentRecurrenceTemplateComponent o = (AppointmentRecurrenceTemplateComponent)other_;
            return AppointmentRecurrenceTemplateComponent.compareValues(this.lastOccurrenceDate, o.lastOccurrenceDate, true) && AppointmentRecurrenceTemplateComponent.compareValues(this.occurrenceCount, o.occurrenceCount, true) && AppointmentRecurrenceTemplateComponent.compareValues(this.occurrenceDate, o.occurrenceDate, true) && AppointmentRecurrenceTemplateComponent.compareValues(this.excludingDate, o.excludingDate, true) && AppointmentRecurrenceTemplateComponent.compareValues(this.excludingRecurrenceId, o.excludingRecurrenceId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.timezone, this.recurrenceType, this.lastOccurrenceDate, this.occurrenceCount, this.occurrenceDate, this.weeklyTemplate, this.monthlyTemplate, this.yearlyTemplate, this.excludingDate, this.excludingRecurrenceId});
        }

        @Override
        public String fhirType() {
            return "Appointment.recurrenceTemplate";
        }
    }

    @Block
    public static class AppointmentParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Role of participant in the appointment", formalDefinition="Role of participant in the appointment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
        protected List<CodeableConcept> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Participation period of the actor", formalDefinition="Participation period of the actor.")
        protected Period period;
        @Child(name="actor", type={Patient.class, Group.class, Practitioner.class, PractitionerRole.class, CareTeam.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The individual, device, location, or service participating in the appointment", formalDefinition="The individual, device, location, or service participating in the appointment.")
        protected Reference actor;
        @Child(name="required", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The participant is required to attend (optional when false)", formalDefinition="Whether this participant is required to be present at the meeting. If false, the participant is optional.")
        protected BooleanType required;
        @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="accepted | declined | tentative | needs-action", formalDefinition="Participation status of the actor.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participationstatus")
        protected Enumeration<ParticipationStatus> status;
        private static final long serialVersionUID = 1537536134L;

        public AppointmentParticipantComponent() {
        }

        public AppointmentParticipantComponent(ParticipationStatus status) {
            this.setStatus(status);
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public AppointmentParticipantComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public AppointmentParticipantComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public AppointmentParticipantComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public AppointmentParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public BooleanType getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new BooleanType();
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public AppointmentParticipantComponent setRequiredElement(BooleanType value) {
            this.required = value;
            return this;
        }

        public boolean getRequired() {
            return this.required == null || this.required.isEmpty() ? false : (Boolean)this.required.getValue();
        }

        public AppointmentParticipantComponent setRequired(boolean value) {
            if (this.required == null) {
                this.required = new BooleanType();
            }
            this.required.setValue((Object)value);
            return this;
        }

        public Enumeration<ParticipationStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<ParticipationStatus>(new ParticipationStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public AppointmentParticipantComponent setStatusElement(Enumeration<ParticipationStatus> value) {
            this.status = value;
            return this;
        }

        public ParticipationStatus getStatus() {
            return this.status == null ? null : (ParticipationStatus)((Object)this.status.getValue());
        }

        public AppointmentParticipantComponent setStatus(ParticipationStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<ParticipationStatus>(new ParticipationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("period", "Period", "Participation period of the actor.", 0, 1, this.period));
            children.add(new Property(Appointment.SP_ACTOR, "Reference(Patient|Group|Practitioner|PractitionerRole|CareTeam|RelatedPerson|Device|HealthcareService|Location)", "The individual, device, location, or service participating in the appointment.", 0, 1, this.actor));
            children.add(new Property("required", "boolean", "Whether this participant is required to be present at the meeting. If false, the participant is optional.", 0, 1, this.required));
            children.add(new Property(Appointment.SP_STATUS, "code", "Participation status of the actor.", 0, 1, this.status));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.type);
                }
                case -991726143: {
                    return new Property("period", "Period", "Participation period of the actor.", 0, 1, this.period);
                }
                case 92645877: {
                    return new Property(Appointment.SP_ACTOR, "Reference(Patient|Group|Practitioner|PractitionerRole|CareTeam|RelatedPerson|Device|HealthcareService|Location)", "The individual, device, location, or service participating in the appointment.", 0, 1, this.actor);
                }
                case -393139297: {
                    return new Property("required", "boolean", "Whether this participant is required to be present at the meeting. If false, the participant is optional.", 0, 1, this.required);
                }
                case -892481550: {
                    return new Property(Appointment.SP_STATUS, "code", "Participation status of the actor.", 0, 1, this.status);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.period;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
                case -393139297: {
                    Base[] baseArray;
                    if (this.required == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.required;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.status;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
                case -393139297: {
                    this.required = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -892481550: {
                    value = new ParticipationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.status = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals(Appointment.SP_ACTOR)) {
                this.actor = TypeConvertor.castToReference(value);
            } else if (name.equals("required")) {
                this.required = TypeConvertor.castToBoolean(value);
            } else if (name.equals(Appointment.SP_STATUS)) {
                value = new ParticipationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().remove(value);
            } else if (name.equals("period")) {
                this.period = null;
            } else if (name.equals(Appointment.SP_ACTOR)) {
                this.actor = null;
            } else if (name.equals("required")) {
                this.required = null;
            } else if (name.equals(Appointment.SP_STATUS)) {
                value = new ParticipationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 92645877: {
                    return this.getActor();
                }
                case -393139297: {
                    return this.getRequiredElement();
                }
                case -892481550: {
                    return this.getStatusElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case -393139297: {
                    return new String[]{"boolean"};
                }
                case -892481550: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals(Appointment.SP_ACTOR)) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.participant.required");
            }
            if (name.equals(Appointment.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a singleton property Appointment.participant.status");
            }
            return super.addChild(name);
        }

        @Override
        public AppointmentParticipantComponent copy() {
            AppointmentParticipantComponent dst = new AppointmentParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AppointmentParticipantComponent dst) {
            super.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.period = this.period == null ? null : this.period.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
            dst.required = this.required == null ? null : this.required.copy();
            dst.status = this.status == null ? null : this.status.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentParticipantComponent)) {
                return false;
            }
            AppointmentParticipantComponent o = (AppointmentParticipantComponent)other_;
            return AppointmentParticipantComponent.compareDeep(this.type, o.type, true) && AppointmentParticipantComponent.compareDeep(this.period, o.period, true) && AppointmentParticipantComponent.compareDeep(this.actor, o.actor, true) && AppointmentParticipantComponent.compareDeep(this.required, o.required, true) && AppointmentParticipantComponent.compareDeep(this.status, o.status, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AppointmentParticipantComponent)) {
                return false;
            }
            AppointmentParticipantComponent o = (AppointmentParticipantComponent)other_;
            return AppointmentParticipantComponent.compareValues(this.required, o.required, true) && AppointmentParticipantComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.period, this.actor, this.required, this.status});
        }

        @Override
        public String fhirType() {
            return "Appointment.participant";
        }
    }

    public static class ParticipationStatusEnumFactory
    implements EnumFactory<ParticipationStatus> {
        @Override
        public ParticipationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("accepted".equals(codeString)) {
                return ParticipationStatus.ACCEPTED;
            }
            if ("declined".equals(codeString)) {
                return ParticipationStatus.DECLINED;
            }
            if ("tentative".equals(codeString)) {
                return ParticipationStatus.TENTATIVE;
            }
            if ("needs-action".equals(codeString)) {
                return ParticipationStatus.NEEDSACTION;
            }
            throw new IllegalArgumentException("Unknown ParticipationStatus code '" + codeString + "'");
        }

        public Enumeration<ParticipationStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.NULL, code);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.ACCEPTED, code);
            }
            if ("declined".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.DECLINED, code);
            }
            if ("tentative".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.TENTATIVE, code);
            }
            if ("needs-action".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.NEEDSACTION, code);
            }
            throw new FHIRException("Unknown ParticipationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ParticipationStatus code) {
            if (code == ParticipationStatus.NULL) {
                return null;
            }
            if (code == ParticipationStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == ParticipationStatus.DECLINED) {
                return "declined";
            }
            if (code == ParticipationStatus.TENTATIVE) {
                return "tentative";
            }
            if (code == ParticipationStatus.NEEDSACTION) {
                return "needs-action";
            }
            return "?";
        }

        @Override
        public String toSystem(ParticipationStatus code) {
            return code.getSystem();
        }
    }

    public static enum ParticipationStatus {
        ACCEPTED,
        DECLINED,
        TENTATIVE,
        NEEDSACTION,
        NULL;


        public static ParticipationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("declined".equals(codeString)) {
                return DECLINED;
            }
            if ("tentative".equals(codeString)) {
                return TENTATIVE;
            }
            if ("needs-action".equals(codeString)) {
                return NEEDSACTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ParticipationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACCEPTED: {
                    return "accepted";
                }
                case DECLINED: {
                    return "declined";
                }
                case TENTATIVE: {
                    return "tentative";
                }
                case NEEDSACTION: {
                    return "needs-action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACCEPTED: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case DECLINED: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case TENTATIVE: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case NEEDSACTION: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACCEPTED: {
                    return "The participant has accepted the appointment.";
                }
                case DECLINED: {
                    return "The participant has declined the appointment and will not participate in the appointment.";
                }
                case TENTATIVE: {
                    return "The participant has  tentatively accepted the appointment. This could be automatically created by a system and requires further processing before it can be accepted. There is no commitment that attendance will occur.";
                }
                case NEEDSACTION: {
                    return "The participant needs to indicate if they accept the appointment by changing this status to one of the other statuses.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACCEPTED: {
                    return "Accepted";
                }
                case DECLINED: {
                    return "Declined";
                }
                case TENTATIVE: {
                    return "Tentative";
                }
                case NEEDSACTION: {
                    return "Needs Action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AppointmentStatusEnumFactory
    implements EnumFactory<AppointmentStatus> {
        @Override
        public AppointmentStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return AppointmentStatus.PROPOSED;
            }
            if ("pending".equals(codeString)) {
                return AppointmentStatus.PENDING;
            }
            if ("booked".equals(codeString)) {
                return AppointmentStatus.BOOKED;
            }
            if ("arrived".equals(codeString)) {
                return AppointmentStatus.ARRIVED;
            }
            if ("fulfilled".equals(codeString)) {
                return AppointmentStatus.FULFILLED;
            }
            if ("cancelled".equals(codeString)) {
                return AppointmentStatus.CANCELLED;
            }
            if ("noshow".equals(codeString)) {
                return AppointmentStatus.NOSHOW;
            }
            if ("entered-in-error".equals(codeString)) {
                return AppointmentStatus.ENTEREDINERROR;
            }
            if ("checked-in".equals(codeString)) {
                return AppointmentStatus.CHECKEDIN;
            }
            if ("waitlist".equals(codeString)) {
                return AppointmentStatus.WAITLIST;
            }
            throw new IllegalArgumentException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        public Enumeration<AppointmentStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.NULL, code);
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.PROPOSED, code);
            }
            if ("pending".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.PENDING, code);
            }
            if ("booked".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.BOOKED, code);
            }
            if ("arrived".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.ARRIVED, code);
            }
            if ("fulfilled".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.FULFILLED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.CANCELLED, code);
            }
            if ("noshow".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.NOSHOW, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.ENTEREDINERROR, code);
            }
            if ("checked-in".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.CHECKEDIN, code);
            }
            if ("waitlist".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.WAITLIST, code);
            }
            throw new FHIRException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AppointmentStatus code) {
            if (code == AppointmentStatus.NULL) {
                return null;
            }
            if (code == AppointmentStatus.PROPOSED) {
                return "proposed";
            }
            if (code == AppointmentStatus.PENDING) {
                return "pending";
            }
            if (code == AppointmentStatus.BOOKED) {
                return "booked";
            }
            if (code == AppointmentStatus.ARRIVED) {
                return "arrived";
            }
            if (code == AppointmentStatus.FULFILLED) {
                return "fulfilled";
            }
            if (code == AppointmentStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == AppointmentStatus.NOSHOW) {
                return "noshow";
            }
            if (code == AppointmentStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == AppointmentStatus.CHECKEDIN) {
                return "checked-in";
            }
            if (code == AppointmentStatus.WAITLIST) {
                return "waitlist";
            }
            return "?";
        }

        @Override
        public String toSystem(AppointmentStatus code) {
            return code.getSystem();
        }
    }

    public static enum AppointmentStatus {
        PROPOSED,
        PENDING,
        BOOKED,
        ARRIVED,
        FULFILLED,
        CANCELLED,
        NOSHOW,
        ENTEREDINERROR,
        CHECKEDIN,
        WAITLIST,
        NULL;


        public static AppointmentStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("pending".equals(codeString)) {
                return PENDING;
            }
            if ("booked".equals(codeString)) {
                return BOOKED;
            }
            if ("arrived".equals(codeString)) {
                return ARRIVED;
            }
            if ("fulfilled".equals(codeString)) {
                return FULFILLED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("noshow".equals(codeString)) {
                return NOSHOW;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("checked-in".equals(codeString)) {
                return CHECKEDIN;
            }
            if ("waitlist".equals(codeString)) {
                return WAITLIST;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case PENDING: {
                    return "pending";
                }
                case BOOKED: {
                    return "booked";
                }
                case ARRIVED: {
                    return "arrived";
                }
                case FULFILLED: {
                    return "fulfilled";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case NOSHOW: {
                    return "noshow";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case CHECKEDIN: {
                    return "checked-in";
                }
                case WAITLIST: {
                    return "waitlist";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case PENDING: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case BOOKED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case ARRIVED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case FULFILLED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case NOSHOW: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case CHECKEDIN: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case WAITLIST: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "None of the participant(s) have finalized their acceptance of the appointment request, and the start/end time might not be set yet.";
                }
                case PENDING: {
                    return "Some or all of the participant(s) have not finalized their acceptance of the appointment request.";
                }
                case BOOKED: {
                    return "All participant(s) have been considered and the appointment is confirmed to go ahead at the date/times specified.";
                }
                case ARRIVED: {
                    return "The patient/patients has/have arrived and is/are waiting to be seen.";
                }
                case FULFILLED: {
                    return "The planning stages of the appointment are now complete, the encounter resource will exist and will track further status changes. Note that an encounter may exist before the appointment status is fulfilled for many reasons.";
                }
                case CANCELLED: {
                    return "The appointment has been cancelled.";
                }
                case NOSHOW: {
                    return "Some or all of the participant(s) have not/did not appear for the appointment (usually the patient).";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case CHECKEDIN: {
                    return "When checked in, all pre-encounter administrative work is complete, and the encounter may begin. (where multiple patients are involved, they are all present).";
                }
                case WAITLIST: {
                    return "The appointment has been placed on a waitlist, to be scheduled/confirmed in the future when a slot/service is available.\nA specific time might or might not be pre-allocated.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case PENDING: {
                    return "Pending";
                }
                case BOOKED: {
                    return "Booked";
                }
                case ARRIVED: {
                    return "Arrived";
                }
                case FULFILLED: {
                    return "Fulfilled";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case NOSHOW: {
                    return "No Show";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
                case CHECKEDIN: {
                    return "Checked In";
                }
                case WAITLIST: {
                    return "Waitlisted";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

