/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="BodyStructure", profile="http://hl7.org/fhir/StructureDefinition/BodyStructure")
public class BodyStructure
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Bodystructure identifier", formalDefinition="Identifier for this instance of the anatomical structure.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this record is in active use", formalDefinition="Whether this body site is in active use.")
    protected BooleanType active;
    @Child(name="morphology", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of Structure", formalDefinition="The kind of structure being represented by the body structure at `BodyStructure.location`.  This can define both normal and abnormal morphologies.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodystructure-code")
    protected CodeableConcept morphology;
    @Child(name="includedStructure", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Included anatomic location(s)", formalDefinition="The anatomical location(s) or region(s) of the specimen, lesion, or body structure.")
    protected List<BodyStructureIncludedStructureComponent> includedStructure;
    @Child(name="excludedStructure", type={BodyStructureIncludedStructureComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Excluded anatomic locations(s)", formalDefinition="The anatomical location(s) or region(s) not occupied or represented by the specimen, lesion, or body structure.")
    protected List<BodyStructureIncludedStructureComponent> excludedStructure;
    @Child(name="description", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Text description", formalDefinition="A summary, characterization or explanation of the body structure.")
    protected MarkdownType description;
    @Child(name="image", type={Attachment.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Attached images", formalDefinition="Image or images used to identify a location.")
    protected List<Attachment> image;
    @Child(name="patient", type={Patient.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who this is about", formalDefinition="The person to which the body site belongs.")
    protected Reference patient;
    private static final long serialVersionUID = -1014863022L;
    @SearchParamDefinition(name="excluded_structure", path="BodyStructure.excludedStructure.structure", description="Body site excludedStructure structure", type="token")
    public static final String SP_EXCLUDEDSTRUCTURE = "excluded_structure";
    public static final TokenClientParam EXCLUDEDSTRUCTURE = new TokenClientParam("excluded_structure");
    @SearchParamDefinition(name="included_structure", path="BodyStructure.includedStructure.structure", description="Body site includedStructure structure", type="token")
    public static final String SP_INCLUDEDSTRUCTURE = "included_structure";
    public static final TokenClientParam INCLUDEDSTRUCTURE = new TokenClientParam("included_structure");
    @SearchParamDefinition(name="morphology", path="BodyStructure.morphology", description="Kind of Structure", type="token")
    public static final String SP_MORPHOLOGY = "morphology";
    public static final TokenClientParam MORPHOLOGY = new TokenClientParam("morphology");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("BodyStructure:patient").toLocked();

    public BodyStructure() {
    }

    public BodyStructure(BodyStructureIncludedStructureComponent includedStructure, Reference patient) {
        this.addIncludedStructure(includedStructure);
        this.setPatient(patient);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public BodyStructure setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public BodyStructure addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public BodyStructure setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public BodyStructure setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public CodeableConcept getMorphology() {
        if (this.morphology == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.morphology");
            }
            if (Configuration.doAutoCreate()) {
                this.morphology = new CodeableConcept();
            }
        }
        return this.morphology;
    }

    public boolean hasMorphology() {
        return this.morphology != null && !this.morphology.isEmpty();
    }

    public BodyStructure setMorphology(CodeableConcept value) {
        this.morphology = value;
        return this;
    }

    public List<BodyStructureIncludedStructureComponent> getIncludedStructure() {
        if (this.includedStructure == null) {
            this.includedStructure = new ArrayList<BodyStructureIncludedStructureComponent>();
        }
        return this.includedStructure;
    }

    public BodyStructure setIncludedStructure(List<BodyStructureIncludedStructureComponent> theIncludedStructure) {
        this.includedStructure = theIncludedStructure;
        return this;
    }

    public boolean hasIncludedStructure() {
        if (this.includedStructure == null) {
            return false;
        }
        for (BodyStructureIncludedStructureComponent item : this.includedStructure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BodyStructureIncludedStructureComponent addIncludedStructure() {
        BodyStructureIncludedStructureComponent t = new BodyStructureIncludedStructureComponent();
        if (this.includedStructure == null) {
            this.includedStructure = new ArrayList<BodyStructureIncludedStructureComponent>();
        }
        this.includedStructure.add(t);
        return t;
    }

    public BodyStructure addIncludedStructure(BodyStructureIncludedStructureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.includedStructure == null) {
            this.includedStructure = new ArrayList<BodyStructureIncludedStructureComponent>();
        }
        this.includedStructure.add(t);
        return this;
    }

    public BodyStructureIncludedStructureComponent getIncludedStructureFirstRep() {
        if (this.getIncludedStructure().isEmpty()) {
            this.addIncludedStructure();
        }
        return this.getIncludedStructure().get(0);
    }

    public List<BodyStructureIncludedStructureComponent> getExcludedStructure() {
        if (this.excludedStructure == null) {
            this.excludedStructure = new ArrayList<BodyStructureIncludedStructureComponent>();
        }
        return this.excludedStructure;
    }

    public BodyStructure setExcludedStructure(List<BodyStructureIncludedStructureComponent> theExcludedStructure) {
        this.excludedStructure = theExcludedStructure;
        return this;
    }

    public boolean hasExcludedStructure() {
        if (this.excludedStructure == null) {
            return false;
        }
        for (BodyStructureIncludedStructureComponent item : this.excludedStructure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BodyStructureIncludedStructureComponent addExcludedStructure() {
        BodyStructureIncludedStructureComponent t = new BodyStructureIncludedStructureComponent();
        if (this.excludedStructure == null) {
            this.excludedStructure = new ArrayList<BodyStructureIncludedStructureComponent>();
        }
        this.excludedStructure.add(t);
        return t;
    }

    public BodyStructure addExcludedStructure(BodyStructureIncludedStructureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.excludedStructure == null) {
            this.excludedStructure = new ArrayList<BodyStructureIncludedStructureComponent>();
        }
        this.excludedStructure.add(t);
        return this;
    }

    public BodyStructureIncludedStructureComponent getExcludedStructureFirstRep() {
        if (this.getExcludedStructure().isEmpty()) {
            this.addExcludedStructure();
        }
        return this.getExcludedStructure().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public BodyStructure setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public BodyStructure setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Attachment> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        return this.image;
    }

    public BodyStructure setImage(List<Attachment> theImage) {
        this.image = theImage;
        return this;
    }

    public boolean hasImage() {
        if (this.image == null) {
            return false;
        }
        for (Attachment item : this.image) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addImage() {
        Attachment t = new Attachment();
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return t;
    }

    public BodyStructure addImage(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return this;
    }

    public Attachment getImageFirstRep() {
        if (this.getImage().isEmpty()) {
            this.addImage();
        }
        return this.getImage().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BodyStructure.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public BodyStructure setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for this instance of the anatomical structure.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("active", "boolean", "Whether this body site is in active use.", 0, 1, this.active));
        children.add(new Property(SP_MORPHOLOGY, "CodeableConcept", "The kind of structure being represented by the body structure at `BodyStructure.location`.  This can define both normal and abnormal morphologies.", 0, 1, this.morphology));
        children.add(new Property("includedStructure", "", "The anatomical location(s) or region(s) of the specimen, lesion, or body structure.", 0, Integer.MAX_VALUE, this.includedStructure));
        children.add(new Property("excludedStructure", "@BodyStructure.includedStructure", "The anatomical location(s) or region(s) not occupied or represented by the specimen, lesion, or body structure.", 0, Integer.MAX_VALUE, this.excludedStructure));
        children.add(new Property("description", "markdown", "A summary, characterization or explanation of the body structure.", 0, 1, this.description));
        children.add(new Property("image", "Attachment", "Image or images used to identify a location.", 0, Integer.MAX_VALUE, this.image));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The person to which the body site belongs.", 0, 1, this.patient));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for this instance of the anatomical structure.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property("active", "boolean", "Whether this body site is in active use.", 0, 1, this.active);
            }
            case 1807231644: {
                return new Property(SP_MORPHOLOGY, "CodeableConcept", "The kind of structure being represented by the body structure at `BodyStructure.location`.  This can define both normal and abnormal morphologies.", 0, 1, this.morphology);
            }
            case -1174069225: {
                return new Property("includedStructure", "", "The anatomical location(s) or region(s) of the specimen, lesion, or body structure.", 0, Integer.MAX_VALUE, this.includedStructure);
            }
            case 1192252105: {
                return new Property("excludedStructure", "@BodyStructure.includedStructure", "The anatomical location(s) or region(s) not occupied or represented by the specimen, lesion, or body structure.", 0, Integer.MAX_VALUE, this.excludedStructure);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A summary, characterization or explanation of the body structure.", 0, 1, this.description);
            }
            case 100313435: {
                return new Property("image", "Attachment", "Image or images used to identify a location.", 0, Integer.MAX_VALUE, this.image);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The person to which the body site belongs.", 0, 1, this.patient);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 1807231644: {
                Base[] baseArray;
                if (this.morphology == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.morphology;
                }
                return baseArray;
            }
            case -1174069225: {
                return this.includedStructure == null ? new Base[]{} : this.includedStructure.toArray(new Base[this.includedStructure.size()]);
            }
            case 1192252105: {
                return this.excludedStructure == null ? new Base[]{} : this.excludedStructure.toArray(new Base[this.excludedStructure.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
            case 100313435: {
                return this.image == null ? new Base[]{} : this.image.toArray(new Base[this.image.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.patient;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 1807231644: {
                this.morphology = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1174069225: {
                this.getIncludedStructure().add((BodyStructureIncludedStructureComponent)value);
                return value;
            }
            case 1192252105: {
                this.getExcludedStructure().add((BodyStructureIncludedStructureComponent)value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 100313435: {
                this.getImage().add(TypeConvertor.castToAttachment(value));
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("active")) {
            this.active = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_MORPHOLOGY)) {
            this.morphology = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("includedStructure")) {
            this.getIncludedStructure().add((BodyStructureIncludedStructureComponent)value);
        } else if (name.equals("excludedStructure")) {
            this.getExcludedStructure().add((BodyStructureIncludedStructureComponent)value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("image")) {
            this.getImage().add(TypeConvertor.castToAttachment(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("active")) {
            this.active = null;
        } else if (name.equals(SP_MORPHOLOGY)) {
            this.morphology = null;
        } else if (name.equals("includedStructure")) {
            this.getIncludedStructure().remove((BodyStructureIncludedStructureComponent)value);
        } else if (name.equals("excludedStructure")) {
            this.getExcludedStructure().remove((BodyStructureIncludedStructureComponent)value);
        } else if (name.equals("description")) {
            this.description = null;
        } else if (name.equals("image")) {
            this.getImage().remove(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 1807231644: {
                return this.getMorphology();
            }
            case -1174069225: {
                return this.addIncludedStructure();
            }
            case 1192252105: {
                return this.addExcludedStructure();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 100313435: {
                return this.addImage();
            }
            case -791418107: {
                return this.getPatient();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 1807231644: {
                return new String[]{"CodeableConcept"};
            }
            case -1174069225: {
                return new String[0];
            }
            case 1192252105: {
                return new String[]{"@BodyStructure.includedStructure"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case 100313435: {
                return new String[]{"Attachment"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("active")) {
            throw new FHIRException("Cannot call addChild on a singleton property BodyStructure.active");
        }
        if (name.equals(SP_MORPHOLOGY)) {
            this.morphology = new CodeableConcept();
            return this.morphology;
        }
        if (name.equals("includedStructure")) {
            return this.addIncludedStructure();
        }
        if (name.equals("excludedStructure")) {
            return this.addExcludedStructure();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property BodyStructure.description");
        }
        if (name.equals("image")) {
            return this.addImage();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BodyStructure";
    }

    @Override
    public BodyStructure copy() {
        BodyStructure dst = new BodyStructure();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(BodyStructure dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        CodeableConcept codeableConcept = dst.morphology = this.morphology == null ? null : this.morphology.copy();
        if (this.includedStructure != null) {
            dst.includedStructure = new ArrayList<BodyStructureIncludedStructureComponent>();
            for (BodyStructureIncludedStructureComponent bodyStructureIncludedStructureComponent : this.includedStructure) {
                dst.includedStructure.add(bodyStructureIncludedStructureComponent.copy());
            }
        }
        if (this.excludedStructure != null) {
            dst.excludedStructure = new ArrayList<BodyStructureIncludedStructureComponent>();
            for (BodyStructureIncludedStructureComponent bodyStructureIncludedStructureComponent : this.excludedStructure) {
                dst.excludedStructure.add(bodyStructureIncludedStructureComponent.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.image != null) {
            dst.image = new ArrayList<Attachment>();
            for (Attachment attachment : this.image) {
                dst.image.add(attachment.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
    }

    protected BodyStructure typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof BodyStructure)) {
            return false;
        }
        BodyStructure o = (BodyStructure)other_;
        return BodyStructure.compareDeep(this.identifier, o.identifier, true) && BodyStructure.compareDeep(this.active, o.active, true) && BodyStructure.compareDeep(this.morphology, o.morphology, true) && BodyStructure.compareDeep(this.includedStructure, o.includedStructure, true) && BodyStructure.compareDeep(this.excludedStructure, o.excludedStructure, true) && BodyStructure.compareDeep(this.description, o.description, true) && BodyStructure.compareDeep(this.image, o.image, true) && BodyStructure.compareDeep(this.patient, o.patient, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof BodyStructure)) {
            return false;
        }
        BodyStructure o = (BodyStructure)other_;
        return BodyStructure.compareValues(this.active, o.active, true) && BodyStructure.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.morphology, this.includedStructure, this.excludedStructure, this.description, this.image, this.patient});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.BodyStructure;
    }

    @Block
    public static class BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="device", type={CodeableReference.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Measurement device", formalDefinition="An instrument, tool, analyzer, etc. used in the measurement.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-type")
        protected List<CodeableReference> device;
        @Child(name="value", type={Quantity.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Measured distance from body landmark", formalDefinition="The measured distance (e.g., in cm) from a body landmark.")
        protected List<Quantity> value;
        private static final long serialVersionUID = 1883586968L;

        public List<CodeableReference> getDevice() {
            if (this.device == null) {
                this.device = new ArrayList<CodeableReference>();
            }
            return this.device;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent setDevice(List<CodeableReference> theDevice) {
            this.device = theDevice;
            return this;
        }

        public boolean hasDevice() {
            if (this.device == null) {
                return false;
            }
            for (CodeableReference item : this.device) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addDevice() {
            CodeableReference t = new CodeableReference();
            if (this.device == null) {
                this.device = new ArrayList<CodeableReference>();
            }
            this.device.add(t);
            return t;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent addDevice(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.device == null) {
                this.device = new ArrayList<CodeableReference>();
            }
            this.device.add(t);
            return this;
        }

        public CodeableReference getDeviceFirstRep() {
            if (this.getDevice().isEmpty()) {
                this.addDevice();
            }
            return this.getDevice().get(0);
        }

        public List<Quantity> getValue() {
            if (this.value == null) {
                this.value = new ArrayList<Quantity>();
            }
            return this.value;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent setValue(List<Quantity> theValue) {
            this.value = theValue;
            return this;
        }

        public boolean hasValue() {
            if (this.value == null) {
                return false;
            }
            for (Quantity item : this.value) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addValue() {
            Quantity t = new Quantity();
            if (this.value == null) {
                this.value = new ArrayList<Quantity>();
            }
            this.value.add(t);
            return t;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent addValue(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.value == null) {
                this.value = new ArrayList<Quantity>();
            }
            this.value.add(t);
            return this;
        }

        public Quantity getValueFirstRep() {
            if (this.getValue().isEmpty()) {
                this.addValue();
            }
            return this.getValue().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("device", "CodeableReference(Device)", "An instrument, tool, analyzer, etc. used in the measurement.", 0, Integer.MAX_VALUE, this.device));
            children.add(new Property("value", "Quantity", "The measured distance (e.g., in cm) from a body landmark.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1335157162: {
                    return new Property("device", "CodeableReference(Device)", "An instrument, tool, analyzer, etc. used in the measurement.", 0, Integer.MAX_VALUE, this.device);
                }
                case 111972721: {
                    return new Property("value", "Quantity", "The measured distance (e.g., in cm) from a body landmark.", 0, Integer.MAX_VALUE, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
                }
                case 111972721: {
                    return this.value == null ? new Base[]{} : this.value.toArray(new Base[this.value.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    this.getDevice().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case 111972721: {
                    this.getValue().add(TypeConvertor.castToQuantity(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("device")) {
                this.getDevice().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("value")) {
                this.getValue().add(TypeConvertor.castToQuantity(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("device")) {
                this.getDevice().remove(value);
            } else if (name.equals("value")) {
                this.getValue().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    return this.addDevice();
                }
                case 111972721: {
                    return this.addValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    return new String[]{"CodeableReference"};
                }
                case 111972721: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("device")) {
                return this.addDevice();
            }
            if (name.equals("value")) {
                return this.addValue();
            }
            return super.addChild(name);
        }

        @Override
        public BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent copy() {
            BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent dst = new BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent dst) {
            super.copyValues(dst);
            if (this.device != null) {
                dst.device = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.device) {
                    dst.device.add(codeableReference.copy());
                }
            }
            if (this.value != null) {
                dst.value = new ArrayList<Quantity>();
                for (Quantity quantity : this.value) {
                    dst.value.add(quantity.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent)) {
                return false;
            }
            BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent o = (BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent)other_;
            return BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent.compareDeep(this.device, o.device, true) && BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent)) {
                return false;
            }
            BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent o = (BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.device, this.value});
        }

        @Override
        public String fhirType() {
            return "BodyStructure.includedStructure.bodyLandmarkOrientation.distanceFromLandmark";
        }
    }

    @Block
    public static class BodyStructureIncludedStructureBodyLandmarkOrientationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="landmarkDescription", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Body ]andmark description", formalDefinition="A description of a landmark on the body used as a reference to locate something else.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
        protected List<CodeableConcept> landmarkDescription;
        @Child(name="clockFacePosition", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Clockface orientation", formalDefinition="An description of the direction away from a landmark something is located based on a radial clock dial.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodystructure-bodylandmarkorientation-clockface-position")
        protected List<CodeableConcept> clockFacePosition;
        @Child(name="distanceFromLandmark", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Landmark relative location", formalDefinition="The distance in centimeters a certain observation is made from a body landmark.")
        protected List<BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent> distanceFromLandmark;
        @Child(name="surfaceOrientation", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Relative landmark surface orientation", formalDefinition="The surface area a body location is in relation to a landmark.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodystructure-relative-location")
        protected List<CodeableConcept> surfaceOrientation;
        private static final long serialVersionUID = -365770277L;

        public List<CodeableConcept> getLandmarkDescription() {
            if (this.landmarkDescription == null) {
                this.landmarkDescription = new ArrayList<CodeableConcept>();
            }
            return this.landmarkDescription;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent setLandmarkDescription(List<CodeableConcept> theLandmarkDescription) {
            this.landmarkDescription = theLandmarkDescription;
            return this;
        }

        public boolean hasLandmarkDescription() {
            if (this.landmarkDescription == null) {
                return false;
            }
            for (CodeableConcept item : this.landmarkDescription) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addLandmarkDescription() {
            CodeableConcept t = new CodeableConcept();
            if (this.landmarkDescription == null) {
                this.landmarkDescription = new ArrayList<CodeableConcept>();
            }
            this.landmarkDescription.add(t);
            return t;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent addLandmarkDescription(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.landmarkDescription == null) {
                this.landmarkDescription = new ArrayList<CodeableConcept>();
            }
            this.landmarkDescription.add(t);
            return this;
        }

        public CodeableConcept getLandmarkDescriptionFirstRep() {
            if (this.getLandmarkDescription().isEmpty()) {
                this.addLandmarkDescription();
            }
            return this.getLandmarkDescription().get(0);
        }

        public List<CodeableConcept> getClockFacePosition() {
            if (this.clockFacePosition == null) {
                this.clockFacePosition = new ArrayList<CodeableConcept>();
            }
            return this.clockFacePosition;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent setClockFacePosition(List<CodeableConcept> theClockFacePosition) {
            this.clockFacePosition = theClockFacePosition;
            return this;
        }

        public boolean hasClockFacePosition() {
            if (this.clockFacePosition == null) {
                return false;
            }
            for (CodeableConcept item : this.clockFacePosition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClockFacePosition() {
            CodeableConcept t = new CodeableConcept();
            if (this.clockFacePosition == null) {
                this.clockFacePosition = new ArrayList<CodeableConcept>();
            }
            this.clockFacePosition.add(t);
            return t;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent addClockFacePosition(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.clockFacePosition == null) {
                this.clockFacePosition = new ArrayList<CodeableConcept>();
            }
            this.clockFacePosition.add(t);
            return this;
        }

        public CodeableConcept getClockFacePositionFirstRep() {
            if (this.getClockFacePosition().isEmpty()) {
                this.addClockFacePosition();
            }
            return this.getClockFacePosition().get(0);
        }

        public List<BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent> getDistanceFromLandmark() {
            if (this.distanceFromLandmark == null) {
                this.distanceFromLandmark = new ArrayList<BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent>();
            }
            return this.distanceFromLandmark;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent setDistanceFromLandmark(List<BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent> theDistanceFromLandmark) {
            this.distanceFromLandmark = theDistanceFromLandmark;
            return this;
        }

        public boolean hasDistanceFromLandmark() {
            if (this.distanceFromLandmark == null) {
                return false;
            }
            for (BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent item : this.distanceFromLandmark) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent addDistanceFromLandmark() {
            BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent t = new BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent();
            if (this.distanceFromLandmark == null) {
                this.distanceFromLandmark = new ArrayList<BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent>();
            }
            this.distanceFromLandmark.add(t);
            return t;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent addDistanceFromLandmark(BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent t) {
            if (t == null) {
                return this;
            }
            if (this.distanceFromLandmark == null) {
                this.distanceFromLandmark = new ArrayList<BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent>();
            }
            this.distanceFromLandmark.add(t);
            return this;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent getDistanceFromLandmarkFirstRep() {
            if (this.getDistanceFromLandmark().isEmpty()) {
                this.addDistanceFromLandmark();
            }
            return this.getDistanceFromLandmark().get(0);
        }

        public List<CodeableConcept> getSurfaceOrientation() {
            if (this.surfaceOrientation == null) {
                this.surfaceOrientation = new ArrayList<CodeableConcept>();
            }
            return this.surfaceOrientation;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent setSurfaceOrientation(List<CodeableConcept> theSurfaceOrientation) {
            this.surfaceOrientation = theSurfaceOrientation;
            return this;
        }

        public boolean hasSurfaceOrientation() {
            if (this.surfaceOrientation == null) {
                return false;
            }
            for (CodeableConcept item : this.surfaceOrientation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSurfaceOrientation() {
            CodeableConcept t = new CodeableConcept();
            if (this.surfaceOrientation == null) {
                this.surfaceOrientation = new ArrayList<CodeableConcept>();
            }
            this.surfaceOrientation.add(t);
            return t;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent addSurfaceOrientation(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.surfaceOrientation == null) {
                this.surfaceOrientation = new ArrayList<CodeableConcept>();
            }
            this.surfaceOrientation.add(t);
            return this;
        }

        public CodeableConcept getSurfaceOrientationFirstRep() {
            if (this.getSurfaceOrientation().isEmpty()) {
                this.addSurfaceOrientation();
            }
            return this.getSurfaceOrientation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("landmarkDescription", "CodeableConcept", "A description of a landmark on the body used as a reference to locate something else.", 0, Integer.MAX_VALUE, this.landmarkDescription));
            children.add(new Property("clockFacePosition", "CodeableConcept", "An description of the direction away from a landmark something is located based on a radial clock dial.", 0, Integer.MAX_VALUE, this.clockFacePosition));
            children.add(new Property("distanceFromLandmark", "", "The distance in centimeters a certain observation is made from a body landmark.", 0, Integer.MAX_VALUE, this.distanceFromLandmark));
            children.add(new Property("surfaceOrientation", "CodeableConcept", "The surface area a body location is in relation to a landmark.", 0, Integer.MAX_VALUE, this.surfaceOrientation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1187892644: {
                    return new Property("landmarkDescription", "CodeableConcept", "A description of a landmark on the body used as a reference to locate something else.", 0, Integer.MAX_VALUE, this.landmarkDescription);
                }
                case 133476820: {
                    return new Property("clockFacePosition", "CodeableConcept", "An description of the direction away from a landmark something is located based on a radial clock dial.", 0, Integer.MAX_VALUE, this.clockFacePosition);
                }
                case 1350792599: {
                    return new Property("distanceFromLandmark", "", "The distance in centimeters a certain observation is made from a body landmark.", 0, Integer.MAX_VALUE, this.distanceFromLandmark);
                }
                case 1408496355: {
                    return new Property("surfaceOrientation", "CodeableConcept", "The surface area a body location is in relation to a landmark.", 0, Integer.MAX_VALUE, this.surfaceOrientation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1187892644: {
                    return this.landmarkDescription == null ? new Base[]{} : this.landmarkDescription.toArray(new Base[this.landmarkDescription.size()]);
                }
                case 133476820: {
                    return this.clockFacePosition == null ? new Base[]{} : this.clockFacePosition.toArray(new Base[this.clockFacePosition.size()]);
                }
                case 1350792599: {
                    return this.distanceFromLandmark == null ? new Base[]{} : this.distanceFromLandmark.toArray(new Base[this.distanceFromLandmark.size()]);
                }
                case 1408496355: {
                    return this.surfaceOrientation == null ? new Base[]{} : this.surfaceOrientation.toArray(new Base[this.surfaceOrientation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1187892644: {
                    this.getLandmarkDescription().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 133476820: {
                    this.getClockFacePosition().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1350792599: {
                    this.getDistanceFromLandmark().add((BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent)value);
                    return value;
                }
                case 1408496355: {
                    this.getSurfaceOrientation().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("landmarkDescription")) {
                this.getLandmarkDescription().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("clockFacePosition")) {
                this.getClockFacePosition().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("distanceFromLandmark")) {
                this.getDistanceFromLandmark().add((BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent)value);
            } else if (name.equals("surfaceOrientation")) {
                this.getSurfaceOrientation().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("landmarkDescription")) {
                this.getLandmarkDescription().remove(value);
            } else if (name.equals("clockFacePosition")) {
                this.getClockFacePosition().remove(value);
            } else if (name.equals("distanceFromLandmark")) {
                this.getDistanceFromLandmark().remove((BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent)value);
            } else if (name.equals("surfaceOrientation")) {
                this.getSurfaceOrientation().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1187892644: {
                    return this.addLandmarkDescription();
                }
                case 133476820: {
                    return this.addClockFacePosition();
                }
                case 1350792599: {
                    return this.addDistanceFromLandmark();
                }
                case 1408496355: {
                    return this.addSurfaceOrientation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1187892644: {
                    return new String[]{"CodeableConcept"};
                }
                case 133476820: {
                    return new String[]{"CodeableConcept"};
                }
                case 1350792599: {
                    return new String[0];
                }
                case 1408496355: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("landmarkDescription")) {
                return this.addLandmarkDescription();
            }
            if (name.equals("clockFacePosition")) {
                return this.addClockFacePosition();
            }
            if (name.equals("distanceFromLandmark")) {
                return this.addDistanceFromLandmark();
            }
            if (name.equals("surfaceOrientation")) {
                return this.addSurfaceOrientation();
            }
            return super.addChild(name);
        }

        @Override
        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent copy() {
            BodyStructureIncludedStructureBodyLandmarkOrientationComponent dst = new BodyStructureIncludedStructureBodyLandmarkOrientationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BodyStructureIncludedStructureBodyLandmarkOrientationComponent dst) {
            super.copyValues(dst);
            if (this.landmarkDescription != null) {
                dst.landmarkDescription = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.landmarkDescription) {
                    dst.landmarkDescription.add(codeableConcept.copy());
                }
            }
            if (this.clockFacePosition != null) {
                dst.clockFacePosition = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.clockFacePosition) {
                    dst.clockFacePosition.add(codeableConcept.copy());
                }
            }
            if (this.distanceFromLandmark != null) {
                dst.distanceFromLandmark = new ArrayList<BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent>();
                for (BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent bodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent : this.distanceFromLandmark) {
                    dst.distanceFromLandmark.add(bodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent.copy());
                }
            }
            if (this.surfaceOrientation != null) {
                dst.surfaceOrientation = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.surfaceOrientation) {
                    dst.surfaceOrientation.add(codeableConcept.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BodyStructureIncludedStructureBodyLandmarkOrientationComponent)) {
                return false;
            }
            BodyStructureIncludedStructureBodyLandmarkOrientationComponent o = (BodyStructureIncludedStructureBodyLandmarkOrientationComponent)other_;
            return BodyStructureIncludedStructureBodyLandmarkOrientationComponent.compareDeep(this.landmarkDescription, o.landmarkDescription, true) && BodyStructureIncludedStructureBodyLandmarkOrientationComponent.compareDeep(this.clockFacePosition, o.clockFacePosition, true) && BodyStructureIncludedStructureBodyLandmarkOrientationComponent.compareDeep(this.distanceFromLandmark, o.distanceFromLandmark, true) && BodyStructureIncludedStructureBodyLandmarkOrientationComponent.compareDeep(this.surfaceOrientation, o.surfaceOrientation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BodyStructureIncludedStructureBodyLandmarkOrientationComponent)) {
                return false;
            }
            BodyStructureIncludedStructureBodyLandmarkOrientationComponent o = (BodyStructureIncludedStructureBodyLandmarkOrientationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.landmarkDescription, this.clockFacePosition, this.distanceFromLandmark, this.surfaceOrientation});
        }

        @Override
        public String fhirType() {
            return "BodyStructure.includedStructure.bodyLandmarkOrientation";
        }
    }

    @Block
    public static class BodyStructureIncludedStructureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="structure", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code that represents the included structure", formalDefinition="Code that represents the included structure.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
        protected CodeableConcept structure;
        @Child(name="laterality", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that represents the included structure laterality", formalDefinition="Code that represents the included structure laterality.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodystructure-relative-location")
        protected CodeableConcept laterality;
        @Child(name="bodyLandmarkOrientation", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Landmark relative location", formalDefinition="Body locations in relation to a specific body landmark (tatoo, scar, other body structure).")
        protected List<BodyStructureIncludedStructureBodyLandmarkOrientationComponent> bodyLandmarkOrientation;
        @Child(name="spatialReference", type={ImagingSelection.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Cartesian reference for structure", formalDefinition="XY or XYZ-coordinate orientation for structure.")
        protected List<Reference> spatialReference;
        @Child(name="qualifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Code that represents the included structure qualifier", formalDefinition="Code that represents the included structure qualifier.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodystructure-relative-location")
        protected List<CodeableConcept> qualifier;
        private static final long serialVersionUID = -1341852782L;

        public BodyStructureIncludedStructureComponent() {
        }

        public BodyStructureIncludedStructureComponent(CodeableConcept structure) {
            this.setStructure(structure);
        }

        public CodeableConcept getStructure() {
            if (this.structure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BodyStructureIncludedStructureComponent.structure");
                }
                if (Configuration.doAutoCreate()) {
                    this.structure = new CodeableConcept();
                }
            }
            return this.structure;
        }

        public boolean hasStructure() {
            return this.structure != null && !this.structure.isEmpty();
        }

        public BodyStructureIncludedStructureComponent setStructure(CodeableConcept value) {
            this.structure = value;
            return this;
        }

        public CodeableConcept getLaterality() {
            if (this.laterality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BodyStructureIncludedStructureComponent.laterality");
                }
                if (Configuration.doAutoCreate()) {
                    this.laterality = new CodeableConcept();
                }
            }
            return this.laterality;
        }

        public boolean hasLaterality() {
            return this.laterality != null && !this.laterality.isEmpty();
        }

        public BodyStructureIncludedStructureComponent setLaterality(CodeableConcept value) {
            this.laterality = value;
            return this;
        }

        public List<BodyStructureIncludedStructureBodyLandmarkOrientationComponent> getBodyLandmarkOrientation() {
            if (this.bodyLandmarkOrientation == null) {
                this.bodyLandmarkOrientation = new ArrayList<BodyStructureIncludedStructureBodyLandmarkOrientationComponent>();
            }
            return this.bodyLandmarkOrientation;
        }

        public BodyStructureIncludedStructureComponent setBodyLandmarkOrientation(List<BodyStructureIncludedStructureBodyLandmarkOrientationComponent> theBodyLandmarkOrientation) {
            this.bodyLandmarkOrientation = theBodyLandmarkOrientation;
            return this;
        }

        public boolean hasBodyLandmarkOrientation() {
            if (this.bodyLandmarkOrientation == null) {
                return false;
            }
            for (BodyStructureIncludedStructureBodyLandmarkOrientationComponent item : this.bodyLandmarkOrientation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent addBodyLandmarkOrientation() {
            BodyStructureIncludedStructureBodyLandmarkOrientationComponent t = new BodyStructureIncludedStructureBodyLandmarkOrientationComponent();
            if (this.bodyLandmarkOrientation == null) {
                this.bodyLandmarkOrientation = new ArrayList<BodyStructureIncludedStructureBodyLandmarkOrientationComponent>();
            }
            this.bodyLandmarkOrientation.add(t);
            return t;
        }

        public BodyStructureIncludedStructureComponent addBodyLandmarkOrientation(BodyStructureIncludedStructureBodyLandmarkOrientationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.bodyLandmarkOrientation == null) {
                this.bodyLandmarkOrientation = new ArrayList<BodyStructureIncludedStructureBodyLandmarkOrientationComponent>();
            }
            this.bodyLandmarkOrientation.add(t);
            return this;
        }

        public BodyStructureIncludedStructureBodyLandmarkOrientationComponent getBodyLandmarkOrientationFirstRep() {
            if (this.getBodyLandmarkOrientation().isEmpty()) {
                this.addBodyLandmarkOrientation();
            }
            return this.getBodyLandmarkOrientation().get(0);
        }

        public List<Reference> getSpatialReference() {
            if (this.spatialReference == null) {
                this.spatialReference = new ArrayList<Reference>();
            }
            return this.spatialReference;
        }

        public BodyStructureIncludedStructureComponent setSpatialReference(List<Reference> theSpatialReference) {
            this.spatialReference = theSpatialReference;
            return this;
        }

        public boolean hasSpatialReference() {
            if (this.spatialReference == null) {
                return false;
            }
            for (Reference item : this.spatialReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSpatialReference() {
            Reference t = new Reference();
            if (this.spatialReference == null) {
                this.spatialReference = new ArrayList<Reference>();
            }
            this.spatialReference.add(t);
            return t;
        }

        public BodyStructureIncludedStructureComponent addSpatialReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.spatialReference == null) {
                this.spatialReference = new ArrayList<Reference>();
            }
            this.spatialReference.add(t);
            return this;
        }

        public Reference getSpatialReferenceFirstRep() {
            if (this.getSpatialReference().isEmpty()) {
                this.addSpatialReference();
            }
            return this.getSpatialReference().get(0);
        }

        public List<CodeableConcept> getQualifier() {
            if (this.qualifier == null) {
                this.qualifier = new ArrayList<CodeableConcept>();
            }
            return this.qualifier;
        }

        public BodyStructureIncludedStructureComponent setQualifier(List<CodeableConcept> theQualifier) {
            this.qualifier = theQualifier;
            return this;
        }

        public boolean hasQualifier() {
            if (this.qualifier == null) {
                return false;
            }
            for (CodeableConcept item : this.qualifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addQualifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.qualifier == null) {
                this.qualifier = new ArrayList<CodeableConcept>();
            }
            this.qualifier.add(t);
            return t;
        }

        public BodyStructureIncludedStructureComponent addQualifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.qualifier == null) {
                this.qualifier = new ArrayList<CodeableConcept>();
            }
            this.qualifier.add(t);
            return this;
        }

        public CodeableConcept getQualifierFirstRep() {
            if (this.getQualifier().isEmpty()) {
                this.addQualifier();
            }
            return this.getQualifier().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("structure", "CodeableConcept", "Code that represents the included structure.", 0, 1, this.structure));
            children.add(new Property("laterality", "CodeableConcept", "Code that represents the included structure laterality.", 0, 1, this.laterality));
            children.add(new Property("bodyLandmarkOrientation", "", "Body locations in relation to a specific body landmark (tatoo, scar, other body structure).", 0, Integer.MAX_VALUE, this.bodyLandmarkOrientation));
            children.add(new Property("spatialReference", "Reference(ImagingSelection)", "XY or XYZ-coordinate orientation for structure.", 0, Integer.MAX_VALUE, this.spatialReference));
            children.add(new Property("qualifier", "CodeableConcept", "Code that represents the included structure qualifier.", 0, Integer.MAX_VALUE, this.qualifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 144518515: {
                    return new Property("structure", "CodeableConcept", "Code that represents the included structure.", 0, 1, this.structure);
                }
                case -170291817: {
                    return new Property("laterality", "CodeableConcept", "Code that represents the included structure laterality.", 0, 1, this.laterality);
                }
                case -994716042: {
                    return new Property("bodyLandmarkOrientation", "", "Body locations in relation to a specific body landmark (tatoo, scar, other body structure).", 0, Integer.MAX_VALUE, this.bodyLandmarkOrientation);
                }
                case 784017063: {
                    return new Property("spatialReference", "Reference(ImagingSelection)", "XY or XYZ-coordinate orientation for structure.", 0, Integer.MAX_VALUE, this.spatialReference);
                }
                case -1247940438: {
                    return new Property("qualifier", "CodeableConcept", "Code that represents the included structure qualifier.", 0, Integer.MAX_VALUE, this.qualifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 144518515: {
                    Base[] baseArray;
                    if (this.structure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.structure;
                    }
                    return baseArray;
                }
                case -170291817: {
                    Base[] baseArray;
                    if (this.laterality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.laterality;
                    }
                    return baseArray;
                }
                case -994716042: {
                    return this.bodyLandmarkOrientation == null ? new Base[]{} : this.bodyLandmarkOrientation.toArray(new Base[this.bodyLandmarkOrientation.size()]);
                }
                case 784017063: {
                    return this.spatialReference == null ? new Base[]{} : this.spatialReference.toArray(new Base[this.spatialReference.size()]);
                }
                case -1247940438: {
                    return this.qualifier == null ? new Base[]{} : this.qualifier.toArray(new Base[this.qualifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 144518515: {
                    this.structure = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -170291817: {
                    this.laterality = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -994716042: {
                    this.getBodyLandmarkOrientation().add((BodyStructureIncludedStructureBodyLandmarkOrientationComponent)value);
                    return value;
                }
                case 784017063: {
                    this.getSpatialReference().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1247940438: {
                    this.getQualifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("structure")) {
                this.structure = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("laterality")) {
                this.laterality = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("bodyLandmarkOrientation")) {
                this.getBodyLandmarkOrientation().add((BodyStructureIncludedStructureBodyLandmarkOrientationComponent)value);
            } else if (name.equals("spatialReference")) {
                this.getSpatialReference().add(TypeConvertor.castToReference(value));
            } else if (name.equals("qualifier")) {
                this.getQualifier().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("structure")) {
                this.structure = null;
            } else if (name.equals("laterality")) {
                this.laterality = null;
            } else if (name.equals("bodyLandmarkOrientation")) {
                this.getBodyLandmarkOrientation().remove((BodyStructureIncludedStructureBodyLandmarkOrientationComponent)value);
            } else if (name.equals("spatialReference")) {
                this.getSpatialReference().remove(value);
            } else if (name.equals("qualifier")) {
                this.getQualifier().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 144518515: {
                    return this.getStructure();
                }
                case -170291817: {
                    return this.getLaterality();
                }
                case -994716042: {
                    return this.addBodyLandmarkOrientation();
                }
                case 784017063: {
                    return this.addSpatialReference();
                }
                case -1247940438: {
                    return this.addQualifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 144518515: {
                    return new String[]{"CodeableConcept"};
                }
                case -170291817: {
                    return new String[]{"CodeableConcept"};
                }
                case -994716042: {
                    return new String[0];
                }
                case 784017063: {
                    return new String[]{"Reference"};
                }
                case -1247940438: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("structure")) {
                this.structure = new CodeableConcept();
                return this.structure;
            }
            if (name.equals("laterality")) {
                this.laterality = new CodeableConcept();
                return this.laterality;
            }
            if (name.equals("bodyLandmarkOrientation")) {
                return this.addBodyLandmarkOrientation();
            }
            if (name.equals("spatialReference")) {
                return this.addSpatialReference();
            }
            if (name.equals("qualifier")) {
                return this.addQualifier();
            }
            return super.addChild(name);
        }

        @Override
        public BodyStructureIncludedStructureComponent copy() {
            BodyStructureIncludedStructureComponent dst = new BodyStructureIncludedStructureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BodyStructureIncludedStructureComponent dst) {
            super.copyValues(dst);
            dst.structure = this.structure == null ? null : this.structure.copy();
            CodeableConcept codeableConcept = dst.laterality = this.laterality == null ? null : this.laterality.copy();
            if (this.bodyLandmarkOrientation != null) {
                dst.bodyLandmarkOrientation = new ArrayList<BodyStructureIncludedStructureBodyLandmarkOrientationComponent>();
                for (BodyStructureIncludedStructureBodyLandmarkOrientationComponent bodyStructureIncludedStructureBodyLandmarkOrientationComponent : this.bodyLandmarkOrientation) {
                    dst.bodyLandmarkOrientation.add(bodyStructureIncludedStructureBodyLandmarkOrientationComponent.copy());
                }
            }
            if (this.spatialReference != null) {
                dst.spatialReference = new ArrayList<Reference>();
                for (Reference reference : this.spatialReference) {
                    dst.spatialReference.add(reference.copy());
                }
            }
            if (this.qualifier != null) {
                dst.qualifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.qualifier) {
                    dst.qualifier.add(codeableConcept2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BodyStructureIncludedStructureComponent)) {
                return false;
            }
            BodyStructureIncludedStructureComponent o = (BodyStructureIncludedStructureComponent)other_;
            return BodyStructureIncludedStructureComponent.compareDeep(this.structure, o.structure, true) && BodyStructureIncludedStructureComponent.compareDeep(this.laterality, o.laterality, true) && BodyStructureIncludedStructureComponent.compareDeep(this.bodyLandmarkOrientation, o.bodyLandmarkOrientation, true) && BodyStructureIncludedStructureComponent.compareDeep(this.spatialReference, o.spatialReference, true) && BodyStructureIncludedStructureComponent.compareDeep(this.qualifier, o.qualifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BodyStructureIncludedStructureComponent)) {
                return false;
            }
            BodyStructureIncludedStructureComponent o = (BodyStructureIncludedStructureComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.structure, this.laterality, this.bodyLandmarkOrientation, this.spatialReference, this.qualifier});
        }

        @Override
        public String fhirType() {
            return "BodyStructure.includedStructure";
        }
    }
}

