/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ClaimResponse", profile="http://hl7.org/fhir/StructureDefinition/ClaimResponse")
public class ClaimResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier for a claim response", formalDefinition="A unique identifier assigned to this claim response.")
    protected List<Identifier> identifier;
    @Child(name="traceNumber", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Number for tracking", formalDefinition="Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.")
    protected List<Identifier> traceNumber;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<Enumerations.FinancialResourceStatusCodes> status;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="More granular claim type", formalDefinition="A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-type")
    protected CodeableConcept type;
    @Child(name="subType", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="More granular claim type", formalDefinition="A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-subtype")
    protected CodeableConcept subType;
    @Child(name="use", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="claim | preauthorization | predetermination", formalDefinition="A code to indicate whether the nature of the request is: Claim - A request to an Insurer to adjudicate the supplied charges for health care goods and services under the identified policy and to pay the determined Benefit amount, if any; Preauthorization - A request to an Insurer to adjudicate the supplied proposed future charges for health care goods and services under the identified policy and to approve the services and provide the expected benefit amounts and potentially to reserve funds to pay the benefits when Claims for the indicated services are later submitted; or, Pre-determination - A request to an Insurer to adjudicate the supplied 'what if' charges for health care goods and services under the identified policy and report back what the Benefit payable would be had the services actually been provided.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-use")
    protected Enumeration<Enumerations.Use> use;
    @Child(name="patient", type={Patient.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The recipient of the products and services", formalDefinition="The party to whom the professional services and/or products have been supplied or are being considered and for whom actual for facast reimbursement is sought.")
    protected Reference patient;
    @Child(name="created", type={DateTimeType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Response creation date", formalDefinition="The date this resource was created.")
    protected DateTimeType created;
    @Child(name="insurer", type={Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Party responsible for reimbursement", formalDefinition="The party responsible for authorization, adjudication and reimbursement.")
    protected Reference insurer;
    @Child(name="requestor", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party responsible for the claim", formalDefinition="The provider which is responsible for the claim, predetermination or preauthorization.")
    protected Reference requestor;
    @Child(name="request", type={Claim.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Id of resource triggering adjudication", formalDefinition="Original request resource reference.")
    protected Reference request;
    @Child(name="outcome", type={CodeType.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="queued | complete | error | partial", formalDefinition="The outcome of the claim, predetermination, or preauthorization processing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-outcome")
    protected Enumeration<Enumerations.ClaimProcessingCodes> outcome;
    @Child(name="decision", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Result of the adjudication", formalDefinition="The result of the claim, predetermination, or preauthorization adjudication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-decision")
    protected CodeableConcept decision;
    @Child(name="disposition", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A human readable description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="preAuthRef", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Preauthorization reference", formalDefinition="Reference from the Insurer which is used in later communications which refers to this adjudication.")
    protected StringType preAuthRef;
    @Child(name="preAuthPeriod", type={Period.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Preauthorization reference effective period", formalDefinition="The time frame during which this authorization is effective.")
    protected Period preAuthPeriod;
    @Child(name="event", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Event information", formalDefinition="Information code for an event with a corresponding date or period.")
    protected List<ClaimResponseEventComponent> event;
    @Child(name="payeeType", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Party to be paid any benefits payable", formalDefinition="Type of Party to be reimbursed: subscriber, provider, other.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payeetype")
    protected CodeableConcept payeeType;
    @Child(name="encounter", type={Encounter.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Encounters associated with the listed treatments", formalDefinition="Healthcare encounters related to this claim.")
    protected List<Reference> encounter;
    @Child(name="diagnosisRelatedGroup", type={CodeableConcept.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Package billing code", formalDefinition="A package billing code or bundle code used to group products and services to a particular health condition (such as heart attack) which is based on a predetermined grouping code system.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosisrelatedgroup")
    protected CodeableConcept diagnosisRelatedGroup;
    @Child(name="item", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Adjudication for claim line items", formalDefinition="A claim line. Either a simple (a product or service) or a 'group' of details which can also be a simple items or groups of sub-details.")
    protected List<ItemComponent> item;
    @Child(name="addItem", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer added line items", formalDefinition="The first-tier service adjudications for payor added product or service lines.")
    protected List<AddedItemComponent> addItem;
    @Child(name="adjudication", type={AdjudicationComponent.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Header-level adjudication", formalDefinition="The adjudication results which are presented at the header level rather than at the line-item or add-item levels.")
    protected List<AdjudicationComponent> adjudication;
    @Child(name="total", type={}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Adjudication totals", formalDefinition="Categorized monetary totals for the adjudication.")
    protected List<TotalComponent> total;
    @Child(name="payment", type={}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment Details", formalDefinition="Payment details for the adjudication of the claim.")
    protected PaymentComponent payment;
    @Child(name="fundsReserve", type={CodeableConcept.class}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Funds reserved status", formalDefinition="A code, used only on a response to a preauthorization, to indicate whether the benefits payable have been reserved and for whom.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fundsreserve")
    protected CodeableConcept fundsReserve;
    @Child(name="formCode", type={CodeableConcept.class}, order=26, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed form identifier", formalDefinition="A code for the form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept formCode;
    @Child(name="form", type={Attachment.class}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed reference or actual form", formalDefinition="The actual form, by reference or inclusion, for printing the content or an EOB.")
    protected Attachment form;
    @Child(name="processNote", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Note concerning adjudication", formalDefinition="A note that describes or explains adjudication results in a human readable form.")
    protected List<NoteComponent> processNote;
    @Child(name="communicationRequest", type={CommunicationRequest.class}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request for additional information", formalDefinition="Request for additional supporting or authorizing information.")
    protected List<Reference> communicationRequest;
    @Child(name="insurance", type={}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Patient insurance information", formalDefinition="Financial instruments for reimbursement for the health care products and services specified on the claim.")
    protected List<InsuranceComponent> insurance;
    @Child(name="error", type={}, order=31, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing errors", formalDefinition="Errors encountered during the processing of the adjudication.")
    protected List<ErrorComponent> error;
    private static final long serialVersionUID = -1099970187L;
    @SearchParamDefinition(name="created", path="ClaimResponse.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="disposition", path="ClaimResponse.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="insurer", path="ClaimResponse.insurer", description="The organization which generated this resource", type="reference", target={Organization.class})
    public static final String SP_INSURER = "insurer";
    public static final ReferenceClientParam INSURER = new ReferenceClientParam("insurer");
    public static final Include INCLUDE_INSURER = new Include("ClaimResponse:insurer").toLocked();
    @SearchParamDefinition(name="outcome", path="ClaimResponse.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="payment-date", path="ClaimResponse.payment.date", description="The expected payment date", type="date")
    public static final String SP_PAYMENT_DATE = "payment-date";
    public static final DateClientParam PAYMENT_DATE = new DateClientParam("payment-date");
    @SearchParamDefinition(name="request", path="ClaimResponse.request", description="The claim reference", type="reference", target={Claim.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("ClaimResponse:request").toLocked();
    @SearchParamDefinition(name="requestor", path="ClaimResponse.requestor", description="The Provider of the claim", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_REQUESTOR = "requestor";
    public static final ReferenceClientParam REQUESTOR = new ReferenceClientParam("requestor");
    public static final Include INCLUDE_REQUESTOR = new Include("ClaimResponse:requestor").toLocked();
    @SearchParamDefinition(name="status", path="ClaimResponse.status", description="The status of the ClaimResponse", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="use", path="ClaimResponse.use", description="The type of claim", type="token")
    public static final String SP_USE = "use";
    public static final TokenClientParam USE = new TokenClientParam("use");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ClaimResponse:patient").toLocked();

    public ClaimResponse() {
    }

    public ClaimResponse(Enumerations.FinancialResourceStatusCodes status, CodeableConcept type, Enumerations.Use use, Reference patient, Date created, Enumerations.ClaimProcessingCodes outcome) {
        this.setStatus(status);
        this.setType(type);
        this.setUse(use);
        this.setPatient(patient);
        this.setCreated(created);
        this.setOutcome(outcome);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ClaimResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ClaimResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Identifier> getTraceNumber() {
        if (this.traceNumber == null) {
            this.traceNumber = new ArrayList<Identifier>();
        }
        return this.traceNumber;
    }

    public ClaimResponse setTraceNumber(List<Identifier> theTraceNumber) {
        this.traceNumber = theTraceNumber;
        return this;
    }

    public boolean hasTraceNumber() {
        if (this.traceNumber == null) {
            return false;
        }
        for (Identifier item : this.traceNumber) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addTraceNumber() {
        Identifier t = new Identifier();
        if (this.traceNumber == null) {
            this.traceNumber = new ArrayList<Identifier>();
        }
        this.traceNumber.add(t);
        return t;
    }

    public ClaimResponse addTraceNumber(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.traceNumber == null) {
            this.traceNumber = new ArrayList<Identifier>();
        }
        this.traceNumber.add(t);
        return this;
    }

    public Identifier getTraceNumberFirstRep() {
        if (this.getTraceNumber().isEmpty()) {
            this.addTraceNumber();
        }
        return this.getTraceNumber().get(0);
    }

    public Enumeration<Enumerations.FinancialResourceStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ClaimResponse setStatusElement(Enumeration<Enumerations.FinancialResourceStatusCodes> value) {
        this.status = value;
        return this;
    }

    public Enumerations.FinancialResourceStatusCodes getStatus() {
        return this.status == null ? null : (Enumerations.FinancialResourceStatusCodes)((Object)this.status.getValue());
    }

    public ClaimResponse setStatus(Enumerations.FinancialResourceStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ClaimResponse setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getSubType() {
        if (this.subType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.subType");
            }
            if (Configuration.doAutoCreate()) {
                this.subType = new CodeableConcept();
            }
        }
        return this.subType;
    }

    public boolean hasSubType() {
        return this.subType != null && !this.subType.isEmpty();
    }

    public ClaimResponse setSubType(CodeableConcept value) {
        this.subType = value;
        return this;
    }

    public Enumeration<Enumerations.Use> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<Enumerations.Use>(new Enumerations.UseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public ClaimResponse setUseElement(Enumeration<Enumerations.Use> value) {
        this.use = value;
        return this;
    }

    public Enumerations.Use getUse() {
        return this.use == null ? null : (Enumerations.Use)((Object)this.use.getValue());
    }

    public ClaimResponse setUse(Enumerations.Use value) {
        if (this.use == null) {
            this.use = new Enumeration<Enumerations.Use>(new Enumerations.UseEnumFactory());
        }
        this.use.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ClaimResponse setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ClaimResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ClaimResponse setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public ClaimResponse setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Reference getRequestor() {
        if (this.requestor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestor");
            }
            if (Configuration.doAutoCreate()) {
                this.requestor = new Reference();
            }
        }
        return this.requestor;
    }

    public boolean hasRequestor() {
        return this.requestor != null && !this.requestor.isEmpty();
    }

    public ClaimResponse setRequestor(Reference value) {
        this.requestor = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public ClaimResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Enumeration<Enumerations.ClaimProcessingCodes> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public ClaimResponse setOutcomeElement(Enumeration<Enumerations.ClaimProcessingCodes> value) {
        this.outcome = value;
        return this;
    }

    public Enumerations.ClaimProcessingCodes getOutcome() {
        return this.outcome == null ? null : (Enumerations.ClaimProcessingCodes)((Object)this.outcome.getValue());
    }

    public ClaimResponse setOutcome(Enumerations.ClaimProcessingCodes value) {
        if (this.outcome == null) {
            this.outcome = new Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
        }
        this.outcome.setValue((Object)value);
        return this;
    }

    public CodeableConcept getDecision() {
        if (this.decision == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.decision");
            }
            if (Configuration.doAutoCreate()) {
                this.decision = new CodeableConcept();
            }
        }
        return this.decision;
    }

    public boolean hasDecision() {
        return this.decision != null && !this.decision.isEmpty();
    }

    public ClaimResponse setDecision(CodeableConcept value) {
        this.decision = value;
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ClaimResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public ClaimResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public StringType getPreAuthRefElement() {
        if (this.preAuthRef == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.preAuthRef");
            }
            if (Configuration.doAutoCreate()) {
                this.preAuthRef = new StringType();
            }
        }
        return this.preAuthRef;
    }

    public boolean hasPreAuthRefElement() {
        return this.preAuthRef != null && !this.preAuthRef.isEmpty();
    }

    public boolean hasPreAuthRef() {
        return this.preAuthRef != null && !this.preAuthRef.isEmpty();
    }

    public ClaimResponse setPreAuthRefElement(StringType value) {
        this.preAuthRef = value;
        return this;
    }

    public String getPreAuthRef() {
        return this.preAuthRef == null ? null : (String)this.preAuthRef.getValue();
    }

    public ClaimResponse setPreAuthRef(String value) {
        if (Utilities.noString((String)value)) {
            this.preAuthRef = null;
        } else {
            if (this.preAuthRef == null) {
                this.preAuthRef = new StringType();
            }
            this.preAuthRef.setValue(value);
        }
        return this;
    }

    public Period getPreAuthPeriod() {
        if (this.preAuthPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.preAuthPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.preAuthPeriod = new Period();
            }
        }
        return this.preAuthPeriod;
    }

    public boolean hasPreAuthPeriod() {
        return this.preAuthPeriod != null && !this.preAuthPeriod.isEmpty();
    }

    public ClaimResponse setPreAuthPeriod(Period value) {
        this.preAuthPeriod = value;
        return this;
    }

    public List<ClaimResponseEventComponent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<ClaimResponseEventComponent>();
        }
        return this.event;
    }

    public ClaimResponse setEvent(List<ClaimResponseEventComponent> theEvent) {
        this.event = theEvent;
        return this;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (ClaimResponseEventComponent item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClaimResponseEventComponent addEvent() {
        ClaimResponseEventComponent t = new ClaimResponseEventComponent();
        if (this.event == null) {
            this.event = new ArrayList<ClaimResponseEventComponent>();
        }
        this.event.add(t);
        return t;
    }

    public ClaimResponse addEvent(ClaimResponseEventComponent t) {
        if (t == null) {
            return this;
        }
        if (this.event == null) {
            this.event = new ArrayList<ClaimResponseEventComponent>();
        }
        this.event.add(t);
        return this;
    }

    public ClaimResponseEventComponent getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public CodeableConcept getPayeeType() {
        if (this.payeeType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.payeeType");
            }
            if (Configuration.doAutoCreate()) {
                this.payeeType = new CodeableConcept();
            }
        }
        return this.payeeType;
    }

    public boolean hasPayeeType() {
        return this.payeeType != null && !this.payeeType.isEmpty();
    }

    public ClaimResponse setPayeeType(CodeableConcept value) {
        this.payeeType = value;
        return this;
    }

    public List<Reference> getEncounter() {
        if (this.encounter == null) {
            this.encounter = new ArrayList<Reference>();
        }
        return this.encounter;
    }

    public ClaimResponse setEncounter(List<Reference> theEncounter) {
        this.encounter = theEncounter;
        return this;
    }

    public boolean hasEncounter() {
        if (this.encounter == null) {
            return false;
        }
        for (Reference item : this.encounter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEncounter() {
        Reference t = new Reference();
        if (this.encounter == null) {
            this.encounter = new ArrayList<Reference>();
        }
        this.encounter.add(t);
        return t;
    }

    public ClaimResponse addEncounter(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.encounter == null) {
            this.encounter = new ArrayList<Reference>();
        }
        this.encounter.add(t);
        return this;
    }

    public Reference getEncounterFirstRep() {
        if (this.getEncounter().isEmpty()) {
            this.addEncounter();
        }
        return this.getEncounter().get(0);
    }

    public CodeableConcept getDiagnosisRelatedGroup() {
        if (this.diagnosisRelatedGroup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.diagnosisRelatedGroup");
            }
            if (Configuration.doAutoCreate()) {
                this.diagnosisRelatedGroup = new CodeableConcept();
            }
        }
        return this.diagnosisRelatedGroup;
    }

    public boolean hasDiagnosisRelatedGroup() {
        return this.diagnosisRelatedGroup != null && !this.diagnosisRelatedGroup.isEmpty();
    }

    public ClaimResponse setDiagnosisRelatedGroup(CodeableConcept value) {
        this.diagnosisRelatedGroup = value;
        return this;
    }

    public List<ItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        return this.item;
    }

    public ClaimResponse setItem(List<ItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemComponent addItem() {
        ItemComponent t = new ItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public ClaimResponse addItem(ItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public ItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    public List<AddedItemComponent> getAddItem() {
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        return this.addItem;
    }

    public ClaimResponse setAddItem(List<AddedItemComponent> theAddItem) {
        this.addItem = theAddItem;
        return this;
    }

    public boolean hasAddItem() {
        if (this.addItem == null) {
            return false;
        }
        for (AddedItemComponent item : this.addItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AddedItemComponent addAddItem() {
        AddedItemComponent t = new AddedItemComponent();
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return t;
    }

    public ClaimResponse addAddItem(AddedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return this;
    }

    public AddedItemComponent getAddItemFirstRep() {
        if (this.getAddItem().isEmpty()) {
            this.addAddItem();
        }
        return this.getAddItem().get(0);
    }

    public List<AdjudicationComponent> getAdjudication() {
        if (this.adjudication == null) {
            this.adjudication = new ArrayList<AdjudicationComponent>();
        }
        return this.adjudication;
    }

    public ClaimResponse setAdjudication(List<AdjudicationComponent> theAdjudication) {
        this.adjudication = theAdjudication;
        return this;
    }

    public boolean hasAdjudication() {
        if (this.adjudication == null) {
            return false;
        }
        for (AdjudicationComponent item : this.adjudication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdjudicationComponent addAdjudication() {
        AdjudicationComponent t = new AdjudicationComponent();
        if (this.adjudication == null) {
            this.adjudication = new ArrayList<AdjudicationComponent>();
        }
        this.adjudication.add(t);
        return t;
    }

    public ClaimResponse addAdjudication(AdjudicationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.adjudication == null) {
            this.adjudication = new ArrayList<AdjudicationComponent>();
        }
        this.adjudication.add(t);
        return this;
    }

    public AdjudicationComponent getAdjudicationFirstRep() {
        if (this.getAdjudication().isEmpty()) {
            this.addAdjudication();
        }
        return this.getAdjudication().get(0);
    }

    public List<TotalComponent> getTotal() {
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        return this.total;
    }

    public ClaimResponse setTotal(List<TotalComponent> theTotal) {
        this.total = theTotal;
        return this;
    }

    public boolean hasTotal() {
        if (this.total == null) {
            return false;
        }
        for (TotalComponent item : this.total) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TotalComponent addTotal() {
        TotalComponent t = new TotalComponent();
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        this.total.add(t);
        return t;
    }

    public ClaimResponse addTotal(TotalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.total == null) {
            this.total = new ArrayList<TotalComponent>();
        }
        this.total.add(t);
        return this;
    }

    public TotalComponent getTotalFirstRep() {
        if (this.getTotal().isEmpty()) {
            this.addTotal();
        }
        return this.getTotal().get(0);
    }

    public PaymentComponent getPayment() {
        if (this.payment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.payment");
            }
            if (Configuration.doAutoCreate()) {
                this.payment = new PaymentComponent();
            }
        }
        return this.payment;
    }

    public boolean hasPayment() {
        return this.payment != null && !this.payment.isEmpty();
    }

    public ClaimResponse setPayment(PaymentComponent value) {
        this.payment = value;
        return this;
    }

    public CodeableConcept getFundsReserve() {
        if (this.fundsReserve == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.fundsReserve");
            }
            if (Configuration.doAutoCreate()) {
                this.fundsReserve = new CodeableConcept();
            }
        }
        return this.fundsReserve;
    }

    public boolean hasFundsReserve() {
        return this.fundsReserve != null && !this.fundsReserve.isEmpty();
    }

    public ClaimResponse setFundsReserve(CodeableConcept value) {
        this.fundsReserve = value;
        return this;
    }

    public CodeableConcept getFormCode() {
        if (this.formCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.formCode");
            }
            if (Configuration.doAutoCreate()) {
                this.formCode = new CodeableConcept();
            }
        }
        return this.formCode;
    }

    public boolean hasFormCode() {
        return this.formCode != null && !this.formCode.isEmpty();
    }

    public ClaimResponse setFormCode(CodeableConcept value) {
        this.formCode = value;
        return this;
    }

    public Attachment getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new Attachment();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public ClaimResponse setForm(Attachment value) {
        this.form = value;
        return this;
    }

    public List<NoteComponent> getProcessNote() {
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        return this.processNote;
    }

    public ClaimResponse setProcessNote(List<NoteComponent> theProcessNote) {
        this.processNote = theProcessNote;
        return this;
    }

    public boolean hasProcessNote() {
        if (this.processNote == null) {
            return false;
        }
        for (NoteComponent item : this.processNote) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NoteComponent addProcessNote() {
        NoteComponent t = new NoteComponent();
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        this.processNote.add(t);
        return t;
    }

    public ClaimResponse addProcessNote(NoteComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processNote == null) {
            this.processNote = new ArrayList<NoteComponent>();
        }
        this.processNote.add(t);
        return this;
    }

    public NoteComponent getProcessNoteFirstRep() {
        if (this.getProcessNote().isEmpty()) {
            this.addProcessNote();
        }
        return this.getProcessNote().get(0);
    }

    public List<Reference> getCommunicationRequest() {
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        return this.communicationRequest;
    }

    public ClaimResponse setCommunicationRequest(List<Reference> theCommunicationRequest) {
        this.communicationRequest = theCommunicationRequest;
        return this;
    }

    public boolean hasCommunicationRequest() {
        if (this.communicationRequest == null) {
            return false;
        }
        for (Reference item : this.communicationRequest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCommunicationRequest() {
        Reference t = new Reference();
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        this.communicationRequest.add(t);
        return t;
    }

    public ClaimResponse addCommunicationRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.communicationRequest == null) {
            this.communicationRequest = new ArrayList<Reference>();
        }
        this.communicationRequest.add(t);
        return this;
    }

    public Reference getCommunicationRequestFirstRep() {
        if (this.getCommunicationRequest().isEmpty()) {
            this.addCommunicationRequest();
        }
        return this.getCommunicationRequest().get(0);
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public ClaimResponse setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public ClaimResponse addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public List<ErrorComponent> getError() {
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        return this.error;
    }

    public ClaimResponse setError(List<ErrorComponent> theError) {
        this.error = theError;
        return this;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (ErrorComponent item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ErrorComponent addError() {
        ErrorComponent t = new ErrorComponent();
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        this.error.add(t);
        return t;
    }

    public ClaimResponse addError(ErrorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<ErrorComponent>();
        }
        this.error.add(t);
        return this;
    }

    public ErrorComponent getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            this.addError();
        }
        return this.getError().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this claim response.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("type", "CodeableConcept", "A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.", 0, 1, this.type));
        children.add(new Property("subType", "CodeableConcept", "A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.", 0, 1, this.subType));
        children.add(new Property(SP_USE, "code", "A code to indicate whether the nature of the request is: Claim - A request to an Insurer to adjudicate the supplied charges for health care goods and services under the identified policy and to pay the determined Benefit amount, if any; Preauthorization - A request to an Insurer to adjudicate the supplied proposed future charges for health care goods and services under the identified policy and to approve the services and provide the expected benefit amounts and potentially to reserve funds to pay the benefits when Claims for the indicated services are later submitted; or, Pre-determination - A request to an Insurer to adjudicate the supplied 'what if' charges for health care goods and services under the identified policy and report back what the Benefit payable would be had the services actually been provided.", 0, 1, this.use));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The party to whom the professional services and/or products have been supplied or are being considered and for whom actual for facast reimbursement is sought.", 0, 1, this.patient));
        children.add(new Property(SP_CREATED, "dateTime", "The date this resource was created.", 0, 1, this.created));
        children.add(new Property(SP_INSURER, "Reference(Organization)", "The party responsible for authorization, adjudication and reimbursement.", 0, 1, this.insurer));
        children.add(new Property(SP_REQUESTOR, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the claim, predetermination or preauthorization.", 0, 1, this.requestor));
        children.add(new Property(SP_REQUEST, "Reference(Claim)", "Original request resource reference.", 0, 1, this.request));
        children.add(new Property(SP_OUTCOME, "code", "The outcome of the claim, predetermination, or preauthorization processing.", 0, 1, this.outcome));
        children.add(new Property("decision", "CodeableConcept", "The result of the claim, predetermination, or preauthorization adjudication.", 0, 1, this.decision));
        children.add(new Property(SP_DISPOSITION, "string", "A human readable description of the status of the adjudication.", 0, 1, this.disposition));
        children.add(new Property("preAuthRef", "string", "Reference from the Insurer which is used in later communications which refers to this adjudication.", 0, 1, this.preAuthRef));
        children.add(new Property("preAuthPeriod", "Period", "The time frame during which this authorization is effective.", 0, 1, this.preAuthPeriod));
        children.add(new Property("event", "", "Information code for an event with a corresponding date or period.", 0, Integer.MAX_VALUE, this.event));
        children.add(new Property("payeeType", "CodeableConcept", "Type of Party to be reimbursed: subscriber, provider, other.", 0, 1, this.payeeType));
        children.add(new Property("encounter", "Reference(Encounter)", "Healthcare encounters related to this claim.", 0, Integer.MAX_VALUE, this.encounter));
        children.add(new Property("diagnosisRelatedGroup", "CodeableConcept", "A package billing code or bundle code used to group products and services to a particular health condition (such as heart attack) which is based on a predetermined grouping code system.", 0, 1, this.diagnosisRelatedGroup));
        children.add(new Property("item", "", "A claim line. Either a simple (a product or service) or a 'group' of details which can also be a simple items or groups of sub-details.", 0, Integer.MAX_VALUE, this.item));
        children.add(new Property("addItem", "", "The first-tier service adjudications for payor added product or service lines.", 0, Integer.MAX_VALUE, this.addItem));
        children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results which are presented at the header level rather than at the line-item or add-item levels.", 0, Integer.MAX_VALUE, this.adjudication));
        children.add(new Property("total", "", "Categorized monetary totals for the adjudication.", 0, Integer.MAX_VALUE, this.total));
        children.add(new Property("payment", "", "Payment details for the adjudication of the claim.", 0, 1, this.payment));
        children.add(new Property("fundsReserve", "CodeableConcept", "A code, used only on a response to a preauthorization, to indicate whether the benefits payable have been reserved and for whom.", 0, 1, this.fundsReserve));
        children.add(new Property("formCode", "CodeableConcept", "A code for the form to be used for printing the content.", 0, 1, this.formCode));
        children.add(new Property("form", "Attachment", "The actual form, by reference or inclusion, for printing the content or an EOB.", 0, 1, this.form));
        children.add(new Property("processNote", "", "A note that describes or explains adjudication results in a human readable form.", 0, Integer.MAX_VALUE, this.processNote));
        children.add(new Property("communicationRequest", "Reference(CommunicationRequest)", "Request for additional supporting or authorizing information.", 0, Integer.MAX_VALUE, this.communicationRequest));
        children.add(new Property("insurance", "", "Financial instruments for reimbursement for the health care products and services specified on the claim.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("error", "", "Errors encountered during the processing of the adjudication.", 0, Integer.MAX_VALUE, this.error));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this claim response.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 82505966: {
                return new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.", 0, 1, this.type);
            }
            case -1868521062: {
                return new Property("subType", "CodeableConcept", "A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.", 0, 1, this.subType);
            }
            case 116103: {
                return new Property(SP_USE, "code", "A code to indicate whether the nature of the request is: Claim - A request to an Insurer to adjudicate the supplied charges for health care goods and services under the identified policy and to pay the determined Benefit amount, if any; Preauthorization - A request to an Insurer to adjudicate the supplied proposed future charges for health care goods and services under the identified policy and to approve the services and provide the expected benefit amounts and potentially to reserve funds to pay the benefits when Claims for the indicated services are later submitted; or, Pre-determination - A request to an Insurer to adjudicate the supplied 'what if' charges for health care goods and services under the identified policy and report back what the Benefit payable would be had the services actually been provided.", 0, 1, this.use);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The party to whom the professional services and/or products have been supplied or are being considered and for whom actual for facast reimbursement is sought.", 0, 1, this.patient);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date this resource was created.", 0, 1, this.created);
            }
            case 1957615864: {
                return new Property(SP_INSURER, "Reference(Organization)", "The party responsible for authorization, adjudication and reimbursement.", 0, 1, this.insurer);
            }
            case 693934258: {
                return new Property(SP_REQUESTOR, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the claim, predetermination or preauthorization.", 0, 1, this.requestor);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(Claim)", "Original request resource reference.", 0, 1, this.request);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "code", "The outcome of the claim, predetermination, or preauthorization processing.", 0, 1, this.outcome);
            }
            case 565719004: {
                return new Property("decision", "CodeableConcept", "The result of the claim, predetermination, or preauthorization adjudication.", 0, 1, this.decision);
            }
            case 583380919: {
                return new Property(SP_DISPOSITION, "string", "A human readable description of the status of the adjudication.", 0, 1, this.disposition);
            }
            case 522246568: {
                return new Property("preAuthRef", "string", "Reference from the Insurer which is used in later communications which refers to this adjudication.", 0, 1, this.preAuthRef);
            }
            case 1819164812: {
                return new Property("preAuthPeriod", "Period", "The time frame during which this authorization is effective.", 0, 1, this.preAuthPeriod);
            }
            case 96891546: {
                return new Property("event", "", "Information code for an event with a corresponding date or period.", 0, Integer.MAX_VALUE, this.event);
            }
            case -316321118: {
                return new Property("payeeType", "CodeableConcept", "Type of Party to be reimbursed: subscriber, provider, other.", 0, 1, this.payeeType);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "Healthcare encounters related to this claim.", 0, Integer.MAX_VALUE, this.encounter);
            }
            case -1599182171: {
                return new Property("diagnosisRelatedGroup", "CodeableConcept", "A package billing code or bundle code used to group products and services to a particular health condition (such as heart attack) which is based on a predetermined grouping code system.", 0, 1, this.diagnosisRelatedGroup);
            }
            case 3242771: {
                return new Property("item", "", "A claim line. Either a simple (a product or service) or a 'group' of details which can also be a simple items or groups of sub-details.", 0, Integer.MAX_VALUE, this.item);
            }
            case -1148899500: {
                return new Property("addItem", "", "The first-tier service adjudications for payor added product or service lines.", 0, Integer.MAX_VALUE, this.addItem);
            }
            case -231349275: {
                return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results which are presented at the header level rather than at the line-item or add-item levels.", 0, Integer.MAX_VALUE, this.adjudication);
            }
            case 110549828: {
                return new Property("total", "", "Categorized monetary totals for the adjudication.", 0, Integer.MAX_VALUE, this.total);
            }
            case -786681338: {
                return new Property("payment", "", "Payment details for the adjudication of the claim.", 0, 1, this.payment);
            }
            case 1314609806: {
                return new Property("fundsReserve", "CodeableConcept", "A code, used only on a response to a preauthorization, to indicate whether the benefits payable have been reserved and for whom.", 0, 1, this.fundsReserve);
            }
            case 473181393: {
                return new Property("formCode", "CodeableConcept", "A code for the form to be used for printing the content.", 0, 1, this.formCode);
            }
            case 3148996: {
                return new Property("form", "Attachment", "The actual form, by reference or inclusion, for printing the content or an EOB.", 0, 1, this.form);
            }
            case 202339073: {
                return new Property("processNote", "", "A note that describes or explains adjudication results in a human readable form.", 0, Integer.MAX_VALUE, this.processNote);
            }
            case -2071896615: {
                return new Property("communicationRequest", "Reference(CommunicationRequest)", "Request for additional supporting or authorizing information.", 0, Integer.MAX_VALUE, this.communicationRequest);
            }
            case 73049818: {
                return new Property("insurance", "", "Financial instruments for reimbursement for the health care products and services specified on the claim.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case 96784904: {
                return new Property("error", "", "Errors encountered during the processing of the adjudication.", 0, Integer.MAX_VALUE, this.error);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 82505966: {
                return this.traceNumber == null ? new Base[]{} : this.traceNumber.toArray(new Base[this.traceNumber.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1868521062: {
                Base[] baseArray;
                if (this.subType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subType;
                }
                return baseArray;
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.use;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.patient;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.created;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.insurer;
                }
                return baseArray;
            }
            case 693934258: {
                Base[] baseArray;
                if (this.requestor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requestor;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.outcome;
                }
                return baseArray;
            }
            case 565719004: {
                Base[] baseArray;
                if (this.decision == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.decision;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.disposition;
                }
                return baseArray;
            }
            case 522246568: {
                Base[] baseArray;
                if (this.preAuthRef == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.preAuthRef;
                }
                return baseArray;
            }
            case 1819164812: {
                Base[] baseArray;
                if (this.preAuthPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.preAuthPeriod;
                }
                return baseArray;
            }
            case 96891546: {
                return this.event == null ? new Base[]{} : this.event.toArray(new Base[this.event.size()]);
            }
            case -316321118: {
                Base[] baseArray;
                if (this.payeeType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.payeeType;
                }
                return baseArray;
            }
            case 1524132147: {
                return this.encounter == null ? new Base[]{} : this.encounter.toArray(new Base[this.encounter.size()]);
            }
            case -1599182171: {
                Base[] baseArray;
                if (this.diagnosisRelatedGroup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.diagnosisRelatedGroup;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
            case -1148899500: {
                return this.addItem == null ? new Base[]{} : this.addItem.toArray(new Base[this.addItem.size()]);
            }
            case -231349275: {
                return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
            }
            case 110549828: {
                return this.total == null ? new Base[]{} : this.total.toArray(new Base[this.total.size()]);
            }
            case -786681338: {
                Base[] baseArray;
                if (this.payment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.payment;
                }
                return baseArray;
            }
            case 1314609806: {
                Base[] baseArray;
                if (this.fundsReserve == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.fundsReserve;
                }
                return baseArray;
            }
            case 473181393: {
                Base[] baseArray;
                if (this.formCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.formCode;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.form;
                }
                return baseArray;
            }
            case 202339073: {
                return this.processNote == null ? new Base[]{} : this.processNote.toArray(new Base[this.processNote.size()]);
            }
            case -2071896615: {
                return this.communicationRequest == null ? new Base[]{} : this.communicationRequest.toArray(new Base[this.communicationRequest.size()]);
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case 96784904: {
                return this.error == null ? new Base[]{} : this.error.toArray(new Base[this.error.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 82505966: {
                this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1868521062: {
                this.subType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 116103: {
                value = new Enumerations.UseEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.use = value;
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1028554472: {
                this.created = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1957615864: {
                this.insurer = TypeConvertor.castToReference(value);
                return value;
            }
            case 693934258: {
                this.requestor = TypeConvertor.castToReference(value);
                return value;
            }
            case 1095692943: {
                this.request = TypeConvertor.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new Enumerations.ClaimProcessingCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 565719004: {
                this.decision = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 583380919: {
                this.disposition = TypeConvertor.castToString(value);
                return value;
            }
            case 522246568: {
                this.preAuthRef = TypeConvertor.castToString(value);
                return value;
            }
            case 1819164812: {
                this.preAuthPeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 96891546: {
                this.getEvent().add((ClaimResponseEventComponent)((Object)value));
                return value;
            }
            case -316321118: {
                this.payeeType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1524132147: {
                this.getEncounter().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1599182171: {
                this.diagnosisRelatedGroup = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3242771: {
                this.getItem().add((ItemComponent)((Object)value));
                return value;
            }
            case -1148899500: {
                this.getAddItem().add((AddedItemComponent)((Object)value));
                return value;
            }
            case -231349275: {
                this.getAdjudication().add((AdjudicationComponent)((Object)value));
                return value;
            }
            case 110549828: {
                this.getTotal().add((TotalComponent)((Object)value));
                return value;
            }
            case -786681338: {
                this.payment = (PaymentComponent)((Object)value);
                return value;
            }
            case 1314609806: {
                this.fundsReserve = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 473181393: {
                this.formCode = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3148996: {
                this.form = TypeConvertor.castToAttachment(value);
                return value;
            }
            case 202339073: {
                this.getProcessNote().add((NoteComponent)((Object)value));
                return value;
            }
            case -2071896615: {
                this.getCommunicationRequest().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
            case 96784904: {
                this.getError().add((ErrorComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("traceNumber")) {
            this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("subType")) {
            this.subType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_USE)) {
            value = new Enumerations.UseEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.use = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_INSURER)) {
            this.insurer = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_REQUESTOR)) {
            this.requestor = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.request = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_OUTCOME)) {
            value = new Enumerations.ClaimProcessingCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.outcome = value;
        } else if (name.equals("decision")) {
            this.decision = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = TypeConvertor.castToString(value);
        } else if (name.equals("preAuthRef")) {
            this.preAuthRef = TypeConvertor.castToString(value);
        } else if (name.equals("preAuthPeriod")) {
            this.preAuthPeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("event")) {
            this.getEvent().add((ClaimResponseEventComponent)((Object)value));
        } else if (name.equals("payeeType")) {
            this.payeeType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("encounter")) {
            this.getEncounter().add(TypeConvertor.castToReference(value));
        } else if (name.equals("diagnosisRelatedGroup")) {
            this.diagnosisRelatedGroup = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemComponent)((Object)value));
        } else if (name.equals("addItem")) {
            this.getAddItem().add((AddedItemComponent)((Object)value));
        } else if (name.equals("adjudication")) {
            this.getAdjudication().add((AdjudicationComponent)((Object)value));
        } else if (name.equals("total")) {
            this.getTotal().add((TotalComponent)((Object)value));
        } else if (name.equals("payment")) {
            this.payment = (PaymentComponent)((Object)value);
        } else if (name.equals("fundsReserve")) {
            this.fundsReserve = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("formCode")) {
            this.formCode = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("form")) {
            this.form = TypeConvertor.castToAttachment(value);
        } else if (name.equals("processNote")) {
            this.getProcessNote().add((NoteComponent)((Object)value));
        } else if (name.equals("communicationRequest")) {
            this.getCommunicationRequest().add(TypeConvertor.castToReference(value));
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else if (name.equals("error")) {
            this.getError().add((ErrorComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("traceNumber")) {
            this.getTraceNumber().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("type")) {
            this.type = null;
        } else if (name.equals("subType")) {
            this.subType = null;
        } else if (name.equals(SP_USE)) {
            value = new Enumerations.UseEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.use = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals(SP_CREATED)) {
            this.created = null;
        } else if (name.equals(SP_INSURER)) {
            this.insurer = null;
        } else if (name.equals(SP_REQUESTOR)) {
            this.requestor = null;
        } else if (name.equals(SP_REQUEST)) {
            this.request = null;
        } else if (name.equals(SP_OUTCOME)) {
            value = new Enumerations.ClaimProcessingCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.outcome = value;
        } else if (name.equals("decision")) {
            this.decision = null;
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = null;
        } else if (name.equals("preAuthRef")) {
            this.preAuthRef = null;
        } else if (name.equals("preAuthPeriod")) {
            this.preAuthPeriod = null;
        } else if (name.equals("event")) {
            this.getEvent().remove((ClaimResponseEventComponent)((Object)value));
        } else if (name.equals("payeeType")) {
            this.payeeType = null;
        } else if (name.equals("encounter")) {
            this.getEncounter().remove(value);
        } else if (name.equals("diagnosisRelatedGroup")) {
            this.diagnosisRelatedGroup = null;
        } else if (name.equals("item")) {
            this.getItem().remove((ItemComponent)((Object)value));
        } else if (name.equals("addItem")) {
            this.getAddItem().remove((AddedItemComponent)((Object)value));
        } else if (name.equals("adjudication")) {
            this.getAdjudication().remove((AdjudicationComponent)((Object)value));
        } else if (name.equals("total")) {
            this.getTotal().remove((TotalComponent)((Object)value));
        } else if (name.equals("payment")) {
            this.payment = (PaymentComponent)((Object)value);
        } else if (name.equals("fundsReserve")) {
            this.fundsReserve = null;
        } else if (name.equals("formCode")) {
            this.formCode = null;
        } else if (name.equals("form")) {
            this.form = null;
        } else if (name.equals("processNote")) {
            this.getProcessNote().remove((NoteComponent)((Object)value));
        } else if (name.equals("communicationRequest")) {
            this.getCommunicationRequest().remove(value);
        } else if (name.equals("insurance")) {
            this.getInsurance().remove((InsuranceComponent)((Object)value));
        } else if (name.equals("error")) {
            this.getError().remove((ErrorComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 82505966: {
                return this.addTraceNumber();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1868521062: {
                return this.getSubType();
            }
            case 116103: {
                return this.getUseElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case 693934258: {
                return this.getRequestor();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 565719004: {
                return this.getDecision();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 522246568: {
                return this.getPreAuthRefElement();
            }
            case 1819164812: {
                return this.getPreAuthPeriod();
            }
            case 96891546: {
                return this.addEvent();
            }
            case -316321118: {
                return this.getPayeeType();
            }
            case 1524132147: {
                return this.addEncounter();
            }
            case -1599182171: {
                return this.getDiagnosisRelatedGroup();
            }
            case 3242771: {
                return this.addItem();
            }
            case -1148899500: {
                return this.addAddItem();
            }
            case -231349275: {
                return this.addAdjudication();
            }
            case 110549828: {
                return this.addTotal();
            }
            case -786681338: {
                return this.getPayment();
            }
            case 1314609806: {
                return this.getFundsReserve();
            }
            case 473181393: {
                return this.getFormCode();
            }
            case 3148996: {
                return this.getForm();
            }
            case 202339073: {
                return this.addProcessNote();
            }
            case -2071896615: {
                return this.addCommunicationRequest();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case 96784904: {
                return this.addError();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 82505966: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1868521062: {
                return new String[]{"CodeableConcept"};
            }
            case 116103: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case 693934258: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 565719004: {
                return new String[]{"CodeableConcept"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 522246568: {
                return new String[]{"string"};
            }
            case 1819164812: {
                return new String[]{"Period"};
            }
            case 96891546: {
                return new String[0];
            }
            case -316321118: {
                return new String[]{"CodeableConcept"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1599182171: {
                return new String[]{"CodeableConcept"};
            }
            case 3242771: {
                return new String[0];
            }
            case -1148899500: {
                return new String[0];
            }
            case -231349275: {
                return new String[]{"@ClaimResponse.item.adjudication"};
            }
            case 110549828: {
                return new String[0];
            }
            case -786681338: {
                return new String[0];
            }
            case 1314609806: {
                return new String[]{"CodeableConcept"};
            }
            case 473181393: {
                return new String[]{"CodeableConcept"};
            }
            case 3148996: {
                return new String[]{"Attachment"};
            }
            case 202339073: {
                return new String[0];
            }
            case -2071896615: {
                return new String[]{"Reference"};
            }
            case 73049818: {
                return new String[0];
            }
            case 96784904: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("traceNumber")) {
            return this.addTraceNumber();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.status");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("subType")) {
            this.subType = new CodeableConcept();
            return this.subType;
        }
        if (name.equals(SP_USE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.use");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.created");
        }
        if (name.equals(SP_INSURER)) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals(SP_REQUESTOR)) {
            this.requestor = new Reference();
            return this.requestor;
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.outcome");
        }
        if (name.equals("decision")) {
            this.decision = new CodeableConcept();
            return this.decision;
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.disposition");
        }
        if (name.equals("preAuthRef")) {
            throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.preAuthRef");
        }
        if (name.equals("preAuthPeriod")) {
            this.preAuthPeriod = new Period();
            return this.preAuthPeriod;
        }
        if (name.equals("event")) {
            return this.addEvent();
        }
        if (name.equals("payeeType")) {
            this.payeeType = new CodeableConcept();
            return this.payeeType;
        }
        if (name.equals("encounter")) {
            return this.addEncounter();
        }
        if (name.equals("diagnosisRelatedGroup")) {
            this.diagnosisRelatedGroup = new CodeableConcept();
            return this.diagnosisRelatedGroup;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("addItem")) {
            return this.addAddItem();
        }
        if (name.equals("adjudication")) {
            return this.addAdjudication();
        }
        if (name.equals("total")) {
            return this.addTotal();
        }
        if (name.equals("payment")) {
            this.payment = new PaymentComponent();
            return this.payment;
        }
        if (name.equals("fundsReserve")) {
            this.fundsReserve = new CodeableConcept();
            return this.fundsReserve;
        }
        if (name.equals("formCode")) {
            this.formCode = new CodeableConcept();
            return this.formCode;
        }
        if (name.equals("form")) {
            this.form = new Attachment();
            return this.form;
        }
        if (name.equals("processNote")) {
            return this.addProcessNote();
        }
        if (name.equals("communicationRequest")) {
            return this.addCommunicationRequest();
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("error")) {
            return this.addError();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ClaimResponse";
    }

    @Override
    public ClaimResponse copy() {
        ClaimResponse dst = new ClaimResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ClaimResponse dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.traceNumber != null) {
            dst.traceNumber = new ArrayList<Identifier>();
            for (Identifier identifier : this.traceNumber) {
                dst.traceNumber.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subType = this.subType == null ? null : this.subType.copy();
        dst.use = this.use == null ? null : this.use.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        dst.requestor = this.requestor == null ? null : this.requestor.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.decision = this.decision == null ? null : this.decision.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.preAuthRef = this.preAuthRef == null ? null : this.preAuthRef.copy();
        Period period = dst.preAuthPeriod = this.preAuthPeriod == null ? null : this.preAuthPeriod.copy();
        if (this.event != null) {
            dst.event = new ArrayList<ClaimResponseEventComponent>();
            for (ClaimResponseEventComponent claimResponseEventComponent : this.event) {
                dst.event.add(claimResponseEventComponent.copy());
            }
        }
        CodeableConcept codeableConcept = dst.payeeType = this.payeeType == null ? null : this.payeeType.copy();
        if (this.encounter != null) {
            dst.encounter = new ArrayList<Reference>();
            for (Reference reference : this.encounter) {
                dst.encounter.add(reference.copy());
            }
        }
        CodeableConcept codeableConcept2 = dst.diagnosisRelatedGroup = this.diagnosisRelatedGroup == null ? null : this.diagnosisRelatedGroup.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemComponent>();
            for (ItemComponent itemComponent : this.item) {
                dst.item.add(itemComponent.copy());
            }
        }
        if (this.addItem != null) {
            dst.addItem = new ArrayList<AddedItemComponent>();
            for (AddedItemComponent addedItemComponent : this.addItem) {
                dst.addItem.add(addedItemComponent.copy());
            }
        }
        if (this.adjudication != null) {
            dst.adjudication = new ArrayList<AdjudicationComponent>();
            for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                dst.adjudication.add(adjudicationComponent.copy());
            }
        }
        if (this.total != null) {
            dst.total = new ArrayList<TotalComponent>();
            for (TotalComponent totalComponent : this.total) {
                dst.total.add(totalComponent.copy());
            }
        }
        dst.payment = this.payment == null ? null : this.payment.copy();
        dst.fundsReserve = this.fundsReserve == null ? null : this.fundsReserve.copy();
        dst.formCode = this.formCode == null ? null : this.formCode.copy();
        Attachment attachment = dst.form = this.form == null ? null : this.form.copy();
        if (this.processNote != null) {
            dst.processNote = new ArrayList<NoteComponent>();
            for (NoteComponent noteComponent : this.processNote) {
                dst.processNote.add(noteComponent.copy());
            }
        }
        if (this.communicationRequest != null) {
            dst.communicationRequest = new ArrayList<Reference>();
            for (Reference reference : this.communicationRequest) {
                dst.communicationRequest.add(reference.copy());
            }
        }
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        if (this.error != null) {
            dst.error = new ArrayList<ErrorComponent>();
            for (ErrorComponent errorComponent : this.error) {
                dst.error.add(errorComponent.copy());
            }
        }
    }

    protected ClaimResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ClaimResponse)) {
            return false;
        }
        ClaimResponse o = (ClaimResponse)other_;
        return ClaimResponse.compareDeep(this.identifier, o.identifier, true) && ClaimResponse.compareDeep(this.traceNumber, o.traceNumber, true) && ClaimResponse.compareDeep(this.status, o.status, true) && ClaimResponse.compareDeep(this.type, o.type, true) && ClaimResponse.compareDeep(this.subType, o.subType, true) && ClaimResponse.compareDeep(this.use, o.use, true) && ClaimResponse.compareDeep(this.patient, o.patient, true) && ClaimResponse.compareDeep(this.created, o.created, true) && ClaimResponse.compareDeep(this.insurer, o.insurer, true) && ClaimResponse.compareDeep(this.requestor, o.requestor, true) && ClaimResponse.compareDeep(this.request, o.request, true) && ClaimResponse.compareDeep(this.outcome, o.outcome, true) && ClaimResponse.compareDeep(this.decision, o.decision, true) && ClaimResponse.compareDeep(this.disposition, o.disposition, true) && ClaimResponse.compareDeep(this.preAuthRef, o.preAuthRef, true) && ClaimResponse.compareDeep(this.preAuthPeriod, o.preAuthPeriod, true) && ClaimResponse.compareDeep(this.event, o.event, true) && ClaimResponse.compareDeep(this.payeeType, o.payeeType, true) && ClaimResponse.compareDeep(this.encounter, o.encounter, true) && ClaimResponse.compareDeep(this.diagnosisRelatedGroup, o.diagnosisRelatedGroup, true) && ClaimResponse.compareDeep(this.item, o.item, true) && ClaimResponse.compareDeep(this.addItem, o.addItem, true) && ClaimResponse.compareDeep(this.adjudication, o.adjudication, true) && ClaimResponse.compareDeep(this.total, o.total, true) && ClaimResponse.compareDeep(this.payment, o.payment, true) && ClaimResponse.compareDeep(this.fundsReserve, o.fundsReserve, true) && ClaimResponse.compareDeep(this.formCode, o.formCode, true) && ClaimResponse.compareDeep(this.form, o.form, true) && ClaimResponse.compareDeep(this.processNote, o.processNote, true) && ClaimResponse.compareDeep(this.communicationRequest, o.communicationRequest, true) && ClaimResponse.compareDeep(this.insurance, o.insurance, true) && ClaimResponse.compareDeep(this.error, o.error, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ClaimResponse)) {
            return false;
        }
        ClaimResponse o = (ClaimResponse)other_;
        return ClaimResponse.compareValues(this.status, o.status, true) && ClaimResponse.compareValues(this.use, o.use, true) && ClaimResponse.compareValues(this.created, o.created, true) && ClaimResponse.compareValues(this.outcome, o.outcome, true) && ClaimResponse.compareValues(this.disposition, o.disposition, true) && ClaimResponse.compareValues(this.preAuthRef, o.preAuthRef, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.traceNumber, this.status, this.type, this.subType, this.use, this.patient, this.created, this.insurer, this.requestor, this.request, this.outcome, this.decision, this.disposition, this.preAuthRef, this.preAuthPeriod, this.event, this.payeeType, this.encounter, this.diagnosisRelatedGroup, this.item, this.addItem, this.adjudication, this.total, this.payment, this.fundsReserve, this.formCode, this.form, this.processNote, this.communicationRequest, this.insurance, this.error});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ClaimResponse;
    }

    @Block
    public static class ErrorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="itemSequence", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Item sequence number", formalDefinition="The sequence number of the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.")
        protected PositiveIntType itemSequence;
        @Child(name="detailSequence", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detail sequence number", formalDefinition="The sequence number of the detail within the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.")
        protected PositiveIntType detailSequence;
        @Child(name="subDetailSequence", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail sequence number", formalDefinition="The sequence number of the sub-detail within the detail within the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.")
        protected PositiveIntType subDetailSequence;
        @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Error code detailing processing issues", formalDefinition="An error code, from a specified code system, which details why the claim could not be adjudicated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-error")
        protected CodeableConcept code;
        @Child(name="expression", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="FHIRPath of element(s) related to issue", formalDefinition="A [simple subset of FHIRPath](fhirpath.html#simple) limited to element names, repetition indicators and the default child accessor that identifies one of the elements in the resource that caused this issue to be raised.")
        protected List<StringType> expression;
        private static final long serialVersionUID = -514754249L;

        public ErrorComponent() {
        }

        public ErrorComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public PositiveIntType getItemSequenceElement() {
            if (this.itemSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.itemSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemSequence = new PositiveIntType();
                }
            }
            return this.itemSequence;
        }

        public boolean hasItemSequenceElement() {
            return this.itemSequence != null && !this.itemSequence.isEmpty();
        }

        public boolean hasItemSequence() {
            return this.itemSequence != null && !this.itemSequence.isEmpty();
        }

        public ErrorComponent setItemSequenceElement(PositiveIntType value) {
            this.itemSequence = value;
            return this;
        }

        public int getItemSequence() {
            return this.itemSequence == null || this.itemSequence.isEmpty() ? 0 : (Integer)this.itemSequence.getValue();
        }

        public ErrorComponent setItemSequence(int value) {
            if (this.itemSequence == null) {
                this.itemSequence = new PositiveIntType();
            }
            this.itemSequence.setValue((Object)value);
            return this;
        }

        public PositiveIntType getDetailSequenceElement() {
            if (this.detailSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.detailSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailSequence = new PositiveIntType();
                }
            }
            return this.detailSequence;
        }

        public boolean hasDetailSequenceElement() {
            return this.detailSequence != null && !this.detailSequence.isEmpty();
        }

        public boolean hasDetailSequence() {
            return this.detailSequence != null && !this.detailSequence.isEmpty();
        }

        public ErrorComponent setDetailSequenceElement(PositiveIntType value) {
            this.detailSequence = value;
            return this;
        }

        public int getDetailSequence() {
            return this.detailSequence == null || this.detailSequence.isEmpty() ? 0 : (Integer)this.detailSequence.getValue();
        }

        public ErrorComponent setDetailSequence(int value) {
            if (this.detailSequence == null) {
                this.detailSequence = new PositiveIntType();
            }
            this.detailSequence.setValue((Object)value);
            return this;
        }

        public PositiveIntType getSubDetailSequenceElement() {
            if (this.subDetailSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.subDetailSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.subDetailSequence = new PositiveIntType();
                }
            }
            return this.subDetailSequence;
        }

        public boolean hasSubDetailSequenceElement() {
            return this.subDetailSequence != null && !this.subDetailSequence.isEmpty();
        }

        public boolean hasSubDetailSequence() {
            return this.subDetailSequence != null && !this.subDetailSequence.isEmpty();
        }

        public ErrorComponent setSubDetailSequenceElement(PositiveIntType value) {
            this.subDetailSequence = value;
            return this;
        }

        public int getSubDetailSequence() {
            return this.subDetailSequence == null || this.subDetailSequence.isEmpty() ? 0 : (Integer)this.subDetailSequence.getValue();
        }

        public ErrorComponent setSubDetailSequence(int value) {
            if (this.subDetailSequence == null) {
                this.subDetailSequence = new PositiveIntType();
            }
            this.subDetailSequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ErrorComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<StringType> getExpression() {
            if (this.expression == null) {
                this.expression = new ArrayList<StringType>();
            }
            return this.expression;
        }

        public ErrorComponent setExpression(List<StringType> theExpression) {
            this.expression = theExpression;
            return this;
        }

        public boolean hasExpression() {
            if (this.expression == null) {
                return false;
            }
            for (StringType item : this.expression) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addExpressionElement() {
            StringType t = new StringType();
            if (this.expression == null) {
                this.expression = new ArrayList<StringType>();
            }
            this.expression.add(t);
            return t;
        }

        public ErrorComponent addExpression(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.expression == null) {
                this.expression = new ArrayList<StringType>();
            }
            this.expression.add(t);
            return this;
        }

        public boolean hasExpression(String value) {
            if (this.expression == null) {
                return false;
            }
            for (StringType v : this.expression) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("itemSequence", "positiveInt", "The sequence number of the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.", 0, 1, this.itemSequence));
            children.add(new Property("detailSequence", "positiveInt", "The sequence number of the detail within the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.", 0, 1, this.detailSequence));
            children.add(new Property("subDetailSequence", "positiveInt", "The sequence number of the sub-detail within the detail within the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.", 0, 1, this.subDetailSequence));
            children.add(new Property("code", "CodeableConcept", "An error code, from a specified code system, which details why the claim could not be adjudicated.", 0, 1, this.code));
            children.add(new Property("expression", "string", "A [simple subset of FHIRPath](fhirpath.html#simple) limited to element names, repetition indicators and the default child accessor that identifies one of the elements in the resource that caused this issue to be raised.", 0, Integer.MAX_VALUE, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1977979892: {
                    return new Property("itemSequence", "positiveInt", "The sequence number of the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.", 0, 1, this.itemSequence);
                }
                case 1321472818: {
                    return new Property("detailSequence", "positiveInt", "The sequence number of the detail within the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.", 0, 1, this.detailSequence);
                }
                case -855462510: {
                    return new Property("subDetailSequence", "positiveInt", "The sequence number of the sub-detail within the detail within the line item submitted which contains the error. This value is omitted when the error occurs outside of the item structure.", 0, 1, this.subDetailSequence);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "An error code, from a specified code system, which details why the claim could not be adjudicated.", 0, 1, this.code);
                }
                case -1795452264: {
                    return new Property("expression", "string", "A [simple subset of FHIRPath](fhirpath.html#simple) limited to element names, repetition indicators and the default child accessor that identifies one of the elements in the resource that caused this issue to be raised.", 0, Integer.MAX_VALUE, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    Base[] baseArray;
                    if (this.itemSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.itemSequence;
                    }
                    return baseArray;
                }
                case 1321472818: {
                    Base[] baseArray;
                    if (this.detailSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detailSequence;
                    }
                    return baseArray;
                }
                case -855462510: {
                    Base[] baseArray;
                    if (this.subDetailSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.subDetailSequence;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.code;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    return this.expression == null ? new Base[]{} : this.expression.toArray(new Base[this.expression.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    this.itemSequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 1321472818: {
                    this.detailSequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case -855462510: {
                    this.subDetailSequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1795452264: {
                    this.getExpression().add(TypeConvertor.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.itemSequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("detailSequence")) {
                this.detailSequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("subDetailSequence")) {
                this.subDetailSequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("expression")) {
                this.getExpression().add(TypeConvertor.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.itemSequence = null;
            } else if (name.equals("detailSequence")) {
                this.detailSequence = null;
            } else if (name.equals("subDetailSequence")) {
                this.subDetailSequence = null;
            } else if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("expression")) {
                this.getExpression().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.getItemSequenceElement();
                }
                case 1321472818: {
                    return this.getDetailSequenceElement();
                }
                case -855462510: {
                    return this.getSubDetailSequenceElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -1795452264: {
                    return this.addExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return new String[]{"positiveInt"};
                }
                case 1321472818: {
                    return new String[]{"positiveInt"};
                }
                case -855462510: {
                    return new String[]{"positiveInt"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.error.itemSequence");
            }
            if (name.equals("detailSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.error.detailSequence");
            }
            if (name.equals("subDetailSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.error.subDetailSequence");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.error.expression");
            }
            return super.addChild(name);
        }

        @Override
        public ErrorComponent copy() {
            ErrorComponent dst = new ErrorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ErrorComponent dst) {
            super.copyValues(dst);
            dst.itemSequence = this.itemSequence == null ? null : this.itemSequence.copy();
            dst.detailSequence = this.detailSequence == null ? null : this.detailSequence.copy();
            dst.subDetailSequence = this.subDetailSequence == null ? null : this.subDetailSequence.copy();
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.expression != null) {
                dst.expression = new ArrayList<StringType>();
                for (StringType i : this.expression) {
                    dst.expression.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ErrorComponent)) {
                return false;
            }
            ErrorComponent o = (ErrorComponent)other_;
            return ErrorComponent.compareDeep(this.itemSequence, o.itemSequence, true) && ErrorComponent.compareDeep(this.detailSequence, o.detailSequence, true) && ErrorComponent.compareDeep(this.subDetailSequence, o.subDetailSequence, true) && ErrorComponent.compareDeep(this.code, o.code, true) && ErrorComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ErrorComponent)) {
                return false;
            }
            ErrorComponent o = (ErrorComponent)other_;
            return ErrorComponent.compareValues(this.itemSequence, o.itemSequence, true) && ErrorComponent.compareValues(this.detailSequence, o.detailSequence, true) && ErrorComponent.compareValues(this.subDetailSequence, o.subDetailSequence, true) && ErrorComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.itemSequence, this.detailSequence, this.subDetailSequence, this.code, this.expression});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.error";
        }
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Insurance instance identifier", formalDefinition="A number to uniquely identify insurance entries and provide a sequence of coverages to convey coordination of benefit order.")
        protected PositiveIntType sequence;
        @Child(name="focal", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Coverage to be used for adjudication", formalDefinition="A flag to indicate that this Coverage is to be used for adjudication of this claim when set to true.")
        protected BooleanType focal;
        @Child(name="coverage", type={Coverage.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.")
        protected Reference coverage;
        @Child(name="businessArrangement", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional provider contract number", formalDefinition="A business agreement number established between the provider and the insurer for special business processing purposes.")
        protected StringType businessArrangement;
        @Child(name="claimResponse", type={ClaimResponse.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication results", formalDefinition="The result of the adjudication of the line items for the Coverage specified in this insurance.")
        protected Reference claimResponse;
        private static final long serialVersionUID = -218152446L;

        public InsuranceComponent() {
        }

        public InsuranceComponent(int sequence, boolean focal, Reference coverage) {
            this.setSequence(sequence);
            this.setFocal(focal);
            this.setCoverage(coverage);
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public InsuranceComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public InsuranceComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public InsuranceComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public InsuranceComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public StringType getBusinessArrangementElement() {
            if (this.businessArrangement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.businessArrangement");
                }
                if (Configuration.doAutoCreate()) {
                    this.businessArrangement = new StringType();
                }
            }
            return this.businessArrangement;
        }

        public boolean hasBusinessArrangementElement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public boolean hasBusinessArrangement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public InsuranceComponent setBusinessArrangementElement(StringType value) {
            this.businessArrangement = value;
            return this;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
        }

        public InsuranceComponent setBusinessArrangement(String value) {
            if (Utilities.noString((String)value)) {
                this.businessArrangement = null;
            } else {
                if (this.businessArrangement == null) {
                    this.businessArrangement = new StringType();
                }
                this.businessArrangement.setValue(value);
            }
            return this;
        }

        public Reference getClaimResponse() {
            if (this.claimResponse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponse = new Reference();
                }
            }
            return this.claimResponse;
        }

        public boolean hasClaimResponse() {
            return this.claimResponse != null && !this.claimResponse.isEmpty();
        }

        public InsuranceComponent setClaimResponse(Reference value) {
            this.claimResponse = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify insurance entries and provide a sequence of coverages to convey coordination of benefit order.", 0, 1, this.sequence));
            children.add(new Property("focal", "boolean", "A flag to indicate that this Coverage is to be used for adjudication of this claim when set to true.", 0, 1, this.focal));
            children.add(new Property("coverage", "Reference(Coverage)", "Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.", 0, 1, this.coverage));
            children.add(new Property("businessArrangement", "string", "A business agreement number established between the provider and the insurer for special business processing purposes.", 0, 1, this.businessArrangement));
            children.add(new Property("claimResponse", "Reference(ClaimResponse)", "The result of the adjudication of the line items for the Coverage specified in this insurance.", 0, 1, this.claimResponse));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify insurance entries and provide a sequence of coverages to convey coordination of benefit order.", 0, 1, this.sequence);
                }
                case 97604197: {
                    return new Property("focal", "boolean", "A flag to indicate that this Coverage is to be used for adjudication of this claim when set to true.", 0, 1, this.focal);
                }
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.", 0, 1, this.coverage);
                }
                case 259920682: {
                    return new Property("businessArrangement", "string", "A business agreement number established between the provider and the insurer for special business processing purposes.", 0, 1, this.businessArrangement);
                }
                case 689513629: {
                    return new Property("claimResponse", "Reference(ClaimResponse)", "The result of the adjudication of the line items for the Coverage specified in this insurance.", 0, 1, this.claimResponse);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 97604197: {
                    Base[] baseArray;
                    if (this.focal == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.focal;
                    }
                    return baseArray;
                }
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.coverage;
                    }
                    return baseArray;
                }
                case 259920682: {
                    Base[] baseArray;
                    if (this.businessArrangement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.businessArrangement;
                    }
                    return baseArray;
                }
                case 689513629: {
                    Base[] baseArray;
                    if (this.claimResponse == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.claimResponse;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 97604197: {
                    this.focal = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -351767064: {
                    this.coverage = TypeConvertor.castToReference(value);
                    return value;
                }
                case 259920682: {
                    this.businessArrangement = TypeConvertor.castToString(value);
                    return value;
                }
                case 689513629: {
                    this.claimResponse = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("focal")) {
                this.focal = TypeConvertor.castToBoolean(value);
            } else if (name.equals("coverage")) {
                this.coverage = TypeConvertor.castToReference(value);
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = TypeConvertor.castToString(value);
            } else if (name.equals("claimResponse")) {
                this.claimResponse = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("focal")) {
                this.focal = null;
            } else if (name.equals("coverage")) {
                this.coverage = null;
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = null;
            } else if (name.equals("claimResponse")) {
                this.claimResponse = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 97604197: {
                    return this.getFocalElement();
                }
                case -351767064: {
                    return this.getCoverage();
                }
                case 259920682: {
                    return this.getBusinessArrangementElement();
                }
                case 689513629: {
                    return this.getClaimResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 97604197: {
                    return new String[]{"boolean"};
                }
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case 259920682: {
                    return new String[]{"string"};
                }
                case 689513629: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.insurance.sequence");
            }
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.insurance.focal");
            }
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("businessArrangement")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.insurance.businessArrangement");
            }
            if (name.equals("claimResponse")) {
                this.claimResponse = new Reference();
                return this.claimResponse;
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsuranceComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
            dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareDeep(this.sequence, o.sequence, true) && InsuranceComponent.compareDeep(this.focal, o.focal, true) && InsuranceComponent.compareDeep(this.coverage, o.coverage, true) && InsuranceComponent.compareDeep(this.businessArrangement, o.businessArrangement, true) && InsuranceComponent.compareDeep(this.claimResponse, o.claimResponse, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareValues(this.sequence, o.sequence, true) && InsuranceComponent.compareValues(this.focal, o.focal, true) && InsuranceComponent.compareValues(this.businessArrangement, o.businessArrangement, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.focal, this.coverage, this.businessArrangement, this.claimResponse});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.insurance";
        }
    }

    @Block
    public static class NoteComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Note instance identifier", formalDefinition="A number to uniquely identify a note entry.")
        protected PositiveIntType number;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Note purpose", formalDefinition="The business purpose of the note text.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        protected CodeableConcept type;
        @Child(name="text", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Note explanatory text", formalDefinition="The explanation or description associated with the processing.")
        protected StringType text;
        @Child(name="language", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language of the text", formalDefinition="A code to define the language used in the text of the note.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-languages")
        protected CodeableConcept language;
        private static final long serialVersionUID = -944255449L;

        public NoteComponent() {
        }

        public NoteComponent(String text) {
            this.setText(text);
        }

        public PositiveIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new PositiveIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public NoteComponent setNumberElement(PositiveIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public NoteComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new PositiveIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NoteComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NoteComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NoteComponent setText(String value) {
            if (this.text == null) {
                this.text = new StringType();
            }
            this.text.setValue(value);
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NoteComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public NoteComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("number", "positiveInt", "A number to uniquely identify a note entry.", 0, 1, this.number));
            children.add(new Property("type", "CodeableConcept", "The business purpose of the note text.", 0, 1, this.type));
            children.add(new Property("text", "string", "The explanation or description associated with the processing.", 0, 1, this.text));
            children.add(new Property("language", "CodeableConcept", "A code to define the language used in the text of the note.", 0, 1, this.language));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1034364087: {
                    return new Property("number", "positiveInt", "A number to uniquely identify a note entry.", 0, 1, this.number);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The business purpose of the note text.", 0, 1, this.type);
                }
                case 3556653: {
                    return new Property("text", "string", "The explanation or description associated with the processing.", 0, 1, this.text);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "A code to define the language used in the text of the note.", 0, 1, this.language);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.number;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.language;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    this.number = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToString(value);
                    return value;
                }
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToString(value);
            } else if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = null;
            } else if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("text")) {
                this.text = null;
            } else if (name.equals("language")) {
                this.language = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case 3556653: {
                    return this.getTextElement();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1034364087: {
                    return new String[]{"positiveInt"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.processNote.number");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.processNote.text");
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            return super.addChild(name);
        }

        @Override
        public NoteComponent copy() {
            NoteComponent dst = new NoteComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NoteComponent dst) {
            super.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.language = this.language == null ? null : this.language.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NoteComponent)) {
                return false;
            }
            NoteComponent o = (NoteComponent)other_;
            return NoteComponent.compareDeep(this.number, o.number, true) && NoteComponent.compareDeep(this.type, o.type, true) && NoteComponent.compareDeep(this.text, o.text, true) && NoteComponent.compareDeep(this.language, o.language, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NoteComponent)) {
                return false;
            }
            NoteComponent o = (NoteComponent)other_;
            return NoteComponent.compareValues(this.number, o.number, true) && NoteComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.number, this.type, this.text, this.language});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.processNote";
        }
    }

    @Block
    public static class PaymentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Partial or complete payment", formalDefinition="Whether this represents partial or complete payment of the benefits payable.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-paymenttype")
        protected CodeableConcept type;
        @Child(name="adjustment", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Payment adjustment for non-claim issues", formalDefinition="Total amount of all adjustments to this payment included in this transaction which are not related to this claim's adjudication.")
        protected Money adjustment;
        @Child(name="adjustmentReason", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation for the adjustment", formalDefinition="Reason for the payment adjustment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-adjustment-reason")
        protected CodeableConcept adjustmentReason;
        @Child(name="date", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Expected date of payment", formalDefinition="Estimated date the payment will be issued or the actual issue date of payment.")
        protected DateType date;
        @Child(name="amount", type={Money.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Payable amount after adjustment", formalDefinition="Benefits payable less any payment adjustment.")
        protected Money amount;
        @Child(name="identifier", type={Identifier.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business identifier for the payment", formalDefinition="Issuer's unique identifier for the payment instrument.")
        protected Identifier identifier;
        private static final long serialVersionUID = 1539906026L;

        public PaymentComponent() {
        }

        public PaymentComponent(CodeableConcept type, Money amount) {
            this.setType(type);
            this.setAmount(amount);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PaymentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Money getAdjustment() {
            if (this.adjustment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.adjustment");
                }
                if (Configuration.doAutoCreate()) {
                    this.adjustment = new Money();
                }
            }
            return this.adjustment;
        }

        public boolean hasAdjustment() {
            return this.adjustment != null && !this.adjustment.isEmpty();
        }

        public PaymentComponent setAdjustment(Money value) {
            this.adjustment = value;
            return this;
        }

        public CodeableConcept getAdjustmentReason() {
            if (this.adjustmentReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.adjustmentReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.adjustmentReason = new CodeableConcept();
                }
            }
            return this.adjustmentReason;
        }

        public boolean hasAdjustmentReason() {
            return this.adjustmentReason != null && !this.adjustmentReason.isEmpty();
        }

        public PaymentComponent setAdjustmentReason(CodeableConcept value) {
            this.adjustmentReason = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public PaymentComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public PaymentComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PaymentComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public PaymentComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Whether this represents partial or complete payment of the benefits payable.", 0, 1, this.type));
            children.add(new Property("adjustment", "Money", "Total amount of all adjustments to this payment included in this transaction which are not related to this claim's adjudication.", 0, 1, this.adjustment));
            children.add(new Property("adjustmentReason", "CodeableConcept", "Reason for the payment adjustment.", 0, 1, this.adjustmentReason));
            children.add(new Property("date", "date", "Estimated date the payment will be issued or the actual issue date of payment.", 0, 1, this.date));
            children.add(new Property("amount", "Money", "Benefits payable less any payment adjustment.", 0, 1, this.amount));
            children.add(new Property(ClaimResponse.SP_IDENTIFIER, "Identifier", "Issuer's unique identifier for the payment instrument.", 0, 1, this.identifier));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Whether this represents partial or complete payment of the benefits payable.", 0, 1, this.type);
                }
                case 1977085293: {
                    return new Property("adjustment", "Money", "Total amount of all adjustments to this payment included in this transaction which are not related to this claim's adjudication.", 0, 1, this.adjustment);
                }
                case -1255938543: {
                    return new Property("adjustmentReason", "CodeableConcept", "Reason for the payment adjustment.", 0, 1, this.adjustmentReason);
                }
                case 3076014: {
                    return new Property("date", "date", "Estimated date the payment will be issued or the actual issue date of payment.", 0, 1, this.date);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Benefits payable less any payment adjustment.", 0, 1, this.amount);
                }
                case -1618432855: {
                    return new Property(ClaimResponse.SP_IDENTIFIER, "Identifier", "Issuer's unique identifier for the payment instrument.", 0, 1, this.identifier);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1977085293: {
                    Base[] baseArray;
                    if (this.adjustment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.adjustment;
                    }
                    return baseArray;
                }
                case -1255938543: {
                    Base[] baseArray;
                    if (this.adjustmentReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.adjustmentReason;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.date;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.identifier;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1977085293: {
                    this.adjustment = TypeConvertor.castToMoney(value);
                    return value;
                }
                case -1255938543: {
                    this.adjustmentReason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = TypeConvertor.castToDate(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToMoney(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("adjustment")) {
                this.adjustment = TypeConvertor.castToMoney(value);
            } else if (name.equals("adjustmentReason")) {
                this.adjustmentReason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = TypeConvertor.castToDate(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToMoney(value);
            } else if (name.equals(ClaimResponse.SP_IDENTIFIER)) {
                this.identifier = TypeConvertor.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("adjustment")) {
                this.adjustment = null;
            } else if (name.equals("adjustmentReason")) {
                this.adjustmentReason = null;
            } else if (name.equals("date")) {
                this.date = null;
            } else if (name.equals("amount")) {
                this.amount = null;
            } else if (name.equals(ClaimResponse.SP_IDENTIFIER)) {
                this.identifier = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1977085293: {
                    return this.getAdjustment();
                }
                case -1255938543: {
                    return this.getAdjustmentReason();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1977085293: {
                    return new String[]{"Money"};
                }
                case -1255938543: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"date"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("adjustment")) {
                this.adjustment = new Money();
                return this.adjustment;
            }
            if (name.equals("adjustmentReason")) {
                this.adjustmentReason = new CodeableConcept();
                return this.adjustmentReason;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.payment.date");
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals(ClaimResponse.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            return super.addChild(name);
        }

        @Override
        public PaymentComponent copy() {
            PaymentComponent dst = new PaymentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PaymentComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.adjustment = this.adjustment == null ? null : this.adjustment.copy();
            dst.adjustmentReason = this.adjustmentReason == null ? null : this.adjustmentReason.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PaymentComponent)) {
                return false;
            }
            PaymentComponent o = (PaymentComponent)other_;
            return PaymentComponent.compareDeep(this.type, o.type, true) && PaymentComponent.compareDeep(this.adjustment, o.adjustment, true) && PaymentComponent.compareDeep(this.adjustmentReason, o.adjustmentReason, true) && PaymentComponent.compareDeep(this.date, o.date, true) && PaymentComponent.compareDeep(this.amount, o.amount, true) && PaymentComponent.compareDeep(this.identifier, o.identifier, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PaymentComponent)) {
                return false;
            }
            PaymentComponent o = (PaymentComponent)other_;
            return PaymentComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.adjustment, this.adjustmentReason, this.date, this.amount, this.identifier});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.payment";
        }
    }

    @Block
    public static class TotalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of adjudication information", formalDefinition="A code to indicate the information type of this adjudication record. Information types may include: the value submitted, maximum values or percentages allowed or payable under the plan, amounts that the patient is responsible for in aggregate or pertaining to this item, amounts paid by other coverages, and the benefit payable for this item.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication")
        protected CodeableConcept category;
        @Child(name="amount", type={Money.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Financial total for the category", formalDefinition="Monetary total amount associated with the category.")
        protected Money amount;
        private static final long serialVersionUID = 2012310309L;

        public TotalComponent() {
        }

        public TotalComponent(CodeableConcept category, Money amount) {
            this.setCategory(category);
            this.setAmount(amount);
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TotalComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public TotalComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TotalComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public TotalComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "A code to indicate the information type of this adjudication record. Information types may include: the value submitted, maximum values or percentages allowed or payable under the plan, amounts that the patient is responsible for in aggregate or pertaining to this item, amounts paid by other coverages, and the benefit payable for this item.", 0, 1, this.category));
            children.add(new Property("amount", "Money", "Monetary total amount associated with the category.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "A code to indicate the information type of this adjudication record. Information types may include: the value submitted, maximum values or percentages allowed or payable under the plan, amounts that the patient is responsible for in aggregate or pertaining to this item, amounts paid by other coverages, and the benefit payable for this item.", 0, 1, this.category);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Monetary total amount associated with the category.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("amount")) {
                this.amount = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public TotalComponent copy() {
            TotalComponent dst = new TotalComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TotalComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TotalComponent)) {
                return false;
            }
            TotalComponent o = (TotalComponent)other_;
            return TotalComponent.compareDeep(this.category, o.category, true) && TotalComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TotalComponent)) {
                return false;
            }
            TotalComponent o = (TotalComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.amount});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.total";
        }
    }

    @Block
    public static class AddedItemSubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="traceNumber", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Number for tracking", formalDefinition="Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.")
        protected List<Identifier> traceNumber;
        @Child(name="revenue", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="productOrService", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing, service, product, or drug code", formalDefinition="When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrService;
        @Child(name="productOrServiceEnd", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="End of a range of codes", formalDefinition="This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrServiceEnd;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes to convey additional context for the product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="quantity", type={Quantity.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of products or services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per item", formalDefinition="If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="tax", type={Money.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total tax", formalDefinition="The total of taxes applicable for this product or service.")
        protected Money tax;
        @Child(name="net", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The total amount claimed for the addItem.detail.subDetail. Net = unit price * quantity * factor.")
        protected Money net;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable note numbers", formalDefinition="The numbers associated with notes below which apply to the adjudication of this item.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="reviewOutcome", type={ReviewOutcomeComponent.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Added items subdetail level adjudication results", formalDefinition="The high-level results of the adjudication if adjudication has been performed.")
        protected ReviewOutcomeComponent reviewOutcome;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items subdetail adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        private static final long serialVersionUID = -1130518441L;

        public List<Identifier> getTraceNumber() {
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            return this.traceNumber;
        }

        public AddedItemSubDetailComponent setTraceNumber(List<Identifier> theTraceNumber) {
            this.traceNumber = theTraceNumber;
            return this;
        }

        public boolean hasTraceNumber() {
            if (this.traceNumber == null) {
                return false;
            }
            for (Identifier item : this.traceNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addTraceNumber() {
            Identifier t = new Identifier();
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return t;
        }

        public AddedItemSubDetailComponent addTraceNumber(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return this;
        }

        public Identifier getTraceNumberFirstRep() {
            if (this.getTraceNumber().isEmpty()) {
                this.addTraceNumber();
            }
            return this.getTraceNumber().get(0);
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public AddedItemSubDetailComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getProductOrService() {
            if (this.productOrService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.productOrService");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrService = new CodeableConcept();
                }
            }
            return this.productOrService;
        }

        public boolean hasProductOrService() {
            return this.productOrService != null && !this.productOrService.isEmpty();
        }

        public AddedItemSubDetailComponent setProductOrService(CodeableConcept value) {
            this.productOrService = value;
            return this;
        }

        public CodeableConcept getProductOrServiceEnd() {
            if (this.productOrServiceEnd == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.productOrServiceEnd");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrServiceEnd = new CodeableConcept();
                }
            }
            return this.productOrServiceEnd;
        }

        public boolean hasProductOrServiceEnd() {
            return this.productOrServiceEnd != null && !this.productOrServiceEnd.isEmpty();
        }

        public AddedItemSubDetailComponent setProductOrServiceEnd(CodeableConcept value) {
            this.productOrServiceEnd = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemSubDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemSubDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemSubDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemSubDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemSubDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemSubDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemSubDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemSubDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getTax() {
            if (this.tax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.tax");
                }
                if (Configuration.doAutoCreate()) {
                    this.tax = new Money();
                }
            }
            return this.tax;
        }

        public boolean hasTax() {
            return this.tax != null && !this.tax.isEmpty();
        }

        public AddedItemSubDetailComponent setTax(Money value) {
            this.tax = value;
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemSubDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemSubDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemSubDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public ReviewOutcomeComponent getReviewOutcome() {
            if (this.reviewOutcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemSubDetailComponent.reviewOutcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.reviewOutcome = new ReviewOutcomeComponent();
                }
            }
            return this.reviewOutcome;
        }

        public boolean hasReviewOutcome() {
            return this.reviewOutcome != null && !this.reviewOutcome.isEmpty();
        }

        public AddedItemSubDetailComponent setReviewOutcome(ReviewOutcomeComponent value) {
            this.reviewOutcome = value;
            return this;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemSubDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemSubDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.", 0, 1, this.productOrService));
            children.add(new Property("productOrServiceEnd", "CodeableConcept", "This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.", 0, 1, this.productOrServiceEnd));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("quantity", "Quantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("tax", "Money", "The total of taxes applicable for this product or service.", 0, 1, this.tax));
            children.add(new Property("net", "Money", "The total amount claimed for the addItem.detail.subDetail. Net = unit price * quantity * factor.", 0, 1, this.net));
            children.add(new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 82505966: {
                    return new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 1957227299: {
                    return new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.", 0, 1, this.productOrService);
                }
                case -717476168: {
                    return new Property("productOrServiceEnd", "CodeableConcept", "This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.", 0, 1, this.productOrServiceEnd);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 114603: {
                    return new Property("tax", "Money", "The total of taxes applicable for this product or service.", 0, 1, this.tax);
                }
                case 108957: {
                    return new Property("net", "Money", "The total amount claimed for the addItem.detail.subDetail. Net = unit price * quantity * factor.", 0, 1, this.net);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -51825446: {
                    return new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 82505966: {
                    return this.traceNumber == null ? new Base[]{} : this.traceNumber.toArray(new Base[this.traceNumber.size()]);
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 1957227299: {
                    Base[] baseArray;
                    if (this.productOrService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.productOrService;
                    }
                    return baseArray;
                }
                case -717476168: {
                    Base[] baseArray;
                    if (this.productOrServiceEnd == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.productOrServiceEnd;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case 114603: {
                    Base[] baseArray;
                    if (this.tax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.tax;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -51825446: {
                    Base[] baseArray;
                    if (this.reviewOutcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.reviewOutcome;
                    }
                    return baseArray;
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 82505966: {
                    this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 1099842588: {
                    this.revenue = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1957227299: {
                    this.productOrService = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -717476168: {
                    this.productOrServiceEnd = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = TypeConvertor.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 114603: {
                    this.tax = TypeConvertor.castToMoney(value);
                    return value;
                }
                case 108957: {
                    this.net = TypeConvertor.castToMoney(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case -51825446: {
                    this.reviewOutcome = (ReviewOutcomeComponent)value;
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("traceNumber")) {
                this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("revenue")) {
                this.revenue = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("productOrService")) {
                this.productOrService = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = TypeConvertor.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = TypeConvertor.castToDecimal(value);
            } else if (name.equals("tax")) {
                this.tax = TypeConvertor.castToMoney(value);
            } else if (name.equals("net")) {
                this.net = TypeConvertor.castToMoney(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("traceNumber")) {
                this.getTraceNumber().remove(value);
            } else if (name.equals("revenue")) {
                this.revenue = null;
            } else if (name.equals("productOrService")) {
                this.productOrService = null;
            } else if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = null;
            } else if (name.equals("modifier")) {
                this.getModifier().remove(value);
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("unitPrice")) {
                this.unitPrice = null;
            } else if (name.equals("factor")) {
                this.factor = null;
            } else if (name.equals("tax")) {
                this.tax = null;
            } else if (name.equals("net")) {
                this.net = null;
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().remove(value);
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().remove((AdjudicationComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 82505966: {
                    return this.addTraceNumber();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 1957227299: {
                    return this.getProductOrService();
                }
                case -717476168: {
                    return this.getProductOrServiceEnd();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 114603: {
                    return this.getTax();
                }
                case 108957: {
                    return this.getNet();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -51825446: {
                    return this.getReviewOutcome();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 82505966: {
                    return new String[]{"Identifier"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957227299: {
                    return new String[]{"CodeableConcept"};
                }
                case -717476168: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 114603: {
                    return new String[]{"Money"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -51825446: {
                    return new String[]{"@ClaimResponse.item.reviewOutcome"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("traceNumber")) {
                return this.addTraceNumber();
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("productOrService")) {
                this.productOrService = new CodeableConcept();
                return this.productOrService;
            }
            if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = new CodeableConcept();
                return this.productOrServiceEnd;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.detail.subDetail.factor");
            }
            if (name.equals("tax")) {
                this.tax = new Money();
                return this.tax;
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.detail.subDetail.noteNumber");
            }
            if (name.equals("reviewOutcome")) {
                this.reviewOutcome = new ReviewOutcomeComponent();
                return this.reviewOutcome;
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemSubDetailComponent copy() {
            AddedItemSubDetailComponent dst = new AddedItemSubDetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AddedItemSubDetailComponent dst) {
            super.copyValues(dst);
            if (this.traceNumber != null) {
                dst.traceNumber = new ArrayList<Identifier>();
                for (Identifier identifier : this.traceNumber) {
                    dst.traceNumber.add(identifier.copy());
                }
            }
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.productOrService = this.productOrService == null ? null : this.productOrService.copy();
            CodeableConcept codeableConcept = dst.productOrServiceEnd = this.productOrServiceEnd == null ? null : this.productOrServiceEnd.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.tax = this.tax == null ? null : this.tax.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            ReviewOutcomeComponent reviewOutcomeComponent = dst.reviewOutcome = this.reviewOutcome == null ? null : this.reviewOutcome.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemSubDetailComponent)) {
                return false;
            }
            AddedItemSubDetailComponent o = (AddedItemSubDetailComponent)other_;
            return AddedItemSubDetailComponent.compareDeep(this.traceNumber, o.traceNumber, true) && AddedItemSubDetailComponent.compareDeep(this.revenue, o.revenue, true) && AddedItemSubDetailComponent.compareDeep(this.productOrService, o.productOrService, true) && AddedItemSubDetailComponent.compareDeep(this.productOrServiceEnd, o.productOrServiceEnd, true) && AddedItemSubDetailComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemSubDetailComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemSubDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemSubDetailComponent.compareDeep(this.factor, o.factor, true) && AddedItemSubDetailComponent.compareDeep(this.tax, o.tax, true) && AddedItemSubDetailComponent.compareDeep(this.net, o.net, true) && AddedItemSubDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemSubDetailComponent.compareDeep(this.reviewOutcome, o.reviewOutcome, true) && AddedItemSubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemSubDetailComponent)) {
                return false;
            }
            AddedItemSubDetailComponent o = (AddedItemSubDetailComponent)other_;
            return AddedItemSubDetailComponent.compareValues(this.factor, o.factor, true) && AddedItemSubDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.traceNumber, this.revenue, this.productOrService, this.productOrServiceEnd, this.modifier, this.quantity, this.unitPrice, this.factor, this.tax, this.net, this.noteNumber, this.reviewOutcome, this.adjudication});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem.detail.subDetail";
        }
    }

    @Block
    public static class AddedItemDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="traceNumber", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Number for tracking", formalDefinition="Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.")
        protected List<Identifier> traceNumber;
        @Child(name="revenue", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="productOrService", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing, service, product, or drug code", formalDefinition="When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrService;
        @Child(name="productOrServiceEnd", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="End of a range of codes", formalDefinition="This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrServiceEnd;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes to convey additional context for the product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="quantity", type={Quantity.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of products or services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per item", formalDefinition="If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="tax", type={Money.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total tax", formalDefinition="The total of taxes applicable for this product or service.")
        protected Money tax;
        @Child(name="net", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The total amount claimed for the group (if a grouper) or the addItem.detail. Net = unit price * quantity * factor.")
        protected Money net;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable note numbers", formalDefinition="The numbers associated with notes below which apply to the adjudication of this item.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="reviewOutcome", type={ReviewOutcomeComponent.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Added items detail level adjudication results", formalDefinition="The high-level results of the adjudication if adjudication has been performed.")
        protected ReviewOutcomeComponent reviewOutcome;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items detail adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Insurer added line items", formalDefinition="The third-tier service adjudications for payor added services.")
        protected List<AddedItemSubDetailComponent> subDetail;
        private static final long serialVersionUID = 1574685043L;

        public List<Identifier> getTraceNumber() {
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            return this.traceNumber;
        }

        public AddedItemDetailComponent setTraceNumber(List<Identifier> theTraceNumber) {
            this.traceNumber = theTraceNumber;
            return this;
        }

        public boolean hasTraceNumber() {
            if (this.traceNumber == null) {
                return false;
            }
            for (Identifier item : this.traceNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addTraceNumber() {
            Identifier t = new Identifier();
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return t;
        }

        public AddedItemDetailComponent addTraceNumber(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return this;
        }

        public Identifier getTraceNumberFirstRep() {
            if (this.getTraceNumber().isEmpty()) {
                this.addTraceNumber();
            }
            return this.getTraceNumber().get(0);
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public AddedItemDetailComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getProductOrService() {
            if (this.productOrService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.productOrService");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrService = new CodeableConcept();
                }
            }
            return this.productOrService;
        }

        public boolean hasProductOrService() {
            return this.productOrService != null && !this.productOrService.isEmpty();
        }

        public AddedItemDetailComponent setProductOrService(CodeableConcept value) {
            this.productOrService = value;
            return this;
        }

        public CodeableConcept getProductOrServiceEnd() {
            if (this.productOrServiceEnd == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.productOrServiceEnd");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrServiceEnd = new CodeableConcept();
                }
            }
            return this.productOrServiceEnd;
        }

        public boolean hasProductOrServiceEnd() {
            return this.productOrServiceEnd != null && !this.productOrServiceEnd.isEmpty();
        }

        public AddedItemDetailComponent setProductOrServiceEnd(CodeableConcept value) {
            this.productOrServiceEnd = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getTax() {
            if (this.tax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.tax");
                }
                if (Configuration.doAutoCreate()) {
                    this.tax = new Money();
                }
            }
            return this.tax;
        }

        public boolean hasTax() {
            return this.tax != null && !this.tax.isEmpty();
        }

        public AddedItemDetailComponent setTax(Money value) {
            this.tax = value;
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public ReviewOutcomeComponent getReviewOutcome() {
            if (this.reviewOutcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailComponent.reviewOutcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.reviewOutcome = new ReviewOutcomeComponent();
                }
            }
            return this.reviewOutcome;
        }

        public boolean hasReviewOutcome() {
            return this.reviewOutcome != null && !this.reviewOutcome.isEmpty();
        }

        public AddedItemDetailComponent setReviewOutcome(ReviewOutcomeComponent value) {
            this.reviewOutcome = value;
            return this;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<AddedItemSubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemSubDetailComponent>();
            }
            return this.subDetail;
        }

        public AddedItemDetailComponent setSubDetail(List<AddedItemSubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (AddedItemSubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemSubDetailComponent addSubDetail() {
            AddedItemSubDetailComponent t = new AddedItemSubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemSubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public AddedItemDetailComponent addSubDetail(AddedItemSubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<AddedItemSubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public AddedItemSubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.", 0, 1, this.productOrService));
            children.add(new Property("productOrServiceEnd", "CodeableConcept", "This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.", 0, 1, this.productOrServiceEnd));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("quantity", "Quantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("tax", "Money", "The total of taxes applicable for this product or service.", 0, 1, this.tax));
            children.add(new Property("net", "Money", "The total amount claimed for the group (if a grouper) or the addItem.detail. Net = unit price * quantity * factor.", 0, 1, this.net));
            children.add(new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("subDetail", "", "The third-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 82505966: {
                    return new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 1957227299: {
                    return new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.", 0, 1, this.productOrService);
                }
                case -717476168: {
                    return new Property("productOrServiceEnd", "CodeableConcept", "This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.", 0, 1, this.productOrServiceEnd);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 114603: {
                    return new Property("tax", "Money", "The total of taxes applicable for this product or service.", 0, 1, this.tax);
                }
                case 108957: {
                    return new Property("net", "Money", "The total amount claimed for the group (if a grouper) or the addItem.detail. Net = unit price * quantity * factor.", 0, 1, this.net);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -51825446: {
                    return new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -828829007: {
                    return new Property("subDetail", "", "The third-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 82505966: {
                    return this.traceNumber == null ? new Base[]{} : this.traceNumber.toArray(new Base[this.traceNumber.size()]);
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 1957227299: {
                    Base[] baseArray;
                    if (this.productOrService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.productOrService;
                    }
                    return baseArray;
                }
                case -717476168: {
                    Base[] baseArray;
                    if (this.productOrServiceEnd == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.productOrServiceEnd;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.factor;
                    }
                    return baseArray;
                }
                case 114603: {
                    Base[] baseArray;
                    if (this.tax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.tax;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -51825446: {
                    Base[] baseArray;
                    if (this.reviewOutcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.reviewOutcome;
                    }
                    return baseArray;
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 82505966: {
                    this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case 1099842588: {
                    this.revenue = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1957227299: {
                    this.productOrService = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -717476168: {
                    this.productOrServiceEnd = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = TypeConvertor.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 114603: {
                    this.tax = TypeConvertor.castToMoney(value);
                    return value;
                }
                case 108957: {
                    this.net = TypeConvertor.castToMoney(value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case -51825446: {
                    this.reviewOutcome = (ReviewOutcomeComponent)value;
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((AddedItemSubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("traceNumber")) {
                this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("revenue")) {
                this.revenue = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("productOrService")) {
                this.productOrService = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = TypeConvertor.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = TypeConvertor.castToDecimal(value);
            } else if (name.equals("tax")) {
                this.tax = TypeConvertor.castToMoney(value);
            } else if (name.equals("net")) {
                this.net = TypeConvertor.castToMoney(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((AddedItemSubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("traceNumber")) {
                this.getTraceNumber().remove(value);
            } else if (name.equals("revenue")) {
                this.revenue = null;
            } else if (name.equals("productOrService")) {
                this.productOrService = null;
            } else if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = null;
            } else if (name.equals("modifier")) {
                this.getModifier().remove(value);
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("unitPrice")) {
                this.unitPrice = null;
            } else if (name.equals("factor")) {
                this.factor = null;
            } else if (name.equals("tax")) {
                this.tax = null;
            } else if (name.equals("net")) {
                this.net = null;
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().remove(value);
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().remove((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().remove((AddedItemSubDetailComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 82505966: {
                    return this.addTraceNumber();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 1957227299: {
                    return this.getProductOrService();
                }
                case -717476168: {
                    return this.getProductOrServiceEnd();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 114603: {
                    return this.getTax();
                }
                case 108957: {
                    return this.getNet();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -51825446: {
                    return this.getReviewOutcome();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 82505966: {
                    return new String[]{"Identifier"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957227299: {
                    return new String[]{"CodeableConcept"};
                }
                case -717476168: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 114603: {
                    return new String[]{"Money"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -51825446: {
                    return new String[]{"@ClaimResponse.item.reviewOutcome"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("traceNumber")) {
                return this.addTraceNumber();
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("productOrService")) {
                this.productOrService = new CodeableConcept();
                return this.productOrService;
            }
            if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = new CodeableConcept();
                return this.productOrServiceEnd;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.detail.factor");
            }
            if (name.equals("tax")) {
                this.tax = new Money();
                return this.tax;
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.detail.noteNumber");
            }
            if (name.equals("reviewOutcome")) {
                this.reviewOutcome = new ReviewOutcomeComponent();
                return this.reviewOutcome;
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemDetailComponent copy() {
            AddedItemDetailComponent dst = new AddedItemDetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AddedItemDetailComponent dst) {
            super.copyValues(dst);
            if (this.traceNumber != null) {
                dst.traceNumber = new ArrayList<Identifier>();
                for (Identifier identifier : this.traceNumber) {
                    dst.traceNumber.add(identifier.copy());
                }
            }
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.productOrService = this.productOrService == null ? null : this.productOrService.copy();
            CodeableConcept codeableConcept = dst.productOrServiceEnd = this.productOrServiceEnd == null ? null : this.productOrServiceEnd.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.tax = this.tax == null ? null : this.tax.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            ReviewOutcomeComponent reviewOutcomeComponent = dst.reviewOutcome = this.reviewOutcome == null ? null : this.reviewOutcome.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<AddedItemSubDetailComponent>();
                for (AddedItemSubDetailComponent addedItemSubDetailComponent : this.subDetail) {
                    dst.subDetail.add(addedItemSubDetailComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemDetailComponent)) {
                return false;
            }
            AddedItemDetailComponent o = (AddedItemDetailComponent)other_;
            return AddedItemDetailComponent.compareDeep(this.traceNumber, o.traceNumber, true) && AddedItemDetailComponent.compareDeep(this.revenue, o.revenue, true) && AddedItemDetailComponent.compareDeep(this.productOrService, o.productOrService, true) && AddedItemDetailComponent.compareDeep(this.productOrServiceEnd, o.productOrServiceEnd, true) && AddedItemDetailComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemDetailComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemDetailComponent.compareDeep(this.factor, o.factor, true) && AddedItemDetailComponent.compareDeep(this.tax, o.tax, true) && AddedItemDetailComponent.compareDeep(this.net, o.net, true) && AddedItemDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemDetailComponent.compareDeep(this.reviewOutcome, o.reviewOutcome, true) && AddedItemDetailComponent.compareDeep(this.adjudication, o.adjudication, true) && AddedItemDetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemDetailComponent)) {
                return false;
            }
            AddedItemDetailComponent o = (AddedItemDetailComponent)other_;
            return AddedItemDetailComponent.compareValues(this.factor, o.factor, true) && AddedItemDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.traceNumber, this.revenue, this.productOrService, this.productOrServiceEnd, this.modifier, this.quantity, this.unitPrice, this.factor, this.tax, this.net, this.noteNumber, this.reviewOutcome, this.adjudication, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem.detail";
        }
    }

    @Block
    public static class BodySiteComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="site", type={CodeableReference.class}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Location", formalDefinition="Physical service site on the patient (limb, tooth, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/tooth")
        protected List<CodeableReference> site;
        @Child(name="subSite", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Sub-location", formalDefinition="A region or surface of the bodySite, e.g. limb region or tooth surface(s).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/surface")
        protected List<CodeableConcept> subSite;
        private static final long serialVersionUID = 1190632415L;

        public BodySiteComponent() {
        }

        public BodySiteComponent(CodeableReference site) {
            this.addSite(site);
        }

        public List<CodeableReference> getSite() {
            if (this.site == null) {
                this.site = new ArrayList<CodeableReference>();
            }
            return this.site;
        }

        public BodySiteComponent setSite(List<CodeableReference> theSite) {
            this.site = theSite;
            return this;
        }

        public boolean hasSite() {
            if (this.site == null) {
                return false;
            }
            for (CodeableReference item : this.site) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addSite() {
            CodeableReference t = new CodeableReference();
            if (this.site == null) {
                this.site = new ArrayList<CodeableReference>();
            }
            this.site.add(t);
            return t;
        }

        public BodySiteComponent addSite(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.site == null) {
                this.site = new ArrayList<CodeableReference>();
            }
            this.site.add(t);
            return this;
        }

        public CodeableReference getSiteFirstRep() {
            if (this.getSite().isEmpty()) {
                this.addSite();
            }
            return this.getSite().get(0);
        }

        public List<CodeableConcept> getSubSite() {
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            return this.subSite;
        }

        public BodySiteComponent setSubSite(List<CodeableConcept> theSubSite) {
            this.subSite = theSubSite;
            return this;
        }

        public boolean hasSubSite() {
            if (this.subSite == null) {
                return false;
            }
            for (CodeableConcept item : this.subSite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSubSite() {
            CodeableConcept t = new CodeableConcept();
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return t;
        }

        public BodySiteComponent addSubSite(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return this;
        }

        public CodeableConcept getSubSiteFirstRep() {
            if (this.getSubSite().isEmpty()) {
                this.addSubSite();
            }
            return this.getSubSite().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("site", "CodeableReference(BodyStructure)", "Physical service site on the patient (limb, tooth, etc.).", 0, Integer.MAX_VALUE, this.site));
            children.add(new Property("subSite", "CodeableConcept", "A region or surface of the bodySite, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3530567: {
                    return new Property("site", "CodeableReference(BodyStructure)", "Physical service site on the patient (limb, tooth, etc.).", 0, Integer.MAX_VALUE, this.site);
                }
                case -1868566105: {
                    return new Property("subSite", "CodeableConcept", "A region or surface of the bodySite, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    return this.site == null ? new Base[]{} : this.site.toArray(new Base[this.site.size()]);
                }
                case -1868566105: {
                    return this.subSite == null ? new Base[]{} : this.subSite.toArray(new Base[this.subSite.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    this.getSite().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case -1868566105: {
                    this.getSubSite().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("site")) {
                this.getSite().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("subSite")) {
                this.getSubSite().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("site")) {
                this.getSite().remove(value);
            } else if (name.equals("subSite")) {
                this.getSubSite().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    return this.addSite();
                }
                case -1868566105: {
                    return this.addSubSite();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    return new String[]{"CodeableReference"};
                }
                case -1868566105: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("site")) {
                return this.addSite();
            }
            if (name.equals("subSite")) {
                return this.addSubSite();
            }
            return super.addChild(name);
        }

        @Override
        public BodySiteComponent copy() {
            BodySiteComponent dst = new BodySiteComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BodySiteComponent dst) {
            super.copyValues(dst);
            if (this.site != null) {
                dst.site = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.site) {
                    dst.site.add(codeableReference.copy());
                }
            }
            if (this.subSite != null) {
                dst.subSite = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.subSite) {
                    dst.subSite.add(codeableConcept.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BodySiteComponent)) {
                return false;
            }
            BodySiteComponent o = (BodySiteComponent)other_;
            return BodySiteComponent.compareDeep(this.site, o.site, true) && BodySiteComponent.compareDeep(this.subSite, o.subSite, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BodySiteComponent)) {
                return false;
            }
            BodySiteComponent o = (BodySiteComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.site, this.subSite});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem.bodySite";
        }
    }

    @Block
    public static class AddedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="itemSequence", type={PositiveIntType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Item sequence number", formalDefinition="Claim items which this service line is intended to replace.")
        protected List<PositiveIntType> itemSequence;
        @Child(name="detailSequence", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail sequence number", formalDefinition="The sequence number of the details within the claim item which this line is intended to replace.")
        protected List<PositiveIntType> detailSequence;
        @Child(name="subdetailSequence", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail sequence number", formalDefinition="The sequence number of the sub-details within the details within the claim item which this line is intended to replace.")
        protected List<PositiveIntType> subdetailSequence;
        @Child(name="traceNumber", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Number for tracking", formalDefinition="Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.")
        protected List<Identifier> traceNumber;
        @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Authorized providers", formalDefinition="The providers who are authorized for the services rendered to the patient.")
        protected List<Reference> provider;
        @Child(name="revenue", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="productOrService", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing, service, product, or drug code", formalDefinition="When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrService;
        @Child(name="productOrServiceEnd", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="End of a range of codes", formalDefinition="This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrServiceEnd;
        @Child(name="request", type={DeviceRequest.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class, SupplyRequest.class, VisionPrescription.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Request or Referral for Service", formalDefinition="Request or Referral for Goods or Service to be rendered.")
        protected List<Reference> request;
        @Child(name="modifier", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes to convey additional context for the product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program the product or service is provided under", formalDefinition="Identifies the program under which this may be recovered.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="serviced", type={DateType.class, Period.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date or dates of service or product delivery", formalDefinition="The date or dates when the service or product was supplied, performed or completed.")
        protected DataType serviced;
        @Child(name="location", type={CodeableConcept.class, Address.class, Location.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Place of service or where product was supplied", formalDefinition="Where the product or service was provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-place")
        protected DataType location;
        @Child(name="quantity", type={Quantity.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of products or services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per item", formalDefinition="If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="tax", type={Money.class}, order=17, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total tax", formalDefinition="The total of taxes applicable for this product or service.")
        protected Money tax;
        @Child(name="net", type={Money.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The total amount claimed for the group (if a grouper) or the addItem. Net = unit price * quantity * factor.")
        protected Money net;
        @Child(name="bodySite", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Anatomical location", formalDefinition="Physical location where the service is performed or applies.")
        protected List<BodySiteComponent> bodySite;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=20, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable note numbers", formalDefinition="The numbers associated with notes below which apply to the adjudication of this item.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="reviewOutcome", type={ReviewOutcomeComponent.class}, order=21, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Added items adjudication results", formalDefinition="The high-level results of the adjudication if adjudication has been performed.")
        protected ReviewOutcomeComponent reviewOutcome;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=22, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Added items adjudication", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Insurer added line details", formalDefinition="The second-tier service adjudications for payor added services.")
        protected List<AddedItemDetailComponent> detail;
        private static final long serialVersionUID = 520179532L;

        public List<PositiveIntType> getItemSequence() {
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            return this.itemSequence;
        }

        public AddedItemComponent setItemSequence(List<PositiveIntType> theItemSequence) {
            this.itemSequence = theItemSequence;
            return this;
        }

        public boolean hasItemSequence() {
            if (this.itemSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.itemSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addItemSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            this.itemSequence.add(t);
            return t;
        }

        public AddedItemComponent addItemSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.itemSequence == null) {
                this.itemSequence = new ArrayList<PositiveIntType>();
            }
            this.itemSequence.add(t);
            return this;
        }

        public boolean hasItemSequence(int value) {
            if (this.itemSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.itemSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getDetailSequence() {
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            return this.detailSequence;
        }

        public AddedItemComponent setDetailSequence(List<PositiveIntType> theDetailSequence) {
            this.detailSequence = theDetailSequence;
            return this;
        }

        public boolean hasDetailSequence() {
            if (this.detailSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.detailSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDetailSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            this.detailSequence.add(t);
            return t;
        }

        public AddedItemComponent addDetailSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.detailSequence == null) {
                this.detailSequence = new ArrayList<PositiveIntType>();
            }
            this.detailSequence.add(t);
            return this;
        }

        public boolean hasDetailSequence(int value) {
            if (this.detailSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.detailSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getSubdetailSequence() {
            if (this.subdetailSequence == null) {
                this.subdetailSequence = new ArrayList<PositiveIntType>();
            }
            return this.subdetailSequence;
        }

        public AddedItemComponent setSubdetailSequence(List<PositiveIntType> theSubdetailSequence) {
            this.subdetailSequence = theSubdetailSequence;
            return this;
        }

        public boolean hasSubdetailSequence() {
            if (this.subdetailSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.subdetailSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addSubdetailSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.subdetailSequence == null) {
                this.subdetailSequence = new ArrayList<PositiveIntType>();
            }
            this.subdetailSequence.add(t);
            return t;
        }

        public AddedItemComponent addSubdetailSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.subdetailSequence == null) {
                this.subdetailSequence = new ArrayList<PositiveIntType>();
            }
            this.subdetailSequence.add(t);
            return this;
        }

        public boolean hasSubdetailSequence(int value) {
            if (this.subdetailSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.subdetailSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Identifier> getTraceNumber() {
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            return this.traceNumber;
        }

        public AddedItemComponent setTraceNumber(List<Identifier> theTraceNumber) {
            this.traceNumber = theTraceNumber;
            return this;
        }

        public boolean hasTraceNumber() {
            if (this.traceNumber == null) {
                return false;
            }
            for (Identifier item : this.traceNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addTraceNumber() {
            Identifier t = new Identifier();
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return t;
        }

        public AddedItemComponent addTraceNumber(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return this;
        }

        public Identifier getTraceNumberFirstRep() {
            if (this.getTraceNumber().isEmpty()) {
                this.addTraceNumber();
            }
            return this.getTraceNumber().get(0);
        }

        public List<Reference> getProvider() {
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            return this.provider;
        }

        public AddedItemComponent setProvider(List<Reference> theProvider) {
            this.provider = theProvider;
            return this;
        }

        public boolean hasProvider() {
            if (this.provider == null) {
                return false;
            }
            for (Reference item : this.provider) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addProvider() {
            Reference t = new Reference();
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            this.provider.add(t);
            return t;
        }

        public AddedItemComponent addProvider(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.provider == null) {
                this.provider = new ArrayList<Reference>();
            }
            this.provider.add(t);
            return this;
        }

        public Reference getProviderFirstRep() {
            if (this.getProvider().isEmpty()) {
                this.addProvider();
            }
            return this.getProvider().get(0);
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public AddedItemComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getProductOrService() {
            if (this.productOrService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.productOrService");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrService = new CodeableConcept();
                }
            }
            return this.productOrService;
        }

        public boolean hasProductOrService() {
            return this.productOrService != null && !this.productOrService.isEmpty();
        }

        public AddedItemComponent setProductOrService(CodeableConcept value) {
            this.productOrService = value;
            return this;
        }

        public CodeableConcept getProductOrServiceEnd() {
            if (this.productOrServiceEnd == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.productOrServiceEnd");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrServiceEnd = new CodeableConcept();
                }
            }
            return this.productOrServiceEnd;
        }

        public boolean hasProductOrServiceEnd() {
            return this.productOrServiceEnd != null && !this.productOrServiceEnd.isEmpty();
        }

        public AddedItemComponent setProductOrServiceEnd(CodeableConcept value) {
            this.productOrServiceEnd = value;
            return this;
        }

        public List<Reference> getRequest() {
            if (this.request == null) {
                this.request = new ArrayList<Reference>();
            }
            return this.request;
        }

        public AddedItemComponent setRequest(List<Reference> theRequest) {
            this.request = theRequest;
            return this;
        }

        public boolean hasRequest() {
            if (this.request == null) {
                return false;
            }
            for (Reference item : this.request) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addRequest() {
            Reference t = new Reference();
            if (this.request == null) {
                this.request = new ArrayList<Reference>();
            }
            this.request.add(t);
            return t;
        }

        public AddedItemComponent addRequest(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.request == null) {
                this.request = new ArrayList<Reference>();
            }
            this.request.add(t);
            return this;
        }

        public Reference getRequestFirstRep() {
            if (this.getRequest().isEmpty()) {
                this.addRequest();
            }
            return this.getRequest().get(0);
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public AddedItemComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public AddedItemComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public AddedItemComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public AddedItemComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public DataType getServiced() {
            return this.serviced;
        }

        public DateType getServicedDateType() throws FHIRException {
            if (this.serviced == null) {
                this.serviced = new DateType();
            }
            if (!(this.serviced instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (DateType)this.serviced;
        }

        public boolean hasServicedDateType() {
            return this != null && this.serviced instanceof DateType;
        }

        public Period getServicedPeriod() throws FHIRException {
            if (this.serviced == null) {
                this.serviced = new Period();
            }
            if (!(this.serviced instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (Period)this.serviced;
        }

        public boolean hasServicedPeriod() {
            return this != null && this.serviced instanceof Period;
        }

        public boolean hasServiced() {
            return this.serviced != null && !this.serviced.isEmpty();
        }

        public AddedItemComponent setServiced(DataType value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new FHIRException("Not the right type for ClaimResponse.addItem.serviced[x]: " + value.fhirType());
            }
            this.serviced = value;
            return this;
        }

        public DataType getLocation() {
            return this.location;
        }

        public CodeableConcept getLocationCodeableConcept() throws FHIRException {
            if (this.location == null) {
                this.location = new CodeableConcept();
            }
            if (!(this.location instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.location;
        }

        public boolean hasLocationCodeableConcept() {
            return this != null && this.location instanceof CodeableConcept;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                this.location = new Address();
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                this.location = new Reference();
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AddedItemComponent setLocation(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Address || value instanceof Reference)) {
                throw new FHIRException("Not the right type for ClaimResponse.addItem.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AddedItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public AddedItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public AddedItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public AddedItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public AddedItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public AddedItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getTax() {
            if (this.tax == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.tax");
                }
                if (Configuration.doAutoCreate()) {
                    this.tax = new Money();
                }
            }
            return this.tax;
        }

        public boolean hasTax() {
            return this.tax != null && !this.tax.isEmpty();
        }

        public AddedItemComponent setTax(Money value) {
            this.tax = value;
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public AddedItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<BodySiteComponent> getBodySite() {
            if (this.bodySite == null) {
                this.bodySite = new ArrayList<BodySiteComponent>();
            }
            return this.bodySite;
        }

        public AddedItemComponent setBodySite(List<BodySiteComponent> theBodySite) {
            this.bodySite = theBodySite;
            return this;
        }

        public boolean hasBodySite() {
            if (this.bodySite == null) {
                return false;
            }
            for (BodySiteComponent item : this.bodySite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BodySiteComponent addBodySite() {
            BodySiteComponent t = new BodySiteComponent();
            if (this.bodySite == null) {
                this.bodySite = new ArrayList<BodySiteComponent>();
            }
            this.bodySite.add(t);
            return t;
        }

        public AddedItemComponent addBodySite(BodySiteComponent t) {
            if (t == null) {
                return this;
            }
            if (this.bodySite == null) {
                this.bodySite = new ArrayList<BodySiteComponent>();
            }
            this.bodySite.add(t);
            return this;
        }

        public BodySiteComponent getBodySiteFirstRep() {
            if (this.getBodySite().isEmpty()) {
                this.addBodySite();
            }
            return this.getBodySite().get(0);
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public AddedItemComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public AddedItemComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public ReviewOutcomeComponent getReviewOutcome() {
            if (this.reviewOutcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.reviewOutcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.reviewOutcome = new ReviewOutcomeComponent();
                }
            }
            return this.reviewOutcome;
        }

        public boolean hasReviewOutcome() {
            return this.reviewOutcome != null && !this.reviewOutcome.isEmpty();
        }

        public AddedItemComponent setReviewOutcome(ReviewOutcomeComponent value) {
            this.reviewOutcome = value;
            return this;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public AddedItemComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<AddedItemDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            return this.detail;
        }

        public AddedItemComponent setDetail(List<AddedItemDetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (AddedItemDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemDetailComponent addDetail() {
            AddedItemDetailComponent t = new AddedItemDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public AddedItemComponent addDetail(AddedItemDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public AddedItemDetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("itemSequence", "positiveInt", "Claim items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.itemSequence));
            children.add(new Property("detailSequence", "positiveInt", "The sequence number of the details within the claim item which this line is intended to replace.", 0, Integer.MAX_VALUE, this.detailSequence));
            children.add(new Property("subdetailSequence", "positiveInt", "The sequence number of the sub-details within the details within the claim item which this line is intended to replace.", 0, Integer.MAX_VALUE, this.subdetailSequence));
            children.add(new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber));
            children.add(new Property("provider", "Reference(Practitioner|PractitionerRole|Organization)", "The providers who are authorized for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.", 0, 1, this.productOrService));
            children.add(new Property("productOrServiceEnd", "CodeableConcept", "This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.", 0, 1, this.productOrServiceEnd));
            children.add(new Property(ClaimResponse.SP_REQUEST, "Reference(DeviceRequest|MedicationRequest|NutritionOrder|ServiceRequest|SupplyRequest|VisionPrescription)", "Request or Referral for Goods or Service to be rendered.", 0, Integer.MAX_VALUE, this.request));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "Identifies the program under which this may be recovered.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced));
            children.add(new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location));
            children.add(new Property("quantity", "Quantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("tax", "Money", "The total of taxes applicable for this product or service.", 0, 1, this.tax));
            children.add(new Property("net", "Money", "The total amount claimed for the group (if a grouper) or the addItem. Net = unit price * quantity * factor.", 0, 1, this.net));
            children.add(new Property("bodySite", "", "Physical location where the service is performed or applies.", 0, Integer.MAX_VALUE, this.bodySite));
            children.add(new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("detail", "", "The second-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1977979892: {
                    return new Property("itemSequence", "positiveInt", "Claim items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.itemSequence);
                }
                case 1321472818: {
                    return new Property("detailSequence", "positiveInt", "The sequence number of the details within the claim item which this line is intended to replace.", 0, Integer.MAX_VALUE, this.detailSequence);
                }
                case 146530674: {
                    return new Property("subdetailSequence", "positiveInt", "The sequence number of the sub-details within the details within the claim item which this line is intended to replace.", 0, Integer.MAX_VALUE, this.subdetailSequence);
                }
                case 82505966: {
                    return new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber);
                }
                case -987494927: {
                    return new Property("provider", "Reference(Practitioner|PractitionerRole|Organization)", "The providers who are authorized for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 1957227299: {
                    return new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related item details, otherwise this contains the product, service, drug or other billing code for the item. This element may be the start of a range of .productOrService codes used in conjunction with .productOrServiceEnd or it may be a solo element where .productOrServiceEnd is not used.", 0, 1, this.productOrService);
                }
                case -717476168: {
                    return new Property("productOrServiceEnd", "CodeableConcept", "This contains the end of a range of product, service, drug or other billing codes for the item. This element is not used when the .productOrService is a group code. This value may only be present when a .productOfService code has been provided to convey the start of the range. Typically this value may be used only with preauthorizations and not with claims.", 0, 1, this.productOrServiceEnd);
                }
                case 1095692943: {
                    return new Property(ClaimResponse.SP_REQUEST, "Reference(DeviceRequest|MedicationRequest|NutritionOrder|ServiceRequest|SupplyRequest|VisionPrescription)", "Request or Referral for Goods or Service to be rendered.", 0, Integer.MAX_VALUE, this.request);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "Identifies the program under which this may be recovered.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1927922223: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1379209295: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 363246749: {
                    return new Property("serviced[x]", "date", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1534966512: {
                    return new Property("serviced[x]", "Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 552316075: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location);
                }
                case -1224800468: {
                    return new Property("location[x]", "CodeableConcept", "Where the product or service was provided.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "Address", "Where the product or service was provided.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "Reference(Location)", "Where the product or service was provided.", 0, 1, this.location);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 114603: {
                    return new Property("tax", "Money", "The total of taxes applicable for this product or service.", 0, 1, this.tax);
                }
                case 108957: {
                    return new Property("net", "Money", "The total amount claimed for the group (if a grouper) or the addItem. Net = unit price * quantity * factor.", 0, 1, this.net);
                }
                case 1702620169: {
                    return new Property("bodySite", "", "Physical location where the service is performed or applies.", 0, Integer.MAX_VALUE, this.bodySite);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -51825446: {
                    return new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -1335224239: {
                    return new Property("detail", "", "The second-tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.itemSequence == null ? new Base[]{} : this.itemSequence.toArray(new Base[this.itemSequence.size()]);
                }
                case 1321472818: {
                    return this.detailSequence == null ? new Base[]{} : this.detailSequence.toArray(new Base[this.detailSequence.size()]);
                }
                case 146530674: {
                    return this.subdetailSequence == null ? new Base[]{} : this.subdetailSequence.toArray(new Base[this.subdetailSequence.size()]);
                }
                case 82505966: {
                    return this.traceNumber == null ? new Base[]{} : this.traceNumber.toArray(new Base[this.traceNumber.size()]);
                }
                case -987494927: {
                    return this.provider == null ? new Base[]{} : this.provider.toArray(new Base[this.provider.size()]);
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 1957227299: {
                    Base[] baseArray;
                    if (this.productOrService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.productOrService;
                    }
                    return baseArray;
                }
                case -717476168: {
                    Base[] baseArray;
                    if (this.productOrServiceEnd == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.productOrServiceEnd;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    return this.request == null ? new Base[]{} : this.request.toArray(new Base[this.request.size()]);
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case 1379209295: {
                    Base[] baseArray;
                    if (this.serviced == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.serviced;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.location;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.factor;
                    }
                    return baseArray;
                }
                case 114603: {
                    Base[] baseArray;
                    if (this.tax == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.tax;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.net;
                    }
                    return baseArray;
                }
                case 1702620169: {
                    return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -51825446: {
                    Base[] baseArray;
                    if (this.reviewOutcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.reviewOutcome;
                    }
                    return baseArray;
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    this.getItemSequence().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case 1321472818: {
                    this.getDetailSequence().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case 146530674: {
                    this.getSubdetailSequence().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case 82505966: {
                    this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -987494927: {
                    this.getProvider().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 1099842588: {
                    this.revenue = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1957227299: {
                    this.productOrService = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -717476168: {
                    this.productOrServiceEnd = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1095692943: {
                    this.getRequest().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1379209295: {
                    this.serviced = TypeConvertor.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToType(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = TypeConvertor.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 114603: {
                    this.tax = TypeConvertor.castToMoney(value);
                    return value;
                }
                case 108957: {
                    this.net = TypeConvertor.castToMoney(value);
                    return value;
                }
                case 1702620169: {
                    this.getBodySite().add((BodySiteComponent)value);
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case -51825446: {
                    this.reviewOutcome = (ReviewOutcomeComponent)value;
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((AddedItemDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.getItemSequence().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("detailSequence")) {
                this.getDetailSequence().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("subdetailSequence")) {
                this.getSubdetailSequence().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("traceNumber")) {
                this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("provider")) {
                this.getProvider().add(TypeConvertor.castToReference(value));
            } else if (name.equals("revenue")) {
                this.revenue = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("productOrService")) {
                this.productOrService = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(ClaimResponse.SP_REQUEST)) {
                this.getRequest().add(TypeConvertor.castToReference(value));
            } else if (name.equals("modifier")) {
                this.getModifier().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("serviced[x]")) {
                this.serviced = TypeConvertor.castToType(value);
            } else if (name.equals("location[x]")) {
                this.location = TypeConvertor.castToType(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = TypeConvertor.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = TypeConvertor.castToDecimal(value);
            } else if (name.equals("tax")) {
                this.tax = TypeConvertor.castToMoney(value);
            } else if (name.equals("net")) {
                this.net = TypeConvertor.castToMoney(value);
            } else if (name.equals("bodySite")) {
                this.getBodySite().add((BodySiteComponent)value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((AddedItemDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.getItemSequence().remove(value);
            } else if (name.equals("detailSequence")) {
                this.getDetailSequence().remove(value);
            } else if (name.equals("subdetailSequence")) {
                this.getSubdetailSequence().remove(value);
            } else if (name.equals("traceNumber")) {
                this.getTraceNumber().remove(value);
            } else if (name.equals("provider")) {
                this.getProvider().remove(value);
            } else if (name.equals("revenue")) {
                this.revenue = null;
            } else if (name.equals("productOrService")) {
                this.productOrService = null;
            } else if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = null;
            } else if (name.equals(ClaimResponse.SP_REQUEST)) {
                this.getRequest().remove(value);
            } else if (name.equals("modifier")) {
                this.getModifier().remove(value);
            } else if (name.equals("programCode")) {
                this.getProgramCode().remove(value);
            } else if (name.equals("serviced[x]")) {
                this.serviced = null;
            } else if (name.equals("location[x]")) {
                this.location = null;
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("unitPrice")) {
                this.unitPrice = null;
            } else if (name.equals("factor")) {
                this.factor = null;
            } else if (name.equals("tax")) {
                this.tax = null;
            } else if (name.equals("net")) {
                this.net = null;
            } else if (name.equals("bodySite")) {
                this.getBodySite().remove((BodySiteComponent)value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().remove(value);
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().remove((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().remove((AddedItemDetailComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.addItemSequenceElement();
                }
                case 1321472818: {
                    return this.addDetailSequenceElement();
                }
                case 146530674: {
                    return this.addSubdetailSequenceElement();
                }
                case 82505966: {
                    return this.addTraceNumber();
                }
                case -987494927: {
                    return this.addProvider();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 1957227299: {
                    return this.getProductOrService();
                }
                case -717476168: {
                    return this.getProductOrServiceEnd();
                }
                case 1095692943: {
                    return this.addRequest();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1927922223: {
                    return this.getServiced();
                }
                case 1379209295: {
                    return this.getServiced();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 114603: {
                    return this.getTax();
                }
                case 108957: {
                    return this.getNet();
                }
                case 1702620169: {
                    return this.addBodySite();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -51825446: {
                    return this.getReviewOutcome();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return new String[]{"positiveInt"};
                }
                case 1321472818: {
                    return new String[]{"positiveInt"};
                }
                case 146530674: {
                    return new String[]{"positiveInt"};
                }
                case 82505966: {
                    return new String[]{"Identifier"};
                }
                case -987494927: {
                    return new String[]{"Reference"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957227299: {
                    return new String[]{"CodeableConcept"};
                }
                case -717476168: {
                    return new String[]{"CodeableConcept"};
                }
                case 1095692943: {
                    return new String[]{"Reference"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case 1379209295: {
                    return new String[]{"date", "Period"};
                }
                case 1901043637: {
                    return new String[]{"CodeableConcept", "Address", "Reference"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 114603: {
                    return new String[]{"Money"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 1702620169: {
                    return new String[0];
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -51825446: {
                    return new String[]{"@ClaimResponse.item.reviewOutcome"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.itemSequence");
            }
            if (name.equals("detailSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.detailSequence");
            }
            if (name.equals("subdetailSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.subdetailSequence");
            }
            if (name.equals("traceNumber")) {
                return this.addTraceNumber();
            }
            if (name.equals("provider")) {
                return this.addProvider();
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("productOrService")) {
                this.productOrService = new CodeableConcept();
                return this.productOrService;
            }
            if (name.equals("productOrServiceEnd")) {
                this.productOrServiceEnd = new CodeableConcept();
                return this.productOrServiceEnd;
            }
            if (name.equals(ClaimResponse.SP_REQUEST)) {
                return this.addRequest();
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("servicedDate")) {
                this.serviced = new DateType();
                return this.serviced;
            }
            if (name.equals("servicedPeriod")) {
                this.serviced = new Period();
                return this.serviced;
            }
            if (name.equals("locationCodeableConcept")) {
                this.location = new CodeableConcept();
                return this.location;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.factor");
            }
            if (name.equals("tax")) {
                this.tax = new Money();
                return this.tax;
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("bodySite")) {
                return this.addBodySite();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.addItem.noteNumber");
            }
            if (name.equals("reviewOutcome")) {
                this.reviewOutcome = new ReviewOutcomeComponent();
                return this.reviewOutcome;
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemComponent copy() {
            AddedItemComponent dst = new AddedItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AddedItemComponent dst) {
            super.copyValues(dst);
            if (this.itemSequence != null) {
                dst.itemSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.itemSequence) {
                    dst.itemSequence.add(positiveIntType.copy());
                }
            }
            if (this.detailSequence != null) {
                dst.detailSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.detailSequence) {
                    dst.detailSequence.add(positiveIntType.copy());
                }
            }
            if (this.subdetailSequence != null) {
                dst.subdetailSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.subdetailSequence) {
                    dst.subdetailSequence.add(positiveIntType.copy());
                }
            }
            if (this.traceNumber != null) {
                dst.traceNumber = new ArrayList<Identifier>();
                for (Identifier identifier : this.traceNumber) {
                    dst.traceNumber.add(identifier.copy());
                }
            }
            if (this.provider != null) {
                dst.provider = new ArrayList<Reference>();
                for (Reference reference : this.provider) {
                    dst.provider.add(reference.copy());
                }
            }
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.productOrService = this.productOrService == null ? null : this.productOrService.copy();
            CodeableConcept codeableConcept = dst.productOrServiceEnd = this.productOrServiceEnd == null ? null : this.productOrServiceEnd.copy();
            if (this.request != null) {
                dst.request = new ArrayList<Reference>();
                for (Reference reference : this.request) {
                    dst.request.add(reference.copy());
                }
            }
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.serviced = this.serviced == null ? null : this.serviced.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.tax = this.tax == null ? null : this.tax.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.bodySite != null) {
                dst.bodySite = new ArrayList<BodySiteComponent>();
                for (BodySiteComponent bodySiteComponent : this.bodySite) {
                    dst.bodySite.add(bodySiteComponent.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType.copy());
                }
            }
            ReviewOutcomeComponent reviewOutcomeComponent = dst.reviewOutcome = this.reviewOutcome == null ? null : this.reviewOutcome.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<AddedItemDetailComponent>();
                for (AddedItemDetailComponent addedItemDetailComponent : this.detail) {
                    dst.detail.add(addedItemDetailComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other_;
            return AddedItemComponent.compareDeep(this.itemSequence, o.itemSequence, true) && AddedItemComponent.compareDeep(this.detailSequence, o.detailSequence, true) && AddedItemComponent.compareDeep(this.subdetailSequence, o.subdetailSequence, true) && AddedItemComponent.compareDeep(this.traceNumber, o.traceNumber, true) && AddedItemComponent.compareDeep(this.provider, o.provider, true) && AddedItemComponent.compareDeep(this.revenue, o.revenue, true) && AddedItemComponent.compareDeep(this.productOrService, o.productOrService, true) && AddedItemComponent.compareDeep(this.productOrServiceEnd, o.productOrServiceEnd, true) && AddedItemComponent.compareDeep(this.request, o.request, true) && AddedItemComponent.compareDeep(this.modifier, o.modifier, true) && AddedItemComponent.compareDeep(this.programCode, o.programCode, true) && AddedItemComponent.compareDeep(this.serviced, o.serviced, true) && AddedItemComponent.compareDeep(this.location, o.location, true) && AddedItemComponent.compareDeep(this.quantity, o.quantity, true) && AddedItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && AddedItemComponent.compareDeep(this.factor, o.factor, true) && AddedItemComponent.compareDeep(this.tax, o.tax, true) && AddedItemComponent.compareDeep(this.net, o.net, true) && AddedItemComponent.compareDeep(this.bodySite, o.bodySite, true) && AddedItemComponent.compareDeep(this.noteNumber, o.noteNumber, true) && AddedItemComponent.compareDeep(this.reviewOutcome, o.reviewOutcome, true) && AddedItemComponent.compareDeep(this.adjudication, o.adjudication, true) && AddedItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other_;
            return AddedItemComponent.compareValues(this.itemSequence, o.itemSequence, true) && AddedItemComponent.compareValues(this.detailSequence, o.detailSequence, true) && AddedItemComponent.compareValues(this.subdetailSequence, o.subdetailSequence, true) && AddedItemComponent.compareValues(this.factor, o.factor, true) && AddedItemComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.itemSequence, this.detailSequence, this.subdetailSequence, this.traceNumber, this.provider, this.revenue, this.productOrService, this.productOrServiceEnd, this.request, this.modifier, this.programCode, this.serviced, this.location, this.quantity, this.unitPrice, this.factor, this.tax, this.net, this.bodySite, this.noteNumber, this.reviewOutcome, this.adjudication, this.detail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem";
        }
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="subDetailSequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Claim sub-detail instance identifier", formalDefinition="A number to uniquely reference the claim sub-detail entry.")
        protected PositiveIntType subDetailSequence;
        @Child(name="traceNumber", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Number for tracking", formalDefinition="Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.")
        protected List<Identifier> traceNumber;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable note numbers", formalDefinition="The numbers associated with notes below which apply to the adjudication of this item.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="reviewOutcome", type={ReviewOutcomeComponent.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail level adjudication results", formalDefinition="The high-level results of the adjudication if adjudication has been performed.")
        protected ReviewOutcomeComponent reviewOutcome;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Subdetail level adjudication details", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        private static final long serialVersionUID = 1370798714L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(int subDetailSequence) {
            this.setSubDetailSequence(subDetailSequence);
        }

        public PositiveIntType getSubDetailSequenceElement() {
            if (this.subDetailSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.subDetailSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.subDetailSequence = new PositiveIntType();
                }
            }
            return this.subDetailSequence;
        }

        public boolean hasSubDetailSequenceElement() {
            return this.subDetailSequence != null && !this.subDetailSequence.isEmpty();
        }

        public boolean hasSubDetailSequence() {
            return this.subDetailSequence != null && !this.subDetailSequence.isEmpty();
        }

        public SubDetailComponent setSubDetailSequenceElement(PositiveIntType value) {
            this.subDetailSequence = value;
            return this;
        }

        public int getSubDetailSequence() {
            return this.subDetailSequence == null || this.subDetailSequence.isEmpty() ? 0 : (Integer)this.subDetailSequence.getValue();
        }

        public SubDetailComponent setSubDetailSequence(int value) {
            if (this.subDetailSequence == null) {
                this.subDetailSequence = new PositiveIntType();
            }
            this.subDetailSequence.setValue((Object)value);
            return this;
        }

        public List<Identifier> getTraceNumber() {
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            return this.traceNumber;
        }

        public SubDetailComponent setTraceNumber(List<Identifier> theTraceNumber) {
            this.traceNumber = theTraceNumber;
            return this;
        }

        public boolean hasTraceNumber() {
            if (this.traceNumber == null) {
                return false;
            }
            for (Identifier item : this.traceNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addTraceNumber() {
            Identifier t = new Identifier();
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return t;
        }

        public SubDetailComponent addTraceNumber(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return this;
        }

        public Identifier getTraceNumberFirstRep() {
            if (this.getTraceNumber().isEmpty()) {
                this.addTraceNumber();
            }
            return this.getTraceNumber().get(0);
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public SubDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public SubDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public ReviewOutcomeComponent getReviewOutcome() {
            if (this.reviewOutcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.reviewOutcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.reviewOutcome = new ReviewOutcomeComponent();
                }
            }
            return this.reviewOutcome;
        }

        public boolean hasReviewOutcome() {
            return this.reviewOutcome != null && !this.reviewOutcome.isEmpty();
        }

        public SubDetailComponent setReviewOutcome(ReviewOutcomeComponent value) {
            this.reviewOutcome = value;
            return this;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public SubDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public SubDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("subDetailSequence", "positiveInt", "A number to uniquely reference the claim sub-detail entry.", 0, 1, this.subDetailSequence));
            children.add(new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber));
            children.add(new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -855462510: {
                    return new Property("subDetailSequence", "positiveInt", "A number to uniquely reference the claim sub-detail entry.", 0, 1, this.subDetailSequence);
                }
                case 82505966: {
                    return new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -51825446: {
                    return new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -855462510: {
                    Base[] baseArray;
                    if (this.subDetailSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.subDetailSequence;
                    }
                    return baseArray;
                }
                case 82505966: {
                    return this.traceNumber == null ? new Base[]{} : this.traceNumber.toArray(new Base[this.traceNumber.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -51825446: {
                    Base[] baseArray;
                    if (this.reviewOutcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reviewOutcome;
                    }
                    return baseArray;
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -855462510: {
                    this.subDetailSequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 82505966: {
                    this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case -51825446: {
                    this.reviewOutcome = (ReviewOutcomeComponent)value;
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("subDetailSequence")) {
                this.subDetailSequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("traceNumber")) {
                this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("subDetailSequence")) {
                this.subDetailSequence = null;
            } else if (name.equals("traceNumber")) {
                this.getTraceNumber().remove(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().remove(value);
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().remove((AdjudicationComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -855462510: {
                    return this.getSubDetailSequenceElement();
                }
                case 82505966: {
                    return this.addTraceNumber();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -51825446: {
                    return this.getReviewOutcome();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -855462510: {
                    return new String[]{"positiveInt"};
                }
                case 82505966: {
                    return new String[]{"Identifier"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -51825446: {
                    return new String[]{"@ClaimResponse.item.reviewOutcome"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("subDetailSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.item.detail.subDetail.subDetailSequence");
            }
            if (name.equals("traceNumber")) {
                return this.addTraceNumber();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.item.detail.subDetail.noteNumber");
            }
            if (name.equals("reviewOutcome")) {
                this.reviewOutcome = new ReviewOutcomeComponent();
                return this.reviewOutcome;
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubDetailComponent dst) {
            super.copyValues(dst);
            PositiveIntType positiveIntType = dst.subDetailSequence = this.subDetailSequence == null ? null : this.subDetailSequence.copy();
            if (this.traceNumber != null) {
                dst.traceNumber = new ArrayList<Identifier>();
                for (Identifier identifier : this.traceNumber) {
                    dst.traceNumber.add(identifier.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            ReviewOutcomeComponent reviewOutcomeComponent = dst.reviewOutcome = this.reviewOutcome == null ? null : this.reviewOutcome.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareDeep(this.subDetailSequence, o.subDetailSequence, true) && SubDetailComponent.compareDeep(this.traceNumber, o.traceNumber, true) && SubDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && SubDetailComponent.compareDeep(this.reviewOutcome, o.reviewOutcome, true) && SubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareValues(this.subDetailSequence, o.subDetailSequence, true) && SubDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.subDetailSequence, this.traceNumber, this.noteNumber, this.reviewOutcome, this.adjudication});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail.subDetail";
        }
    }

    @Block
    public static class ItemDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="detailSequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Claim detail instance identifier", formalDefinition="A number to uniquely reference the claim detail entry.")
        protected PositiveIntType detailSequence;
        @Child(name="traceNumber", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Number for tracking", formalDefinition="Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.")
        protected List<Identifier> traceNumber;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable note numbers", formalDefinition="The numbers associated with notes below which apply to the adjudication of this item.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="reviewOutcome", type={ReviewOutcomeComponent.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detail level adjudication results", formalDefinition="The high-level results of the adjudication if adjudication has been performed.")
        protected ReviewOutcomeComponent reviewOutcome;
        @Child(name="adjudication", type={AdjudicationComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Detail level adjudication details", formalDefinition="The adjudication results.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication for claim sub-details", formalDefinition="A sub-detail adjudication of a simple product or service.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = -1263137525L;

        public ItemDetailComponent() {
        }

        public ItemDetailComponent(int detailSequence) {
            this.setDetailSequence(detailSequence);
        }

        public PositiveIntType getDetailSequenceElement() {
            if (this.detailSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemDetailComponent.detailSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailSequence = new PositiveIntType();
                }
            }
            return this.detailSequence;
        }

        public boolean hasDetailSequenceElement() {
            return this.detailSequence != null && !this.detailSequence.isEmpty();
        }

        public boolean hasDetailSequence() {
            return this.detailSequence != null && !this.detailSequence.isEmpty();
        }

        public ItemDetailComponent setDetailSequenceElement(PositiveIntType value) {
            this.detailSequence = value;
            return this;
        }

        public int getDetailSequence() {
            return this.detailSequence == null || this.detailSequence.isEmpty() ? 0 : (Integer)this.detailSequence.getValue();
        }

        public ItemDetailComponent setDetailSequence(int value) {
            if (this.detailSequence == null) {
                this.detailSequence = new PositiveIntType();
            }
            this.detailSequence.setValue((Object)value);
            return this;
        }

        public List<Identifier> getTraceNumber() {
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            return this.traceNumber;
        }

        public ItemDetailComponent setTraceNumber(List<Identifier> theTraceNumber) {
            this.traceNumber = theTraceNumber;
            return this;
        }

        public boolean hasTraceNumber() {
            if (this.traceNumber == null) {
                return false;
            }
            for (Identifier item : this.traceNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addTraceNumber() {
            Identifier t = new Identifier();
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return t;
        }

        public ItemDetailComponent addTraceNumber(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return this;
        }

        public Identifier getTraceNumberFirstRep() {
            if (this.getTraceNumber().isEmpty()) {
                this.addTraceNumber();
            }
            return this.getTraceNumber().get(0);
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public ItemDetailComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemDetailComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public ReviewOutcomeComponent getReviewOutcome() {
            if (this.reviewOutcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemDetailComponent.reviewOutcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.reviewOutcome = new ReviewOutcomeComponent();
                }
            }
            return this.reviewOutcome;
        }

        public boolean hasReviewOutcome() {
            return this.reviewOutcome != null && !this.reviewOutcome.isEmpty();
        }

        public ItemDetailComponent setReviewOutcome(ReviewOutcomeComponent value) {
            this.reviewOutcome = value;
            return this;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public ItemDetailComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemDetailComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public ItemDetailComponent setSubDetail(List<SubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public ItemDetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public SubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("detailSequence", "positiveInt", "A number to uniquely reference the claim detail entry.", 0, 1, this.detailSequence));
            children.add(new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber));
            children.add(new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome));
            children.add(new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("subDetail", "", "A sub-detail adjudication of a simple product or service.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1321472818: {
                    return new Property("detailSequence", "positiveInt", "A number to uniquely reference the claim detail entry.", 0, 1, this.detailSequence);
                }
                case 82505966: {
                    return new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -51825446: {
                    return new Property("reviewOutcome", "@ClaimResponse.item.reviewOutcome", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome);
                }
                case -231349275: {
                    return new Property("adjudication", "@ClaimResponse.item.adjudication", "The adjudication results.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -828829007: {
                    return new Property("subDetail", "", "A sub-detail adjudication of a simple product or service.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1321472818: {
                    Base[] baseArray;
                    if (this.detailSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.detailSequence;
                    }
                    return baseArray;
                }
                case 82505966: {
                    return this.traceNumber == null ? new Base[]{} : this.traceNumber.toArray(new Base[this.traceNumber.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -51825446: {
                    Base[] baseArray;
                    if (this.reviewOutcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reviewOutcome;
                    }
                    return baseArray;
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1321472818: {
                    this.detailSequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 82505966: {
                    this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case -51825446: {
                    this.reviewOutcome = (ReviewOutcomeComponent)value;
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((SubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("detailSequence")) {
                this.detailSequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("traceNumber")) {
                this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("detailSequence")) {
                this.detailSequence = null;
            } else if (name.equals("traceNumber")) {
                this.getTraceNumber().remove(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().remove(value);
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().remove((AdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().remove((SubDetailComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1321472818: {
                    return this.getDetailSequenceElement();
                }
                case 82505966: {
                    return this.addTraceNumber();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -51825446: {
                    return this.getReviewOutcome();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1321472818: {
                    return new String[]{"positiveInt"};
                }
                case 82505966: {
                    return new String[]{"Identifier"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -51825446: {
                    return new String[]{"@ClaimResponse.item.reviewOutcome"};
                }
                case -231349275: {
                    return new String[]{"@ClaimResponse.item.adjudication"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("detailSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.item.detail.detailSequence");
            }
            if (name.equals("traceNumber")) {
                return this.addTraceNumber();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.item.detail.noteNumber");
            }
            if (name.equals("reviewOutcome")) {
                this.reviewOutcome = new ReviewOutcomeComponent();
                return this.reviewOutcome;
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemDetailComponent copy() {
            ItemDetailComponent dst = new ItemDetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ItemDetailComponent dst) {
            super.copyValues(dst);
            PositiveIntType positiveIntType = dst.detailSequence = this.detailSequence == null ? null : this.detailSequence.copy();
            if (this.traceNumber != null) {
                dst.traceNumber = new ArrayList<Identifier>();
                for (Identifier identifier : this.traceNumber) {
                    dst.traceNumber.add(identifier.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            ReviewOutcomeComponent reviewOutcomeComponent = dst.reviewOutcome = this.reviewOutcome == null ? null : this.reviewOutcome.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent subDetailComponent : this.subDetail) {
                    dst.subDetail.add(subDetailComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemDetailComponent)) {
                return false;
            }
            ItemDetailComponent o = (ItemDetailComponent)other_;
            return ItemDetailComponent.compareDeep(this.detailSequence, o.detailSequence, true) && ItemDetailComponent.compareDeep(this.traceNumber, o.traceNumber, true) && ItemDetailComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemDetailComponent.compareDeep(this.reviewOutcome, o.reviewOutcome, true) && ItemDetailComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemDetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemDetailComponent)) {
                return false;
            }
            ItemDetailComponent o = (ItemDetailComponent)other_;
            return ItemDetailComponent.compareValues(this.detailSequence, o.detailSequence, true) && ItemDetailComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.detailSequence, this.traceNumber, this.noteNumber, this.reviewOutcome, this.adjudication, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail";
        }
    }

    @Block
    public static class AdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of adjudication information", formalDefinition="A code to indicate the information type of this adjudication record. Information types may include the value submitted, maximum values or percentages allowed or payable under the plan, amounts that: the patient is responsible for in aggregate or pertaining to this item; amounts paid by other coverages; and, the benefit payable for this item.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication")
        protected CodeableConcept category;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation of adjudication outcome", formalDefinition="A code supporting the understanding of the adjudication result and explaining variance from expected amount.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/adjudication-reason")
        protected CodeableConcept reason;
        @Child(name="amount", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monetary amount associated with the category.")
        protected Money amount;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Non-monetary value", formalDefinition="A non-monetary value associated with the category. Mutually exclusive to the amount element above.")
        protected Quantity quantity;
        private static final long serialVersionUID = 29312734L;

        public AdjudicationComponent() {
        }

        public AdjudicationComponent(CodeableConcept category) {
            this.setCategory(category);
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public AdjudicationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public AdjudicationComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdjudicationComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public AdjudicationComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "A code to indicate the information type of this adjudication record. Information types may include the value submitted, maximum values or percentages allowed or payable under the plan, amounts that: the patient is responsible for in aggregate or pertaining to this item; amounts paid by other coverages; and, the benefit payable for this item.", 0, 1, this.category));
            children.add(new Property("reason", "CodeableConcept", "A code supporting the understanding of the adjudication result and explaining variance from expected amount.", 0, 1, this.reason));
            children.add(new Property("amount", "Money", "Monetary amount associated with the category.", 0, 1, this.amount));
            children.add(new Property("quantity", "Quantity", "A non-monetary value associated with the category. Mutually exclusive to the amount element above.", 0, 1, this.quantity));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "A code to indicate the information type of this adjudication record. Information types may include the value submitted, maximum values or percentages allowed or payable under the plan, amounts that: the patient is responsible for in aggregate or pertaining to this item; amounts paid by other coverages; and, the benefit payable for this item.", 0, 1, this.category);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "A code supporting the understanding of the adjudication result and explaining variance from expected amount.", 0, 1, this.reason);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "Monetary amount associated with the category.", 0, 1, this.amount);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "A non-monetary value associated with the category. Mutually exclusive to the amount element above.", 0, 1, this.quantity);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reason;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.quantity;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.reason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToMoney(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToMoney(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("reason")) {
                this.reason = null;
            } else if (name.equals("amount")) {
                this.amount = null;
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -934964668: {
                    return this.getReason();
                }
                case -1413853096: {
                    return this.getAmount();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            return super.addChild(name);
        }

        @Override
        public AdjudicationComponent copy() {
            AdjudicationComponent dst = new AdjudicationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdjudicationComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdjudicationComponent)) {
                return false;
            }
            AdjudicationComponent o = (AdjudicationComponent)other_;
            return AdjudicationComponent.compareDeep(this.category, o.category, true) && AdjudicationComponent.compareDeep(this.reason, o.reason, true) && AdjudicationComponent.compareDeep(this.amount, o.amount, true) && AdjudicationComponent.compareDeep(this.quantity, o.quantity, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdjudicationComponent)) {
                return false;
            }
            AdjudicationComponent o = (AdjudicationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.reason, this.amount, this.quantity});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.adjudication";
        }
    }

    @Block
    public static class ReviewOutcomeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="decision", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Result of the adjudication", formalDefinition="The result of the claim, predetermination, or preauthorization adjudication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-decision")
        protected CodeableConcept decision;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Reason for result of the adjudication", formalDefinition="The reasons for the result of the claim, predetermination, or preauthorization adjudication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-decision-reason")
        protected List<CodeableConcept> reason;
        @Child(name="preAuthRef", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Preauthorization reference", formalDefinition="Reference from the Insurer which is used in later communications which refers to this adjudication.")
        protected StringType preAuthRef;
        @Child(name="preAuthPeriod", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Preauthorization reference effective period", formalDefinition="The time frame during which this authorization is effective.")
        protected Period preAuthPeriod;
        private static final long serialVersionUID = 2126097594L;

        public CodeableConcept getDecision() {
            if (this.decision == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ReviewOutcomeComponent.decision");
                }
                if (Configuration.doAutoCreate()) {
                    this.decision = new CodeableConcept();
                }
            }
            return this.decision;
        }

        public boolean hasDecision() {
            return this.decision != null && !this.decision.isEmpty();
        }

        public ReviewOutcomeComponent setDecision(CodeableConcept value) {
            this.decision = value;
            return this;
        }

        public List<CodeableConcept> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            return this.reason;
        }

        public ReviewOutcomeComponent setReason(List<CodeableConcept> theReason) {
            this.reason = theReason;
            return this;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (CodeableConcept item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return t;
        }

        public ReviewOutcomeComponent addReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return this;
        }

        public CodeableConcept getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                this.addReason();
            }
            return this.getReason().get(0);
        }

        public StringType getPreAuthRefElement() {
            if (this.preAuthRef == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ReviewOutcomeComponent.preAuthRef");
                }
                if (Configuration.doAutoCreate()) {
                    this.preAuthRef = new StringType();
                }
            }
            return this.preAuthRef;
        }

        public boolean hasPreAuthRefElement() {
            return this.preAuthRef != null && !this.preAuthRef.isEmpty();
        }

        public boolean hasPreAuthRef() {
            return this.preAuthRef != null && !this.preAuthRef.isEmpty();
        }

        public ReviewOutcomeComponent setPreAuthRefElement(StringType value) {
            this.preAuthRef = value;
            return this;
        }

        public String getPreAuthRef() {
            return this.preAuthRef == null ? null : (String)this.preAuthRef.getValue();
        }

        public ReviewOutcomeComponent setPreAuthRef(String value) {
            if (Utilities.noString((String)value)) {
                this.preAuthRef = null;
            } else {
                if (this.preAuthRef == null) {
                    this.preAuthRef = new StringType();
                }
                this.preAuthRef.setValue(value);
            }
            return this;
        }

        public Period getPreAuthPeriod() {
            if (this.preAuthPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ReviewOutcomeComponent.preAuthPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.preAuthPeriod = new Period();
                }
            }
            return this.preAuthPeriod;
        }

        public boolean hasPreAuthPeriod() {
            return this.preAuthPeriod != null && !this.preAuthPeriod.isEmpty();
        }

        public ReviewOutcomeComponent setPreAuthPeriod(Period value) {
            this.preAuthPeriod = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("decision", "CodeableConcept", "The result of the claim, predetermination, or preauthorization adjudication.", 0, 1, this.decision));
            children.add(new Property("reason", "CodeableConcept", "The reasons for the result of the claim, predetermination, or preauthorization adjudication.", 0, Integer.MAX_VALUE, this.reason));
            children.add(new Property("preAuthRef", "string", "Reference from the Insurer which is used in later communications which refers to this adjudication.", 0, 1, this.preAuthRef));
            children.add(new Property("preAuthPeriod", "Period", "The time frame during which this authorization is effective.", 0, 1, this.preAuthPeriod));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 565719004: {
                    return new Property("decision", "CodeableConcept", "The result of the claim, predetermination, or preauthorization adjudication.", 0, 1, this.decision);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "The reasons for the result of the claim, predetermination, or preauthorization adjudication.", 0, Integer.MAX_VALUE, this.reason);
                }
                case 522246568: {
                    return new Property("preAuthRef", "string", "Reference from the Insurer which is used in later communications which refers to this adjudication.", 0, 1, this.preAuthRef);
                }
                case 1819164812: {
                    return new Property("preAuthPeriod", "Period", "The time frame during which this authorization is effective.", 0, 1, this.preAuthPeriod);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 565719004: {
                    Base[] baseArray;
                    if (this.decision == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.decision;
                    }
                    return baseArray;
                }
                case -934964668: {
                    return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
                }
                case 522246568: {
                    Base[] baseArray;
                    if (this.preAuthRef == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.preAuthRef;
                    }
                    return baseArray;
                }
                case 1819164812: {
                    Base[] baseArray;
                    if (this.preAuthPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preAuthPeriod;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 565719004: {
                    this.decision = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.getReason().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 522246568: {
                    this.preAuthRef = TypeConvertor.castToString(value);
                    return value;
                }
                case 1819164812: {
                    this.preAuthPeriod = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("decision")) {
                this.decision = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.getReason().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("preAuthRef")) {
                this.preAuthRef = TypeConvertor.castToString(value);
            } else if (name.equals("preAuthPeriod")) {
                this.preAuthPeriod = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("decision")) {
                this.decision = null;
            } else if (name.equals("reason")) {
                this.getReason().remove(value);
            } else if (name.equals("preAuthRef")) {
                this.preAuthRef = null;
            } else if (name.equals("preAuthPeriod")) {
                this.preAuthPeriod = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 565719004: {
                    return this.getDecision();
                }
                case -934964668: {
                    return this.addReason();
                }
                case 522246568: {
                    return this.getPreAuthRefElement();
                }
                case 1819164812: {
                    return this.getPreAuthPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 565719004: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
                case 522246568: {
                    return new String[]{"string"};
                }
                case 1819164812: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("decision")) {
                this.decision = new CodeableConcept();
                return this.decision;
            }
            if (name.equals("reason")) {
                return this.addReason();
            }
            if (name.equals("preAuthRef")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.item.reviewOutcome.preAuthRef");
            }
            if (name.equals("preAuthPeriod")) {
                this.preAuthPeriod = new Period();
                return this.preAuthPeriod;
            }
            return super.addChild(name);
        }

        @Override
        public ReviewOutcomeComponent copy() {
            ReviewOutcomeComponent dst = new ReviewOutcomeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ReviewOutcomeComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.decision = this.decision == null ? null : this.decision.copy();
            if (this.reason != null) {
                dst.reason = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.reason) {
                    dst.reason.add(i.copy());
                }
            }
            dst.preAuthRef = this.preAuthRef == null ? null : this.preAuthRef.copy();
            dst.preAuthPeriod = this.preAuthPeriod == null ? null : this.preAuthPeriod.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ReviewOutcomeComponent)) {
                return false;
            }
            ReviewOutcomeComponent o = (ReviewOutcomeComponent)other_;
            return ReviewOutcomeComponent.compareDeep(this.decision, o.decision, true) && ReviewOutcomeComponent.compareDeep(this.reason, o.reason, true) && ReviewOutcomeComponent.compareDeep(this.preAuthRef, o.preAuthRef, true) && ReviewOutcomeComponent.compareDeep(this.preAuthPeriod, o.preAuthPeriod, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ReviewOutcomeComponent)) {
                return false;
            }
            ReviewOutcomeComponent o = (ReviewOutcomeComponent)other_;
            return ReviewOutcomeComponent.compareValues(this.preAuthRef, o.preAuthRef, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.decision, this.reason, this.preAuthRef, this.preAuthPeriod});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.reviewOutcome";
        }
    }

    @Block
    public static class ItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="itemSequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Claim item instance identifier", formalDefinition="A number to uniquely reference the claim item entries.")
        protected PositiveIntType itemSequence;
        @Child(name="traceNumber", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Number for tracking", formalDefinition="Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.")
        protected List<Identifier> traceNumber;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable note numbers", formalDefinition="The numbers associated with notes below which apply to the adjudication of this item.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="reviewOutcome", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication results", formalDefinition="The high-level results of the adjudication if adjudication has been performed.")
        protected ReviewOutcomeComponent reviewOutcome;
        @Child(name="adjudication", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication details", formalDefinition="If this item is a group then the values here are a summary of the adjudication of the detail items. If this item is a simple product or service then this is the result of the adjudication of this item.")
        protected List<AdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication for claim details", formalDefinition="A claim detail. Either a simple (a product or service) or a 'group' of sub-details which are simple items.")
        protected List<ItemDetailComponent> detail;
        private static final long serialVersionUID = -1834500828L;

        public ItemComponent() {
        }

        public ItemComponent(int itemSequence) {
            this.setItemSequence(itemSequence);
        }

        public PositiveIntType getItemSequenceElement() {
            if (this.itemSequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.itemSequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemSequence = new PositiveIntType();
                }
            }
            return this.itemSequence;
        }

        public boolean hasItemSequenceElement() {
            return this.itemSequence != null && !this.itemSequence.isEmpty();
        }

        public boolean hasItemSequence() {
            return this.itemSequence != null && !this.itemSequence.isEmpty();
        }

        public ItemComponent setItemSequenceElement(PositiveIntType value) {
            this.itemSequence = value;
            return this;
        }

        public int getItemSequence() {
            return this.itemSequence == null || this.itemSequence.isEmpty() ? 0 : (Integer)this.itemSequence.getValue();
        }

        public ItemComponent setItemSequence(int value) {
            if (this.itemSequence == null) {
                this.itemSequence = new PositiveIntType();
            }
            this.itemSequence.setValue((Object)value);
            return this;
        }

        public List<Identifier> getTraceNumber() {
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            return this.traceNumber;
        }

        public ItemComponent setTraceNumber(List<Identifier> theTraceNumber) {
            this.traceNumber = theTraceNumber;
            return this;
        }

        public boolean hasTraceNumber() {
            if (this.traceNumber == null) {
                return false;
            }
            for (Identifier item : this.traceNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addTraceNumber() {
            Identifier t = new Identifier();
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return t;
        }

        public ItemComponent addTraceNumber(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.traceNumber == null) {
                this.traceNumber = new ArrayList<Identifier>();
            }
            this.traceNumber.add(t);
            return this;
        }

        public Identifier getTraceNumberFirstRep() {
            if (this.getTraceNumber().isEmpty()) {
                this.addTraceNumber();
            }
            return this.getTraceNumber().get(0);
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public ItemComponent setNoteNumber(List<PositiveIntType> theNoteNumber) {
            this.noteNumber = theNoteNumber;
            return this;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public ReviewOutcomeComponent getReviewOutcome() {
            if (this.reviewOutcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.reviewOutcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.reviewOutcome = new ReviewOutcomeComponent();
                }
            }
            return this.reviewOutcome;
        }

        public boolean hasReviewOutcome() {
            return this.reviewOutcome != null && !this.reviewOutcome.isEmpty();
        }

        public ItemComponent setReviewOutcome(ReviewOutcomeComponent value) {
            this.reviewOutcome = value;
            return this;
        }

        public List<AdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            return this.adjudication;
        }

        public ItemComponent setAdjudication(List<AdjudicationComponent> theAdjudication) {
            this.adjudication = theAdjudication;
            return this;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AdjudicationComponent addAdjudication() {
            AdjudicationComponent t = new AdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemComponent addAdjudication(AdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public AdjudicationComponent getAdjudicationFirstRep() {
            if (this.getAdjudication().isEmpty()) {
                this.addAdjudication();
            }
            return this.getAdjudication().get(0);
        }

        public List<ItemDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            return this.detail;
        }

        public ItemComponent setDetail(List<ItemDetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (ItemDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ItemDetailComponent addDetail() {
            ItemDetailComponent t = new ItemDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemComponent addDetail(ItemDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public ItemDetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("itemSequence", "positiveInt", "A number to uniquely reference the claim item entries.", 0, 1, this.itemSequence));
            children.add(new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber));
            children.add(new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber));
            children.add(new Property("reviewOutcome", "", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome));
            children.add(new Property("adjudication", "", "If this item is a group then the values here are a summary of the adjudication of the detail items. If this item is a simple product or service then this is the result of the adjudication of this item.", 0, Integer.MAX_VALUE, this.adjudication));
            children.add(new Property("detail", "", "A claim detail. Either a simple (a product or service) or a 'group' of sub-details which are simple items.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1977979892: {
                    return new Property("itemSequence", "positiveInt", "A number to uniquely reference the claim item entries.", 0, 1, this.itemSequence);
                }
                case 82505966: {
                    return new Property("traceNumber", "Identifier", "Trace number for tracking purposes. May be defined at the jurisdiction level or between trading partners.", 0, Integer.MAX_VALUE, this.traceNumber);
                }
                case -1110033957: {
                    return new Property("noteNumber", "positiveInt", "The numbers associated with notes below which apply to the adjudication of this item.", 0, Integer.MAX_VALUE, this.noteNumber);
                }
                case -51825446: {
                    return new Property("reviewOutcome", "", "The high-level results of the adjudication if adjudication has been performed.", 0, 1, this.reviewOutcome);
                }
                case -231349275: {
                    return new Property("adjudication", "", "If this item is a group then the values here are a summary of the adjudication of the detail items. If this item is a simple product or service then this is the result of the adjudication of this item.", 0, Integer.MAX_VALUE, this.adjudication);
                }
                case -1335224239: {
                    return new Property("detail", "", "A claim detail. Either a simple (a product or service) or a 'group' of sub-details which are simple items.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    Base[] baseArray;
                    if (this.itemSequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.itemSequence;
                    }
                    return baseArray;
                }
                case 82505966: {
                    return this.traceNumber == null ? new Base[]{} : this.traceNumber.toArray(new Base[this.traceNumber.size()]);
                }
                case -1110033957: {
                    return this.noteNumber == null ? new Base[]{} : this.noteNumber.toArray(new Base[this.noteNumber.size()]);
                }
                case -51825446: {
                    Base[] baseArray;
                    if (this.reviewOutcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reviewOutcome;
                    }
                    return baseArray;
                }
                case -231349275: {
                    return this.adjudication == null ? new Base[]{} : this.adjudication.toArray(new Base[this.adjudication.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    this.itemSequence = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
                case 82505966: {
                    this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -1110033957: {
                    this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
                    return value;
                }
                case -51825446: {
                    this.reviewOutcome = (ReviewOutcomeComponent)value;
                    return value;
                }
                case -231349275: {
                    this.getAdjudication().add((AdjudicationComponent)value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((ItemDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.itemSequence = TypeConvertor.castToPositiveInt(value);
            } else if (name.equals("traceNumber")) {
                this.getTraceNumber().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(TypeConvertor.castToPositiveInt(value));
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((ItemDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("itemSequence")) {
                this.itemSequence = null;
            } else if (name.equals("traceNumber")) {
                this.getTraceNumber().remove(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().remove(value);
            } else if (name.equals("reviewOutcome")) {
                this.reviewOutcome = (ReviewOutcomeComponent)value;
            } else if (name.equals("adjudication")) {
                this.getAdjudication().remove((AdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().remove((ItemDetailComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return this.getItemSequenceElement();
                }
                case 82505966: {
                    return this.addTraceNumber();
                }
                case -1110033957: {
                    return this.addNoteNumberElement();
                }
                case -51825446: {
                    return this.getReviewOutcome();
                }
                case -231349275: {
                    return this.addAdjudication();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1977979892: {
                    return new String[]{"positiveInt"};
                }
                case 82505966: {
                    return new String[]{"Identifier"};
                }
                case -1110033957: {
                    return new String[]{"positiveInt"};
                }
                case -51825446: {
                    return new String[0];
                }
                case -231349275: {
                    return new String[0];
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.item.itemSequence");
            }
            if (name.equals("traceNumber")) {
                return this.addTraceNumber();
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a singleton property ClaimResponse.item.noteNumber");
            }
            if (name.equals("reviewOutcome")) {
                this.reviewOutcome = new ReviewOutcomeComponent();
                return this.reviewOutcome;
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemComponent copy() {
            ItemComponent dst = new ItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ItemComponent dst) {
            super.copyValues(dst);
            PositiveIntType positiveIntType = dst.itemSequence = this.itemSequence == null ? null : this.itemSequence.copy();
            if (this.traceNumber != null) {
                dst.traceNumber = new ArrayList<Identifier>();
                for (Identifier identifier : this.traceNumber) {
                    dst.traceNumber.add(identifier.copy());
                }
            }
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            ReviewOutcomeComponent reviewOutcomeComponent = dst.reviewOutcome = this.reviewOutcome == null ? null : this.reviewOutcome.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AdjudicationComponent>();
                for (AdjudicationComponent adjudicationComponent : this.adjudication) {
                    dst.adjudication.add(adjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<ItemDetailComponent>();
                for (ItemDetailComponent itemDetailComponent : this.detail) {
                    dst.detail.add(itemDetailComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareDeep(this.itemSequence, o.itemSequence, true) && ItemComponent.compareDeep(this.traceNumber, o.traceNumber, true) && ItemComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemComponent.compareDeep(this.reviewOutcome, o.reviewOutcome, true) && ItemComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareValues(this.itemSequence, o.itemSequence, true) && ItemComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.itemSequence, this.traceNumber, this.noteNumber, this.reviewOutcome, this.adjudication, this.detail});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item";
        }
    }

    @Block
    public static class ClaimResponseEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific event", formalDefinition="A coded event such as when a service is expected or a card printed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/datestype")
        protected CodeableConcept type;
        @Child(name="when", type={DateTimeType.class, Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Occurance date or period", formalDefinition="A date or period in the past or future indicating when the event occurred or is expectd to occur.")
        protected DataType when;
        private static final long serialVersionUID = -634897375L;

        public ClaimResponseEventComponent() {
        }

        public ClaimResponseEventComponent(CodeableConcept type, DataType when) {
            this.setType(type);
            this.setWhen(when);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClaimResponseEventComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ClaimResponseEventComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getWhen() {
            return this.when;
        }

        public DateTimeType getWhenDateTimeType() throws FHIRException {
            if (this.when == null) {
                this.when = new DateTimeType();
            }
            if (!(this.when instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.when.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.when;
        }

        public boolean hasWhenDateTimeType() {
            return this != null && this.when instanceof DateTimeType;
        }

        public Period getWhenPeriod() throws FHIRException {
            if (this.when == null) {
                this.when = new Period();
            }
            if (!(this.when instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.when.getClass().getName() + " was encountered");
            }
            return (Period)this.when;
        }

        public boolean hasWhenPeriod() {
            return this != null && this.when instanceof Period;
        }

        public boolean hasWhen() {
            return this.when != null && !this.when.isEmpty();
        }

        public ClaimResponseEventComponent setWhen(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new FHIRException("Not the right type for ClaimResponse.event.when[x]: " + value.fhirType());
            }
            this.when = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A coded event such as when a service is expected or a card printed.", 0, 1, this.type));
            children.add(new Property("when[x]", "dateTime|Period", "A date or period in the past or future indicating when the event occurred or is expectd to occur.", 0, 1, this.when));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A coded event such as when a service is expected or a card printed.", 0, 1, this.type);
                }
                case 1312831238: {
                    return new Property("when[x]", "dateTime|Period", "A date or period in the past or future indicating when the event occurred or is expectd to occur.", 0, 1, this.when);
                }
                case 3648314: {
                    return new Property("when[x]", "dateTime|Period", "A date or period in the past or future indicating when the event occurred or is expectd to occur.", 0, 1, this.when);
                }
                case -1785502475: {
                    return new Property("when[x]", "dateTime", "A date or period in the past or future indicating when the event occurred or is expectd to occur.", 0, 1, this.when);
                }
                case 251476379: {
                    return new Property("when[x]", "Period", "A date or period in the past or future indicating when the event occurred or is expectd to occur.", 0, 1, this.when);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3648314: {
                    Base[] baseArray;
                    if (this.when == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.when;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3648314: {
                    this.when = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("when[x]")) {
                this.when = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("when[x]")) {
                this.when = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1312831238: {
                    return this.getWhen();
                }
                case 3648314: {
                    return this.getWhen();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3648314: {
                    return new String[]{"dateTime", "Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("whenDateTime")) {
                this.when = new DateTimeType();
                return this.when;
            }
            if (name.equals("whenPeriod")) {
                this.when = new Period();
                return this.when;
            }
            return super.addChild(name);
        }

        @Override
        public ClaimResponseEventComponent copy() {
            ClaimResponseEventComponent dst = new ClaimResponseEventComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClaimResponseEventComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.when = this.when == null ? null : this.when.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClaimResponseEventComponent)) {
                return false;
            }
            ClaimResponseEventComponent o = (ClaimResponseEventComponent)other_;
            return ClaimResponseEventComponent.compareDeep(this.type, o.type, true) && ClaimResponseEventComponent.compareDeep(this.when, o.when, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClaimResponseEventComponent)) {
                return false;
            }
            ClaimResponseEventComponent o = (ClaimResponseEventComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.when});
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.event";
        }
    }
}

