/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="FamilyMemberHistory", profile="http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory")
public class FamilyMemberHistory
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Id(s) for this record", formalDefinition="Business identifiers assigned to this family member history by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates FHIR protocol or definition", formalDefinition="The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.")
    protected List<CanonicalType> instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates external protocol or definition", formalDefinition="The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.")
    protected List<UriType> instantiatesUri;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="partial | completed | entered-in-error | health-unknown", formalDefinition="A code specifying the status of the record of the family history of a specific family member.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/history-status")
    protected Enumeration<FamilyHistoryStatus> status;
    @Child(name="dataAbsentReason", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="subject-unknown | withheld | unable-to-obtain | deferred", formalDefinition="Describes why the family member's history is not available.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/history-absent-reason")
    protected CodeableConcept dataAbsentReason;
    @Child(name="patient", type={Patient.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient history is about", formalDefinition="The person who this history concerns.")
    protected Reference patient;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When history was recorded or last updated", formalDefinition="The date (and possibly time) when the family member history was recorded or last updated.")
    protected DateTimeType date;
    @Child(name="participant", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who or what participated in the activities related to the family member history and how they were involved", formalDefinition="Indicates who or what participated in the activities related to the family member history and how they were involved.")
    protected List<FamilyMemberHistoryParticipantComponent> participant;
    @Child(name="name", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The family member described", formalDefinition="This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\".")
    protected StringType name;
    @Child(name="relationship", type={CodeableConcept.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relationship to the subject", formalDefinition="The type of relationship this person has to the patient (father, mother, brother etc.).")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-FamilyMember")
    protected CodeableConcept relationship;
    @Child(name="sex", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="The birth sex of the family member.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
    protected CodeableConcept sex;
    @Child(name="born", type={Period.class, DateType.class, StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="(approximate) date of birth", formalDefinition="The actual or approximate date of birth of the relative.")
    protected DataType born;
    @Child(name="age", type={Age.class, Range.class, StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="(approximate) age", formalDefinition="The age of the relative at the time the family member history is recorded.")
    protected DataType age;
    @Child(name="estimatedAge", type={BooleanType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Age is estimated?", formalDefinition="If true, indicates that the age value specified is an estimated value.")
    protected BooleanType estimatedAge;
    @Child(name="deceased", type={BooleanType.class, Age.class, Range.class, DateType.class, StringType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dead? How old/when?", formalDefinition="Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.")
    protected DataType deceased;
    @Child(name="reason", type={CodeableReference.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why was family member history performed?", formalDefinition="Describes why the family member history occurred in coded or textual form, or Indicates a Condition, Observation, AllergyIntolerance, or QuestionnaireResponse that justifies this family member history event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableReference> reason;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="General note about related person", formalDefinition="This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.")
    protected List<Annotation> note;
    @Child(name="condition", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Condition that the related person had", formalDefinition="The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.")
    protected List<FamilyMemberHistoryConditionComponent> condition;
    @Child(name="procedure", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Procedures that the related person had", formalDefinition="The significant Procedures (or procedure) that the family member had. This is a repeating section to allow a system to represent more than one procedure per resource, though there is nothing stopping multiple resources - one per procedure.")
    protected List<FamilyMemberHistoryProcedureComponent> procedure;
    private static final long serialVersionUID = -1025621277L;
    @SearchParamDefinition(name="instantiates-canonical", path="FamilyMemberHistory.instantiatesCanonical", description="Instantiates FHIR protocol or definition", type="reference", target={ActivityDefinition.class, Measure.class, OperationDefinition.class, PlanDefinition.class, Questionnaire.class})
    public static final String SP_INSTANTIATES_CANONICAL = "instantiates-canonical";
    public static final ReferenceClientParam INSTANTIATES_CANONICAL = new ReferenceClientParam("instantiates-canonical");
    public static final Include INCLUDE_INSTANTIATES_CANONICAL = new Include("FamilyMemberHistory:instantiates-canonical").toLocked();
    @SearchParamDefinition(name="instantiates-uri", path="FamilyMemberHistory.instantiatesUri", description="Instantiates external protocol or definition", type="uri")
    public static final String SP_INSTANTIATES_URI = "instantiates-uri";
    public static final UriClientParam INSTANTIATES_URI = new UriClientParam("instantiates-uri");
    @SearchParamDefinition(name="relationship", path="FamilyMemberHistory.relationship", description="A search by a relationship type", type="token")
    public static final String SP_RELATIONSHIP = "relationship";
    public static final TokenClientParam RELATIONSHIP = new TokenClientParam("relationship");
    @SearchParamDefinition(name="sex", path="FamilyMemberHistory.sex", description="A search by a sex code of a family member", type="token")
    public static final String SP_SEX = "sex";
    public static final TokenClientParam SEX = new TokenClientParam("sex");
    @SearchParamDefinition(name="status", path="FamilyMemberHistory.status", description="partial | completed | entered-in-error | health-unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="code", path="AdverseEvent.code | AllergyIntolerance.code | AllergyIntolerance.reaction.substance | AuditEvent.code | Basic.code | ChargeItem.code | Condition.code | DetectedIssue.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | ImagingSelection.status | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationStatement.medication.concept | NutritionIntake.code | Observation.code | Procedure.code | RequestOrchestration.code | Task.code", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [AuditEvent](auditevent.html): More specific code for the event\r\n* [Basic](basic.html): Kind of Resource\r\n* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code\r\n* [Condition](condition.html): Code for the condition\r\n* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [ImagingSelection](imagingselection.html): The imaging selection status\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationStatement](medicationstatement.html): Return statements of this medication code\r\n* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n* [RequestOrchestration](requestorchestration.html): The code of the request orchestration\r\n* [Task](task.html): Search by task code\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("FamilyMemberHistory:patient").toLocked();

    public FamilyMemberHistory() {
    }

    public FamilyMemberHistory(FamilyHistoryStatus status, Reference patient, CodeableConcept relationship) {
        this.setStatus(status);
        this.setPatient(patient);
        this.setRelationship(relationship);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public FamilyMemberHistory setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public FamilyMemberHistory addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CanonicalType> getInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        return this.instantiatesCanonical;
    }

    public FamilyMemberHistory setInstantiatesCanonical(List<CanonicalType> theInstantiatesCanonical) {
        this.instantiatesCanonical = theInstantiatesCanonical;
        return this;
    }

    public boolean hasInstantiatesCanonical() {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.instantiatesCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return t;
    }

    public FamilyMemberHistory addInstantiatesCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiatesCanonical == null) {
            this.instantiatesCanonical = new ArrayList<CanonicalType>();
        }
        this.instantiatesCanonical.add(t);
        return this;
    }

    public boolean hasInstantiatesCanonical(String value) {
        if (this.instantiatesCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.instantiatesCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getInstantiatesUri() {
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        return this.instantiatesUri;
    }

    public FamilyMemberHistory setInstantiatesUri(List<UriType> theInstantiatesUri) {
        this.instantiatesUri = theInstantiatesUri;
        return this;
    }

    public boolean hasInstantiatesUri() {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType item : this.instantiatesUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addInstantiatesUriElement() {
        UriType t = new UriType();
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return t;
    }

    public FamilyMemberHistory addInstantiatesUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.instantiatesUri == null) {
            this.instantiatesUri = new ArrayList<UriType>();
        }
        this.instantiatesUri.add(t);
        return this;
    }

    public boolean hasInstantiatesUri(String value) {
        if (this.instantiatesUri == null) {
            return false;
        }
        for (UriType v : this.instantiatesUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<FamilyHistoryStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FamilyHistoryStatus>(new FamilyHistoryStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public FamilyMemberHistory setStatusElement(Enumeration<FamilyHistoryStatus> value) {
        this.status = value;
        return this;
    }

    public FamilyHistoryStatus getStatus() {
        return this.status == null ? null : (FamilyHistoryStatus)((Object)this.status.getValue());
    }

    public FamilyMemberHistory setStatus(FamilyHistoryStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<FamilyHistoryStatus>(new FamilyHistoryStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getDataAbsentReason() {
        if (this.dataAbsentReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.dataAbsentReason");
            }
            if (Configuration.doAutoCreate()) {
                this.dataAbsentReason = new CodeableConcept();
            }
        }
        return this.dataAbsentReason;
    }

    public boolean hasDataAbsentReason() {
        return this.dataAbsentReason != null && !this.dataAbsentReason.isEmpty();
    }

    public FamilyMemberHistory setDataAbsentReason(CodeableConcept value) {
        this.dataAbsentReason = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public FamilyMemberHistory setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public FamilyMemberHistory setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public FamilyMemberHistory setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<FamilyMemberHistoryParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<FamilyMemberHistoryParticipantComponent>();
        }
        return this.participant;
    }

    public FamilyMemberHistory setParticipant(List<FamilyMemberHistoryParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (FamilyMemberHistoryParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FamilyMemberHistoryParticipantComponent addParticipant() {
        FamilyMemberHistoryParticipantComponent t = new FamilyMemberHistoryParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<FamilyMemberHistoryParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public FamilyMemberHistory addParticipant(FamilyMemberHistoryParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<FamilyMemberHistoryParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public FamilyMemberHistoryParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public FamilyMemberHistory setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public FamilyMemberHistory setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeableConcept getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new CodeableConcept();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public FamilyMemberHistory setRelationship(CodeableConcept value) {
        this.relationship = value;
        return this;
    }

    public CodeableConcept getSex() {
        if (this.sex == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.sex");
            }
            if (Configuration.doAutoCreate()) {
                this.sex = new CodeableConcept();
            }
        }
        return this.sex;
    }

    public boolean hasSex() {
        return this.sex != null && !this.sex.isEmpty();
    }

    public FamilyMemberHistory setSex(CodeableConcept value) {
        this.sex = value;
        return this;
    }

    public DataType getBorn() {
        return this.born;
    }

    public Period getBornPeriod() throws FHIRException {
        if (this.born == null) {
            this.born = new Period();
        }
        if (!(this.born instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (Period)this.born;
    }

    public boolean hasBornPeriod() {
        return this != null && this.born instanceof Period;
    }

    public DateType getBornDateType() throws FHIRException {
        if (this.born == null) {
            this.born = new DateType();
        }
        if (!(this.born instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (DateType)this.born;
    }

    public boolean hasBornDateType() {
        return this != null && this.born instanceof DateType;
    }

    public StringType getBornStringType() throws FHIRException {
        if (this.born == null) {
            this.born = new StringType();
        }
        if (!(this.born instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.born.getClass().getName() + " was encountered");
        }
        return (StringType)this.born;
    }

    public boolean hasBornStringType() {
        return this != null && this.born instanceof StringType;
    }

    public boolean hasBorn() {
        return this.born != null && !this.born.isEmpty();
    }

    public FamilyMemberHistory setBorn(DataType value) {
        if (!(value == null || value instanceof Period || value instanceof DateType || value instanceof StringType)) {
            throw new FHIRException("Not the right type for FamilyMemberHistory.born[x]: " + value.fhirType());
        }
        this.born = value;
        return this;
    }

    public DataType getAge() {
        return this.age;
    }

    public Age getAgeAge() throws FHIRException {
        if (this.age == null) {
            this.age = new Age();
        }
        if (!(this.age instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (Age)this.age;
    }

    public boolean hasAgeAge() {
        return this != null && this.age instanceof Age;
    }

    public Range getAgeRange() throws FHIRException {
        if (this.age == null) {
            this.age = new Range();
        }
        if (!(this.age instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (Range)this.age;
    }

    public boolean hasAgeRange() {
        return this != null && this.age instanceof Range;
    }

    public StringType getAgeStringType() throws FHIRException {
        if (this.age == null) {
            this.age = new StringType();
        }
        if (!(this.age instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (StringType)this.age;
    }

    public boolean hasAgeStringType() {
        return this != null && this.age instanceof StringType;
    }

    public boolean hasAge() {
        return this.age != null && !this.age.isEmpty();
    }

    public FamilyMemberHistory setAge(DataType value) {
        if (!(value == null || value instanceof Age || value instanceof Range || value instanceof StringType)) {
            throw new FHIRException("Not the right type for FamilyMemberHistory.age[x]: " + value.fhirType());
        }
        this.age = value;
        return this;
    }

    public BooleanType getEstimatedAgeElement() {
        if (this.estimatedAge == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FamilyMemberHistory.estimatedAge");
            }
            if (Configuration.doAutoCreate()) {
                this.estimatedAge = new BooleanType();
            }
        }
        return this.estimatedAge;
    }

    public boolean hasEstimatedAgeElement() {
        return this.estimatedAge != null && !this.estimatedAge.isEmpty();
    }

    public boolean hasEstimatedAge() {
        return this.estimatedAge != null && !this.estimatedAge.isEmpty();
    }

    public FamilyMemberHistory setEstimatedAgeElement(BooleanType value) {
        this.estimatedAge = value;
        return this;
    }

    public boolean getEstimatedAge() {
        return this.estimatedAge == null || this.estimatedAge.isEmpty() ? false : (Boolean)this.estimatedAge.getValue();
    }

    public FamilyMemberHistory setEstimatedAge(boolean value) {
        if (this.estimatedAge == null) {
            this.estimatedAge = new BooleanType();
        }
        this.estimatedAge.setValue((Object)value);
        return this;
    }

    public DataType getDeceased() {
        return this.deceased;
    }

    public BooleanType getDeceasedBooleanType() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new BooleanType();
        }
        if (!(this.deceased instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.deceased;
    }

    public boolean hasDeceasedBooleanType() {
        return this != null && this.deceased instanceof BooleanType;
    }

    public Age getDeceasedAge() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new Age();
        }
        if (!(this.deceased instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (Age)this.deceased;
    }

    public boolean hasDeceasedAge() {
        return this != null && this.deceased instanceof Age;
    }

    public Range getDeceasedRange() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new Range();
        }
        if (!(this.deceased instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (Range)this.deceased;
    }

    public boolean hasDeceasedRange() {
        return this != null && this.deceased instanceof Range;
    }

    public DateType getDeceasedDateType() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new DateType();
        }
        if (!(this.deceased instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (DateType)this.deceased;
    }

    public boolean hasDeceasedDateType() {
        return this != null && this.deceased instanceof DateType;
    }

    public StringType getDeceasedStringType() throws FHIRException {
        if (this.deceased == null) {
            this.deceased = new StringType();
        }
        if (!(this.deceased instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (StringType)this.deceased;
    }

    public boolean hasDeceasedStringType() {
        return this != null && this.deceased instanceof StringType;
    }

    public boolean hasDeceased() {
        return this.deceased != null && !this.deceased.isEmpty();
    }

    public FamilyMemberHistory setDeceased(DataType value) {
        if (!(value == null || value instanceof BooleanType || value instanceof Age || value instanceof Range || value instanceof DateType || value instanceof StringType)) {
            throw new FHIRException("Not the right type for FamilyMemberHistory.deceased[x]: " + value.fhirType());
        }
        this.deceased = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public FamilyMemberHistory setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public FamilyMemberHistory addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public FamilyMemberHistory setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public FamilyMemberHistory addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<FamilyMemberHistoryConditionComponent> getCondition() {
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        return this.condition;
    }

    public FamilyMemberHistory setCondition(List<FamilyMemberHistoryConditionComponent> theCondition) {
        this.condition = theCondition;
        return this;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        for (FamilyMemberHistoryConditionComponent item : this.condition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FamilyMemberHistoryConditionComponent addCondition() {
        FamilyMemberHistoryConditionComponent t = new FamilyMemberHistoryConditionComponent();
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        this.condition.add(t);
        return t;
    }

    public FamilyMemberHistory addCondition(FamilyMemberHistoryConditionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.condition == null) {
            this.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
        }
        this.condition.add(t);
        return this;
    }

    public FamilyMemberHistoryConditionComponent getConditionFirstRep() {
        if (this.getCondition().isEmpty()) {
            this.addCondition();
        }
        return this.getCondition().get(0);
    }

    public List<FamilyMemberHistoryProcedureComponent> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<FamilyMemberHistoryProcedureComponent>();
        }
        return this.procedure;
    }

    public FamilyMemberHistory setProcedure(List<FamilyMemberHistoryProcedureComponent> theProcedure) {
        this.procedure = theProcedure;
        return this;
    }

    public boolean hasProcedure() {
        if (this.procedure == null) {
            return false;
        }
        for (FamilyMemberHistoryProcedureComponent item : this.procedure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FamilyMemberHistoryProcedureComponent addProcedure() {
        FamilyMemberHistoryProcedureComponent t = new FamilyMemberHistoryProcedureComponent();
        if (this.procedure == null) {
            this.procedure = new ArrayList<FamilyMemberHistoryProcedureComponent>();
        }
        this.procedure.add(t);
        return t;
    }

    public FamilyMemberHistory addProcedure(FamilyMemberHistoryProcedureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.procedure == null) {
            this.procedure = new ArrayList<FamilyMemberHistoryProcedureComponent>();
        }
        this.procedure.add(t);
        return this;
    }

    public FamilyMemberHistoryProcedureComponent getProcedureFirstRep() {
        if (this.getProcedure().isEmpty()) {
            this.addProcedure();
        }
        return this.getProcedure().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this family member history by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("instantiatesCanonical", "canonical(PlanDefinition|Questionnaire|ActivityDefinition|Measure|OperationDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.", 0, Integer.MAX_VALUE, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.", 0, Integer.MAX_VALUE, this.instantiatesUri));
        children.add(new Property(SP_STATUS, SP_CODE, "A code specifying the status of the record of the family history of a specific family member.", 0, 1, this.status));
        children.add(new Property("dataAbsentReason", "CodeableConcept", "Describes why the family member's history is not available.", 0, 1, this.dataAbsentReason));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The person who this history concerns.", 0, 1, this.patient));
        children.add(new Property(SP_DATE, "dateTime", "The date (and possibly time) when the family member history was recorded or last updated.", 0, 1, this.date));
        children.add(new Property("participant", "", "Indicates who or what participated in the activities related to the family member history and how they were involved.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("name", "string", "This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\".", 0, 1, this.name));
        children.add(new Property(SP_RELATIONSHIP, "CodeableConcept", "The type of relationship this person has to the patient (father, mother, brother etc.).", 0, 1, this.relationship));
        children.add(new Property(SP_SEX, "CodeableConcept", "The birth sex of the family member.", 0, 1, this.sex));
        children.add(new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born));
        children.add(new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age));
        children.add(new Property("estimatedAge", "boolean", "If true, indicates that the age value specified is an estimated value.", 0, 1, this.estimatedAge));
        children.add(new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|AllergyIntolerance|QuestionnaireResponse|DiagnosticReport|DocumentReference)", "Describes why the family member history occurred in coded or textual form, or Indicates a Condition, Observation, AllergyIntolerance, or QuestionnaireResponse that justifies this family member history event.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("note", "Annotation", "This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("condition", "", "The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.", 0, Integer.MAX_VALUE, this.condition));
        children.add(new Property("procedure", "", "The significant Procedures (or procedure) that the family member had. This is a repeating section to allow a system to represent more than one procedure per resource, though there is nothing stopping multiple resources - one per procedure.", 0, Integer.MAX_VALUE, this.procedure));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this family member history by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(PlanDefinition|Questionnaire|ActivityDefinition|Measure|OperationDefinition)", "The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.", 0, Integer.MAX_VALUE, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this FamilyMemberHistory.", 0, Integer.MAX_VALUE, this.instantiatesUri);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code specifying the status of the record of the family history of a specific family member.", 0, 1, this.status);
            }
            case 1034315687: {
                return new Property("dataAbsentReason", "CodeableConcept", "Describes why the family member's history is not available.", 0, 1, this.dataAbsentReason);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The person who this history concerns.", 0, 1, this.patient);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date (and possibly time) when the family member history was recorded or last updated.", 0, 1, this.date);
            }
            case 767422259: {
                return new Property("participant", "", "Indicates who or what participated in the activities related to the family member history and how they were involved.", 0, Integer.MAX_VALUE, this.participant);
            }
            case 3373707: {
                return new Property("name", "string", "This will either be a name or a description; e.g. \"Aunt Susan\", \"my cousin with the red hair\".", 0, 1, this.name);
            }
            case -261851592: {
                return new Property(SP_RELATIONSHIP, "CodeableConcept", "The type of relationship this person has to the patient (father, mother, brother etc.).", 0, 1, this.relationship);
            }
            case 113766: {
                return new Property(SP_SEX, "CodeableConcept", "The birth sex of the family member.", 0, 1, this.sex);
            }
            case 67532951: {
                return new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case 3029833: {
                return new Property("born[x]", "Period|date|string", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case 1497711210: {
                return new Property("born[x]", "Period", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case 2092814999: {
                return new Property("born[x]", SP_DATE, "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case 1597451450: {
                return new Property("born[x]", "string", "The actual or approximate date of birth of the relative.", 0, 1, this.born);
            }
            case -1419716831: {
                return new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case 96511: {
                return new Property("age[x]", "Age|Range|string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case -1419742336: {
                return new Property("age[x]", "Age", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case 1442748286: {
                return new Property("age[x]", "Range", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case 1821821424: {
                return new Property("age[x]", "string", "The age of the relative at the time the family member history is recorded.", 0, 1, this.age);
            }
            case 2130167587: {
                return new Property("estimatedAge", "boolean", "If true, indicates that the age value specified is an estimated value.", 0, 1, this.estimatedAge);
            }
            case -1311442804: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case 561497972: {
                return new Property("deceased[x]", "boolean|Age|Range|date|string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case 497463828: {
                return new Property("deceased[x]", "boolean", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case -1311468309: {
                return new Property("deceased[x]", "Age", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case -1880094167: {
                return new Property("deceased[x]", "Range", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case -2000727742: {
                return new Property("deceased[x]", SP_DATE, "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case 1892920485: {
                return new Property("deceased[x]", "string", "Deceased flag or the actual or approximate age of the relative at the time of death for the family member history record.", 0, 1, this.deceased);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|AllergyIntolerance|QuestionnaireResponse|DiagnosticReport|DocumentReference)", "Describes why the family member history occurred in coded or textual form, or Indicates a Condition, Observation, AllergyIntolerance, or QuestionnaireResponse that justifies this family member history event.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 3387378: {
                return new Property("note", "Annotation", "This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.", 0, Integer.MAX_VALUE, this.note);
            }
            case -861311717: {
                return new Property("condition", "", "The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.", 0, Integer.MAX_VALUE, this.condition);
            }
            case -1095204141: {
                return new Property("procedure", "", "The significant Procedures (or procedure) that the family member had. This is a repeating section to allow a system to represent more than one procedure per resource, though there is nothing stopping multiple resources - one per procedure.", 0, Integer.MAX_VALUE, this.procedure);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 8911915: {
                return this.instantiatesCanonical == null ? new Base[]{} : this.instantiatesCanonical.toArray(new Base[this.instantiatesCanonical.size()]);
            }
            case -1926393373: {
                return this.instantiatesUri == null ? new Base[]{} : this.instantiatesUri.toArray(new Base[this.instantiatesUri.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1034315687: {
                Base[] baseArray;
                if (this.dataAbsentReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.dataAbsentReason;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.date;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.name;
                }
                return baseArray;
            }
            case -261851592: {
                Base[] baseArray;
                if (this.relationship == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.relationship;
                }
                return baseArray;
            }
            case 113766: {
                Base[] baseArray;
                if (this.sex == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.sex;
                }
                return baseArray;
            }
            case 3029833: {
                Base[] baseArray;
                if (this.born == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.born;
                }
                return baseArray;
            }
            case 96511: {
                Base[] baseArray;
                if (this.age == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.age;
                }
                return baseArray;
            }
            case 2130167587: {
                Base[] baseArray;
                if (this.estimatedAge == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.estimatedAge;
                }
                return baseArray;
            }
            case 561497972: {
                Base[] baseArray;
                if (this.deceased == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.deceased;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -861311717: {
                return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
            }
            case -1095204141: {
                return this.procedure == null ? new Base[]{} : this.procedure.toArray(new Base[this.procedure.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 8911915: {
                this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1926393373: {
                this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -892481550: {
                value = new FamilyHistoryStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 1034315687: {
                this.dataAbsentReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((FamilyMemberHistoryParticipantComponent)((Object)value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -261851592: {
                this.relationship = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 113766: {
                this.sex = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3029833: {
                this.born = TypeConvertor.castToType(value);
                return value;
            }
            case 96511: {
                this.age = TypeConvertor.castToType(value);
                return value;
            }
            case 2130167587: {
                this.estimatedAge = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 561497972: {
                this.deceased = TypeConvertor.castToType(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -861311717: {
                this.getCondition().add((FamilyMemberHistoryConditionComponent)((Object)value));
                return value;
            }
            case -1095204141: {
                this.getProcedure().add((FamilyMemberHistoryProcedureComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals(SP_STATUS)) {
            value = new FamilyHistoryStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("participant")) {
            this.getParticipant().add((FamilyMemberHistoryParticipantComponent)((Object)value));
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_RELATIONSHIP)) {
            this.relationship = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SEX)) {
            this.sex = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("born[x]")) {
            this.born = TypeConvertor.castToType(value);
        } else if (name.equals("age[x]")) {
            this.age = TypeConvertor.castToType(value);
        } else if (name.equals("estimatedAge")) {
            this.estimatedAge = TypeConvertor.castToBoolean(value);
        } else if (name.equals("deceased[x]")) {
            this.deceased = TypeConvertor.castToType(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("condition")) {
            this.getCondition().add((FamilyMemberHistoryConditionComponent)((Object)value));
        } else if (name.equals("procedure")) {
            this.getProcedure().add((FamilyMemberHistoryProcedureComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("instantiatesCanonical")) {
            this.getInstantiatesCanonical().remove(value);
        } else if (name.equals("instantiatesUri")) {
            this.getInstantiatesUri().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new FamilyHistoryStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = null;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals("participant")) {
            this.getParticipant().remove((FamilyMemberHistoryParticipantComponent)((Object)value));
        } else if (name.equals("name")) {
            this.name = null;
        } else if (name.equals(SP_RELATIONSHIP)) {
            this.relationship = null;
        } else if (name.equals(SP_SEX)) {
            this.sex = null;
        } else if (name.equals("born[x]")) {
            this.born = null;
        } else if (name.equals("age[x]")) {
            this.age = null;
        } else if (name.equals("estimatedAge")) {
            this.estimatedAge = null;
        } else if (name.equals("deceased[x]")) {
            this.deceased = null;
        } else if (name.equals("reason")) {
            this.getReason().remove(value);
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("condition")) {
            this.getCondition().remove((FamilyMemberHistoryConditionComponent)((Object)value));
        } else if (name.equals("procedure")) {
            this.getProcedure().remove((FamilyMemberHistoryProcedureComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 8911915: {
                return this.addInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.addInstantiatesUriElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1034315687: {
                return this.getDataAbsentReason();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -261851592: {
                return this.getRelationship();
            }
            case 113766: {
                return this.getSex();
            }
            case 67532951: {
                return this.getBorn();
            }
            case 3029833: {
                return this.getBorn();
            }
            case -1419716831: {
                return this.getAge();
            }
            case 96511: {
                return this.getAge();
            }
            case 2130167587: {
                return this.getEstimatedAgeElement();
            }
            case -1311442804: {
                return this.getDeceased();
            }
            case 561497972: {
                return this.getDeceased();
            }
            case -934964668: {
                return this.addReason();
            }
            case 3387378: {
                return this.addNote();
            }
            case -861311717: {
                return this.addCondition();
            }
            case -1095204141: {
                return this.addProcedure();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 1034315687: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 767422259: {
                return new String[0];
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -261851592: {
                return new String[]{"CodeableConcept"};
            }
            case 113766: {
                return new String[]{"CodeableConcept"};
            }
            case 3029833: {
                return new String[]{"Period", SP_DATE, "string"};
            }
            case 96511: {
                return new String[]{"Age", "Range", "string"};
            }
            case 2130167587: {
                return new String[]{"boolean"};
            }
            case 561497972: {
                return new String[]{"boolean", "Age", "Range", SP_DATE, "string"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -861311717: {
                return new String[0];
            }
            case -1095204141: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.instantiatesUri");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.status");
        }
        if (name.equals("dataAbsentReason")) {
            this.dataAbsentReason = new CodeableConcept();
            return this.dataAbsentReason;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.date");
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.name");
        }
        if (name.equals(SP_RELATIONSHIP)) {
            this.relationship = new CodeableConcept();
            return this.relationship;
        }
        if (name.equals(SP_SEX)) {
            this.sex = new CodeableConcept();
            return this.sex;
        }
        if (name.equals("bornPeriod")) {
            this.born = new Period();
            return this.born;
        }
        if (name.equals("bornDate")) {
            this.born = new DateType();
            return this.born;
        }
        if (name.equals("bornString")) {
            this.born = new StringType();
            return this.born;
        }
        if (name.equals("ageAge")) {
            this.age = new Age();
            return this.age;
        }
        if (name.equals("ageRange")) {
            this.age = new Range();
            return this.age;
        }
        if (name.equals("ageString")) {
            this.age = new StringType();
            return this.age;
        }
        if (name.equals("estimatedAge")) {
            throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.estimatedAge");
        }
        if (name.equals("deceasedBoolean")) {
            this.deceased = new BooleanType();
            return this.deceased;
        }
        if (name.equals("deceasedAge")) {
            this.deceased = new Age();
            return this.deceased;
        }
        if (name.equals("deceasedRange")) {
            this.deceased = new Range();
            return this.deceased;
        }
        if (name.equals("deceasedDate")) {
            this.deceased = new DateType();
            return this.deceased;
        }
        if (name.equals("deceasedString")) {
            this.deceased = new StringType();
            return this.deceased;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("condition")) {
            return this.addCondition();
        }
        if (name.equals("procedure")) {
            return this.addProcedure();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "FamilyMemberHistory";
    }

    @Override
    public FamilyMemberHistory copy() {
        FamilyMemberHistory dst = new FamilyMemberHistory();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(FamilyMemberHistory dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.instantiatesCanonical != null) {
            dst.instantiatesCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiatesCanonical) {
                dst.instantiatesCanonical.add(canonicalType.copy());
            }
        }
        if (this.instantiatesUri != null) {
            dst.instantiatesUri = new ArrayList<UriType>();
            for (UriType uriType : this.instantiatesUri) {
                dst.instantiatesUri.add(uriType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.dataAbsentReason = this.dataAbsentReason == null ? null : this.dataAbsentReason.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<FamilyMemberHistoryParticipantComponent>();
            for (FamilyMemberHistoryParticipantComponent familyMemberHistoryParticipantComponent : this.participant) {
                dst.participant.add(familyMemberHistoryParticipantComponent.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.relationship = this.relationship == null ? null : this.relationship.copy();
        dst.sex = this.sex == null ? null : this.sex.copy();
        dst.born = this.born == null ? null : this.born.copy();
        dst.age = this.age == null ? null : this.age.copy();
        dst.estimatedAge = this.estimatedAge == null ? null : this.estimatedAge.copy();
        DataType dataType = dst.deceased = this.deceased == null ? null : this.deceased.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.condition != null) {
            dst.condition = new ArrayList<FamilyMemberHistoryConditionComponent>();
            for (FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : this.condition) {
                dst.condition.add(familyMemberHistoryConditionComponent.copy());
            }
        }
        if (this.procedure != null) {
            dst.procedure = new ArrayList<FamilyMemberHistoryProcedureComponent>();
            for (FamilyMemberHistoryProcedureComponent familyMemberHistoryProcedureComponent : this.procedure) {
                dst.procedure.add(familyMemberHistoryProcedureComponent.copy());
            }
        }
    }

    protected FamilyMemberHistory typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof FamilyMemberHistory)) {
            return false;
        }
        FamilyMemberHistory o = (FamilyMemberHistory)other_;
        return FamilyMemberHistory.compareDeep(this.identifier, o.identifier, true) && FamilyMemberHistory.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && FamilyMemberHistory.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && FamilyMemberHistory.compareDeep(this.status, o.status, true) && FamilyMemberHistory.compareDeep(this.dataAbsentReason, o.dataAbsentReason, true) && FamilyMemberHistory.compareDeep(this.patient, o.patient, true) && FamilyMemberHistory.compareDeep(this.date, o.date, true) && FamilyMemberHistory.compareDeep(this.participant, o.participant, true) && FamilyMemberHistory.compareDeep(this.name, o.name, true) && FamilyMemberHistory.compareDeep(this.relationship, o.relationship, true) && FamilyMemberHistory.compareDeep(this.sex, o.sex, true) && FamilyMemberHistory.compareDeep(this.born, o.born, true) && FamilyMemberHistory.compareDeep(this.age, o.age, true) && FamilyMemberHistory.compareDeep(this.estimatedAge, o.estimatedAge, true) && FamilyMemberHistory.compareDeep(this.deceased, o.deceased, true) && FamilyMemberHistory.compareDeep(this.reason, o.reason, true) && FamilyMemberHistory.compareDeep(this.note, o.note, true) && FamilyMemberHistory.compareDeep(this.condition, o.condition, true) && FamilyMemberHistory.compareDeep(this.procedure, o.procedure, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof FamilyMemberHistory)) {
            return false;
        }
        FamilyMemberHistory o = (FamilyMemberHistory)other_;
        return FamilyMemberHistory.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && FamilyMemberHistory.compareValues(this.instantiatesUri, o.instantiatesUri, true) && FamilyMemberHistory.compareValues(this.status, o.status, true) && FamilyMemberHistory.compareValues(this.date, o.date, true) && FamilyMemberHistory.compareValues(this.name, o.name, true) && FamilyMemberHistory.compareValues(this.estimatedAge, o.estimatedAge, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.instantiatesCanonical, this.instantiatesUri, this.status, this.dataAbsentReason, this.patient, this.date, this.participant, this.name, this.relationship, this.sex, this.born, this.age, this.estimatedAge, this.deceased, this.reason, this.note, this.condition, this.procedure});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.FamilyMemberHistory;
    }

    @Block
    public static class FamilyMemberHistoryProcedureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Procedures performed on the related person", formalDefinition="The actual procedure specified. Could be a coded procedure or a less specific string depending on how much is known about the procedure and the capabilities of the creating system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
        protected CodeableConcept code;
        @Child(name="outcome", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What happened following the procedure", formalDefinition="Indicates what happened following the procedure. If the procedure resulted in death, deceased date is captured on the relation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
        protected CodeableConcept outcome;
        @Child(name="contributedToDeath", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the procedure contributed to the cause of death", formalDefinition="This procedure contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.")
        protected BooleanType contributedToDeath;
        @Child(name="performed", type={Age.class, Range.class, Period.class, StringType.class, DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the procedure was performed", formalDefinition="Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.")
        protected DataType performed;
        @Child(name="note", type={Annotation.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Extra information about the procedure", formalDefinition="An area where general notes can be placed about this specific procedure.")
        protected List<Annotation> note;
        private static final long serialVersionUID = 281271062L;

        public FamilyMemberHistoryProcedureComponent() {
        }

        public FamilyMemberHistoryProcedureComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryProcedureComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public FamilyMemberHistoryProcedureComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getOutcome() {
            if (this.outcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryProcedureComponent.outcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcome = new CodeableConcept();
                }
            }
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public FamilyMemberHistoryProcedureComponent setOutcome(CodeableConcept value) {
            this.outcome = value;
            return this;
        }

        public BooleanType getContributedToDeathElement() {
            if (this.contributedToDeath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryProcedureComponent.contributedToDeath");
                }
                if (Configuration.doAutoCreate()) {
                    this.contributedToDeath = new BooleanType();
                }
            }
            return this.contributedToDeath;
        }

        public boolean hasContributedToDeathElement() {
            return this.contributedToDeath != null && !this.contributedToDeath.isEmpty();
        }

        public boolean hasContributedToDeath() {
            return this.contributedToDeath != null && !this.contributedToDeath.isEmpty();
        }

        public FamilyMemberHistoryProcedureComponent setContributedToDeathElement(BooleanType value) {
            this.contributedToDeath = value;
            return this;
        }

        public boolean getContributedToDeath() {
            return this.contributedToDeath == null || this.contributedToDeath.isEmpty() ? false : (Boolean)this.contributedToDeath.getValue();
        }

        public FamilyMemberHistoryProcedureComponent setContributedToDeath(boolean value) {
            if (this.contributedToDeath == null) {
                this.contributedToDeath = new BooleanType();
            }
            this.contributedToDeath.setValue((Object)value);
            return this;
        }

        public DataType getPerformed() {
            return this.performed;
        }

        public Age getPerformedAge() throws FHIRException {
            if (this.performed == null) {
                this.performed = new Age();
            }
            if (!(this.performed instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.performed.getClass().getName() + " was encountered");
            }
            return (Age)this.performed;
        }

        public boolean hasPerformedAge() {
            return this != null && this.performed instanceof Age;
        }

        public Range getPerformedRange() throws FHIRException {
            if (this.performed == null) {
                this.performed = new Range();
            }
            if (!(this.performed instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.performed.getClass().getName() + " was encountered");
            }
            return (Range)this.performed;
        }

        public boolean hasPerformedRange() {
            return this != null && this.performed instanceof Range;
        }

        public Period getPerformedPeriod() throws FHIRException {
            if (this.performed == null) {
                this.performed = new Period();
            }
            if (!(this.performed instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.performed.getClass().getName() + " was encountered");
            }
            return (Period)this.performed;
        }

        public boolean hasPerformedPeriod() {
            return this != null && this.performed instanceof Period;
        }

        public StringType getPerformedStringType() throws FHIRException {
            if (this.performed == null) {
                this.performed = new StringType();
            }
            if (!(this.performed instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.performed.getClass().getName() + " was encountered");
            }
            return (StringType)this.performed;
        }

        public boolean hasPerformedStringType() {
            return this != null && this.performed instanceof StringType;
        }

        public DateTimeType getPerformedDateTimeType() throws FHIRException {
            if (this.performed == null) {
                this.performed = new DateTimeType();
            }
            if (!(this.performed instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.performed.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.performed;
        }

        public boolean hasPerformedDateTimeType() {
            return this != null && this.performed instanceof DateTimeType;
        }

        public boolean hasPerformed() {
            return this.performed != null && !this.performed.isEmpty();
        }

        public FamilyMemberHistoryProcedureComponent setPerformed(DataType value) {
            if (!(value == null || value instanceof Age || value instanceof Range || value instanceof Period || value instanceof StringType || value instanceof DateTimeType)) {
                throw new FHIRException("Not the right type for FamilyMemberHistory.procedure.performed[x]: " + value.fhirType());
            }
            this.performed = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public FamilyMemberHistoryProcedureComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public FamilyMemberHistoryProcedureComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(FamilyMemberHistory.SP_CODE, "CodeableConcept", "The actual procedure specified. Could be a coded procedure or a less specific string depending on how much is known about the procedure and the capabilities of the creating system.", 0, 1, this.code));
            children.add(new Property("outcome", "CodeableConcept", "Indicates what happened following the procedure. If the procedure resulted in death, deceased date is captured on the relation.", 0, 1, this.outcome));
            children.add(new Property("contributedToDeath", "boolean", "This procedure contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.", 0, 1, this.contributedToDeath));
            children.add(new Property("performed[x]", "Age|Range|Period|string|dateTime", "Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed));
            children.add(new Property("note", "Annotation", "An area where general notes can be placed about this specific procedure.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(FamilyMemberHistory.SP_CODE, "CodeableConcept", "The actual procedure specified. Could be a coded procedure or a less specific string depending on how much is known about the procedure and the capabilities of the creating system.", 0, 1, this.code);
                }
                case -1106507950: {
                    return new Property("outcome", "CodeableConcept", "Indicates what happened following the procedure. If the procedure resulted in death, deceased date is captured on the relation.", 0, 1, this.outcome);
                }
                case -363644638: {
                    return new Property("contributedToDeath", "boolean", "This procedure contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.", 0, 1, this.contributedToDeath);
                }
                case 1355984064: {
                    return new Property("performed[x]", "Age|Range|Period|string|dateTime", "Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
                }
                case 481140672: {
                    return new Property("performed[x]", "Age|Range|Period|string|dateTime", "Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
                }
                case 1355958559: {
                    return new Property("performed[x]", "Age", "Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
                }
                case 1716617565: {
                    return new Property("performed[x]", "Range", "Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
                }
                case 1622094241: {
                    return new Property("performed[x]", "Period", "Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
                }
                case 1721834481: {
                    return new Property("performed[x]", "string", "Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
                }
                case 1118270331: {
                    return new Property("performed[x]", "dateTime", "Estimated or actual date, date-time, period, or age when the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.", 0, 1, this.performed);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "An area where general notes can be placed about this specific procedure.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1106507950: {
                    Base[] baseArray;
                    if (this.outcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.outcome;
                    }
                    return baseArray;
                }
                case -363644638: {
                    Base[] baseArray;
                    if (this.contributedToDeath == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.contributedToDeath;
                    }
                    return baseArray;
                }
                case 481140672: {
                    Base[] baseArray;
                    if (this.performed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.performed;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1106507950: {
                    this.outcome = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -363644638: {
                    this.contributedToDeath = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 481140672: {
                    this.performed = TypeConvertor.castToType(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("outcome")) {
                this.outcome = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("contributedToDeath")) {
                this.contributedToDeath = TypeConvertor.castToBoolean(value);
            } else if (name.equals("performed[x]")) {
                this.performed = TypeConvertor.castToType(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = null;
            } else if (name.equals("outcome")) {
                this.outcome = null;
            } else if (name.equals("contributedToDeath")) {
                this.contributedToDeath = null;
            } else if (name.equals("performed[x]")) {
                this.performed = null;
            } else if (name.equals("note")) {
                this.getNote().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1106507950: {
                    return this.getOutcome();
                }
                case -363644638: {
                    return this.getContributedToDeathElement();
                }
                case 1355984064: {
                    return this.getPerformed();
                }
                case 481140672: {
                    return this.getPerformed();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1106507950: {
                    return new String[]{"CodeableConcept"};
                }
                case -363644638: {
                    return new String[]{"boolean"};
                }
                case 481140672: {
                    return new String[]{"Age", "Range", "Period", "string", "dateTime"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("outcome")) {
                this.outcome = new CodeableConcept();
                return this.outcome;
            }
            if (name.equals("contributedToDeath")) {
                throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.procedure.contributedToDeath");
            }
            if (name.equals("performedAge")) {
                this.performed = new Age();
                return this.performed;
            }
            if (name.equals("performedRange")) {
                this.performed = new Range();
                return this.performed;
            }
            if (name.equals("performedPeriod")) {
                this.performed = new Period();
                return this.performed;
            }
            if (name.equals("performedString")) {
                this.performed = new StringType();
                return this.performed;
            }
            if (name.equals("performedDateTime")) {
                this.performed = new DateTimeType();
                return this.performed;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public FamilyMemberHistoryProcedureComponent copy() {
            FamilyMemberHistoryProcedureComponent dst = new FamilyMemberHistoryProcedureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(FamilyMemberHistoryProcedureComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
            dst.contributedToDeath = this.contributedToDeath == null ? null : this.contributedToDeath.copy();
            DataType dataType = dst.performed = this.performed == null ? null : this.performed.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof FamilyMemberHistoryProcedureComponent)) {
                return false;
            }
            FamilyMemberHistoryProcedureComponent o = (FamilyMemberHistoryProcedureComponent)other_;
            return FamilyMemberHistoryProcedureComponent.compareDeep(this.code, o.code, true) && FamilyMemberHistoryProcedureComponent.compareDeep(this.outcome, o.outcome, true) && FamilyMemberHistoryProcedureComponent.compareDeep(this.contributedToDeath, o.contributedToDeath, true) && FamilyMemberHistoryProcedureComponent.compareDeep(this.performed, o.performed, true) && FamilyMemberHistoryProcedureComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof FamilyMemberHistoryProcedureComponent)) {
                return false;
            }
            FamilyMemberHistoryProcedureComponent o = (FamilyMemberHistoryProcedureComponent)other_;
            return FamilyMemberHistoryProcedureComponent.compareValues(this.contributedToDeath, o.contributedToDeath, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.outcome, this.contributedToDeath, this.performed, this.note});
        }

        @Override
        public String fhirType() {
            return "FamilyMemberHistory.procedure";
        }
    }

    @Block
    public static class FamilyMemberHistoryConditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Condition suffered by relation", formalDefinition="The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected CodeableConcept code;
        @Child(name="outcome", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="deceased | permanent disability | etc", formalDefinition="Indicates what happened following the condition.  If the condition resulted in death, deceased date is captured on the relation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-outcome")
        protected CodeableConcept outcome;
        @Child(name="contributedToDeath", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the condition contributed to the cause of death", formalDefinition="This condition contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.")
        protected BooleanType contributedToDeath;
        @Child(name="onset", type={Age.class, Range.class, Period.class, StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When condition first manifested", formalDefinition="Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.")
        protected DataType onset;
        @Child(name="note", type={Annotation.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Extra information about condition", formalDefinition="An area where general notes can be placed about this specific condition.")
        protected List<Annotation> note;
        private static final long serialVersionUID = -91335661L;

        public FamilyMemberHistoryConditionComponent() {
        }

        public FamilyMemberHistoryConditionComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getOutcome() {
            if (this.outcome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.outcome");
                }
                if (Configuration.doAutoCreate()) {
                    this.outcome = new CodeableConcept();
                }
            }
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setOutcome(CodeableConcept value) {
            this.outcome = value;
            return this;
        }

        public BooleanType getContributedToDeathElement() {
            if (this.contributedToDeath == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryConditionComponent.contributedToDeath");
                }
                if (Configuration.doAutoCreate()) {
                    this.contributedToDeath = new BooleanType();
                }
            }
            return this.contributedToDeath;
        }

        public boolean hasContributedToDeathElement() {
            return this.contributedToDeath != null && !this.contributedToDeath.isEmpty();
        }

        public boolean hasContributedToDeath() {
            return this.contributedToDeath != null && !this.contributedToDeath.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setContributedToDeathElement(BooleanType value) {
            this.contributedToDeath = value;
            return this;
        }

        public boolean getContributedToDeath() {
            return this.contributedToDeath == null || this.contributedToDeath.isEmpty() ? false : (Boolean)this.contributedToDeath.getValue();
        }

        public FamilyMemberHistoryConditionComponent setContributedToDeath(boolean value) {
            if (this.contributedToDeath == null) {
                this.contributedToDeath = new BooleanType();
            }
            this.contributedToDeath.setValue((Object)value);
            return this;
        }

        public DataType getOnset() {
            return this.onset;
        }

        public Age getOnsetAge() throws FHIRException {
            if (this.onset == null) {
                this.onset = new Age();
            }
            if (!(this.onset instanceof Age)) {
                throw new FHIRException("Type mismatch: the type Age was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Age)this.onset;
        }

        public boolean hasOnsetAge() {
            return this != null && this.onset instanceof Age;
        }

        public Range getOnsetRange() throws FHIRException {
            if (this.onset == null) {
                this.onset = new Range();
            }
            if (!(this.onset instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Range)this.onset;
        }

        public boolean hasOnsetRange() {
            return this != null && this.onset instanceof Range;
        }

        public Period getOnsetPeriod() throws FHIRException {
            if (this.onset == null) {
                this.onset = new Period();
            }
            if (!(this.onset instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (Period)this.onset;
        }

        public boolean hasOnsetPeriod() {
            return this != null && this.onset instanceof Period;
        }

        public StringType getOnsetStringType() throws FHIRException {
            if (this.onset == null) {
                this.onset = new StringType();
            }
            if (!(this.onset instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.onset.getClass().getName() + " was encountered");
            }
            return (StringType)this.onset;
        }

        public boolean hasOnsetStringType() {
            return this != null && this.onset instanceof StringType;
        }

        public boolean hasOnset() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public FamilyMemberHistoryConditionComponent setOnset(DataType value) {
            if (!(value == null || value instanceof Age || value instanceof Range || value instanceof Period || value instanceof StringType)) {
                throw new FHIRException("Not the right type for FamilyMemberHistory.condition.onset[x]: " + value.fhirType());
            }
            this.onset = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public FamilyMemberHistoryConditionComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public FamilyMemberHistoryConditionComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(FamilyMemberHistory.SP_CODE, "CodeableConcept", "The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.", 0, 1, this.code));
            children.add(new Property("outcome", "CodeableConcept", "Indicates what happened following the condition.  If the condition resulted in death, deceased date is captured on the relation.", 0, 1, this.outcome));
            children.add(new Property("contributedToDeath", "boolean", "This condition contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.", 0, 1, this.contributedToDeath));
            children.add(new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset));
            children.add(new Property("note", "Annotation", "An area where general notes can be placed about this specific condition.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(FamilyMemberHistory.SP_CODE, "CodeableConcept", "The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system.", 0, 1, this.code);
                }
                case -1106507950: {
                    return new Property("outcome", "CodeableConcept", "Indicates what happened following the condition.  If the condition resulted in death, deceased date is captured on the relation.", 0, 1, this.outcome);
                }
                case -363644638: {
                    return new Property("contributedToDeath", "boolean", "This condition contributed to the cause of death of the related person. If contributedToDeath is not populated, then it is unknown.", 0, 1, this.contributedToDeath);
                }
                case -1886216323: {
                    return new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case 105901603: {
                    return new Property("onset[x]", "Age|Range|Period|string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case -1886241828: {
                    return new Property("onset[x]", "Age", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case -186664742: {
                    return new Property("onset[x]", "Range", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case -1545082428: {
                    return new Property("onset[x]", "Period", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case -1445342188: {
                    return new Property("onset[x]", "string", "Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.", 0, 1, this.onset);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "An area where general notes can be placed about this specific condition.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1106507950: {
                    Base[] baseArray;
                    if (this.outcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.outcome;
                    }
                    return baseArray;
                }
                case -363644638: {
                    Base[] baseArray;
                    if (this.contributedToDeath == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.contributedToDeath;
                    }
                    return baseArray;
                }
                case 105901603: {
                    Base[] baseArray;
                    if (this.onset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.onset;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1106507950: {
                    this.outcome = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -363644638: {
                    this.contributedToDeath = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 105901603: {
                    this.onset = TypeConvertor.castToType(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("outcome")) {
                this.outcome = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("contributedToDeath")) {
                this.contributedToDeath = TypeConvertor.castToBoolean(value);
            } else if (name.equals("onset[x]")) {
                this.onset = TypeConvertor.castToType(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = null;
            } else if (name.equals("outcome")) {
                this.outcome = null;
            } else if (name.equals("contributedToDeath")) {
                this.contributedToDeath = null;
            } else if (name.equals("onset[x]")) {
                this.onset = null;
            } else if (name.equals("note")) {
                this.getNote().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1106507950: {
                    return this.getOutcome();
                }
                case -363644638: {
                    return this.getContributedToDeathElement();
                }
                case -1886216323: {
                    return this.getOnset();
                }
                case 105901603: {
                    return this.getOnset();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1106507950: {
                    return new String[]{"CodeableConcept"};
                }
                case -363644638: {
                    return new String[]{"boolean"};
                }
                case 105901603: {
                    return new String[]{"Age", "Range", "Period", "string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(FamilyMemberHistory.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("outcome")) {
                this.outcome = new CodeableConcept();
                return this.outcome;
            }
            if (name.equals("contributedToDeath")) {
                throw new FHIRException("Cannot call addChild on a singleton property FamilyMemberHistory.condition.contributedToDeath");
            }
            if (name.equals("onsetAge")) {
                this.onset = new Age();
                return this.onset;
            }
            if (name.equals("onsetRange")) {
                this.onset = new Range();
                return this.onset;
            }
            if (name.equals("onsetPeriod")) {
                this.onset = new Period();
                return this.onset;
            }
            if (name.equals("onsetString")) {
                this.onset = new StringType();
                return this.onset;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public FamilyMemberHistoryConditionComponent copy() {
            FamilyMemberHistoryConditionComponent dst = new FamilyMemberHistoryConditionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(FamilyMemberHistoryConditionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
            dst.contributedToDeath = this.contributedToDeath == null ? null : this.contributedToDeath.copy();
            DataType dataType = dst.onset = this.onset == null ? null : this.onset.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof FamilyMemberHistoryConditionComponent)) {
                return false;
            }
            FamilyMemberHistoryConditionComponent o = (FamilyMemberHistoryConditionComponent)other_;
            return FamilyMemberHistoryConditionComponent.compareDeep(this.code, o.code, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.outcome, o.outcome, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.contributedToDeath, o.contributedToDeath, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.onset, o.onset, true) && FamilyMemberHistoryConditionComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof FamilyMemberHistoryConditionComponent)) {
                return false;
            }
            FamilyMemberHistoryConditionComponent o = (FamilyMemberHistoryConditionComponent)other_;
            return FamilyMemberHistoryConditionComponent.compareValues(this.contributedToDeath, o.contributedToDeath, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.outcome, this.contributedToDeath, this.onset, this.note});
        }

        @Override
        public String fhirType() {
            return "FamilyMemberHistory.condition";
        }
    }

    @Block
    public static class FamilyMemberHistoryParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of involvement", formalDefinition="Distinguishes the type of involvement of the actor in the activities related to the family member history.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class, Device.class, Organization.class, CareTeam.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who or what participated in the activities related to the family member history", formalDefinition="Indicates who or what participated in the activities related to the family member history.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public FamilyMemberHistoryParticipantComponent() {
        }

        public FamilyMemberHistoryParticipantComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryParticipantComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public FamilyMemberHistoryParticipantComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FamilyMemberHistoryParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public FamilyMemberHistoryParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the actor in the activities related to the family member history.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device|Organization|CareTeam)", "Indicates who or what participated in the activities related to the family member history.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the actor in the activities related to the family member history.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device|Organization|CareTeam)", "Indicates who or what participated in the activities related to the family member history.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = null;
            } else if (name.equals("actor")) {
                this.actor = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public FamilyMemberHistoryParticipantComponent copy() {
            FamilyMemberHistoryParticipantComponent dst = new FamilyMemberHistoryParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(FamilyMemberHistoryParticipantComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof FamilyMemberHistoryParticipantComponent)) {
                return false;
            }
            FamilyMemberHistoryParticipantComponent o = (FamilyMemberHistoryParticipantComponent)other_;
            return FamilyMemberHistoryParticipantComponent.compareDeep(this.function, o.function, true) && FamilyMemberHistoryParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof FamilyMemberHistoryParticipantComponent)) {
                return false;
            }
            FamilyMemberHistoryParticipantComponent o = (FamilyMemberHistoryParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "FamilyMemberHistory.participant";
        }
    }

    public static class FamilyHistoryStatusEnumFactory
    implements EnumFactory<FamilyHistoryStatus> {
        @Override
        public FamilyHistoryStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("partial".equals(codeString)) {
                return FamilyHistoryStatus.PARTIAL;
            }
            if ("completed".equals(codeString)) {
                return FamilyHistoryStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return FamilyHistoryStatus.ENTEREDINERROR;
            }
            if ("health-unknown".equals(codeString)) {
                return FamilyHistoryStatus.HEALTHUNKNOWN;
            }
            throw new IllegalArgumentException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        public Enumeration<FamilyHistoryStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.NULL, code);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.PARTIAL, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.ENTEREDINERROR, code);
            }
            if ("health-unknown".equals(codeString)) {
                return new Enumeration<FamilyHistoryStatus>(this, FamilyHistoryStatus.HEALTHUNKNOWN, code);
            }
            throw new FHIRException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FamilyHistoryStatus code) {
            if (code == FamilyHistoryStatus.NULL) {
                return null;
            }
            if (code == FamilyHistoryStatus.PARTIAL) {
                return "partial";
            }
            if (code == FamilyHistoryStatus.COMPLETED) {
                return "completed";
            }
            if (code == FamilyHistoryStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == FamilyHistoryStatus.HEALTHUNKNOWN) {
                return "health-unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(FamilyHistoryStatus code) {
            return code.getSystem();
        }
    }

    public static enum FamilyHistoryStatus {
        PARTIAL,
        COMPLETED,
        ENTEREDINERROR,
        HEALTHUNKNOWN,
        NULL;


        public static FamilyHistoryStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("health-unknown".equals(codeString)) {
                return HEALTHUNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FamilyHistoryStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PARTIAL: {
                    return "partial";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case HEALTHUNKNOWN: {
                    return "health-unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PARTIAL: {
                    return "http://hl7.org/fhir/history-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/history-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/history-status";
                }
                case HEALTHUNKNOWN: {
                    return "http://hl7.org/fhir/history-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PARTIAL: {
                    return "Some health information is known and captured, but not complete - see notes for details.";
                }
                case COMPLETED: {
                    return "All available related health information is captured as of the date (and possibly time) when the family member history was taken.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case HEALTHUNKNOWN: {
                    return "Health information for this family member is unavailable/unknown.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PARTIAL: {
                    return "Partial";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case HEALTHUNKNOWN: {
                    return "Health Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

