/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.instance.model.api.IBaseIntegerDatatype;
import org.hl7.fhir.r5.model.PrimitiveType;

@DatatypeDef(name="integer")
public class IntegerType
extends PrimitiveType<Integer>
implements IBaseIntegerDatatype {
    private static final long serialVersionUID = 3L;

    public IntegerType() {
    }

    public IntegerType(int theInteger) {
        this.setValue((Object)theInteger);
    }

    public IntegerType(Integer theInteger) {
        this.setValue(theInteger);
    }

    public IntegerType(String theIntegerAsString) {
        this.setValueAsString(theIntegerAsString);
    }

    public IntegerType(Long theValue) {
        if (theValue < Integer.MIN_VALUE || theValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(theValue + " cannot be cast to int without changing its value.");
        }
        if (theValue != null) {
            this.setValue((Object)((int)theValue.longValue()));
        }
    }

    @Override
    protected Integer parse(String theValue) {
        try {
            return Integer.parseInt(theValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected String encode(Integer theValue) {
        return Integer.toString(theValue);
    }

    @Override
    public IntegerType copy() {
        Integer value = (Integer)this.getValue();
        IntegerType ret = value == null ? new IntegerType() : new IntegerType((int)value);
        this.copyValues(ret);
        return ret;
    }

    @Override
    public String fhirType() {
        return "integer";
    }
}

